/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.translator.global;

import com.goide.dfa.GoDfaConfig;
import com.goide.dfa.GoDfaMode;
import com.goide.dfa.translator.GoDereferenceKind;
import com.goide.dfa.translator.GoDfaUtilsKt;
import com.goide.dfa.translator.GoExpressionTranslatorKt;
import com.goide.dfa.translator.GoFunctionContract;
import com.goide.dfa.translator.GoFunctionContractsService;
import com.goide.dfa.translator.GoFunctionPsiToIrTranslator;
import com.goide.dfa.translator.GoFunctionTerminationType;
import com.goide.dfa.translator.GoPsiMapper;
import com.goide.dfa.translator.GoValueContract;
import com.goide.dfa.translator.IrNilnessConstant;
import com.goide.dfa.translator.global.GoIrCallExpr;
import com.goide.dfa.translator.global.GoIrStopExecutionStmt;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.GoNilnessInspection;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrComparisonCondition;
import com.intellij.rml.dfa.ir.ast.IrCondition;
import com.intellij.rml.dfa.ir.ast.IrConstant;
import com.intellij.rml.dfa.ir.ast.IrConstantExpr;
import com.intellij.rml.dfa.ir.ast.IrEqualityKind;
import com.intellij.rml.dfa.ir.ast.IrExpr;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.ast.IrVarRefExpr;
import com.intellij.rml.dfa.ir.cfg.IrCfgRegionBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a(\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012\u001a(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0019H\u0002\u00a8\u0006\u001f"}, d2={"getQualifierExpression", "Lcom/goide/psi/GoExpression;", "call", "Lcom/goide/psi/GoCallExpr;", "translateCall", "Lcom/goide/dfa/translator/global/GoIrCallExpr;", "mapper", "Lcom/goide/dfa/translator/GoPsiMapper;", "builder", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgRegionBuilder;", "isImplicitAddressOfOperation", "", "callQualifier", "methodDecl", "Lcom/goide/psi/GoMethodDeclaration;", "translateCallExpr", "Lcom/intellij/rml/dfa/ir/ast/IrVarRefExpr;", "config", "Lcom/goide/dfa/GoDfaConfig;", "addArgumentsRequirementStmts", "", "callExpr", "contract", "Lcom/goide/dfa/translator/GoFunctionContract;", "callLocation", "Lcom/intellij/rml/dfa/ir/IrLocation;", "toIrCondition", "Lcom/intellij/rml/dfa/ir/ast/IrCondition;", "Lcom/goide/dfa/translator/GoValueContract;", "value", "location", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nGoDfaGlobalTranslatorExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDfaGlobalTranslatorExtension.kt\ncom/goide/dfa/translator/global/GoDfaGlobalTranslatorExtensionKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n40#2,3:141\n1#3:144\n*S KotlinDebug\n*F\n+ 1 GoDfaGlobalTranslatorExtension.kt\ncom/goide/dfa/translator/global/GoDfaGlobalTranslatorExtensionKt\n*L\n100#1:141,3\n*E\n"})
public final class GoDfaGlobalTranslatorExtensionKt {
    @Nullable
    public static final GoExpression getQualifierExpression(@NotNull GoCallExpr call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        GoReferenceExpression goReferenceExpression = GoPsiUtil.getCallReference(call);
        if (goReferenceExpression == null) {
            return null;
        }
        GoReferenceExpression ref = goReferenceExpression;
        GoQualifier goQualifier = ref.getQualifier();
        GoExpression goExpression = goQualifier instanceof GoExpression ? (GoExpression)goQualifier : null;
        if (goExpression == null) {
            return null;
        }
        GoExpression receiverExpr = goExpression;
        return receiverExpr;
    }

    @Nullable
    public static final GoIrCallExpr translateCall(@NotNull GoCallExpr call, @NotNull GoPsiMapper mapper, @NotNull IrCfgRegionBuilder builder) {
        List list;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        GoNamedSignatureOwner decl = GoInspectionUtil.resolveCall(call);
        if (decl == null) {
            GoExpression goExpression = call.getExpression();
            Intrinsics.checkNotNullExpressionValue((Object)goExpression, (String)"getExpression(...)");
            GoExpressionTranslatorKt.processElement(builder, goExpression, mapper, true, GoDfaConfig.Companion.getGlobal());
            return null;
        }
        List $this$translateCall_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (decl instanceof GoMethodDeclaration || decl instanceof GoMethodSpec) {
            GoExpression qualifierExpr = GoDfaGlobalTranslatorExtensionKt.getQualifierExpression(call);
            if (qualifierExpr == null) {
                GoFunctionPsiToIrTranslator.Companion.getLOG().warn("Receiver expression is null for method call: " + call.getText());
            }
            if (qualifierExpr != null) {
                IrExpr irExpr;
                if (decl instanceof GoMethodDeclaration && GoDfaGlobalTranslatorExtensionKt.isImplicitAddressOfOperation(qualifierExpr, (GoMethodDeclaration)decl)) {
                    GoExpressionTranslatorKt.processElement(builder, qualifierExpr, mapper, true, GoDfaConfig.Companion.getGlobal());
                    irExpr = (IrExpr)IrNilnessConstant.NotNil.INSTANCE;
                } else {
                    irExpr = GoExpressionTranslatorKt.translateCoreExpr(qualifierExpr, mapper, builder, GoDfaConfig.Companion.getGlobal());
                }
                IrExpr receiverIrExpr = irExpr;
                $this$translateCall_u24lambda_u240.add(receiverIrExpr);
                boolean allowedNilReceiver = GoNilnessInspection.allowsNilReceiver(decl instanceof GoMethodDeclaration ? (GoMethodDeclaration)decl : null);
                if (!allowedNilReceiver && receiverIrExpr instanceof IrVarRefExpr) {
                    TextRange textRange = qualifierExpr.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    GoDereferenceKind.MethodCallNotNilReceiver kind = new GoDereferenceKind.MethodCallNotNilReceiver(textRange);
                    GoExpressionTranslatorKt.addDereference(builder, ((IrVarRefExpr)receiverIrExpr).getVariable(), (PsiElement)call, true, (GoDereferenceKind)kind, mapper);
                }
            }
        }
        for (GoExpression argExpr : call.getArgumentList().getExpressionList()) {
            Intrinsics.checkNotNull((Object)argExpr);
            $this$translateCall_u24lambda_u240.add(GoExpressionTranslatorKt.translateCoreExpr(argExpr, mapper, builder, GoDfaConfig.Companion.getGlobal()));
        }
        List args = CollectionsKt.build((List)list);
        IrFunctionID irFunctionID = mapper.getFunctionId(decl);
        if (irFunctionID == null) {
            return null;
        }
        IrFunctionID functionId = irFunctionID;
        return new GoIrCallExpr(functionId, args);
    }

    private static final boolean isImplicitAddressOfOperation(GoExpression callQualifier, GoMethodDeclaration methodDecl) {
        GoType goType = methodDecl.getReceiverType();
        if (goType == null) {
            return false;
        }
        GoType receiverType = goType;
        GoType goType2 = callQualifier.getGoType(GoPsiImplUtil.createContextOnElement(callQualifier));
        if (goType2 == null) {
            return false;
        }
        GoType qualifierType = goType2;
        return !GoTypeUtil.isPointer(qualifierType, callQualifier) && GoTypeUtil.isPointer(receiverType, callQualifier);
    }

    @Nullable
    public static final IrVarRefExpr translateCallExpr(@NotNull GoCallExpr call, @NotNull GoPsiMapper mapper, @NotNull IrCfgRegionBuilder builder, @NotNull GoDfaConfig config) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.getMode() == GoDfaMode.Local) {
            throw new DfaInternalException("Local DFA mode should not process static calls");
        }
        GoIrCallExpr goIrCallExpr = GoDfaGlobalTranslatorExtensionKt.translateCall(call, mapper, builder);
        if (goIrCallExpr == null) {
            return null;
        }
        GoIrCallExpr callExpr = goIrCallExpr;
        IrVarID tmpVar = mapper.makeTmpVar(call);
        IrLocation callLocation = GoDfaUtilsKt.getLocation(call, config);
        boolean $i$f$service = false;
        Class<GoFunctionContractsService> serviceClass$iv = GoFunctionContractsService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        GoFunctionContract goFunctionContract = ((GoFunctionContractsService)object).lookup(call);
        if (goFunctionContract == null) {
            goFunctionContract = GoFunctionContract.Companion.getDefault();
        }
        GoFunctionContract contract = goFunctionContract;
        GoDfaGlobalTranslatorExtensionKt.addArgumentsRequirementStmts(callExpr, contract, builder, callLocation);
        switch (WhenMappings.$EnumSwitchMapping$0[contract.getTerminationType().ordinal()]) {
            case 1: {
                builder.addStaticCallStmt(tmpVar, callExpr.getCallee(), callExpr.getArguments(), null, callLocation);
                break;
            }
            case 2: {
                builder.addStatement((IrStatement)new GoIrStopExecutionStmt(callExpr.getCallee(), contract.getTerminationType(), callLocation));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return new IrVarRefExpr(tmpVar, callLocation);
    }

    private static final void addArgumentsRequirementStmts(GoIrCallExpr callExpr, GoFunctionContract contract, IrCfgRegionBuilder builder, IrLocation callLocation) {
        for (Pair pair : CollectionsKt.zip((Iterable)callExpr.getArguments(), (Iterable)contract.getAccepts())) {
            IrCondition condition;
            IrExpr value2 = (IrExpr)pair.component1();
            GoValueContract valueContract = (GoValueContract)((Object)pair.component2());
            if (!(value2 instanceof IrVarRefExpr) || GoDfaGlobalTranslatorExtensionKt.toIrCondition(valueContract, (IrVarRefExpr)value2, callLocation) == null) continue;
            builder.addRequirementStmt(condition, callLocation);
        }
    }

    private static final IrCondition toIrCondition(GoValueContract $this$toIrCondition, IrVarRefExpr value2, IrLocation location) {
        IrComparisonCondition irComparisonCondition;
        IrConstantExpr irConstantExpr;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toIrCondition.ordinal()]) {
            case 1: {
                IrConstantExpr irConstantExpr2 = IrConstant.Companion.makeBoolConst$default((IrConstant.Companion)IrConstant.Companion, (boolean)true, null, (int)2, null);
                break;
            }
            case 2: {
                IrConstantExpr irConstantExpr2 = IrConstant.Companion.makeBoolConst$default((IrConstant.Companion)IrConstant.Companion, (boolean)false, null, (int)2, null);
                break;
            }
            case 3: {
                IrConstantExpr irConstantExpr2 = IrNilnessConstant.Nil.INSTANCE;
                break;
            }
            case 4: {
                IrConstantExpr irConstantExpr2 = IrNilnessConstant.NotNil.INSTANCE;
                break;
            }
            default: {
                IrConstantExpr irConstantExpr2 = irConstantExpr = null;
            }
        }
        if (irConstantExpr != null) {
            IrConstantExpr it = irConstantExpr;
            boolean bl = false;
            irComparisonCondition = new IrComparisonCondition((IrExpr)value2, (IrExpr)it, IrEqualityKind.EQ, location);
        } else {
            irComparisonCondition = null;
        }
        return (IrCondition)irComparisonCondition;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GoFunctionTerminationType.values().length];
            try {
                nArray[GoFunctionTerminationType.TERMINATES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoFunctionTerminationType.NOT_TERMINATES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GoValueContract.values().length];
            try {
                nArray[GoValueContract.True.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoValueContract.False.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoValueContract.Nil.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoValueContract.NotNil.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

