/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.translator;

import com.goide.dataflow.GoDataFlowUtil;
import com.goide.dfa.GoDfaConfig;
import com.goide.dfa.GoDfaMode;
import com.goide.dfa.translator.GoDereferenceKind;
import com.goide.dfa.translator.GoDfaUtilsKt;
import com.goide.dfa.translator.GoExpressionTranslatorKt;
import com.goide.dfa.translator.GoPsiMapper;
import com.goide.dfa.translator.global.GoDfaGlobalTranslatorExtensionKt;
import com.goide.inspections.GoNilnessInspection;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.util.GoStdlibUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.rml.dfa.ir.cfg.IrCfgRegionBuilder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/goide/dfa/translator/GoExpressionVisitor;", "Lcom/goide/psi/GoVisitor;", "Lcom/intellij/psi/PsiRecursiveVisitor;", "cfgBuilder", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgRegionBuilder;", "mapper", "Lcom/goide/dfa/translator/GoPsiMapper;", "recursive", "", "config", "Lcom/goide/dfa/GoDfaConfig;", "<init>", "(Lcom/intellij/rml/dfa/ir/cfg/IrCfgRegionBuilder;Lcom/goide/dfa/translator/GoPsiMapper;ZLcom/goide/dfa/GoDfaConfig;)V", "visitElement", "", "o", "Lcom/intellij/psi/PsiElement;", "visitUnaryExpr", "expr", "Lcom/goide/psi/GoUnaryExpr;", "visitReferenceExpression", "ref", "Lcom/goide/psi/GoReferenceExpression;", "visitCallExpr", "callExpr", "Lcom/goide/psi/GoCallExpr;", "visitFunctionLit", "function", "Lcom/goide/psi/GoFunctionLit;", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nGoExpressionTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoExpressionTranslator.kt\ncom/goide/dfa/translator/GoExpressionVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,435:1\n1#2:436\n*E\n"})
final class GoExpressionVisitor
extends GoVisitor
implements PsiRecursiveVisitor {
    @NotNull
    private final IrCfgRegionBuilder cfgBuilder;
    @NotNull
    private final GoPsiMapper mapper;
    private final boolean recursive;
    @NotNull
    private final GoDfaConfig config;

    public GoExpressionVisitor(@NotNull IrCfgRegionBuilder cfgBuilder, @NotNull GoPsiMapper mapper, boolean recursive, @NotNull GoDfaConfig config) {
        Intrinsics.checkNotNullParameter((Object)cfgBuilder, (String)"cfgBuilder");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.cfgBuilder = cfgBuilder;
        this.mapper = mapper;
        this.recursive = recursive;
        this.config = config;
    }

    public void visitElement(@NotNull PsiElement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (this.recursive) {
            o.acceptChildren((PsiElementVisitor)this);
        }
    }

    @Override
    public void visitUnaryExpr(@NotNull GoUnaryExpr expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this.visitElement(expr);
        GoExpression operand = expr.getExpression();
        if (operand != null) {
            if (expr.getArrow() != null || expr.getMul() != null) {
                GoNamedElement variable = GoDfaUtilsKt.getVariableOrParameterOrReceiverDefinition(operand);
                if (variable != null) {
                    GoExpression goExpression = operand.unwrapParentheses();
                    if (goExpression == null) {
                        goExpression = operand;
                    }
                    GoExpression unwrappedOperand = goExpression;
                    TextRange textRange = expr.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                    TextRange textRange2 = unwrappedOperand.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
                    GoDereferenceKind.PointerDereference kind = new GoDereferenceKind.PointerDereference(textRange, textRange2);
                    GoExpressionTranslatorKt.addDereference(this.cfgBuilder, variable, (PsiElement)expr, true, (GoDereferenceKind)kind, this.mapper);
                }
            } else if (expr.getBitAnd() != null) {
                GoNamedElement varOrParam;
                GoExpression goExpression = expr.getExpression();
                if (goExpression != null) {
                    GoExpression it = goExpression;
                    boolean bl = false;
                    v4 = GoDfaUtilsKt.getVariableOrParameterOrReceiverDefinition(it);
                } else {
                    v4 = varOrParam = null;
                }
                if (varOrParam != null) {
                    this.cfgBuilder.addUncontrolledVarStmt(this.mapper.getVarID(varOrParam), this.mapper.getLocation(expr));
                }
            }
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull GoReferenceExpression ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.visitElement(ref);
        PsiElement resolve = ref.resolve();
        if (!(resolve instanceof GoFieldDefinition) && !(resolve instanceof GoAnonymousFieldDefinition)) {
            return;
        }
        GoResolvable goResolvable = ref.getResolvableQualifier();
        if (goResolvable == null) {
            return;
        }
        GoResolvable qualifier = goResolvable;
        GoExpressionTranslatorKt.addDereference(this.cfgBuilder, qualifier, (PsiElement)qualifier, true, (GoDereferenceKind)GoDereferenceKind.FieldAccess.INSTANCE, this.mapper);
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr callExpr) {
        GoDereferenceKind goDereferenceKind;
        PsiElement method;
        GoReferenceExpression methodRef;
        Intrinsics.checkNotNullParameter((Object)callExpr, (String)"callExpr");
        switch (WhenMappings.$EnumSwitchMapping$0[this.config.getMode().ordinal()]) {
            case 1: {
                this.visitElement(callExpr);
                break;
            }
            case 2: {
                GoDfaGlobalTranslatorExtensionKt.translateCallExpr(callExpr, this.mapper, this.cfgBuilder, this.config);
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        for (GoExpression argument : callExpr.getArgumentList().getExpressionList()) {
            Intrinsics.checkNotNull((Object)argument);
            GoNamedElement def = GoDfaUtilsKt.getVariableOrParameterOrReceiverDefinition(argument);
            if (def == null || !GoStdlibUtil.implementsError(def.getGoType(null), def)) continue;
            this.cfgBuilder.addVarInvalidationStmt(this.mapper.getVarID(def), this.mapper.getLocation(callExpr));
        }
        GoReferenceExpression goReferenceExpression = methodRef = GoPsiUtil.getCallReference(callExpr);
        Object object = method = goReferenceExpression != null ? goReferenceExpression.resolve() : null;
        if (!(method instanceof GoMethodDeclaration) && !(method instanceof GoMethodSpec)) {
            return;
        }
        GoResolvable goResolvable = methodRef.getResolvableQualifier();
        if (goResolvable == null) {
            return;
        }
        GoResolvable receiverRef = goResolvable;
        boolean isNilReceiverAllowed = GoNilnessInspection.allowsNilReceiver(method instanceof GoMethodDeclaration ? (GoMethodDeclaration)method : null);
        if (isNilReceiverAllowed) {
            goDereferenceKind = GoDereferenceKind.MethodCallNilableReceiver.INSTANCE;
        } else {
            TextRange textRange = receiverRef.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            goDereferenceKind = new GoDereferenceKind.MethodCallNotNilReceiver(textRange);
        }
        GoDereferenceKind kind = goDereferenceKind;
        GoExpressionTranslatorKt.addDereference(this.cfgBuilder, receiverRef, (PsiElement)callExpr, !isNilReceiverAllowed, kind, this.mapper);
    }

    @Override
    public void visitFunctionLit(@NotNull GoFunctionLit function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        for (GoNamedElement varOrParameter : GoDataFlowUtil.findUnpredictableVars(function)) {
            Intrinsics.checkNotNull((Object)varOrParameter);
            this.cfgBuilder.addUncontrolledVarStmt(this.mapper.getVarID(varOrParameter), this.mapper.getLocation(function));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GoDfaMode.values().length];
            try {
                nArray[GoDfaMode.Local.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoDfaMode.Global.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

