/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.symbolicExecution.interpreter;

import com.goide.dfa.symbolicExecution.common.UtilsKt;
import com.goide.dfa.symbolicExecution.interpreter.ConstantValue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u0011\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004H\u0086\u0002J\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0006J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u001c\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006!"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/ConstantValueSet;", "", "values", "", "Lcom/goide/dfa/symbolicExecution/interpreter/ConstantValue;", "isFinite", "", "<init>", "(Ljava/util/Set;Z)V", "getValues", "()Ljava/util/Set;", "()Z", "toString", "", "unite", "other", "subtract", "intersect", "negate", "contains", "value", "isAnything", "isEmpty", "isNotEmpty", "toSingle", "asBounded", "component1", "component2", "copy", "equals", "hashCode", "", "Companion", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nGoDfaSymbolicState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoDfaSymbolicState.kt\ncom/goide/dfa/symbolicExecution/interpreter/ConstantValueSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,370:1\n1#2:371\n*E\n"})
public final class ConstantValueSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<ConstantValue> values;
    private final boolean isFinite;

    public ConstantValueSet(@NotNull Set<? extends ConstantValue> values2, boolean isFinite) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.values = values2;
        this.isFinite = isFinite;
    }

    @NotNull
    public final Set<ConstantValue> getValues() {
        return this.values;
    }

    public final boolean isFinite() {
        return this.isFinite;
    }

    @NotNull
    public String toString() {
        if (this.isAnything()) {
            return "{*}";
        }
        String dataStr = UtilsKt.joinToSortedString$default(this.values, null, "{", "}", 1, null);
        return this.isFinite ? dataStr : "!" + dataStr;
    }

    @NotNull
    public final ConstantValueSet unite(@NotNull ConstantValueSet other) {
        ConstantValueSet constantValueSet;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.isFinite && other.isFinite) {
            constantValueSet = new ConstantValueSet(SetsKt.plus(this.values, (Iterable)other.values), true);
        } else if (!this.isFinite && !other.isFinite) {
            constantValueSet = new ConstantValueSet(CollectionsKt.intersect((Iterable)this.values, (Iterable)other.values), false);
        } else {
            ConstantValueSet finite = this.isFinite ? this : other;
            ConstantValueSet infinite = !this.isFinite ? this : other;
            constantValueSet = new ConstantValueSet(SetsKt.minus(infinite.values, (Iterable)finite.values), false);
        }
        return constantValueSet;
    }

    @NotNull
    public final ConstantValueSet subtract(@NotNull ConstantValueSet other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.isFinite && other.isFinite ? new ConstantValueSet(SetsKt.minus(this.values, (Iterable)other.values), true) : (!this.isFinite && !other.isFinite ? new ConstantValueSet(SetsKt.minus(other.values, (Iterable)this.values), true) : (!this.isFinite && other.isFinite ? new ConstantValueSet(SetsKt.plus(this.values, (Iterable)other.values), false) : new ConstantValueSet(CollectionsKt.intersect((Iterable)this.values, (Iterable)other.values), true)));
    }

    @NotNull
    public final ConstantValueSet intersect(@NotNull ConstantValueSet other) {
        ConstantValueSet constantValueSet;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.isFinite && other.isFinite) {
            constantValueSet = new ConstantValueSet(CollectionsKt.intersect((Iterable)this.values, (Iterable)other.values), true);
        } else if (!this.isFinite && !other.isFinite) {
            constantValueSet = new ConstantValueSet(SetsKt.plus(this.values, (Iterable)other.values), false);
        } else {
            ConstantValueSet finite = this.isFinite ? this : other;
            ConstantValueSet infinite = !this.isFinite ? this : other;
            constantValueSet = new ConstantValueSet(SetsKt.minus(finite.values, (Iterable)infinite.values), true);
        }
        return constantValueSet;
    }

    @NotNull
    public final ConstantValueSet negate() {
        return new ConstantValueSet(this.values, !this.isFinite);
    }

    public final boolean contains(@NotNull ConstantValue value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return this.intersect(Companion.single(value2)).isNotEmpty();
    }

    public final boolean isAnything() {
        return !this.isFinite && this.values.isEmpty();
    }

    public final boolean isEmpty() {
        return this.isFinite && this.values.isEmpty();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ConstantValue toSingle() {
        if (this.isFinite) {
            Set<ConstantValue> set;
            Set<ConstantValue> it = set = this.values;
            boolean bl = false;
            if (it.size() != 1) return null;
            boolean bl2 = true;
            if (!bl2) return null;
            Set<ConstantValue> set2 = set;
            if (set2 == null) return null;
            v2 = (ConstantValue)CollectionsKt.first((Iterable)set2);
            return v2;
        } else {
            Object object = this.values;
            Set<ConstantValue> it = object;
            boolean bl = false;
            if (it.size() != 1) return null;
            boolean bl3 = true;
            if (!bl3) return null;
            Set<ConstantValue> set = object;
            Set<ConstantValue> set3 = set;
            if (set3 == null) return null;
            object = (ConstantValue)CollectionsKt.first((Iterable)set3);
            if (object == null) return null;
            Object value2 = object;
            boolean bl4 = false;
            Object object2 = value2;
            if (object2 instanceof ConstantValue.Bool) {
                v2 = ((ConstantValue.Bool)value2).negate();
                return v2;
            } else if (object2 instanceof ConstantValue.Nilness) {
                v2 = ((ConstantValue.Nilness)value2).negate();
                return v2;
            } else {
                if (!(object2 instanceof ConstantValue.Integer)) throw new NoWhenBranchMatchedException();
                return null;
            }
        }
    }

    @Nullable
    public final Set<ConstantValue> asBounded() {
        return this.isFinite ? this.values : null;
    }

    @NotNull
    public final Set<ConstantValue> component1() {
        return this.values;
    }

    public final boolean component2() {
        return this.isFinite;
    }

    @NotNull
    public final ConstantValueSet copy(@NotNull Set<? extends ConstantValue> values2, boolean isFinite) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        return new ConstantValueSet(values2, isFinite);
    }

    public static /* synthetic */ ConstantValueSet copy$default(ConstantValueSet constantValueSet, Set set, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = constantValueSet.values;
        }
        if ((n & 2) != 0) {
            bl = constantValueSet.isFinite;
        }
        return constantValueSet.copy(set, bl);
    }

    public int hashCode() {
        int result = ((Object)this.values).hashCode();
        result = result * 31 + Boolean.hashCode(this.isFinite);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConstantValueSet)) {
            return false;
        }
        ConstantValueSet constantValueSet = (ConstantValueSet)other;
        if (!Intrinsics.areEqual(this.values, constantValueSet.values)) {
            return false;
        }
        return this.isFinite == constantValueSet.isFinite;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/goide/dfa/symbolicExecution/interpreter/ConstantValueSet$Companion;", "", "<init>", "()V", "empty", "Lcom/goide/dfa/symbolicExecution/interpreter/ConstantValueSet;", "single", "value", "Lcom/goide/dfa/symbolicExecution/interpreter/ConstantValue;", "universe", "intellij.go.dfa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConstantValueSet empty() {
            return new ConstantValueSet(SetsKt.emptySet(), true);
        }

        @NotNull
        public final ConstantValueSet single(@NotNull ConstantValue value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return new ConstantValueSet(SetsKt.setOf((Object)value2), true);
        }

        @NotNull
        public final ConstantValueSet universe() {
            return new ConstantValueSet(SetsKt.emptySet(), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

