/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.symbolicExecution.common;

import com.goide.dfa.GoDfaConfigGlobal;
import com.goide.dfa.symbolicExecution.common.UtilsKt;
import com.goide.dfa.symbolicExecution.summaries.id.GoCallableIdKt;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoReferenceExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rml.dfa.ir.IrLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a9\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\u0003\u00a2\u0006\u0002\u0010\u0007\u001a`\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00032\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00030\r\u001a`\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\t2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\u001e\u0010\u0014\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0016\u0012\u0004\u0012\u00020\u000f0\u0015\u001aH\u0010\u0017\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\u000f0\u0015\u001a4\u0010\u0017\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0011\u001a\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020\u001c*\u00020 \u001a\n\u0010!\u001a\u00020\"*\u00020 \u001a\u0011\u0010#\u001a\u0004\u0018\u00010\u001c*\u00020 \u00a2\u0006\u0002\u0010$\u001aZ\u0010%\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H*0'0&\"\u0004\b\u0000\u0010(\"\u0004\b\u0001\u0010)\"\u0004\b\u0002\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H(0&2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H)0&2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H*0&\u001a\u0014\u0010.\u001a\u0004\u0018\u00010/*\u0002002\u0006\u00101\u001a\u00020 \u001a\u001c\u00102\u001a\u0004\u0018\u000103*\u00020/2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001c\u001a\u0016\u00107\u001a\u0002052\u0006\u00101\u001a\u00020 2\u0006\u00108\u001a\u000209\u00a8\u0006:"}, d2={"createDefaultMutableMap", "", "K", "V", "keys", "", "default", "(Ljava/util/Collection;Ljava/lang/Object;)Ljava/util/Map;", "merge", "", "m1", "m2", "f", "Lkotlin/Function2;", "toStableString", "", "separator", "", "prefix", "postfix", "transform", "Lkotlin/Function1;", "Lkotlin/Pair;", "joinToSortedString", "T", "getGoFileById", "Lcom/goide/psi/GoFile;", "id", "", "project", "Lcom/intellij/openapi/project/Project;", "getLinesCount", "Lcom/intellij/psi/PsiFile;", "getVirtualFileSafe", "Lcom/intellij/openapi/vfs/VirtualFile;", "getId", "(Lcom/intellij/psi/PsiFile;)Ljava/lang/Integer;", "zip3", "", "Lkotlin/Triple;", "T1", "T2", "T3", "xs", "ys", "zs", "toGoCallExpr", "Lcom/goide/psi/GoCallExpr;", "Lcom/intellij/rml/dfa/ir/IrLocation;", "file", "getArgumentElement", "Lcom/intellij/psi/PsiElement;", "isMethod", "", "index", "isFileWithinLimit", "config", "Lcom/goide/dfa/GoDfaConfigGlobal;", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/goide/dfa/symbolicExecution/common/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,158:1\n1299#2,4:159\n1285#2,2:163\n1299#2,4:165\n1563#2:169\n1634#2,3:170\n1563#2:173\n1634#2,3:174\n1563#2:177\n1634#2,3:178\n19#3:181\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/goide/dfa/symbolicExecution/common/UtilsKt\n*L\n23#1:159,4\n27#1:163,2\n27#1:165,4\n42#1:169\n42#1:170,3\n49#1:173\n49#1:174,3\n126#1:177\n126#1:178,3\n140#1:181\n*E\n"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> createDefaultMutableMap(@NotNull Collection<? extends K> keys, V v) {
        void $this$associateWithTo$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Map result = new LinkedHashMap();
        Iterable iterable = keys;
        Map destination$iv = result;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object t = element$iv = iterator.next();
            Object t2 = element$iv;
            Map map = destination$iv;
            boolean bl = false;
            V v2 = v;
            map.put(t2, v2);
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> merge(@NotNull Map<K, ? extends V> m1, @NotNull Map<K, ? extends V> m2, @NotNull Function2<? super V, ? super V, ? extends V> f) {
        Intrinsics.checkNotNullParameter(m1, (String)"m1");
        Intrinsics.checkNotNullParameter(m2, (String)"m2");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Iterable $this$associateWith$iv = SetsKt.plus(m1.keySet(), (Iterable)m2.keySet());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            void it;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Object t2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            V l = m1.get(it);
            V r = m2.get(it);
            if (l == null) {
                V v = r;
                object = v;
                Intrinsics.checkNotNull(v);
            } else {
                object = r == null ? l : f.invoke(l, r);
            }
            V v = object;
            map.put(t2, v);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> String toStableString(@NotNull Map<K, ? extends V> $this$toStableString, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix, @NotNull Function1<? super Pair<? extends K, ? extends V>, String> transform) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toStableString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable $this$map$iv = MapsKt.toList($this$toStableString);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)transform.invoke((Object)it));
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix, (int)0, null, null, (int)56, null);
    }

    public static /* synthetic */ String toStableString$default(Map map, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charSequence = ", ";
        }
        if ((n & 2) != 0) {
            charSequence2 = "";
        }
        if ((n & 4) != 0) {
            charSequence3 = "";
        }
        return UtilsKt.toStableString(map, charSequence, charSequence2, charSequence3, function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> String joinToSortedString(@NotNull Collection<? extends T> $this$joinToSortedString, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix, @NotNull Function1<? super T, String> transform) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$joinToSortedString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Iterable $this$map$iv = $this$joinToSortedString;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)transform.invoke((Object)it));
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)separator, (CharSequence)prefix, (CharSequence)postfix, (int)0, null, null, (int)56, null);
    }

    public static /* synthetic */ String joinToSortedString$default(Collection collection, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charSequence = ", ";
        }
        if ((n & 2) != 0) {
            charSequence2 = "";
        }
        if ((n & 4) != 0) {
            charSequence3 = "";
        }
        return UtilsKt.joinToSortedString(collection, charSequence, charSequence2, charSequence3, function1);
    }

    @NotNull
    public static final <T> String joinToSortedString(@NotNull Collection<? extends T> $this$joinToSortedString, @NotNull CharSequence separator, @NotNull CharSequence prefix, @NotNull CharSequence postfix) {
        Intrinsics.checkNotNullParameter($this$joinToSortedString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)postfix, (String)"postfix");
        return UtilsKt.joinToSortedString($this$joinToSortedString, separator, prefix, postfix, joinToSortedString.2.INSTANCE);
    }

    public static /* synthetic */ String joinToSortedString$default(Collection collection, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, Object object) {
        if ((n & 1) != 0) {
            charSequence = ", ";
        }
        if ((n & 2) != 0) {
            charSequence2 = "";
        }
        if ((n & 4) != 0) {
            charSequence3 = "";
        }
        return UtilsKt.joinToSortedString(collection, charSequence, charSequence2, charSequence3);
    }

    @Nullable
    public static final GoFile getGoFileById(int id, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = ManagingFS.getInstance().findFileById(id);
        if (virtualFile == null) {
            GoCallableIdKt.getLOG().warn("Cannot find virtual file with id=" + id);
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        return psiFile instanceof GoFile ? (GoFile)psiFile : null;
    }

    public static final int getLinesCount(@NotNull PsiFile $this$getLinesCount) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)$this$getLinesCount, (String)"<this>");
        Document document2 = document = PsiDocumentManager.getInstance((Project)$this$getLinesCount.getProject()).getDocument($this$getLinesCount);
        return document2 != null ? document2.getLineCount() : -1;
    }

    @NotNull
    public static final VirtualFile getVirtualFileSafe(@NotNull PsiFile $this$getVirtualFileSafe) {
        Intrinsics.checkNotNullParameter((Object)$this$getVirtualFileSafe, (String)"<this>");
        VirtualFile virtualFile = $this$getVirtualFileSafe.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return VirtualFileUtil.originalFileOrSelf((VirtualFile)virtualFile);
    }

    @Nullable
    public static final Integer getId(@NotNull PsiFile $this$getId) {
        Integer fileId;
        Intrinsics.checkNotNullParameter((Object)$this$getId, (String)"<this>");
        VirtualFile virtualFile = UtilsKt.getVirtualFileSafe($this$getId);
        VirtualFileWithId virtualFileWithId = virtualFile instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile : null;
        Integer n = fileId = virtualFileWithId != null ? Integer.valueOf(virtualFileWithId.getId()) : null;
        if (fileId == null) {
            GoCallableIdKt.getLOG().warn("File " + virtualFile.getPath() + " is not VirtualFileWithId, skipping function summary id creation for " + $this$getId.getName());
            return null;
        }
        return fileId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T1, T2, T3> List<Triple<T1, T2, T3>> zip3(@NotNull List<? extends T1> xs, @NotNull List<? extends T2> ys, @NotNull List<? extends T3> zs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Intrinsics.checkNotNullParameter(zs, (String)"zs");
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)CollectionsKt.zip((Iterable)xs, (Iterable)ys), (Iterable)zs);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair p1 = (Pair)pair.component1();
            Object p2 = pair.component2();
            collection.add(new Triple(p1.getFirst(), p1.getSecond(), p2));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final GoCallExpr toGoCallExpr(@NotNull IrLocation $this$toGoCallExpr, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$toGoCallExpr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (GoCallExpr)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)$this$toGoCallExpr.getOffset1(), (int)$this$toGoCallExpr.getOffset2(), GoCallExpr.class);
    }

    @Nullable
    public static final PsiElement getArgumentElement(@NotNull GoCallExpr $this$getArgumentElement, boolean isMethod, int index) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)$this$getArgumentElement, (String)"<this>");
        if (isMethod && index == 0) {
            GoReferenceExpression expression;
            GoExpression $this$asSafely$iv = $this$getArgumentElement.getExpression();
            boolean $i$f$asSafely = false;
            GoExpression goExpression = $this$asSafely$iv;
            if (!(goExpression instanceof GoReferenceExpression)) {
                goExpression = null;
            }
            GoReferenceExpression goReferenceExpression = expression = (GoReferenceExpression)goExpression;
            psiElement = goReferenceExpression != null ? goReferenceExpression.getQualifier() : null;
        } else {
            int argIndex = isMethod ? index - 1 : index;
            List<GoExpression> list = $this$getArgumentElement.getArgumentList().getExpressionList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionList(...)");
            psiElement = (PsiElement)CollectionsKt.getOrNull(list, (int)argIndex);
        }
        return psiElement;
    }

    public static final boolean isFileWithinLimit(@NotNull PsiFile file, @NotNull GoDfaConfigGlobal config) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        VirtualFile vFile = UtilsKt.getVirtualFileSafe(file);
        if (vFile.getLength() > config.getFileSizeLimitBt()) {
            return false;
        }
        return UtilsKt.getLinesCount(file) <= config.getFileLinesCountLimit();
    }
}

