/*
 * Decompiled with CFR 0.152.
 */
package com.goide.configuration;

import com.goide.configuration.GoLibrariesConfigurable;
import com.goide.configuration.GoLibrariesConfigurableContent;
import com.goide.configuration.GoModuleAwareConfigurable;
import com.goide.i18n.GoBundle;
import com.goide.project.GoApplicationLibrariesService;
import com.goide.project.GoModuleLibrariesService;
import com.goide.project.GoProjectLibrariesService;
import com.goide.project.GoRootsProvider;
import com.goide.sdk.GoSdkUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLibrariesConfigurableProvider
extends ConfigurableProvider {
    @NotNull
    private final Project myProject;

    public GoLibrariesConfigurableProvider(@NotNull Project project) {
        if (project == null) {
            GoLibrariesConfigurableProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public Configurable createConfigurable() {
        return this.createConfigurable(false);
    }

    @NotNull
    private Configurable createConfigurable(boolean dialogMode) {
        return new CompositeConfigurable<UnnamedConfigurable>(){

            @NotNull
            public JComponent createComponent() {
                List configurables = this.getConfigurables();
                GoLibrariesConfigurableContent goLibrariesConfigurableContent = new GoLibrariesConfigurableContent(GoLibrariesConfigurableProvider.this.myProject, configurables);
                DialogPanel dialogPanel = goLibrariesConfigurableContent.panel;
                if (dialogPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dialogPanel;
            }

            @NotNull
            protected List<UnnamedConfigurable> createConfigurables() {
                ArrayList<UnnamedConfigurable> result = new ArrayList<UnnamedConfigurable>();
                List urlsFromEnv = ContainerUtil.map(GoSdkUtil.getGoPathsRootsFromEnvironment(GoLibrariesConfigurableProvider.this.myProject, null), VirtualFile::getUrl);
                List defaultPaths = ContainerUtil.mapNotNull((Collection)GoRootsProvider.EP_NAME.getExtensionList(), e -> {
                    VirtualFile file = e.getDefaultGoPath(GoLibrariesConfigurableProvider.this.myProject, null);
                    return file != null ? file.getUrl() : null;
                });
                GoLibrariesConfigurable applicationConfigurable = new GoLibrariesConfigurable(GoBundle.message((String)"go.settings.global.gopath.group.name", (Object[])new Object[0]), GoApplicationLibrariesService.getInstance());
                result.add((UnnamedConfigurable)applicationConfigurable);
                GoLibrariesConfigurable projectConfigurable = new GoLibrariesConfigurable(GoBundle.message((String)"go.settings.project.gopath.group.name", (Object[])new Object[0]), GoProjectLibrariesService.getInstance(GoLibrariesConfigurableProvider.this.myProject));
                result.add((UnnamedConfigurable)projectConfigurable);
                if (!GoLibrariesConfigurableProvider.this.myProject.isDefault()) {
                    result.add((UnnamedConfigurable)new GoModuleAwareConfigurable(GoLibrariesConfigurableProvider.this.myProject, GoBundle.message((String)"go.settings.module.gopath.group.name", (Object[])new Object[0]), null){

                        @NotNull
                        protected UnnamedConfigurable createModuleConfigurable(@NotNull Module module) {
                            if (module == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return new GoLibrariesConfigurable(GoBundle.message((String)"go.settings.module.gopath.group.name", (Object[])new Object[0]), GoModuleLibrariesService.getInstance(module));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/goide/configuration/GoLibrariesConfigurableProvider$1$1", "createModuleConfigurable"));
                        }
                    });
                }
                1.setupListeners(applicationConfigurable, projectConfigurable, urlsFromEnv, defaultPaths);
                ArrayList<UnnamedConfigurable> arrayList = result;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static void setupListeners(@NotNull GoLibrariesConfigurable applicationConfigurable, @NotNull GoLibrariesConfigurable projectConfigurable, @NotNull List<String> urlsFromEnv, @NotNull List<String> defaultPaths) {
                if (applicationConfigurable == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (projectConfigurable == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (urlsFromEnv == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (defaultPaths == null) {
                    1.$$$reportNull$$$0(5);
                }
                Runnable updateDefaultPaths = () -> {
                    applicationConfigurable.removeReadOnlyUrls(true);
                    if (applicationConfigurable.getUserDefinedUrls().isEmpty() && projectConfigurable.getUserDefinedUrls().isEmpty() && applicationConfigurable.getReadOnlyUrls(false).isEmpty()) {
                        applicationConfigurable.addReadOnlyUrls(defaultPaths, true);
                    }
                };
                projectConfigurable.setUseGoPathCheckBoxValueConsumer(value2 -> {
                    if (value2.booleanValue()) {
                        applicationConfigurable.addReadOnlyUrls(urlsFromEnv, false);
                    } else {
                        applicationConfigurable.removeReadOnlyUrls(false);
                    }
                    updateDefaultPaths.run();
                });
                applicationConfigurable.addPathsChangeListener(updateDefaultPaths);
                projectConfigurable.addPathsChangeListener(updateDefaultPaths);
                updateDefaultPaths.run();
            }

            @NotNull
            @Nls
            public String getDisplayName() {
                return "GOPATH";
            }

            @NotNull
            public String getHelpTopic() {
                return "Configuring_GOROOT_and_GOPATH";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3, 4, 5 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/configuration/GoLibrariesConfigurableProvider$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "applicationConfigurable";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectConfigurable";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "urlsFromEnv";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultPaths";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createConfigurables";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/configuration/GoLibrariesConfigurableProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "setupListeners";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3, 4, 5 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public static boolean isConfigurableExpanded(int index, @NotNull Configurable configurable, @NotNull Project project) {
        String oldKey;
        PropertiesComponent properties;
        if (configurable == null) {
            GoLibrariesConfigurableProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GoLibrariesConfigurableProvider.$$$reportNull$$$0(2);
        }
        if ((properties = PropertiesComponent.getInstance((Project)project)).isValueSet(oldKey = GoLibrariesConfigurableProvider.getConfigurableExpandedOldPropertyKey(configurable))) {
            properties.setValue(GoLibrariesConfigurableProvider.getConfigurableExpandedPropertyKey(configurable), properties.getValue(oldKey));
            properties.unsetValue(oldKey);
        }
        return properties.getBoolean(GoLibrariesConfigurableProvider.getConfigurableExpandedPropertyKey(configurable), index < 2);
    }

    @Deprecated
    private static String getConfigurableExpandedOldPropertyKey(@NotNull Configurable configurable) {
        if (configurable == null) {
            GoLibrariesConfigurableProvider.$$$reportNull$$$0(3);
        }
        String keyName = "configurable " + configurable.getDisplayName() + " is expanded";
        return keyName.replace(' ', '.');
    }

    public static String getConfigurableExpandedPropertyKey(@NotNull Configurable configurable) {
        if (configurable == null) {
            GoLibrariesConfigurableProvider.$$$reportNull$$$0(4);
        }
        return "configurable." + configurable.getClass().getSimpleName() + ".is.expanded";
    }

    public static void showModulesConfigurable(@NotNull Project project) {
        if (project == null) {
            GoLibrariesConfigurableProvider.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!project.isDisposed()) {
            Configurable configurable = new GoLibrariesConfigurableProvider(project).createConfigurable(true);
            ShowSettingsUtil.getInstance().editConfigurable(project, configurable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
        }
        objectArray2[1] = "com/goide/configuration/GoLibrariesConfigurableProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurableExpanded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurableExpandedOldPropertyKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurableExpandedPropertyKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showModulesConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

