/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoLookupElementOptions;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReference;
import com.goide.psi.impl.GoScopeProcessor;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoReceiverCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        String receiverName;
        PsiElement position;
        GoReferenceExpression expression;
        if (parameters == null) {
            GoReceiverCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GoReceiverCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            GoReceiverCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((expression = (GoReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)(position = parameters.getPosition()), GoReferenceExpression.class)) == null || expression.getQualifier() != null) {
            return;
        }
        GoReceiver receiver = GoReceiverCompletionProvider.getReceiver(expression);
        String string = receiverName = receiver != null ? receiver.getName() : null;
        if (receiverName == null) {
            return;
        }
        GoReference reference = GoReceiverCompletionProvider.createReference(receiver, expression);
        if (reference != null) {
            final CompletionResultSet res = GoCompletionUtil.withCamelHumpPrefixMatcher(result);
            reference.processResolveVariants(new GoScopeProcessor(){

                @Override
                public boolean isCompletion() {
                    return true;
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    String name;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (StringUtil.isEmpty((String)(name = (String)ObjectUtils.doIfCast((Object)element, GoNamedElement.class, it -> it.getName())))) {
                        return true;
                    }
                    String lookup = receiverName + "." + name;
                    InsertHandler<LookupElement> handler = GoCompletionUtil.Lazy.VARIABLE_OR_FUNCTION_INSERT_HANDLER;
                    GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(lookup).setInsertHandler(handler);
                    if (element instanceof GoFieldDefinition || element instanceof GoAnonymousFieldDefinition) {
                        res.addElement(GoCompletionUtil.createVariableLikeLookupElement((GoNamedElement)element, options));
                    } else if (element instanceof GoMethodDeclaration) {
                        res.addElement(GoCompletionUtil.createFunctionOrMethodLookupElement((GoMethodDeclaration)element, options));
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/goide/completion/GoReceiverCompletionProvider$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, GoPsiImplUtil.createContextOnElement(parameters.getPosition()));
        }
    }

    @Nullable
    private static GoReference createReference(@NotNull GoReceiver receiver, @NotNull GoReferenceExpression expression) {
        String typeImportPath;
        String typeName;
        GoType type;
        if (receiver == null) {
            GoReceiverCompletionProvider.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            GoReceiverCompletionProvider.$$$reportNull$$$0(4);
        }
        GoTypeSpec resolvedType = (type = GoTypeUtil.unwrapPointerAndParTypes(receiver.getType())) != null ? (GoTypeSpec)ObjectUtils.tryCast((Object)type.resolve(ResolveState.initial()), GoTypeSpec.class) : null;
        String string = typeName = resolvedType != null ? resolvedType.getName() : null;
        if (typeName == null) {
            return null;
        }
        GoFile typeFile = (GoFile)((Object)ObjectUtils.tryCast((Object)type.getContainingFile().getOriginalFile(), GoFile.class));
        String string2 = typeImportPath = typeFile != null ? typeFile.getImportPath(GoVendoringUtil.isVendoringEnabled(expression)) : null;
        if (typeImportPath == null) {
            return null;
        }
        Object importString = GoPsiImplUtil.builtin(type) ? "" : "import pkg \"" + typeImportPath + "\";";
        String qualifier = StringUtil.isNotEmpty((String)importString) ? "pkg." : "";
        String text = "package main; " + (String)importString + "var (a " + qualifier + typeName + "; b = a." + expression.getIdentifier().getText() + ")";
        GoVarDeclaration declaration = GoElementFactory.createElement(expression.getProject(), text, GoVarDeclaration.class, null);
        GoVarSpec spec = (GoVarSpec)ContainerUtil.getLastItem(declaration != null ? declaration.getVarSpecList() : null);
        GoExpression expr = (GoExpression)ContainerUtil.getLastItem(spec != null ? spec.getExpressionList() : null);
        GoReferenceExpression referenceExpression = (GoReferenceExpression)ObjectUtils.tryCast((Object)expr, GoReferenceExpression.class);
        return referenceExpression != null ? referenceExpression.getReference() : null;
    }

    @Nullable
    private static GoReceiver getReceiver(@Nullable PsiElement context) {
        GoMethodDeclaration method = (GoMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, GoMethodDeclaration.class);
        return method != null ? method.getReceiver() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/goide/completion/GoReceiverCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

