/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.codeInsight.imports.GoImport;
import com.goide.completion.CancellableCollectProcessor;
import com.goide.completion.GoCompletionUtil;
import com.goide.completion.GoLookupElementOptions;
import com.goide.editor.template.GoLocalNameMacro;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.template.GoTemplate;
import com.goide.sdk.GoSdkUtil;
import com.goide.stubs.index.GoFunctionIndex;
import com.goide.stubs.index.GoIdFilter;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoMethodLikeFunctionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final InsertHandler<LookupElement> HANDLER = (context, item) -> {
        GoQualifier qualifier;
        GoFunctionDeclaration function = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)item.getPsiElement(), GoFunctionDeclaration.class);
        GoSignature signature = (GoSignature)ObjectUtils.doIfNotNull((Object)function, GoFunctionDeclaration::getSignature);
        if (signature == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
        PsiElement position = context.getFile().findElementAt(context.getStartOffset());
        GoReferenceExpressionBase expression = (GoReferenceExpressionBase)PsiTreeUtil.getParentOfType((PsiElement)position, GoReferenceExpressionBase.class);
        GoQualifier goQualifier = qualifier = expression != null ? expression.getQualifier() : null;
        if (qualifier == null) {
            return;
        }
        boolean withVendoring = GoVendoringUtil.isVendoringEnabled((PsiElement)context.getFile());
        GoTemplate template = new GoTemplate((GoFile)context.getFile());
        if (GoPsiImplUtil.isBuiltinFile((PsiFile)function.getContainingFile())) {
            template.addTextSegment(Objects.requireNonNull(function.getName()));
        } else {
            MacroCallNode localNameMacro = new MacroCallNode((Macro)new GoLocalNameMacro());
            localNameMacro.addParameter((Expression)new ConstantNode(Objects.requireNonNull(function.getContainingFile().getImportPath(withVendoring))));
            localNameMacro.addParameter((Expression)new ConstantNode(Objects.requireNonNull(function.getName())));
            template.getTemplate().addVariable("FUNC", (Expression)localNameMacro, false);
        }
        template.addTextSegment("(");
        template.addTextSegment(qualifier.getText());
        if (signature.getParameters().getDefinitionList().size() > 1) {
            template.addTextSegment(", ");
            template.addEndVariable();
            template.addTextSegment(")");
            template.addListener((TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AutoPopupController.getInstance((Project)context.getProject()).autoPopupParameterInfo(context.getEditor(), null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/goide/completion/GoMethodLikeFunctionCompletionProvider$1", "templateFinished"));
                }
            });
        } else {
            template.addTextSegment(")");
            template.addEndVariable();
        }
        template.startTemplate(context.getEditor(), expression.getTextOffset(), GoBundle.message((String)"go.completion.method.like.completion.command.name", (Object[])new Object[0]), expression.getTextRange());
    };

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        String functionName;
        if (parameters == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(2);
        }
        if (parameters.getInvocationCount() < 2) {
            String shortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
            result.addLookupAdvertisement(GoBundle.message((String)"go.completion.method.like.completion.advertisement", (Object[])new Object[]{shortcut}));
            return;
        }
        PsiElement position = parameters.getPosition();
        GoType type = GoMethodLikeFunctionCompletionProvider.getExpectedFirstFunctionArgumentType(position);
        if (type == null) {
            return;
        }
        Project project = position.getProject();
        CompletionResultSet finalResult = GoCompletionUtil.withCamelHumpPrefixMatcher(result);
        Module module = GoUtil.module((PsiElement)parameters.getOriginalFile());
        boolean withVendoring = GoVendoringUtil.isVendoringEnabled(module);
        PrefixMatcher prefixMatcher = finalResult.getPrefixMatcher();
        GlobalSearchScope scope = GoUtil.goPathResolveScope((PsiElement)parameters.getOriginalFile());
        for (String string : GoMethodLikeFunctionCompletionProvider.getExportedFunctionNames(project, prefixMatcher)) {
            GoFunctionIndex.process(string, project, scope, GoIdFilter.getProductionFilter(project), (Processor<? super GoFunctionDeclaration>)((Processor)function -> {
                ProgressManager.checkCanceled();
                GoFile functionFile = function.getContainingFile();
                if (GoPsiImplUtil.canBeAutoImported(functionFile, false, module, withVendoring) && GoMethodLikeFunctionCompletionProvider.isMatched(function, functionName2, type, prefixMatcher, position)) {
                    GoMethodLikeFunctionCompletionProvider.addElement(finalResult, functionName2, function, functionFile.getImportPath(withVendoring));
                }
                return true;
            }));
        }
        for (GoFunctionDeclaration goFunctionDeclaration : GoMethodLikeFunctionCompletionProvider.getBuiltinFunctions(position)) {
            if (!GoMethodLikeFunctionCompletionProvider.isMatched(goFunctionDeclaration, functionName = goFunctionDeclaration.getName(), type, prefixMatcher, position)) continue;
            GoMethodLikeFunctionCompletionProvider.addElement(finalResult, functionName, goFunctionDeclaration, null);
        }
        for (GoFunctionDeclaration goFunctionDeclaration : GoMethodLikeFunctionCompletionProvider.getUnexportedPackageFunctions(parameters.getOriginalFile())) {
            if (!GoMethodLikeFunctionCompletionProvider.isMatched(goFunctionDeclaration, functionName = goFunctionDeclaration.getName(), type, prefixMatcher, position)) continue;
            GoMethodLikeFunctionCompletionProvider.addElement(finalResult, functionName, goFunctionDeclaration, null);
        }
    }

    @NotNull
    private static Collection<? extends GoFunctionDeclaration> getBuiltinFunctions(@NotNull PsiElement position) {
        GoFile builtinFile;
        if (position == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(3);
        }
        Collection<Object> collection = (builtinFile = GoSdkUtil.findBuiltinFile(position)) != null ? builtinFile.getFunctions() : Collections.emptyList();
        if (collection == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private static Collection<GoFunctionDeclaration> getUnexportedPackageFunctions(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(5);
        }
        SmartList result = new SmartList();
        GoPackage currentPackage = (GoPackage)ObjectUtils.doIfCast((Object)currentFile, GoFile.class, GoPackage::of);
        if (currentPackage == null) {
            SmartList smartList = result;
            if (smartList == null) {
                GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(6);
            }
            return smartList;
        }
        currentPackage.processFiles((Processor<? super PsiFile>)((Processor)arg_0 -> GoMethodLikeFunctionCompletionProvider.lambda$getUnexportedPackageFunctions$2((List)result, arg_0)));
        SmartList smartList = result;
        if (smartList == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @Contract(value="_, null, _, _, _ -> false")
    private static boolean isMatched(@NotNull GoFunctionDeclaration function, @Nullable String functionName, @NotNull GoType type, @NotNull PrefixMatcher matcher, @Nullable PsiElement context) {
        if (function == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(8);
        }
        if (type == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(9);
        }
        if (matcher == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(10);
        }
        return functionName != null && matcher.isStartMatch(functionName) && GoMethodLikeFunctionCompletionProvider.hasFirstArgumentWithCompatibleType(function, type, context);
    }

    private static boolean hasFirstArgumentWithCompatibleType(@NotNull GoFunctionDeclaration function, @NotNull GoType expectedType, @Nullable PsiElement context) {
        GoType firstParamType;
        if (function == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(11);
        }
        if (expectedType == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(12);
        }
        return (firstParamType = GoMethodLikeFunctionCompletionProvider.getParameterTypeByIndex(function.getSignature())) != null && GoTypeUtil.isAssignable(firstParamType, null, expectedType, context, false);
    }

    private static void addElement(@NotNull CompletionResultSet result, @NotNull String functionName, @NotNull GoFunctionDeclaration function, @Nullable String importPath) {
        if (result == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(13);
        }
        if (functionName == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(14);
        }
        if (function == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(15);
        }
        GoImport goImport = importPath != null ? new GoImport(importPath) : null;
        GoLookupElementOptions options = new GoLookupElementOptions().setLookupString(functionName).setImport(goImport).setInsertHandler(HANDLER).setPriority(5.0);
        result.addElement(GoCompletionUtil.createFunctionOrMethodLookupElement(function, options));
    }

    @Nullable
    private static GoType getParameterTypeByIndex(@Nullable GoSignature signature) {
        if (signature == null) {
            return null;
        }
        GoParamDefinition firstParam = signature.getParameters().getDefinitionByIndex(0);
        return firstParam != null ? firstParam.getGoType(null) : signature.getParameters().getTypeByIndex(0);
    }

    @Nullable
    private static GoType getExpectedFirstFunctionArgumentType(@NotNull PsiElement position) {
        GoReferenceExpressionBase expression;
        PsiElement identifier;
        if (position == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(16);
        }
        PsiElement psiElement = identifier = (expression = (GoReferenceExpressionBase)PsiTreeUtil.getParentOfType((PsiElement)position, GoReferenceExpressionBase.class)) != null ? expression.getIdentifier() : null;
        if (position != identifier) {
            return null;
        }
        GoExpression qualifierExpression = (GoExpression)ObjectUtils.tryCast((Object)expression.getQualifier(), GoExpression.class);
        return qualifierExpression != null ? qualifierExpression.getGoType(null) : null;
    }

    @NotNull
    private static Set<String> getExportedFunctionNames(@NotNull Project project, final @NotNull PrefixMatcher prefixMatcher) {
        if (project == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(17);
        }
        if (prefixMatcher == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(18);
        }
        HashSet<String> result = new HashSet<String>();
        StubIndex.getInstance().processAllKeys(GoFunctionIndex.KEY, project, (Processor)new CancellableCollectProcessor<String>(result){

            protected boolean accept(String s) {
                return StringUtil.isCapitalized((String)s) && prefixMatcher.isStartMatch(s);
            }
        });
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoMethodLikeFunctionCompletionProvider.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static /* synthetic */ boolean lambda$getUnexportedPackageFunctions$2(List result, PsiFile file) {
        Collection functions = (Collection)ObjectUtils.doIfCast((Object)file, GoFile.class, GoFile::getFunctions);
        if (functions != null) {
            for (GoFunctionDeclaration function : functions) {
                if (function.isPublic()) continue;
                result.add(function);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoMethodLikeFunctionCompletionProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoMethodLikeFunctionCompletionProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinFunctions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnexportedPackageFunctions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedFunctionNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinFunctions";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUnexportedPackageFunctions";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMatched";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasFirstArgumentWithCompatibleType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedFirstFunctionArgumentType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getExportedFunctionNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 19 -> new IllegalStateException(string);
        };
    }
}

