/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.codeInsight.imports.GoImportsSettingsStorage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoImportsSettings
extends SimpleModificationTracker {
    private String[] myExcludedPackages = ArrayUtil.EMPTY_STRING_ARRAY;
    private boolean myShowImportPopup = true;
    private boolean myAddUnambiguousImportsOnTheFly = true;
    private boolean myOptimizeImportsOnTheFly = true;

    public static GoImportsSettings getInstance(Project project) {
        return GoImportsSettingsStorage.getInstance(project).getSettings();
    }

    public String[] getExcludedPackages() {
        return this.myExcludedPackages;
    }

    public void setExcludedPackages(String ... excludedPackages) {
        if (!Arrays.equals(excludedPackages, this.myExcludedPackages)) {
            Object[] sorted = (String[])ArrayUtil.copyOf((Object[])excludedPackages);
            Arrays.sort(sorted);
            this.myExcludedPackages = sorted;
            this.incModificationCount();
        }
    }

    public boolean isExcluded(@Nullable String importPath) {
        if (importPath == null) {
            return false;
        }
        for (String excludedPath : this.myExcludedPackages) {
            if (!FileUtil.isAncestor((String)excludedPath, (String)importPath, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void excludePath(@NotNull String importPath) {
        if (importPath == null) {
            GoImportsSettings.$$$reportNull$$$0(0);
        }
        this.setExcludedPackages((String[])ArrayUtil.append((Object[])this.myExcludedPackages, (Object)importPath));
    }

    public boolean isShowImportPopup() {
        return this.myShowImportPopup;
    }

    public void setShowImportPopup(boolean showImportPopup) {
        if (showImportPopup != this.myShowImportPopup) {
            this.myShowImportPopup = showImportPopup;
            this.incModificationCount();
        }
    }

    public boolean isAddUnambiguousImportsOnTheFly() {
        return this.myAddUnambiguousImportsOnTheFly;
    }

    public void setAddUnambiguousImportsOnTheFly(boolean addUnambiguousImportsOnTheFly) {
        if (this.myAddUnambiguousImportsOnTheFly != addUnambiguousImportsOnTheFly) {
            this.myAddUnambiguousImportsOnTheFly = addUnambiguousImportsOnTheFly;
            this.incModificationCount();
        }
    }

    public boolean isOptimizeImportsOnTheFly() {
        return this.myOptimizeImportsOnTheFly;
    }

    public void setOptimizeImportsOnTheFly(boolean optimizeImportsOnTheFly) {
        if (this.myOptimizeImportsOnTheFly != optimizeImportsOnTheFly) {
            this.myOptimizeImportsOnTheFly = optimizeImportsOnTheFly;
            this.incModificationCount();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPath", "com/goide/codeInsight/imports/GoImportsSettings", "excludePath"));
    }
}

