/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.debugger;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvVm;
import com.goide.dlv.dump.DlvDumpPanel;
import com.goide.dlv.dump.DlvThreadDump;
import com.goide.i18n.GoBundle;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class DlvDumpAction
extends AnAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DlvDumpAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DlvDebugProcess process;
        if (e == null) {
            DlvDumpAction.$$$reportNull$$$0(1);
        }
        if ((process = DlvDebugProcess.getCurrentProcess(e)) == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(!process.isThreadDumpInProgress());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DlvDumpAction.$$$reportNull$$$0(2);
        }
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final DlvDebugProcess debugProcess = DlvDebugProcess.getCurrentProcess(e);
        if (debugProcess != null) {
            DlvThreadDump lastSelectedDump = debugProcess.getLastSelectedDump();
            final DlvThreadDump.UiFilterSettings filter = lastSelectedDump != null ? lastSelectedDump.getUiFilterSettings() : null;
            new Task.Backgroundable(e.getProject(), GoBundle.message((String)"go.debugger.create.dump.background.task.title", (Object[])new Object[0]), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(true);
                    Promise promise = debugProcess.getThreadDump(indicator).then(dump -> {
                        if (dump != null) {
                            ApplicationManager.getApplication().invokeLater(() -> {
                                XDebugSession session = debugProcess.getSession();
                                RunnerLayoutUi ui = session.getUI();
                                if (ui == null) {
                                    return;
                                }
                                DlvDumpPanel panel2 = new DlvDumpPanel(session.getProject(), (DlvThreadDump)dump, filter);
                                String time = DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
                                String threadDumpName = dump.isIncomplete() ? GoBundle.message((String)"go.debugger.thread.dump.incomplete.display.name", (Object[])new Object[]{time}) : GoBundle.message((String)"go.debugger.thread.dump.display.name", (Object[])new Object[]{time});
                                Content content2 = ui.createContent(dump.getId(), (JComponent)panel2, threadDumpName, null, null);
                                content2.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)Boolean.TRUE);
                                content2.setCloseable(true);
                                content2.setDescription(threadDumpName);
                                ui.addContent(content2);
                                ui.addListener((ContentManagerListener)new ContentSelectionListener(debugProcess, content2, (DlvThreadDump)dump), (Disposable)content2);
                                ui.selectAndFocus(content2, true, true);
                                Disposer.register((Disposable)content2, (Disposable)panel2);
                            }, ModalityState.nonModal());
                        }
                        return dump;
                    });
                    try {
                        while (!indicator.isCanceled() && !debugProcess.getSession().isStopped()) {
                            try {
                                promise.blockingGet(10, TimeUnit.SECONDS);
                                break;
                            }
                            catch (TimeoutException timeoutException) {
                            }
                        }
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DlvVm.LOG.warn("Error while dumping stacks", error);
                    String details = error.getMessage();
                    if (details == null) {
                        details = error.getClass().getName();
                    }
                    XDebuggerManagerImpl.getNotificationGroup().createNotification(GoBundle.message((String)"go.debugger.thread.dump.error", (Object[])new Object[]{details}), NotificationType.WARNING).notify(project);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/goide/actions/debugger/DlvDumpAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/debugger/DlvDumpAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/debugger/DlvDumpAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ContentSelectionListener
    implements ContentManagerListener {
        private final DlvDebugProcess myDebugProcess;
        private final Content myContent;
        private final DlvThreadDump myDump;

        private ContentSelectionListener(@NotNull DlvDebugProcess debugProcess, @NotNull Content content2, @NotNull DlvThreadDump dump) {
            if (debugProcess == null) {
                ContentSelectionListener.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                ContentSelectionListener.$$$reportNull$$$0(1);
            }
            if (dump == null) {
                ContentSelectionListener.$$$reportNull$$$0(2);
            }
            this.myDebugProcess = debugProcess;
            this.myContent = content2;
            this.myDump = dump;
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ContentSelectionListener.$$$reportNull$$$0(3);
            }
            if (event.getContent() == this.myContent && event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                this.myDebugProcess.setLastSelectedDump(this.myDump);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcess";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dump";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/goide/actions/debugger/DlvDumpAction$ContentSelectionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

