/*
 * Decompiled with CFR 0.152.
 */
package com.goide;

import com.goide.project.GoActivityKey;
import com.goide.vgo.project.workspaceModel.VgoWorkspaceModelUpdater;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.backend.observation.ActivityKey;
import com.intellij.platform.backend.observation.TrackingUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.TimeoutUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLibrariesUtil {
    private static final Logger LOG = Logger.getInstance(GoLibrariesUtil.class);
    private static final AtomicBoolean myRootsChangeInProgress = new AtomicBoolean();

    public static void updateLibraries(@NotNull Project project, @NotNull RootsChangeRescanningInfo info, @NotNull Runnable changeRoots, @Nullable Runnable afterCallback) {
        if (project == null) {
            GoLibrariesUtil.$$$reportNull$$$0(0);
        }
        if (info == null) {
            GoLibrariesUtil.$$$reportNull$$$0(1);
        }
        if (changeRoots == null) {
            GoLibrariesUtil.$$$reportNull$$$0(2);
        }
        if (project.isDisposed()) {
            return;
        }
        LOG.debug("Libraries update requested", new Throwable());
        Application application = ApplicationManager.getApplication();
        boolean runSynchronouslyInHeadlessMode = application.isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode();
        Runnable runnable = Registry.is((String)"use.dependencies.cache.service", (boolean)false) && !runSynchronouslyInHeadlessMode ? () -> {
            if (!project.isDisposed()) {
                WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(changeRoots, info));
                if (afterCallback != null) {
                    afterCallback.run();
                }
            }
        } : () -> {
            if (!project.isDisposed()) {
                WriteAction.run(() -> {
                    boolean rootsChangeInProgress = myRootsChangeInProgress.getAndSet(true);
                    try {
                        if (rootsChangeInProgress) {
                            changeRoots.run();
                        } else {
                            ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(changeRoots, RootsChangeRescanningInfo.TOTAL_RESCAN);
                        }
                    }
                    finally {
                        myRootsChangeInProgress.set(rootsChangeInProgress);
                    }
                });
                if (afterCallback != null) {
                    afterCallback.run();
                }
            }
        };
        TrackingUtil.trackActivity((Project)project, (ActivityKey)GoActivityKey.INSTANCE, () -> {
            if (runSynchronouslyInHeadlessMode) {
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), (Runnable)runnable);
            } else {
                application.invokeLater(runnable);
            }
        });
    }

    public static void updateProjectModel(@NotNull Project project, @NotNull Runnable changeRoots) {
        if (project == null) {
            GoLibrariesUtil.$$$reportNull$$$0(3);
        }
        if (changeRoots == null) {
            GoLibrariesUtil.$$$reportNull$$$0(4);
        }
        if (project.isDisposed()) {
            return;
        }
        ProjectInitializationDiagnosticService.ActivityTracker activityTracker = ProjectInitializationDiagnosticService.registerTracker((Project)project, (String)"GoLibrariesUtil.updateProjectModel");
        LOG.debug("Project model update requested", new Throwable());
        Application application = ApplicationManager.getApplication();
        Runnable runnable = () -> {
            if (project.isDisposed()) {
                activityTracker.activityFinished();
                return;
            }
            try {
                changeRoots.run();
                long time = TimeoutUtil.measureExecutionTime(() -> new VgoWorkspaceModelUpdater(project).update());
                LOG.debug("VgoWorkspaceModelUpdater.update time: ", new Object[]{time});
            }
            finally {
                activityTracker.activityFinished();
            }
        };
        if (application.isUnitTestMode()) {
            runnable.run();
        } else {
            application.executeOnPooledThread(runnable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRoots";
                break;
            }
        }
        objectArray2[1] = "com/goide/GoLibrariesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateLibraries";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProjectModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

