/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.parallelStacks.threads;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.parallelStacks.base.view.FullRowContentProvider;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\u0013\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/threads/FrameInfo;", "", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "stack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "threadId", "", "isTopFrame", "", "FrameInfo", "(Lcom/intellij/xdebugger/frame/XStackFrame;Lcom/intellij/xdebugger/frame/XExecutionStack;JZ)V", "getFrame", "()Lcom/intellij/xdebugger/frame/XStackFrame;", "getStack", "()Lcom/intellij/xdebugger/frame/XExecutionStack;", "getThreadId", "()J", "()Z", "setTopFrame", "(Z)V", "customizePresentation", "Lcom/intellij/xdebugger/impl/parallelStacks/base/view/FullRowContentProvider;", "container", "Lcom/intellij/ui/ColoredTextContainer;", "maxCharsNonCropped", "", "getIcon", "Ljavax/swing/Icon;", "isActiveThread", "getPriorityWeight", "", "hashCode", "equals", "other", "Companion", "intellij.platform.debugger.parallelStacks"})
public class FrameInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XStackFrame frame;
    @NotNull
    private final XExecutionStack stack;
    private final long threadId;
    private boolean isTopFrame;
    @NotNull
    private static final JBColor COMMON_TEXT_COLOR = new JBColor(0x323232, 0xC4C4C4);
    @NotNull
    private static final JBColor SYSTEM_TEXT_COLOR = new JBColor(10321059, 8610698);

    public FrameInfo(@NotNull XStackFrame frame, @NotNull XExecutionStack stack, long threadId, boolean isTopFrame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.frame = frame;
        this.stack = stack;
        this.threadId = threadId;
        this.isTopFrame = isTopFrame;
    }

    @NotNull
    public final XStackFrame getFrame() {
        return this.frame;
    }

    @NotNull
    public final XExecutionStack getStack() {
        return this.stack;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public final boolean isTopFrame() {
        return this.isTopFrame;
    }

    public final void setTopFrame(boolean bl2) {
        this.isTopFrame = bl2;
    }

    @Nullable
    public FullRowContentProvider customizePresentation(@NotNull ColoredTextContainer container2, int maxCharsNonCropped) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        this.frame.customizePresentation(container2);
        return null;
    }

    @Nullable
    public Icon getIcon(boolean isActiveThread) {
        if (!this.isTopFrame) {
            return null;
        }
        return isActiveThread ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadGroup;
    }

    public double getPriorityWeight() {
        return 1.0;
    }

    public int hashCode() {
        Object object = this.frame.getEqualityObject();
        return object != null ? object.hashCode() : 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.parallelStacks.threads.FrameInfo");
        FrameInfo cfr_ignored_0 = (FrameInfo)other;
        return Objects.equals(this.frame.getEqualityObject(), ((FrameInfo)other).frame.getEqualityObject());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/xdebugger/impl/parallelStacks/threads/FrameInfo$Companion;", "", "FrameInfo$Companion", "()V", "COMMON_TEXT_COLOR", "Lcom/intellij/ui/JBColor;", "getCOMMON_TEXT_COLOR", "()Lcom/intellij/ui/JBColor;", "SYSTEM_TEXT_COLOR", "getSYSTEM_TEXT_COLOR", "intellij.platform.debugger.parallelStacks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JBColor getCOMMON_TEXT_COLOR() {
            return COMMON_TEXT_COLOR;
        }

        @NotNull
        public final JBColor getSYSTEM_TEXT_COLOR() {
            return SYSTEM_TEXT_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

