/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.backend.split.dialects;

import com.intellij.lang.Language;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.SqlDialectDocumentExtension;
import com.jetbrains.rdserver.document.BackendProjectAwareDocumentExtensionsProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/backend/split/dialects/SqlDialectsDocumentExtensionsProvider;", "Lcom/jetbrains/rdserver/document/BackendProjectAwareDocumentExtensionsProvider;", "<init>", "()V", "getExtensions", "", "Lcom/jetbrains/rd/ide/model/DocumentExtension;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.database.backend.split"})
public final class SqlDialectsDocumentExtensionsProvider
implements BackendProjectAwareDocumentExtensionsProvider {
    @NotNull
    public List<DocumentExtension> getExtensions(@NotNull ClientAppSession session, @NotNull Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile file = virtualFile;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file.getName());
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        if (!Intrinsics.areEqual((Object)fileType2, (Object)SqlFileType.INSTANCE)) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2.getLanguage();
        SqlLanguageDialect sqlLanguageDialect = language instanceof SqlLanguageDialect ? (SqlLanguageDialect)language : null;
        if (sqlLanguageDialect == null) {
            return CollectionsKt.emptyList();
        }
        SqlLanguageDialect dialect = sqlLanguageDialect;
        String string = dialect.getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return CollectionsKt.listOf((Object)new SqlDialectDocumentExtension(string));
    }
}

