#!/bin/bash

set_output()
{
	if [ -z $ERROROUTPUT ] || [ "m$ERROROUTPUT" = "m" ] ; then
		if [ -z $CONSOLEOUTPUT ] ; then
			CNT=1
			while [ -f /tmp/sm$SHORTVERSION.$CNT.log ] ; do
				let CNT+=1
			done
			ERROROUTPUT=/tmp/sm$SHORTVERSION.$CNT.log
			touch $ERROROUTPUT
			chmod 666 $ERROROUTPUT
		else
			echo "Output enabled"
			ERROROUTPUT=`tty`
		fi
	fi

#lh 26.06.2020 FS#45762 no mode display information vv
#	NOTSEND=`which notify-send 2>/dev/null`
#	XMSG=`which xmessage 2>/dev/null`
#	echo "NOTSEND is -$NOTSEND-" >> $ERROROUTPUT
#	echo "XMSG is -$XMSG-" >> $ERROROUTPUT
#lh 26.06.2020 FS#45762 no mode display information ^^

	echo "env: " >> $ERROROUTPUT
	printenv|sort >> $ERROROUTPUT
	echo "----------------" >> $ERROROUTPUT
	if [ "m$DISPLAY" = "m" ] ; then
		DISPLAY=":0"
		export DISPLAY 
		echo "DISPLAY set to $DISPLAY" >> $ERROROUTPUT
		echo "----------------" >> $ERROROUTPUT
	fi
}

display_information()
{
	TEXT=$1
	echo "$TEXT"

#lh 26.06.2020 FS#45762 no mode display information vv
#	if [ "m$NOTSEND" != "m" ] ; then
#		notify-send "SoftMaker Office installation" "$TEXT" -t 2000 &
#	else
#		if [ "m$XMSG" != "m" ] ; then
#			xmessage -timeout 2 "$TEXT" &
#		fi
#	fi
#lh 26.06.2020 FS#45762 no mode display information ^^
}

copy_icons()
{   
	VERSION=$1
	if [ $VERSION = "free" ] ; then
		SHORTVERSION="free"
	else
		if [ $VERSION = "nx" ] ; then
			SHORTVERSION=nx
		else
			SHORTVERSION=$(($VERSION-2000))
		fi
	fi
	SCRIPT=1
	if [ -z $2 ] ; then
		SCRIPT=0
	else
		if [ $2 = "0" ] ; then
			SCRIPT=0
		fi
	fi

	echo Theme dir is $THEMEDIR
	
	
	if [ $SCRIPT -eq 1 ] ; then
#       if global folders for icons exist, create local folders for non-root users
		ICONDIR=/usr/share/icons
		if [ "$LOCALINSTALL" = "1" ] ; then
			ICONDIR=~/.local/share/icons
		fi
		
#		if [ "$LOCALINSTALL" = "1" -a -d "$ICONDIR/$THEME" ] ; then
			mkdir -p "$THEMEDIR/48x48/mimetypes"
			mkdir -p "$THEMEDIR/32x32/mimetypes"
			mkdir -p "$THEMEDIR/16x16/mimetypes"
#		fi
		
		echo Icon dir is $ICONDIR
	fi  

	set_output

	if [ -d "$THEMEDIR" ] ; then        
    	if [ $SCRIPT -eq 1 ] ; then

			if [ "$LOCALINSTALL" = "1" ] ; then
				XDG_MODE=" user "
				
			else
				XDG_MODE=" system "
			fi
		else
			XDG_MODE=" system "
		fi

		if [ $VERSION = "free" ] ; then
			for SIZE in 16 24 32 48 64 72 128 256 512 1024 ; do
				for APP in prl tml pml ; do
					echo sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $SIZE --theme $THEME --context apps $SRCPATH/icons/"$APP"_"$SIZE".png application-x-"$APP""24free" >>$ERROROUTPUT 
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $SIZE --theme $THEME --context apps $SRCPATH/icons/"$APP"_"$SIZE".png application-x-"$APP""24free" >>$ERROROUTPUT 2>&1	
				done
			done		
                else
		if [ $VERSION = "nx" ] ; then
			for SIZE in 16 24 32 48 64 72 128 256 512 1024 ; do
				for APP in prl tml pml ; do
					echo sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $SIZE --theme $THEME --context apps $SRCPATH/icons/"$APP"_"$SIZE""nx".png application-x-"$APP""nx" >>$ERROROUTPUT 
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $SIZE --theme $THEME --context apps $SRCPATH/icons/"$APP"_"$SIZE""nx".png application-x-"$APP""nx" >>$ERROROUTPUT 2>&1	
				done
			done		
                else
			for SIZE in 16 24 32 48 64 72 128 256 512 1024 ; do
				for APP in prl tml pml ; do
					echo sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $SIZE --theme $THEME --context apps $SRCPATH/icons/"$APP"_"$SIZE".png application-x-"$APP""24" >>$ERROROUTPUT 
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $SIZE --theme $THEME --context apps $SRCPATH/icons/"$APP"_"$SIZE".png application-x-"$APP""24" >>$ERROROUTPUT 2>&1	
				done
			done		
		fi
		fi


		echo "LOOP start"  >>$ERROROUTPUT
		
		cd /usr/share/icons
		# ALLTHEMES=`echo *`
		#lh 12.10.2017 FS#37057
		ALLTHEMES=`find * | grep 'msword\|excel\|powerpoint\|hicolor' |grep -v excellent| xargs dirname | xargs dirname | xargs dirname | grep -v '\.' | sort | uniq`

		cd $SRCPATH/icons/

		ICONCACHECMD=`which update-icon-caches 2>/dev/null` 
#lh 20.07.2020 FS#45876 two loops instead of one.
		echo "" > $REMOVEICONSSCRIPT.1
		ALLMIMES="application-x-tmd\|application-x-tmv"
		for VAR in application-rtf text-rtf application-msword application-msword-template application-vnd.ms-word application-x-doc application-x-pocket-word application-vnd.openxmlformats-officedocument.wordprocessingml.document application-vnd.openxmlformats-officedocument.wordprocessingml.template application-vnd.ms-word.document.macroenabled.12 application-vnd.ms-word.template.macroenabled.12 ; do
			ALLMIMES="$ALLMIMES\|$VAR"
		done
		for VAR in application-x-pocket-word application-vnd.oasis.opendocument.text text-rtf application-vnd.sun.xml.writer application-vnd.sun.xml.writer.template application-vnd.wordperfect application-vnd.oasis.opendocument.text-template application-vnd.oasis.opendocument.text application-vnd.sun.xml.writer application-vnd.sun.xml.writer.template application-x-dbf ; do
			ALLMIMES="$ALLMIMES\|$VAR"
		done
		for VAR in application-x-pmd application-x-pmv application-x-pmdx application/x-pagemaker ; do
			ALLMIMES="$ALLMIMES\|$VAR"
		done
		for VAR in application-x-sylk application-excel application-x-excel application-x-ms-excel application-x-msexcel application-x-xls application-xls application-vnd.ms-excel application-vnd.openxmlformats-officedocument.spreadsheetml.sheet application-vnd.openxmlformats-officedocument.spreadsheetml.template application-vnd.ms-excel.sheet.macroenabled.12 application-vnd.ms-excel.template.macroenabled.12 text-spreadsheet ; do
			ALLMIMES="$ALLMIMES\|$VAR"
		done
		for VAR in text-csv application-x-dif application-x-prn application-vnd.stardivision.calc ; do
			ALLMIMES="$ALLMIMES\|$VAR"
		done
		for VAR in application-x-prd application-x-prs application-x-prv ; do
			ALLMIMES="$ALLMIMES\|$VAR"
		done
		for VAR in application-ppt application-mspowerpoint application-vnd.ms-powerpoint application-vnd.ms-powerpoint.presentation.macroenabled.12 application-vnd.ms-powerpoint.slideshow.macroEnabled.12 application-vnd.openxmlformats-officedocument.presentationml.presentation application-vnd.openxmlformats-officedocument.presentationml.template application-vnd.openxmlformats-officedocument.presentationml.slideshow ; do
			ALLMIMES="$ALLMIMES\|$VAR"
		done
		ALLMIMES="$ALLMIMES\|x-office-document\|x-office-spreadsheet\|wordprocessing"

		for THEME in $ALLTHEMES ; do
			echo "Updating theme $THEME /1 of 2/"
			echo "Updating theme $THEME /1 of 2/">>$ERROROUTPUT 
			echo "echo Removing icons from theme $THEME /2 of 2/" >> $REMOVEICONSSCRIPT.1
			
			for ICON in 16 32 48 64 128 ; do
				for VAR in application-x-tmd application-x-tmv ; do
					sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
				done
				for VAR in application-rtf text-rtf application-msword application-msword-template application-vnd.ms-word application-x-doc application-x-pocket-word application-vnd.openxmlformats-officedocument.wordprocessingml.document application-vnd.openxmlformats-officedocument.wordprocessingml.template application-vnd.ms-word.document.macroenabled.12 application-vnd.ms-word.template.macroenabled.12 application-vnd.oasis.opendocument.text application-vnd.oasis.opendocument.text-template application-vnd.sun.xml.writer application-vnd.sun.xml.writer.template ; do
					sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
				done
				for VAR in application-x-pmd application-x-pmv application-x-pmdx ; do
					sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
				done
				for VAR in application-x-sylk application-excel application-x-excel application-x-ms-excel application-x-msexcel application-x-xls application-xls application-vnd.ms-excel application-vnd.openxmlformats-officedocument.spreadsheetml.sheet application-vnd.openxmlformats-officedocument.spreadsheetml.template application-vnd.ms-excel.sheet.macroenabled.12 application-vnd.ms-excel.template.macroenabled.12 ; do
					sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
				done
				for VAR in application-x-prd application-x-prs application-x-prv ; do
					sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
				done
				for VAR in application-ppt application-mspowerpoint application-vnd.ms-powerpoint application-vnd.ms-powerpoint.presentation.macroenabled.12 application-vnd.ms-powerpoint.slideshow.macroEnabled.12 application-vnd.openxmlformats-officedocument.presentationml.presentation application-vnd.openxmlformats-officedocument.presentationml.template application-vnd.openxmlformats-officedocument.presentationml.slideshow ; do
					sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
				done
			done
		done	

		for THEME in $ALLTHEMES ; do
				echo "Updating theme $THEME /2 of 2/"
				echo "Updating theme $THEME /2 of 2/">>$ERROROUTPUT 
				echo "echo Removing icons from theme $THEME /1 of 2/" >> $REMOVEICONSSCRIPT

				for ICON in 48 16 32 64 128 ; do
					for VAR in application-x-tmd application-x-tmv ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/tmd_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done
					for VAR in application-rtf text-rtf application-msword application-msword-template application-vnd.ms-word application-x-doc application-x-pocket-word application-vnd.openxmlformats-officedocument.wordprocessingml.document application-vnd.openxmlformats-officedocument.wordprocessingml.template application-vnd.ms-word.document.macroenabled.12 application-vnd.ms-word.template.macroenabled.12 ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR" >> $REMOVEICONSSCRIPT
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/tmd_mso_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done
					for VAR in application-x-pocket-word application-vnd.oasis.opendocument.text text-rtf application-vnd.sun.xml.writer application-vnd.sun.xml.writer.template application-vnd.wordperfect application-vnd.oasis.opendocument.text-template application-vnd.oasis.opendocument.text application-vnd.sun.xml.writer application-vnd.sun.xml.writer.template application-x-dbf ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR" >> $REMOVEICONSSCRIPT
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/tmd_oth_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done
					for VAR in application-x-pmd application-x-pmv application-x-pmdx application/x-pagemaker ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/pmd_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done
					for VAR in application-x-sylk application-excel application-x-excel application-x-ms-excel application-x-msexcel application-x-xls application-xls application-vnd.ms-excel application-vnd.openxmlformats-officedocument.spreadsheetml.sheet application-vnd.openxmlformats-officedocument.spreadsheetml.template application-vnd.ms-excel.sheet.macroenabled.12 application-vnd.ms-excel.template.macroenabled.12 text-spreadsheet ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR" >> $REMOVEICONSSCRIPT
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/pmd_mso_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done
					for VAR in text-csv application-x-dif application-x-prn application-vnd.stardivision.calc ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR" >> $REMOVEICONSSCRIPT
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/pmd_oth_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done
					for VAR in application-x-prd application-x-prs application-x-prv ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/prd_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done
					for VAR in application-ppt application-mspowerpoint application-vnd.ms-powerpoint application-vnd.ms-powerpoint.presentation.macroenabled.12 application-vnd.ms-powerpoint.slideshow.macroEnabled.12 application-vnd.openxmlformats-officedocument.presentationml.presentation application-vnd.openxmlformats-officedocument.presentationml.template application-vnd.openxmlformats-officedocument.presentationml.slideshow ; do
						sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR >>$ERROROUTPUT 2>&1
						echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $VAR" >> $REMOVEICONSSCRIPT
						sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/prd_mso_$ICON.png $VAR >>$ERROROUTPUT 2>&1
					done

					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/tmd_$ICON.png application-x-tmd >>$ERROROUTPUT 2>&1

					echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes application-x-tmd-mso" >> $REMOVEICONSSCRIPT
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/tmd_mso_$ICON.png application-x-tmd-mso >>$ERROROUTPUT 2>&1
						
					echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes application-x-tmd-oth" >> $REMOVEICONSSCRIPT
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/tmd_oth_$ICON.png application-x-tmd-oth >>$ERROROUTPUT 2>&1

					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/pmd_$ICON.png application-x-pmd >>$ERROROUTPUT 2>&1

					echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes application-x-pmd-mso" >> $REMOVEICONSSCRIPT
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/pmd_mso_$ICON.png application-x-pmd-mso >>$ERROROUTPUT 2>&1

					echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes application-x-pmd-oth" >> $REMOVEICONSSCRIPT
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/pmd_oth_$ICON.png application-x-pmd-oth >>$ERROROUTPUT 2>&1

					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/prd_$ICON.png application-x-prd >>$ERROROUTPUT 2>&1

					echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes application-x-prd-mso" >> $REMOVEICONSSCRIPT
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/prd_mso_$ICON.png application-x-prd-mso >>$ERROROUTPUT 2>&1

					echo "sh $XDGPATH/xdg-icon-resource uninstall --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes application-x-prd-oth" >> $REMOVEICONSSCRIPT
					sh $XDGPATH/xdg-icon-resource install --novendor --noupdate --mode $XDG_MODE --size $ICON --theme $THEME --context mimetypes $SRCPATH/icons/prd_oth_$ICON.png application-x-prd-oth >>$ERROROUTPUT 2>&1
				done
				
				sh $XDGPATH/xdg-icon-resource forceupdate --mode $XDG_MODE --theme $THEME >>$ERROROUTPUT 2>&1
				echo "sh $XDGPATH/xdg-icon-resource forceupdate --mode $XDG_MODE --theme $THEME" >> $REMOVEICONSSCRIPT
				if [ "m$ICONCACHECMD" != "m" -a "$LOCALINSTALL" != "1" ] ; then
					update-icon-caches $ICONDIR/$THEME
					echo "update-icon-caches $ICONDIR/$THEME" >> $REMOVEICONSSCRIPT
				fi
		done
		cat $REMOVEICONSSCRIPT.1 >> $REMOVEICONSSCRIPT
		rm $REMOVEICONSSCRIPT.1
	fi
}

modify_defaults()
{
echo "Called with params $1 $2"
	APP=$1
	FILE=$2
	LL=`grep -R "$APP" "$FILE"`
echo GREP is $LL
CC=`cat "$FILE"`
echo CC is $CC
	for LINE in `cat "$FILE"|grep "$APP"` ; do
		LINE1=`echo $LINE|cut -d "=" -f 1`
		LINE2=`echo $LINE|cut -d "=" -f 2`
		LINE3=`echo $LINE2|sed 's/;/ /'`
echo $LINE1 $LINE2 -- $LINE3
		LINE4="$APP"
		for i in $LINE3; do
			if [ "$i" != "$APP" ] ; then
				LINE4="$LINE4;$i"
			fi
		done
echo "Changing $LINE1 -- $LINE4"
echo "Changing $LINE1 -- $LINE4" >>$ERROROUTPUT 2>&1
		sed -i "s:$LINE:$LINE1=$LINE4:g" $FILE
	done
}

create_mime()
{
	VERSION=$1
	SHORTVERSION=$(($VERSION-2000))
	SCRIPT=1
	if [ -z $2 ] ; then
		SCRIPT=0
	else
		if [ $2 = "0" ] ; then
			SCRIPT=0
		fi
	fi

	echo "Create MIME"
	display_information "Adding document icons. This may take a few minutes..."
	#echo "Adding document icons..."
	echo "echo Removing document icons..."  >> $REMOVEICONSSCRIPT
	
    THEMEDIR="$DATADIR/icons/hicolor"             
    THEME="hicolor"

# lh 29.08.2024 FS#54158 
    if [ "$ICONS" = "1"  ] ; then
        copy_icons $VERSION $SCRIPT
    fi
    
    display_information "Registering MIME types..."
	#echo "Registering MIME types..."
	if [ $SCRIPT -eq 1 ] ; then
		if [ "$LOCALINSTALL" = "1" ] ; then
			XDG_MODE=" --mode user "
		else
			XDG_MODE=" --mode system "

			display_information "Creating /etc/SoftMaker folder..."
			mkdir -p /etc/SoftMaker
			chmod 777 /etc/SoftMaker
		fi
	else
		XDG_MODE=" --mode system "

		display_information "Creating /etc/SoftMaker folder..."
		mkdir -p /etc/SoftMaker
		chmod 777 /etc/SoftMaker
	fi

	set_output

	if [ $VERSION = "free" ] ; then
		sh $XDGPATH/xdg-mime install $XDG_MODE --novendor $SRCPATH/mime/softmaker-freeoffice24.xml  
	else
		if [ $VERSION = "nx" ] ; then
			sh $XDGPATH/xdg-mime install $XDG_MODE --novendor $SRCPATH/mime/softmaker-office-nx.xml  
		else
			sh $XDGPATH/xdg-mime install $XDG_MODE --novendor $SRCPATH/mime/softmaker-office-2024.xml  
		fi
	fi


	ISKDE=`ps -ef | grep kde | wc -l`
	echo "mkdir -p ~/.local/share/applications/" > /tmp/mime.sh

	if [ $VERSION = "free" ] ; then
		echo "sh $XDGPATH/xdg-mime install --mode user --novendor $SRCPATH/mime/softmaker-freeoffice24.xml  " >> /tmp/mime.sh
	else
		if [ $VERSION = "nx" ] ; then
			echo "sh $XDGPATH/xdg-mime install --mode user --novendor $SRCPATH/mime/softmaker-office-nx.xml  " >> /tmp/mime.sh
		else
			echo "sh $XDGPATH/xdg-mime install --mode user --novendor $SRCPATH/mime/softmaker-office-2024.xml  " >> /tmp/mime.sh
		fi
	fi

	if [ $VERSION = "free" ] ; then
		TMDESKTOPNAME=textmaker-$VERSION"24".desktop
		PMDESKTOPNAME=planmaker-$VERSION"24".desktop
		PRDESKTOPNAME=presentations-$VERSION"24".desktop
	else
		if [ $VERSION = "nx" ] ; then
			SHORTVERSION="nx"
		else
			SHORTVERSION=$(($VERSION-2000))
		fi
		TMDESKTOPNAME=textmaker-$SHORTVERSION.desktop
		PMDESKTOPNAME=planmaker-$SHORTVERSION.desktop
		PRDESKTOPNAME=presentations-$SHORTVERSION.desktop
	fi

# lh 29.08.2024 FS#54158 vvvv
#	echo "$XDGPATH/xdg-mime default $TMDESKTOPNAME application/x-tmd application/x-tmv application/msword application/vnd.ms-word application/x-doc text/rtf application/rtf application/vnd.oasis.opendocument.text application/vnd.oasis.opendocument.text-template application/vnd.stardivision.writer application/vnd.sun.xml.writer application/vnd.sun.xml.writer.template application/vnd.openxmlformats-officedocument.wordprocessingml.document application/vnd.ms-word.document.macroenabled.12 application/vnd.ms-word.document.macroEnabled.12 application/vnd.openxmlformats-officedocument.wordprocessingml.template application/vnd.ms-word.template.macroenabled.12 application/vnd.ms-word.template.macroEnabled.12 application/x-pocket-word application/vnd.wordperfect application/x-dbf " >> /tmp/mime.sh
#	echo "$XDGPATH/xdg-mime default $PMDESKTOPNAME application/x-pmd application/x-pmdx application/x-pmv application/excel application/x-excel application/x-ms-excel application/x-msexcel application/x-sylk application/x-xls application/xls application/vnd.ms-excel application/vnd.stardivision.calc application/vnd.openxmlformats-officedocument.spreadsheetml.sheet application/vnd.openxmlformats-officedocument.spreadsheetml.template application/vnd.ms-excel.sheet.macroenabled.12 application/vnd.ms-excel.sheet.macroEnabled.12 application/vnd.openxmlformats-officedocument.spreadsheetml.template application/vnd.ms-excel.template.macroenabled.12 application/vnd.ms-excel.template.macroEnabled.12 text/csv application/x-dif application/x-prn text/spreadsheet application/vnd.oasis.opendocument.spreadsheet application/vnd.oasis.opendocument.spreadsheet-template" >> /tmp/mime.sh
#	echo "$XDGPATH/xdg-mime default $PRDESKTOPNAME application/x-prd application/x-prv application/x-prs application/ppt application/mspowerpoint application/vnd.ms-powerpoint application/vnd.openxmlformats-officedocument.presentationml.presentation application/vnd.ms-powerpoint.presentation.macroenabled.12 application/vnd.ms-powerpoint.presentation.macroEnabled.12 application/vnd.openxmlformats-officedocument.presentationml.template application/vnd.ms-powerpoint.template.macroenabled.12 application/vnd.ms-powerpoint.template.macroEnabled.12 application/vnd.ms-powerpoint.slideshow.macroenabled.12 application/vnd.ms-powerpoint.slideshow.macroEnabled.12 application/vnd.openxmlformats-officedocument.presentationml.slideshow " >> /tmp/mime.sh		

	echo "$XDGPATH/xdg-mime default $TMDESKTOPNAME application/x-tmd application/x-tmdx application/x-tmv " >> /tmp/mime.sh
	echo "$XDGPATH/xdg-mime default $PMDESKTOPNAME application/x-pmd application/x-pmdx application/x-pmv" >> /tmp/mime.sh
	echo "$XDGPATH/xdg-mime default $PRDESKTOPNAME application/x-prd application/x-prdx application/x-prv application/x-prs application/x-prsx" >> /tmp/mime.sh		

	if [ $MSASSOC -eq 1 ] ; then
		echo "$XDGPATH/xdg-mime default $TMDESKTOPNAME application/msword application/vnd.ms-word.document.macroenabled.12 application/vnd.ms-word application/vnd.ms-word.template.macroenabled.12 application/msword-template application/vnd.openxmlformats-officedocument.wordprocessingml.document application/vnd.openxmlformats-officedocument.wordprocessingml.template application/x-doc " >> /tmp/mime.sh
		echo "$XDGPATH/xdg-mime default $PMDESKTOPNAME application/vnd.ms-excel application/vnd.ms-excel.sheet.macroenabled.12 application/vnd.ms-excel.sheet.binary.macroenabled.12 application/vnd.ms-excel.template.macroenabled.12 application/vnd.openxmlformats-officedocument.spreadsheetml.sheet application/vnd.openxmlformats-officedocument.spreadsheetml.template text/spreadsheet application/x-sylk application/excel application/x-excel application/x-ms-excel application/x-msexcel application/x-xls application/xls " >> /tmp/mime.sh
		echo "$XDGPATH/xdg-mime default $PRDESKTOPNAME application/vnd.ms-powerpoint application/vnd.ms-powerpoint.presentation.macroenabled.12 application/vnd.ms-powerpoint.template.macroenabled.12 application/vnd.openxmlformats-officedocument.presentationml.slideshow application/vnd.ms-powerpoint.slideshow.macroenabled.12 application/vnd.openxmlformats-officedocument.presentationml.presentation application/vnd.openxmlformats-officedocument.presentationml.template application/ppt application/mspowerpoint " >> /tmp/mime.sh		
	fi
	
	if [ $OOASSOC -eq 1 ] ; then
		echo "$XDGPATH/xdg-mime default $TMDESKTOPNAME application/vnd.oasis.opendocument.text-template application/vnd.oasis.opendocument.text application/vnd.sun.xml.writer application/vnd.sun.xml.writer.template application/vnd.stardivision.writer " >> /tmp/mime.sh
		echo "$XDGPATH/xdg-mime default $PMDESKTOPNAME application/vnd.stardivision.calc " >> /tmp/mime.sh
	fi

	if [ $OTHASSOC -eq 1 ] ; then
		echo "$XDGPATH/xdg-mime default $TMDESKTOPNAME application/x-pocket-word text/rtf application/rtf application/x-dbf application/vnd.wordperfect" >> /tmp/mime.sh
		echo "$XDGPATH/xdg-mime default $PMDESKTOPNAME text/csv application/x-dif application/x-prn " >> /tmp/mime.sh
	fi
# lh 29.08.2024 FS#54158 ^^^^

#	if [ $ISKDE -gt 5 ] ; then
	if [ "$LOCALINSTALL" != "1" ] ; then
		echo "perl $SRCPATH/mime/def.pl ~/.local/share/applications/mimeapps.list $TMDESKTOPNAME $PMDESKTOPNAME $PRDESKTOPNAME"  >> /tmp/mime.sh
		echo "perl $SRCPATH/mime/def.pl ~/.config/mimeapps.list $TMDESKTOPNAME $PMDESKTOPNAME $PRDESKTOPNAME"  >> /tmp/mime.sh
	fi
	echo "rm ~/.local/share/mime/application/vnd.ms-word.template.macroenabled.12.xml" >> /tmp/mime.sh
	echo "rm ~/.local/share/mime/application/vnd.ms-excel.template.macroenabled.12.xml" >> /tmp/mime.sh
	
	echo "mime.sh:" >>$ERROROUTPUT 2>&1
	cat /tmp/mime.sh >>$ERROROUTPUT 2>&1
	echo "---" >>$ERROROUTPUT 2>&1

	if [ "$LOCALINSTALL" != "1" ] ; then
		for INSTUSERNAME in `awk -F: '$NF ~ /sh$/' /etc/passwd | sort | cut -f 1 -d':'` ; do
			if [ -f "$XDGPATH/xdg-user-dir" ] ; then
				DesktopDir=`su $INSTUSERNAME -c "/bin/sh $XDGPATH/xdg-user-dir DESKTOP" 2>/dev/null` 2>/dev/null
			else
				DesktopDir=`grep "$INSTUSERNAME:" /etc/passwd | cut -f 6 -d":"`
				DesktopDir="$DesktopDir/Desktop"
			fi
			if [ -d "$DesktopDir" ] ; then
				echo "Installing for user $INSTUSERNAME"
 
				# lh 22.11.2023 FS#57849
				SUCMD="su $INSTUSERNAME -c"
				#SUCMD="runuser -u $INSTUSERNAME"
				#INSTUID=`grep $INSTUSERNAME /etc/passwd|cut -f 3 -d:`
				#INSTGID=`grep $INSTUSERNAME /etc/passwd|cut -f 4 -d:`
				#SUCMD="setpriv --reuid=$INSTUID --regid=$INSTGID --init-groups"
				echo $SUCMD "sh /tmp/mime.sh" >>$ERROROUTPUT 2>&1
				$SUCMD "sh /tmp/mime.sh" >>$ERROROUTPUT 2>&1			
				
			fi
		done
		# fix for kde bug https://bugs.kde.org/show_bug.cgi?id=343468
		sed -i 's:macroEnabled:macroenabled:g' /usr/share/mime/subclasses			
	else
		#sh /tmp/icons.sh
		sh /tmp/mime.sh
	fi
	
	TMPCMD=`which update-mime-database 2>/dev/null` 
	if [ ! "$TMPCMD" = ""  ] ; then
		update-mime-database /usr/share/mime >/dev/null 2>&1
	fi

#	if [ $ISKDE -gt 5 ] ; then
	if [ "$LOCALINSTALL" != "1" ] ; then
		DEFAULTFILE="/usr/share/applications/defaults.list"
		if [ -f "$DEFAULTFILE" ] ; then
			cp $DEFAULTFILE /tmp/defaults.old.txt
			for i in application/x-tmd application/x-tmv application/msword application/vnd.ms-word application/x-doc text/rtf application/rtf application/vnd.oasis.opendocument.text application/vnd.oasis.opendocument.text-template application/vnd.stardivision.writer application/vnd.sun.xml.writer application/vnd.sun.xml.writer.template application/vnd.openxmlformats-officedocument.wordprocessingml.document application/vnd.ms-word.document.macroenabled.12 application/vnd.ms-word.document.macroEnabled.12 application/vnd.openxmlformats-officedocument.wordprocessingml.template application/vnd.ms-word.template.macroenabled.12 application/vnd.ms-word.template.macroEnabled.12 application/x-pocket-word application/vnd.wordperfect application/x-dbf ; do
				LINE=`grep "$i=" $DEFAULTFILE`
				if [ "M$LINE" != "M" ] ; then
							LINE1=`echo $LINE|cut -d "=" -f 1`
							LINE2=`echo $LINE|cut -d "=" -f 2`
	echo "Changing $LINE1 -- $LINE2" >>$ERROROUTPUT 2>&1
							sed -i "s:$LINE:$LINE1=$TMDESKTOPNAME;$LINE2:g" $DEFAULTFILE
			
				fi
			done
			for i in application/x-pmd application/x-pmdx application/x-pmv application/excel application/x-excel application/x-ms-excel application/x-msexcel application/x-sylk application/x-xls application/xls application/vnd.ms-excel application/vnd.stardivision.calc application/vnd.openxmlformats-officedocument.spreadsheetml.sheet application/vnd.openxmlformats-officedocument.spreadsheetml.template application/vnd.ms-excel.sheet.macroenabled.12 application/vnd.ms-excel.sheet.macroEnabled.12 application/vnd.openxmlformats-officedocument.spreadsheetml.template application/vnd.ms-excel.template.macroenabled.12 application/vnd.ms-excel.template.macroEnabled.12 text/csv application/x-dif application/x-prn text/spreadsheet application/vnd.oasis.opendocument.spreadsheet application/vnd.oasis.opendocument.spreadsheet-template ; do
				LINE=`grep "$i=" $DEFAULTFILE`
				if [ "M$LINE" != "M" ] ; then
							LINE1=`echo $LINE|cut -d "=" -f 1`
							LINE2=`echo $LINE|cut -d "=" -f 2`
	echo "Changing $LINE1 -- $LINE2" >>$ERROROUTPUT 2>&1
							sed -i "s:$LINE:$LINE1=$PMDESKTOPNAME;$LINE2:g" $DEFAULTFILE
			
				fi
			done
			for i in application/x-prd application/x-prv application/x-prs application/ppt application/mspowerpoint application/vnd.ms-powerpoint application/vnd.openxmlformats-officedocument.presentationml.presentation application/vnd.ms-powerpoint.presentation.macroenabled.12 application/vnd.ms-powerpoint.presentation.macroEnabled.12 application/vnd.openxmlformats-officedocument.presentationml.template application/vnd.ms-powerpoint.template.macroenabled.12 application/vnd.ms-powerpoint.template.macroEnabled.12 application/vnd.ms-powerpoint.slideshow.macroenabled.12 application/vnd.ms-powerpoint.slideshow.macroEnabled.12 application/vnd.openxmlformats-officedocument.presentationml.slideshow ; do
				LINE=`grep "$i=" $DEFAULTFILE`
				if [ "M$LINE" != "M" ] ; then
							LINE1=`echo $LINE|cut -d "=" -f 1`
							LINE2=`echo $LINE|cut -d "=" -f 2`
	echo "Changing $LINE1 -- $LINE2" >>$ERROROUTPUT 2>&1
							sed -i "s:$LINE:$LINE1=$PRDESKTOPNAME;$LINE2:g" $DEFAULTFILE
			
				fi
			done
			cp $DEFAULTFILE /tmp/defaults.new.txt
		else 
			echo "No default apps file"
			echo "No default apps file" >>$ERROROUTPUT 2>&1
		fi
		
		#remove the KDE cache if exists
		for i in `echo /var/tmp/kdecache-*` ; do
			echo "Cleaning the cache from folder: $i/*" >>$ERROROUTPUT 2>&1
			echo "Cleaning the cache from folder: $i/*" 
			rm -rf $i/*
			echo "rm -rf $i/*" >> $REMOVEICONSSCRIPT
		done
	fi
	
	echo "Icons forceupdate start"  >>$ERROROUTPUT
	sh $XDGPATH/xdg-icon-resource forceupdate --novendor $XDG_MODE >>$ERROROUTPUT 2>&1

	rm -f /tmp/mime.sh

 	echo echo sleep 1 '>' /tmp/remove_icons_tmp.sh >> $REMOVEICONSSCRIPT
	echo echo rm '$'0 '>>' /tmp/remove_icons_tmp.sh >> $REMOVEICONSSCRIPT
	echo /bin/sh /tmp/remove_icons_tmp.sh '&' >> $REMOVEICONSSCRIPT
}  

# main part
LOCALINSTALL=1
DATADIR=/usr/share
APPPATH=$DATADIR/freeoffice2024

MSASSOC=$1
OOASSOC=$2
OTHASSOC=$3
ICONS=$4

APPBINPATH="/usr/bin"
SRCPATH=$APPPATH
TMPCMD=`which xdg-mime 2>/dev/null` 
if [ "$TMPCMD" = "" ] 
then
	echo "Using xdg-utils supplied by this package"
	XDGPATH=$SRCPATH/mime/xdg-utils
else
	echo "Using existing xdg-utils"
	XDGPATH=`dirname $TMPCMD`
fi

REMOVEICONSSCRIPT=~/SoftMaker/Settings/remove_icons.sh

if [ $ICONS -gt 0 ] ; then 
	if [ -f $REMOVEICONSSCRIPT ] ; then
		echo Remove icons script found: "$REMOVEICONSSCRIPT". Executing...
		$REMOVEICONSSCRIPT
	fi

	echo '#!/bin/sh' >$REMOVEICONSSCRIPT
	chmod 755 $REMOVEICONSSCRIPT
fi


create_mime free "1"

TMPCMD=`which update-mime-database 2>/dev/null` 
if [ ! "$TMPCMD" = ""  ] ; then
	update-mime-database /usr/share/mime >/dev/null 2>&1
fi

TMPCMD=`which update-desktop-database 2>/dev/null` 
if [ ! "$TMPCMD" = ""  ] ; then
	update-desktop-database /usr/share/applications >/dev/null 2>&1
	update-desktop-database /usr/share/mimelnk/application >/dev/null 2>&1
fi

TMPCMD=`which gtk-update-icon-cache 2>/dev/null` 
if [ ! "$TMPCMD" = ""  ] ; then
  touch --no-create $ICONDIR/hicolor
  gtk-update-icon-cache --ignore-theme-index $ICONDIR/hicolor >/dev/null 2>&1
fi

if [ "$LOCALINSTALL" != "1" ] ; then
	rm -f /usr/share/freeoffice2024/mime/uninst1
	rm -f /usr/share/freeoffice2024/mime/uninst2
fi

display_information "Done."

