<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'сохранено в ":timezone"',
    'displayed_in_tz'                           => 'отображено в ":timezone"',
    'close'                                     => 'Закрыть',
    'actions'                                   => 'Действия',
    'edit'                                      => 'Изменить',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'ID журнала операций',
    'delete'                                    => 'Удалить',
    'split'                                     => 'Разделить',
    'single_split'                              => 'Разделённая транзакция',
    'clone'                                     => 'Клонировать',
    'clone_and_edit'                            => 'Клонировать и редактировать',
    'confirm_action'                            => 'Подтвердите действие',
    'last_seven_days'                           => 'Последние 7 дней',
    'last_thirty_days'                          => 'Последние 30 дней',
    'last_180_days'                             => 'Последние 180 дней',
    'month_to_date'                             => 'Месяц до даты',
    'year_to_date'                              => 'Лет до даты',
    'YTD'                                       => 'YTD',
    'welcome_back'                              => 'Что происходит с моими финансами?',
    'main_dashboard_page_title'                 => 'Главная',
    'everything'                                => 'Всё',
    'today'                                     => 'сегодня',
    'customRange'                               => 'Другой интервал',
    'date_range'                                => 'Диапазон дат',
    'apply'                                     => 'Применить',
    'select_date'                               => 'Выбрать дату...',
    'cancel'                                    => 'Отмена',
    'from'                                      => 'От',
    'to'                                        => 'Куда',
    'structure'                                 => 'Структура',
    'help_translating'                          => 'Этот текст справки пока не доступен на русском языке. Но вы <a href="https://crowdin.com/project/firefly-iii-help">можете помочь с переводом.</a>',
    'showEverything'                            => 'Показать всё',
    'never'                                     => 'Никогда',
    'no_results_for_empty_search'               => 'Результатов не найдено.',
    'removed_amount'                            => 'Снято :amount',
    'added_amount'                              => 'Добавлено :amount',
    'asset_account_role_help'                   => 'Вы сможете произвести любые дополнительные настройки позже.',
    'Opening balance'                           => 'Баланс на момент открытия',
    'create_new_stuff'                          => 'Создать новый объект',
    'new_withdrawal'                            => 'Новый расход',
    'create_new_transaction'                    => 'Создать новую транзакцию',
    'sidebar_frontpage_create'                  => 'Создать',
    'new_transaction'                           => 'Новая транзакция',
    'no_rules_for_bill'                         => 'У этой подписки нет правил, связанных с ней.',
    'go_to_asset_accounts'                      => 'Просмотр ваших основных счетов',
    'go_to_budgets'                             => 'Перейти к вашим бюджетам',
    'go_to_withdrawals'                         => 'Перейти к вашим расходам',
    'clones_journal_x'                          => 'Эта транзакция является клоном ":description" (#:id)',
    'go_to_categories'                          => 'Перейти к вашим категориям',
    'go_to_bills'                               => 'Перейти к вашим подпискам',
    'go_to_expense_accounts'                    => 'Перейти к вашим счетам расходов',
    'go_to_revenue_accounts'                    => 'Перейти к вашим счетам доходов',
    'go_to_piggies'                             => 'Перейти к вашим копилкам',
    'new_deposit'                               => 'Новый доход',
    'new_transfer'                              => 'Новый перевод',
    'new_transfers'                             => 'Новый перевод',
    'new_asset_account'                         => 'Новый счет активов',
    'new_expense_account'                       => 'Новый счёт расходов',
    'new_revenue_account'                       => 'Новый счёт доходов',
    'new_liabilities_account'                   => 'Новый долг',
    'new_budget'                                => 'Новый бюджет',
    'new_bill'                                  => 'Новая подписка',
    'block_account_logout'                      => 'Вы вышли из системы. Заблокированные учётные записи не могут использовать этот сайт. Вы зарегистрировались с действующим адресом электронной почты?',
    'flash_success'                             => 'Успешно!',
    'flash_info'                                => 'Сообщение',
    'flash_warning'                             => 'Предупреждение!',
    'flash_error'                               => 'Ошибка!',
    'flash_danger'                              => 'Опасность!',
    'flash_info_multiple'                       => 'Есть одно сообщение|Есть :count сообщений',
    'flash_error_multiple'                      => 'Есть одна ошибка|Есть :count ошибок',
    'net_worth'                                 => 'Мои сбережения',
    'help_for_this_page'                        => 'Справка по этой странице',
    'help_for_this_page_body'                   => 'Вы можете найти подробную информацию об этой странице <a href="https://docs.firefly-iii.org/">в документации</a>.',
    'two_factor_welcome'                        => 'Здравствуйте!',
    'two_factor_enter_code'                     => 'Чтобы продолжить, введите ваш код двухфакторной аутентификации. Ваше приложение может сгенерировать его для вас.',
    'two_factor_code_here'                      => 'Введите код здесь',
    'two_factor_title'                          => 'Двухфакторная аутентификация',
    'authenticate'                              => 'Аутентификация',
    'two_factor_forgot_title'                   => 'Утерян код для двухфакторной аутентификации',
    'two_factor_forgot'                         => 'Я забыл свой ключ для двухфакторной авторизации.',
    'two_factor_lost_header'                    => 'Потеряли вашу двухфакторную аутентификацию?',
    'two_factor_lost_intro'                     => 'Если вы потеряли также и ваши резервные коды, вам не повезло. Эту проблему вы не сможете решить через веб-интерфейс. Теперь у вас есть два варианта.',
    'two_factor_lost_fix_self'                  => 'Если вы запускаете собственный экземпляр Firefly III, прочтите <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working>эту запись в FAQ</a> для получения инструкций.',
    'two_factor_lost_fix_owner'                 => 'Иначе, свяжитесь по email с владельцем сайта <a href="mailto::site_owner">:site_owner</a> и попросите сбросить вашу двухфакторную аутентификацию.',
    'mfa_backup_code'                           => 'Вы использовали резервный код для входа в Firefly III. Его нельзя использовать второй раз, поэтому вычеркните его из своего списка.',
    'pref_two_factor_new_backup_codes'          => 'Получить новые коды резервирования',
    'pref_two_factor_backup_code_count'         => 'У вас есть :count действующих резервных кодов.|У вас есть :count действующих резервных кодов.',
    '2fa_i_have_them'                           => 'Я всё сохранил!',
    'warning_much_data'                         => 'Загрузка данных за :days дней может занять некоторое время.',
    'registered'                                => 'Вы успешно зарегистрированы!',
    'Default asset account'                     => 'Счёт по умолчанию',
    'no_budget_pointer'                         => 'Похоже, у вас пока нет бюджетов. Вы должны создать их на странице <a href="budgets">Бюджеты</a>. Бюджеты могут помочь вам отслеживать расходы.',
    'no_bill_pointer'                           => 'Похоже, у вас пока нет подписки. Вам следует создать ее на странице <a href="subscriptions">подписки</a>. Подписки могут помочь вам отслеживать расходы.',
    'Savings account'                           => 'Сберегательный счет',
    'Credit card'                               => 'Кредитная карта',
    'source_accounts'                           => 'Счёт-источник|Счета-источники',
    'destination_accounts'                      => 'Счёт назначения|Счета назначения',
    'user_id_is'                                => 'Ваш id пользователя <strong>:user</strong>',
    'field_supports_markdown'                   => 'Это поле поддерживает <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Если вам нужна дополнительная помощь по использованию Firefly III, пожалуйста, <a href="https://github.com/firefly-iii/firefly-iii/issues">откройте issue на Github</a> (желательно, на английском языке).',
    'reenable_intro_text'                       => 'Вы также можете повторно включить <a href="#" id="reenableGuidance">обучение для начинающих</a>.',
    'intro_boxes_after_refresh'                 => 'Блоки с подсказками появятся, когда вы обновите страницу.',
    'show_all_no_filter'                        => 'Показать все транзакции без группировки по датам.',
    'expenses_by_category'                      => 'Расходы по категориям',
    'expenses_by_budget'                        => 'Расходы по бюджетам',
    'income_by_category'                        => 'Доход по категориям',
    'expenses_by_asset_account'                 => 'Расходы по основному счёту',
    'expenses_by_expense_account'               => 'Расходы по счету назначения',
    'cannot_redirect_to_account'                => 'Firefly III не может перенаправить вас на правильную страницу. Приносим извинения.',
    'sum_of_expenses'                           => 'Сумма расходов',
    'sum_of_income'                             => 'Сумма дохода',
    'liabilities'                               => 'Долговые счета',
    'spent_in_specific_budget'                  => 'Расходы по бюджету ":budget"',
    'spent_in_specific_double'                  => 'Расходы по счёту ":account"',
    'earned_in_specific_double'                 => 'Доходы по счёту ":account"',
    'source_account'                            => 'Счёт-источник',
    'source_account_reconciliation'             => 'Вы не можете редактировать счёт-источник для сверяемой транзакции.',
    'destination_account'                       => 'Счёт назначения',
    'destination_account_reconciliation'        => 'Вы не можете редактировать счёт назначения для сверяемой транзакции.',
    'sum_of_expenses_in_budget'                 => 'Сумма расходов по бюджету ":budget"',
    'left_in_budget_limit'                      => 'Осталось потратить в соответствии с бюджетом',
    'current_period'                            => 'Текущий период',
    'show_the_current_period_and_overview'      => 'Показать текущий период и обзор',
    'pref_languages_locale'                     => 'Для корректной работы с языками, отличными от английского, ваша операционная система должна отдавать корректную информацию о локали. Если это не так, валюты, даты и суммы могут отображаться некорректно.',
    'budget_in_period'                          => 'Все транзакции для бюджета ":name" между :start и :end в :currency',
    'chart_budget_in_period'                    => 'Диаграмма всех транзакций для бюджета ":name" между :start и :end в :currency',
    'chart_budget_in_period_only_currency'      => 'Ваш бюджет использует валюту :currency, поэтому будут показаны только транзакции в :currency.',
    'chart_account_in_period'                   => 'Диаграмма всех транзакций для счёта ":name" (:balance) между :start и :end',
    'chart_category_in_period'                  => 'Диаграмма всех транзакций для категории ":name" между :start и :end',
    'chart_category_all'                        => 'Диаграмма всех транзакций для категории ":name"',
    'clone_withdrawal'                          => 'Клонировать этот расход',
    'clone_deposit'                             => 'Клонировать этот доход',
    'clone_transfer'                            => 'Клонировать этот трансфер',
    'multi_select_no_selection'                 => 'Ничего не выбрано',
    'multi_select_select_all'                   => 'Выбрать все',
    'multi_select_n_selected'                   => 'выбранные',
    'multi_select_all_selected'                 => 'Все выбранные',
    'multi_select_filter_placeholder'           => 'Поиск..',
    'intro_next_label'                          => 'Далее',
    'intro_prev_label'                          => 'Назад',
    'intro_skip_label'                          => 'Пропустить',
    'intro_done_label'                          => 'Завершить',
    'between_dates_breadcrumb'                  => 'Между :start и :end',
    'all_journals_without_budget'               => 'Все транзакции без бюджета',
    'journals_without_budget'                   => 'Транзакции без бюджета',
    'all_journals_without_category'             => 'Все транзакции без категории',
    'journals_without_category'                 => 'Транзакции без категории',
    'all_journals_for_account'                  => 'Все транзакции для счёта :name',
    'chart_all_journals_for_account'            => 'Диаграмма всех транзакций для счёта :name',
    'journals_in_period_for_account'            => 'Все транзакции для счёта :name между :start и :end',
    'journals_in_period_for_account_js'         => 'Все транзакции по счету {title} между {start} и {end}',
    'transferred'                               => 'Переведено',
    'all_withdrawal'                            => 'Все расходы',
    'all_transactions'                          => 'Все транзакции',
    'title_withdrawal_between'                  => 'Все расходы между :start и :end',
    'all_deposit'                               => 'Все доходы',
    'title_deposit_between'                     => 'Все доходы между :start и :end',
    'all_transfers'                             => 'Все переводы',
    'title_transfers_between'                   => 'Все переводы между :start и :end',
    'all_transfer'                              => 'Все переводы',
    'all_journals_for_tag'                      => 'Все транзакции для метки ":tag"',
    'title_transfer_between'                    => 'Все переводы между :start и :end',
    'all_journals_for_category'                 => 'Все транзакции для категории :name',
    'all_journals_for_budget'                   => 'Все транзакции для бюджета :name',
    'chart_all_journals_for_budget'             => 'Диаграмма всех транзакций для бюджета :name',
    'journals_in_period_for_category'           => 'Все транзакции для категории :name между :start и :end',
    'journals_in_period_for_tag'                => 'Все транзакции для метки :tag между :start и :end',
    'not_available_demo_user'                   => 'Функция, которую вы пытаетесь использовать, недоступна для демо-пользователей.',
    'exchange_rate_instructions'                => 'Для счёта "@name" возможны транзакции только в валюте @primary_currency. Если вы хотите использовать валюту @foreign_currency, убедитесь, что сумма в @primary_currency вам также известна:',
    'transfer_exchange_rate_instructions'       => 'Исходный счёт "@source_name" может использовать только транзакции в валюте @source_currency. Счёт назначения "@dest_name" может использовать транзакции только в валюте @dest_currency. Вы должны правильно указать сумму перевода в обеих валютах.',
    'transaction_data'                          => 'Данные транзакции',
    'invalid_server_configuration'              => 'Неправильная конфигурация сервера',
    'invalid_locale_settings'                   => 'Firefly III не может форматировать денежные суммы, потому что на вашем сервере отсутствуют необходимые пакеты. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">Инструкция, как это сделать</a>.',
    'quickswitch'                               => 'Быстрое переключение',
    'sign_in_to_start'                          => 'Войдите, чтобы начать сессию',
    'sign_in'                                   => 'Войти',
    'register_new_account'                      => 'Зарегистрировать новый счёт',
    'forgot_my_password'                        => 'Я забыл пароль',
    'problems_with_input'                       => 'Есть кое-какие проблемы с введёнными вами данными.',
    'reset_password'                            => 'Восстановление пароля',
    'button_reset_password'                     => 'Сбросить пароль',
    'reset_button'                              => 'Сбросить',
    'want_to_login'                             => 'Я хочу войти',
    'login_page_title'                          => 'Вход в Firefly III',
    'register_page_title'                       => 'Регистрация в Firefly III',
    'forgot_pw_page_title'                      => 'Забыли свой пароль к Firefly III?',
    'reset_pw_page_title'                       => 'Сбросить свой пароль к Firefly III',
    'cannot_reset_demo_user'                    => 'Вы не можете сбросить пароль демонстрационной учётной записи.',
    'no_att_demo_user'                          => 'Демо-пользователь не может загружать вложения.',
    'button_register'                           => 'Регистрация',
    'authorization'                             => 'Авторизация',
    'active_bills_only'                         => 'только активная подписка',
    'active_bills_only_total'                   => 'все активные подписки',
    'active_exp_bills_only'                     => 'только активные и ожидаемые подписки',
    'active_exp_bills_only_total'               => 'только все активные ожидаемые подписки',
    'per_period_sum_1D'                         => 'Ожидаемые ежедневные расходы',
    'per_period_sum_1W'                         => 'Ожидаемые еженедельные расходы',
    'per_period_sum_1M'                         => 'Ожидаемые ежемесячные расходы',
    'per_period_sum_3M'                         => 'Ожидаемые ежеквартальные расходы',
    'per_period_sum_6M'                         => 'Ожидаемые расходы раз в полгода',
    'per_period_sum_1Y'                         => 'Ожидаемые ежегодные расходы',
    'average_per_bill'                          => 'в среднем за подписку',
    'expected_total'                            => 'ожидаемый итог',
    'reconciliation_account_name'               => ':name сверка (:currency)',
    'saved'                                     => 'Сохранено',
    'advanced_options'                          => 'Расширенные настройки',
    'advanced_options_explain'                  => 'На некоторых страницах Firefly III за этой кнопкой скрыты расширенные опции. На этой странице нет ничего фантастического, но проверьте на других страницах!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III обнаружил, что у вас есть транзакции с начала 1970 года. Пожалуйста, исправьте эти транзакции как можно скорее.',
    'anonymous_warning_on'                      => 'Для вашей конфиденциальности, все суммы теперь отображаются как "ноль". Внимание: поле ввода текста может по-прежнему показывать оригинальные суммы!',
    'anonymous_warning_off'                     => 'Суммы будет снова видны. Пожалуйста, обращайте внимание на то, что вокруг вас.',

    // Webhooks
    'webhooks'                                  => 'Веб-хуки',
    'webhooks_breadcrumb'                       => 'Вебхуки',
    'webhooks_menu_disabled'                    => 'отключено',
    'no_webhook_messages'                       => 'Нет сообщений от вебхуков',
    'webhook_trigger_ANY'         => 'После любого события',
    'webhook_trigger_STORE_TRANSACTION'         => 'После создания транзакции',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'После обновления транзакции',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'После удаления транзакции',
    'webhook_trigger_STORE_BUDGET'              => 'После создания бюджета',
    'webhook_trigger_UPDATE_BUDGET'             => 'После обновления бюджета',
    'webhook_trigger_DESTROY_BUDGET'            => 'После удаления бюджета',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Детали операции',
    'webhook_response_ACCOUNTS'                 => 'Сведения об учетной записи',
    'webhook_response_BUDGET'                   => 'Информация о бюджете',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Проинспектировать',
    'create_new_webhook'                        => 'Создать новый вебхук',
    'webhooks_create_breadcrumb'                => 'Создать новый вебхук',
    'webhook_trigger_form_help'                 => 'Укажите, на каких событиях будет срабатывать веб-хук',
    'webhook_response_form_help'                => 'Укажите, что веб-хук должен отправить на URL.',
    'webhook_delivery_form_help'                => 'В каком формате должны быть загружены данные веб-хука.',
    'webhook_active_form_help'                  => 'Веб-хук должен быть активным или он не будет вызван.',
    'stored_new_webhook'                        => 'Добавлен новый вебхук ":title"',
    'delete_webhook'                            => 'Удалить вебхук',
    'deleted_webhook'                           => 'Удалить вебхук ":title"',
    'edit_webhook'                              => 'Редактировать webhook ":title"',
    'updated_webhook'                           => 'Обновлен webhook ":title"',
    'edit_webhook_js'                           => 'Редактировать вебхук "{title}"',
    'show_webhook'                              => 'Вебхук ":title"',
    'webhook_was_triggered'                     => 'Веб-хук сработал на указанную транзакцию. Пожалуйста, дождитесь появления результатов.',
    'webhook_messages'                          => 'Сообщение вебхука',
    'view_message'                              => 'Просмотр сообщения',
    'view_attempts'                             => 'Просмотр неудачных попыток',
    'message_content_title'                     => 'Содержимое сообщения webhook',
    'message_content_help'                      => 'Это содержимое сообщения, которое было отправлено (или попробовало) с помощью этого веб-хука.',
    'attempt_content_title'                     => 'Попытки веб-хука',
    'attempt_content_help'                      => 'Это все неудачные попытки отправки этого веб-хук сообщения на указанный URL. Через некоторое время Firefly III прекратит попытки.',
    'no_attempts'                               => 'Нет неудачных попыток. Это хорошо!',
    'webhook_attempt_at'                        => 'Попытка в {moment}',
    'logs'                                      => 'Логи',
    'response'                                  => 'Ответ',
    'visit_webhook_url'                         => 'Посетить URL вебхука',
    'reset_webhook_secret'                      => '',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Веб-хук #{ID} ("{title}")</a> сохранен.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Веб-хук #{ID} ("{title}")</a> обновлен.',

    // API access
    'authorization_request'                     => 'Запрос авторизации Firefly III v:version',
    'authorization_request_intro'               => 'Приложение "<strong>:client</strong>" запрашивает разрешение на доступ к вашему финансовому администрированию. Вы хотите разрешить <strong>:client</strong> доступ к этим записям?',
    'authorization_request_site'                => 'Вы будете перенаправлены на <code>:url</code>, который будет иметь доступ к вашим данным Firefly III.',
    'authorization_request_invalid'             => 'Этот запрос доступа недействителен. Пожалуйста, никогда не переходите по этой ссылке снова.',
    'scopes_will_be_able'                       => 'Это приложение будет иметь возможность:',
    'button_authorize'                          => 'Авторизация',
    'none_in_select_list'                       => '(нет)',
    'no_piggy_bank'                             => '(нет копилки)',
    'name_in_currency'                          => ':name в :currency',
    'paid_in_currency'                          => 'Оплачено в :currency',
    'unpaid_in_currency'                        => 'Неоплачено в :currency',
    'is_alpha_warning'                          => 'Вы используете АЛЬФА-версию. Будьте осторожны с ошибками и проблемами.',
    'is_beta_warning'                           => 'Вы используете БЕТА-версию. Будьте осторожны с ошибками и проблемами.',
    'all_destination_accounts'                  => 'Счета назначения',
    'all_source_accounts'                       => 'Счета-источники',
    'back_to_index'                             => 'Вернуться к содержанию',
    'cant_logout_guard'                         => 'Firefly III не может выйти из системы.',
    'internal_reference'                        => 'Внутренняя ссылка',

    // check for updates:
    'update_check_title'                        => 'Проверить обновления',
    'admin_update_check_title'                  => 'Автоматически проверять наличие обновлений',
    'admin_update_check_explain'                => 'Firefly III может автоматически проверять наличие обновлений. После включения опции, он свяжется с сервером обновлений Firefly III, чтобы узнать, доступна ли новая версия Firefly III. Когда это произойдёт, вы получите уведомление. Вы можете проверить это уведомление, нажав кнопку справа. Пожалуйста, укажите ниже, если вы хотите, чтобы Firefly III проверял наличие обновлений.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Спросить меня позже',
    'updates_do_not_check'                      => 'Не проверять наличие обновлений',
    'updates_enable_check'                      => 'Включить проверку обновлений',
    'admin_update_check_now_title'              => 'Проверить наличие обновлений',
    'admin_update_check_now_explain'            => 'Если вы нажмете кнопку, Firefly III посмотрит, является ли ваша текущая версия последней.',
    'check_for_updates_button'                  => 'Проверить сейчас!',
    'update_new_version_alert'                  => 'Доступна новая версия Firefly III. Вы используете версию v:your_version, самая свежая версия - v:new_version (выпущена :date).',
    'update_version_beta'                       => 'Эта версия является БЕТА-версией. Вы можете столкнуться с проблемами.',
    'update_version_alpha'                      => 'Эта версия является АЛЬФА-версией. Вы можете столкнуться с проблемами.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Вы используете v:version, которая является последним доступным релизом.',
    'update_newer_version_alert'                => 'Вы используете версию v:your_version, которая новее последнего релиза (v:new_version).',
    'update_check_error'                        => 'Произошла ошибка при проверке обновлений: :error',
    'unknown_error'                             => 'Неизвестная ошибка. Извините за это.',
    'disabled_but_check'                        => 'Вы отключили проверку обновлений. Так что не забывайте время от времени проверять наличие обновлений самостоятельно. Спасибо!',
    'admin_update_channel_title'                => 'Канал обновлений',
    'admin_update_channel_explain'              => 'Firefly III может использовать три "канала" обновлений, которые различаются наборами новых функций и ошибок. Используйте "бета"-канал, если вы любите приключения и "альфа", если вам нравится жить с чувством постоянной опасности.',
    'update_channel_stable'                     => 'Стабильный. Всё должно работать, как вы ожидаете.',
    'update_channel_beta'                       => 'Бета. Есть новые возможности, но что-нибудь может быть сломано.',
    'update_channel_alpha'                      => 'Альфа. Код таких версий может быть собран из соплей и палок.',

    // search
    'search'                                    => 'Поиск',
    'search_query'                              => 'Запрос',
    'search_found_transactions'                 => 'Firefly III нашёл :count транзакции за :time секунд.|Firefly III нашёл :count транзакций за :time секунд.',
    'search_found_more_transactions'            => 'Firefly III нашёл более :count транзакций за :time секунд.',
    'search_for_overview'                       => 'Firefly III ищет операции удовлетворяющие <b>всем</b> условиям:',
    'search_for_query'                          => 'Все эти слова должны присутствовать: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Ни одно из этих слов не присутствует: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Эти параметры поиска некорректны и были проигнорированы.',

    // old


    'search_modifier_date_on'                             => 'Дата транзакции: ":value"',
    'search_modifier_not_date_on'                         => 'Дата транзакции не ":value"',
    'search_modifier_reconciled'                          => 'Транзакция сверена',
    'search_modifier_not_reconciled'                      => 'Транзакция не сверена',
    'search_modifier_id'                                  => 'ID транзакции - ":value"',
    'search_modifier_not_id'                              => 'ID транзакции не является ":value"',
    'search_modifier_date_before'                         => 'Дата транзакции до или равна ":value"',
    'search_modifier_date_after'                          => 'Дата транзакции после или равна ":value"',
    'search_modifier_external_id_is'                      => 'Внешний ID: ":value"',
    'search_modifier_not_external_id_is'                  => 'Внешний ID не ":value"',
    'search_modifier_no_external_url'                     => 'У транзакции нет внешнего URL',
    'search_modifier_no_external_id'                      => 'У транзакции нет внешнего URL',
    'search_modifier_not_any_external_url'                => 'У транзакции нет внешнего URL',
    'search_modifier_not_any_external_id'                 => 'У транзакции нет внешнего ID',
    'search_modifier_any_external_url'                    => 'Транзакция должна иметь (любой) внешний URL',
    'search_modifier_any_external_id'                     => 'Транзакция должна иметь (любой) внешний идентификатор',
    'search_modifier_not_no_external_url'                 => 'Транзакция должна иметь (любой) внешний URL',
    'search_modifier_not_no_external_id'                  => 'Транзакция должна иметь (любой) внешний идентификатор',
    'search_modifier_internal_reference_is'               => 'Внутренняя ссылка: ":value"',
    'search_modifier_not_internal_reference_is'           => 'Внутренняя ссылка не ":value"',
    'search_modifier_description_starts'                  => 'Описание начинается с ":value"',
    'search_modifier_not_description_starts'              => 'Описание не начинается с ":value"',
    'search_modifier_description_ends'                    => 'Описание заканчивается на ":value"',
    'search_modifier_not_description_ends'                => 'Описание не заканчивается на ":value"',
    'search_modifier_description_contains'                => 'Описание содержит ":value"',
    'search_modifier_not_description_contains'            => 'Описание не содержит ":value"',
    'search_modifier_description_is'                      => 'Описание точно соответствует ":value"',
    'search_modifier_not_description_is'                  => 'Описание не является ":value"',
    'search_modifier_currency_is'                         => '(Иностранная) валюта транзакции - ":value"',
    'search_modifier_not_currency_is'                     => 'Валюта транзакции (иностранная) не ":value"',
    'search_modifier_foreign_currency_is'                 => 'Иностранная валюта транзакции - ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Иностранная валюта транзакции не ":value"',
    'search_modifier_has_attachments'                     => 'Транзакция должна иметь вложение',
    'search_modifier_has_no_category'                     => 'Транзакция не должна быть связана с категорией',
    'search_modifier_not_has_no_category'                 => 'Транзакция должна иметь (любую) категорию',
    'search_modifier_not_has_any_category'                => 'Транзакция не должна иметь категорию',
    'search_modifier_has_any_category'                    => 'Транзакция должна быть связана с (любой) категорией',
    'search_modifier_has_no_budget'                       => 'Транзакция не должна быть связана с бюджетом',
    'search_modifier_not_has_any_budget'                  => 'Транзакция не должна иметь бюджет',
    'search_modifier_has_any_budget'                      => 'Транзакция должна быть связана с (любым) бюджетом',
    'search_modifier_not_has_no_budget'                   => 'Транзакция должна иметь (любой) бюджет',
    'search_modifier_has_no_bill'                         => 'Транзакция не должна содержать подписки',
    'search_modifier_not_has_no_bill'                     => 'Транзакция должна иметь (любой) подписку',
    'search_modifier_has_any_bill'                        => 'Операция должна иметь любую подписку',
    'search_modifier_not_has_any_bill'                    => 'Операция не должна содержать подписки',
    'search_modifier_has_no_tag'                          => 'У транзакции не должно быть меток',
    'search_modifier_not_has_any_tag'                     => 'У транзакции не должно быть меток',
    'search_modifier_not_has_no_tag'                      => 'Транзакция должна иметь (любую) метку',
    'search_modifier_has_any_tag'                         => 'Транзакция должна иметь (любую) метку',
    'search_modifier_notes_contains'                      => 'Заметка к транзакции содержит ":value"',
    'search_modifier_not_notes_contains'                  => 'Заметки к транзакции не содержат ":value"',
    'search_modifier_notes_starts'                        => 'Заметка к транзакции начинается с ":value"',
    'search_modifier_not_notes_starts'                    => 'Заметки к транзакции не начинаются с ":value"',
    'search_modifier_notes_ends'                          => 'Заметка к транзакции заканчивается на ":value"',
    'search_modifier_not_notes_ends'                      => 'Заметки к транзакции не заканчиваются на ":value"',
    'search_modifier_notes_is'                            => 'Заметка к транзакции в точности совпадает с ":value"',
    'search_modifier_not_notes_is'                        => 'Заметки к транзакции не совпадают с ":value"',
    'search_modifier_no_notes'                            => 'Транзакция не содержит заметок',
    'search_modifier_not_no_notes'                        => 'Транзакция должна иметь заметки',
    'search_modifier_any_notes'                           => 'Транзакция должна содержать заметки',
    'search_modifier_not_any_notes'                       => 'У транзакции нет заметок',
    'search_modifier_amount_is'                           => 'Сумма в точности равна :value',
    'search_modifier_not_amount_is'                       => 'Сумма не равна :value',
    'search_modifier_amount_less'                         => 'Сумма меньше или равна :value',
    'search_modifier_not_amount_more'                     => 'Сумма меньше или равна :value',
    'search_modifier_amount_more'                         => 'Сумма больше или равна :value',
    'search_modifier_not_amount_less'                     => 'Сумма больше или равна :value',
    'search_modifier_source_account_is'                   => 'Название счёта-источника точно соответствует ":value"',
    'search_modifier_not_source_account_is'               => 'Название счёта-источника не ":value"',
    'search_modifier_source_account_contains'             => 'Название счёта-источника содержит ":value"',
    'search_modifier_not_source_account_contains'         => 'Название счёта-источника не содержит ":value"',
    'search_modifier_source_account_starts'               => 'Название счёта-источника начинается с ":value"',
    'search_modifier_not_source_account_starts'           => 'Название счёта-источника не начинается с ":value"',
    'search_modifier_source_account_ends'                 => 'Название счёта-источника заканчивается на ":value"',
    'search_modifier_not_source_account_ends'             => 'Название счёта-источника не заканчивается на ":value"',
    'search_modifier_source_account_id'                   => 'ID счёта-источника = :value',
    'search_modifier_not_source_account_id'               => 'Идентификатор исходного аккаунта не :value',
    'search_modifier_source_account_nr_is'                => 'Номер счёта-источника (IBAN) - ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Номер счёта-источника (IBAN) не ":value"',
    'search_modifier_source_account_nr_contains'          => 'Номер счёта-источника (IBAN) содержит ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Номер счёта-источника (IBAN) не содержит на ":value"',
    'search_modifier_source_account_nr_starts'            => 'Номер счёта-источника (IBAN) начинается с ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Номер счёта-источника (IBAN) не начинается с ":value"',
    'search_modifier_source_account_nr_ends'              => 'Номер счёта-источника (IBAN) заканчивается на ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Номер счёта-источника (IBAN) не заканчивается на ":value"',
    'search_modifier_destination_account_is'              => 'Название счёта назначения точно соответствует ":value"',
    'search_modifier_not_destination_account_is'          => 'Название счёта-назначения не ":value"',
    'search_modifier_destination_account_contains'        => 'Название счёта назначения содержит ":value"',
    'search_modifier_not_destination_account_contains'    => 'Название счёта-назначения не содержит ":value"',
    'search_modifier_destination_account_starts'          => 'Название счёта назначения начинается с ":value"',
    'search_modifier_not_destination_account_starts'      => 'Название счёта-назначения не начинается с ":value"',
    'search_modifier_destination_account_ends'            => 'Название счёта-назначения заканчивается на ":value"',
    'search_modifier_not_destination_account_ends'        => 'Название счёта-назначения не заканчивается на ":value"',
    'search_modifier_destination_account_id'              => 'ID счёта назначения = :value',
    'search_modifier_not_destination_account_id'          => 'ID счёта-назначения не ":value"',
    'search_modifier_destination_is_cash'                 => 'Целевой счет - это аккаунт "(наличные)"',
    'search_modifier_not_destination_is_cash'             => 'Целевой счет - это аккаунт не "(наличные)"',
    'search_modifier_source_is_cash'                      => 'Исходный счет - это "(наличные)"',
    'search_modifier_not_source_is_cash'                  => 'Исходный счет не является "(наличные)"',
    'search_modifier_destination_account_nr_is'           => 'Номер счета назначения (IBAN) - ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Номер счета назначения (IBAN) - ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Номер счета назначения (IBAN) содержит ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Номер счёта-назначения (IBAN) не содержит ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Номер счета назначения (IBAN) начинается с ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Номер счёта-назначения (IBAN) не начинается с ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Номер счета назначения (IBAN) оканчивается на ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Номер счёта-назначения (IBAN) не заканчивается на ":value"',
    'search_modifier_account_id'                          => 'ID счета источника или назначения: :value',
    'search_modifier_not_account_id'                      => 'Идентификатор счёта источника или назначения не: :value',
    'search_modifier_category_is'                         => 'Категория - ":value"',
    'search_modifier_not_category_is'                     => 'Категория не равна ":value"',
    'search_modifier_budget_is'                           => 'Бюджет - ":value"',
    'search_modifier_not_budget_is'                       => 'Бюджет не ":value"',
    'search_modifier_bill_is'                             => 'Подписка ":value"',
    'search_modifier_not_bill_is'                         => 'Подписка не является ":value"',
    'search_modifier_transaction_type'                    => 'Тип транзакции - ":value"',
    'search_modifier_not_transaction_type'                => 'Тип транзакции не ":value"',
    'search_modifier_tag_is'                              => 'Тег - ":value"',
    'search_modifier_tag_contains'                        => 'Метка содержит ":value"',
    'search_modifier_not_tag_contains'                    => 'Метка не содержит ":value"',
    'search_modifier_tag_ends'                            => 'Метка заканчивается на ":value"',
    'search_modifier_tag_starts'                          => 'Метка начинается с ":value"',
    'search_modifier_not_tag_is'                          => 'Нет тега ":value"',
    'search_modifier_date_on_year'                        => 'Транзакция в году ":value"',
    'search_modifier_not_date_on_year'                    => 'Транзакция не в году ":value"',
    'search_modifier_date_on_month'                       => 'Транзакция в месяце ":value"',
    'search_modifier_not_date_on_month'                   => 'Транзакция не в месяц ":value"',
    'search_modifier_date_on_day'                         => 'Транзакция в день месяца ":value"',
    'search_modifier_not_date_on_day'                     => 'Транзакция не в день месяца ":value"',
    'search_modifier_date_before_year'                    => 'Транзакция до или в год ":value"',
    'search_modifier_date_before_month'                   => 'Транзакция до или в месяц ":value"',
    'search_modifier_date_before_day'                     => 'Транзакция до или в день месяца ":value"',
    'search_modifier_date_after_year'                     => 'Транзакция в году ":value " или после',
    'search_modifier_date_after_month'                    => 'Транзакция в месяце ":value" или после',
    'search_modifier_date_after_day'                      => 'Транзакция после или в день месяца ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Нет тега ":value"',
    'search_modifier_not_tag_is_not'                      => 'Тег ":value"',
    'search_modifier_account_is'                          => 'Является ли счёт ":value"',
    'search_modifier_not_account_is'                      => 'Ни один аккаунт не является ":value"',
    'search_modifier_account_contains'                    => 'Содержит ли счёт ":value"',
    'search_modifier_not_account_contains'                => 'Ни один аккаунт не содержит ":value"',
    'search_modifier_account_ends'                        => 'Либо счет заканчивается на ":value"',
    'search_modifier_not_account_ends'                    => 'Ни один из аккаунтов не заканчивается на ":value"',
    'search_modifier_account_starts'                      => 'Либо счет начинается с ":value"',
    'search_modifier_not_account_starts'                  => 'Ни один аккаунт не начинается с ":value"',
    'search_modifier_account_nr_is'                       => 'Номер счета / IBAN ":value"',
    'search_modifier_not_account_nr_is'                   => 'Номер счета / IBAN ":value"',
    'search_modifier_account_nr_contains'                 => 'Номер счета / IBAN содержит ":value"',
    'search_modifier_not_account_nr_contains'             => 'Ни один номер счета / IBAN не содержит ":value"',
    'search_modifier_account_nr_ends'                     => 'Номер счета / IBAN заканчивается на ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Ни один номер счета / IBAN не заканчивается на ":value"',
    'search_modifier_account_nr_starts'                   => 'Номер счета / IBAN начинается с ":value"',
    'search_modifier_not_account_nr_starts'               => 'Ни один номер счета / IBAN не начинается с ":value"',
    'search_modifier_category_contains'                   => 'Категория содержит ":value"',
    'search_modifier_not_category_contains'               => 'Категория не содержит ":value"',
    'search_modifier_category_ends'                       => 'Категория заканчивается на ":value"',
    'search_modifier_not_category_ends'                   => 'Категория не заканчивается ":value"',
    'search_modifier_category_starts'                     => 'Категория начинается с ":value"',
    'search_modifier_not_category_starts'                 => 'Категория не начинается с ":value"',
    'search_modifier_budget_contains'                     => 'Бюджет содержит ":value"',
    'search_modifier_not_budget_contains'                 => 'Бюджет не содержит ":value"',
    'search_modifier_budget_ends'                         => 'Бюджет заканчивается на ":value"',
    'search_modifier_not_budget_ends'                     => 'Бюджет не заканчивается ":value"',
    'search_modifier_budget_starts'                       => 'Бюджет начинается с ":value"',
    'search_modifier_not_budget_starts'                   => 'Бюджет не начинается с ":value"',
    'search_modifier_bill_contains'                       => 'Подписка содержит ":value"',
    'search_modifier_not_bill_contains'                   => 'Подписка не содержит ":value"',
    'search_modifier_bill_ends'                           => 'Подписка заканчивается на ":value"',
    'search_modifier_not_bill_ends'                       => 'Подписка не заканчивается ":value"',
    'search_modifier_bill_starts'                         => 'Подписка начинается с ":value"',
    'search_modifier_not_bill_starts'                     => 'Подписка не начинается с ":value"',
    'search_modifier_external_id_contains'                => 'Внешний ID содержит ":value"',
    'search_modifier_not_external_id_contains'            => 'Внешний ID не содержит ":value"',
    'search_modifier_external_id_ends'                    => 'Внешний ID заканчивается на ":value"',
    'search_modifier_not_external_id_ends'                => 'Внешний ID не заканчивается на ":value"',
    'search_modifier_external_id_starts'                  => 'Внешний ID начинается с ":value"',
    'search_modifier_not_external_id_starts'              => 'Внешний ID не начинается с ":value"',
    'search_modifier_internal_reference_contains'         => 'Внутренняя ссылка содержит ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Внутренняя ссылка не содержит ":value"',
    'search_modifier_internal_reference_ends'             => 'Внутренняя ссылка заканчивается на ":value"',
    'search_modifier_internal_reference_starts'           => 'Внутренняя ссылка начинается с ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Внутренняя ссылка не заканчивается на ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Внутренняя ссылка не начинается с ":value"',
    'search_modifier_external_url_is'                     => 'Внешний URL-адрес ":value"',
    'search_modifier_not_external_url_is'                 => 'Внешний URL не ":value"',
    'search_modifier_external_url_contains'               => 'Внешний URL содержит ":value"',
    'search_modifier_not_external_url_contains'           => 'Внешний URL не содержит ":value"',
    'search_modifier_external_url_ends'                   => 'Внешний URL заканчивается на ":value"',
    'search_modifier_not_external_url_ends'               => 'Внешний URL не заканчивается на ":value"',
    'search_modifier_external_url_starts'                 => 'Внешний URL начинается с ":value"',
    'search_modifier_not_external_url_starts'             => 'Внешний URL не начинается с ":value"',
    'search_modifier_has_no_attachments'                  => 'Транзакция не содержит вложений',
    'search_modifier_not_has_no_attachments'              => 'Транзакция имеет вложения',
    'search_modifier_not_has_attachments'                 => 'Транзакции не содержит вложений',
    'search_modifier_account_is_cash'                     => 'Любой счет является «(наличными)».',
    'search_modifier_not_account_is_cash'                 => 'Ни один из этих счетов не является "(наличные)".',
    'search_modifier_journal_id'                          => 'ID журнала ":value"',
    'search_modifier_not_journal_id'                      => 'ID журнала не является ":value"',
    'search_modifier_recurrence_id'                       => 'ID повторяющейся транзакции является ":value"',
    'search_modifier_not_recurrence_id'                   => 'ID повторяющейся транзакции не является ":value"',
    'search_modifier_foreign_amount_is'                   => 'Сумма иностранного платежа: ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Сумма в иностранной валюте не ":value"',
    'search_modifier_foreign_amount_less'                 => 'Сумма в иностранной валюте меньше ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Сумма в иностранной валюте меньше ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Сумма в иностранной валюте больше ":value"',
    'search_modifier_foreign_amount_more'                 => 'Иначе сумма больше чем ":value"',
    'search_modifier_exists'                              => 'Транзакция существует (любая транзакция)',
    'search_modifier_not_exists'                          => 'Транзакция не существует (нет транзакции)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Дата начисления процентов по транзакции ":value"',
    'search_modifier_not_interest_date_on'                => 'Дата начисления процентов по транзакции не ":value"',
    'search_modifier_interest_date_on_year'               => 'Дата интересующей транзакции указана в году ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Дата интересующей сделке указана вне года ":value"',
    'search_modifier_interest_date_on_month'              => 'Дата начисления процентов по сделке указана в месяце ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Дата интересующей сделке указана вне месяца ":value"',
    'search_modifier_interest_date_on_day'                => 'Дата начисления процентов по сделке приходится на день месяца ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Дата выплаты процентов по транзакции не совпадает с днем месяца «:value»',
    'search_modifier_interest_date_before_year'           => 'Дата выплаты процентов по сделке наступает в ":value" году или предшествует этому году',
    'search_modifier_interest_date_before_month'          => 'Дата выплаты процентов по сделке наступает в ":value" месяце или до этого месяца',
    'search_modifier_interest_date_before_day'            => 'Дата начисления процентов по сделке в день месяца ":value" или до него',
    'search_modifier_interest_date_after_year'            => 'Дата транзакции через или в год ":value"',
    'search_modifier_interest_date_after_month'           => 'Дата транзакции после или в ":value" месяце',
    'search_modifier_interest_date_after_day'             => 'Дата транзакции после или в день месяца ":value"',
    'search_modifier_book_date_on_year'                   => 'Дата книги транзакций в году ":value"',
    'search_modifier_book_date_on_month'                  => 'Дата книги транзакций в месяце ":value"',
    'search_modifier_book_date_on_day'                    => '',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Дата выполнения сделки в ":value" году',
    'search_modifier_due_date_on_month'                   => 'Дата выполнения сделки в ":value" месяце',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Дата выполнения транзакции через или в ":value" году',
    'search_modifier_due_date_after_month'                => 'Дата выполнения транзакции через или в ":value" месяце',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Дата оплаты транзакции в ":value" году',
    'search_modifier_payment_date_on_month'               => 'Дата оплаты транзакции в ":value" месяце',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => '',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Последний раз транзакция обновлялась в ":value" году',
    'search_modifier_updated_at_on_month'                 => 'Последний раз транзакция обновлялась в ":value" месяце',
    'search_modifier_updated_at_on_day'                   => 'Последний раз транзакция обновлялась ":value" числа',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Последний раз транзакция обновлялась в ":value" году или ранее',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Сделка создана в ":value" году',
    'search_modifier_created_at_on_month'                 => 'Сделка создана в ":value" месяце',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Транзакция была создана в течение или до ":value" месяца',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Транзакция была создана в течение или до ":value" года',
    'search_modifier_created_at_after_month'              => 'Транзакция была создана в течение ":value" месяца или после',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Сделка была создана ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Сделка была создана или до ":value"',
    'search_modifier_created_at_after'                    => 'Сделка была создана или после ":value"',
    'search_modifier_updated_at_on'                       => 'Сделка обновлена ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Сделка обновлена или до ":value"',
    'search_modifier_updated_at_after'                    => 'Сделка обновлена или после ":value"',

    'search_modifier_attachment_name_is'            => 'Имя вложения: ":value"',
    'search_modifier_attachment_name_contains'      => 'Имя вложений содержащее ":value"',
    'search_modifier_attachment_name_starts'        => 'Имя вложений начинается с ":value"',
    'search_modifier_attachment_name_ends'          => 'Имя вложений заканчивается на ":value"',
    'search_modifier_attachment_notes_are'          => 'Любые заметки к вложениям являются ":value"',
    'search_modifier_attachment_notes_contains'     => 'Любые заметки вложений содержат ":value"',
    'search_modifier_attachment_notes_starts'       => 'Любые заметки вложений начинаются с ":value"',
    'search_modifier_attachment_notes_ends'         => 'Любые заметки вложений заканчиваются на ":value"',
    'search_modifier_not_attachment_name_is'        => 'Любое имя вложений не является ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Имя любого прикрепленного файла не содержит ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Имя любого прикрепленного файла не начинается с ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => '',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT ":value"',
    'update_rule_from_query'                        => 'Обновить правило ":rule" из поискового запроса',
    'create_rule_from_query'                        => 'Создать новое правило из поискового запроса',
    'rule_from_search_words'                        => 'Механизм правил не справился с обработкой ":string". Предлагаемое правило, удовлетворяющее вашему поисковому запросу, может дать различные результаты. Пожалуйста, тщательно проверьте условия правила.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Баланс целевого счета ровно ":value"',
    'search_modifier_not_destination_balance_is'    => 'Баланс целевого счета не равен ":value"',
    'search_modifier_source_balance_is'             => 'Баланс исходного счета равен ":value"',
    'search_modifier_not_source_balance_is'         => 'Баланс исходного счета не равен ":value"',

    'search_modifier_destination_balance_lte'     => 'Баланс целевого счета меньше или равен ":value"',
    'search_modifier_not_destination_balance_lte' => 'Баланс целевого счета больше чем ":value"',
    'search_modifier_source_balance_lte'          => 'Баланс исходного счета меньше или равен ":value"',
    'search_modifier_not_source_balance_lte'      => 'Баланс исходного счета более чем ":value"',

    'search_modifier_destination_balance_lt'     => 'Баланс целевого счета меньше, чем ":value"',
    'search_modifier_not_destination_balance_lt' => 'Баланс целевого счета больше или равен ":value"',
    'search_modifier_source_balance_lt'          => 'Баланс исходного счета меньше, чем ":value"',
    'search_modifier_not_source_balance_lt'      => 'Баланс исходного счета больше или равен ":value"',

    'search_modifier_destination_balance_gte'     => 'Баланс целевого счета больше или равен ":value"',
    'search_modifier_not_destination_balance_gte' => 'Баланс целевого счета меньше, чем ":value"',
    'search_modifier_source_balance_gte'          => 'Баланс исходного счета больше или равен ":value"',
    'search_modifier_not_source_balance_gte'      => 'Баланс исходного счета меньше, чем ":value"',

    'search_modifier_destination_balance_gt'              => 'Баланс целевого счета больше чем ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Баланс целевого счета меньше или равен ":value"',
    'search_modifier_source_balance_gt'                   => 'Баланс исходного счета больше чем ":value"',
    'search_modifier_not_source_balance_gt'               => 'Баланс исходного счета меньше или равен ":value"',


    // END
    'general_search_error'                                => 'При поиске произошла ошибка. Пожалуйста, проверьте log-файлы для получения дополнительной информации.',
    'search_box'                                          => 'Поиск',
    'search_box_intro'                                    => 'Добро пожаловать в поиск по Firefly III. Введите поисковый запрос в поле. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Убедитесь, что вы ознакомились с файлом помощи</a>, т.к. поиск довольно продвинут.',
    'search_error'                                        => 'Ошибка при поиске',
    'search_searching'                                    => 'Поиск...',
    'search_results'                                      => 'Результаты поиска',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'ежегодно',
    'repeat_freq_half-year'                               => 'раз в полгода',
    'repeat_freq_quarterly'                               => 'раз в квартал',
    'repeat_freq_monthly'                                 => 'ежемесячно',
    'repeat_freq_weekly'                                  => 'еженедельно',
    'repeat_freq_daily'                                   => 'ежедневно',
    'daily'                                               => 'ежедневно',
    'weekly'                                              => 'еженедельно',
    'quarterly'                                           => 'раз в квартал',
    'half-year'                                           => 'раз в полгода',
    'yearly'                                              => 'ежегодно',

    // rules
    'is_not_rule_trigger'                                 => 'НЕ',
    'cannot_fire_inactive_rules'                          => 'Вы не можете выполнять неактивные правила.',
    'show_triggers'                                       => 'Показать триггеры',
    'show_actions'                                        => 'Показать действия',
    'rules'                                               => 'Правила',
    'rule_name'                                           => 'Название правила',
    'rule_triggers'                                       => 'Правило срабатывает, когда',
    'rule_actions'                                        => 'Правило будет делать',
    'new_rule'                                            => 'Новое правило',
    'new_rule_group'                                      => 'Новая группа правил',
    'rule_priority_up'                                    => 'Задать для правила более высокий приоритет',
    'rule_priority_down'                                  => 'Задать для правила более низкий приоритет',
    'make_new_rule_group'                                 => 'Создать новую группу правил',
    'store_new_rule_group'                                => 'Сохранить новую группу правил',
    'created_new_rule_group'                              => 'Новая группа правил ":title" сохранена!',
    'updated_rule_group'                                  => 'Группа правил ":title" успешно обновлена.',
    'edit_rule_group'                                     => 'Изменить группу правил ":title"',
    'duplicate_rule'                                      => 'Дублировать правило ":title"',
    'rule_copy_of'                                        => 'Копия ":title"',
    'duplicated_rule'                                     => 'Дублированное правило ":title" в ":newTitle"',
    'delete_rule_group'                                   => 'Удалить группу правил ":title"',
    'deleted_rule_group'                                  => 'Группа правил ":title" удалена',
    'update_rule_group'                                   => 'Обновление группы правил',
    'no_rules_in_group'                                   => 'В этой группе нет правил',
    'move_rule_group_up'                                  => 'Переместить группу правил вверх',
    'move_rule_group_down'                                => 'Переместить группу правил вниз',
    'save_rules_by_moving'                                => 'Сохраните это правило, переместив его в другую группу правил:|Сохраните эти правила, переместив их в другую группу правил:',
    'make_new_rule'                                       => 'Создать новое правило в группе правил ":title"',
    'make_new_rule_no_group'                              => 'Создать новое правило',
    'instructions_rule_from_bill'                         => 'Для того, чтобы сопоставить операции с вашей новой подпиской ":name", Firefly III может создать правило, которое будет автоматически применятся к любым операция, которые вы храните. Проверьте данные ниже и сохраните правило, чтобы Firefly III автоматически сопоставлял операции с вашим новым счетом.',
    'instructions_rule_from_journal'                      => 'Создайте правило, основанное на одной из ваших транзакций. Заполните или отправьте форму ниже.',
    'rule_is_strict'                                      => 'строгое правило',
    'rule_is_not_strict'                                  => 'нестрогое правило',
    'rule_help_stop_processing'                           => 'Если вы установите этот флажок, последующие правила в этой группе не будут выполняться, если выполняется данное конкретное правило.',
    'rule_help_strict'                                    => 'В строгих правилах действие будет запущено, если ВСЕ триггеры выполнены. Для нестрогих правил достаточно срабатывания одного ЛЮБОГО триггера.',
    'rule_help_active'                                    => 'Неактивные правила никогда не срабатывают.',
    'stored_new_rule'                                     => 'Сохранено новое правило с названием ":title"',
    'deleted_rule'                                        => 'Удалено правило с названием ":title"',
    'store_new_rule'                                      => 'Сохранить новое правило',
    'updated_rule'                                        => 'Обновлено правило с названием ":title"',
    'default_rule_group_name'                             => 'Правила по умолчанию',
    'default_rule_group_description'                      => 'Здесь размещаются правила, которые вы не поместили ни в одну из групп.',
    'trigger'                                             => 'Условие',
    'trigger_value'                                       => 'Значение условия',
    'stop_processing_other_triggers'                      => 'Прекратить обработку других условий',
    'add_rule_trigger'                                    => 'Добавить новое условие',
    'action'                                              => 'Действие',
    'action_value'                                        => 'Значение действия',
    'stop_executing_other_actions'                        => 'Прекратить выполнение других действий',
    'add_rule_action'                                     => 'Добавить новое действие',
    'edit_rule'                                           => 'Редактировать правило #:nr ":title"',
    'delete_rule'                                         => 'Удалить правило ":title"',
    'update_rule'                                         => 'Обновить правило',
    'test_rule_triggers'                                  => 'Показать подходящие транзакции',
    'warning_no_matching_transactions'                    => 'Подходящих транзакций не найдено.',
    'warning_no_valid_triggers'                           => 'Отсутствуют правильные условия.',
    'apply_rule_selection'                                => 'Применить ":title" к выбранным вами транзакциям',
    'apply_rule_selection_intro'                          => 'Такие правила, как ":title", обычно применяются только к новым или обновлённым транзакциям, но Firefly III может применить его для выбранных вами существующих транзакций. Это может быть полезно, если вы обновили правило, и вам нужно изменить ранее созданные транзакции в соответствии с новыми условиями.',
    'include_transactions_from_accounts'                  => 'Включить транзакции с указанных счетов',
    'include'                                             => 'Включить?',
    'applied_rule_selection'                              => '{0} В вашем выборе ни одна транзакция не была изменена правилом ":title".|[1] В вашем выборе одна транзакция была изменена правилом ":title".|[2,*] :count транзакции(-ий) в вашем выборе было изменено правилом ":title".',
    'execute'                                             => 'Выполнить',
    'apply_rule_group_selection'                          => 'Применить группу правил":title" к выбранным вами транзакциям',
    'apply_rule_group_selection_intro'                    => 'Такие группы правил, как ":title", обычно применяются только к новым или обновлённым транзакциям, но Firefly III может применить все правила из этой группы для выбранных вами существующих транзакций. Это может быть полезно, если вы обновили одно или несколько правил в группе и вам нужно изменить ранее созданные транзакции в соответствии с новыми условиями.',
    'applied_rule_group_selection'                        => 'Группа правил ":title" была применена к выбранным вами транзакциям.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Когда создается транзакция',
    'rule_trigger_update_journal'                         => 'Когда транзакция обновляется',
    'rule_trigger_manual'                                 => 'Только когда пользователь активирован',
    'rule_trigger_user_action'                            => 'Действие пользователя = ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Название счёта-источника начинается с..',
    'rule_trigger_source_account_starts'                  => 'Название счёта-источника начинается с ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Название счёта-источника заканчивается на..',
    'rule_trigger_source_account_ends'                    => 'Название счёта-источника заканчивается на ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Название счёта-источника..',
    'rule_trigger_source_account_is'                      => 'Название счёта-источника ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Название счёта-источника содержит..',
    'rule_trigger_source_account_contains'                => 'Название счёта-источника содержит ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Идентификатор счёта совпадает с..',
    'rule_trigger_account_id'                             => 'Идентификатор счёта совпадает с :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'ID счёта-источника совпадает с..',
    'rule_trigger_source_account_id'                      => 'ID счёта-источника совпадает с :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'ID счёта назначения совпадает с..',
    'rule_trigger_destination_account_id'                 => 'ID счёта назначения совпадает с :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Любой счет является наличными',
    'rule_trigger_account_is_cash'                        => 'Любой счет является наличными',
    'rule_trigger_source_is_cash_choice'                  => 'Счёт-источник - это (наличный) счёт',
    'rule_trigger_source_is_cash'                         => 'Счёт-источник - это (наличный) счёт',
    'rule_trigger_destination_is_cash_choice'             => 'Счёт назначения - это (наличный) счёт',
    'rule_trigger_destination_is_cash'                    => 'Счёт назначения - это (наличный) счёт',
    'rule_trigger_source_account_nr_starts_choice'        => 'Номер счёта-источника / IBAN начинается с..',
    'rule_trigger_source_account_nr_starts'               => 'Номер счёта-источника / IBAN начинается с ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Номер счёта-источника / IBAN заканчивается на..',
    'rule_trigger_source_account_nr_ends'                 => 'Номер счёта-источника / IBAN заканчивается на ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Номер счёта-источника / IBAN..',
    'rule_trigger_source_account_nr_is'                   => 'Номер счёта-источника / IBAN - ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Номер счёта-источника / IBAN содержит..',
    'rule_trigger_source_account_nr_contains'             => 'Номер счёта-источника / IBAN содержит ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Название счёта назначения начинается с..',
    'rule_trigger_destination_account_starts'             => 'Название счёта назначения начинается с ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Название счёта назначения заканчивается на..',
    'rule_trigger_destination_account_ends'               => 'Название счёта назначения заканчивается на ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Название счёта назначения..',
    'rule_trigger_destination_account_is'                 => 'Название счёта назначения ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Название счёта назначения содержит..',
    'rule_trigger_destination_account_contains'           => 'Название счёта назначения содержит ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Номер счёта назначение / IBAN начинается с..',
    'rule_trigger_destination_account_nr_starts'          => 'Номер счёта назначение / IBAN начинается с ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Номер счёта назначения / IBAN заканчивается на..',
    'rule_trigger_destination_account_nr_ends'            => 'Номер счёта назначения / IBAN заканчивается ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Номер счёта назначение / IBAN..',
    'rule_trigger_destination_account_nr_is'              => 'Номер счёта назначения / IBAN ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Номер счёта назначения / IBAN содержит..',
    'rule_trigger_destination_account_nr_contains'        => 'Номер счёта назначения / IBAN содержит ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Тип транзакции = ',
    'rule_trigger_transaction_type'                       => 'Тип транзакции = ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Категория =',
    'rule_trigger_category_is'                            => 'Категория = ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Сумма меньше или равна ..',
    'rule_trigger_amount_less'                            => 'Сумма меньше или равна :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Сумма..',
    'rule_trigger_amount_is'                              => 'Сумма :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Сумма больше или равна..',
    'rule_trigger_amount_more'                            => 'Сумма больше или равна :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Описание начинается с...',
    'rule_trigger_description_starts'                     => 'Описание начинается с ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Описание заканчивается на...',
    'rule_trigger_description_ends'                       => 'Описание заканчивается на ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Описание содержит...',
    'rule_trigger_description_contains'                   => 'Описание содержит ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Описание =',
    'rule_trigger_description_is'                         => 'Описание = ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Дата транзакции..',
    'rule_trigger_date_on'                                => 'Дата транзакции: ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Дата транзакции до...',
    'rule_trigger_date_before'                            => 'Дата транзакции до ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Дата транзакции после..',
    'rule_trigger_date_after'                             => 'Дата транзакции после ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Транзакция совершена..',
    'rule_trigger_created_at_on'                          => 'Транзакция совершена ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Последнее изменение транзакции..',
    'rule_trigger_updated_at_on'                          => 'Последнее изменение транзакции ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Бюджет =',
    'rule_trigger_budget_is'                              => 'Бюджет = ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Любой тег..',
    'rule_trigger_tag_is'                                 => 'Любой тег ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Любая метка содержит..',
    'rule_trigger_tag_contains'                           => 'Любая метка содержит ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Любая метка заканчивается..',
    'rule_trigger_tag_ends'                               => 'Любая метка заканчивается на ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Любая метка начинается с..',
    'rule_trigger_tag_starts'                             => 'Любая метка начинается с ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Валюта операции - ',
    'rule_trigger_currency_is'                            => 'Валюта транзакции = ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Валюта операции - ',
    'rule_trigger_foreign_currency_is'                    => 'Валюта транзакции = ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Содержит вложения',
    'rule_trigger_has_attachments'                        => 'Содержит вложение или вложения',
    'rule_trigger_has_no_category_choice'                 => 'Нет связанной категории',
    'rule_trigger_has_no_category'                        => 'Транзакция не связана ни с одной категорией',
    'rule_trigger_has_any_category_choice'                => 'Связана с (любой) категорией',
    'rule_trigger_has_any_category'                       => 'Транзакция связана с (любой) категорией',
    'rule_trigger_has_no_budget_choice'                   => 'Нет связанного бюджета',
    'rule_trigger_has_no_budget'                          => 'Транзакция не связана ни с одним бюджетом',
    'rule_trigger_has_any_budget_choice'                  => 'Связана с (любым) бюджетом',
    'rule_trigger_has_any_budget'                         => 'Транзакция связана с (любым) бюджетом',
    'rule_trigger_has_no_bill_choice'                     => 'Нет подписки',
    'rule_trigger_has_no_bill'                            => 'У транзакции нет подписки',
    'rule_trigger_has_any_bill_choice'                    => 'Имеет (любой) подписку',
    'rule_trigger_has_any_bill'                           => 'Транзакция содержит (любую) подписку',
    'rule_trigger_has_no_tag_choice'                      => 'Нет меток',
    'rule_trigger_has_no_tag'                             => 'У транзакции ни одной метки',
    'rule_trigger_has_any_tag_choice'                     => 'Есть одна или несколько (любых) меток',
    'rule_trigger_has_any_tag'                            => 'Транзакция имеет одну или более (любые) метки',
    'rule_trigger_any_notes_choice'                       => 'Содержит (любые) заметки',
    'rule_trigger_any_notes'                              => 'Транзакция содержит (любые) заметки',
    'rule_trigger_no_notes_choice'                        => 'Не содержит заметок',
    'rule_trigger_no_notes'                               => 'Транзакция не содержит заметок',
    'rule_trigger_notes_is_choice'                        => 'Примечания..',
    'rule_trigger_notes_is'                               => 'Примечания ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Заметки содержат..',
    'rule_trigger_notes_contains'                         => 'Заметки содержат ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Заметки начинаются с..',
    'rule_trigger_notes_starts'                           => 'Заметки начинаются с ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Заметки заканчиваются на..',
    'rule_trigger_notes_ends'                             => 'Заметки заканчиваются на ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Подписка..',
    'rule_trigger_bill_is'                                => 'Подписка ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Внешний ID..',
    'rule_trigger_external_id_is'                         => 'Внешний ID - ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Внутренняя ссылка..',
    'rule_trigger_internal_reference_is'                  => 'Внутренняя ссылка - ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'ID журнала транзакций..',
    'rule_trigger_journal_id'                             => 'ID журнала транзакций ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'У транзакции есть (любой) внешний URL',
    'rule_trigger_any_external_url_choice'                => 'Имеет (любой) внешний URL',
    'rule_trigger_any_external_id'                        => 'У транзакции есть (любой) внешний идентификатор',
    'rule_trigger_any_external_id_choice'                 => 'Имеет (любой) внешний ID',
    'rule_trigger_no_external_url_choice'                 => 'Не имеет внешнего URL',
    'rule_trigger_no_external_url'                        => 'У транзакции нет внешнего URL',
    'rule_trigger_no_external_id_choice'                  => 'Не имеет внешнего ID',
    'rule_trigger_no_external_id'                         => 'У транзакции нет внешнего идентификатора',
    'rule_trigger_id_choice'                              => 'ID транзакции..',
    'rule_trigger_id'                                     => 'ID транзакции ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Действие пользователя = ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Нет тэга..',
    'rule_trigger_tag_is_not'                             => 'Нет тега ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Счет совпадает с..',
    'rule_trigger_account_is'                             => 'Счет совпадает с ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Любая учетная запись заканчивается содержит..',
    'rule_trigger_account_contains'                       => 'Любая учетная запись содержит ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Любая учетная запись заканчивается..',
    'rule_trigger_account_ends'                           => 'Любая учетная запись заканчивается на ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Любая учетная запись начинается с..',
    'rule_trigger_account_starts'                         => 'Любая учетная запись начинается с ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Номер счета / IBAN..',
    'rule_trigger_account_nr_is'                          => 'Номер счета / IBAN ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Номер счета / IBAN содержит..',
    'rule_trigger_account_nr_contains'                    => 'Номер счета / IBAN содержит ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Номер счета / IBAN заканчивается на..',
    'rule_trigger_account_nr_ends'                        => 'Номер счета / IBAN заканчивается на ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Номер счета / IBAN начинается с..',
    'rule_trigger_account_nr_starts'                      => 'Номер счета / IBAN начинается с ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Категория содержит..',
    'rule_trigger_category_contains'                      => 'Категория содержит ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Категория заканчивается на..',
    'rule_trigger_category_ends'                          => 'Категория заканчивается на ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Категория начинается на..',
    'rule_trigger_category_starts'                        => 'Категория начинается на ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Бюджет содержит..',
    'rule_trigger_budget_contains'                        => 'Бюджет содержит ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Бюджет заканчивается на..',
    'rule_trigger_budget_ends'                            => 'Бюджет заканчивается на ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Бюджет начинается с..',
    'rule_trigger_budget_starts'                          => 'Бюджет начинается с ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Подписка содержит..',
    'rule_trigger_bill_contains'                          => 'Подписка содержит ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Подписка заканчивается..',
    'rule_trigger_bill_ends'                              => 'Подписка заканчивается на ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Подписка начинается с..',
    'rule_trigger_bill_starts'                            => 'Подписка начинается с ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Внешний ID содержит..',
    'rule_trigger_external_id_contains'                   => 'Внешний ID содержит ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Внешний ID заканчивается на..',
    'rule_trigger_external_id_ends'                       => 'Внешний ID заканчивается на ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Внешний ID начинается с..',
    'rule_trigger_external_id_starts'                     => 'Внешний ID начинается на ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Внутренняя ссылка содержит..',
    'rule_trigger_internal_reference_contains'            => 'Внутренняя ссылка содержит ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Внутренняя ссылка заканчивается на..',
    'rule_trigger_internal_reference_ends'                => 'Внутренняя ссылка заканчивается на ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Внутренняя ссылка начинается с..',
    'rule_trigger_internal_reference_starts'              => 'Внутренняя ссылка начинается с ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Внешний URL..',
    'rule_trigger_external_url_is'                        => 'Внешний URL ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Внешний URL-адрес содержит..',
    'rule_trigger_external_url_contains'                  => 'Внешний URL содержит ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Внешний URL-адрес заканчивается на..',
    'rule_trigger_external_url_ends'                      => 'Внешний URL заканчивается на ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Внешний URL-адрес начинается с..',
    'rule_trigger_external_url_starts'                    => 'Внешний URL начинается с ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Вложений нет',
    'rule_trigger_has_no_attachments'                     => 'У транзакции нет вложений',
    'rule_trigger_recurrence_id_choice'                   => 'Идентификатор повторяющейся транзакции..',
    'rule_trigger_recurrence_id'                          => 'Идентификатор повторяющейся транзакции ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Дата начисления процентов..',
    'rule_trigger_interest_date_on'                       => 'Дата начисления процентов ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Дата начисления процентов после..',
    'rule_trigger_interest_date_before'                   => 'Дата начисления процентов до ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Дата начисления процентов после..',
    'rule_trigger_interest_date_after'                    => 'Дата начисления процентов после ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => '',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Дата оплаты..',
    'rule_trigger_process_date_on'                        => 'Дата оплаты ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Дата оплаты до..',
    'rule_trigger_process_date_before'                    => 'Дата оплаты до ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Дата оплаты после..',
    'rule_trigger_process_date_after'                     => 'Дата счета после ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Дата выполнения..',
    'rule_trigger_due_date_on'                            => 'Дата выполнения ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Дата выполнения до..',
    'rule_trigger_due_date_before'                        => 'Дата выполнения до ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Дата выполнения после..',
    'rule_trigger_due_date_after'                         => 'Дата выполнения после ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Дата оплаты..',
    'rule_trigger_payment_date_on'                        => 'Дата оплаты ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Дата оплаты до..',
    'rule_trigger_payment_date_before'                    => 'Дата оплаты до ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Дата оплаты после..',
    'rule_trigger_payment_date_after'                     => 'Дата оплаты после ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Дата выставления счета..',
    'rule_trigger_invoice_date_on'                        => 'Дата выставления счета ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Дата выставления счета до..',
    'rule_trigger_invoice_date_before'                    => 'Дата счета до ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Дата выставления счёта после..',
    'rule_trigger_invoice_date_after'                     => 'Дата счета после ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Транзакция была создана ранее..',
    'rule_trigger_created_at_before'                      => 'Транзакция была создана до ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Транзакция была создана после..',
    'rule_trigger_created_at_after'                       => 'Транзакция была создана после ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Последний раз транзакция обновилась..',
    'rule_trigger_updated_at_before'                      => 'Последняя транзакция была обновлена до ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Последняя транзакция была обновлена после..',
    'rule_trigger_updated_at_after'                       => 'Последняя транзакция была обновлена после ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Имя любого вложения..',
    'rule_trigger_attachment_name_is'                     => 'Любое имя вложения: ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Имя любых вложений содержит..',
    'rule_trigger_attachment_name_contains'               => 'Имя любых вложений содержит ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Имя любого вложения начинается с..',
    'rule_trigger_attachment_name_starts'                 => 'Имя любого вложения начинается с ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Имя любого вложений заканчивается на..',
    'rule_trigger_attachment_name_ends'                   => 'Имя любого вложений заканчивается на ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Имя любого вложения..',
    'rule_trigger_attachment_notes_are'                   => 'Любое имя вложения: ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Имя любых вложений содержит..',
    'rule_trigger_attachment_notes_contains'              => 'Имя любых вложений содержит ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Имя любого вложения начинается с..',
    'rule_trigger_attachment_notes_starts'                => 'Имя любого вложения начинается с ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Имя любого вложений заканчивается на..',
    'rule_trigger_attachment_notes_ends'                  => 'Имя любого вложений заканчивается на ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Транзакция сверена',
    'rule_trigger_reconciled'                             => 'Транзакция сверена',
    'rule_trigger_exists_choice'                          => 'Любые транзакции совпадают(!)',
    'rule_trigger_exists'                                 => 'Любые транзакции совпадают',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'ID аккаунта не ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'ID счёта-источника не ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'ID счёта-назначения не ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Тип транзакции не ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Метка не ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Метка = ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Описание не ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Описание не содержит ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Описание не заканчивается на ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Описание не начинается с ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Заметки не ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Заметки не содержат ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Заметки не заканчиваются на ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Заметки не начинаются с ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Счёт-источник не ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Счёт-источник не содержит ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Счёт-источник не заканчивается на ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Счёт-источник не начинается с ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Номер счёта-источника / IBAN не ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Счет назначения не является ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Счет назначения не содержит ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Счет назначения не заканчивается ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Счет назначения не начинается с ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Номер счета назначения / IBAN не ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Номер счета назначения / IBAN не содержит ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Номер счета назначения / IBAN не заканчивается на ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Номер счета назначения / IBAN не начинается с ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Категория не ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Категория не содержит ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Категория не заканчивается ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Категория не начинается с ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Бюджет не ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Бюджет не содержит ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Бюджет не заканчивается ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Бюджет не начинается с ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Подписка не является ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Подписка не содержит ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Подписка не заканчивается ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Подписка не заканчивается на ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Валюта не ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'ID транзакции не является ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'ID журнала транзакций не является ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Дата не ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Дата не до ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Дата не после ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Дата выставления счета не ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Дата счета не до ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Дата счета не после ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Транзакция не создана в ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Транзакция не сверена',
    'rule_trigger_not_exists'                             => 'Транзакция не существует',
    'rule_trigger_not_has_attachments'                    => 'У транзакции нет вложений',
    'rule_trigger_not_has_any_category'                   => 'У транзакции нет категории',
    'rule_trigger_not_has_any_budget'                     => 'В транзакции не указан бюджет',
    'rule_trigger_not_has_any_bill'                       => 'У транзакции нет подписки',
    'rule_trigger_not_has_any_tag'                        => 'У транзакции нет тегов',
    'rule_trigger_not_any_notes'                          => 'У транзакции нет заметок',
    'rule_trigger_not_any_external_url'                   => 'У транзакции нет внешнего URL',
    'rule_trigger_not_has_no_attachments'                 => 'У транзакции есть (любое) вложение(я)',
    'rule_trigger_not_has_no_category'                    => 'У транзакции есть (любая) категория',
    'rule_trigger_not_has_no_budget'                      => 'У транзакции есть (любой) бюджет',
    'rule_trigger_not_has_no_bill'                        => 'Транзакция содержит (любцю) подписку',
    'rule_trigger_not_has_no_tag'                         => 'У транзакции есть (любой) тег',
    'rule_trigger_not_no_notes'                           => 'У транзакции есть заметки',
    'rule_trigger_not_no_external_url'                    => 'У транзакции есть внешний URL',
    'rule_trigger_not_source_is_cash'                     => 'Счёт-источник не наличный счёт',
    'rule_trigger_not_destination_is_cash'                => 'Счет назначения не наличный счёт',
    'rule_trigger_not_account_is_cash'                    => 'Ни один счет не является наличным',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Баланс целевого счета больше чем..',
    'rule_trigger_destination_balance_gte_choice'         => 'Баланс целевого счета больше или равен..',
    'rule_trigger_destination_balance_is_choice'          => 'Баланс целевого счета точно..',
    'rule_trigger_destination_balance_lt_choice'          => 'Баланс целевого счета меньше чем..',
    'rule_trigger_destination_balance_lte_choice'         => 'Баланс целевого счета меньше или равен..',

    'rule_trigger_source_balance_gt_choice'  => 'Баланс исходного счета больше, чем..',
    'rule_trigger_source_balance_gte_choice' => 'Баланс исходного счета больше или равен..',
    'rule_trigger_source_balance_is_choice'  => 'Баланс исходного счета точно..',
    'rule_trigger_source_balance_lt_choice'  => 'Баланс исходного счета меньше чем..',
    'rule_trigger_source_balance_lte_choice' => 'Баланс исходного счета меньше или равен..',

    'rule_trigger_destination_balance_gt'  => 'Баланс целевого счета больше чем :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Баланс целевого счета больше или равен :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Баланс целевого счета равен :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Баланс целевого счета меньше :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Баланс целевого счета меньше или равен :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Баланс исходного счета больше чем на :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Баланс исходного счета больше или равен :trigger_value',
    'rule_trigger_source_balance_is'           => 'Баланс исходного счета равен :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Баланс исходного счета меньше, чем :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Баланс исходного счета меньше или равен :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Баланс целевого счета меньше или равен :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Баланс целевого счета меньше :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Баланс целевого счета не :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Баланс целевого счета больше или равен :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Баланс целевого счета больше чем :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Баланс исходного счета меньше или равен :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Баланс исходного счета меньше, чем :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Баланс исходного счета не :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Баланс исходного счета больше или равен :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Баланс исходного счета больше чем на :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'УДАЛИТЬ транзакцию(!)',
    'rule_action_delete_transaction'             => 'УДАЛИТЬ транзакцию(!)',
    'rule_action_set_category'                   => 'Назначить категорию ":action_value"',
    'rule_action_clear_category'                 => 'Очистить поле "Категория"',
    'rule_action_set_budget'                     => 'Назначить бюджет ":action_value"',
    'rule_action_clear_budget'                   => 'Очистить поле "Бюджет"',
    'rule_action_add_tag'                        => 'Добавить метку ":action_value"',
    'rule_action_remove_tag'                     => 'Удалить метку ":action_value"',
    'rule_action_remove_all_tags'                => 'Удалить все метки',
    'rule_action_set_description'                => 'Назначить описание ":action_value"',
    'rule_action_append_description'             => 'Добавить в конце описание с ":action_value"',
    'rule_action_prepend_description'            => 'Добавить в начале описание с ":action_value"',
    'rule_action_set_category_choice'            => 'Установить категорию в ..',
    'rule_action_clear_category_choice'          => 'Удалить любую категорию',
    'rule_action_set_budget_choice'              => 'Установить бюджет в ..',
    'rule_action_clear_budget_choice'            => 'Удалить любой бюджет',
    'rule_action_add_tag_choice'                 => 'Добавить метку ..',
    'rule_action_remove_tag_choice'              => 'Удалить метку ..',
    'rule_action_remove_all_tags_choice'         => 'Удалить все метки...',
    'rule_action_set_description_choice'         => 'Задать описание ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Добавить описание с ..',
    'rule_action_prepend_description_choice'     => 'Добавить в начале описания ..',
    'rule_action_set_source_account_choice'      => 'Назначить счёт-источник ..',
    'rule_action_set_source_account'             => 'Назначить счёт-источник :action_value',
    'rule_action_set_destination_account_choice' => 'Установить счет назначения на ..',
    'rule_action_set_destination_account'        => 'Назначить целевой счёт :action_value',
    'rule_action_append_notes_choice'            => 'Добавить в конце заметки ..',
    'rule_action_append_notes'                   => 'Добавить в конце заметки с ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Добавить в начале заметки ..',
    'rule_action_prepend_notes'                  => 'Добавить в начале заметки с ":action_value"',
    'rule_action_clear_notes_choice'             => 'Удалить любые заметки',
    'rule_action_clear_notes'                    => 'Удалить любые заметки',
    'rule_action_set_notes_choice'               => 'Добавить заметку ..',
    'rule_action_link_to_bill_choice'            => 'Ссылка на подписку ..',
    'rule_action_link_to_bill'                   => 'Ссылка на подписку ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Поменять счета источника и назначения (только для переводов!)',
    'rule_action_switch_accounts'                => 'Поменять источник и назначение',
    'rule_action_set_notes'                      => 'Назначить примечания ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Преобразовать транзакцию в доход',
    'rule_action_convert_deposit'                => 'Преобразовать транзакцию в доход с помощью ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Преобразовать транзакцию в расход',
    'rule_action_convert_withdrawal'             => 'Преобразовать транзакцию в расход с помощью ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Преобразовать транзакцию в перевод',
    'rule_action_convert_transfer'               => 'Преобразовать транзакцию в перевод с помощью ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Заменить текущие примечания транзакции описанием',
    'rule_action_move_notes_to_descr_choice'     => 'Заменить текущее описание примечаниями к сделкам',
    'rule_action_append_descr_to_notes'          => 'Добавить описание к заметкам',
    'rule_action_append_notes_to_descr'          => 'Добавить заметки к описанию',
    'rule_action_move_descr_to_notes'            => 'Заменить заметки описанием',
    'rule_action_move_notes_to_descr'            => 'Заменить описание заметками',
    'rule_action_set_amount_choice'              => 'Установить сумму в ..',
    'rule_action_set_amount'                     => 'Установить сумму ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Установить счет назначения (кэш)',
    'rule_action_set_source_to_cash_choice'      => 'Установить исходный счёт (кэш)',
    'rulegroup_for_bills_title'                  => 'Группа правил для подписок',
    'rulegroup_for_bills_description'            => 'Специальная группа правил для всех правил, связанных с подпиской.',
    'rule_for_bill_title'                        => 'Автоматически сгенерированное правило для подписки ":name"',
    'rule_for_bill_description'                  => 'Это правило сгенерировано автоматически, чтобы попытаться совпадать с подпиской ":name".',
    'create_rule_for_bill'                       => 'Создать новое правило для подписки ":name"',
    'create_rule_for_bill_txt'                   => 'Вы только что создали новую подписку под названием «:name», поздравляем! Firefly III может автоматически сопоставлять новые расходы с этой подпиской. Например, каждый раз, когда вы платите за квартиру, подписка «Аренда» будет связана с этим расходом. Таким образом, Firefly III может точно показать вам, какие подписки подлежат оплате, а какие нет. Для этого необходимо создать новое правило. Firefly III заполнил для вас некоторые разумные значения по умолчанию. Убедитесь, что они верны. Если эти значения верны, Firefly III автоматически свяжет нужный расход средств с нужной подпиской. Пожалуйста, проверьте триггеры, чтобы убедиться в их правильности, и добавьте несколько, если они неправильные.',
    'new_rule_for_bill_title'                    => 'Правило подписки ":name"',
    'new_rule_for_bill_description'              => 'Это правило маркирует операции подписки ":name".',

    'new_rule_for_journal_title'                => 'Правило основано на транзакции ":description"',
    'new_rule_for_journal_description'          => 'Это правило основано на транзакции ":description". Под него будут подпадать транзакции, которые точно совпадают.',

    // tags
    'store_new_tag'                             => 'Сохранить новую метку',
    'update_tag'                                => 'Обновить метку',
    'no_location_set'                           => 'Местоположение не указано.',
    'meta_data'                                 => 'Расширенные данные',
    'location'                                  => 'Размещение',
    'location_first_split'                      => 'Расположение для этой транзакции может быть установлено на первой части этой транзакции.',
    'without_date'                              => 'Без даты',
    'result'                                    => 'Результат',
    'sums_apply_to_range'                       => 'Все суммы относятся к выбранному диапазону',
    'mapbox_api_key'                            => 'Чтобы использовать карту, получите ключ API от сервиса <a href="https://www.mapbox.com/">Mapbox</a>. Откройте файл <code>.env</code> и введите этот код в строке <code>MAPBOX_API_KEY = </code>.',
    'press_object_location'                     => 'Щёлкните правой кнопкой мыши или надолго нажмите на сенсорный экран, чтобы установить местоположение объекта.',
    'click_tap_location'                        => 'Нажмите на карту, чтобы добавить местоположение',
    'clear_location'                            => 'Очистить местоположение',
    'delete_all_selected_tags'                  => 'Удалить все выбранные метки',
    'select_tags_to_delete'                     => 'Не забудьте выбрать несколько меток.',
    'deleted_x_tags'                            => 'Удалена :count метка.|Удалено :count меток.',
    'create_rule_from_transaction'              => 'Создать правило на основе транзакции',
    'create_recurring_from_transaction'         => 'Создать повторяющуюся транзакцию, основанную на транзакции',

    // preferences
    'test_notifications_buttons'                => 'Для тестирования конфигурации используйте кнопки ниже. Обратите внимание, что кнопки не имеют контроля за спамом.',
    'dark_mode_option_browser'                  => 'По усмотрению браузера',
    'dark_mode_option_light'                    => 'Всегда светлый',
    'dark_mode_option_dark'                     => 'Всегда тёмный',
    'equal_to_language'                         => '(в соответствии с языком)',
    'dark_mode_preference'                      => 'Тёмный режим',
    'dark_mode_preference_help'                 => 'Когда Firefly III должен использовать тёмный режим?',
    'pref_home_screen_accounts'                 => 'Счета, отображаемые в сводке',
    'pref_home_screen_accounts_help'            => 'Какие счета нужно отображать в сводке на главной странице?',
    'pref_view_range'                           => 'Диапазон просмотра',
    'pref_view_range_help'                      => 'Некоторые графики автоматически сгруппированы по периодам. Ваш бюджет также будет сгруппирован по периодам. Какой период вы предпочитаете?',
    'pref_1D'                                   => 'Один день',
    'pref_1W'                                   => 'Одна неделя',
    'pref_1M'                                   => 'Один месяц',
    'pref_3M'                                   => 'Три месяца (квартал)',
    'pref_6M'                                   => 'Шесть месяцев',
    'pref_1Y'                                   => 'Один год',
    'pref_last365'                              => 'Последний год',
    'pref_last90'                               => 'Последние 90 дней',
    'pref_last30'                               => 'Последние 30 дней',
    'pref_last7'                                => 'Последние 7 дней',
    'pref_YTD'                                  => 'За год до сегодня',
    'pref_QTD'                                  => 'Квартал до сегодняшнего дня',
    'pref_MTD'                                  => 'Месяц до сегодняшнего дня',
    'pref_languages'                            => 'Языки',
    'pref_locale'                               => 'Региональные настройки',
    'pref_languages_help'                       => 'Firefly III поддерживает несколько языков. Какой язык вы предпочитаете?',
    'pref_locale_help'                          => 'Firefly III позволяет устанавливать другие региональные настройки, например форматирование валют, чисел и дат. Записи в этом списке могут не поддерживаться вашей системой. Firefly III не имеет правильных настроек даты для каждой локали; свяжитесь со мной для улучшения.',
    'pref_locale_no_demo'                       => 'Эта функция не будет работать для демо-пользователя.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Параметры финансового года',
    'pref_custom_fiscal_year_label'             => 'Включить',
    'pref_custom_fiscal_year_help'              => 'Для стран, в которых финансовый год начинается не 1 января, а заканчивается не 31 декабря, вы должны указать даты начала и окончания финансового года',
    'pref_fiscal_year_start_label'              => 'Дата начала финансового года',
    'pref_two_factor_auth'                      => 'Многофакторная аутентификация',
    'pref_two_factor_auth_help'                 => 'Когда вы включаете многофакторную аутентификацию (также известную как двухфакторную аутентификацию), вы добавляете дополнительный уровень безопасности вашей учетной записи. Вы входите в систему, используя то, что вы знаете (ваш пароль) и то, что у вас есть (код подтверждения). Проверочные коды создаются приложением на вашем телефоне, таким как Authy или Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Включить многофакторную аутентификацию',
    'pref_two_factor_auth_disabled'             => 'Код подтверждения многофакторной аутентификации удален и отключен',
    'pref_two_factor_auth_remove_it'            => 'Не забудьте удалить учётную запись из своего приложения для аутентификации!',
    'pref_two_factor_auth_code'                 => 'Проверить код',
    'pref_two_factor_auth_code_help'            => 'Отсканируйте QR-код приложением на вашем телефоне, например, Authy или Google Authenticator и введите сгенерированный код. QR-код меняется каждый раз, когда вы посещаете эту страницу. Убедитесь, что вы используете самые последние из них.',
    'pref_two_factor_auth_reset_code'           => 'Сбросить код верификации',
    'pref_two_factor_auth_disable_2fa'          => 'Отключить MFA',
    '2fa_use_secret_instead'                    => 'Если вы не можете отсканировать QR-код, не стесняйтесь использовать вместо него секрет: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Сохраните эти резервные коды для доступа в случае потери устройства.',
    '2fa_already_enabled'                       => 'Многофакторная проверка подлинности уже включена.',
    'wrong_mfa_code'                            => 'Этот код MFA недействителен.',
    'pref_save_settings'                        => 'Сохранить настройки',
    'saved_preferences'                         => 'Настройки сохранены!',
    'preferences_general'                       => 'Основные',
    'preferences_frontpage'                     => 'Сводка',
    'preferences_security'                      => 'Безопасность',
    'preferences_layout'                        => 'Отображение',
    'preferences_notifications'                 => 'Уведомления',
    'pref_home_show_deposits'                   => 'Показывать доходы на главной странице',
    'pref_home_show_deposits_info'              => 'В сводке уже отображаются ваши счета расходов. Нужно ли показывать там также ваши счета доходов?',
    'pref_home_do_show_deposits'                => 'Да, показать их',
    'successful_count'                          => 'из которых :count успешно',
    'list_page_size_title'                      => 'Размер страницы',
    'list_page_size_help'                       => 'Все списки в программе (счета, транзакции и т. п.) будут отображаться с указанным количеством на одну страницу.',
    'list_page_size_label'                      => 'Размер страницы',
    'between_dates'                             => '(:start и :end)',
    'pref_optional_fields_transaction'          => 'Дополнительные поля для транзакций',
    'pref_optional_fields_transaction_help'     => 'По умолчанию при создании новой транзакции включены не все поля (чтобы не создавать беспорядок). Но вы можете включить эти поля, если лично вам они могут быть полезны. Любое поле, которое в последствии будет отключено, будет по-прежнему отображаться, если оно уже заполнено (независимо от данный настроек).',
    'optional_tj_date_fields'                   => 'Поля с датами',
    'optional_tj_other_fields'                  => 'Прочие поля',
    'optional_tj_attachment_fields'             => 'Поля вложений',
    'pref_optional_tj_interest_date'            => 'Дата начисления процентов',
    'pref_optional_tj_book_date'                => 'Дата внесения записи',
    'pref_optional_tj_process_date'             => 'Дата обработки',
    'pref_optional_tj_due_date'                 => 'Срок оплаты',
    'pref_optional_tj_payment_date'             => 'Дата платежа',
    'pref_optional_tj_invoice_date'             => 'Дата выставления счёта',
    'pref_optional_tj_internal_reference'       => 'Внутренняя ссылка',
    'pref_optional_tj_notes'                    => 'Заметки',
    'pref_optional_tj_attachments'              => 'Вложения',
    'pref_optional_tj_external_url'             => 'Внешний URL',
    'pref_optional_tj_location'                 => 'Расположение',
    'pref_optional_tj_links'                    => 'Связи транзакции',
    'optional_field_meta_dates'                 => 'Даты',
    'optional_field_meta_business'              => 'Бизнес',
    'optional_field_attachments'                => 'Вложения',
    'optional_field_meta_data'                  => 'Расширенные данные',
    'external_url'                              => 'Внешний URL-адрес',
    'pref_notification_login_failure'           => 'Ошибка входа',
    'pref_notification_bill_reminder'           => 'Напоминание об истекающих подписках',
    'pref_notification_new_access_token'        => 'Оповещения о создании нового токена для доступа к API',
    'pref_notification_transaction_creation'    => 'Предупреждения об автоматически созданных транзакциях',
    'pref_notification_user_login'              => 'Оповещение при входе в аккаунт из нового места',
    'pref_notification_rule_action_failures'    => 'Оповещение, когда действия правил не выполняются (не через электронную почту)',
    'pref_notification_new_password'            => 'Ваш пароль изменен',
    'pref_notification_enabled_mfa'             => 'Мультифакторная аутентификация включена',
    'pref_notification_disabled_mfa'            => 'Мультифакторная аутентификация отключена',
    'pref_notification_few_left_mfa'            => 'У вас осталось всего несколько резервных кодов',
    'pref_notification_no_left_mfa'             => 'У вас нет резервных кодов',
    'pref_notification_many_failed_mfa'         => 'Мультифакторная проверка аутентификации провалена',
    'pref_notification_new_backup_codes'        => 'Новые резервные коды были созданы',
    'pref_notifications'                        => 'Уведомления',
    'pref_notifications_help'                   => 'Укажите, какие из перечисленных уведомлений вы хотели бы получать. Некоторые уведомления могут содержать конфиденциальную финансовую информацию.',
    'pref_notifications_settings'               => 'Настройки уведомлений',
    'pref_notifications_settings_help'          => 'Используйте эти настройки для настройки каналов уведомлений. Пожалуйста, обратите внимание, что уведомления будут отправляться во все каналы. Пожалуйста, сначала сохраните настройки.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'URL-адрес веб-хука Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Курсы валют',
    'header_exchange_rates'                     => 'Курсы валют',
    'exchange_rates_intro'                      => 'Firefly III поддерживает загрузку и использование курсов обмена. Подробнее об этом читайте в <a href="https://docs.firefly-iii.org/LOL_NOT_FINISHED_YET_TODO">документации</a>.',
    'exchange_rates_from_to'                    => 'Между {from} и {to} (и наоборот)',
    'header_exchange_rates_rates'               => 'Курсы валют',
    'exchange_rates_intro_rates'                => 'Firefly III использует следующие обменные курсы. Обратный курс автоматически рассчитывается, когда он не установлен. Если на дату сделки не существует обменного курса, то Firefly III вернется в нужное время. Если их нет, будет использован курс "1".',
    'header_exchange_rates_table'               => 'Таблица с обменными курсами',
    'help_rate_form'                            => 'В этот день сколько {to} вы получите за одного {from}?',
    'save_new_rate'                             => 'Сохранить новый тариф',
    'add_new_rate'                              => 'Добавить новый обменный курс',
    'not_enough_currencies'                     => 'Недостаточное количество единиц валют',
    'not_enough_currencies_enabled'             => 'Если включена только одна валюта, нет необходимости добавлять курсы валют.',

    // Financial administrations
    'administration_index'                      => 'Управление финансами',
    'administrations_breadcrumb'                => 'Фин. администраторы',
    'administrations_page_title'                => 'Финансовые администраторы',
    'administrations_index_menu'                => 'Финансовые администраторы',
    'administrations_page_sub_title'            => 'Общий обзор',
    'create_administration'                     => 'Создать новую администрацию',
    'administration_owner'                      => 'Владелец администрации: {{email}}',
    'administration_you'                        => 'Ваша роль: {{role}}',
    'other_users_in_admin'                      => 'Другие пользователи в администрации',
    'administrations_create_breadcrumb'         => 'Новая фин. администрация',
    'administrations_page_create_sub_title'     => 'Создать новую финансовую администрацию',
    'basic_administration_information'          => 'Основная информация об администрации',
    'new_administration_created'                => 'Создана новая финансовая администрация "{{title}}"',
    'edit_administration_breadcrumb'            => 'Изменить фин. администрацию ":title"',
    'administrations_page_edit_sub_title'       => 'Изменить финансовую администрацию ":title"',
    'administrations_page_edit_sub_title_js'    => 'Редактировать управление финансами "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Администрация ":title" обновлена',
    'flash_administration_created'              => 'Администрация ":title" создана',
    'flash_administration_deleted'              => 'Администрация ":title" удалена',

    // roles
    'administration_role_owner'                 => 'Владелец',
    'administration_role_ro'                    => 'Только чтение',
    'administration_role_mng_trx'               => 'Управление транзакциями',
    'administration_role_mng_meta'              => 'Управление классификацией и метаданными',
    'administration_role_mng_budgets'           => 'Управление бюджетами',
    'administration_role_mng_piggies'           => 'Управление копилками',
    'administration_role_mng_subscriptions'     => 'Управление подписками',
    'administration_role_mng_rules'             => 'Управление правилами',
    'administration_role_mng_recurring'         => 'Управление повторяющимися операциями',
    'administration_role_mng_webhooks'          => 'Управление вебхуками',
    'administration_role_mng_currencies'        => 'Управление валютами',
    'administration_role_view_reports'          => 'Просмотр отчетов',
    'administration_role_full'                  => 'Полный доступ',

    // mfa
    'enable_mfa'                                => 'Включить многофакторную аутентификацию',
    'mfa_index_title'                           => 'Многофакторная аутентификация',
    'mfa_index_intro'                           => 'Firefly III поддерживает многофакторную аутентификацию (MFA). Вы можете включить MFA для вашего аккаунта, чтобы добавить дополнительный уровень безопасности. Такие приложения, как Authy, Google Authenticator и FreeOTP могут быть использованы для генерации кодов, которые вам необходимы для входа. Ключи безопасности не поддерживаются Firefly III, но вы можете использовать ключ безопасности в качестве устройства хранения для вашего MFA секрета.',
    'mfa_index_enabled'                         => 'Для вашей учетной записи включена многофакторная аутентификация.',
    'mfa_index_disabled'                        => 'Многофакторная аутентификация не включена для вашей учётной записи.',
    'mfa_index_owner'                           => 'Владелец этого экземпляра всегда сможет отключить многофакторную аутентификацию для вашей учетной записи.',
    'current_password_confirm_mfa'              => 'Введите ваш текущий пароль',
    'mfa_warning_code_changes'                  => 'Вы можете получить диалоговое окно MFA после ввода пароля и MFA кода. В этом случае, пожалуйста, дождитесь появления приложения нового MFA кода и не утилизируйте тот, который вы только что использовали.',
    'mfa_already_disabled'                      => 'Многофакторная аутентификация выключена, поэтому вы не можете отключить ее.',
    'disable_mfa_page'                          => 'Отключить многофакторную аутентификацию',
    'disable_mfa_intro'                         => 'Вы можете отключить многофакторную аутентификацию. Для этого введите свой пароль и многофакторный код аутентификации. Если вы хотите отключить многофакторную аутентификацию, потому что вы потеряли доступ к генератору вашего кода, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">пожалуйста, обратитесь к документации</a>.',
    'pref_disable_mfa'                          => 'Отключить многофакторную аутентификацию',
    'mfa_not_enabled'                           => 'Многофакторная аутентификация выключена.',
    'mfa_backup_codes_intro'                    => 'Firefly III может создавать резервные коды для вас. Эти коды могут быть использованы для входа, когда вы не можете использовать ваш генератор кода. Вы можете сгенерировать новый набор кодов в любое время. Если вы сгенерируете новый набор, старый набор будет аннулирован.',
    'mfa_backup_codes_quick'                    => 'Если вы очень быстро пришли со страницы установки многофакторной аутентификации, то ваше приложение может не сгенерировать новый код. Пожалуйста, имейте в виду, что коды MFA могут быть использованы только один раз. Убедитесь, что вы используете другой код от предыдущего.',
    'mfa_backup_codes_title'                    => 'Резервные коды многофакторной аутентификации',
    'mfa_backup_codes_post_title'               => 'Резервные коды многофакторной аутентификации',

    // profile:
    'manage_mfa_settings'                       => 'Управление настройками многофакторной аутентификации',
    'purge_data_title'                          => 'Уничтожить данные из Firefly III',
    'purge_data_expl'                           => '"Уничтожение" - это полное "удаление того, что уже было удалено". Обычно Firefly III ничего не удаляет полностью. Он просто скрывает данные. Кнопка ниже удаляет все эти ранее "удалённые" записи НАВСЕГДА.',
    'delete_stuff_header'                       => 'Удалить и уничтожить данные',
    'purge_all_data'                            => 'Уничтожить все записи',
    'purge_data'                                => 'Уничтожить данные',
    'purged_all_records'                        => 'Все удалённые записи будут полностью уничтожены.',
    'delete_data_title'                         => 'Удалить данные из Firefly III',
    'permanent_delete_stuff'                    => 'Вы можете удалить данные из Firefly III. Использование кнопок ниже означает, что ваши данные больше не будут видны в Firefly. Вы не сможете отменить эту операцию из интерфейса Firefly, но записи могут остаться в базе данных, и вы сможете их восстановить при необходимости.',
    'other_sessions_logged_out'                 => 'Все прочие ваши сессии были прекращены.',
    'delete_unused_accounts'                    => 'Удаление неиспользуемых учетных записей очистит ваши автоматически заполненные списки.',
    'delete_all_unused_accounts'                => 'Удалить неиспользуемые учётные записи',
    'deleted_all_unused_accounts'               => 'Все неиспользуемые учетные записи удалены',
    'delete_all_budgets'                        => 'Удалить ВСЕ ваши бюджеты',
    'delete_all_categories'                     => 'Удалить ВСЕ ваши категории',
    'delete_all_tags'                           => 'Удалить ВСЕ ваши метки',
    'delete_all_bills'                          => 'Удалить ВСЕ ваши подписки',
    'delete_all_piggy_banks'                    => 'Удалите ВСЕ ваши копилки',
    'delete_all_rules'                          => 'Удалить ВСЕ ваши правила',
    'delete_all_recurring'                      => 'Удалить ВСЕ ваши повторяющиеся транзакции',
    'delete_all_object_groups'                  => 'Удалить все ваши группы объектов',
    'delete_all_accounts'                       => 'Удалить ВСЕ ваши счета',
    'delete_all_asset_accounts'                 => 'Удалить ВСЕ ваши основные счета',
    'delete_all_expense_accounts'               => 'Удалить ВСЕ счета расходов',
    'delete_all_revenue_accounts'               => 'Удалить ВСЕ ваши счета доходов',
    'delete_all_liabilities'                    => 'Удалить ВСЕ ваши обязательства',
    'delete_all_transactions'                   => 'Удалить все ваши транзакции',
    'delete_all_withdrawals'                    => 'Удалить ВСЕ ваши расходы',
    'delete_all_deposits'                       => 'Удалить ВСЕ ваши доходы',
    'delete_all_transfers'                      => 'Удалить ВСЕ ваши переводы',
    'also_delete_transactions'                  => 'Удаление счетов приведёт к удалению ВСЕХ связанных расходов, доходов и переводов!',
    'deleted_all_budgets'                       => 'Все бюджеты были удалены',
    'deleted_all_categories'                    => 'Все категории были удалены',
    'deleted_all_tags'                          => 'Все метки были удалены',
    'deleted_all_bills'                         => 'Все подписки были удалены',
    'deleted_all_piggy_banks'                   => 'Все копилки были удалены',
    'deleted_all_rules'                         => 'Все правила и группы правил были удалены',
    'deleted_all_object_groups'                 => 'Все группы были удалены',
    'deleted_all_accounts'                      => 'Все счета были удалены',
    'deleted_all_asset_accounts'                => 'Все основные счета были удалены',
    'deleted_all_expense_accounts'              => 'Все счета расходов были удалены',
    'deleted_all_revenue_accounts'              => 'Все счета доходов были удалены',
    'deleted_all_liabilities'                   => 'Все обязательства были удалены',
    'deleted_all_transactions'                  => 'Все транзакции были удалены',
    'deleted_all_withdrawals'                   => 'Все расходы были удалены',
    'deleted_all_deposits'                      => 'Все доходы были удалены',
    'deleted_all_transfers'                     => 'Все переводы были удалены',
    'deleted_all_recurring'                     => 'Все повторяющиеся операции были удалены',
    'change_your_password'                      => 'Изменить ваш пароль',
    'delete_account'                            => 'Удалить профиль',
    'current_password'                          => 'Текущий пароль',
    'new_password'                              => 'Новый пароль',
    'new_password_again'                        => 'Новый пароль (ещё раз)',
    'delete_your_account'                       => 'Удалить ваш профиль',
    'delete_your_account_help'                  => 'При удалении вашего профиля также будут удалены все счета, транзакции. Не будет сохранено <em>ничего</em>, что вы хранили в Firefly III. Всё будет УТЕРЯНО!',
    'delete_your_account_password'              => 'Для продолжения введите свой пароль.',
    'password'                                  => 'Пароль',
    'are_you_sure'                              => 'Вы уверены? Эту операцию нельзя будет отменить.',
    'are_you_sure_confirm'                      => 'Вы уверены?',
    'delete_account_button'                     => 'УДАЛИТЬ ваш профиль',
    'invalid_current_password'                  => 'Неправильный пароль!',
    'password_changed'                          => 'Пароль изменён!',
    'should_change'                             => 'Кажется, нужно изменить пароль.',
    'invalid_password'                          => 'Неверный пароль!',
    'what_is_pw_security'                       => 'Что такое «проверка безопасности паролей»?',
    'secure_pw_title'                           => 'Как выбрать безопасный пароль',
    'forgot_password_response'                  => 'Спасибо. Если существует учетная запись с этим адресом электронной почты, вы найдете инструкции в вашем почтовом ящике.',
    'secure_pw_history'                         => 'Каждую неделю вы читаете в новостях о сайтах, теряющих пароли своих пользователей. Хакеры и воры используют эти пароли, чтобы попытаться украсть вашу личную информацию. Эта информация является ценной.',
    'secure_pw_ff'                              => 'Вы используете один и тот же пароль по всему Интернету? Если один сайт потеряет ваш пароль, хакеры получат полный доступ ко всем вашим данным. Firefly III надеется, что вы выберите хороший и уникальный пароль для защиты своих финансовых данных.',
    'secure_pw_check_box'                       => 'Чтобы помочь вам, Firefly III может проверить, был ли использован пароль, который вы хотите использовать, где-то ещё. Если это так, Firefly III советует вам НЕ использовать такой пароль.',
    'secure_pw_working_title'                   => 'Как это работает?',
    'secure_pw_working'                         => 'Если вы установите данный флажок, Firefly III отправит первые 5 символов SHA1-хэша вашего пароля на <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">сайт Troy Hunt</a>, чтобы узнать, есть ли он в списке. Согласно рекомендациям по данному вопросу, опубликованным недавно в <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Special Publication</a>, такая проверка защитит вас от использования небезопасных паролей.',
    'secure_pw_should'                          => 'Должен ли я установить флажок?',
    'secure_pw_long_password'                   => 'Да. Всегда проверять безопасность моего пароля.',
    'command_line_token'                        => 'Токен командной строки',
    'explain_command_line_token'                => 'Этот токен необходим для выполнения операций из командной строки (таких как экспорт данных). Без него эта чувствительная команда не будет работать. Не показывайте никому свой токен. Никто не попросит у вас эту информацию, даже я. Если вы боитесь, что потеряли этот токен, или у вас паранойя, вы можете сгенерировать новый токен с помощью этой кнопки.',
    'regenerate_command_line_token'             => 'Сгенерировать новый токен командной строки',
    'token_regenerated'                         => 'Новый токен командной строки сгенерирован',
    'change_your_email'                         => 'Изменить ваш адрес электронной почты',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Пока вы не подтвердите свой адрес электронной почты, вы не сможете войти в систему.',
    'login_with_new_email'                      => 'Теперь вы можете войти с новым адресом электронной почты.',
    'login_with_old_email'                      => 'Теперь вы можете снова войти со своим старым адресом электронной почты.',
    'login_provider_local_only'                 => 'Это действие недоступно при аутентификации через ":login_provider".',
    'external_user_mgt_disabled'                => 'Это действие недоступно, если Firefly III не отвечает за управление пользователями или обработку аутентификации.',
    'external_auth_disabled'                    => 'Это действие недоступно, если Firefly III не отвечает за обработку аутентификации.',
    'delete_local_info_only'                    => "Поскольку Firefly III не отвечает за управление пользователями или обработку аутентификации, эта функция будет удалять только локальную информацию Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Клиенты OAuth',
    'profile_oauth_no_clients'                  => 'У вас пока нет клиентов OAuth.',
    'profile_oauth_clients_external_auth'       => 'Если вы используете внешний поставщик аутентификации, например Authelia, клиенты OAuth не будут работать. Вы можете использовать только персональные токены доступа.',
    'profile_oauth_clients_header'              => 'Клиенты',
    'profile_oauth_client_id'                   => 'ID клиента',
    'profile_oauth_client_name'                 => 'Название',
    'profile_oauth_client_secret'               => 'Секретный ключ',
    'profile_oauth_create_new_client'           => 'Создать нового клиента',
    'profile_oauth_create_client'               => 'Создать клиента',
    'profile_oauth_edit_client'                 => 'Изменить клиента',
    'profile_oauth_name_help'                   => 'Что-то, что ваши пользователи знают, и чему доверяют.',
    'profile_oauth_redirect_url'                => 'URL редиректа',
    'profile_oauth_redirect_url_help'           => 'URL обратного вызова для вашего приложения.',
    'profile_authorized_apps'                   => 'Авторизованные приложения',
    'profile_authorized_clients'                => 'Авторизованные клиенты',
    'profile_scopes'                            => 'Разрешения',
    'profile_revoke'                            => 'Отключить',
    'profile_oauth_client_secret_title'         => 'Ключ клиента',
    'profile_oauth_client_secret_expl'          => 'Вот ваш новый ключ клиента. Он будет показан вам только сейчас, поэтому не потеряйте его! Теперь вы можете использовать этот ключ, чтобы делать запросы по API.',
    'profile_personal_access_tokens'            => 'Персональные Access Tokens',
    'profile_personal_access_token'             => 'Персональный Access Token',
    'profile_oauth_confidential'                => 'Конфиденциальный',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Вот ваш новый персональный токен доступа. Он будет показан вам только сейчас, поэтому не потеряйте его! Теперь вы можете использовать этот токен, чтобы делать запросы по API.',
    'profile_no_personal_access_token'          => 'Вы не создали ни одного персонального токена доступа.',
    'profile_create_new_token'                  => 'Создать новый токен',
    'profile_create_token'                      => 'Создать токен',
    'profile_create'                            => 'Создать',
    'profile_save_changes'                      => 'Сохранить изменения',
    'profile_whoops'                            => 'Ууупс!',
    'profile_something_wrong'                   => 'Что-то пошло не так!',
    'profile_try_again'                         => 'Произошла ошибка. Пожалуйста, попробуйте снова.',
    'amounts'                                   => 'Сумма',
    'multi_account_warning_unknown'             => 'В зависимости от типа транзакции, которую вы создаёте, счёт-источник и/или счёт назначения следующих частей разделённой транзакции могут быть заменены теми, которые указаны для первой части транзакции.',
    'multi_account_warning_withdrawal'          => 'Имейте в виду, что счёт-источник в других частях разделённой транзакции будет таким же, как в первой части расхода.',
    'multi_account_warning_deposit'             => 'Имейте в виду, что счёт назначения в других частях разделённой транзакции будет таким же, как в первой части дохода.',
    'multi_account_warning_transfer'            => 'Имейте в виду, что счёт-источник и счёт назначения в других частях разделённой транзакции будут такими же, как в первой части перевода.',


    // export data:
    'export_data_title'                         => 'Экспорт данных из Firefly III',
    'export_data_menu'                          => 'Экспорт данных',
    'export_data_bc'                            => 'Экспорт данных из Firefly III',
    'export_data_main_title'                    => 'Экспорт данных из Firefly III',
    'export_data_expl'                          => 'Эта ссылка позволяет вам экспортировать все транзакции и мета-данные из Firefly III. Подробную информацию об экспорте вы можете получить в справке (см. значок (?) в правом верхнем углу).',
    'export_data_all_transactions'              => 'Экспорт всех транзакций',
    'export_data_advanced_expl'                 => 'Если вам нужен более продвинутый или конкретный тип экспорта, прочтите справку о том, как использовать команду консоли <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Одно вложение |:count вложений',
    'attachments'                               => 'Вложения',
    'edit_attachment'                           => 'Изменить вложение ":name"',
    'update_attachment'                         => 'Обновить вложение',
    'delete_attachment'                         => 'Удалить вложение ":name"',
    'attachment_deleted'                        => 'Вложение ":name" удалено',
    'liabilities_deleted'                       => 'Долговой счёт ":name" удалён',
    'attachment_updated'                        => 'Вложение ":name" обновлено',
    'upload_max_file_size'                      => 'Максимальный размер файла: :size',
    'list_all_attachments'                      => 'Список всех вложений',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Поскольку эта транзакция сверяется, вам необходимо удалить флаг сверки для обновления счета или суммы.',
    'is_reconciled'                             => 'Сверено',
    'title_expenses'                            => 'Расходы',
    'title_withdrawal'                          => 'Расходы',
    'title_revenue'                             => 'Доход',
    'title_deposit'                             => 'Доход',
    'title_transfer'                            => 'Переводы',
    'title_transfers'                           => 'Переводы',
    'submission_options'                        => 'Опции отправки',
    'apply_rules_checkbox'                      => 'Применить правила',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Пожалуйста, выберите или введите корректное имя счета источника',
    'select_dest_account'                       => 'Пожалуйста, выберите или введите правильное имя счета назначения',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Эта транзакция уже является расходом',
    'convert_is_already_type_Deposit'           => 'Эта транзакция уже является доходом',
    'convert_is_already_type_Transfer'          => 'Эта транзакция уже является переводом',
    'convert_to_Withdrawal'                     => 'Преобразовать ":description" в расход',
    'convert_to_Deposit'                        => 'Преобразовать ":description" в доход',
    'convert_to_Transfer'                       => 'Преобразовать ":description" в перевод',
    'convert_options_WithdrawalDeposit'         => 'Преобразовать расход в доход',
    'convert_options_WithdrawalTransfer'        => 'Преобразовать расход в перевод',
    'convert_options_DepositTransfer'           => 'Преобразовать доход в перевод',
    'convert_options_DepositWithdrawal'         => 'Преобразовать доход в расход',
    'convert_options_TransferWithdrawal'        => 'Преобразовать перевод в расход',
    'convert_options_TransferDeposit'           => 'Преобразовать перевод в доход',
    'convert_Withdrawal_to_deposit'             => 'Преобразовать этот расход в доход',
    'convert_Withdrawal_to_transfer'            => 'Преобразовать этот расход в перевод',
    'convert_Deposit_to_withdrawal'             => 'Преобразовать этот доход в расход',
    'convert_Deposit_to_transfer'               => 'Преобразовать этот доход в перевод',
    'convert_Transfer_to_deposit'               => 'Преобразовать этот перевод в доход',
    'convert_Transfer_to_withdrawal'            => 'Преобразовать этот перевод в расход',
    'convert_please_set_revenue_source'         => 'Пожалуйста, выберите счёт доходов, с которого поступят деньги.',
    'convert_please_set_asset_destination'      => 'Пожалуйста, выберите основной счёт, на который будут переведены деньги.',
    'convert_please_set_expense_destination'    => 'Пожалуйста, выберите счёт расходов, на который будут направлены деньги.',
    'convert_please_set_asset_source'           => 'Пожалуйста, выберите основной счёт, с которого поступят деньги.',
    'convert_expl_w_d'                          => 'При преобразовании расхода в доход, средства будут внесены на указанный счёт, а не списаны с него.|При преобразовании расхода в доход, средства будут внесены на указанные счета, а не списаны с них.',
    'convert_expl_w_t'                          => 'При преобразовании расхода в перевод, средства будут переведены с исходного счёта на другой основной счёт или вклад, а не просто списаны с исходного счёта расходов.|При преобразовании расхода в перевод, средства будут переведены с исходных счётов на другие основные счета или вклады, а не просто списаны с исходных счетов расходов.',
    'convert_expl_d_w'                          => 'При преобразовании дохода в расход, средства будут списаны с указанного счёта-источника, а не внесены на него.|При преобразовании дохода в расход, средства будут списаны с указанных счетов-источников, а не внесены на них.',
    'convert_expl_d_t'                          => 'При преобразовании дохода в перевод, средства будут начислены на счёт назначения с любого из ваших активов или обязательств.|При преобразовании дохода в перевод, средства будут начислены на счета назначения с любого из ваших активов или обязательств.',
    'convert_expl_t_w'                          => 'При преобразовании перевода в расход, средства будут списаны с указанного вами счёта назначения, а не переведены на него.|При преобразовании перевода в расход, средства будут списаны с указанных вами счетов назначения, а не переведены на них.',
    'convert_expl_t_d'                          => 'При преобразовании перевода в доход, средства будут начислены на указанный счёт назначения, а не переведены на него.|При преобразовании перевода в доход, средства будут начислены на указанные счета назначения, а не переведены на них.',
    'convert_select_sources'                    => 'Для завершения преобразования, укажите новый счёт назначения.|Для завершения преобразования, укажите новые счета назначения.',
    'convert_select_destinations'               => 'Для завершения преобразования, выберите новый счёт назначения.|Для завершения преобразования, выберите новые счета назначения.',
    'converted_to_Withdrawal'                   => 'Транзакция была преобразована в расход',
    'converted_to_Deposit'                      => 'Транзакция была преобразована в доход',
    'converted_to_Transfer'                     => 'Транзакция была преобразована в перевод',
    'invalid_convert_selection'                 => 'Выбранный вами счёт уже используется в этой транзакции или не существует.',
    'source_or_dest_invalid'                    => 'Не удается найти правильные сведения о транзакции. Преобразование невозможно.',
    'convert_to_withdrawal'                     => 'Преобразовать в расход',
    'convert_to_deposit'                        => 'Преобразовать в доход',
    'convert_to_transfer'                       => 'Преобразовать в перевод',

    // create new stuff:
    'create_new_withdrawal'                     => 'Создать новый расход',
    'create_new_deposit'                        => 'Создать новый доход',
    'create_new_transfer'                       => 'Создать новый перевод',
    'create_new_asset'                          => 'Создать новый активный счёт',
    'create_new_liabilities'                    => 'Создать новый долговой счёт',
    'create_new_expense'                        => 'Создать новый счёт расхода',
    'create_new_revenue'                        => 'Создать новый счёт дохода',
    'create_new_piggy_bank'                     => 'Создать новую копилку',
    'create_new_bill'                           => 'Создать новую подписку',
    'create_new_subscription'                   => 'Создать новую подписку',
    'create_new_rule'                           => 'Создать новое правило',

    // currencies:
    'create_currency'                           => 'Создать новую валюту',
    'store_currency'                            => 'Сохранить новую валюту',
    'update_currency'                           => 'Обновить валюту',
    'new_default_currency'                      => '":name" сейчас валюта по умолчанию.',
    'default_currency_failed'                   => 'Не удалось сделать ":name" валютой по умолчанию. Пожалуйста, проверьте журналы (логи).',
    'cannot_delete_currency'                    => 'Невозможно удалить валюту :name, поскольку она используется.',
    'cannot_delete_fallback_currency'           => ':name - это системная резервная валюта, она не может быть удалена.',
    'cannot_disable_currency_journals'          => 'Не удается отключить валюту :name, потому что она была использована в транзакциях.',
    'cannot_disable_currency_last_left'         => 'Не удается отключить валюту :name, потому что это последняя активная валюта.',
    'cannot_disable_currency_account_meta'      => 'Невозможно отключить валюту :name, поскольку она используется для одного из счетов.',
    'cannot_disable_currency_bills'             => 'Невозможно отключить :name , потому что он используется в подписках.',
    'cannot_disable_currency_recurring'         => 'Невозможно отключить валюту :name, поскольку она используется для повторяющейся транзакции.',
    'cannot_disable_currency_available_budgets' => 'Невозможно отключить валюту :name, поскольку она используется в бюджете.',
    'cannot_disable_currency_budget_limits'     => 'Невозможно отключить валюту :name, поскольку она используется в лимите для бюджета.',
    'cannot_disable_currency_current_default'   => 'Невозможно отключить валюту :name, поскольку это текущая валюта по умолчанию.',
    'cannot_disable_currency_system_fallback'   => 'Невозможно отключить валюту :name, поскольку это системная валюта по умолчанию.',
    'disable_EUR_side_effects'                  => 'Евро является аварийной резервной валютой системы. Её отключение может иметь непредвиденные побочные эффекты и может привести к потере гарантии.',
    'deleted_currency'                          => 'Валюта :name удалена',
    'created_currency'                          => 'Валюта :name создана',
    'could_not_store_currency'                  => 'Невозможно сохранить новую валюту.',
    'updated_currency'                          => 'Валюта :name обновлена',
    'ask_site_owner'                            => 'Пожалуйста, обратитесь к :owner для добавления, удаления или изменения валюты.',
    'currencies_intro'                          => 'Firefly III может работать с несколькими валютами. Вы можете управлять ими здесь.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Сделать основной',
    'default_currency'                          => 'основная',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Отключена',
    'enable_currency'                           => 'Включить',
    'disable_currency'                          => 'Отключить',
    'currencies_default_disabled'               => 'Большинство этих валют по умолчанию отключены. Для использования, сначала включите их.',
    'currency_is_now_enabled'                   => 'Валюта ":name" была включена',
    'could_not_enable_currency'                 => 'Не удалось включить валюту ":name". Пожалуйста, просмотрите журналы.',
    'currency_is_now_disabled'                  => 'Валюта ":name" была отключена',
    'could_not_disable_currency'                => 'Не удалось отключить валюту ":name". Возможно, она все еще используется?',

    // forms:
    'mandatoryFields'                           => 'Обязательные поля',
    'optionalFields'                            => 'Дополнительные поля',
    'options'                                   => 'Параметры',

    // budgets:
    'daily_budgets'                             => 'Бюджеты на день',
    'weekly_budgets'                            => 'Бюджеты на неделю',
    'monthly_budgets'                           => 'Бюджеты на месяц',
    'quarterly_budgets'                         => 'Бюджеты на квартал',
    'half_year_budgets'                         => 'Бюджеты на полгода',
    'yearly_budgets'                            => 'Годовые бюджеты',
    'other_budgets'                             => 'Бюджеты на произвольный отрезок времени',
    'budget_limit_not_in_range'                 => 'Эта сумма действует с :start по :end:',
    'total_available_budget'                    => 'Общий доступный бюджет (между :start и :end)',
    'total_available_budget_in_currency'        => 'Всего доступно в бюджете (:currency)',
    'see_below'                                 => 'см. ниже',
    'create_new_budget'                         => 'Создать новый бюджет',
    'store_new_budget'                          => 'Сохранить новый бюджет',
    'stored_new_budget'                         => 'Новый бюджет ":name" сохранён',
    'available_between'                         => 'Доступно между :start и :end',
    'transactionsWithoutBudget'                 => 'Расходы вне бюджета',
    'transactions_no_budget'                    => 'Расходы вне бюджета между :start и :end',
    'spent_between'                             => 'Уже потрачено между :start и :end',
    'spent_between_left'                        => 'Потрачено :spent между :start и :end, осталось :left.',
    'set_available_amount'                      => 'Установить доступную сумму',
    'update_available_amount'                   => 'Обновить доступную сумму',
    'ab_basic_modal_explain'                    => 'Используйте эту форму, чтобы указать какой бюджет вы планируете (всего, в :currency) на указанный период.',
    'createBudget'                              => 'Новый бюджет',
    'invalid_currency'                          => 'Это неверная валюта',
    'invalid_amount'                            => 'Пожалуйста, введите сумму',
    'set_ab'                                    => 'Доступная сумма бюджета была установлена',
    'updated_ab'                                => 'Доступная сумма бюджета была обновлена',
    'deleted_ab'                                => 'Доступная сумма бюджета была удалена',
    'deleted_bl'                                => 'Запланированная в бюджете сумма была удалена',
    'alt_currency_ab_create'                    => 'Установите доступный бюджет в другой валюте',
    'bl_create_btn'                             => 'Установите бюджет в другой валюте',
    'inactiveBudgets'                           => 'Неактивные бюджеты',
    'without_budget_between'                    => 'Транзакции вне бюджета между :start и :end',
    'delete_budget'                             => 'Удалить бюджет ":name"',
    'deleted_budget'                            => 'Бюджет ":name" удалён',
    'edit_budget'                               => 'Редактировать бюджет ":name"',
    'updated_budget'                            => 'Бюджет ":name" обновлён',
    'update_amount'                             => 'Обновить сумму',
    'update_budget'                             => 'Обновить бюджет',
    'update_budget_amount_range'                => 'Обновить (ожидаемые) доступные средства между :start и :end',
    'set_budget_limit_title'                    => 'Установите сумму для :budget между :start и :end',
    'set_budget_limit'                          => 'Установите сумму в бюджете',
    'budget_period_navigator'                   => 'Навигация по периодам',
    'info_on_available_amount'                  => 'Сколько средств у меня есть?',
    'available_amount_indication'               => 'Используйте эти суммы, чтобы узнать, каким может быть ваш суммарный бюджет.',
    'suggested'                                 => 'Рекомендуемые',
    'average_between'                           => 'В среднем между :start и :end',
    'transferred_in'                            => 'Переведено (в)',
    'transferred_away'                          => 'Переведено (из)',
    'auto_budget_none'                          => 'Без автобюджета',
    'auto_budget_reset'                         => 'Задать фиксированную сумму на каждый период',
    'auto_budget_rollover'                      => 'Добавить сумму на каждый период',
    'auto_budget_adjusted'                      => 'Добавьте сумму каждого периода и скорректируйте перерасход',
    'auto_budget_period_daily'                  => 'Ежедневно',
    'auto_budget_period_weekly'                 => 'Еженедельно',
    'auto_budget_period_monthly'                => 'Ежемесячно',
    'auto_budget_period_quarterly'              => 'Ежеквартально',
    'auto_budget_period_half_year'              => 'Раз в полгода',
    'auto_budget_period_yearly'                 => 'Каждый год',
    'auto_budget_help'                          => 'Подробнее об этой функции можно прочитать в справке. Щёлкните по значку (?) в правом верхнем углу.',
    'auto_budget_reset_icon'                    => 'Этот бюджет будет устанавливаться периодически',
    'auto_budget_rollover_icon'                 => 'Доступная в бюджете сумма будет периодически увеличиваться',
    'auto_budget_adjusted_icon'                 => 'Сумма бюджета будет периодически увеличиваться и будет скорректирована в случае перерасхода',
    'remove_budgeted_amount'                    => 'Удалить запланированную в бюджете сумму в :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'осталось заплатить',
    'less_than_expected'                        => 'меньше чем ожидалось',
    'more_than_expected'                        => 'больше чем ожидалось',
    'skip_help_text'                            => 'Используйте поле пропуска для создания двухмесячного (пропуск = 1) или других пользовательских интервалов.',
    'subscription'                              => 'Подписка',
    'not_expected_period'                       => 'Не ожидается в данном периоде',
    'subscriptions_in_group'                    => 'Подписки в группе "{{title}}"',
    'subscr_expected_x_times'                   => 'Ожидается оплата {{amount}} {{times}} раз за этот период',
    'not_or_not_yet'                            => 'Нет (пока)',
    'visit_bill'                                => 'Посетите подписку ":name" на Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Подписка сопоставляет операции между :low и :high.',
    'running_again_loss'                        => 'Ранее связанные операции с этой подпиской могут потерять соединение, если они больше не соответствуют правилам.',
    'bill_related_rules'                        => 'Правила, относящиеся к этой подписке',
    'repeats'                                   => 'Повторы',
    'bill_end_date_help'                        => 'Необязательное поле. Ожидается, что подписка закончится в эту дату.',
    'bill_extension_date_help'                  => 'Необязательное поле. Подписка должна быть продлена (или отменена) не позднее этой даты.',
    'bill_end_index_line'                       => 'Эта подписка заканчивается :date',
    'bill_extension_index_line'                 => 'Эта подписка должна быть продлена или отменена :date',
    'connected_journals'                        => 'Связанные транзакции',
    'auto_match_on'                             => 'Автоматически сверено Firefly III',
    'auto_match_off'                            => 'Не сверено автоматически Firefly III',
    'next_expected_match'                       => 'Следующая сверка ожидается',
    'delete_bill'                               => 'Удалить подписку ":name"',
    'deleted_bill'                              => 'Удалена подписка ":name"',
    'edit_bill'                                 => 'Редактировать подписку ":name"',
    'more'                                      => 'Больше',
    'rescan_old'                                => 'Выполнить правила снова, по всем транзакциям',
    'update_bill'                               => 'Обновить подписку',
    'updated_bill'                              => 'Обновлена подписка ":name"',
    'store_new_bill'                            => 'Сохранить новую подписку',
    'stored_new_bill'                           => 'Сохранена новая подписка ":name"',
    'cannot_scan_inactive_bill'                 => 'Неактивные подписки не могут быть сканированы.',
    'rescanned_bill'                            => 'Проверены :count транзакций, привязанная к этой подписке.|Проверены все :count транзакций, привязанных к этим операциям подписки.',
    'average_bill_amount_year'                  => 'Средняя сумма подписки (:year)',
    'average_bill_amount_overall'               => 'Средняя сумма подписки (за всё время)',
    'bill_is_active'                            => 'Подписка активна',
    'bill_expected_between'                     => 'Ожидается между :start и :end',
    'bill_will_automatch'                       => 'Подписка будет автоматически связана с подходящими транзакциями',
    'skips_over'                                => 'пропустить',
    'bill_store_error'                          => 'Произошла непредвиденная ошибка при сохранении вашей новой подписки. Пожалуйста, проверьте файлы журнала',
    'list_inactive_rule'                        => 'неактивное правило',
    'bill_edit_rules'                           => 'Firefly III попытается отредактировать правило, связанное с этой подпиской. Однако, если вы сами редактировали это правило, Firefly III ничего не изменит.|Firefly III попытается редактировать правила :count, связанные с этой подпиской. Однако, если вы сами редактировали эти правила, Firefly III ничего не изменит.',
    'bill_expected_date'                        => 'Истекает :date',
    'bill_expected_date_js'                     => 'Ожидаемая дата {date}',
    'expected_amount'                           => '(Ожидаемая) сумма',
    'bill_paid_on'                              => 'Оплачено {date}',
    'bill_repeats_weekly'                       => 'Повторяет еженедельно',
    'bill_repeats_monthly'                      => 'Повторять ежемесячно',
    'bill_repeats_quarterly'                    => 'Повторяет ежеквартально',
    'bill_repeats_half-year'                    => 'Повторяется раз в полгода',
    'bill_repeats_yearly'                       => 'Повторяется ежегодно',
    'bill_repeats_weekly_other'                 => 'Повторяется каждую неделю',
    'bill_repeats_monthly_other'                => 'Повторяется каждый месяц',
    'bill_repeats_quarterly_other'              => 'Повторяется каждый квартал',
    'bill_repeats_half-year_other'              => 'Повторяется ежегодно',
    'bill_repeats_yearly_other'                 => 'Повторяется каждый год',
    'bill_repeats_weekly_skip'                  => 'Повторяется каждую {skip} неделю',
    'bill_repeats_monthly_skip'                 => 'Повторяется каждый {skip} месяц',
    'bill_repeats_quarterly_skip'               => 'Повторяется каждый {skip} квартал',
    'bill_repeats_half-year_skip'               => 'Повторяется каждые {skip} полгода',
    'bill_repeats_yearly_skip'                  => 'Повторяется каждые {skip} года',
    'subscriptions'                             => 'Подписки',
    'go_to_subscriptions'                       => 'Перейти к вашим подпискам',
    'forever'                                   => 'Всегда',
    'extension_date_is'                         => 'Дата расширения {date}',

    // accounts:
    'account_locked_currency'                   => 'Валюта этого счета должна оставаться на :name, пока к нему привязаны копилки.',
    'i_am_owed_amount'                          => 'Мне должны сумму',
    'i_owe_amount'                              => 'Я должен сумму',
    'inactive_account_link'                     => 'У вас :count неактивный (архивный) счёт, который вы можете увидеть на этой отдельной странице.|У вас :count неактивных (архивных) счетов, которые вы можете увидеть на этой отдельной странице.',
    'all_accounts_inactive'                     => 'Это ваши неактивные счета.',
    'active_account_link'                       => 'Эта ссылка вернёт вас к вашим активным счетам.',
    'account_missing_transaction'               => 'Счёт #:id (":name") невозможно просмотреть напрямую, и у Firefly нет информации для перенаправления.',
    'cc_monthly_payment_date_help'              => 'Выберите любой год и любой месяц, он будет проигнорирован в любом случае. Только день месяца является актуальным.',
    'details_for_asset'                         => 'Детали по основному счёту ":name"',
    'details_for_expense'                       => 'Детали по счёту расходов ":name"',
    'details_for_revenue'                       => 'Детали по счёту доходов ":name"',
    'details_for_cash'                          => 'Детали по наличному счёту ":name"',
    'store_new_asset_account'                   => 'Сохранить новый основной счёт',
    'store_new_expense_account'                 => 'Сохранить новый счёт расхода',
    'store_new_revenue_account'                 => 'Сохранить новый счёт дохода',
    'edit_asset_account'                        => 'Изменить основной счёт ":name"',
    'edit_expense_account'                      => 'Изменить счёт расходов ":name"',
    'edit_revenue_account'                      => 'Изменить счёт доходов ":name"',
    'delete_asset_account'                      => 'Удалить основной счёт ":name"',
    'delete_expense_account'                    => 'Удалить счёт расходов ":name"',
    'delete_revenue_account'                    => 'Удалить счёт доходов ":name"',
    'delete_liabilities_account'                => 'Удалить долговой счёт ":name"',
    'asset_deleted'                             => 'Основной счёт ":name" успешно удалён',
    'account_deleted'                           => 'Счёт ":name" успешно удалён',
    'expense_deleted'                           => 'Счёт расхода ":name" успешно удалён',
    'revenue_deleted'                           => 'Счёт дохода ":name" успешно удалён',
    'update_asset_account'                      => 'Обновить основной счёт',
    'update_undefined_account'                  => 'Обновить учётную запись',
    'update_liabilities_account'                => 'Обновить долговой счёт',
    'update_expense_account'                    => 'Обновить счёт расхода',
    'update_revenue_account'                    => 'Обновить счёт дохода',
    'make_new_asset_account'                    => 'Создать новый основной счёт',
    'make_new_expense_account'                  => 'Создать новый счёт расхода',
    'make_new_revenue_account'                  => 'Создать новый счёт дохода',
    'make_new_liabilities_account'              => 'Создать новый долговой счёт',
    'asset_accounts'                            => 'Основные счета',
    'undefined_accounts'                        => 'Учётные записи',
    'asset_accounts_inactive'                   => 'Основной счёт (неактивный)',
    'expense_account'                           => 'Счет расходов',
    'expense_accounts'                          => 'Счета расходов',
    'expense_accounts_inactive'                 => 'Счёт расходов (неактивный)',
    'revenue_account'                           => 'Счет доходов',
    'revenue_accounts'                          => 'Счета доходов',
    'revenue_accounts_inactive'                 => 'Счёт доходов (неактивный)',
    'cash_accounts'                             => 'Наличные деньги',
    'Cash account'                              => 'Наличные деньги',
    'liabilities_accounts'                      => 'Долги',
    'liabilities_accounts_inactive'             => 'Долги (неактивные)',
    'reconcile_account'                         => 'Сверка счёта ":account"',
    'overview_of_reconcile_modal'               => 'Обзор сверки',
    'delete_reconciliation'                     => 'Удалить сверку',
    'update_reconciliation'                     => 'Обновить сверку',
    'amount_cannot_be_zero'                     => 'Сумма не может быть равна нулю',
    'end_of_reconcile_period'                   => 'Конец периода сверки: :period',
    'start_of_reconcile_period'                 => 'Начало периода сверки: :period',
    'start_balance'                             => 'Начальный баланс',
    'end_balance'                               => 'Конечный баланс',
    'update_balance_dates_instruction'          => 'Сверьте суммы и даты, указанные выше, со своей банковской выпиской и нажмите «Начать сверку»',
    'select_transactions_instruction'           => 'Выберите транзакции, которые отражены в выписке с вашего банковского счёта.',
    'select_range_and_balance'                  => 'Сначала проверьте диапазон дат и балансы. Затем нажмите «Начать сверку»',
    'date_change_instruction'                   => 'Если вы измените диапазон дат сейчас, текущий прогресс будет потерян.',
    'update_selection'                          => 'Обновить выбранное',
    'store_reconcile'                           => 'Сохранить сверку',
    'reconciliation_transaction'                => 'Сверка транзакции',
    'Reconciliation'                            => 'Сверка',
    'reconciliation'                            => 'Сверка',
    'reconcile_options'                         => 'Параметры сверки',
    'reconcile_range'                           => 'Диапазон сверки',
    'start_reconcile'                           => 'Начать сверку',
    'cash_account_type'                         => 'Наличные',
    'cash'                                      => 'наличные',
    'cant_find_redirect_account'                => 'Firefly III попытался перенаправить вас, но не смог. Извините. Вернуться на главную страницу.',
    'account_type'                              => 'Тип счёта',
    'save_transactions_by_moving'               => 'Сохраните эту транзакцию, переместив её на другой счёт:|Сохраните эти транзакции, переместив их на другой счёт:',
    'save_transactions_by_moving_js'            => 'Нет транзакций|Сохраните эту транзакцию, переместив ее на другой счет. |Сохраните эти транзакции, переместив их на другой счет.',
    'stored_new_account'                        => 'Новый счёт ":name" сохранён!',
    'stored_new_account_js'                     => 'Новыая учётная запись "<a href="accounts/show/{ID}">{name}</a>" сохранена!',
    'updated_account'                           => 'Обновить счёт ":name"',
    'updated_account_js'                        => 'Обновлена учетная запись "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Параметры кредитной карты',
    'no_transactions_account'                   => 'Для основного счёта ":name" нет транзакций (в этом периоде).',
    'no_transactions_period'                    => 'Нет транзакций (в этот период).',
    'no_data_for_chart'                         => 'Недостаточно информации (пока) для построения этой диаграммы.',
    'select_at_least_one_account'               => 'Выберите хотя бы один счёт',
    'select_at_least_one_category'              => 'Пожалуйста, выберите по крайней мере одну категорию',
    'select_at_least_one_budget'                => 'Пожалуйста, выберите по крайней мере один бюджет',
    'select_at_least_one_tag'                   => 'Пожалуйста, выберите по крайней мере одну метку',
    'select_at_least_one_expense'               => 'Пожалуйста, выберите хотя бы одну комбинацию счетов расходов/доходов. Если их у вас нет (список пуст), данный отчёт недоступен.',
    'account_default_currency'                  => 'С этим счётом будет связана валюта по умолчанию.',
    'piggy_default_currency'                    => 'Копилки могут хранить деньги только в одной валюте.',
    'piggy_account_currency_match'              => 'Только счета, использующие ранее выбранную валюту, будут приняты.',
    'reconcile_has_more'                        => 'В вашей бухгалтерской книге Firefly III учтено больше денег, чем должно быть, согласно выписке из банка. Существует несколько вариантов. Пожалуйста, выберите, что делать, а затем нажмите «Подтвердить сверку».',
    'reconcile_has_less'                        => 'В вашей бухгалтерской книге Firefly III учтено меньше денег, чем должно быть, согласно выписке из банка. Существует несколько вариантов. Пожалуйста, выберите, что делать, а затем нажмите «Подтвердить сверку».',
    'reconcile_is_equal'                        => 'Ваша бухгалтерская книга Firefly III и ваши банковские выписки совпадают. Ничего делать не нужно. Пожалуйста, нажмите «Подтвердить сверку» для ввода данных.',
    'create_pos_reconcile_transaction'          => 'Удалить выбранные транзакции и создать корректировку, добавляющую сумму :amount к этому основному счёту.',
    'create_neg_reconcile_transaction'          => 'Удалить выбранные транзакции и создать корректировку, удаляющую сумму :amount с этого основного счёта.',
    'reconcile_do_nothing'                      => 'Удалить выбранные транзакции, но не производить корректировку.',
    'reconcile_go_back'                         => 'Вы сможете изменить или удалить корректировку позже.',
    'must_be_asset_account'                     => 'Вы можете производить сверку только для основных счётов',
    'reconciliation_stored'                     => 'Сверка сохранена',
    'reconciliation_error'                      => 'Из-за ошибки транзакции были помечены как сверенные, но коррекция не была сохранена: :error.',
    'reconciliation_transaction_title'          => 'Сверка (с :from по :to)',
    'sum_of_reconciliation'                     => 'Сумма по сверке',
    'reconcile_this_account'                    => 'Произвести сверку данного счёта',
    'reconcile'                                 => 'Сверить',
    'show'                                      => 'Показать',
    'confirm_reconciliation'                    => 'Подтвердить сверку',
    'submitted_start_balance'                   => 'Подтверждённый начальный баланс',
    'selected_transactions'                     => 'Выбранный транзакции (:count)',
    'already_cleared_transactions'              => 'Уже удалённые транзакции (:count)',
    'submitted_end_balance'                     => 'Подтверждённый конечный баланс',
    'initial_balance_description'               => 'Начальный баланс для ":account"',
    'liability_credit_description'              => 'Кредитное обязательство по ":account"',
    'interest_calc_'                            => 'неизвестно',
    'interest_calc_daily'                       => 'В день',
    'interest_calc_monthly'                     => 'В месяц',
    'interest_calc_yearly'                      => 'В год',
    'interest_calc_weekly'                      => 'За неделю',
    'interest_calc_half-year'                   => 'За полгода',
    'interest_calc_quarterly'                   => 'За квартал',
    'initial_balance_account'                   => 'Начальный баланс для счёта :account',
    'list_options'                              => 'Список настроек',
    'account_column_opt_drag_and_drop'          => 'Перетаскивание',
    'account_column_opt_active'                 => 'Активный',
    'account_column_opt_name'                   => 'Наименование',
    'account_column_opt_type'                   => 'Тип',
    'account_column_opt_liability_type'         => 'Тип ответственности',
    'account_column_opt_liability_direction'    => 'Направление ответственности',
    'account_column_opt_liability_interest'     => 'Процент ответственности',
    'account_column_opt_number'                 => 'Номер счета',
    'account_column_opt_current_balance'        => 'Текущий баланс',
    'account_column_opt_amount_due'             => 'Сумма к оплате',
    'account_column_opt_last_activity'          => 'Последнее действие',
    'account_column_opt_balance_difference'     => 'Разница баланса',
    'account_column_opt_menu'                   => 'Меню',

    // categories:
    'new_category'                              => 'Новая категория',
    'create_new_category'                       => 'Создать новую категорию',
    'without_category'                          => 'Без категории',
    'update_category'                           => 'Обновить категорию',
    'updated_category'                          => 'Обновить категорию ":name"',
    'categories'                                => 'Категории',
    'edit_category'                             => 'Изменить категорию ":name"',
    'no_category'                               => '(без категории)',
    'unknown_category_plain'                    => 'Без категории',
    'category'                                  => 'Категория',
    'delete_category'                           => 'Удалить категорию ":name"',
    'deleted_category'                          => 'Удалить категорию ":name"',
    'store_category'                            => 'Сохранить новую категорию',
    'stored_category'                           => 'Новая категория ":name" успешно сохранена!',
    'without_category_between'                  => 'Без категории между :start и :end',


    // transactions:
    'wait_loading_transaction'                  => 'Дождитесь загрузки формы',
    'wait_loading_data'                         => 'Пожалуйста, дождитесь загрузки вашей информации...',
    'wait_attachments'                          => 'Пожалуйста, дождитесь загрузки вложений.',
    'errors_upload'                             => 'Загрузка не удалась. Пожалуйста, проверьте консоль вашего браузера на наличие ошибки.',
    'amount_foreign_if'                         => 'Сумма в иностранной валюте, если таковая имеется',
    'amount_destination_account'                => 'Сумма в валюте счета назначения',
    'edit_transaction_title'                    => 'Редактировать транзакцию ":description"',
    'unreconcile'                               => 'Отменить сверку',
    'update_withdrawal'                         => 'Обновить расход',
    'update_deposit'                            => 'Обновить доход',
    'update_transaction'                        => 'Обновить транзакцию',
    'update_transfer'                           => 'Обновить перевод',
    'updated_withdrawal'                        => 'Расход ":description" обновлён',
    'updated_deposit'                           => 'Доход ":description" обновлён',
    'updated_transfer'                          => 'Перевод ":description" обновлён',
    'no_changes_withdrawal'                     => 'Расход ":description" не был изменен.',
    'no_changes_deposit'                        => 'Доход ":description" не был изменен.',
    'no_changes_transfer'                       => 'Перевод ":description" не был изменен.',
    'delete_withdrawal'                         => 'Удалить расход ":description"',
    'delete_deposit'                            => 'Удалить доход ":description"',
    'delete_transfer'                           => 'Удалить перевод ":description"',
    'deleted_withdrawal'                        => 'Расход ":description" успешно удалён',
    'deleted_deposit'                           => 'Доход ":description" успешно удалён',
    'deleted_transfer'                          => 'Перевод ":description" успешно удалён',
    'deleted_reconciliation'                    => 'Сверенная транзакция ":description" успешно удалена',
    'stored_journal'                            => 'Новая транзакция ":description" успешно создана',
    'stored_journal_js'                         => 'Успешно создана новая транзакция "{{description}}"',
    'stored_journal_no_descr'                   => 'Ваша новая транзакция успешно создана',
    'updated_journal_no_descr'                  => 'Ваша транзакция успешно обновлена',
    'select_transactions'                       => 'Выбрать транзакции',
    'rule_group_select_transactions'            => 'Применить ":title" к транзакциям',
    'rule_select_transactions'                  => 'Применить ":title" к транзакциям',
    'stop_selection'                            => 'Завершить выбор транзакций',
    'reconcile_selected'                        => 'Сверить',
    'mass_delete_journals'                      => 'Удалить несколько транзакций',
    'mass_edit_journals'                        => 'Изменить несколько транзакций',
    'mass_bulk_journals'                        => 'Массовое изменение нескольких транзакций',
    'mass_bulk_journals_explain'                => 'Эта форма позволяет массово изменять свойства всех транзакций, перечисленных ниже. Все транзакции в таблице будут обновлены с учётом новых параметров, которые вы видите здесь.',
    'part_of_split'                             => 'Эта транзакция является частью разделённой транзакции. Если вы выбрали не все части, то можете изменить только половину транзакции.',
    'bulk_set_new_values'                       => 'Используйте эти поля для ввода новых значений. Если вы оставите их пустыми, они будут очищены у всех записей. Также обратите внимание, что бюджет будет сопоставлен только с расходами.',
    'no_bulk_category'                          => 'Не обновлять категорию',
    'no_bulk_budget'                            => 'Не обновлять бюджет',
    'no_bulk_tags'                              => 'Не обновлять метки',
    'replace_with_these_tags'                   => 'Заменить этими метками',
    'append_these_tags'                         => 'Добавить эти метки',
    'mass_edit'                                 => 'Изменить выбранные по отдельности',
    'bulk_edit'                                 => 'Изменить выбранную группу',
    'mass_delete'                               => 'Удалить выбранные',
    'cannot_edit_other_fields'                  => 'Вы не можете массово редактировать другие поля, кроме тех, которые видите здесь, поскольку для их отображения недостаточно места. Пожалуйста, перейдите по ссылке и отредактируйте их по одной, если вам нужно изменить такие поля.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(вне бюджета)',
    'no_bill'                                   => '(нет подписки)',
    'account_per_budget'                        => 'Счёт в бюджете',
    'account_per_category'                      => 'Счёт по категории',
    'create_new_object'                         => 'Создать',
    'empty'                                     => '(пусто)',
    'all_other_budgets'                         => '(все остальные бюджеты)',
    'all_other_accounts'                        => '(все остальные счета)',
    'expense_per_source_account'                => 'Расходы по счёту-источнику',
    'expense_per_destination_account'           => 'Расходы по счёту назначения',
    'income_per_destination_account'            => 'Доходы по счёту назначения',
    'spent_in_specific_category'                => 'Расходы по категории ":category"',
    'earned_in_specific_category'               => 'Доходы по категории ":category"',
    'spent_in_specific_tag'                     => 'Расходы с меткой ":tag"',
    'earned_in_specific_tag'                    => 'Доходы с меткой ":tag"',
    'income_per_source_account'                 => 'Доход на счёт-источник',
    'average_spending_per_destination'          => 'Средний расход по счёту-источнику',
    'average_spending_per_source'               => 'Средний расход по счёту-источнику',
    'average_earning_per_source'                => 'Средний доход по счёту-источнику',
    'average_earning_per_destination'           => 'Средний доход по счёту назначения',
    'account_per_tag'                           => 'Счёт по метку',
    'tag_report_expenses_listed_once'           => 'Расходы и доходы никогда не отображаются дважды. Если транзакция имеет несколько меток, она может отображаться только с одной из них. Может показаться, что диаграмма не отображает часть данных, но суммы будут правильной.',
    'double_report_expenses_charted_once'       => 'Расходы и доходы никогда не отображаются дважды. Если транзакция имеет несколько меток, она может отображаться только с одной из них. Может показаться, что диаграмма не отображает часть данных, но суммы будут правильной.',
    'tag_report_chart_single_tag'               => 'Эта диаграмма отображает данные для одной метки. Если транзакция имеет несколько меток, эти же самые данные могут быть отражены в диаграммах других меток.',
    'tag'                                       => 'Метка',
    'no_budget_squared'                         => '(вне бюджета)',
    'perm-delete-many'                          => 'Удаление нескольких элементов за один раз может быть очень разрушительным. Пожалуйста, будьте осторожны. Например, вы можете удалить часть разделённой транзакции, видиму на этой странице.',
    'mass_deleted_transactions_success'         => 'Удалена :count транзакция.|Удалено :count транзакций.',
    'mass_edited_transactions_success'          => 'Обновлена :count транзакция.|Обновлено :count транзакций.',
    'opt_group_'                                => '(нет типа счёта)',
    'opt_group_no_account_type'                 => '(нет типа счёта)',
    'opt_group_defaultAsset'                    => 'Основные счета по умолчанию',
    'opt_group_savingAsset'                     => 'Сберегательные счета',
    'opt_group_sharedAsset'                     => 'Общие основные счета',
    'opt_group_ccAsset'                         => 'Кредитные карты',
    'opt_group_cashWalletAsset'                 => 'Кошельки с наличными',
    'opt_group_expense_account'                 => 'Счета расходов',
    'opt_group_revenue_account'                 => 'Счета доходов',
    'opt_group_l_Loan'                          => 'Долги (кредит)',
    'opt_group_cash_account'                    => 'Наличные деньги',
    'opt_group_l_Debt'                          => 'Долги (дебит)',
    'opt_group_l_Mortgage'                      => 'Долги (ипотека)',
    'opt_group_l_Credit card'                   => 'Долги (кредитная карта)',
    'notes'                                     => 'Заметки',
    'view_notes'                                => 'Просмотреть заметки',
    'set_budget_limit_notes'                    => 'Просмотреть примечания для этой суммы в бюджете',
    'edit_bl_notes'                             => 'Изменить заметки',
    'update_bl_notes'                           => 'Обновить заметки',
    'unknown_journal_error'                     => 'Не удалось сохранить транзакцию. Пожалуйста, проверьте log-файлы.',
    'attachment_not_found'                      => 'Вложение не найдено.',
    'journal_link_bill'                         => 'Эта транзакция связана с подпиской <a href=«:route»>:name</a>. Чтобы удалить связь, снимите флажок. Используйте правила, чтобы связать ее с другой подпиской.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Транзакция #{ID} ("{title}")</a> сохранена.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Транзакция #{ID}</a> сохранена.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Транзакция #{ID}</a> ("{title}") обновлена.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Транзакция #{ID}</a> ("{title}") не изменилась.',
    'first_split_decides'                       => 'В данном поле используется значение из первой части разделенной транзакции',
    'first_split_overrules_source'              => 'Значение из первой части транзакции может изменить счет источника',
    'first_split_overrules_destination'         => 'Значение из первой части транзакции может изменить счет назначения',
    'spent_x_of_y'                              => 'Потрачено {amount} из {total}',

    // new user:
    'welcome'                                   => 'Добро пожаловать в Firefly III!',
    'submit'                                    => 'Подтвердить',
    'submission'                                => 'Отправить',
    'submit_yes_really'                         => 'Подтвердить (я знаю, что делаю)',
    'getting_started'                           => 'Начало работы',
    'to_get_started'                            => 'Приятно видеть, что вы успешно установили Firefly III. Чтобы начать работу, введите, пожалуйста, название своего банка и баланс вашего основного банковского счёта. Если вы планируете использовать несколько счетов, не волнуйтесь, вы сможете добавить их позже. Сейчас Firefly III просто нужны какие-нибудь первоначальные данные.',
    'savings_balance_text'                      => 'Firefly III автоматически создаст сберегательный счёт для вас. По умолчанию на вашем сберегательном счёте не будет денег, но если вы укажете начальный баланс, он будет сохранен.',
    'finish_up_new_user'                        => 'Это всё! Вы можете продолжить, нажав <strong>Подтвердить</strong>. Вы попадете на главную страницу Firefly III.',
    'stored_new_accounts_new_user'              => 'Ура! Ваши новые учётные записи сохранены.',
    'set_preferred_language'                    => 'Если вы предпочитаете использовать Firefly III на другом языке, укажите здесь здесь.',
    'language'                                  => 'Язык',
    'new_savings_account'                       => 'сберегательный счёт в :bank_name',
    'cash_wallet'                               => 'Кошелёк с наличными',
    'currency_not_present'                      => 'Если ваша основная валюта ещё не указана, не волнуйтесь. Вы можете создать собственные валюты в разделе Параметры > Валюты.',

    // home page:
    'transaction_table_description'             => 'Таблица, содержащая ваши транзакции',
    'opposing_account'                          => 'Противодействующий счёт',
    'yourAccounts'                              => 'Ваши счета',
    'your_accounts'                             => 'Обзор вашего счёта',
    'category_overview'                         => 'Обзор категории',
    'expense_overview'                          => 'Обзор счета расходов',
    'revenue_overview'                          => 'Обзор счёта доходов',
    'budgetsAndSpending'                        => 'Бюджеты и расходы',
    'budgets_and_spending'                      => 'Бюджеты и расходы',
    'go_to_budget'                              => 'Перейти к бюджету "{budget}"',
    'go_to_deposits'                            => 'Перейти ко вкладам',
    'go_to_expenses'                            => 'Перейти к расходам',
    'savings'                                   => 'Экономия',
    'newWithdrawal'                             => 'Новый расход',
    'newDeposit'                                => 'Новый доход',
    'newTransfer'                               => 'Новый перевод',
    'bills_to_pay'                              => 'Платежные подписки',
    'per_day'                                   => 'В день',
    'left_to_spend_per_day'                     => 'Можно тратить в день',
    'bills_paid'                                => 'Подписка оплачена',
    'custom_period'                             => 'Пользовательский период',
    'reset_to_current'                          => 'Сброс к текущему периоду',
    'select_period'                             => 'Выберите период',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Валюта',
    'preferences'                               => 'Настройки',
    'logout'                                    => 'Выход',
    'logout_other_sessions'                     => 'Завершить все другие сессии',
    'toggleNavigation'                          => 'Переключить навигацию',
    'toggle_dropdown'                           => 'Переключить выпадающий список',
    'searchPlaceholder'                         => 'Поиск...',
    'version'                                   => 'Версия',
    'dashboard'                                 => 'Сводка',
    'income_and_expense'                        => 'Доходы и расходы',
    'all_money'                                 => 'Все ваши деньги',
    'unknown_source_plain'                      => 'Неизвестный счет источник',
    'unknown_dest_plain'                        => 'Неизвестный счет назначения',
    'unknown_any_plain'                         => 'Неизвестный счет',
    'unknown_budget_plain'                      => 'Без бюджета',
    'available_budget'                          => 'Доступный бюджет ({currency})',
    'currencies'                                => 'Валюты',
    'activity'                                  => 'Активность',
    'usage'                                     => 'Использование',
    'accounts'                                  => 'Счета',
    'Asset account'                             => 'Активный счёт',
    'Default account'                           => 'Основной счёт',
    'Expense account'                           => 'Счета расходов',
    'Revenue account'                           => 'Счета доходов',
    'Initial balance account'                   => 'Начальный баланс для счёта',
    'account_type_Asset account'                => 'Счет активов',
    'account_type_Expense account'              => 'Счета расходов',
    'account_type_Revenue account'              => 'Счет доходов',
    'account_type_Debt'                         => 'Дебит',
    'account_type_Loan'                         => 'Заём',
    'account_type_Mortgage'                     => 'Ипотека',
    'account_type_debt'                         => 'Долг',
    'account_type_loan'                         => 'Заём',
    'account_type_mortgage'                     => 'Ипотека',
    'account_type_Credit card'                  => 'Кредитная карта',
    'credit_card_type_monthlyFull'              => 'Полная оплата каждый месяц',
    'liability_direction_credit'                => 'Мне должны',
    'liability_direction_debit'                 => 'Я должен кому-то',
    'liability_direction_credit_short'          => 'Мне должны',
    'liability_direction_debit_short'           => 'Я должен',
    'liability_direction__short'                => 'Неизвестно',
    'liability_direction_null_short'            => 'Неизвестно',
    'Liability credit'                          => 'Кредитное обязательство',
    'budgets'                                   => 'Бюджет',
    'tags'                                      => 'Метки',
    'reports'                                   => 'Отчёты',
    'transactions'                              => 'Транзакции',
    'expenses'                                  => 'Расходы',
    'income'                                    => 'Доходы',
    'transfers'                                 => 'Переводы',
    'moneyManagement'                           => 'Управление финансами',
    'money_management'                          => 'Управление финансами',
    'tools'                                     => 'Инструменты',
    'piggyBanks'                                => 'Копилки',
    'piggy_banks'                               => 'Копилки',
    'amount_x_of_y'                             => '{current} из {total}',
    'bills'                                     => 'Подписки',
    'withdrawal'                                => 'Расход',
    'opening_balance'                           => 'Начальный баланс',
    'deposit'                                   => 'Доход',
    'account'                                   => 'Счёт',
    'transfer'                                  => 'Перевод',
    'Withdrawal'                                => 'Расход',
    'Deposit'                                   => 'Доход',
    'Transfer'                                  => 'Перевод',
    'bill'                                      => 'Подписка',
    'yes'                                       => 'Да',
    'no'                                        => 'Нет',
    'amount'                                    => 'Сумма',
    'overview'                                  => 'Обзор',
    'saveOnAccount'                             => 'Сохранить на счёте',
    'saveOnAccounts'                            => 'Сохранить на аккаунт(ы)',
    'unknown'                                   => 'Неизвестно',
    'monthly'                                   => 'Ежемесячно',
    'profile'                                   => 'Профиль',
    'errors'                                    => 'Ошибки',
    'debt_start_date'                           => 'Дата начала дебита',
    'debt_start_amount'                         => 'Начальная сумма дебита',
    'debt_start_amount_help'                    => 'Всегда лучше установить отрицательное значение. Для получения дополнительной информации прочтите страницу справки (значок (?) в правом верхнем углу).',
    'interest_period_help'                      => 'Это поле чисто косметическое и не будет рассчитано для вас. Как оказалось, банки очень хитры, так что Firefly III никогда не делает это правильно.',
    'store_new_liabilities_account'             => 'Сохранить новое обязательство',
    'edit_liabilities_account'                  => 'Редактировать долговой счёт ":name"',
    'financial_control'                         => 'Финансовый контроль',
    'accounting'                                => 'Учёт финансов',
    'automation'                                => 'Автоматизация',
    'others'                                    => 'Другие',
    'classification'                            => 'Классификация',
    'store_transaction'                         => 'Сохранить транзакцию',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Стандартный финансовый отчёт за период с :start по :end',
    'report_audit'                              => 'Обзор транзакций за период с :start по :end',
    'report_category'                           => 'Отчёт по категории между :start и :end',
    'report_double'                             => 'Отчёт по счёту расходов/доходов между :start и :end',
    'report_budget'                             => 'Отчет по бюджету между :start и :end',
    'report_tag'                                => 'Отчет по метке между :start и :end',
    'quick_link_reports'                        => 'Быстрые ссылки',
    'quick_link_examples'                       => 'Это лишь несколько примеров ссылок, которые вы начали. Посмотрите страницу справки (кнопка "?") для получения информации о всех отчётах и волшебных словах, которые вы можете использовать.',
    'quick_link_default_report'                 => 'Стандартный финансовый отчёт',
    'quick_link_audit_report'                   => 'Обзор транзакций',
    'report_this_month_quick'                   => 'Текущий месяц, все счета',
    'report_last_month_quick'                   => 'Последний месяц, все счета',
    'report_this_year_quick'                    => 'Текущий год, все счета',
    'report_this_fiscal_year_quick'             => 'Текущий финансовый год, всё счета',
    'report_all_time_quick'                     => 'Всё время, все счета',
    'reports_can_bookmark'                      => 'Помните, что отчеты можно добавить в закладки.',
    'incomeVsExpenses'                          => 'Сравнение расходов и доходов',
    'accountBalances'                           => 'Остатки на счетах',
    'balanceStart'                              => 'Остаток на начало периода',
    'balanceEnd'                                => 'Остаток на конец периода',
    'splitByAccount'                            => 'Разделить по разным счетам',
    'coveredWithTags'                           => 'Присвоены метки',
    'leftInBudget'                              => 'Осталось в бюджете',
    'left_in_debt'                              => 'Сумма долга',
    'sumOfSums'                                 => 'Сумма сумм',
    'noCategory'                                => '(без категории)',
    'notCharged'                                => 'Не взимается (пока)',
    'inactive'                                  => 'Неактивный',
    'active'                                    => 'Активный',
    'difference'                                => 'Разница',
    'money_flowing_in'                          => 'В',
    'money_flowing_out'                         => 'Из',
    'topX'                                      => 'макс. :number',
    'show_full_list'                            => 'Показать весь список',
    'show_only_top'                             => 'Показывать только первые :number',
    'report_type'                               => 'Тип отчета',
    'report_type_default'                       => 'Стандартный финансовый отчёт',
    'report_type_audit'                         => 'Обзор истории транзакций (аудит)',
    'report_type_category'                      => 'Отчёт по категории',
    'report_type_budget'                        => 'Отчёт по бюджету',
    'report_type_tag'                           => 'Отчёт по метке',
    'report_type_double'                        => 'Отчёт о расходах/доходах',
    'more_info_help'                            => 'Более подробную информацию об этих типах отчётов вы можете найти на странице справки. Нажмите значок (?) в правом верхнем углу.',
    'report_included_accounts'                  => 'Счета, включаемые в отчёт',
    'report_date_range'                         => 'Диапазон дат',
    'report_preset_ranges'                      => 'Предустановленные диапазоны',
    'shared'                                    => 'Общие',
    'fiscal_year'                               => 'Фискальный год',
    'income_entry'                              => 'Поступления со счёта ":name" между :start и :end',
    'expense_entry'                             => 'Расходы на счёт ":name" между :start и :end',
    'category_entry'                            => 'Расходы и доходы по категории ":name" между :start и :end',
    'budget_spent_amount'                       => 'Расходы по статье бюджета ":budget" между :start и :end',
    'balance_amount'                            => 'Расходы по статmt бюджета ":budget", оплаченные со счёта ":account" между :start и :end',
    'no_audit_activity'                         => 'Для счёта <a href=":url" title=":account_name">:account_name</a> не было зафиксировано никакой активности между :start и :end.',
    'audit_end_balance'                         => 'Баланс на счёте <a href=":url" title=":account_name">:account_name</a> на конец :end составляет: :balance',
    'reports_extra_options'                     => 'Дополнительные опции',
    'report_has_no_extra_options'               => 'У этого отчёта нет дополнительных опций',
    'reports_submit'                            => 'Просмотреть отчет',
    'end_after_start_date'                      => 'Конечная дата отчёта должна быть позже, чем начальная дата.',
    'select_category'                           => 'Выберите категории',
    'select_budget'                             => 'Выберите бюджет(ы).',
    'select_tag'                                => 'Выберите метки.',
    'income_per_category'                       => 'Доход по категориям',
    'expense_per_category'                      => 'Расход по категориям',
    'expense_per_budget'                        => 'Расход по бюджетам',
    'income_per_account'                        => 'Доход по счетам',
    'expense_per_account'                       => 'Расход по счетам',
    'expense_per_tag'                           => 'Расход по меткам',
    'income_per_tag'                            => 'Доход по меткам',
    'include_expense_not_in_budget'             => 'Включены расходы, не входящие в выбранный бюджет',
    'include_expense_not_in_account'            => 'Включены расходы, не относящиеся к выбранному счёту',
    'include_expense_not_in_category'           => 'Включены расходы, не относящиеся к выбранной категории',
    'include_income_not_in_category'            => 'Включены доходы, не относящиеся к выбранной категории',
    'include_income_not_in_account'             => 'Включены доходы, не относящиеся к выбранному счёту',
    'include_income_not_in_tags'                => 'Включены доходы, не отмеченные выбранной меткой',
    'include_expense_not_in_tags'               => 'Включены расходы, не отмеченные выбранной меткой',
    'everything_else'                           => 'Всё остальное',
    'income_and_expenses'                       => 'Доходы и расходы',
    'spent_average'                             => 'Расход (средний)',
    'income_average'                            => 'Доход (средний)',
    'transaction_count'                         => 'Количество транзакций',
    'average_spending_per_account'              => 'Средний расход по счёту',
    'average_income_per_account'                => 'Средний доход на счету',
    'total'                                     => 'Итого',
    'description'                               => 'Описание',
    'sum_of_period'                             => 'Сумма за период',
    'average_in_period'                         => 'В среднем за период',
    'no_account_role'                           => '(нет роли)',
    'account_role_defaultAsset'                 => 'Счёт по умолчанию',
    'account_role_sharedAsset'                  => 'Общий основной счёт',
    'account_role_savingAsset'                  => 'Сберегательный счет',
    'account_role_ccAsset'                      => 'Кредитная карта',
    'account_role_cashWalletAsset'              => 'Наличные',
    'budget_chart_click'                        => 'Щёлкните по названию бюджета в таблице выше, чтобы увидеть диаграмму.',
    'category_chart_click'                      => 'Щёлкните по названию категории в таблице выше, чтобы увидеть диаграмму.',
    'in_out_accounts'                           => 'Доходы и траты в сумме',
    'in_out_accounts_per_asset'                 => 'Доходы и траты (по основному счету)',
    'in_out_per_category'                       => 'Доходы и траты по каждой из категорий',
    'out_per_budget'                            => 'Расходы по бюджету',
    'select_expense_revenue'                    => 'Выберите счёт расходов или доходов',
    'multi_currency_report_sum'                 => 'Поскольку этот список содержит счета с несколькими валютами, то сумма(ы), которую вы видите, может не иметь смысла. Отчёт всегда будет возвращаться к вашей валюте по умолчанию.',
    'sum_in_default_currency'                   => 'Сумма всегда будет в валюте по умолчанию.',
    'net_filtered_prefs'                        => 'Эта диаграмма никогда не будет включать счета, у которых выключена опция "Включать в мои сбережения".',


    // charts:
    'chart'                                     => 'Диаграмма',
    'month'                                     => 'Месяц',
    'budget'                                    => 'Бюджет',
    'spent'                                     => 'Расход',
    'spent_capped'                              => 'Потрачено (не более)',
    'spent_in_budget'                           => 'Расходы по бюджету',
    'left_to_spend'                             => 'Осталось потратить',
    'earned'                                    => 'Доходы',
    'overspent'                                 => 'Перерасход',
    'left'                                      => 'Осталось',
    'max-amount'                                => 'Максимальная сумма',
    'min-amount'                                => 'Минимальная сумма',
    'journal-amount'                            => 'Текущая запись подписки',
    'name'                                      => 'Название',
    'expires_at'                                => 'Истекает',
    'date'                                      => 'Дата',
    'date_and_time'                             => 'Дата и время',
    'time'                                      => 'Время',
    'paid'                                      => 'Оплачено',
    'unpaid'                                    => 'Не оплачено',
    'day'                                       => 'День',
    'budgeted'                                  => 'Запланировано в бюджете',
    'period'                                    => 'Период',
    'balance'                                   => 'Бaлaнc',
    'in_out_period'                             => 'Баланс в этом периоде',
    'sum'                                       => 'Сумма',
    'summary'                                   => 'Сводка',
    'average'                                   => 'Среднее значение',
    'balanceFor'                                => 'Баланс для :name',
    'no_tags'                                   => '(нет меток)',
    'nothing_found'                             => '(ничего не найдено)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Настройки страницы',
    'visible_columns'               => 'Видимые столбцы',
    'accounts_to_show'              => 'Показываемые учетные записи',
    'active_accounts_only'          => 'Только активные учетные записи',
    'in_active_accounts_only'       => 'Только неактивные учетные записи',
    'show_all_accounts'             => 'Показать все учетные записи',
    'group_accounts'                => 'Учетные записи группы',

    // piggy banks:
    'event_history'                 => 'История событий',
    'add_money_to_piggy'            => 'Добавить деньги в копилку ":name"',
    'piggy_bank'                    => 'Копилка',
    'new_piggy_bank'                => 'Новая копилка',
    'store_piggy_bank'              => 'Сохранить новую копилку',
    'stored_piggy_bank'             => 'Сохранить новую копилку ":name"',
    'account_status'                => 'Состояние счета',
    'left_for_piggy_banks'          => 'Остаток для всех копилок',
    'sum_of_piggy_banks'            => 'Сумма по всем копилкам',
    'saved_so_far'                  => 'Сохранено на данный момент',
    'saved_so_far_total'            => 'Всего сохранено на данный момент',
    'reset_history'                 => 'сбросить историю',
    'reset_history_confirm'         => 'Вы уверены, что хотите сбросить историю этой копилки? Это снова приведет диаграмму в соответствие с суммой копилки.',
    'piggy_history_reset'           => 'История копилки сброшена',
    'left_to_save'                  => 'Осталось накопить',
    'suggested_amount'              => 'Рекомендуемая месячная сумма для перевода в копилку',
    'add_money_to_piggy_title'      => 'Добавить деньги в копилку ":name"',
    'remove_money_from_piggy_title' => 'Удалить деньги из копилки ":name"',
    'add'                           => 'Добавить',
    'no_money_for_piggy'            => 'У вас нет денег, чтобы положить в этот копилку.',
    'suggested_savings_per_month'   => 'Рекомендуется на месяц',

    'remove'                    => 'Удалить',
    'max_amount_add'            => 'Максимальная сумма, которую вы можете добавить:',
    'max_amount_remove'         => 'Максимальная сумма, которую вы можете удалить:',
    'update_piggy_button'       => 'Обновить копилку',
    'update_piggy_title'        => 'Обновить копилку ":name"',
    'updated_piggy_bank'        => 'Копилка ":name" обновлена',
    'details'                   => 'Подробности',
    'events'                    => 'События',
    'target_amount'             => 'Целевая сумма',
    'start_date'                => 'Дата начала',
    'no_start_date'             => 'Нет начальной даты',
    'target_date'               => 'Конечная дата',
    'no_target_date'            => 'Нет конечной даты',
    'table'                     => 'Таблица',
    'delete_piggy_bank'         => 'Удалить копилку ":name"',
    'cannot_add_amount_piggy'   => 'Невозможно добавить :amount в ":name".',
    'cannot_remove_from_piggy'  => 'Невозможно удалить :amount из ":name".',
    'deleted_piggy_bank'        => 'Копилка ":name" удалена',
    'added_amount_to_piggy'     => 'Добавлено :amount в ":name"',
    'removed_amount_from_piggy' => 'Удалено :amount из ":name"',
    'piggy_events'              => 'Связанные копилки',

    // tags
    'delete_tag'                => 'Удалить метку ":tag"',
    'deleted_tag'               => 'Метка ":tag" удалена',
    'new_tag'                   => 'Создать новую метку',
    'edit_tag'                  => 'Изменить метку ":tag"',
    'updated_tag'               => 'Метка ":tag" обновлена',
    'created_tag'               => 'Метка ":tag" была создана!',

    'transaction_journal_information'               => 'Информация о транзакции',
    'transaction_journal_amount'                    => 'Информация о сумме',
    'transaction_journal_meta'                      => 'Дополнительная информация',
    'transaction_journal_more'                      => 'Дополнительная информация',
    'basic_journal_information'                     => 'Основная информация о транзакции',
    'transaction_journal_extra'                     => 'Дополнительные сведения',
    'att_part_of_journal'                           => 'Сохранено в ":journal"',
    'total_amount'                                  => 'Итого',
    'number_of_decimals'                            => 'Количество знаков после запятой',


    // administration
    'invite_is_already_redeemed'                    => 'Приглашение ":address" уже было активировано.',
    'invite_is_deleted'                             => 'Приглашение ":address" удалено.',
    'invite_new_user_title'                         => 'Пригласить нового пользователя',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Адрес электронной почты',
    'invite_user'                                   => 'Пригласить пользователя',
    'user_is_invited'                               => 'Адрес электронной почты ":address" был приглашен в Firefly III',
    'administration'                                => 'Администрирование',
    'system_settings'                               => 'Настройки системы',
    'code_already_used'                             => 'Код приглашения уже был использован',
    'user_administration'                           => 'Управление пользователями',
    'list_all_users'                                => 'Список пользователей',
    'all_users'                                     => 'Все пользователи',
    'instance_configuration'                        => 'Конфигурация',
    'firefly_instance_configuration'                => 'Firefly III конфигурация',
    'setting_single_user_mode'                      => 'Режим одного пользователя',
    'setting_single_user_mode_explain'              => 'По умолчанию Firefly III работает только с одним пользователем (это вы). Это сделано с целью обеспечения безопасности, чтобы другие люди не могли использовать ваш Firefly без вашего разрешения. Регистрация других пользователей просто невозможна. Однако, если вы снимите этот флажок, другие смогут использовать ваш Firefly, при условии, что у них есть доступ к нему (например, он доступен через Интернет).',
    'store_configuration'                           => 'Сохранить конфигурацию',
    'single_user_administration'                    => 'Управление пользователем :email',
    'edit_user'                                     => 'Редактирование пользователя :email',
    'hidden_fields_preferences'                     => 'Вы можете включить больше параметров транзакции в <a href="preferences">настройках</a>.',
    'user_data_information'                         => 'Данные пользователя',
    'user_information'                              => 'Информация о пользователе',
    'total_size'                                    => 'общий размер',
    'budget_or_budgets'                             => ':count бюджет|:count бюджетов',
    'budgets_with_limits'                           => ':count бюджет с заданной суммой|:count бюджетов с заданной суммой',
    'nr_of_rules_in_total_groups'                   => ':count_rules правил в :count_groups группах',
    'tag_or_tags'                                   => ':count метка|:count меток',
    'configuration_updated'                         => 'Конфигурация обновлена',
    'setting_is_demo_site'                          => 'Демо-сайт',
    'setting_is_demo_site_explain'                  => 'Если вы установите этот флажок, эта копия FireFly будет вести себя как демонстрационный сайт, который может иметь странные побочные эффекты.',
    'block_code_bounced'                            => 'Отправка письма (писем) с аккаунта',
    'block_code_expired'                            => 'Срок демо-версии истёк',
    'no_block_code'                                 => 'Нет причины для блокировки или пользователь не заблокирован',
    'demo_user_export'                              => 'Демо-пользователь не может выгружать данные',
    'block_code_email_changed'                      => 'Пользователь не подтвердил новый адрес электронной почты',
    'admin_update_email'                            => 'Внимание! Пользователь НЕ будет уведомлён о смене адреса электронной почты. Новый адрес он увидит только на странице профиля.',
    'update_user'                                   => 'Обновить пользователя',
    'updated_user'                                  => 'Данные пользователя были изменены.',
    'delete_user'                                   => 'Удалить пользователя :email',
    'user_deleted'                                  => 'Пользователь был удален',
    'send_test_email'                               => 'Отправить тестовое письмо на E-mail пользователя',
    'send_test_email_text'                          => 'Нажмите на кнопку для проверки отправки уведомлений. Здесь вы не увидите ошибку (если таковая имеется), <strong>файлы журнала будут отражать любые ошибки</strong>. Вы можете нажимать эту кнопку столько раз, сколько захотите. Контроль спама отсутствует. Сообщение будет отправлено на <code>:email</code> и должно прийти в ближайшее время.',
    'send_message'                                  => 'Отправить сообщение',
    'send_test_triggered'                           => 'Тест был выполнен. Проверьте ваш почтовый ящик и log-файлы.',
    'give_admin_careful'                            => 'Пользователи, которым даны права администратора, могут отнять такие права у вас. Будьте осторожны.',
    'admin_maintanance_title'                       => 'Обслуживание',
    'admin_maintanance_expl'                        => 'Некоторые хитрые кнопочки для обслуживания Firefly III',
    'admin_maintenance_clear_cache'                 => 'Очистить кэш',
    'owner_notifications'                           => 'Уведомления администратора',
    'owner_notifications_expl'                      => 'Следующие уведомления могут быть включены или отключены администратором. Они будут отправлены по всем настроенным каналам. Некоторые каналы настроены в переменных окружения, другие можно установить здесь.',
    'channel_settings'                              => 'Настройки каналов уведомления',
    'notification_test_failed'                      => 'Проверка уведомлений для канала ":channel" не удалась. Подробности в журнале.',
    'notification_test_executed'                    => 'Проведено тестирование уведомлений для канала ":channel". Подробности в логах.',
    'settings_notifications'                        => 'Настройки уведомлений',
    'title_owner_notifications'                     => 'Уведомления владельца',
    'owner_notification_check_user_new_reg'         => 'Пользователь получает приветственное сообщение после регистрации',
    'owner_notification_check_admin_new_reg'        => 'Администраторы(ы) получают уведомление о регистрации нового пользователя',
    'owner_notification_check_new_version'          => 'Доступна новая версия',
    'owner_notification_check_invite_created'       => 'Пользователь приглашен в Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Приглашение пользователя активировано',
    'owner_notification_check_unknown_user_attempt' => 'Неизвестный пользователь пытается войти в систему',
    'all_invited_users'                             => 'Все приглашенные пользователи',
    'save_notification_settings'                    => 'Сохранить настройки',
    'notification_settings'                         => 'Настройки уведомлений',
    'notification_settings_saved'                   => 'Настройки уведомлений сохранены',
    'available_channels_title'                      => 'Доступные каналы',
    'available_channels_expl'                       => 'Эти каналы заново доступны для отправки уведомлений. Чтобы проверить конфигурацию, используйте кнопки ниже. Пожалуйста, обратите внимание, что кнопки не имеют контроля за спамом.',
    'notification_channel_name_email'               => 'Почта',
    'slack_discord_double'                          => 'Канал уведомлений Slack также может отправлять уведомления Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'не доступно',
    'configure_channel_in_env'                      => 'требуются переменные окружения',
    'test_notification_channel_name_email'          => 'Проверка электронной почты',
    'test_notification_channel_name_slack'          => 'Проверка Slack',
    'test_notification_channel_name_ntfy'           => 'Проверка Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Проверить Pushover',
    'test_notification_channel_name_gotify'         => 'Проверить Gotify',
    'test_notification_channel_name_pushbullet'     => 'Проверить Pushbullet',

    'split_transaction_title'               => 'Описание разделённой транзакции',
    'split_transaction_title_help'          => 'Если вы создаёте разделённую транзакцию, то должны указать общее описание для всех её составляющих.',
    'split_title_help'                      => 'Если вы создаёте разделённую транзакцию, то должны указать общее описание дле всех её составляющих.',
    'you_create_transfer'                   => 'Вы создаёте перевод.',
    'you_create_withdrawal'                 => 'Вы создаёте расход.',
    'you_create_deposit'                    => 'Вы создаёте доход.',

    // links
    'journal_link_configuration'            => 'Настройка связей между транзакциями',
    'create_new_link_type'                  => 'Создать новый тип связи',
    'store_new_link_type'                   => 'Сохранить новый тип связи',
    'update_link_type'                      => 'Обновить тип связи',
    'edit_link_type'                        => 'Изменить тип ссылки ":name"',
    'updated_link_type'                     => 'Тип связи ":name" обновлён',
    'delete_link_type'                      => 'Удалить тип ссылки ":name"',
    'deleted_link_type'                     => 'Тип ссылки ":name" удалён',
    'stored_new_link_type'                  => 'Сохранить новый тип связи ":name"',
    'cannot_edit_link_type'                 => 'Невозможно изменить тип ссылки ":name"',
    'link_type_help_name'                   => 'Например, "Дубликаты"',
    'link_type_help_inward'                 => 'Например, "дубликаты"',
    'link_type_help_outward'                => 'Например, "это дублирует..."',
    'save_connections_by_moving'            => 'Сохраните связь между этими транзакциями, переместив их на другой тип ссылок:',
    'do_not_save_connection'                => '(не сохранять соединение)',
    'link_transaction'                      => 'Связать транзакцию',
    'link_to_other_transaction'             => 'Связать эту транзакцию с другой транзакцией',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Эта транзакция',
    'transaction'                           => 'Транзакция',
    'comments'                              => 'Комментарии',
    'link_notes'                            => 'Любые заметки, которые вы хотите сохранить с этой ссылкой.',
    'invalid_link_selection'                => 'Невозможно связать эти транзакции',
    'selected_transaction'                  => 'Выбранная транзакция',
    'journals_linked'                       => 'Транзакции были связаны.',
    'journals_error_linked'                 => 'Эти транзакции уже связаны.',
    'journals_link_to_self'                 => 'Вы не можете связать транзакцию с самой собой',
    'journal_links'                         => 'Связи транзакции',
    'this_withdrawal'                       => 'Этот расход',
    'this_deposit'                          => 'Этот доход',
    'this_transfer'                         => 'Этот перевод',
    'overview_for_link'                     => 'Обзор для типа ссылки ":name"',
    'source_transaction'                    => 'Исходная транзакция',
    'link_description'                      => 'Описание связи',
    'destination_transaction'               => 'Целевая транзакция',
    'delete_journal_link'                   => 'Удалить связи между <a href=":source_link">:source</a> и <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Связь удалена',

    // link translations:
    'Paid_name'                             => 'Оплачено',
    'Refund_name'                           => 'Возврат',
    'Reimbursement_name'                    => 'Возмещение',
    'Related_name'                          => 'Связанные',
    'relates to_inward'                     => 'связано с',
    'is (partially) refunded by_inward'     => '(частично) возвращён',
    'is (partially) paid for by_inward'     => '(частично) оплачен',
    'is (partially) reimbursed by_inward'   => '(частично) возмещён',
    'inward_transaction'                    => 'Внутренняя транзакция',
    'outward_transaction'                   => 'Внешняя транзакция',
    'relates to_outward'                    => 'относится к',
    '(partially) refunds_outward'           => '(частично) возвращает',
    '(partially) pays for_outward'          => '(частично) оплачивает',
    '(partially) reimburses_outward'        => '(частично) возмещает',
    'is (partially) refunded by'            => '(частично) возвращён',
    'is (partially) paid for by'            => '(частично) оплачен',
    'is (partially) reimbursed by'          => '(частично) возмещён',
    'relates to'                            => 'связано с',
    '(partially) refunds'                   => '(частично) возвращает',
    '(partially) pays for'                  => '(частично) оплачивает',
    '(partially) reimburses'                => '(частично) возмещает',

    // split a transaction:
    'splits'                                => 'Разделение транзакции',
    'add_another_split'                     => 'Добавить еще одну часть',
    'cannot_edit_opening_balance'           => 'Вы не можете изменить начальный баланс этого счёта.',
    'no_edit_multiple_left'                 => 'Вы выбрали для редактирования некорректную транзакцию.',
    'breadcrumb_convert_group'              => 'Преобразовать транзакцию',
    'convert_invalid_source'                => 'Транзакция #%d содержит неверную информацию о счете источника.',
    'convert_invalid_destination'           => 'Транзакция #%d содержит неверную информацию о счёте назначения.',
    'create_another'                        => 'После сохранения вернуться сюда и создать ещё одну аналогичную запись.',
    'after_update_create_another'           => 'После обновления вернитесь сюда, чтобы продолжить редактирование.',
    'store_as_new'                          => 'Сохранить как новую транзакцию вместо обновления.',
    'reset_after'                           => 'Сбросить форму после отправки',
    'errors_submission'                     => 'С вашей публикацией произошла ошибка. Пожалуйста, проверьте ошибки ниже.',
    'errors_submission_v2'                  => 'С вашей публикацией произошла ошибка. Пожалуйста, проверьте следующие ошибки: {{errorMessage}}',
    'transaction_expand_split'              => 'Развернуть разделение',
    'transaction_remove_split'              => 'Удалить разделение',
    'transaction_collapse_split'            => 'Свернуть разделение',

    // object groups
    'default_group_title_name'              => '(без группировки)',
    'default_group_title_name_plain'        => 'без группировки',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Давайте создадим счёт расхода!',
    'no_accounts_intro_asset'               => 'У вас пока нет основных счетов. Основные счета - это ваши денежные активы (наличные, сберегательный счёт, кредитная карта и т. п.).',
    'no_accounts_imperative_asset'          => 'Чтобы начать использовать Firefly III, вы должны создать хотя бы один основной счёт. Давайте сделаем это сейчас:',
    'no_accounts_create_asset'              => 'Создание расходного счёта',
    'no_accounts_title_expense'             => 'Давайте создадим расходный счёт!',
    'no_accounts_intro_expense'             => 'Пока у вас нет ни одного расходного счёта. Расходные счета используются для контроля за тем, где именно вы расходуете свои финансы. Например, в магазинах или на оплату коммунальных счетов.',
    'no_accounts_imperative_expense'        => 'Расходные счета создаются автоматически, когда вы создаёте транзакции (расходы), но вы можете также создать их вручную, если хотите. Давайте создадим один прямо сейчас:',
    'no_accounts_create_expense'            => 'Создать расходный счёт',
    'no_accounts_title_revenue'             => 'Давайте создадим счёт дохода!',
    'no_accounts_intro_revenue'             => 'У вас ещё нет счетов дохода. Счета дохода - это источники вашего дохода (например, ваш работодатель).',
    'no_accounts_imperative_revenue'        => 'Счета дохода создаются автоматически при создании транзакций, но вы можете создать их вручную, если хотите. Давайте создадим один сейчас:',
    'no_accounts_create_revenue'            => 'Создать счёт дохода',
    'no_accounts_title_liabilities'         => 'Давайте создадим первый долговой счёт!',
    'no_accounts_intro_liabilities'         => 'У вас пока нет обязательств. Обязательства являются счетами, которые регистрируют ваши ссуды (например, студенческие) и другие долги.',
    'no_accounts_imperative_liabilities'    => 'Вам не обязательно использовать эту функцию, но она может быть полезной, если вы хотите отслеживать такие вещи.',
    'no_accounts_create_liabilities'        => 'Создать новый долговой счёт',
    'no_budgets_title_default'              => 'Давайте создадим бюджет',
    'no_rules_title_default'                => 'Давайте создадим правило',
    'no_budgets_intro_default'              => 'У вас пока нет бюджетов. Бюджеты используются для упорядочивания ваших расходов в логические группы, с помощью наблюдения за которыми вы можете ограничить свои расходы.',
    'no_rules_intro_default'                => 'У Вас пока нет правил. Правила - это мощные автоматизации, которые могут обрабатывать транзакции за вас.',
    'no_rules_imperative_default'           => 'Правила могут быть очень полезны при управлении транзакциями. Давайте создадим одно сейчас:',
    'no_budgets_imperative_default'         => 'Бюджеты - это основные инструменты управления финансами. Давайте создадим один сейчас:',
    'no_budgets_create_default'             => 'Создать бюджет',
    'no_rules_create_default'               => 'Создать правило',
    'no_categories_title_default'           => 'Давайте создадим категорию!',
    'no_categories_intro_default'           => 'У вас пока нет категорий. Категории используются для точной настройки ваших транзакций и их маркировки.',
    'no_categories_imperative_default'      => 'Категории создаются автоматически при создании транзакций, но вы также можете создать их вручную. Давайте создадим одну сейчас:',
    'no_categories_create_default'          => 'Создать категорию',
    'no_tags_title_default'                 => 'Давайте создадим метку!',
    'no_tags_intro_default'                 => 'У вас еще нет меток. Метки используются для точной настройки транзакций и маркировки их конкретными ключевыми словами.',
    'no_tags_imperative_default'            => 'Метки создаются автоматически при создании транзакций, но вы также можете создать их вручную. Давайте создадим одну сейчас:',
    'no_tags_create_default'                => 'Создать метку',
    'no_transactions_title_withdrawal'      => 'Давайте создадим расход!',
    'no_transactions_intro_withdrawal'      => 'У вас пока нет расходов. Вы должны создать хотя бы один расход, чтобы начать управлять своими финансами.',
    'no_transactions_imperative_withdrawal' => 'Вы потратили часть своих денег? Это нужно записать:',
    'no_transactions_create_withdrawal'     => 'Создать расход',
    'no_transactions_title_deposit'         => 'Давайте создадим какой-нибудь доход!',
    'no_transactions_intro_deposit'         => 'У вас пока нет учтённых доходов. Вы должны создать запись дохода, чтобы начать управлять своими финансами.',
    'no_transactions_imperative_deposit'    => 'Вы получили какие-нибудь деньги? Вам нужно это записать:',
    'no_transactions_create_deposit'        => 'Создать доход',
    'no_transactions_title_transfers'       => 'Давайте создадим перевод!',
    'no_transactions_intro_transfers'       => 'У вас ещё нет переводов. Когда вы перемещаете деньги между счетами, это нужно записывать как перевод.',
    'no_transactions_imperative_transfers'  => 'Вы переместили часть своих денег? Это нужно записать:',
    'no_transactions_create_transfers'      => 'Создать перевод',
    'no_piggies_title_default'              => 'Давайте создадим копилку!',
    'no_piggies_intro_default'              => 'У вас пока нет копилок. Вы можете создавать копилки, чтобы разделить свои сбережения и следить за тем, за что вы сберегаете.',
    'no_piggies_imperative_default'         => 'Вы хотите накопить денег на что-нибудь? Создайте копилку и следите за своими сбережениями:',
    'no_piggies_create_default'             => 'Создать новую копилку',
    'no_bills_title_default'                => 'Давайте создадим подписку!',
    'no_bills_intro_default'                => 'У вас пока нет подписок. Вы можете создавать подписки, чтобы отслеживать регулярные расходы, такие как аренда или страхование.',
    'no_bills_imperative_default'           => 'У вас есть такие регулярные подписки? Создайте подписку и следите за платежами:',
    'no_bills_create_default'               => 'Создать подписку',

    // recurring transactions
    'recurrence_max_count'                  => 'Повторяющиеся транзакции будут созданы максимум :max раз(а), уже созданы :count раз.',
    'create_right_now'                      => 'Создать прямо сейчас',
    'no_new_transaction_in_recurrence'      => 'Не было создано ни одной новой транзакции. Возможно, она уже была запущена на эту дату?',
    'recurrences'                           => 'Повторяющиеся транзакции',
    'repeat_until_in_past'                  => 'Повторение этой повторяющейся транзакции прервано :date.',
    'recurring_calendar_view'               => 'Календарь',
    'no_recurring_title_default'            => 'Давайте создадим повторяющуюся транзакцию!',
    'no_recurring_intro_default'            => 'У вас пока нет повторяющихся транзакций. Вы можете использовать их для автоматического создания транзакций в Firefly III.',
    'no_recurring_imperative_default'       => 'Это очень продвинутая функция, но она может быть очень полезна. Убедитесь, что вы прочитали документацию (значок "?" в правом верхнем углу), прежде чем продолжить.',
    'no_recurring_create_default'           => 'Создать повторяющуюся транзакцию',
    'make_new_recurring'                    => 'Создать повторяющуюся транзакцию',
    'recurring_daily'                       => 'Каждый день',
    'recurring_weekly'                      => 'Каждую неделю в :weekday',
    'recurring_weekly_skip'                 => 'Каждую :skip(st/nd/rd/th) неделю в :weekday',
    'recurring_monthly'                     => 'Каждый месяц в :dayOfMonth(st/nd/rd/th) день',
    'recurring_monthly_skip'                => 'Каждый :skip(st/nd/rd/th) месяц в :dayOfMonth(st/nd/rd/th) день',
    'recurring_ndom'                        => 'Каждый месяц в :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_ndom_skip'                   => 'Каждый :skip(st/nd/rd/th) месяц на :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Каждый год на :date',
    'overview_for_recurrence'               => 'Обзор повторяющейся транзакции ":title"',
    'warning_duplicates_repetitions'        => 'В редких случаях даты в этом списке появляются дважды. Это может произойти, когда несколько повторяющихся транзакций пересекаются. Firefly III всегда будет генерировать одну транзакцию в день.',
    'created_transactions'                  => 'Связанные транзакции',
    'expected_withdrawals'                  => 'Просроченные расходы',
    'expected_deposits'                     => 'Просроченные доходы',
    'expected_transfers'                    => 'Просроченные переводы',
    'created_withdrawals'                   => 'Расходы созданы',
    'created_deposits'                      => 'Доходы созданы',
    'created_transfers'                     => 'Переводы созданы',
    'recurring_info'                        => 'Повторяющаяся транзакция :count / :total',
    'created_from_recurrence'               => 'Создано из повторяющейся транзакции ":title" (#:id)',
    'recurring_never_cron'                  => 'Похоже, что задание cron, которое необходимо для работы повторяющихся транзакций, никогда не запускалось. Это совершенно нормально, если вы только что установили Firefly III, но возможно стоит проверить кое-какие настройки как можно скорее. Пожалуйста, перечитайте страницу справки, используя значок (?) в верхнем правом углу этой страницы.',
    'recurring_cron_long_ago'               => 'Похоже, что прошло более 36 часов с того времени, когда задание cron должно было быть выполнено в последний раз. Вы уверены, что всё настроено правильно? Пожалуйста, перечитайте страницу справки, используя значок (?) в верхнем правом углу этой страницы.',

    'create_new_recurrence'              => 'Создать новую повторяющуюся транзакцию',
    'help_first_date'                    => 'Укажите первое ожидаемое повторение. Оно должно быть в будущем.',
    'help_first_date_no_past'            => 'Укажите первое ожидаемое повторение. Firefly III не будет создавать транзакции ранее этой даты.',
    'no_currency'                        => '(нет валюты)',
    'mandatory_for_recurring'            => 'Обязательные сведения о повторении',
    'mandatory_for_transaction'          => 'Обязательные сведения о транзакции',
    'optional_for_recurring'             => 'Опциональные сведения о повторении',
    'optional_for_transaction'           => 'Опциональные сведения о транзакции',
    'change_date_other_options'          => 'Измените "начальную дату", чтобы увидеть больше опций.',
    'mandatory_fields_for_tranaction'    => 'Эти значения будут использоваться при создании транзакций',
    'click_for_calendar'                 => 'Щёлкните здесь, чтобы открыт календарь и указать, когда транзакция будет повторяться.',
    'repeat_forever'                     => 'Повторять всегда',
    'repeat_until_date'                  => 'Повторять до указанной даты',
    'repeat_times'                       => 'Повторять указанное число раз',
    'recurring_skips_one'                => 'Другой период',
    'recurring_skips_more'               => 'Пропустить :count повторов',
    'store_new_recurrence'               => 'Сохранить повторяющуюся транзакцию',
    'stored_new_recurrence'              => 'Повторяющаяся транзакция ":title" успешно сохранена.',
    'edit_recurrence'                    => 'Изменить повторяющуюся транзакцию ":title"',
    'recurring_repeats_until'            => 'Повторять до :date',
    'recurring_repeats_forever'          => 'Повторять всегда',
    'recurring_repeats_x_times'          => 'Повторяется :count раз|Повторяется :count раз',
    'update_recurrence'                  => 'Обновить повторяющуюся транзакцию',
    'updated_recurrence'                 => 'Повторяющаяся транзакция ":title" обновлена',
    'recurrence_is_inactive'             => 'Эта повторяющаяся транзакция не активна и не создаёт новые транзакции.',
    'delete_recurring'                   => 'Удалить повторяющуюся транзакцию ":title"',
    'new_recurring_transaction'          => 'Новая запланированная транзакция',
    'help_weekend'                       => 'Что должен сделать Firefly III, когда повторяющаяся транзакция попадает на субботу или воскресенье?',
    'do_nothing'                         => 'Просто создать транзакцию',
    'skip_transaction'                   => 'Пропустить транзакцию',
    'jump_to_friday'                     => 'Создать транзакцию в предшествующую пятницу',
    'jump_to_monday'                     => 'Создать транзакцию в следующий понедельник',
    'will_jump_friday'                   => 'Будет создана в пятницу, а не в выходной день.',
    'will_jump_monday'                   => 'Будет создана в понедельник, а не в выходной день.',
    'except_weekends'                    => 'Исключить выходные дни',
    'recurrence_deleted'                 => 'Повторяющаяся транзакция ":title" удалена',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Баланс (:currency)',
    'box_spent_in_currency'              => 'Расходы (:currency)',
    'box_earned_in_currency'             => 'Доходы (:currency)',
    'box_budgeted_in_currency'           => 'Запланировано в бюджете (:currency)',
    'box_bill_paid_in_currency'          => 'Оплачена подписка (:currency)',
    'box_bill_unpaid_in_currency'        => 'Подписки не оплачены (:currency)',
    'box_left_to_spend_in_currency'      => 'Осталось потратить (:currency)',
    'box_net_worth_in_currency'          => 'Мои сбережения (:currency)',
    'box_spend_per_day'                  => 'Можно тратить в день: :amount',

    // debug page
    'debug_page'                         => 'Отладка',
    'debug_submit_instructions'          => 'Если у вас возникли проблемы, вы можете использовать информацию в этом поле в качестве отладочной информации. Пожалуйста, скопируйте и вставьте эту информацию в новую или существующую <a href="https://github.com/firefly-iii/firefly-iii/issues">проблему на GitHub</a>. Будет сгенерирована красивая таблица, которая поможет быстро диагностировать вашу проблему.',
    'debug_pretty_table'                 => 'Если вы скопируете/вставите содержимое этого поля в проблему на GitHub, будет сгенерирована таблица. Пожалуйста, не окружайте этот текст апострофами или кавычками.',
    'debug_additional_data'              => 'Вы также можете поделиться содержимым поля ниже. Вы можете скопировать и вставить это в новую или существующую <a href="https://github.com/firefly-iii/firefly-iii/issues">проблему на GitHub</a>. Однако помните, что содержимое этого поля может содержать личную информацию, такую как имена счетов, детали ваших транзакций или адреса электронной почты.',

    // object groups
    'object_groups_menu_bar'             => 'Группы',
    'object_groups_page_title'           => 'Группы',
    'object_groups_breadcrumb'           => 'Группы',
    'object_groups_index'                => 'Обзор',
    'object_groups'                      => 'Группы',
    'object_groups_empty_explain'        => 'Некоторые вещи в Firefly III можно разделить на группы. Например, поле "Группа " на экранах редактирования и создания копилок. Когда вы зададите это поле, вы сможете редактировать названия и порядок групп на этой странице. Для получения дополнительной информации ознакомьтесь со справочными страницами (щёлкните по значку (?) в правом верхнем углу).',
    'object_group_title'                 => 'Название',
    'edit_object_group'                  => 'Изменить группу ":title"',
    'delete_object_group'                => 'Удалить группу ":title"',
    'update_object_group'                => 'Обновить группу',
    'updated_object_group'               => 'Группа успешно обновлена ":title"',
    'deleted_object_group'               => 'Группа успешно удалена ":title"',
    'object_group'                       => 'Группа',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Записи журнала аудита',
    'ale_action_log_add'                 => 'Добавить :amount в копилку ":name"',
    'ale_action_log_remove'              => 'Взять :amount из копилки ":name"',
    'ale_action_clear_budget'            => 'Удалено из бюджета',
    'ale_action_update_group_title'      => 'Обновлены название группы транзакций',
    'ale_action_update_date'             => 'Обновлена дата транзакции',
    'ale_action_update_order'            => 'Обновлён порядок транзакций',
    'ale_action_clear_category'          => 'Удалено из категории',
    'ale_action_clear_notes'             => 'Удаленные заметки',
    'ale_action_clear_tag'               => 'Тэг очищен',
    'ale_action_clear_all_tags'          => 'Все теги очищены',
    'ale_action_set_bill'                => 'Связан с подпиской',
    'ale_action_switch_accounts'         => 'Смена счета источника и назначения',
    'ale_action_set_budget'              => 'Указать бюджет',
    'ale_action_set_category'            => 'Указать категорию',
    'ale_action_set_source'              => 'Указать счёт-источник',
    'ale_action_set_destination'         => 'Указать счёт назначения',
    'ale_action_update_transaction_type' => 'Изменен тип платежа',
    'ale_action_update_notes'            => 'Заметки изменены',
    'ale_action_update_description'      => 'Описание изменено',
    'ale_action_add_to_piggy'            => 'Копилка',
    'ale_action_remove_from_piggy'       => 'Копилка',
    'ale_action_add_tag'                 => 'Добавленный тег',
    'ale_action_update_amount'           => 'Обновленная сумма',

    // dashboard
    'enable_auto_convert'                => 'Включить конвертацию валюты',
    'disable_auto_convert'               => 'Отключить конвертацию валюты',
];
