<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'armazenado em ":timezone"',
    'displayed_in_tz'                           => 'exibido em ":timezone"',
    'close'                                     => 'Fechar',
    'actions'                                   => 'Ações',
    'edit'                                      => 'Editar',
    'loading'                                   => 'Baixar',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Apagar',
    'split'                                     => 'Dividir',
    'single_split'                              => 'Divisão',
    'clone'                                     => 'Clonar',
    'clone_and_edit'                            => 'Clonar e editar',
    'confirm_action'                            => 'Confirmar ação',
    'last_seven_days'                           => 'Últimos sete dias',
    'last_thirty_days'                          => 'Últimos 30 dias',
    'last_180_days'                             => 'Últimos 180 dias',
    'month_to_date'                             => 'Começo do mês até hoje',
    'year_to_date'                              => 'Começo do ano até hoje',
    'YTD'                                       => 'Acumulado no ano',
    'welcome_back'                              => 'O que está acontecendo?',
    'main_dashboard_page_title'                 => 'Início',
    'everything'                                => 'Tudo',
    'today'                                     => 'hoje',
    'customRange'                               => 'Intervalo personalizado',
    'date_range'                                => 'Intervalo de datas',
    'apply'                                     => 'Aplicar',
    'select_date'                               => 'Selecione a data..',
    'cancel'                                    => 'Cancelar',
    'from'                                      => 'De',
    'to'                                        => 'Até',
    'structure'                                 => 'Estrutura',
    'help_translating'                          => 'Este texto de ajuda ainda não está disponível no seu idioma. <a href="https://crowdin.com/project/firefly-iii-help">Que tal ajudar a traduzí-lo?</a>',
    'showEverything'                            => 'Mostrar tudo',
    'never'                                     => 'Nunca',
    'no_results_for_empty_search'               => 'Sua pesquisa estava vazia, então nada foi encontrado.',
    'removed_amount'                            => 'Removido :amount',
    'added_amount'                              => 'Adicionado :amount',
    'asset_account_role_help'                   => 'Quaisquer opções extras resultantes da sua escolha podem ser definidas depois.',
    'Opening balance'                           => 'Saldo inicial',
    'create_new_stuff'                          => 'Criar coisas novas',
    'new_withdrawal'                            => 'Nova saída',
    'create_new_transaction'                    => 'Criar nova transação',
    'sidebar_frontpage_create'                  => 'Criar',
    'new_transaction'                           => 'Nova transação',
    'no_rules_for_bill'                         => 'Esta assinatura não tem regras associadas a ela.',
    'go_to_asset_accounts'                      => 'Veja suas contas de ativos',
    'go_to_budgets'                             => 'Vá para seus orçamentos',
    'go_to_withdrawals'                         => 'Vá para seus saques',
    'clones_journal_x'                          => 'Esta transação é um clone de ":description" (#:id)',
    'go_to_categories'                          => 'Vá para suas categorias',
    'go_to_bills'                               => 'Vá para suas assinaturas',
    'go_to_expense_accounts'                    => 'Veja suas despesas',
    'go_to_revenue_accounts'                    => 'Veja suas receitas',
    'go_to_piggies'                             => 'Vá para seus cofrinhos',
    'new_deposit'                               => 'Nova entrada',
    'new_transfer'                              => 'Nova transferência',
    'new_transfers'                             => 'Nova transferência',
    'new_asset_account'                         => 'Nova conta de ativo',
    'new_expense_account'                       => 'Nova conta de despesa',
    'new_revenue_account'                       => 'Nova conta de receita',
    'new_liabilities_account'                   => 'Novo passivo',
    'new_budget'                                => 'Novo orçamento',
    'new_bill'                                  => 'Nova assinatura',
    'block_account_logout'                      => 'Você foi desconectado. Contas bloqueadas não podem usar este site. Você se registrou com um email válido?',
    'flash_success'                             => 'Sucesso!',
    'flash_info'                                => 'Mensagem',
    'flash_warning'                             => 'Atenção!',
    'flash_error'                               => 'Erro!',
    'flash_danger'                              => 'Perigo!',
    'flash_info_multiple'                       => 'Há uma mensagem|Existem :count mensagens',
    'flash_error_multiple'                      => 'Houve um erro|Houve :count erros',
    'net_worth'                                 => 'Patrimônio líquido',
    'help_for_this_page'                        => 'Ajuda para esta página',
    'help_for_this_page_body'                   => 'Você pode encontrar mais informações sobre esta página <a href="https://docs.firefly-iii.org/">na documentação</a>.',
    'two_factor_welcome'                        => 'Olá!',
    'two_factor_enter_code'                     => 'Para continuar, por favor, digite seu código de autenticação em duas etapas. Seu aplicativo pode gerá-lo para você.',
    'two_factor_code_here'                      => 'Insira o código aqui',
    'two_factor_title'                          => 'Autenticação em duas etapas',
    'authenticate'                              => 'Autenticar',
    'two_factor_forgot_title'                   => 'Autenticação em duas etapas perdida',
    'two_factor_forgot'                         => 'Esqueci minha autenticação em duas etapas.',
    'two_factor_lost_header'                    => 'Perdeu sua autenticação em duas etapas?',
    'two_factor_lost_intro'                     => 'Se você perdeu seus códigos de backup também, você tem azar. Isso não é algo que você pode corrigir a partir da interface da web. Você tem duas escolhas.',
    'two_factor_lost_fix_self'                  => 'Se você roda sua própria instância do Firefly III, leia <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">esta seção do FAQ</a> para instruções.',
    'two_factor_lost_fix_owner'                 => 'Caso contrário, entre em contato com o proprietário do site, <a href="mailto::site_owner">:site_owner</a>, e peça que redefina sua autenticação de duas etapas.',
    'mfa_backup_code'                           => 'Você usou um código de backup para acessar o Firefly III. Não pode ser usado novamente, então cruze-o na sua lista.',
    'pref_two_factor_new_backup_codes'          => 'Obter novos códigos de backup',
    'pref_two_factor_backup_code_count'         => 'Você tem :count código de backup válido.|Você tem :count códigos de backup válidos.',
    '2fa_i_have_them'                           => 'Eu os armazenei!',
    'warning_much_data'                         => ':days dias de dados podem demorar um pouco para carregar.',
    'registered'                                => 'Você se registrou com sucesso!',
    'Default asset account'                     => 'Conta de ativo padrão',
    'no_budget_pointer'                         => 'Parece que você ainda não tem orçamentos. Você deve criar alguns na página de <a href="budgets">orçamentos</a>. Orçamentos podem ajudá-lo a manter o controle das despesas.',
    'no_bill_pointer'                           => 'Parece que você não tem assinatura ainda. Você deve criar alguma na página de <a href="subscriptions">assinaturas</a>. Assinaturas podem ajudá-lo a manter o controle das despesas.',
    'Savings account'                           => 'Conta poupança',
    'Credit card'                               => 'Cartão de crédito',
    'source_accounts'                           => 'Conta de origem|Contas de origem',
    'destination_accounts'                      => 'Conta de destino|Contas de destino',
    'user_id_is'                                => 'Seu id de usuário é <strong>:user</strong>',
    'field_supports_markdown'                   => 'Este campo suporta <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Se você precisa de mais ajuda usando o Firefly III, por favor <a href="https://github.com/firefly-iii/firefly-iii/issues">abra um ticket no Github</a>.',
    'reenable_intro_text'                       => 'Você também pode reabilitar <a href="#" id="reenableGuidance">o guia de introdução</a>.',
    'intro_boxes_after_refresh'                 => 'As caixas de introdução reaparecerão quando você atualizar a página.',
    'show_all_no_filter'                        => 'Mostre todas as transações sem agrupá-las por data.',
    'expenses_by_category'                      => 'Despesa por categoria',
    'expenses_by_budget'                        => 'Despesas pelo orçamento',
    'income_by_category'                        => 'Receitas por categoria',
    'expenses_by_asset_account'                 => 'Despesas por conta de ativos',
    'expenses_by_expense_account'               => 'Despesas por conta destino',
    'cannot_redirect_to_account'                => 'Firefly III não pode redirecioná-lo para a página correta. Minhas desculpas.',
    'sum_of_expenses'                           => 'Soma das despesas',
    'sum_of_income'                             => 'Soma da renda',
    'liabilities'                               => 'Passivos',
    'spent_in_specific_budget'                  => 'Gasto no orçamento ":budget"',
    'spent_in_specific_double'                  => 'Gasto na conta ":account"',
    'earned_in_specific_double'                 => 'Ganho na conta ":account"',
    'source_account'                            => 'Conta origem',
    'source_account_reconciliation'             => 'Você não pode editar a conta de origem de uma transação de reconciliação.',
    'destination_account'                       => 'Conta destino',
    'destination_account_reconciliation'        => 'Você não pode editar a conta destino de uma transação de reconciliação.',
    'sum_of_expenses_in_budget'                 => 'Gasto total no orçamento ":budget"',
    'left_in_budget_limit'                      => 'Restante para gastar de acordo com o orçamento',
    'current_period'                            => 'Período atual',
    'show_the_current_period_and_overview'      => 'Mostrar o período atual e visão geral',
    'pref_languages_locale'                     => 'Para que um idioma diferente do inglês funcione corretamente, seu sistema operacional deve estar configurado com as informações locais corretas. Se estas não estiverem presentes, os dados de moeda, as datas e os montantes podem ser formatados incorretamente.',
    'budget_in_period'                          => 'Todas as transações para orçamento ":name" entre :start e :end na moeda :currency',
    'chart_budget_in_period'                    => 'Gráfico para todas as transações do orçamento ":name" entre :start e :end em :currency',
    'chart_budget_in_period_only_currency'      => 'O valor que você orçou foi em :currency, então este gráfico mostrará apenas transações em :currency.',
    'chart_account_in_period'                   => 'Gráfico para todas as transações para a conta ":name" (:balance) entre :start e :end',
    'chart_category_in_period'                  => 'Gráfico para todas as transações para a categoria ":name" entre :start e :end',
    'chart_category_all'                        => 'Gráfico para todas as transações para a categoria ":name"',
    'clone_withdrawal'                          => 'Clonar esta saída',
    'clone_deposit'                             => 'Clonar esta entrada',
    'clone_transfer'                            => 'Clonar esta transferência',
    'multi_select_no_selection'                 => 'Nenhum selecionado',
    'multi_select_select_all'                   => 'Selecionar tudo',
    'multi_select_n_selected'                   => 'selecionado',
    'multi_select_all_selected'                 => 'Todos selecionados',
    'multi_select_filter_placeholder'           => 'Encontrar..',
    'intro_next_label'                          => 'Próximo',
    'intro_prev_label'                          => 'Anterior',
    'intro_skip_label'                          => 'Pular',
    'intro_done_label'                          => 'Concluído',
    'between_dates_breadcrumb'                  => 'Entre :start e :end',
    'all_journals_without_budget'               => 'Todas as transações sem um orçamento',
    'journals_without_budget'                   => 'Transações sem um orçamento',
    'all_journals_without_category'             => 'Todas as transações sem uma categoria',
    'journals_without_category'                 => 'Transações sem uma categoria',
    'all_journals_for_account'                  => 'Todas as transações para conta :name',
    'chart_all_journals_for_account'            => 'Gráfico de todas as transações para conta :name',
    'journals_in_period_for_account'            => 'Todas as transações para conta :name entre :start e :end',
    'journals_in_period_for_account_js'         => 'Todas as transações para conta {title} entre {start} e {end}',
    'transferred'                               => 'Transferido',
    'all_withdrawal'                            => 'Todas as despesas',
    'all_transactions'                          => 'Todas as transações',
    'title_withdrawal_between'                  => 'Todas as despesas entre :start e :end',
    'all_deposit'                               => 'Todas as receitas',
    'title_deposit_between'                     => 'Todas as receitas entre :start e :end',
    'all_transfers'                             => 'Todas as transferências',
    'title_transfers_between'                   => 'Todas as transferências entre :start e :end',
    'all_transfer'                              => 'Todas as transferências',
    'all_journals_for_tag'                      => 'Todas as transações para tag ":tag"',
    'title_transfer_between'                    => 'Todas as transferências entre :start e :end',
    'all_journals_for_category'                 => 'Todas as transações para categoria :name',
    'all_journals_for_budget'                   => 'Todas as transações para orçamento :name',
    'chart_all_journals_for_budget'             => 'Gráfico de todas as transações para orçamento :name',
    'journals_in_period_for_category'           => 'Todas as transações para a categoria :name entre :start e :end',
    'journals_in_period_for_tag'                => 'Todas as transações para tag :tag entre :start e :end',
    'not_available_demo_user'                   => 'O recurso que você tenta acessar não está disponível para usuários da demo.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'A conta ativa de origem "@source_name" aceita apenas transações em @source_currency. A conta ativa de destino "@dest_name" aceita apenas transações em @dest_currency. Você deve fornecer o valor transferido corretamente em ambas as moedas.',
    'transaction_data'                          => 'Dados de transação',
    'invalid_server_configuration'              => 'Configuração do servidor inválida',
    'invalid_locale_settings'                   => 'O Firefly III não é capaz de formatar valores monetários porque seu servidor não tem os pacotes necessários. Veja as <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instruções de como resolver isso</a>.',
    'quickswitch'                               => 'Mudança rápida',
    'sign_in_to_start'                          => 'Faça login para iniciar sua sessão',
    'sign_in'                                   => 'Entrar',
    'register_new_account'                      => 'Cadastrar uma nova conta',
    'forgot_my_password'                        => 'Esqueci minha senha',
    'problems_with_input'                       => 'Houve alguns problemas com a sua entrada.',
    'reset_password'                            => 'Redefinir sua senha',
    'button_reset_password'                     => 'Redefinir senha',
    'reset_button'                              => 'Redefinir',
    'want_to_login'                             => 'Eu quero fazer o login',
    'login_page_title'                          => 'Login no Firefly III',
    'register_page_title'                       => 'Registrar no Firefly III',
    'forgot_pw_page_title'                      => 'Esqueceu sua senha do Firefly III',
    'reset_pw_page_title'                       => 'Redefinir sua senha para Firefly III',
    'cannot_reset_demo_user'                    => 'Você não pode redefinir a senha do usuário demo.',
    'no_att_demo_user'                          => 'O usuário de demonstração não pode enviar anexos.',
    'button_register'                           => 'Registrar',
    'authorization'                             => 'Autorização',
    'active_bills_only'                         => '',
    'active_bills_only_total'                   => 'todas as assinaturas ativas',
    'active_exp_bills_only'                     => 'somente assinaturas ativas e esperadas',
    'active_exp_bills_only_total'               => 'todas as assinaturas ativas e esperadas',
    'per_period_sum_1D'                         => 'Custos diários esperados',
    'per_period_sum_1W'                         => 'Custos semanais esperados',
    'per_period_sum_1M'                         => 'Custos mensais esperados',
    'per_period_sum_3M'                         => 'Custos trimestrais esperados',
    'per_period_sum_6M'                         => 'Custos semestrais esperados',
    'per_period_sum_1Y'                         => 'Custos anuais esperados',
    'average_per_bill'                          => 'média por assinatura',
    'expected_total'                            => 'total esperado',
    'reconciliation_account_name'               => 'Reconciliação :name (:currency)',
    'saved'                                     => 'Salvo',
    'advanced_options'                          => 'Opções avançadas',
    'advanced_options_explain'                  => 'Algumas páginas no Firefly III têm opções avançadas escondidas atrás deste botão. Esta página não tem nada elaborado aqui, mas confira as outras!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'desabilitado',
    'no_webhook_messages'                       => 'Não há mensagens de webhook',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Após criação da transação',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Após atualização da transação',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Após exclusão da transação',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Detalhes da transação',
    'webhook_response_ACCOUNTS'                 => 'Detalhes da conta',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspecionar',
    'create_new_webhook'                        => 'Criar novo webhook',
    'webhooks_create_breadcrumb'                => 'Criar novo webhook',
    'webhook_trigger_form_help'                 => 'Indica em que evento o webhook será acionado',
    'webhook_response_form_help'                => 'Indica o que o webhook deve enviar para a URL.',
    'webhook_delivery_form_help'                => 'Em que formato o webhook deverá entregar os dados.',
    'webhook_active_form_help'                  => 'O webhook deverá estar ativo ou não será chamado.',
    'stored_new_webhook'                        => 'Novo webhook armazenado: ":title"',
    'delete_webhook'                            => 'Excluir webhook',
    'deleted_webhook'                           => 'Webhook ":title" excluído',
    'edit_webhook'                              => 'Editar webhook ":title"',
    'updated_webhook'                           => 'Webhook ":title" atualizado',
    'edit_webhook_js'                           => 'Editar webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'O webhook foi acionado na transação indicada. Por favor, aguarde os resultados aparecerem.',
    'webhook_messages'                          => 'Mensagem do webhook',
    'view_message'                              => 'Ver mensagem',
    'view_attempts'                             => 'Ver tentativas que falharam',
    'message_content_title'                     => 'Conteúdo da mensagem do webhook',
    'message_content_help'                      => 'Este é o conteúdo da mensagem enviada (ou a tentativa) usando este webhook.',
    'attempt_content_title'                     => 'Tentativas do webhook',
    'attempt_content_help'                      => 'Estas são todas as tentativas mal sucedidas do webhook enviar mensagem para a URL configurada. Depois de algum tempo, Firefly III parará de tentar.',
    'no_attempts'                               => 'Não há tentativas mal sucedidas. Esta é uma coisa boa!',
    'webhook_attempt_at'                        => 'Tentativa em {moment}',
    'logs'                                      => 'Registros',
    'response'                                  => 'Resposta',
    'visit_webhook_url'                         => 'Acesse a URL do webhook',
    'reset_webhook_secret'                      => 'Redefinir chave do webhook',
    'webhook_stored_link'                       => '<a href="transactions/show/{ID}">Webhooh #{ID} ("{title}")</a> foi salva.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") foi atualizado.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Pedido de autorização',
    'authorization_request_intro'               => 'O aplicativo "<strong>:client</strong>" está solicitando permissão para acessar sua administração financeira. Você deseja autorizar o acesso a estes registros a <strong>:client</strong>?',
    'authorization_request_site'                => 'Você será redirecionado para <code>:url</code> que então será capaz de acessar seus dados do Firefly III.',
    'authorization_request_invalid'             => 'Este pedido de acesso é inválido. Por favor, nunca mais acesse este link novamente.',
    'scopes_will_be_able'                       => 'Esta aplicação será capaz de:',
    'button_authorize'                          => 'Autorizar',
    'none_in_select_list'                       => '(nenhum)',
    'no_piggy_bank'                             => '(nenhum cofrinho)',
    'name_in_currency'                          => ':name em :currency',
    'paid_in_currency'                          => 'Pago em :currency',
    'unpaid_in_currency'                        => 'Não pago em :currency',
    'is_alpha_warning'                          => 'Você está executando uma versão ALPHA. Cuidado com bugs e problemas.',
    'is_beta_warning'                           => 'Você está executando uma versão BETA. Cuidado com bugs e problemas.',
    'all_destination_accounts'                  => 'Contas de destino',
    'all_source_accounts'                       => 'Contas de origem',
    'back_to_index'                             => 'Voltar ao índice',
    'cant_logout_guard'                         => 'Firefly III não pode te deslogar.',
    'internal_reference'                        => 'Referência interna',

    // check for updates:
    'update_check_title'                        => 'Verificar Atualizações',
    'admin_update_check_title'                  => 'Verificar atualização automaticamente',
    'admin_update_check_explain'                => 'O Firefly lll pode checar por atualizações automaticamente. Quando você ativa essa configuração, o servidor de atualização do Firefly lll será contatado para ver se uma nova versão está disponível. Quando estiver, você receberá uma notificação. Você pode testar essa notificação utilizando o botão à direita. Por favor, indique abaixo se você quer que o Firefly lll verifique por atualizações.',
    'check_for_updates_permission'              => 'O Firefly III pode verificar atualizações, mas precisa da sua permissão para fazê-lo. Acesse as <a href=":link">configurações</a> para indicar se você gostaria que esse recurso fosse ativado.',
    'updates_ask_me_later'                      => 'Pergunte-me depois',
    'updates_do_not_check'                      => 'Não verifique se há atualizações',
    'updates_enable_check'                      => 'Habilitar a verificação de atualizações',
    'admin_update_check_now_title'              => 'Verifique se há atualizações agora',
    'admin_update_check_now_explain'            => 'Se você pressionar o botão, o Firefly III verá se sua versão atual é a mais recente.',
    'check_for_updates_button'                  => 'Verifique agora!',
    'update_new_version_alert'                  => 'Uma nova versão do Firefly lll está disponível. Você está utilizando a versão :your_version, e a nova é a :new_version, que foi lançada no dia :date.',
    'update_version_beta'                       => 'Esta versão é uma versão BETA. Você pode encontrar problemas.',
    'update_version_alpha'                      => 'Esta versão é uma versão ALPHA. Você pode encontrar problemas.',
    'update_current_dev_older'                  => 'Você está executando a versão de desenvolvimento ":version", que é mais antiga que o último lançamento :new_version. Por favor, atualize!',
    'update_current_dev_newer'                  => 'Você está executando a versão de desenvolvimento ":version", que é mais recente que o último lançamento :new_version.',
    'update_current_version_alert'              => 'Você está utilizando a versão :version, que é a última disponível.',
    'update_newer_version_alert'                => 'Você está utilizando a versão :your_version, que é mais nova do que a mais recente :new_version.',
    'update_check_error'                        => 'Ocorreu um erro durante a verificação de atualizações: :error',
    'unknown_error'                             => 'Erro desconhecido. Desculpe por isso.',
    'disabled_but_check'                        => 'Você desativou a verificação de atualizações. Então, não se esqueça de verificar se há atualizações de vez em quando. Obrigado!',
    'admin_update_channel_title'                => 'Atualizar canal',
    'admin_update_channel_explain'              => 'O Firefly lll tem três "canais" de atualizações que determinam o quão à frente da curva você está em termos de funções, melhorias e bugs. Utilize o canal "beta" se você é aventureiro, e o "alpha" se você gosta de viver a vida perigosamente.',
    'update_channel_stable'                     => 'Estável. Tudo deve funcionar como esperado.',
    'update_channel_beta'                       => 'Beta. Novas funções, mas as coisas podem estar quebradas.',
    'update_channel_alpha'                      => 'Alfa. Nós tentamos várias coisas e usamos o que funcionar.',

    // search
    'search'                                    => 'Pesquisa',
    'search_query'                              => 'Pedido',
    'search_found_transactions'                 => 'Firefly III encontrou :count transação em :time segundos.|Firefly III encontrou :count transações em :time segundos.',
    'search_found_more_transactions'            => 'Firefly III encontrou mais de :count transações em :time segundos.',
    'search_for_overview'                       => 'O Firefly III está procurando por transações que preencham <b>todas</b> as seguintes condições:',
    'search_for_query'                          => 'Todas estas palavras devem estar presentes: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Nenhuma destas palavras pode estar presente: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Estes parâmetros de busca não são válidos e foram ignorados.',

    // old


    'search_modifier_date_on'                             => 'A data da transação é ":value"',
    'search_modifier_not_date_on'                         => 'A data da transação não é ":value"',
    'search_modifier_reconciled'                          => 'Transação está reconciliada',
    'search_modifier_not_reconciled'                      => 'Transação não está reconciliada',
    'search_modifier_id'                                  => 'O ID da transação é ":value"',
    'search_modifier_not_id'                              => 'O ID da transação não é ":value"',
    'search_modifier_date_before'                         => 'Data da transação é anterior ou em ":value"',
    'search_modifier_date_after'                          => 'Data da transação é posterior ou em ":value"',
    'search_modifier_external_id_is'                      => 'O ID externo é ":value"',
    'search_modifier_not_external_id_is'                  => 'ID Externo não é ":value"',
    'search_modifier_no_external_url'                     => 'A transação não tem URL externa',
    'search_modifier_no_external_id'                      => 'A transação não tem ID externo',
    'search_modifier_not_any_external_url'                => 'A transação não tem URL externa',
    'search_modifier_not_any_external_id'                 => 'A transação não tem ID externo',
    'search_modifier_any_external_url'                    => 'A transação deve ter uma URL externa (qualquer)',
    'search_modifier_any_external_id'                     => 'A transação deve ter um (qualquer) ID externo',
    'search_modifier_not_no_external_url'                 => 'A transação deve ter uma URL externa (qualquer)',
    'search_modifier_not_no_external_id'                  => 'A transação deve ter um (qualquer) ID externo',
    'search_modifier_internal_reference_is'               => 'A referência interna é ":value"',
    'search_modifier_not_internal_reference_is'           => 'Referência interna não é ":value"',
    'search_modifier_description_starts'                  => 'Descrição começa com ":value"',
    'search_modifier_not_description_starts'              => 'Descrição não começa com ":value"',
    'search_modifier_description_ends'                    => 'Descrição termina em ":value"',
    'search_modifier_not_description_ends'                => 'Descrição não termina com ":value"',
    'search_modifier_description_contains'                => 'Descrição contém ":value"',
    'search_modifier_not_description_contains'            => 'Descrição não contém ":value"',
    'search_modifier_description_is'                      => 'Descrição é exatamente ":value"',
    'search_modifier_not_description_is'                  => 'Descrição não é exatamente ":value"',
    'search_modifier_currency_is'                         => 'A moeda da transação (estrangeira) é ":value"',
    'search_modifier_not_currency_is'                     => 'A moeda (estrangeira) da transação não é ":value"',
    'search_modifier_foreign_currency_is'                 => 'A moeda estrangeira da transação é ":value"',
    'search_modifier_not_foreign_currency_is'             => 'A moeda estrangeira da transação não é ":value"',
    'search_modifier_has_attachments'                     => 'A transação deve ter um anexo',
    'search_modifier_has_no_category'                     => 'A transação não deve ter nenhuma categoria',
    'search_modifier_not_has_no_category'                 => 'A transação deve ter (qualquer) categoria',
    'search_modifier_not_has_any_category'                => 'A transação não deve ter nenhuma categoria',
    'search_modifier_has_any_category'                    => 'A transação deve ter uma categoria (qualquer)',
    'search_modifier_has_no_budget'                       => 'A transação não deve ter orçamento',
    'search_modifier_not_has_any_budget'                  => 'A transação não deve ter orçamento',
    'search_modifier_has_any_budget'                      => 'A transação deve ter um orçamento (qualquer)',
    'search_modifier_not_has_no_budget'                   => 'A transação deve ter (qualquer) orçamento',
    'search_modifier_has_no_bill'                         => 'A transação não pode ter nenhuma assinatura',
    'search_modifier_not_has_no_bill'                     => 'A transação deve ter alguma assinatura',
    'search_modifier_has_any_bill'                        => 'A transação deve ter alguma assinatura',
    'search_modifier_not_has_any_bill'                    => 'A transação não pode ter nenhuma assinatura',
    'search_modifier_has_no_tag'                          => 'A transação não deve ter tags',
    'search_modifier_not_has_any_tag'                     => 'A transação não deve ter tags',
    'search_modifier_not_has_no_tag'                      => 'A transação deve ter uma tag (qualquer)',
    'search_modifier_has_any_tag'                         => 'A transação deve ter uma tag (qualquer)',
    'search_modifier_notes_contains'                      => 'As notas de transação contém ":value"',
    'search_modifier_not_notes_contains'                  => 'As anotações da transação não contém ":value"',
    'search_modifier_notes_starts'                        => 'As notas de transação começam com ":value"',
    'search_modifier_not_notes_starts'                    => 'As anotações da transação não começam com ":value"',
    'search_modifier_notes_ends'                          => 'As notas de transação terminam com ":value"',
    'search_modifier_not_notes_ends'                      => 'As anotações da transação não terminam com ":value"',
    'search_modifier_notes_is'                            => 'As notas de transação são iguais a ":value"',
    'search_modifier_not_notes_is'                        => 'As anotações da transação não são iguais a ":value"',
    'search_modifier_no_notes'                            => 'A transação não tem notas',
    'search_modifier_not_no_notes'                        => 'A transação deve ter anotações',
    'search_modifier_any_notes'                           => 'A transação deve ter notas',
    'search_modifier_not_any_notes'                       => 'A transação não tem anotações',
    'search_modifier_amount_is'                           => 'Valor é exatamente :value',
    'search_modifier_not_amount_is'                       => 'O valor não é :value',
    'search_modifier_amount_less'                         => 'Valor é menor ou igual a :value',
    'search_modifier_not_amount_more'                     => 'O valor é menor ou igual a :value',
    'search_modifier_amount_more'                         => 'Valor é maior ou igual a :value',
    'search_modifier_not_amount_less'                     => 'O valor é maior ou igual a :value',
    'search_modifier_source_account_is'                   => 'O nome da conta de origem é igual a ":value"',
    'search_modifier_not_source_account_is'               => 'O nome da conta de origem não é igual a ":value"',
    'search_modifier_source_account_contains'             => 'O nome da conta de origem contém ":value"',
    'search_modifier_not_source_account_contains'         => 'O nome da conta de origem não contém ":value"',
    'search_modifier_source_account_starts'               => 'Nome da conta de origem começa com ":value"',
    'search_modifier_not_source_account_starts'           => 'O nome da conta de origem não começa com ":value"',
    'search_modifier_source_account_ends'                 => 'O nome da conta de origem termina com ":value"',
    'search_modifier_not_source_account_ends'             => 'O nome da conta de origem não termina com ":value"',
    'search_modifier_source_account_id'                   => 'ID da conta de origem é :value',
    'search_modifier_not_source_account_id'               => 'ID da conta de origem não é :value',
    'search_modifier_source_account_nr_is'                => 'Número da conta de origem (IBAN) é ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Número da conta de origem (IBAN) não é ":value"',
    'search_modifier_source_account_nr_contains'          => 'Número da conta de origem (IBAN) contém ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Número da conta de origem (IBAN) não contém ":value"',
    'search_modifier_source_account_nr_starts'            => 'Número da conta de origem (IBAN) começa com ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Número da conta de origem (IBAN) não começa com ":value"',
    'search_modifier_source_account_nr_ends'              => 'Número da conta de origem (IBAN) termina com ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Número da conta de origem (IBAN) não termina com ":value"',
    'search_modifier_destination_account_is'              => 'O nome da conta de destino é igual a ":value"',
    'search_modifier_not_destination_account_is'          => 'O nome da conta de destino não é ":value"',
    'search_modifier_destination_account_contains'        => 'Nome da conta de destino contém ":value"',
    'search_modifier_not_destination_account_contains'    => 'Nome da conta de destino não contém ":value"',
    'search_modifier_destination_account_starts'          => 'O nome da conta de destino começa com ":value"',
    'search_modifier_not_destination_account_starts'      => 'Nome da conta de destino não começa com ":value"',
    'search_modifier_destination_account_ends'            => 'Nome da conta de destino termina com ":value"',
    'search_modifier_not_destination_account_ends'        => 'Nome da conta de destino não termina com ":value"',
    'search_modifier_destination_account_id'              => 'ID da conta de destino é :value',
    'search_modifier_not_destination_account_id'          => 'ID da conta de destino não é :value',
    'search_modifier_destination_is_cash'                 => 'A conta de destino é conta "(dinheiro)"',
    'search_modifier_not_destination_is_cash'             => 'A conta de destino não é a conta "(dinheiro)"',
    'search_modifier_source_is_cash'                      => 'A conta de origem é a conta "(dinheiro)"',
    'search_modifier_not_source_is_cash'                  => 'A conta de origem não é a conta "(dinheiro)"',
    'search_modifier_destination_account_nr_is'           => 'Número da conta de destino (IBAN) é ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Número da conta de destino (IBAN) é ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Número da conta de destino (IBAN) contém ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Número da conta de destino (IBAN) não contém ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Número da conta de destino (IBAN) começa com ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Número da conta de destino (IBAN) não começa com ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Número da conta de destino (IBAN) termina com ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Número da conta de destino (IBAN) não termina com ":value"',
    'search_modifier_account_id'                          => 'ID(s) da conta de origem ou destino é/são: :value',
    'search_modifier_not_account_id'                      => 'ID(s) da conta de origem ou destino não é/são: :value',
    'search_modifier_category_is'                         => 'A categoria é ":value"',
    'search_modifier_not_category_is'                     => 'A categoria não é ":value"',
    'search_modifier_budget_is'                           => 'O orçamento é ":value"',
    'search_modifier_not_budget_is'                       => 'Orçamento não é ":value"',
    'search_modifier_bill_is'                             => 'A assinatura é ":value"',
    'search_modifier_not_bill_is'                         => 'Assinatura não é ":value"',
    'search_modifier_transaction_type'                    => 'O tipo da transação é ":value"',
    'search_modifier_not_transaction_type'                => 'Tipo de transação não é ":value"',
    'search_modifier_tag_is'                              => 'A tag é ":value"',
    'search_modifier_tag_contains'                        => 'Tag contém ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag não contém ":value"',
    'search_modifier_tag_ends'                            => 'Tag termina com ":value"',
    'search_modifier_tag_starts'                          => 'Tag começa com ":value"',
    'search_modifier_not_tag_is'                          => 'Nenhuma tag é ":value"',
    'search_modifier_date_on_year'                        => 'Transação é no ano de ":value"',
    'search_modifier_not_date_on_year'                    => 'Transação não está no ano ":value"',
    'search_modifier_date_on_month'                       => 'Transação é no mês de ":value"',
    'search_modifier_not_date_on_month'                   => 'Transação não está em mês ":value"',
    'search_modifier_date_on_day'                         => 'Transação é no dia do mês de ":value"',
    'search_modifier_not_date_on_day'                     => 'Transação não está no dia do mês ":value"',
    'search_modifier_date_before_year'                    => 'Transação é antes ou no ano de ":value"',
    'search_modifier_date_before_month'                   => 'Transação é antes ou no mês de ":value"',
    'search_modifier_date_before_day'                     => 'A transação é antes ou no dia do mês ":value"',
    'search_modifier_date_after_year'                     => 'Transação está no ano ou após ":value"',
    'search_modifier_date_after_month'                    => 'Transação está no mês ou após ":value"',
    'search_modifier_date_after_day'                      => 'Transação é depois ou no dia do mês de ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Nenhuma tag é ":value"',
    'search_modifier_not_tag_is_not'                      => 'A tag é ":value"',
    'search_modifier_account_is'                          => 'Ou a conta é ":value"',
    'search_modifier_not_account_is'                      => 'Nenhuma conta é ":value"',
    'search_modifier_account_contains'                    => 'Ou a conta contém ":value"',
    'search_modifier_not_account_contains'                => 'Nenhuma conta contém ":value"',
    'search_modifier_account_ends'                        => 'Ou a conta termina com ":value"',
    'search_modifier_not_account_ends'                    => 'Nenhuma conta termina com ":value"',
    'search_modifier_account_starts'                      => 'Ou a conta começa com ":value"',
    'search_modifier_not_account_starts'                  => 'Nenhuma conta começa com ":value"',
    'search_modifier_account_nr_is'                       => 'Ou número da conta / IBAN é ":value"',
    'search_modifier_not_account_nr_is'                   => 'Nenhum número de conta / IBAN é ":value"',
    'search_modifier_account_nr_contains'                 => 'Ou número da conta / IBAN contém ":value"',
    'search_modifier_not_account_nr_contains'             => 'Nenhum número de conta / IBAN contém ":value"',
    'search_modifier_account_nr_ends'                     => 'Ou número de conta / IBAN termina com ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Nenhum número de conta / IBAN termina com ":value"',
    'search_modifier_account_nr_starts'                   => 'Ou número da conta / IBAN começa com ":value"',
    'search_modifier_not_account_nr_starts'               => 'Nenhum número de conta / IBAN começa com ":value"',
    'search_modifier_category_contains'                   => 'Categoria contém ":value"',
    'search_modifier_not_category_contains'               => 'Categoria não contém ":value"',
    'search_modifier_category_ends'                       => 'Categoria termina em ":value"',
    'search_modifier_not_category_ends'                   => 'Categoria não termina em ":value"',
    'search_modifier_category_starts'                     => 'Categoria começa com ":value"',
    'search_modifier_not_category_starts'                 => 'Categoria não começa com ":value"',
    'search_modifier_budget_contains'                     => 'Orçamento contém ":value"',
    'search_modifier_not_budget_contains'                 => 'Orçamento não contém ":value"',
    'search_modifier_budget_ends'                         => 'Orçamento termina com ":value"',
    'search_modifier_not_budget_ends'                     => 'Orçamento não termina em ":value"',
    'search_modifier_budget_starts'                       => 'Orçamento começa com ":value"',
    'search_modifier_not_budget_starts'                   => 'Orçamento não começa com ":value"',
    'search_modifier_bill_contains'                       => 'Assinatura contém ":value"',
    'search_modifier_not_bill_contains'                   => 'Assinatura não contém com ":value"',
    'search_modifier_bill_ends'                           => 'Assinatura termina com ":value"',
    'search_modifier_not_bill_ends'                       => 'Assinatura não termina com ":value"',
    'search_modifier_bill_starts'                         => 'Assinatura começa com ":value"',
    'search_modifier_not_bill_starts'                     => 'Assinatura não começa com ":value"',
    'search_modifier_external_id_contains'                => 'ID Externo contém ":value"',
    'search_modifier_not_external_id_contains'            => 'ID Externo não contém ":value"',
    'search_modifier_external_id_ends'                    => 'ID Externo termina com ":value"',
    'search_modifier_not_external_id_ends'                => 'ID Externo não termina com ":value"',
    'search_modifier_external_id_starts'                  => 'ID Externo começa com ":value"',
    'search_modifier_not_external_id_starts'              => 'ID Externo não inicia com ":value"',
    'search_modifier_internal_reference_contains'         => 'Referência interna contém ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Referência interna não contém ":value"',
    'search_modifier_internal_reference_ends'             => 'Referência interna termina com ":value"',
    'search_modifier_internal_reference_starts'           => 'Referência interna começa com ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Referência interna não termina com ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Referência interna não inicia com ":value"',
    'search_modifier_external_url_is'                     => 'URL externa é ":value"',
    'search_modifier_not_external_url_is'                 => 'URL externa não é ":value"',
    'search_modifier_external_url_contains'               => 'URL externa contém ":value"',
    'search_modifier_not_external_url_contains'           => 'URL externa não contém ":value"',
    'search_modifier_external_url_ends'                   => 'URL externa termina com ":value"',
    'search_modifier_not_external_url_ends'               => 'URL externa não termina com ":value"',
    'search_modifier_external_url_starts'                 => 'URL externa começa com ":value"',
    'search_modifier_not_external_url_starts'             => 'URL externa não inicia com ":value"',
    'search_modifier_has_no_attachments'                  => 'A transação não tem anexos',
    'search_modifier_not_has_no_attachments'              => 'A transação tem anexos',
    'search_modifier_not_has_attachments'                 => 'A transação não tem anexos',
    'search_modifier_account_is_cash'                     => 'Qualquer outra conta é a conta em "(dinheiro)".',
    'search_modifier_not_account_is_cash'                 => 'Nenhuma das contas é a conta em "(dinheiro)".',
    'search_modifier_journal_id'                          => 'O ID do registro é ":value"',
    'search_modifier_not_journal_id'                      => 'O ID do diário não é ":value"',
    'search_modifier_recurrence_id'                       => 'O ID da transação recorrente é ":value"',
    'search_modifier_not_recurrence_id'                   => 'O ID de transação recorrente não é ":value"',
    'search_modifier_foreign_amount_is'                   => 'A quantidade em moeda estrangeira é ":value"',
    'search_modifier_not_foreign_amount_is'               => 'A quantidade em moeda estrangeira não é ":value"',
    'search_modifier_foreign_amount_less'                 => 'A quantidade em moeda estrangeira é menor que ":value"',
    'search_modifier_not_foreign_amount_more'             => 'A quantidade em moeda estrangeira é menor que ":value"',
    'search_modifier_not_foreign_amount_less'             => 'A quantidade em moeda estrangeira é maior que ":value"',
    'search_modifier_foreign_amount_more'                 => 'A quantidade em moeda estrangeira é maior que ":value"',
    'search_modifier_exists'                              => 'Transação existe (qualquer transação)',
    'search_modifier_not_exists'                          => 'Transação não existe (sem transação)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Data de juros da transação é ":value"',
    'search_modifier_not_interest_date_on'                => 'Data de juros da transação não é ":value"',
    'search_modifier_interest_date_on_year'               => 'Data de juros da transação está no ano de ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Data de juros da transação não está no ano ":value"',
    'search_modifier_interest_date_on_month'              => 'Data de juros da transação é no mês de ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Data de juros da transação não está no mês ":value"',
    'search_modifier_interest_date_on_day'                => 'Data de juros da transação é no dia do mês de ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Data de juros da transação não é no dia do mês ":value"',
    'search_modifier_interest_date_before_year'           => 'Data de juros da transação é antes ou no ano de ":value"',
    'search_modifier_interest_date_before_month'          => 'Data de juros da transação é antes ou no mês de ":value"',
    'search_modifier_interest_date_before_day'            => 'Data de juros da transação é antes ou no dia do mês de ":value"',
    'search_modifier_interest_date_after_year'            => 'Data de juros da transação é após ou no ano de ":value"',
    'search_modifier_interest_date_after_month'           => 'Data de juros da transação é posterior ou no mês de ":value"',
    'search_modifier_interest_date_after_day'             => 'Data de juros da transação é após ou no dia do mês de ":value"',
    'search_modifier_book_date_on_year'                   => 'Data de lançamento está no ano de ":value"',
    'search_modifier_book_date_on_month'                  => 'Data de lançamento é no mês de ":value"',
    'search_modifier_book_date_on_day'                    => 'Data de lançamento é no dia do mês de ":value"',
    'search_modifier_not_book_date_on_year'               => 'Data de lançamento não é no ano ":value"',
    'search_modifier_not_book_date_on_month'              => 'Data de lançamento não é no mês ":value"',
    'search_modifier_not_book_date_on_day'                => 'Data de lançamento não é no dia do mês ":value"',
    'search_modifier_book_date_before_year'               => 'Data de lançamento é antes ou no ano de ":value"',
    'search_modifier_book_date_before_month'              => 'Data de lançamento é antes ou no mês de ":value"',
    'search_modifier_book_date_before_day'                => 'Data de lançamento é antes ou no dia do mês de ":value"',
    'search_modifier_book_date_after_year'                => 'Data de lançamento é posterior ou no ano de ":value"',
    'search_modifier_book_date_after_month'               => 'Data de lançamento é posterior ou no mês de ":value"',
    'search_modifier_book_date_after_day'                 => 'Data de registro da transação é posterior ou no dia do mês de ":value"',
    'search_modifier_process_date_on_year'                => 'Data de processamento da transação está no ano de ":value"',
    'search_modifier_process_date_on_month'               => 'Data de processamento da transação está no mês de ":value"',
    'search_modifier_process_date_on_day'                 => 'Data de processamento da transação está no dia do mês de ":value"',
    'search_modifier_not_process_date_on_year'            => 'Data do processasmento da transação não é no ano ":value"',
    'search_modifier_not_process_date_on_month'           => 'Data do processasmento da transação é no mês ":value"',
    'search_modifier_not_process_date_on_day'             => 'Data do processasmento da transação não é no dia do mês ":value"',
    'search_modifier_process_date_before_year'            => 'Data de processamento da transação é antes ou no ano de ":value"',
    'search_modifier_process_date_before_month'           => 'Data de processamento da transação é antes ou no mês de ":value"',
    'search_modifier_process_date_before_day'             => 'Data de processamento da transação é antes ou no dia do mês de ":value"',
    'search_modifier_process_date_after_year'             => 'Data de processamento da transação é posterior ou no ano de ":value"',
    'search_modifier_process_date_after_month'            => 'Data de processamento da transação é posterior ou no mês de ":value"',
    'search_modifier_process_date_after_day'              => 'Data de processamento da transação é posterior ou no dia do mês de ":value"',
    'search_modifier_due_date_on_year'                    => 'Data de vencimento da transação é no ano de ":value"',
    'search_modifier_due_date_on_month'                   => 'Data de vencimento da transação é no mês de ":value"',
    'search_modifier_due_date_on_day'                     => 'Data de vencimento da transação é no dia do mês de ":value"',
    'search_modifier_not_due_date_on_year'                => 'Data de vencimento da transação não é no ano ":value"',
    'search_modifier_not_due_date_on_month'               => 'Data de vencimento da transação não é no mês ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Data de vencimento da transação não é no dia do mês ":value"',
    'search_modifier_due_date_before_year'                => 'Data de vencimento da transação é antes ou no ano de ":value"',
    'search_modifier_due_date_before_month'               => 'Data de vencimento da transação é antes ou no mês de ":value"',
    'search_modifier_due_date_before_day'                 => 'Data de vencimento da transação é antes ou no dia do mês de ":value"',
    'search_modifier_due_date_after_year'                 => 'Data de vencimento da transação é posterior ou no ano de ":value"',
    'search_modifier_due_date_after_month'                => 'Data de vencimento da transação é posterior ou no mês de ":value"',
    'search_modifier_due_date_after_day'                  => 'Data de vencimento da transação é posterior ou no dia do mês de ":value"',
    'search_modifier_payment_date_on_year'                => 'Data de pagamento da transação é no ano de ":value"',
    'search_modifier_payment_date_on_month'               => 'Data de pagamento da transação é no dia do mês de ":value"',
    'search_modifier_payment_date_on_day'                 => 'Data de pagamento da transação é no dia do mês de ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Data de pagamento da transação não é no ano ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Data de pagamento da transação não está no mês ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Data de pagamento da transação não é no dia do mês ":value"',
    'search_modifier_payment_date_before_year'            => 'Data de pagamento da transação é antes ou no ano de ":value"',
    'search_modifier_payment_date_before_month'           => 'Data de pagamento da transação é antes ou no mês de ":value"',
    'search_modifier_payment_date_before_day'             => 'Data de pagamento da transação é antes ou no dia do mês de ":value"',
    'search_modifier_payment_date_after_year'             => 'Data de pagamento da transação é posterior ou no ano de ":value"',
    'search_modifier_payment_date_after_month'            => 'Data de pagamento da transação é posterior ou no mês de ":value"',
    'search_modifier_payment_date_after_day'              => 'Data de pagamento da transação é posterior ou no dia do mês de ":value"',
    'search_modifier_invoice_date_on_year'                => 'Data de fatura da transação está no ano de ":value"',
    'search_modifier_invoice_date_on_month'               => 'Data de fatura da transação está no mês de ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Data de fatura da transação é no dia do mês de ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Data de fatura da transação não é no ano ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Data de fatura da transação não é no mês ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Data de fatura da transação não é no dia do mês ":value"',
    'search_modifier_invoice_date_before_year'            => 'Data de fatura da transação é antes ou no ano de ":value"',
    'search_modifier_invoice_date_before_month'           => 'Data da fatura da transação é antes ou em no mês de ":value"',
    'search_modifier_invoice_date_before_day'             => 'Data de fatura da transação é antes ou no dia do mês de ":value"',
    'search_modifier_invoice_date_after_year'             => 'Data de fatura da transação é posterior ou no ano de ":value"',
    'search_modifier_invoice_date_after_month'            => 'Data de fatura da transação é antes ou no ano de ":value"',
    'search_modifier_invoice_date_after_day'              => 'Data de pagamento da transação é antes ou no dia do mês de ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'A transação foi atualizada pela última vez no ano de ":value"',
    'search_modifier_updated_at_on_month'                 => 'A transação foi atualizada pela última vez no mês de ":value"',
    'search_modifier_updated_at_on_day'                   => 'A transação foi atualizada pela última vez no dia do mês de ":value"',
    'search_modifier_not_updated_at_on_year'              => 'A transação não foi atualizada pela última vez no ano ":value"',
    'search_modifier_not_updated_at_on_month'             => 'A transação não foi atualizada pela última vez no mês de ":value"',
    'search_modifier_not_updated_at_on_day'               => 'A transação não foi atualizada pela última vez no dia do mês ":value"',
    'search_modifier_updated_at_before_year'              => 'A transação foi atualizada pela última vez no ano, ou antes de ":value"',
    'search_modifier_updated_at_before_month'             => 'A transação foi atualizada pela última vez no mês ou antes de ":value"',
    'search_modifier_updated_at_before_day'               => 'A transação foi atualizada pela última vez no dia do mês ou antes de ":value"',
    'search_modifier_updated_at_after_year'               => 'A transação foi atualizada pela última vez no ano, ou depois de ":value"',
    'search_modifier_updated_at_after_month'              => 'A transação foi atualizada pela última vez no mês ou depois de ":value"',
    'search_modifier_updated_at_after_day'                => 'A transação foi atualizada pela última vez no dia do mês ou depois de ":value"',
    'search_modifier_created_at_on_year'                  => 'A transação foi criada no ano de ":value"',
    'search_modifier_created_at_on_month'                 => 'A transação foi criada no mês de ":value"',
    'search_modifier_created_at_on_day'                   => 'A transação foi criada no dia do mês de ":value"',
    'search_modifier_not_created_at_on_year'              => 'A transação não foi criada no ano ":value"',
    'search_modifier_not_created_at_on_month'             => 'A transação não foi criada no mês de ":value"',
    'search_modifier_not_created_at_on_day'               => 'A transação não foi criada no dia do mês ":value"',
    'search_modifier_created_at_before_year'              => 'A transação foi criada em ou antes do ano de ":value"',
    'search_modifier_created_at_before_month'             => 'A transação foi criada em ou antes do mês de ":value"',
    'search_modifier_created_at_before_day'               => 'A transação foi criada em ou antes do dia do mês de ":value"',
    'search_modifier_created_at_after_year'               => 'A transação foi criada em ou após o ano de ":value"',
    'search_modifier_created_at_after_month'              => 'A transação foi criada em ou após o mês de ":value"',
    'search_modifier_created_at_after_day'                => 'A transação foi criada em ou após o dia do mês de ":value"',
    'search_modifier_interest_date_before'                => 'Data de juros da transação é em ou antes de ":value"',
    'search_modifier_interest_date_after'                 => 'Data de juros da transação é em ou posterior a ":value"',
    'search_modifier_book_date_on'                        => 'Data de lançamento é em ":value"',
    'search_modifier_not_book_date_on'                    => 'Data de lançamento não está em ":value"',
    'search_modifier_book_date_before'                    => 'Data de lançamento é em ou antes de ":value"',
    'search_modifier_book_date_after'                     => 'Data de lançamento é em ou após ":value"',
    'search_modifier_process_date_on'                     => 'Data de processamento da transação é em ":value"',
    'search_modifier_not_process_date_on'                 => 'Data do processasmento da transação é no mês ":value"',
    'search_modifier_process_date_before'                 => 'Data de processamento da transação é em ou antes de ":value"',
    'search_modifier_process_date_after'                  => 'Data de processamento da transação é em ou após ":value"',
    'search_modifier_due_date_on'                         => 'Data de vencimento da transação é em ":value"',
    'search_modifier_not_due_date_on'                     => 'Data de vencimento da transação não está em ":value"',
    'search_modifier_due_date_before'                     => 'Data de vencimento da transação é em ou antes de ":value"',
    'search_modifier_due_date_after'                      => 'Data de vencimento da transação é em ou após ":value"',
    'search_modifier_payment_date_on'                     => 'Data de pagamento da transação é em ":value"',
    'search_modifier_not_payment_date_on'                 => 'Data de pagamento da transação não está em ":value"',
    'search_modifier_payment_date_before'                 => 'Data de pagamento da transação é em ou antes de ":value"',
    'search_modifier_payment_date_after'                  => 'Data de pagamento da transação é em ou após ":value"',
    'search_modifier_invoice_date_on'                     => 'Data de fatura de transação é em ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Data de fatura de transação não está em ":value"',
    'search_modifier_invoice_date_before'                 => 'Data da fatura de transação é em ou antes de ":value"',
    'search_modifier_invoice_date_after'                  => 'Data da fatura de transação é em ou após ":value"',
    'search_modifier_created_at_on'                       => 'A transação foi criada em ":value"',
    'search_modifier_not_created_at_on'                   => 'Transação não foi criada em ":value"',
    'search_modifier_created_at_before'                   => 'A transação foi criada em ou antes de ":value"',
    'search_modifier_created_at_after'                    => 'A transação foi criada em ou após ":value"',
    'search_modifier_updated_at_on'                       => 'Transação foi atualizada em ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transação não foi atualizada em ":value"',
    'search_modifier_updated_at_before'                   => 'A transação foi atualizada em ou antes de ":value"',
    'search_modifier_updated_at_after'                    => 'A transação foi atualizada em ou após ":value"',

    'search_modifier_attachment_name_is'            => 'Qualquer nome de anexo é ":value"',
    'search_modifier_attachment_name_contains'      => 'Qualquer nome do anexo contém ":value"',
    'search_modifier_attachment_name_starts'        => 'Qualquer nome de anexo começa com ":value"',
    'search_modifier_attachment_name_ends'          => 'Qualquer nome de anexo termina com ":value"',
    'search_modifier_attachment_notes_are'          => 'Qualquer nota de anexo é ":value"',
    'search_modifier_attachment_notes_contains'     => 'Qualquer nota de anexo contém ":value"',
    'search_modifier_attachment_notes_starts'       => 'Qualquer nota de anexo começa com ":value"',
    'search_modifier_attachment_notes_ends'         => 'Qualquer nota de anexo que termina com ":value"',
    'search_modifier_not_attachment_name_is'        => 'Qualquer nome de anexo não é ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Qualquer nome de anexo não contém ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Qualquer nome de anexo não começa com ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Qualquer nome de anexo não termina com ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Qualquer nota de anexo que não seja ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Qualquer nota de anexo não contém ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Qualquer nota de anexo começa com ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Qualquer nota de anexo que não termina com ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT é ":value"',
    'update_rule_from_query'                        => 'Atualizar regra ":rule" da pesquisa',
    'create_rule_from_query'                        => 'Criar nova regra a partir da pesquisa',
    'rule_from_search_words'                        => 'O mecanismo de regra tem dificuldade para tratar ":string". A regra sugerida que se encaixa na sua pesquisa pode retornar resultados diferentes. Por favor, verifique os gatilhos das regras cuidadosamente.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Saldo da conta destino é exatamente ":value"',
    'search_modifier_not_destination_balance_is'    => 'Saldo da conta destino NÃO é exatamente ":value"',
    'search_modifier_source_balance_is'             => 'Saldo da conta de origem é exatamente ":value"',
    'search_modifier_not_source_balance_is'         => 'Saldo da conta de origem NÃO é exatamente ":value"',

    'search_modifier_destination_balance_lte'     => 'Saldo da conta destino é menor ou igual a ":value"',
    'search_modifier_not_destination_balance_lte' => 'Saldo da conta destino é maior que ":value"',
    'search_modifier_source_balance_lte'          => 'Saldo da conta origem é menor ou igual a ":value"',
    'search_modifier_not_source_balance_lte'      => 'Saldo da conta origem é maior que ":value"',

    'search_modifier_destination_balance_lt'     => 'Saldo da conta destino é menor que ":value"',
    'search_modifier_not_destination_balance_lt' => 'Saldo da conta destino é maior ou igual a ":value"',
    'search_modifier_source_balance_lt'          => 'Saldo da conta origem é menor que ":value"',
    'search_modifier_not_source_balance_lt'      => 'Saldo da conta origem é maior ou igual a ":value"',

    'search_modifier_destination_balance_gte'     => 'Saldo da conta destino é maior ou igual a ":value"',
    'search_modifier_not_destination_balance_gte' => 'Saldo da conta destino é menor que ":value"',
    'search_modifier_source_balance_gte'          => 'Saldo da conta origem é maior ou igual a ":value"',
    'search_modifier_not_source_balance_gte'      => 'Saldo da conta origem é menor que ":value"',

    'search_modifier_destination_balance_gt'              => 'Saldo da conta destino é maior que ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Saldo da conta destino é menor ou igual a ":value"',
    'search_modifier_source_balance_gt'                   => 'Saldo da conta origem é maior que ":value"',
    'search_modifier_not_source_balance_gt'               => 'Saldo da conta origem é menor ou igual a ":value"',


    // END
    'general_search_error'                                => 'Um erro ocorreu durante a pesquisa. Por favor, cheque os arquivos de log para mais informações.',
    'search_box'                                          => 'Pesquisar',
    'search_box_intro'                                    => 'Boas vindas a função de pesquisa do Firefly III. Digite sua pesquisa na caixa de consultas. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Certifique-se de verificar o arquivo de ajuda</a>, porque a pesquisa é muito avançada.',
    'search_error'                                        => 'Erro durante a busca',
    'search_searching'                                    => 'Procurando ...',
    'search_results'                                      => 'Resultados da pesquisa',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'anual',
    'repeat_freq_half-year'                               => 'cada semestre',
    'repeat_freq_quarterly'                               => 'trimestral',
    'repeat_freq_monthly'                                 => 'mensal',
    'repeat_freq_weekly'                                  => 'semanal',
    'repeat_freq_daily'                                   => 'diariamente',
    'daily'                                               => 'diariamente',
    'weekly'                                              => 'semanal',
    'quarterly'                                           => 'trimestral',
    'half-year'                                           => 'semestralmente',
    'yearly'                                              => 'anual',

    // rules
    'is_not_rule_trigger'                                 => 'Não é',
    'cannot_fire_inactive_rules'                          => 'Você não pode executar regras inativas.',
    'show_triggers'                                       => 'Exibir gatilhos',
    'show_actions'                                        => 'Exibir ações',
    'rules'                                               => 'Regras',
    'rule_name'                                           => 'Nome da regra',
    'rule_triggers'                                       => 'Regra dispara quando',
    'rule_actions'                                        => 'Regra irá',
    'new_rule'                                            => 'Nova regra',
    'new_rule_group'                                      => 'Novo grupo de regras',
    'rule_priority_up'                                    => 'Dar mais prioridade à regra',
    'rule_priority_down'                                  => 'Dar à regra menos prioridade',
    'make_new_rule_group'                                 => 'Fazer o novo grupo de regras',
    'store_new_rule_group'                                => 'Gravar novo grupo de regras',
    'created_new_rule_group'                              => 'Novo grupo de regras ":title" armazenado!',
    'updated_rule_group'                                  => 'Grupo de regras atualizado com sucesso ":title".',
    'edit_rule_group'                                     => 'Editar grupo de regras ":title"',
    'duplicate_rule'                                      => 'Duplicar regra ":title"',
    'rule_copy_of'                                        => 'Cópia de ":title"',
    'duplicated_rule'                                     => 'Regra duplicada ":title" em ":newTitle"',
    'delete_rule_group'                                   => 'Excluir grupo de regra ":title"',
    'deleted_rule_group'                                  => 'Grupo de regra ":title" excluído',
    'update_rule_group'                                   => 'Atualizar um grupo de regra',
    'no_rules_in_group'                                   => 'Não existem regras neste grupo',
    'move_rule_group_up'                                  => 'Subir o grupo de regras',
    'move_rule_group_down'                                => 'Descer grupo de regras',
    'save_rules_by_moving'                                => 'Salve essa regra movendo-a para outro grupo de regras:|Salve essas regras movendo-as para outro grupo de regras:',
    'make_new_rule'                                       => 'Faça uma nova regra no grupo de regras ":title"',
    'make_new_rule_no_group'                              => 'Criar uma nova regra',
    'instructions_rule_from_bill'                         => 'Para conectar transações com sua nova assinatura ":name", Firefly III pode criar uma regra que automaticamente será verificada a cada transação que você criar. por favor, verifique os detalhes abaixo e salve a regra para que o Firefly III possa conectar automaticamente as transações a sua nova fatura.',
    'instructions_rule_from_journal'                      => 'Crie uma regra com base em uma de suas transações. Complete ou envie o formulário abaixo.',
    'rule_is_strict'                                      => 'regra estrita',
    'rule_is_not_strict'                                  => 'regra não estrita',
    'rule_help_stop_processing'                           => 'Quando você marcar esta caixa, as regras seguintes neste grupo não serão executadas se esta regra em particular for executada.',
    'rule_help_strict'                                    => 'Nas regras estritas TODOS os gatilhos devem ser acionados para que a ação ou ações sejam executadas. Nas regras não-estritas, QUALQUER gatilho será suficiente para que a ação ou ações sejam executadas.',
    'rule_help_active'                                    => 'Regras inativas nunca serão disparadas.',
    'stored_new_rule'                                     => 'Armazenado a nova regra com o título ":title"',
    'deleted_rule'                                        => 'Regra ":title" excluída',
    'store_new_rule'                                      => 'Armazenar nova regra',
    'updated_rule'                                        => 'Regra atualizada com o título ":title"',
    'default_rule_group_name'                             => 'Regras padrão',
    'default_rule_group_description'                      => 'Todas as suas regras, não estão em um grupo específico.',
    'trigger'                                             => 'Disparo',
    'trigger_value'                                       => 'Disparo no valor',
    'stop_processing_other_triggers'                      => 'Parar o processamento de outros gatilhos',
    'add_rule_trigger'                                    => 'Adicionar novo disparador',
    'action'                                              => 'Ação',
    'action_value'                                        => 'Valor da ação',
    'stop_executing_other_actions'                        => 'Parar de executar outras ações',
    'add_rule_action'                                     => 'Adicionar nova ação',
    'edit_rule'                                           => 'Editar regra #:nr ":title"',
    'delete_rule'                                         => 'Excluir a regra ":title"',
    'update_rule'                                         => 'Atualizar Regra',
    'test_rule_triggers'                                  => 'Veja transações correspondentes',
    'warning_no_matching_transactions'                    => 'Nenhuma transação correspondente foi encontrada.',
    'warning_no_valid_triggers'                           => 'Sem gatilhos válidos fornecidos.',
    'apply_rule_selection'                                => 'Aplicar a regra ":title" para uma seleção de suas transações',
    'apply_rule_selection_intro'                          => 'As regras como ":title" normalmente são aplicadas apenas a transações novas ou atualizadas, mas você pode informar o Firefly III para executá-lo em uma seleção de suas transações existentes. Isso pode ser útil quando você atualizou uma regra e você precisa que as alterações sejam aplicadas a todas as suas outras transações.',
    'include_transactions_from_accounts'                  => 'Incluir as transações destas contas',
    'include'                                             => 'Incluir?',
    'applied_rule_selection'                              => '{0} Nenhuma transação em sua seleção foi alterada pela regra ":title".|[1] Uma transação em sua seleção foi alterada pela regra ":title".|[2,*] :count transações em sua seleção foram alteradas pela regra ":title".',
    'execute'                                             => 'Executar',
    'apply_rule_group_selection'                          => 'Aplicar grupo de regras ":title" para uma seleção de suas transações',
    'apply_rule_group_selection_intro'                    => 'Os grupos de regras como ":title" normalmente são aplicados apenas a transações novas ou atualizadas, mas você pode informar ao Firefly III para executar todas as regras neste grupo em uma seleção de suas transações existentes. Isso pode ser útil quando você atualizou um grupo de regras e você precisa que as alterações sejam aplicadas a todas as suas outras transações.',
    'applied_rule_group_selection'                        => 'Grupo de regras ":title" tem sido aplicada para sua seleção.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Quando uma transação é criada',
    'rule_trigger_update_journal'                         => 'Quando uma transação é atualizada',
    'rule_trigger_manual'                                 => 'Somente quando ativado pelo usuário',
    'rule_trigger_user_action'                            => 'Ação do usuário é ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Nome da conta de origem começa com..',
    'rule_trigger_source_account_starts'                  => 'Nome da conta de origem começa com ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'O nome da conta de origem termina com..',
    'rule_trigger_source_account_ends'                    => 'O nome da conta de origem termina com ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Nome da conta de origem é..',
    'rule_trigger_source_account_is'                      => 'Nome da conta de origem é ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Nome da conta de origem contém..',
    'rule_trigger_source_account_contains'                => 'Nome da conta de origem contém ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Ou ID da conta é exatamente..',
    'rule_trigger_account_id'                             => 'Ou o ID da conta é exatamente :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'ID da conta de origem é igual a..',
    'rule_trigger_source_account_id'                      => 'ID da conta de origem é igual a :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'ID da conta de destino é igual a..',
    'rule_trigger_destination_account_id'                 => 'ID da conta de destino é igual a :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Ou a conta é dinheiro',
    'rule_trigger_account_is_cash'                        => 'Ou a conta é dinheiro',
    'rule_trigger_source_is_cash_choice'                  => 'Conta de origem é (dinheiro)',
    'rule_trigger_source_is_cash'                         => 'Conta de origem é (dinheiro)',
    'rule_trigger_destination_is_cash_choice'             => 'Conta de destino é (dinheiro)',
    'rule_trigger_destination_is_cash'                    => 'Conta de destino é (dinheiro)',
    'rule_trigger_source_account_nr_starts_choice'        => 'Número da conta de origem (IBAN) começa com..',
    'rule_trigger_source_account_nr_starts'               => 'Número da conta de origem (IBAN) começa com ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Número da conta de origem (IBAN) termina com..',
    'rule_trigger_source_account_nr_ends'                 => 'Número da conta de origem (IBAN) termina com ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Número da conta de origem (IBAN) é..',
    'rule_trigger_source_account_nr_is'                   => 'Número da conta de origem (IBAN) é ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Número da conta de origem (IBAN) contém..',
    'rule_trigger_source_account_nr_contains'             => 'Número da conta de origem (IBAN) contém ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Nome da conta de destino começa com..',
    'rule_trigger_destination_account_starts'             => 'Nome da conta de destino começa com ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Nome da conta de destino termina com..',
    'rule_trigger_destination_account_ends'               => 'Nome da conta de destino termina com ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Nome da conta de destino é..',
    'rule_trigger_destination_account_is'                 => 'Nome da conta de destino é ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Nome da conta de destino contém..',
    'rule_trigger_destination_account_contains'           => 'Nome da conta de destino contém ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Número da conta de destino (IBAN) começa com..',
    'rule_trigger_destination_account_nr_starts'          => 'Número da conta de destino (IBAN) começa com ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Número da conta de destino (IBAN) termina com..',
    'rule_trigger_destination_account_nr_ends'            => 'Número da conta de destino (IBAN) termina com ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Número da conta de destino (IBAN) é..',
    'rule_trigger_destination_account_nr_is'              => 'Número da conta de destino (IBAN) é ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Número da conta de destino (IBAN) contém..',
    'rule_trigger_destination_account_nr_contains'        => 'Número da conta de destino (IBAN) contém ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transação é do tipo..',
    'rule_trigger_transaction_type'                       => 'Transação é do tipo ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'A categoria é..',
    'rule_trigger_category_is'                            => 'A categoria é ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Valor é menor ou igual a ..',
    'rule_trigger_amount_less'                            => 'Valor é menor ou igual a :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Quantia é..',
    'rule_trigger_amount_is'                              => 'Quantia é :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Valor é maior ou igual a..',
    'rule_trigger_amount_more'                            => 'Valor é maior ou igual a :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Descrição começa com..',
    'rule_trigger_description_starts'                     => 'Descrição começa com ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Descrição termina com..',
    'rule_trigger_description_ends'                       => 'Descrição termina com ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Descrição contém..',
    'rule_trigger_description_contains'                   => 'Descrição contém ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Descrição é..',
    'rule_trigger_description_is'                         => 'Descrição é ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Data da transação é..',
    'rule_trigger_date_on'                                => 'Data de transação é ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'A data da transação é anterior a...',
    'rule_trigger_date_before'                            => 'A data da transação é anterior a ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'A data da transação é posterior a...',
    'rule_trigger_date_after'                             => 'A data da transação é posterior a ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transação foi feita em..',
    'rule_trigger_created_at_on'                          => 'A transação foi feita em ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transação foi editada pela última vez em..',
    'rule_trigger_updated_at_on'                          => 'Transação foi editada pela última vez em ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'O orçamento é..',
    'rule_trigger_budget_is'                              => 'O orçamento é ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Qualquer tag é..',
    'rule_trigger_tag_is'                                 => 'Qualquer tag é ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Qualquer tag contém..',
    'rule_trigger_tag_contains'                           => 'Qualquer tag contém ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Qualquer tag termina com..',
    'rule_trigger_tag_ends'                               => 'Qualquer tag termina com ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Qualquer tag começa com..',
    'rule_trigger_tag_starts'                             => 'Qualquer tag começa com ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'A moeda da transação é..',
    'rule_trigger_currency_is'                            => 'A moeda da transação é ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'A moeda estrangeira da transação é...',
    'rule_trigger_foreign_currency_is'                    => 'A moeda estrangeira da transação é ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Tem quaisquer anexos',
    'rule_trigger_has_attachments'                        => 'Tem qualquer anexo(s)',
    'rule_trigger_has_no_category_choice'                 => 'Não tem categoria',
    'rule_trigger_has_no_category'                        => 'A transação não tem categoria',
    'rule_trigger_has_any_category_choice'                => 'Tem uma categoria (qualquer)',
    'rule_trigger_has_any_category'                       => 'A transação tem uma categoria (qualquer)',
    'rule_trigger_has_no_budget_choice'                   => 'Não tem orçamento',
    'rule_trigger_has_no_budget'                          => 'A transação não possui orçamento',
    'rule_trigger_has_any_budget_choice'                  => 'Tem um orçamento (qualquer)',
    'rule_trigger_has_any_budget'                         => 'Transação tem um orçamento (qualquer)',
    'rule_trigger_has_no_bill_choice'                     => 'Não tem assinatura',
    'rule_trigger_has_no_bill'                            => 'Transação não tem assinatura',
    'rule_trigger_has_any_bill_choice'                    => 'Tem qualquer assinatura',
    'rule_trigger_has_any_bill'                           => 'Transação não tem qualquer assinatura',
    'rule_trigger_has_no_tag_choice'                      => 'Não tem tag(s)',
    'rule_trigger_has_no_tag'                             => 'A transação não tem tag(s)',
    'rule_trigger_has_any_tag_choice'                     => 'Tem uma ou mais tags (qualquer)',
    'rule_trigger_has_any_tag'                            => 'A transação tem uma ou mais tags (qualquer)',
    'rule_trigger_any_notes_choice'                       => 'Tem notas (qualquer)',
    'rule_trigger_any_notes'                              => 'A transação tem notas (qualquer)',
    'rule_trigger_no_notes_choice'                        => 'Não tem notas',
    'rule_trigger_no_notes'                               => 'A transação não tem notas',
    'rule_trigger_notes_is_choice'                        => 'As notas são..',
    'rule_trigger_notes_is'                               => 'As notas são ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'As notas contêm..',
    'rule_trigger_notes_contains'                         => 'As notas contêm ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'As notas começam com..',
    'rule_trigger_notes_starts'                           => 'As notas começam com ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'As notas terminam com..',
    'rule_trigger_notes_ends'                             => 'Notas terminam com ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Assinatura é..',
    'rule_trigger_bill_is'                                => 'Assinatura é ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'ID externo é..',
    'rule_trigger_external_id_is'                         => 'ID externo é ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Referência interna é..',
    'rule_trigger_internal_reference_is'                  => 'Referência interna é ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'ID do livro de transação é..',
    'rule_trigger_journal_id'                             => 'ID do livro de transação é ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'A transação tem uma URL externa (qualquer)',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'A transação tem um ID externo (qualquer)',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'A transação não tem URL externa',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'A transação não tem um ID externo',
    'rule_trigger_id_choice'                              => 'O identificador da transação é..',
    'rule_trigger_id'                                     => 'O identificador da transação é ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT é..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT é ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Ação do usuário é ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Nenhuma tag é..',
    'rule_trigger_tag_is_not'                             => 'Nenhuma tag é ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Ou a conta é exatamente..',
    'rule_trigger_account_is'                             => 'Ou a conta é exatamente ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Ou a conta contém..',
    'rule_trigger_account_contains'                       => 'Ou a conta contém ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Ou a conta termina com..',
    'rule_trigger_account_ends'                           => 'Ou a conta termina com ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Ou a conta começa com..',
    'rule_trigger_account_starts'                         => 'Ou a conta começa com ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Ou número da conta / IBAN é..',
    'rule_trigger_account_nr_is'                          => 'Ou número da conta / IBAN é ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Ou número da conta / IBAN contém..',
    'rule_trigger_account_nr_contains'                    => 'Ou número da conta / IBAN contém ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Ou número da conta / IBAN termina com..',
    'rule_trigger_account_nr_ends'                        => 'Ou número da conta / IBAN termina com ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Ou número da conta / IBAN começa com..',
    'rule_trigger_account_nr_starts'                      => 'Ou número da conta / IBAN começa com ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'A categoria contém..',
    'rule_trigger_category_contains'                      => 'Categoria contém ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Categoria termina com..',
    'rule_trigger_category_ends'                          => 'Categoria termina com ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Categoria começa com..',
    'rule_trigger_category_starts'                        => 'Categoria começa com ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'O orçamento contém..',
    'rule_trigger_budget_contains'                        => 'O orçamento contém ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'O orçamento termina com..',
    'rule_trigger_budget_ends'                            => 'Orçamento termina com ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'O orçamento começa com..',
    'rule_trigger_budget_starts'                          => 'Orçamento começa com ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Assinatura contém..',
    'rule_trigger_bill_contains'                          => 'Assinatura contém ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Assinatura termina com..',
    'rule_trigger_bill_ends'                              => 'Assinatura termina com ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Assinatura começa com..',
    'rule_trigger_bill_starts'                            => 'Assinatura começa com ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'ID Externo contém..',
    'rule_trigger_external_id_contains'                   => 'ID Externo contém ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'ID externo termina com..',
    'rule_trigger_external_id_ends'                       => 'ID Externo termina com ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'ID externo começa com..',
    'rule_trigger_external_id_starts'                     => 'ID Externo começa com ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Referência interna contém..',
    'rule_trigger_internal_reference_contains'            => 'Referência interna contém ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Referência interna termina com..',
    'rule_trigger_internal_reference_ends'                => 'Referência interna termina com ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Referência interna começa com..',
    'rule_trigger_internal_reference_starts'              => 'Referência interna começa com ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'URL externa é..',
    'rule_trigger_external_url_is'                        => 'URL externa é ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'URL externa contém..',
    'rule_trigger_external_url_contains'                  => 'URL externa contém ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'URL externa termina com..',
    'rule_trigger_external_url_ends'                      => 'URL externa termina com ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'URL externa começa com..',
    'rule_trigger_external_url_starts'                    => 'URL externa começa com ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Não há anexos',
    'rule_trigger_has_no_attachments'                     => 'A transação não tem anexos',
    'rule_trigger_recurrence_id_choice'                   => 'O ID da transação recorrente é..',
    'rule_trigger_recurrence_id'                          => 'ID da transação recorrente é ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Data de juros é em..',
    'rule_trigger_interest_date_on'                       => 'Data de juros é em ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Data de juros é anterior a..',
    'rule_trigger_interest_date_before'                   => 'Data de juros é antes de ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Data de juros é após..',
    'rule_trigger_interest_date_after'                    => 'Data de juros é após ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Data de lançamento é em..',
    'rule_trigger_book_date_on'                           => 'Data de lançamento é em ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Data de lançamento é antes de..',
    'rule_trigger_book_date_before'                       => 'Data de lançamento é antes de ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Data de lançamento é após..',
    'rule_trigger_book_date_after'                        => 'Data de lançamento é após ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Data de processamento é em..',
    'rule_trigger_process_date_on'                        => 'Data de processamento é ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Data de processamento é antes de..',
    'rule_trigger_process_date_before'                    => 'Data de processamento é antes de ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Data de processamento é após..',
    'rule_trigger_process_date_after'                     => 'Data de processamento é após ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Data de vencimento é em..',
    'rule_trigger_due_date_on'                            => 'Data de vencimento é em ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'A data de vencimento é antes de..',
    'rule_trigger_due_date_before'                        => 'Data de vencimento é antes de ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Data de vencimento é após..',
    'rule_trigger_due_date_after'                         => 'Data de vencimento é após ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Data de pagamento é em..',
    'rule_trigger_payment_date_on'                        => 'Data do pagamento é em ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Data de pagamento é anterior a..',
    'rule_trigger_payment_date_before'                    => 'Data do pagamento é antes de ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Data de pagamento é depois de..',
    'rule_trigger_payment_date_after'                     => 'Data do pagamento é após ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Data da fatura é em..',
    'rule_trigger_invoice_date_on'                        => 'A data da fatura é em ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Data da fatura é antes de..',
    'rule_trigger_invoice_date_before'                    => 'Data da fatura é antes de ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Data da fatura é depois de..',
    'rule_trigger_invoice_date_after'                     => 'Data da fatura é depois de ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'A transação foi criada antes de..',
    'rule_trigger_created_at_before'                      => 'A transação foi criada antes de ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'A transação foi criada depois de..',
    'rule_trigger_created_at_after'                       => 'A transação foi criada após ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'A transação foi atualizada pela última vez..',
    'rule_trigger_updated_at_before'                      => 'A transação foi atualizada pela última vez antes de ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'A transação foi atualizada pela última vez depois de..',
    'rule_trigger_updated_at_after'                       => 'A transação foi atualizada pela última vez após ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Quantidade em moeda estrangeira é exatamente..',
    'rule_trigger_foreign_amount_is'                      => 'Quantidade em moeda estrangeira é exatamente ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Quantidade em moeda estrangeira é menor que..',
    'rule_trigger_foreign_amount_less'                    => 'Quantia em moeda estrangeira é inferior a ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Quantidade em moeda estrangeira é maior que..',
    'rule_trigger_foreign_amount_more'                    => 'Quantia em moeda estrangeira é maior que ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Qualquer nome do anexo é..',
    'rule_trigger_attachment_name_is'                     => 'Qualquer nome de anexo é ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Qualquer nome do anexo contém..',
    'rule_trigger_attachment_name_contains'               => 'Qualquer nome do anexo contém ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Qualquer nome do anexo começa com..',
    'rule_trigger_attachment_name_starts'                 => 'Qualquer nome de anexo começa com ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Qualquer nome de anexo termina com..',
    'rule_trigger_attachment_name_ends'                   => 'Qualquer nome de anexo termina com ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Qualquer nota de anexo é..',
    'rule_trigger_attachment_notes_are'                   => 'Qualquer nota de anexo é ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Qualquer nota de anexo contém..',
    'rule_trigger_attachment_notes_contains'              => 'Qualquer nota de anexo contém ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Qualquer nota de anexo começa com..',
    'rule_trigger_attachment_notes_starts'                => 'Qualquer nota de anexo começa com ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Qualquer nota de anexo termina com..',
    'rule_trigger_attachment_notes_ends'                  => 'Qualquer nota de anexo termina com ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transação reconciliada',
    'rule_trigger_reconciled'                             => 'Transação reconciliada',
    'rule_trigger_exists_choice'                          => 'Qualquer transação corresponde(!)',
    'rule_trigger_exists'                                 => 'Qualquer transação corresponde',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'ID da conta não é ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'ID da conta de origem não é ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'ID da conta de destino não é ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Tipo de transação não é ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'A tag não é ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'A tag é ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Descrição não é ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Descrição não termina com ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Descrição não começa com ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'As notas não são ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'As notas não contêm ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'As notas não terminam em ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'As notas não começam com ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Conta de origem não é ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Conta de origem não contém ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Conta de origem não termina em ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Conta de origem não começa com ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Número da conta de origem / IBAN não é ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Número da conta de origem / IBAN não contém ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Número da conta de origem / IBAN não termina em ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Número da conta de origem / IBAN não começa com ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Conta de destino não é ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Conta de destino não contém ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Conta de destino não termina em ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Conta de destino não começa com ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Número da conta de destino / IBAN não é ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Número da conta de destino / IBAN não contém ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Número da conta de destino / IBAN não termina em ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Número da conta de destino / IBAN não começa com ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Nenhuma conta é ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Nenhuma conta contém ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Nenhuma conta termina em ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Nenhuma conta começa com ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Nenhum número de conta / IBAN é ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Nenhum número de conta / IBAN contém ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Nenhum número de conta / IBAN termina em ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Nenhum número de conta / IBAN começa com ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Categoria não é ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Categoria não contém ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Categoria não termina em ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Categoria não começa com ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Orçamento não é ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Orçamento não contém ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Orçamento não termina em ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Orçamento não começa com ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Assinatura não é ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Assinatura não contém ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Assinatura não termina em ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Assinatura não termina com ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'ID Externo não é ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'ID Externo não contém ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'ID Externo não termina em ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'ID Externo não inicia com ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Referência interna não é ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Referência interna não contém ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Referência interna não termina em ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Referência interna não começa com ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'URL externa não é ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'URL externa não contém ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'URL externa não termina em ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'URL externa não inicia com ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'A moeda não é ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'A moeda estrangeira não é ":trigger_value"',
    'rule_trigger_not_id'                                 => 'O identificador da transação não é ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Identificador do livro de transação não é ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Identificador recorrente não é ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'A data não está em ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'A data não está antes de ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'A data não está após ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Data de juros não é em ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Data de juros não é anterior a ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Data de juros não é posterior a ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Data de lançamento não é em ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Data de lançamento não é antes de ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Data de lançamento não é após ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Data de processamento não é em ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Data de processamento não é antes de ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Data de processamento não é após ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Data de vencimento não é em ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Data de vencimento não é antes de ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Data de vencimento não é após ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Data do pagamento não é em ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Data do pagamento não é antes de ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Data do pagamento não é após ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Data da fatura não é em ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Data da fatura não é antes de ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Data da fatura não é depois de ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'A transação não foi criada em ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'A transação não foi criada antes de ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'A transação não foi criada depois de ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'A transação não foi atualizada em ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'A transação não foi atualizada antes de ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'A transação não foi atualizada depois de ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'O valor da transação não é ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'O valor da transação é maior que ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'O valor da transação é menor que ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'O valor da transação estrangeira não é ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'O valor da transação estrangeira é maior que ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'O valor da transação estrangeira é menor que ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Nenhum anexo é nomeado ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Nenhum nome do anexo contém ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'Nenhum nome de anexo começa com ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Nenhum nome do anexo termina em ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Nenhuma nota de anexo é ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Nenhuma nota de anexo contém ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Nenhuma nota de anexo começa com ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Nenhuma nota de anexo termina em ":trigger_value" "',
    'rule_trigger_not_reconciled'                         => 'Transação não está reconciliada',
    'rule_trigger_not_exists'                             => 'Transação não existe',
    'rule_trigger_not_has_attachments'                    => 'A transação não tem anexos',
    'rule_trigger_not_has_any_category'                   => 'A transação não tem categoria',
    'rule_trigger_not_has_any_budget'                     => 'A transação não tem orçamento',
    'rule_trigger_not_has_any_bill'                       => 'Transação não tem assinatura',
    'rule_trigger_not_has_any_tag'                        => 'A transação não tem tags',
    'rule_trigger_not_any_notes'                          => 'A transação não tem notas',
    'rule_trigger_not_any_external_url'                   => 'A transação não tem URL externa',
    'rule_trigger_not_has_no_attachments'                 => 'Transação tem anexo (qualquer)',
    'rule_trigger_not_has_no_category'                    => 'A transação tem uma categoria (qualquer)',
    'rule_trigger_not_has_no_budget'                      => 'A transação tem um orçamento (qualquer)',
    'rule_trigger_not_has_no_bill'                        => 'Transação tem alguma assinatura',
    'rule_trigger_not_has_no_tag'                         => 'A transação tem uma tag (qualquer)',
    'rule_trigger_not_no_notes'                           => 'A transação tem qualquer nota',
    'rule_trigger_not_no_external_url'                    => 'A transação tem uma URL externa',
    'rule_trigger_not_source_is_cash'                     => 'Conta de origem não é uma conta em dinheiro',
    'rule_trigger_not_destination_is_cash'                => 'Conta de destino não é uma conta em dinheiro',
    'rule_trigger_not_account_is_cash'                    => 'Nenhuma conta é uma conta em dinheiro',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Saldo da conta destino é maior que..',
    'rule_trigger_destination_balance_gte_choice'         => 'Saldo da conta destino é maior ou igual a..',
    'rule_trigger_destination_balance_is_choice'          => 'Saldo da conta destino é exatamente..',
    'rule_trigger_destination_balance_lt_choice'          => 'Saldo da conta destino é menor que..',
    'rule_trigger_destination_balance_lte_choice'         => 'Saldo da conta destino é menor ou igual a..',

    'rule_trigger_source_balance_gt_choice'  => 'Saldo da conta origem é maior que..',
    'rule_trigger_source_balance_gte_choice' => 'Saldo da conta origem é maior ou igual a..',
    'rule_trigger_source_balance_is_choice'  => 'Saldo da conta origem é exatamente..',
    'rule_trigger_source_balance_lt_choice'  => 'Saldo da conta origem é menor que..',
    'rule_trigger_source_balance_lte_choice' => 'Saldo da conta origem é menor ou igual a..',

    'rule_trigger_destination_balance_gt'  => 'Saldo da conta destino é maior que :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Saldo da conta destino é maior ou igual a :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Saldo da conta destino é exatamente :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Saldo da conta destino é menor que :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Saldo da conta destino é menor ou igual a :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Saldo da conta origem é maior que :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Saldo da conta origem é maior ou igual a :trigger_value',
    'rule_trigger_source_balance_is'           => 'Saldo da conta origem é exatamente :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Saldo da conta origem é menor que :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Saldo da conta origem é menor ou igual a :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Saldo da conta destino é menor ou igual a :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Saldo da conta destino é menor que :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Saldo da conta destino não é :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Saldo da conta destino é maior ou igual a :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Saldo da conta destino é maior que :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Saldo da conta origem é menor ou igual a :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Saldo da conta origem é menor que :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Saldo da conta origem não é :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Saldo da conta origem é maior ou igual a :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Saldo da conta origem é maior que :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'EXCLUIR transação(!)',
    'rule_action_delete_transaction'             => 'EXCLUIR transação(!)',
    'rule_action_set_category'                   => 'Definir categoria para ":action_value"',
    'rule_action_clear_category'                 => 'Limpar categoria',
    'rule_action_set_budget'                     => 'Definir orçamento para ":action_value"',
    'rule_action_clear_budget'                   => 'Limpar orçamento',
    'rule_action_add_tag'                        => 'Adicionar tag ":action_value"',
    'rule_action_remove_tag'                     => 'Remover tag ":action_value"',
    'rule_action_remove_all_tags'                => 'Remover todas as tags',
    'rule_action_set_description'                => 'Definir descrição para ":action_value"',
    'rule_action_append_description'             => 'Acrescentar a descrição com ":action_value"',
    'rule_action_prepend_description'            => 'Preceder a descrição com ":action_value"',
    'rule_action_set_category_choice'            => 'Definir a categoria para ..',
    'rule_action_clear_category_choice'          => 'Limpar qualquer categoria',
    'rule_action_set_budget_choice'              => 'Definir orçamento para ..',
    'rule_action_clear_budget_choice'            => 'Limpar qualquer orçamento',
    'rule_action_add_tag_choice'                 => 'Adicionar tag ..',
    'rule_action_remove_tag_choice'              => 'Remover tag ..',
    'rule_action_remove_all_tags_choice'         => 'Remover todas as tags',
    'rule_action_set_description_choice'         => 'Definir descrição para ..',
    'rule_action_update_piggy_choice'            => 'Adicionar / remover o valor da transação no cofrinho ..',
    'rule_action_update_piggy'                   => 'Adicionar / remover o valor da transação no cofrinho ":action_value"',
    'rule_action_append_description_choice'      => 'Adicionar descrição com ..',
    'rule_action_prepend_description_choice'     => 'Adicionar (ao começo) descrição com ..',
    'rule_action_set_source_account_choice'      => 'Definir a conta de origem para ..',
    'rule_action_set_source_account'             => 'Definir a conta de origem para :action_value',
    'rule_action_set_destination_account_choice' => 'Definir a conta de destino para ..',
    'rule_action_set_destination_account'        => 'Definir a conta de destino :action_value',
    'rule_action_append_notes_choice'            => 'Adicionar notas com ..',
    'rule_action_append_notes'                   => 'Anexar notas com ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Adicionar (ao começo) notas com ..',
    'rule_action_prepend_notes'                  => 'Preceder notas com ":action_value"',
    'rule_action_clear_notes_choice'             => 'Remover quaisquer notas',
    'rule_action_clear_notes'                    => 'Remover quaisquer notas',
    'rule_action_set_notes_choice'               => 'Defina notas para..',
    'rule_action_link_to_bill_choice'            => 'Vincular a uma assinatura ..',
    'rule_action_link_to_bill'                   => 'Vincular à assinatura ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Mudar conta de origem e destino (apenas transferências!)',
    'rule_action_switch_accounts'                => 'Alternar origem e destino',
    'rule_action_set_notes'                      => 'Defina notas para ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Converter esta transferência em entrada',
    'rule_action_convert_deposit'                => 'Converter a transação em uma entrada de ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Converter esta transação para uma saída',
    'rule_action_convert_withdrawal'             => 'Converter a transação em uma saída de ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Converter esta transação para transferência',
    'rule_action_convert_transfer'               => 'Converter a transação em uma transferência de ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Adicionar a descrição às notas da transação',
    'rule_action_append_notes_to_descr_choice'   => 'Adicionar as notas da trasação à descrição',
    'rule_action_move_descr_to_notes_choice'     => 'Substituir as notas de transação atual com a descrição',
    'rule_action_move_notes_to_descr_choice'     => 'Substituir a descrição atual com notas da transação',
    'rule_action_append_descr_to_notes'          => 'Adicionar descrição às notas',
    'rule_action_append_notes_to_descr'          => 'Adicionar notas à descrição',
    'rule_action_move_descr_to_notes'            => 'Substituir notas por descrição',
    'rule_action_move_notes_to_descr'            => 'Substituir descrição por notas',
    'rule_action_set_amount_choice'              => 'Definir valor para ..',
    'rule_action_set_amount'                     => 'Definir valor para ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Definir a conta destino para (dinheiro)',
    'rule_action_set_source_to_cash_choice'      => 'Definir a conta de ativo para (dinheiro)',
    'rulegroup_for_bills_title'                  => 'Grupo de regras para assinaturas',
    'rulegroup_for_bills_description'            => 'Um grupo especial de regras para todas as regras que envolvem assinaturas.',
    'rule_for_bill_title'                        => 'Regra gerada automaticamente para a assinatura ":name"',
    'rule_for_bill_description'                  => 'Esta regra é gerada automaticamente para tentar corresponder a assinatura ":name".',
    'create_rule_for_bill'                       => 'Criar uma nova regra para a assinatura ":name"',
    'create_rule_for_bill_txt'                   => 'Você acabou de criar uma nova assinatura, com nome ":name", parabéns! O Firefly III pode automagicamente combinar novos saques com esta assinatura. Por exemplo, sempre que você pagar seu aluguel, a assinatura "aluguel" será vinculada com esta despesa. Desse jeito, Firefly III pode mostar de forma precisa quais assinaturas estão vencidas e quais não estão. Para isso acontecer, uma nova regra precisa ser criada. Firefly III vai automagicamente vincular o saque correto à assinatura correta. Por favor, verifique os gatilhos para ver se eles estão corretos, e adicione mais se eles estão errados.',
    'new_rule_for_bill_title'                    => 'Regra para assinatura ":name"',
    'new_rule_for_bill_description'              => 'Esta regra marca transações para a assinatura ":name".',

    'new_rule_for_journal_title'                => 'Regra baseada na transação ":description"',
    'new_rule_for_journal_description'          => 'Esta regra é baseada na transação ":description". Irá corresponder a transações que são exatamente iguais.',

    // tags
    'store_new_tag'                             => 'Armazenar nova tag',
    'update_tag'                                => 'Atualizar tag',
    'no_location_set'                           => 'Nenhuma localização.',
    'meta_data'                                 => 'Meta dados',
    'location'                                  => 'Localização',
    'location_first_split'                      => 'O local para essa transação pode ser definido na primeira divisão dessa transação.',
    'without_date'                              => 'Sem data',
    'result'                                    => 'Resultado',
    'sums_apply_to_range'                       => 'Todas as somas aplicam-se ao intervalo selecionado',
    'mapbox_api_key'                            => 'Para usar o mapa, obtenha uma chave API do <a href="https://www.mapbox.com/">Mapbox</a>. Abra seu arquivo <code>.env</code> e insira este código <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Clique com o botão direito ou pressione longamente para definir a localização do objeto.',
    'click_tap_location'                        => 'Clique ou toque no mapa para adicionar um local',
    'clear_location'                            => 'Limpar localização',
    'delete_all_selected_tags'                  => 'Excluir todas as tags selecionadas',
    'select_tags_to_delete'                     => 'Não se esqueça de selecionar algumas tags.',
    'deleted_x_tags'                            => ':count tag foi excluída.|:count tags foram excluídas.',
    'create_rule_from_transaction'              => 'Criar regra baseada na transação',
    'create_recurring_from_transaction'         => 'Criar transação recorrente baseada na transação',

    // preferences
    'test_notifications_buttons'                => 'Para testar sua configuração, use os botões abaixo. Por favor, note que os botões não tem controle de spam.',
    'dark_mode_option_browser'                  => 'Deixe seu navegador decidir',
    'dark_mode_option_light'                    => 'Sempre claro',
    'dark_mode_option_dark'                     => 'Sempre escuro',
    'equal_to_language'                         => '(igual ao idioma)',
    'dark_mode_preference'                      => 'Modo escuro',
    'dark_mode_preference_help'                 => 'Avise ao Firefly III quando usar o modo escuro.',
    'pref_home_screen_accounts'                 => 'Conta da tela inicial',
    'pref_home_screen_accounts_help'            => 'Quais contas devem ser exibidas na tela inicial?',
    'pref_view_range'                           => 'Ver intervalo',
    'pref_view_range_help'                      => 'Algumas tabelas estão automaticamente agrupadas em períodos. Seus orçamentos também serão agrupados em períodos. Qual período você prefere?',
    'pref_1D'                                   => 'Um dia',
    'pref_1W'                                   => 'Uma semana',
    'pref_1M'                                   => 'Um mês',
    'pref_3M'                                   => 'Trimestral',
    'pref_6M'                                   => 'Semestral',
    'pref_1Y'                                   => 'Um ano',
    'pref_last365'                              => 'Ano passado',
    'pref_last90'                               => 'Últimos 90 dias',
    'pref_last30'                               => 'Últimos 30 dias',
    'pref_last7'                                => 'Últimos 7 dias',
    'pref_YTD'                                  => 'Começo do ano até hoje',
    'pref_QTD'                                  => 'Começo do trimestre até hoje',
    'pref_MTD'                                  => 'Começo do mês até hoje',
    'pref_languages'                            => 'Idiomas',
    'pref_locale'                               => 'Configurações regionais',
    'pref_languages_help'                       => 'Firefly III suporta muitos idiomas. Qual você prefere?',
    'pref_locale_help'                          => 'Firefly III permite que você defina outras configurações locais, por exemplo, como moedas, números e datas são formatadas. Os itens nesta lista podem não ser suportadas pelo seu sistema. Firefly III não tem as corretas configurações de data para cada local; entre em contato para melhorias.',
    'pref_locale_no_demo'                       => 'Este recurso não funcionará para o usuário de demonstração.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Configurações de ano fiscal',
    'pref_custom_fiscal_year_label'             => 'Habilitado',
    'pref_custom_fiscal_year_help'              => 'Nos países que usam um exercício diferente de 1 de Janeiro a 31 de Dezembro, você pode ativar isto e especificar início / fim do ano fiscal',
    'pref_fiscal_year_start_label'              => 'Data de início de ano fiscal',
    'pref_two_factor_auth'                      => 'Segundo fator de autenticação',
    'pref_two_factor_auth_help'                 => 'Quando você habilita o segundo fator de autenticação (também conhecido como autenticação de dois passos), você adiciona uma camada extra de segurança para sua conta. Você entra com alguma coisa que você sabe (sua senha) e algo que você tem (um código de verificação). Os códigos de verificação são gerados por um aplicativo em seu celular, como Authy ou Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Ativar segundo fator de autenticação',
    'pref_two_factor_auth_disabled'             => 'Código de verificação do segundo fator de autenticação removido ou desativado',
    'pref_two_factor_auth_remove_it'            => 'Não se esqueça de remover a conta de seu aplicativo de autenticação!',
    'pref_two_factor_auth_code'                 => 'Verificar código',
    'pref_two_factor_auth_code_help'            => 'Escaneie o QR Code com um app no seu celular com um aplicativo como Authy ou Google Authenticator e digite o código gerado. O QR Code muda cada vez que você visita essa página. Tenha certeza que você está usando o mais recente.',
    'pref_two_factor_auth_reset_code'           => 'Redefinir o código de verificação',
    'pref_two_factor_auth_disable_2fa'          => 'Desativar segundo fator de autenticação',
    '2fa_use_secret_instead'                    => 'Se você não pode escanear o QR code, sinta-se à vontade para usar o código secreto <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Armazene esses códigos de reserva para acesso, caso você perca seu dispositivo.',
    '2fa_already_enabled'                       => 'Verificação do segundo fator de autenticação já está habilitada.',
    'wrong_mfa_code'                            => 'Esse código MFA não é válido.',
    'pref_save_settings'                        => 'Salvar definições',
    'saved_preferences'                         => 'Preferências salvas!',
    'preferences_general'                       => 'Geral',
    'preferences_frontpage'                     => 'Tela inicial',
    'preferences_security'                      => 'Segurança',
    'preferences_layout'                        => 'Interface',
    'preferences_notifications'                 => 'Notificações',
    'pref_home_show_deposits'                   => 'Depósitos de mostrar na tela inicial',
    'pref_home_show_deposits_info'              => 'A tela inicial já mostra suas contas de despesas. Deveria também mostrar suas receitas?',
    'pref_home_do_show_deposits'                => 'Sim, mostrar-lhes',
    'successful_count'                          => 'dos quais :count bem sucedida',
    'list_page_size_title'                      => 'Tamanho da página',
    'list_page_size_help'                       => 'Qualquer lista de coisas (contas, transações, etc.) mostra, no máximo, este tanto por página.',
    'list_page_size_label'                      => 'Tamanho da página',
    'between_dates'                             => '(:start e :end)',
    'pref_optional_fields_transaction'          => 'Campos opcionais para transações',
    'pref_optional_fields_transaction_help'     => 'Por padrão, nem todos os campos estão ativados ao criar uma nova transação (por causa da desordem). Abaixo, você pode habilitar esses campos se você acha que eles podem ser úteis para você. Claro, qualquer campo desabilitado, mas já preenchido, será visível, independentemente da configuração.',
    'optional_tj_date_fields'                   => 'Campos de data',
    'optional_tj_other_fields'                  => 'Outros campos',
    'optional_tj_attachment_fields'             => 'Campos de anexo',
    'pref_optional_tj_interest_date'            => 'Data de juros',
    'pref_optional_tj_book_date'                => 'Data de lançamento',
    'pref_optional_tj_process_date'             => 'Data de processamento',
    'pref_optional_tj_due_date'                 => 'Data de vencimento',
    'pref_optional_tj_payment_date'             => 'Data de pagamento',
    'pref_optional_tj_invoice_date'             => 'Data da Fatura',
    'pref_optional_tj_internal_reference'       => 'Referência interna',
    'pref_optional_tj_notes'                    => 'Notas',
    'pref_optional_tj_attachments'              => 'Anexos',
    'pref_optional_tj_external_url'             => 'URL externa',
    'pref_optional_tj_location'                 => 'Localização',
    'pref_optional_tj_links'                    => 'Links da transação',
    'optional_field_meta_dates'                 => 'Datas',
    'optional_field_meta_business'              => 'Negócios',
    'optional_field_attachments'                => 'Anexos',
    'optional_field_meta_data'                  => 'Meta dados opcionais',
    'external_url'                              => 'URL externa',
    'pref_notification_login_failure'           => 'Falha de login',
    'pref_notification_bill_reminder'           => 'Lembrete sobre expiração de assinaturas',
    'pref_notification_new_access_token'        => 'Alerta quando um novo token de acesso à API é criado',
    'pref_notification_transaction_creation'    => 'Alerta quando uma transação é criada automaticamente',
    'pref_notification_user_login'              => 'Alertar quando você logar de uma nova localidade',
    'pref_notification_rule_action_failures'    => 'Alertar quando as ações de regras falharem ao executar (não por e-mail)',
    'pref_notification_new_password'            => 'Sua senha foi alterada',
    'pref_notification_enabled_mfa'             => 'Segundo fator de autenticação está ativado',
    'pref_notification_disabled_mfa'            => 'Segundo fator de autenticação está desativado',
    'pref_notification_few_left_mfa'            => 'Você tem apenas alguns códigos de backup',
    'pref_notification_no_left_mfa'             => 'Você não tem mais nenhum código de backup',
    'pref_notification_many_failed_mfa'         => 'A verificação de autenticação de vários fatores continua falhando',
    'pref_notification_new_backup_codes'        => 'Novos códigos de backup foram gerados',
    'pref_notifications'                        => 'Notificações',
    'pref_notifications_help'                   => 'Indique se estas são notificações que você gostaria de receber. Algumas notificações podem conter informações financeiras sensíveis.',
    'pref_notifications_settings'               => 'Configurações de notificações',
    'pref_notifications_settings_help'          => 'Use estas configurações para configurar seus canais de notificação. Por favor, note que as notificações serão enviadas para TODOS os canais. Por favor, salve suas configurações PRIMEIRO.',
    'slack_url_label'                           => 'URL do webhook de entrada do Slack',
    'discord_url_label'                         => 'URL do Webhook do Discord',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Taxa de câmbio',
    'header_exchange_rates'                     => 'Taxa de câmbio',
    'exchange_rates_intro'                      => 'O Firefly III suporta o download e uso de taxas de câmbio. Leia mais sobre isso <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">na documentação</a>.',
    'exchange_rates_from_to'                    => 'Entre {from} e {to} (e vice-versa)',
    'header_exchange_rates_rates'               => 'Taxa de câmbio',
    'exchange_rates_intro_rates'                => 'O Firefly III usa as seguintes taxas de câmbio. A inversa é automaticamente calculada quando não é fornecida. Se não existir nenhuma taxa de câmbio para a data da transação, o Firefly III voltará no tempo para encontrar uma. Se nenhum estiver presente, a taxa "1" será usada.',
    'header_exchange_rates_table'               => 'Tabela com taxas de câmbio',
    'help_rate_form'                            => 'Neste dia, quantos {to} você receberá por um {from}?',
    'save_new_rate'                             => 'Salvar nova taxa',
    'add_new_rate'                              => 'Adicionar uma nova taxa de câmbio',
    'not_enough_currencies'                     => 'Moedas insuficientes',
    'not_enough_currencies_enabled'             => 'Se você tem apenas uma moeda ativada, não há necessidade de adicionar taxas de câmbio.',

    // Financial administrations
    'administration_index'                      => 'Administração financeira',
    'administrations_breadcrumb'                => 'Administração financeira',
    'administrations_page_title'                => 'Administração financeira',
    'administrations_index_menu'                => 'Administração financeira',
    'administrations_page_sub_title'            => 'Visão Geral',
    'create_administration'                     => 'Criar nova administração',
    'administration_owner'                      => 'Proprietário da administração: {{email}}',
    'administration_you'                        => 'Seu papel: {{role}}',
    'other_users_in_admin'                      => 'Outros usuários nesta administração',
    'administrations_create_breadcrumb'         => 'Criar nova administração financeira',
    'administrations_page_create_sub_title'     => 'Criar nova administração financeira',
    'basic_administration_information'          => 'Informações básicas da administração',
    'new_administration_created'                => 'Nova administração financeira "{{title}}" foi criada',
    'edit_administration_breadcrumb'            => 'Editar administração financeira ":title"',
    'administrations_page_edit_sub_title'       => 'Editar administração financeira ":title"',
    'administrations_page_edit_sub_title_js'    => 'Editar administração financeira "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administração ":title" foi atualizada',
    'flash_administration_created'              => 'Administração ":title" foi criada',
    'flash_administration_deleted'              => 'Administração ":title" foi excluída',

    // roles
    'administration_role_owner'                 => 'Proprietário',
    'administration_role_ro'                    => 'Somente leitura',
    'administration_role_mng_trx'               => 'Gerenciar transações',
    'administration_role_mng_meta'              => 'Gerenciar classificação e metadados',
    'administration_role_mng_budgets'           => 'Gerenciar orçamentos',
    'administration_role_mng_piggies'           => 'Gerenciar cofrinhos',
    'administration_role_mng_subscriptions'     => 'Gerenciar assinaturas',
    'administration_role_mng_rules'             => 'Gerenciar regras',
    'administration_role_mng_recurring'         => 'Gerenciar transações recorrentes',
    'administration_role_mng_webhooks'          => 'Gerenciar webhooks',
    'administration_role_mng_currencies'        => 'Gerenciar moedas',
    'administration_role_view_reports'          => 'Ver relatórios',
    'administration_role_full'                  => 'Acesso completo',

    // mfa
    'enable_mfa'                                => 'Ativar segundo fator de autenticação',
    'mfa_index_title'                           => 'Segundo fator de autenticação',
    'mfa_index_intro'                           => 'Firefly III suporta autenticação de múltiplos fatores (MFA). Você pode habilitar MFA para sua conta para adicionar uma camada extra de segurança. Apps como Authy, Google Authenticator e FreeOTP podem ser usados para gerar os códigos que você precisa para fazer login. As chaves de segurança não são suportadas pelo Firefly III, mas você pode usar uma chave de segurança como um dispositivo de armazenamento para sua chave secreta do MFA.',
    'mfa_index_enabled'                         => 'O segundo fator de autenticação está ativado para sua conta.',
    'mfa_index_disabled'                        => 'Segundo fator de autenticação não está ativado para sua conta.',
    'mfa_index_owner'                           => 'O proprietário dessa instância sempre vai ativar ou desativar o segundo fator de autenticação para sua conta.',
    'current_password_confirm_mfa'              => 'Digite sua senha atual',
    'mfa_warning_code_changes'                  => 'Você pode receber uma caixa de diálogo do segundo fator de autenticação logo após digitar sua senha e código do segundo fator de autenticação. Neste caso, por favor espere para que seu app gere um novo código, e não tente reutilizar o mesmo código que você acabou de usar.',
    'mfa_already_disabled'                      => 'Segundo fator de autenticação não está ativado, então você não pode desativar.',
    'disable_mfa_page'                          => 'Desativar segundo fator de autenticação',
    'disable_mfa_intro'                         => 'Você pode desativar o segundo fator de autenticação. Para fazer isso, digite sua senha e o código do segundo fator de autenticação. Se você deseja desativar o segundo fator de autenticação porque perdeu acesso ao seu app de autenticação, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">por favor confira a documentação</a>.',
    'pref_disable_mfa'                          => 'Desativar segundo fator de autenticação',
    'mfa_not_enabled'                           => 'Segundo fator de autenticação não está ativado.',
    'mfa_backup_codes_intro'                    => 'O Firefly III pode gerar códigos de backup para você. Esses códigos podem ser usados para entrar quando você não pode usar o seu gerador de código. Você pode gerar um novo conjunto de códigos a qualquer momento. Se você gerar um novo conjunto, o conjunto anterior será invalidado.',
    'mfa_backup_codes_quick'                    => 'Se você é muito rápido vindo da página de configuração do segundo fator de autenticação, seu aplicativo pode não ter gerado um novo código ainda. Por favor, entenda que os códigos MFA só podem ser usados uma vez. Certifique-se de usar um código diferente do anterior.',
    'mfa_backup_codes_title'                    => 'Códigos de backup do segundo fator de autenticação',
    'mfa_backup_codes_post_title'               => 'Códigos de backup do segundo fator de autenticação',

    // profile:
    'manage_mfa_settings'                       => 'Gerenciar configurações do segundo fator de autenticação',
    'purge_data_title'                          => 'Expurgar dados do Firefly III',
    'purge_data_expl'                           => '"Expurgar" significa "apagar o que já está excluído". Em circunstâncias normais, o Firefly III não exclui nada permanentemente. Ela apenas o esconde. O botão abaixo exclui todos estes registros "excluídos" anteriores PARA SEMPRE.',
    'delete_stuff_header'                       => 'Apagar e expurgar dados',
    'purge_all_data'                            => 'Expurgar registros excluídos',
    'purge_data'                                => 'Expurgar dados',
    'purged_all_records'                        => 'Todos os registros apagados foram expurgados.',
    'delete_data_title'                         => 'Excluir dados do Firefly III',
    'permanent_delete_stuff'                    => 'Você pode excluir coisas do Firefly III. Usar os botões abaixo significa que seus itens serão removidos da visualização e ocultados. Não há botão de desfazer para isso, mas os itens podem permanecer no banco de dados onde você pode salvá-los se necessário.',
    'other_sessions_logged_out'                 => 'Todas as suas outras sessões foram desconectadas.',
    'delete_unused_accounts'                    => 'Excluir contas não utilizadas limpará suas listas de preenchimento automático.',
    'delete_all_unused_accounts'                => 'Apagar contas não utilizadas',
    'deleted_all_unused_accounts'               => 'Todas as contas não utilizadas foram excluídas',
    'delete_all_budgets'                        => 'Excluir TODOS os seus orçamentos',
    'delete_all_categories'                     => 'Excluir TODAS as suas categorias',
    'delete_all_tags'                           => 'Excluir TODAS as suas tags',
    'delete_all_bills'                          => 'Excluir TODAS as suas assinaturas',
    'delete_all_piggy_banks'                    => 'Excluir TODOS os seus cofrinhos',
    'delete_all_rules'                          => 'Excluir TODAS as suas regras',
    'delete_all_recurring'                      => 'Excluir TODAS as suas transações recorrentes',
    'delete_all_object_groups'                  => 'Excluir TODOS os seus grupos de objetos',
    'delete_all_accounts'                       => 'Excluir TODAS as suas contas',
    'delete_all_asset_accounts'                 => 'Excluir TODAS as suas contas de ativos',
    'delete_all_expense_accounts'               => 'Excluir TODAS as suas contas de despesas',
    'delete_all_revenue_accounts'               => 'Excluir TODAS as suas contas de receita',
    'delete_all_liabilities'                    => 'Excluir TODOS os seus passivos',
    'delete_all_transactions'                   => 'Excluir TODAS as suas transações',
    'delete_all_withdrawals'                    => 'Excluir TODAS as suas despesas',
    'delete_all_deposits'                       => 'Excluir TODAS as suas entradas',
    'delete_all_transfers'                      => 'Excluir TODAS as suas transferências',
    'also_delete_transactions'                  => 'A exclusão de contas também excluirá TODAS as saídas, entradas e transferências associadas!',
    'deleted_all_budgets'                       => 'Todos os orçamentos foram excluídos',
    'deleted_all_categories'                    => 'Todas as categorias foram excluídas',
    'deleted_all_tags'                          => 'Todas as tags foram excluídas',
    'deleted_all_bills'                         => 'Todas as assinaturas foram excluídas',
    'deleted_all_piggy_banks'                   => 'Todos os cofrinhos foram excluídos',
    'deleted_all_rules'                         => 'Todas as regras e grupos de regras foram excluídos',
    'deleted_all_object_groups'                 => 'Todos os grupos foram excluídos',
    'deleted_all_accounts'                      => 'Todas as contas foram excluídas',
    'deleted_all_asset_accounts'                => 'Todas as contas de ativos foram excluídas',
    'deleted_all_expense_accounts'              => 'Todas as contas de despesas foram excluídas',
    'deleted_all_revenue_accounts'              => 'Todas as contas de receita foram excluídas',
    'deleted_all_liabilities'                   => 'Todos os passivos foram excluídos',
    'deleted_all_transactions'                  => 'Todas as transações foram excluídas',
    'deleted_all_withdrawals'                   => 'Todas as saídas foram excluídas',
    'deleted_all_deposits'                      => 'Todas as entradas foram excluídas',
    'deleted_all_transfers'                     => 'Todas as transferências foram excluídas',
    'deleted_all_recurring'                     => 'Todas as transações recorrentes foram excluídas',
    'change_your_password'                      => 'Alterar sua senha',
    'delete_account'                            => 'Apagar conta',
    'current_password'                          => 'Senha atual',
    'new_password'                              => 'Nova senha',
    'new_password_again'                        => 'Nova senha (novamente)',
    'delete_your_account'                       => 'Apagar sua conta',
    'delete_your_account_help'                  => 'Excluindo sua conta também vai apagar quaisquer contas, transações, <em>qualquer coisa</em> que você pode ter salvo no Firefly III. Tudo será perdido.',
    'delete_your_account_password'              => 'Coloque sua senha para continuar.',
    'password'                                  => 'Senha',
    'are_you_sure'                              => 'Você tem certeza? Você não poderá desfazer isso.',
    'are_you_sure_confirm'                      => 'Você tem certeza?',
    'delete_account_button'                     => 'Apagar sua conta',
    'invalid_current_password'                  => 'Senha atual inválida!',
    'password_changed'                          => 'Senha alterada!',
    'should_change'                             => 'A idéia é alterar sua senha.',
    'invalid_password'                          => 'Senha inválida!',
    'what_is_pw_security'                       => 'O que é "verificar a segurança da senha"?',
    'secure_pw_title'                           => 'Como escolher uma senha segura',
    'forgot_password_response'                  => 'Caso exista uma conta com este endereço de e-mail, você encontrará instruções em sua caixa de entrada.',
    'secure_pw_history'                         => 'Não é toda semana que você lê notícias sobre site que perde as senhas de seus usuários. Hackers e ladrões usam essas senhas para tentar roubar suas informações privadas. Esta informação é valiosa.',
    'secure_pw_ff'                              => 'Você usa a mesma senha em toda a internet? Se um site perder sua senha, os hackers terão acesso a todos os seus dados. O Firefly III depende de você para escolher uma senha forte e única para proteger seus registros financeiros.',
    'secure_pw_check_box'                       => 'Para ajudá-lo o Firefly III pode verificar se a senha que você deseja usar foi roubada anteriormente. Se for esse o caso, o Firefly III aconselha a você NÃO utilizar essa senha.',
    'secure_pw_working_title'                   => 'Como isso funciona?',
    'secure_pw_working'                         => 'Ao marcar a caixa de seleção, o Firefly III enviará os cinco primeiros caracteres do hash SHA1 de sua senha <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">ao site Troy Hunt</a>, para verificar se ela está na lista. Isso impede que você use senhas inseguras, como recomendado na última <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">publicação NIST Special</a> sobre esse assunto.',
    'secure_pw_should'                          => 'Devo verificar a caixa?',
    'secure_pw_long_password'                   => 'Sim. Sempre verificar se sua senha é segura.',
    'command_line_token'                        => 'Token de linha de comando',
    'explain_command_line_token'                => 'Você precisa desse token para executar ações na linha de comando, como exportação de dados. Sem ele, esse comando sensível não irá funcionar. Não compartilhe seu token de linha de comando. Ninguém irá te perguntar sobre esse token, nem mesmo eu. se você tiver medo de perder ele, ou quando estiver paranoico, crie um novo token usando o botão.',
    'regenerate_command_line_token'             => 'Regenerar token de linha de comando',
    'token_regenerated'                         => 'Foi gerado um novo token de linha de comando',
    'change_your_email'                         => 'Altere seu endereço de email',
    'email_verification'                        => 'Uma mensagem de e-mail será enviada para o seu antigo e novo endereço de e-mail. Por motivos de segurança, você não poderá fazer o login até verificar seu novo endereço de e-mail. Se você não tem certeza se a sua instalação do Firefly III é capaz de enviar e-mails, não use esse recurso. Se você é um administrador, você pode testar isso nas <a href="settings">configurações</a>.',
    'email_changed_logout'                      => 'Até que você verifique seu endereço de e-mail, não pode iniciar sessão.',
    'login_with_new_email'                      => 'Agora você pode fazer login com seu novo endereço de e-mail.',
    'login_with_old_email'                      => 'Agora você pode fazer login novamente com o seu endereço de e-mail antigo.',
    'login_provider_local_only'                 => 'Esta ação não está disponível durante a autenticação por meio de ":login_provider".',
    'external_user_mgt_disabled'                => 'Esta ação não está disponível quando o Firefly III não é responsável pelo gerenciamento de usuários ou manipulação de autenticação.',
    'external_auth_disabled'                    => 'Esta ação não está disponível quando o Firefly III não é responsável pela autenticação.',
    'delete_local_info_only'                    => "Como o Firefly III não é responsável pelo gerenciamento de usuários ou pela manipulação de autenticação, esta função excluirá apenas informações locais do Firefly III.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'Clientes OAuth',
    'profile_oauth_no_clients'                  => 'Você não criou nenhum cliente OAuth.',
    'profile_oauth_clients_external_auth'       => 'Se você estiver usando um provedor de autenticação externo, como Authelia, clientes OAuth (como apps) não funcionarão. Você só poderá usar Tokens de Acesso Pessoal.',
    'profile_oauth_clients_header'              => 'Clientes',
    'profile_oauth_client_id'                   => 'ID do Cliente',
    'profile_oauth_client_name'                 => 'Nome',
    'profile_oauth_client_secret'               => 'Segredo',
    'profile_oauth_create_new_client'           => 'Criar um novo cliente',
    'profile_oauth_create_client'               => 'Criar um cliente',
    'profile_oauth_edit_client'                 => 'Editar cliente',
    'profile_oauth_name_help'                   => 'Alguma coisa que seus usuários vão reconhecer e identificar.',
    'profile_oauth_redirect_url'                => 'URL de redirecionamento',
    'profile_oauth_redirect_url_help'           => 'A URL de retorno da sua solicitação de autorização.',
    'profile_authorized_apps'                   => 'Aplicativos autorizados',
    'profile_authorized_clients'                => 'Clientes autorizados',
    'profile_scopes'                            => 'Escopos',
    'profile_revoke'                            => 'Revogar',
    'profile_oauth_client_secret_title'         => 'Segredo do cliente',
    'profile_oauth_client_secret_expl'          => 'Aqui está o seu novo segredo de cliente. Esta é a única vez que ela será mostrada, então não o perca! Agora você pode usar este segredo para fazer requisições de API.',
    'profile_personal_access_tokens'            => 'Tokens de acesso pessoal',
    'profile_personal_access_token'             => 'Token de acesso pessoal',
    'profile_oauth_confidential'                => 'Confidencial',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Aqui está seu novo token de acesso pessoal. Esta é a única vez que ela será mostrada então não perca! Agora você pode usar esse token para fazer solicitações de API.',
    'profile_no_personal_access_token'          => 'Você não criou nenhum token de acesso pessoal.',
    'profile_create_new_token'                  => 'Criar novo token',
    'profile_create_token'                      => 'Criar token',
    'profile_create'                            => 'Criar',
    'profile_save_changes'                      => 'Salvar alterações',
    'profile_whoops'                            => 'Ops!',
    'profile_something_wrong'                   => 'Alguma coisa deu errado!',
    'profile_try_again'                         => 'Algo deu errado. Por favor tente novamente.',
    'amounts'                                   => 'Quantias',
    'multi_account_warning_unknown'             => 'Dependendo do tipo de transação que você criar, a conta de origem e/ou de destino das divisões subsequentes pode ser sobrescrita pelo que estiver definido na primeira divisão da transação.',
    'multi_account_warning_withdrawal'          => 'Tenha em mente que a conta de origem das divisões subsequentes será sobrescrita pelo que estiver definido na primeira divisão da saída.',
    'multi_account_warning_deposit'             => 'Tenha em mente que a conta de destino das divisões subsequentes será sobrescrita pelo que estiver definido na primeira divisão da entrada.',
    'multi_account_warning_transfer'            => 'Tenha em mente que a conta de origem + de destino das divisões subsequentes serão sobrescritas pelo que for definido na primeira divisão da transferência.',


    // export data:
    'export_data_title'                         => 'Exportar dados do Firefly III',
    'export_data_menu'                          => 'Exportar dados',
    'export_data_bc'                            => 'Exportar dados do Firefly III',
    'export_data_main_title'                    => 'Exportar dados do Firefly III',
    'export_data_expl'                          => 'Este botão permite que você exporte todas as transações e os metadados do Firefly lll. Por favor, consulte a ajuda (ícone no topo direito (?)) para mais informações sobre o processo.',
    'export_data_all_transactions'              => 'Exportar todas as transações',
    'export_data_advanced_expl'                 => 'Se você precisa de um tipo mais avançado ou específico de exportação, leia a ajuda sobre como utilizar o console de comandos <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Um anexo|:count anexos',
    'attachments'                               => 'Anexos',
    'edit_attachment'                           => 'Editar anexo ":name"',
    'update_attachment'                         => 'Atualizar anexo',
    'delete_attachment'                         => 'Apagar anexo ":name"',
    'attachment_deleted'                        => 'Anexo apagado ":name"',
    'liabilities_deleted'                       => 'Passivo ":name" excluído',
    'attachment_updated'                        => 'Anexo atualizado ":name"',
    'upload_max_file_size'                      => 'Tamanho máximo do arquivo: :size',
    'list_all_attachments'                      => 'Lista de todos os anexos',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Como a transação está reconciliada, você não pode atualizar as contas, nem o(s) valor(es) até você remover o indicador de reconciliação.',
    'is_reconciled'                             => 'Está reconciliado',
    'title_expenses'                            => 'Despesas',
    'title_withdrawal'                          => 'Despesas',
    'title_revenue'                             => 'Receitas / Renda',
    'title_deposit'                             => 'Receita / Renda',
    'title_transfer'                            => 'Transferências',
    'title_transfers'                           => 'Transferências',
    'submission_options'                        => 'Opções de envio',
    'apply_rules_checkbox'                      => 'Aplicar regras',
    'fire_webhooks_checkbox'                    => 'Acionar webhooks',
    'select_source_account'                     => 'Por favor, selecione ou digite um nome de conta de origem válido',
    'select_dest_account'                       => 'Por favor, selecione ou digite um nome de conta de destino válido',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Esta transação já é uma saída',
    'convert_is_already_type_Deposit'           => 'Esta transação já é uma entrada',
    'convert_is_already_type_Transfer'          => 'Esta transação é já uma transferência',
    'convert_to_Withdrawal'                     => 'Converter ":description" para uma saída',
    'convert_to_Deposit'                        => 'Converter ":description" para uma entrada',
    'convert_to_Transfer'                       => 'Converter ":description" para uma transferência',
    'convert_options_WithdrawalDeposit'         => 'Converter uma saída em uma entrada',
    'convert_options_WithdrawalTransfer'        => 'Converter uma saída para uma transferência',
    'convert_options_DepositTransfer'           => 'Converter uma entrada em uma transferência',
    'convert_options_DepositWithdrawal'         => 'Converter uma entrada em uma saída',
    'convert_options_TransferWithdrawal'        => 'Converter uma transferência em uma saída',
    'convert_options_TransferDeposit'           => 'Converter uma transferência em uma entrada',
    'convert_Withdrawal_to_deposit'             => 'Converter esta saída de uma entrada',
    'convert_Withdrawal_to_transfer'            => 'Converter esta saída para uma transferência',
    'convert_Deposit_to_withdrawal'             => 'Converter esta entrada para uma saída',
    'convert_Deposit_to_transfer'               => 'Converter esta entrada para uma transferência',
    'convert_Transfer_to_deposit'               => 'Converter esta transferência para uma entrada',
    'convert_Transfer_to_withdrawal'            => 'Converter esta transferência em uma saída',
    'convert_please_set_revenue_source'         => 'Por favor, escolha a conta de receitas de onde virá o dinheiro.',
    'convert_please_set_asset_destination'      => 'Por favor, escolha a conta de ativo para onde vai o dinheiro.',
    'convert_please_set_expense_destination'    => 'Por favor, escolha a conta de despesas para onde o dinheiro vai.',
    'convert_please_set_asset_source'           => 'Por favor, escolha a conta de ativo, de onde virá o dinheiro.',
    'convert_expl_w_d'                          => 'Ao converter uma saída para uma entrada, o dinheiro será depositado na conta de destino exibida, em vez de ser retirado dela.|Ao converter uma saída para uma entrada, o dinheiro será depositado nas contas de destino exibidas, em vez de ser retirado delas.',
    'convert_expl_w_t'                          => 'Ao converter uma saída em uma transferência, o dinheiro será transferido para fora da conta de origem para outra conta de ativo ou conta de responsabilidade em vez de ser gasto na conta de despesa original.|Ao converter uma saída em uma transferência, o dinheiro será transferido das contas de origem para outras contas de ativo ou contas de responsabilidade em vez de ser gasto nas contas de despesas originais.',
    'convert_expl_d_w'                          => 'Ao converter uma entrada para uma saída, o dinheiro será retirado da conta de destino exibida, em vez de ser depositado nela.|Ao converter uma entrada para uma entrada, o dinheiro será retirado das contas de destino exibidas, em vez de ser depositados nelas.',
    'convert_expl_d_t'                          => 'Quando você converte uma entrada em uma transferência, o dinheiro será depositado na conta de destino listada de sua conta de ativo ou de responsabilidade.|Quando você converter uma entrada em uma transferência, o dinheiro será depositado nas contas de destino listadas de qualquer um dos seus ativos ou contas de responsabilidade.',
    'convert_expl_t_w'                          => 'Quando você converter uma transferência em uma saída, o dinheiro será gasto na conta de destino que você definir aqui, em vez de ser transferido.|Quando você converter uma transferência em uma saída, o dinheiro será gasto nas contas de destino que você definir aqui, em vez de ser transferido.',
    'convert_expl_t_d'                          => 'Quando você converte uma transferência ema uma entrada, o dinheiro será depositado na conta de destino que você vê aqui, em vez de ser transferido para ele.|Quando você converte uma transferência em uma entrada, o dinheiro será depositado nas contas de destino que você vê aqui, em vez de ser transferido para elas.',
    'convert_select_sources'                    => 'Para completar a conversão, defina a nova conta de origem abaixo.|Para completar a conversão, por favor, defina as novas contas de origem abaixo.',
    'convert_select_destinations'               => 'Para completar a conversão, por favor, selecione a nova conta de destino abaixo.|Para completar a conversão, selecione as novas contas de destino abaixo.',
    'converted_to_Withdrawal'                   => 'A transação foi convertida em uma saída',
    'converted_to_Deposit'                      => 'A transação foi convertida em entrada',
    'converted_to_Transfer'                     => 'A transação foi convertida em uma transferência',
    'invalid_convert_selection'                 => 'A conta que você selecionou já é usada nesta transação ou não existe.',
    'source_or_dest_invalid'                    => 'Os detalhes corretos da transação não foram encontrados. A conversão não é possível.',
    'convert_to_withdrawal'                     => 'Converter para saída',
    'convert_to_deposit'                        => 'Converter para entrada',
    'convert_to_transfer'                       => 'Converter para transferência',

    // create new stuff:
    'create_new_withdrawal'                     => 'Criar nova saída',
    'create_new_deposit'                        => 'Criar uma nova entrada',
    'create_new_transfer'                       => 'Criar nova  transferência',
    'create_new_asset'                          => 'Criar nova conta de ativo',
    'create_new_liabilities'                    => 'Criar novo passivo',
    'create_new_expense'                        => 'Criar nova conta de despesa',
    'create_new_revenue'                        => 'Criar nova conta de receita',
    'create_new_piggy_bank'                     => 'Criar novo cofrinho',
    'create_new_bill'                           => 'Criar nova assinatura',
    'create_new_subscription'                   => 'Criar nova assinatura',
    'create_new_rule'                           => 'Criar nova regra',

    // currencies:
    'create_currency'                           => 'Criar uma nova moeda',
    'store_currency'                            => 'Armazenar nova moeda',
    'update_currency'                           => 'Atualizar moeda',
    'new_default_currency'                      => '":name" é agora a moeda padrão.',
    'default_currency_failed'                   => 'Não foi possível tornar ":name" a moeda padrão. Por favor, verifique os logs.',
    'cannot_delete_currency'                    => 'Não é possível excluir :name porque ainda está em uso.',
    'cannot_delete_fallback_currency'           => ':name é a moeda padrão do sistema e não pode ser excluída.',
    'cannot_disable_currency_journals'          => 'Não é possível desativar :name porque as transações ainda estão a usando.',
    'cannot_disable_currency_last_left'         => ':name não pode ser desabilitada pois essa é a única moeda ativa.',
    'cannot_disable_currency_account_meta'      => ':name não pode ser desabilitada pois é utilizada nas contas de ativos.',
    'cannot_disable_currency_bills'             => ':name não pode ser desabilitada pois é utilizada nas assinaturas.',
    'cannot_disable_currency_recurring'         => ':name não pode ser desabilitada pois é utilizada nas transações recorrentes.',
    'cannot_disable_currency_available_budgets' => ':name não pode ser desabilitada pois é utilizada em orçamentos existentes.',
    'cannot_disable_currency_budget_limits'     => ':name não pode ser desabilitada pois é utilizada em limites dos orçamentos.',
    'cannot_disable_currency_current_default'   => ':name não pode ser desabilitada pois é moeda atualmente utilizada.',
    'cannot_disable_currency_system_fallback'   => ':name não pode ser desabilitada pois é moeda padrão do sistema.',
    'disable_EUR_side_effects'                  => 'O Euro é a moeda de recurso de emergência do sistema. Desativar pode ter efeitos colaterais indesejados e pode violar sua garantia.',
    'deleted_currency'                          => 'Moeda :name excluída',
    'created_currency'                          => 'Moeda :name criada',
    'could_not_store_currency'                  => 'Não foi possível guardar a nova moeda.',
    'updated_currency'                          => 'Moeda :name atualizada',
    'ask_site_owner'                            => 'Por favor, peça para :owner para adicionar, remover ou editar moedas.',
    'currencies_intro'                          => 'Firefly III oferece suporte a várias moedas que você pode definir e ativar aqui.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Tornar padrão',
    'default_currency'                          => 'padrão',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Desabilitado',
    'enable_currency'                           => 'Habilitar',
    'disable_currency'                          => 'Desabilitar',
    'currencies_default_disabled'               => 'A maioria das moedas é desabilitada por padrão. Para usá-las, você deve primeiro habilitá-las.',
    'currency_is_now_enabled'                   => 'Moeda ":name" foi ativada',
    'could_not_enable_currency'                 => 'Não foi possível habilitar a moeda ":name". Por favor, revise os logs.',
    'currency_is_now_disabled'                  => 'Moeda ":name" foi desativada',
    'could_not_disable_currency'                => 'Não foi possível desabilitar a moeda ":name". Será que ainda está em uso?',

    // forms:
    'mandatoryFields'                           => 'Campos obrigatórios',
    'optionalFields'                            => 'Campos opcionais',
    'options'                                   => 'Opções',

    // budgets:
    'daily_budgets'                             => 'Orçamentos diários',
    'weekly_budgets'                            => 'Orçamentos semanais',
    'monthly_budgets'                           => 'Orçamentos mensais',
    'quarterly_budgets'                         => 'Orçamentos trimestrais',
    'half_year_budgets'                         => 'Orçamentos semestrais',
    'yearly_budgets'                            => 'Orçamentos anuais',
    'other_budgets'                             => 'Orçamentos de períodos personalizados',
    'budget_limit_not_in_range'                 => 'Esta quantia aplica-se de :start a :end:',
    'total_available_budget'                    => 'Total de orçamentos disponíveis (entre :start e :end)',
    'total_available_budget_in_currency'        => 'Orçamentos disponíveis em :currency',
    'see_below'                                 => 'veja abaixo',
    'create_new_budget'                         => 'Criar um novo orçamento',
    'store_new_budget'                          => 'Armazenar novo orçamento',
    'stored_new_budget'                         => 'Novo orçamento armazenado ":name"',
    'available_between'                         => 'Disponível entre :start e :end',
    'transactionsWithoutBudget'                 => 'Despesas sem orçamentos',
    'transactions_no_budget'                    => 'Despesas sem orçamento entre :start e :end',
    'spent_between'                             => 'Gasto entre :start e :end',
    'spent_between_left'                        => 'Gasto :spent entre :start e :end, restando :left.',
    'set_available_amount'                      => 'Definir o valor disponível',
    'update_available_amount'                   => 'Atualizar o valor disponível',
    'ab_basic_modal_explain'                    => 'Use este formulário para indicar quanto você espera gastar (no total, em :currency) no período indicado.',
    'createBudget'                              => 'Novo orçamento',
    'invalid_currency'                          => 'Esta é uma moeda inválida',
    'invalid_amount'                            => 'Por favor, insira uma quantidade',
    'set_ab'                                    => 'O valor do orçamento disponível foi definido',
    'updated_ab'                                => 'O montante do orçamento disponível foi atualizado',
    'deleted_ab'                                => 'O montante do orçamento disponível foi excluído',
    'deleted_bl'                                => 'O valor orçado foi removido',
    'alt_currency_ab_create'                    => 'Definir o orçamento disponível em outra moeda',
    'bl_create_btn'                             => 'Definir o orçamento em outra moeda',
    'inactiveBudgets'                           => 'Orçamentos inativos',
    'without_budget_between'                    => 'Transações sem um orçamento entre :start e :end',
    'delete_budget'                             => 'Excluir orçamento ":name"',
    'deleted_budget'                            => 'Orçamento ":name" excluído',
    'edit_budget'                               => 'Editar orçamento ":name"',
    'updated_budget'                            => 'Orçamento atualizado ":name"',
    'update_amount'                             => 'Atualizar quantia',
    'update_budget'                             => 'Atualizar Orçamento',
    'update_budget_amount_range'                => 'Atualizar quantia disponível (esperada) entre :start e :end',
    'set_budget_limit_title'                    => 'Definir valor para o orçamento :budget entre :start e :end',
    'set_budget_limit'                          => 'Definir valor orçado',
    'budget_period_navigator'                   => 'Navegador do período',
    'info_on_available_amount'                  => 'O que tenho disponível?',
    'available_amount_indication'               => 'Use esses montantes para obter uma indicação do que seu orçamento total poderia ser.',
    'suggested'                                 => 'Sugerido',
    'average_between'                           => 'Média entre :start e :end',
    'transferred_in'                            => 'Transferido (para)',
    'transferred_away'                          => 'Transferido (fora)',
    'auto_budget_none'                          => 'Sem orçamento automático',
    'auto_budget_reset'                         => 'Definir um valor fixo a cada período',
    'auto_budget_rollover'                      => 'Adicionar valor a cada período',
    'auto_budget_adjusted'                      => 'Adicionar um valor a cada período e corrigir para gastos excessivos',
    'auto_budget_period_daily'                  => 'Diariamente',
    'auto_budget_period_weekly'                 => 'Semanalmente',
    'auto_budget_period_monthly'                => 'Mensalmente',
    'auto_budget_period_quarterly'              => 'Trimestralmente',
    'auto_budget_period_half_year'              => 'A cada semestre',
    'auto_budget_period_yearly'                 => 'Anualmente',
    'auto_budget_help'                          => 'Você pode ler mais sobre esta função na seção ajuda. Clique no ícone superior direito (?).',
    'auto_budget_reset_icon'                    => 'Este orçamento será definido periodicamente',
    'auto_budget_rollover_icon'                 => 'O valor orçado aumentará periodicamente',
    'auto_budget_adjusted_icon'                 => 'O valor do orçamento aumentará periodicamente e corrigirá para gastos excessivos',
    'remove_budgeted_amount'                    => 'Remover montante orçado em :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => '',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use o campo ignorar para criar intervalo bimestral (pular = 1) ou outros intervalos personalizados.',
    'subscription'                              => 'Assinatura',
    'not_expected_period'                       => 'Não esperado este período',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Não (ainda)',
    'visit_bill'                                => 'Visite a assinatura ":name" no Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Assinatura corresponde a transações entre :low e :high.',
    'running_again_loss'                        => 'Transações previamente vinculadas a esta assinatura podem perder sua conexão, se elas (não mais) corresponderem à(s) regra(s).',
    'bill_related_rules'                        => 'Regras relacionadas a essa assinatura',
    'repeats'                                   => 'Repetições',
    'bill_end_date_help'                        => 'Campo opcional. Espera-se que a assinatura termine nesta data.',
    'bill_extension_date_help'                  => 'Campo opcional. A assinatura deve ser renovada (ou cancelada) nesta ou antes desta data.',
    'bill_end_index_line'                       => 'Esta assinatura termina em :date',
    'bill_extension_index_line'                 => 'Esta fatura deve ser renovada ou cancelada em :date',
    'connected_journals'                        => 'Transações conectadas',
    'auto_match_on'                             => 'Automaticamente correspondente com Firefly III',
    'auto_match_off'                            => 'Não corresponde automaticamente com Firefly III',
    'next_expected_match'                       => 'Próximo correspondente esperado',
    'delete_bill'                               => 'Excluir assinatura ":name"',
    'deleted_bill'                              => 'Excluir assinatura ":name"',
    'edit_bill'                                 => 'Editar assinatura ":name"',
    'more'                                      => 'Mais',
    'rescan_old'                                => 'Executar regras novamente, em todas as transações',
    'update_bill'                               => 'Atualizar assinatura',
    'updated_bill'                              => 'Assinatura ":name" atualizada',
    'store_new_bill'                            => 'Armazenar nova assinatura',
    'stored_new_bill'                           => 'Nova assinatura ":name" armazenada',
    'cannot_scan_inactive_bill'                 => 'Assinaturas inativas não podem ser canceladas.',
    'rescanned_bill'                            => 'Verificamos tudo e vinculamos :count transação para a assinatura.|Verificamos tudo e vinculamos :count transações para a assinatura.',
    'average_bill_amount_year'                  => 'Valor médio de assinatura (:year)',
    'average_bill_amount_overall'               => 'Valor médio de assinatura (geral)',
    'bill_is_active'                            => 'A assinatura está ativa',
    'bill_expected_between'                     => 'Esperado entre :start e :end',
    'bill_will_automatch'                       => 'A assinatura será automaticamente vinculada a transações correspondentes',
    'skips_over'                                => 'ignorar',
    'bill_store_error'                          => 'Ocorreu um erro inesperado ao salvar sua nova assinatura. Por favor, verifique os arquivos de log',
    'list_inactive_rule'                        => 'regra inativa',
    'bill_edit_rules'                           => 'O Firefly III tentará editar a regra relacionada a esta assinatura também. Se você editou essa regra, o Firefly III não vai mudar nada. |Firefly III tentará editar :count regras relacionadas a esta assinatura também. Se você editou essas regras, no entanto, o Firefly III não vai mudar nada.',
    'bill_expected_date'                        => 'Esperado :date',
    'bill_expected_date_js'                     => 'Esperado {date}',
    'expected_amount'                           => 'Valor (esperado)',
    'bill_paid_on'                              => 'Pago em {date}',
    'bill_repeats_weekly'                       => 'Repete semanalmente',
    'bill_repeats_monthly'                      => 'Repete mensalmente',
    'bill_repeats_quarterly'                    => 'Repete trimestralmente',
    'bill_repeats_half-year'                    => 'Repete a cada semestre',
    'bill_repeats_yearly'                       => 'Repete anualmente',
    'bill_repeats_weekly_other'                 => 'Repete quinzenalmente',
    'bill_repeats_monthly_other'                => 'Repete bimestralmente',
    'bill_repeats_quarterly_other'              => 'Repete a cada dois trimestres',
    'bill_repeats_half-year_other'              => 'Repete anualmente',
    'bill_repeats_yearly_other'                 => 'Repete a cada dois anos',
    'bill_repeats_weekly_skip'                  => 'Repete a cada {skip} semanas',
    'bill_repeats_monthly_skip'                 => 'Repete a cada {skip} meses',
    'bill_repeats_quarterly_skip'               => 'Repete a cada {skip} trimestres',
    'bill_repeats_half-year_skip'               => 'Repete a cada {skip} semestres',
    'bill_repeats_yearly_skip'                  => 'Repete a cada {skip} anos',
    'subscriptions'                             => 'Assinaturas',
    'go_to_subscriptions'                       => 'Vá para suas assinaturas',
    'forever'                                   => 'Para sempre',
    'extension_date_is'                         => 'Data da extensão é {date}',

    // accounts:
    'account_locked_currency'                   => 'A moeda desta conta deve permanecer :name enquanto os cofrinhos estiverem ligados a ela.',
    'i_am_owed_amount'                          => 'Eu tenho uma dívida a receber',
    'i_owe_amount'                              => 'Valor do passivo',
    'inactive_account_link'                     => 'Você tem :count conta inativa (arquivada), que você pode ver nesta página separada.|Você tem :count contas inativas (arquivadas), que você pode ver nesta página separada.',
    'all_accounts_inactive'                     => 'Estas são as suas contas inativas.',
    'active_account_link'                       => 'Este link volta para suas contas ativas.',
    'account_missing_transaction'               => 'Conta #:id (":name") não pode ser visualizada diretamente, mas o Firefly está sem informação de redirecionamento.',
    'cc_monthly_payment_date_help'              => 'Selecione qualquer ano e mês, eles serão ignorados. Apenas o dia do mês é relevante.',
    'details_for_asset'                         => 'Detalhes para a conta de ativo ":name"',
    'details_for_expense'                       => 'Detalhes para a conta de despesas ":name"',
    'details_for_revenue'                       => 'Detalhes para a conta de receitas ":name"',
    'details_for_cash'                          => 'Detalhes para a conta de dinheiro ":name"',
    'store_new_asset_account'                   => 'Armazenar nova conta de ativo',
    'store_new_expense_account'                 => 'Armazenar nova conta de despesa',
    'store_new_revenue_account'                 => 'Armazenar nova conta de receita',
    'edit_asset_account'                        => 'Editar conta de ativo ":name"',
    'edit_expense_account'                      => 'Editar conta de despesa ":name"',
    'edit_revenue_account'                      => 'Editar conta de receitas ":name"',
    'delete_asset_account'                      => 'Excluir conta de ativo ":name"',
    'delete_expense_account'                    => 'Excluir conta de despesas ":name"',
    'delete_revenue_account'                    => 'Excluir conta de receitas ":name"',
    'delete_liabilities_account'                => 'Apagar passivo ":name"',
    'asset_deleted'                             => 'Conta de ativo ":name" excluída com sucesso',
    'account_deleted'                           => 'Conta ":name" deletada com sucesso',
    'expense_deleted'                           => 'Conta de despesa ":name" excluída com sucesso',
    'revenue_deleted'                           => 'Conta de receitas ":name" excluída com sucesso',
    'update_asset_account'                      => 'Atualizar de conta de ativo',
    'update_undefined_account'                  => 'Atualizar conta',
    'update_liabilities_account'                => 'Atualizar passivo',
    'update_expense_account'                    => 'Atualizar conta de despesas',
    'update_revenue_account'                    => 'Atualizar conta de receita',
    'make_new_asset_account'                    => 'Criar uma nova conta de ativo',
    'make_new_expense_account'                  => 'Criar uma nova conta de despesa',
    'make_new_revenue_account'                  => 'Criar uma nova conta de receita',
    'make_new_liabilities_account'              => 'Criar um novo passivo',
    'asset_accounts'                            => 'Contas de ativo',
    'undefined_accounts'                        => 'Contas',
    'asset_accounts_inactive'                   => 'Contas de ativos (inativas)',
    'expense_account'                           => 'Conta de despesas',
    'expense_accounts'                          => 'Contas de despesas',
    'expense_accounts_inactive'                 => 'Contas de despesas (inativas)',
    'revenue_account'                           => 'Conta de Receitas',
    'revenue_accounts'                          => 'Contas de receitas',
    'revenue_accounts_inactive'                 => 'Contas de receita (inativas)',
    'cash_accounts'                             => 'Contas Correntes',
    'Cash account'                              => 'Conta Corrente',
    'liabilities_accounts'                      => 'Passivos',
    'liabilities_accounts_inactive'             => 'Passivos (inativos)',
    'reconcile_account'                         => 'Reconciliar conta ":account"',
    'overview_of_reconcile_modal'               => 'Visão geral da reconciliação',
    'delete_reconciliation'                     => 'Eliminar reconciliação',
    'update_reconciliation'                     => 'Atualizar a reconciliação',
    'amount_cannot_be_zero'                     => 'O valor não pode ser zero',
    'end_of_reconcile_period'                   => 'Período de fim de reconciliação: :period',
    'start_of_reconcile_period'                 => 'Início do período de reconciliação: :period',
    'start_balance'                             => 'Saldo Inicial',
    'end_balance'                               => 'Saldo Final',
    'update_balance_dates_instruction'          => 'Corresponda os valores e datas acima do seu extracto bancário e pressione "Começar reconciliar"',
    'select_transactions_instruction'           => 'Selecione as transações que aparecem no extrato bancário.',
    'select_range_and_balance'                  => 'Primeiro, verifique o intervalo de datas e os saldos. Em seguida, pressione "Iniciar reconciliação"',
    'date_change_instruction'                   => 'Se você alterar o intervalo de datas agora, qualquer progresso será perdido.',
    'update_selection'                          => 'Atualizar seleção',
    'store_reconcile'                           => 'Armazenar reconciliação',
    'reconciliation_transaction'                => 'Transação de reconciliação',
    'Reconciliation'                            => 'Reconciliação',
    'reconciliation'                            => 'Reconciliação',
    'reconcile_options'                         => 'Opções de reconciliação',
    'reconcile_range'                           => 'Intervalo de reconciliação',
    'start_reconcile'                           => 'Comece a reconciliar',
    'cash_account_type'                         => 'Dinheiro',
    'cash'                                      => 'dinheiro',
    'cant_find_redirect_account'                => 'Firefly III tentou te redirecionar mas não conseguiu. Desculpe por isso. De volta ao índice.',
    'account_type'                              => 'Tipo de conta',
    'save_transactions_by_moving'               => 'Salve esta transação movendo-a para outra conta:|Salve essas transações movendo-as para outra conta:',
    'save_transactions_by_moving_js'            => 'Nenhuma transação.|Salve esta transação movendo-a para outra conta.|Salve essas transações movendo-as para outra conta.',
    'stored_new_account'                        => 'Nova conta ":name" armazenado!',
    'stored_new_account_js'                     => 'Nova conta "<a href="accounts/show/{ID}">{name}</a>" armazenada!',
    'updated_account'                           => 'Conta ":name" atualizada',
    'updated_account_js'                        => 'Conta atualizada "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Opções de cartão de crédito',
    'no_transactions_account'                   => 'Não há transações (neste período) para a conta ativa ":name".',
    'no_transactions_period'                    => 'Não há transações (neste período).',
    'no_data_for_chart'                         => 'Não há informações suficientes (ainda) para gerar este gráfico.',
    'select_at_least_one_account'               => 'Por favor, selecione pelo menos uma conta de ativo',
    'select_at_least_one_category'              => 'Por favor selecione, pelo menos, uma categoria',
    'select_at_least_one_budget'                => 'Por favor, selecione pelo menos um orçamento',
    'select_at_least_one_tag'                   => 'Por favor, selecione pelo menos uma tag',
    'select_at_least_one_expense'               => 'Por favor, selecione pelo menos uma combinação de contas de despesas/receitas. Se você não tem nenhuma (a lista está vazia) este relatório não está disponível.',
    'account_default_currency'                  => 'Esta será a moeda padrão associada a esta conta.',
    'piggy_default_currency'                    => 'Os cofrinhos só podem guardar dinheiro em uma única moeda.',
    'piggy_account_currency_match'              => 'Apenas as contas que usam a moeda selecionada anteriormente serão aceitas.',
    'reconcile_has_more'                        => 'Seu registro do Firefly III tem mais dinheiro nele do que o seu banco afirma que você deveria ter. Existem várias opções. Escolha o que fazer. Em seguida, pressione "Confirmar reconciliação".',
    'reconcile_has_less'                        => 'Seu registro do Firefly III tem menos dinheiro nele do que o seu banco afirma que você deveria ter. Existem várias opções. Escolha o que fazer. Em seguida, pressione "Confirmar reconciliação".',
    'reconcile_is_equal'                        => 'Seu registro do Firefly III e seus registros bancários combinam. Não há nada a se fazer. Pressione "Confirmar reconciliação" para confirmar sua entrada.',
    'create_pos_reconcile_transaction'          => 'Desmarque as transações selecionadas e, em seguida, crie uma correção adicionando :amount para esta conta ativa.',
    'create_neg_reconcile_transaction'          => 'Desmarque as transações selecionadas e, em seguida, crie uma correção removendo :amount para esta conta ativa.',
    'reconcile_do_nothing'                      => 'Desmarcar as transações selecionadas, mas não corrigir.',
    'reconcile_go_back'                         => 'Você sempre pode editar ou excluir uma correção mais tarde.',
    'must_be_asset_account'                     => 'Você só pode conciliar contas de ativos',
    'reconciliation_stored'                     => 'Reconciliação armazenada',
    'reconciliation_error'                      => 'Devido a um erro, as transações foram marcadas como conciliadas, mas a correcção não foi armazenada: :error.',
    'reconciliation_transaction_title'          => 'Reconciliação (:from a :to)',
    'sum_of_reconciliation'                     => 'Total reconciliado',
    'reconcile_this_account'                    => 'Concilie esta conta',
    'reconcile'                                 => 'Reconciliar',
    'show'                                      => 'Exibir',
    'confirm_reconciliation'                    => 'Confirmar reconciliação',
    'submitted_start_balance'                   => 'Saldo inicial enviado',
    'selected_transactions'                     => 'Transações selecionadas (:count)',
    'already_cleared_transactions'              => 'Transações já removidas (:count)',
    'submitted_end_balance'                     => 'Saldo final enviado',
    'initial_balance_description'               => 'Saldo inicial para ":account"',
    'liability_credit_description'              => 'Passivo de crédito para ":account"',
    'interest_calc_'                            => 'desconhecido',
    'interest_calc_daily'                       => 'Por dia',
    'interest_calc_monthly'                     => 'Por mês',
    'interest_calc_yearly'                      => 'Por ano',
    'interest_calc_weekly'                      => 'Por semana',
    'interest_calc_half-year'                   => 'Por semestre',
    'interest_calc_quarterly'                   => 'Por trimestre',
    'initial_balance_account'                   => 'Saldo inicial da conta :account',
    'list_options'                              => 'Opções de lista',
    'account_column_opt_drag_and_drop'          => 'Arrastar e soltar',
    'account_column_opt_active'                 => 'Ativo',
    'account_column_opt_name'                   => 'Nome',
    'account_column_opt_type'                   => 'Tipo',
    'account_column_opt_liability_type'         => 'Tipo de passivo',
    'account_column_opt_liability_direction'    => 'Direção do passivo',
    'account_column_opt_liability_interest'     => 'Juro do passivo',
    'account_column_opt_number'                 => 'Número da conta',
    'account_column_opt_current_balance'        => 'Saldo atual',
    'account_column_opt_amount_due'             => 'Valor devido',
    'account_column_opt_last_activity'          => 'Última atividade',
    'account_column_opt_balance_difference'     => 'Diferença de saldo',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nova categoria',
    'create_new_category'                       => 'Criar uma nova categoria',
    'without_category'                          => 'Sem uma categoria',
    'update_category'                           => 'Atualizar Categoria',
    'updated_category'                          => 'Atualizado categoria ":name"',
    'categories'                                => 'Categorias',
    'edit_category'                             => 'Editar categoria ":name"',
    'no_category'                               => '(sem categoria)',
    'unknown_category_plain'                    => 'Sem categoria',
    'category'                                  => 'Categoria',
    'delete_category'                           => 'Excluir categoria ":name"',
    'deleted_category'                          => 'Categoria ":name" excluída',
    'store_category'                            => 'Armazenar nova categoria',
    'stored_category'                           => 'Armazenada nova categoria ":name"',
    'without_category_between'                  => 'Sem categoria entre :start e :end',


    // transactions:
    'wait_loading_transaction'                  => 'Por favor, aguarde o formulário carregar',
    'wait_loading_data'                         => 'Por favor, aguarde suas informações serem carregadas...',
    'wait_attachments'                          => 'Por favor, aguarde pelo upload dos anexos.',
    'errors_upload'                             => 'O upload falhou. Por favor, verifique o console do seu navegador para o erro.',
    'amount_foreign_if'                         => 'Valor em moeda estrangeira, se houver',
    'amount_destination_account'                => 'Valor na moeda da conta destino',
    'edit_transaction_title'                    => 'Editar transação ":description"',
    'unreconcile'                               => 'Desfazer reconciliação',
    'update_withdrawal'                         => 'Atualizar saída',
    'update_deposit'                            => 'Atualizar entrada',
    'update_transaction'                        => 'Atualizar transação',
    'update_transfer'                           => 'Atualizar transferência',
    'updated_withdrawal'                        => 'Saída atualizada ":description"',
    'updated_deposit'                           => 'Entrada atualizada ":description"',
    'updated_transfer'                          => 'Transferência atualizada ":description"',
    'no_changes_withdrawal'                     => 'A retirada ":description" não foi alterada.',
    'no_changes_deposit'                        => 'O depósito ":description" não foi alterado.',
    'no_changes_transfer'                       => 'A transferência ":description" não foi alterada.',
    'delete_withdrawal'                         => 'Excluir a saída ":description"',
    'delete_deposit'                            => 'Apagar entrada ":description"',
    'delete_transfer'                           => 'Apagar transferência ":description"',
    'deleted_withdrawal'                        => 'Saída":description" excluída com sucesso',
    'deleted_deposit'                           => 'Entrada":description" excluída com sucesso',
    'deleted_transfer'                          => 'Transferência ":description" excluída com sucesso',
    'deleted_reconciliation'                    => 'Transação de reconciliação ":description" excluída com sucesso',
    'stored_journal'                            => 'Transação ":description" incluída com sucesso',
    'stored_journal_js'                         => 'Transação "{{description}}" criada com sucesso',
    'stored_journal_no_descr'                   => 'Transação criada com sucesso',
    'updated_journal_no_descr'                  => 'Transação atualizada com sucesso',
    'select_transactions'                       => 'Selecione as transações',
    'rule_group_select_transactions'            => 'Aplicar ":title" às transações',
    'rule_select_transactions'                  => 'Aplicar ":title" às transações',
    'stop_selection'                            => 'Parar de selecionar transações',
    'reconcile_selected'                        => 'Reconciliar',
    'mass_delete_journals'                      => 'Excluir transações em massa',
    'mass_edit_journals'                        => 'Editar transações em massa',
    'mass_bulk_journals'                        => 'Editar transações em massa',
    'mass_bulk_journals_explain'                => 'Este formulário permite alterar as propriedades das transações listadas abaixo em uma atualização abrangente. Todas as transações na tabela serão atualizadas quando você alterar os parâmetros que você vê aqui.',
    'part_of_split'                             => 'Esta transação faz parte de uma transação dividida. Se você não selecionou todas as divisões, poderá acabar mudando apenas metade da transação.',
    'bulk_set_new_values'                       => 'Use as entradas abaixo para definir novos valores. Se você deixá-los vazios, eles serão feitos vazios para todos. Além disso, note que apenas as saídas receberão um orçamento.',
    'no_bulk_category'                          => 'Não atualize a categoria',
    'no_bulk_budget'                            => 'Não atualize o orçamento',
    'no_bulk_tags'                              => 'Não atualize a(s) tag(s)',
    'replace_with_these_tags'                   => 'Substituir com estas tags',
    'append_these_tags'                         => 'Adicionar estas tags',
    'mass_edit'                                 => 'Editar selecionados individualmente',
    'bulk_edit'                                 => 'Editar selecionados em massa',
    'mass_delete'                               => 'Excluir selecionados',
    'cannot_edit_other_fields'                  => 'Você não pode editar em massa outros campos além desses aqui, porque não há espaço para mostrá-los. Por favor, siga o link para editá-los um por um, se você precisar editar esses campos.',
    'cannot_change_amount_reconciled'           => 'Você não pode alterar o valor ou conta(s) das transações reconciliadas.',
    'no_budget'                                 => '(sem orçamento)',
    'no_bill'                                   => '(sem assinatura)',
    'account_per_budget'                        => 'Conta por orçamento',
    'account_per_category'                      => 'Conta por categoria',
    'create_new_object'                         => 'Criar',
    'empty'                                     => '(vazio)',
    'all_other_budgets'                         => '(todos os outros orçamentos)',
    'all_other_accounts'                        => '(todas as outras contas)',
    'expense_per_source_account'                => 'Despesas por conta origem',
    'expense_per_destination_account'           => 'Despesas por conta destino',
    'income_per_destination_account'            => 'Receita por conta destino',
    'spent_in_specific_category'                => 'Gasto na categoria ":category"',
    'earned_in_specific_category'               => 'Ganhos na categoria ":category"',
    'spent_in_specific_tag'                     => 'Gasto na tag ":tag"',
    'earned_in_specific_tag'                    => 'Ganho na tag ":tag"',
    'income_per_source_account'                 => 'Receita por conta origem',
    'average_spending_per_destination'          => 'Média de despesas por conta destino',
    'average_spending_per_source'               => 'Gasto médio por conta origem',
    'average_earning_per_source'                => 'Média de ganhos por conta origem',
    'average_earning_per_destination'           => 'Ganhos médios por conta destino',
    'account_per_tag'                           => 'Conta por tag',
    'tag_report_expenses_listed_once'           => 'Despesas e receitas nunca são listadas duas vezes. Se uma transação tiver múltiplas tags, pode apenas aparecer em uma de suas tags. Esta lista pode parecer estar faltando dados, mas os valores estão corretos.',
    'double_report_expenses_charted_once'       => 'Despesas e receitas nunca são exibidos duas vezes. Se uma transação tiver múltiplas tags, pode apenas aparecer em uma de suas tags. Este gráfico pode parecer que está faltando dados, mas os valores estão corretos.',
    'tag_report_chart_single_tag'               => 'Este gráfico se aplica a uma única tag. Se uma transação tem múltiplas tags, o que você vê aqui pode aparecer nos gráficos de outras tags também.',
    'tag'                                       => 'Tag',
    'no_budget_squared'                         => '(sem orçamento)',
    'perm-delete-many'                          => 'Excluir muitos itens de uma só vez pode ser muito perturbador. Por favor, seja cauteloso. Você pode excluir parte de uma transação dividida desta página, então tome cuidado.',
    'mass_deleted_transactions_success'         => ':count transação excluída.|:count transações excluídas.',
    'mass_edited_transactions_success'          => 'Atualizado :count transação.|Atualizado :count transações.',
    'opt_group_'                                => '(nenhum tipo de conta)',
    'opt_group_no_account_type'                 => '(sem o tipo de conta)',
    'opt_group_defaultAsset'                    => 'Contas padrão',
    'opt_group_savingAsset'                     => 'Contas de poupança',
    'opt_group_sharedAsset'                     => 'Contas de ativos compartilhadas',
    'opt_group_ccAsset'                         => 'Cartões de crédito',
    'opt_group_cashWalletAsset'                 => 'Carteiras de dinheiro',
    'opt_group_expense_account'                 => 'Contas de despesas',
    'opt_group_revenue_account'                 => 'Contas de receitas',
    'opt_group_l_Loan'                          => 'Passivo: empréstimo',
    'opt_group_cash_account'                    => 'Conta em dinheiro',
    'opt_group_l_Debt'                          => 'Passivo: dívida',
    'opt_group_l_Mortgage'                      => 'Passivo: hipoteca',
    'opt_group_l_Credit card'                   => 'Passivo: cartão de crédito',
    'notes'                                     => 'Notas',
    'view_notes'                                => 'Ver notas',
    'set_budget_limit_notes'                    => 'Ver as notas para este valor orçado',
    'edit_bl_notes'                             => 'Editar notas',
    'update_bl_notes'                           => 'Atualizar notas',
    'unknown_journal_error'                     => 'A transação não pôde ser armazenada. Por favor, verifique os arquivos de log.',
    'attachment_not_found'                      => 'O anexo não foi encontrado.',
    'journal_link_bill'                         => 'Esta transação está vinculada à assinatura <a href=":route">:name</a>. Para remover a conexão, desmarque a caixa de seleção. Use as regras para conectá-la a outra assinatura.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transação #{ID} ("{title}")</a> foi salva.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transação #{ID}</a> foi salva.',
    'transaction_updated_link'                  => 'A <a href="transactions/show/{ID}">Transação #{ID}</a> ("{title}") foi atualizada.',
    'transaction_updated_no_changes'            => 'A <a href="transactions/show/{ID}">Transação #{ID}</a> ("{title}") não recebeu nenhuma alteração.',
    'first_split_decides'                       => 'A primeira divisão determina o valor deste campo',
    'first_split_overrules_source'              => 'A primeira divisão pode anular a conta de origem',
    'first_split_overrules_destination'         => 'A primeira divisão pode anular a conta de destino',
    'spent_x_of_y'                              => 'Gasto {amount} de {total}',

    // new user:
    'welcome'                                   => 'Bem Vindo ao Firefly III!',
    'submit'                                    => 'Enviar',
    'submission'                                => 'Envio',
    'submit_yes_really'                         => 'Enviar (eu sei o que estou fazendo)',
    'getting_started'                           => 'Iniciar',
    'to_get_started'                            => 'É bom ver que você instalou o Firefly III com sucesso. Para começar com esta ferramenta, insira o nome do banco e o saldo da sua principal conta corrente. Não se preocupe ainda se você tiver várias contas. Você pode adicionar aqueles mais tarde. É só que o Firefly III precisa de algo para começar.',
    'savings_balance_text'                      => 'O Firefly III criará automaticamente uma conta de poupança para você. Por padrão, não haverá dinheiro na sua conta de poupança, mas se você contar o saldo ao Firefly III, ele será armazenado como tal.',
    'finish_up_new_user'                        => 'É isso aí! Você pode continuar pressionando <strong>Enviar</strong>. Você será levado ao índice de Firefly III.',
    'stored_new_accounts_new_user'              => 'Yay! Suas novas contas foram armazenadas.',
    'set_preferred_language'                    => 'Se você prefere utilizar o Firefly III em outro idioma, informe aqui.',
    'language'                                  => 'Idioma',
    'new_savings_account'                       => 'Conta de poupança :bank_name',
    'cash_wallet'                               => 'Carteira de dinheiro',
    'currency_not_present'                      => 'Não se preocupe se a moeda que você usa normalmente não está listada. Você pode criar suas próprias moedas em "Opções > Moedas".',

    // home page:
    'transaction_table_description'             => 'Uma tabela contendo suas transações',
    'opposing_account'                          => 'Conta oposta',
    'yourAccounts'                              => 'Suas contas',
    'your_accounts'                             => 'Visão geral da sua conta',
    'category_overview'                         => 'Visão geral da categoria',
    'expense_overview'                          => 'Visão geral da conta de despesa',
    'revenue_overview'                          => 'Visão geral da conta de receita',
    'budgetsAndSpending'                        => 'Orçamentos e despesas',
    'budgets_and_spending'                      => 'Orçamentos e despesas',
    'go_to_budget'                              => 'Ir para o orçamento "{budget}"',
    'go_to_deposits'                            => 'Ir para as entradas',
    'go_to_expenses'                            => 'Ir para despesas',
    'savings'                                   => 'Poupanças',
    'newWithdrawal'                             => 'Nova despesa',
    'newDeposit'                                => 'Nova entrada',
    'newTransfer'                               => 'Nova transferência',
    'bills_to_pay'                              => 'Assinaturas a pagar',
    'per_day'                                   => 'Por dia',
    'left_to_spend_per_day'                     => 'Restante para gastar por dia',
    'bills_paid'                                => 'Assinaturas pagas',
    'custom_period'                             => 'Período personalizado',
    'reset_to_current'                          => 'Redefinir para o período atual',
    'select_period'                             => 'Selecione um período',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Moeda',
    'preferences'                               => 'Preferências',
    'logout'                                    => 'Desconectar',
    'logout_other_sessions'                     => 'Sair de todas as outras sessões',
    'toggleNavigation'                          => 'Alternar navegação',
    'toggle_dropdown'                           => 'Ativar/Desativar Menu Suspenso',
    'searchPlaceholder'                         => 'Pesquisar...',
    'version'                                   => 'Versão',
    'dashboard'                                 => 'Painel de Controle',
    'income_and_expense'                        => 'Receitas e despesas',
    'all_money'                                 => 'Todo o seu dinheiro',
    'unknown_source_plain'                      => 'Conta de origem desconhecida',
    'unknown_dest_plain'                        => 'Conta de destino desconhecida',
    'unknown_any_plain'                         => 'Conta desconhecida',
    'unknown_budget_plain'                      => 'Nenhum orçamento',
    'available_budget'                          => 'Orçamento disponível ({currency})',
    'currencies'                                => 'Moedas',
    'activity'                                  => 'Atividade',
    'usage'                                     => 'Utilização',
    'accounts'                                  => 'Contas',
    'Asset account'                             => 'Conta de ativo',
    'Default account'                           => 'Conta de ativo',
    'Expense account'                           => 'Conta de Despesa',
    'Revenue account'                           => 'Conta de Receita',
    'Initial balance account'                   => 'Saldo inicial da conta',
    'account_type_Asset account'                => 'Conta de ativos',
    'account_type_Expense account'              => 'Conta de despesas',
    'account_type_Revenue account'              => 'Conta de receitas',
    'account_type_Debt'                         => 'Dívida',
    'account_type_Loan'                         => 'Empréstimo',
    'account_type_Mortgage'                     => 'Hipoteca',
    'account_type_debt'                         => 'Débito',
    'account_type_loan'                         => 'Empréstimo',
    'account_type_mortgage'                     => 'Hipoteca',
    'account_type_Credit card'                  => 'Cartão de crédito',
    'credit_card_type_monthlyFull'              => 'Pagamento completo todo mês',
    'liability_direction_credit'                => 'Eu tenho uma dívida a receber',
    'liability_direction_debit'                 => 'Eu tenho uma dívida a pagar',
    'liability_direction_credit_short'          => 'Devo receber essa dívida',
    'liability_direction_debit_short'           => 'Devo essa dívida',
    'liability_direction__short'                => 'Desconhecida',
    'liability_direction_null_short'            => 'Desconhecida',
    'Liability credit'                          => 'Crédito de passivo',
    'budgets'                                   => 'Orçamentos',
    'tags'                                      => 'Tags',
    'reports'                                   => 'Relatórios',
    'transactions'                              => 'Transações',
    'expenses'                                  => 'Despesas',
    'income'                                    => 'Receita / Renda',
    'transfers'                                 => 'Transferências',
    'moneyManagement'                           => 'Gerenciamento de Dinheiro',
    'money_management'                          => 'Gestão Monetária',
    'tools'                                     => 'Ferramentas',
    'piggyBanks'                                => 'Cofrinhos',
    'piggy_banks'                               => 'Cofrinhos',
    'amount_x_of_y'                             => '{current} de {total}',
    'bills'                                     => 'Assinaturas',
    'withdrawal'                                => 'Retirada',
    'opening_balance'                           => 'Saldo inicial',
    'deposit'                                   => 'Depósito',
    'account'                                   => 'Conta',
    'transfer'                                  => 'Transferência',
    'Withdrawal'                                => 'Retirada',
    'Deposit'                                   => 'Depósito',
    'Transfer'                                  => 'Transferência',
    'bill'                                      => 'Assinatura',
    'yes'                                       => 'Sim',
    'no'                                        => 'Não',
    'amount'                                    => 'Valor',
    'overview'                                  => 'Visão Geral',
    'saveOnAccount'                             => 'Salvar na conta',
    'saveOnAccounts'                            => 'Salvar na(s) conta(s)',
    'unknown'                                   => 'Desconhecido',
    'monthly'                                   => 'Mensal',
    'profile'                                   => 'Perfil',
    'errors'                                    => 'Erros',
    'debt_start_date'                           => 'Data de início da dívida',
    'debt_start_amount'                         => 'Montante inicial da dívida',
    'debt_start_amount_help'                    => 'É sempre melhor definir este valor para um valor negativo. Leia as páginas de ajuda (ícone no topo direito (?)) para mais informações.',
    'interest_period_help'                      => 'Esse campo é puramente estético e não será calculado para você. Como os bancos são muito sorrateiros, o Firefly lll nunca acertou esse cálculo.',
    'store_new_liabilities_account'             => 'Guardar novo passivo',
    'edit_liabilities_account'                  => 'Editar passivo ":name"',
    'financial_control'                         => 'Controle financeiro',
    'accounting'                                => 'Contabilidade',
    'automation'                                => 'Automação',
    'others'                                    => 'Outros',
    'classification'                            => 'Classificação',
    'store_transaction'                         => 'Salvar transação',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Relatório financeiro padrão entre :start e :end',
    'report_audit'                              => 'Visão geral do histórico de transação entre :start e :end',
    'report_category'                           => 'Relatório de categoria entre :start e :end',
    'report_double'                             => 'Relatório de despesas/receitas entre :start e :end',
    'report_budget'                             => 'Relatório de orçamento entre :start e :end',
    'report_tag'                                => 'Relatório de tag entre :start e :end',
    'quick_link_reports'                        => 'Links rápidos',
    'quick_link_examples'                       => 'Estes são apenas alguns links de exemplo para você começar. Confira as páginas de ajuda com o botão (?) para obter informações sobre todos os relatórios e as palavras mágicas que você pode usar.',
    'quick_link_default_report'                 => 'Relatório financeiro padrão',
    'quick_link_audit_report'                   => 'Visão geral do histórico de transação',
    'report_this_month_quick'                   => 'Mês atual, todas as contas',
    'report_last_month_quick'                   => 'Mês passado, todas as contas',
    'report_this_year_quick'                    => 'Ano atual, todas as contas',
    'report_this_fiscal_year_quick'             => 'Ano fiscal atual, todas as contas',
    'report_all_time_quick'                     => 'Todos os tempos, todas as contas',
    'reports_can_bookmark'                      => 'Lembre-se que relatórios podem ser favoritados.',
    'incomeVsExpenses'                          => 'Renda vs. Despesas',
    'accountBalances'                           => 'Saldos de Contas',
    'balanceStart'                              => 'Saldo no início do período',
    'balanceEnd'                                => 'Saldo no final do período',
    'splitByAccount'                            => 'Dividir por conta',
    'coveredWithTags'                           => 'Coberto com tags',
    'leftInBudget'                              => 'Deixou no orçamento',
    'left_in_debt'                              => 'Valor do passivo',
    'sumOfSums'                                 => 'Soma dos montantes',
    'noCategory'                                => '(sem categoria)',
    'notCharged'                                => 'Não cobrado (ainda)',
    'inactive'                                  => 'Inativo',
    'active'                                    => 'Ativo',
    'difference'                                => 'Diferença',
    'money_flowing_in'                          => 'Entrada',
    'money_flowing_out'                         => 'Saída',
    'topX'                                      => 'topo :number',
    'show_full_list'                            => 'Mostrar a lista inteira',
    'show_only_top'                             => 'Mostrar apenas os topo :number',
    'report_type'                               => 'Tipo de relatório',
    'report_type_default'                       => 'Relatório financeiro padrão',
    'report_type_audit'                         => 'Visão geral do histórico de transação (auditoria)',
    'report_type_category'                      => 'Relatório por Categorias',
    'report_type_budget'                        => 'Relatório de orçamento',
    'report_type_tag'                           => 'Relatório de tag',
    'report_type_double'                        => 'Relatório de despesas/receitas',
    'more_info_help'                            => 'Mais informações sobre esses tipos de relatórios podem ser encontradas nas páginas de ajuda. Pressione o ícone (?) no canto superior direito.',
    'report_included_accounts'                  => 'Contas incluídas',
    'report_date_range'                         => 'Período',
    'report_preset_ranges'                      => 'Intervalos pré-definidos',
    'shared'                                    => 'Compartilhado',
    'fiscal_year'                               => 'Ano fiscal',
    'income_entry'                              => 'Rendimento da conta ":name" entre :start e :end',
    'expense_entry'                             => 'Despesas da conta ":name" entre :start e :end',
    'category_entry'                            => 'Despesas e receitas na categoria ":name" entre :start e :end',
    'budget_spent_amount'                       => 'Despesas no orçamento ":name" entre :start e :end',
    'balance_amount'                            => 'Despesas no orçamento ":budget" pagas por conta":account" entre :start e :end',
    'no_audit_activity'                         => 'Nenhuma atividade foi registrada na conta <a href=":url" title=":account_name">:account_name</a> entre :start e :end.',
    'audit_end_balance'                         => 'Saldo da conta <a href=":url" title=":account_name">:account_name</a> no final de :end foi :balance',
    'reports_extra_options'                     => 'Opções adicionais',
    'report_has_no_extra_options'               => 'Este relatório não tem mais opções',
    'reports_submit'                            => 'Visualizar relatório',
    'end_after_start_date'                      => 'Data de término do relatório deve ser depois da data de início.',
    'select_category'                           => 'Selecionar categoria(s)',
    'select_budget'                             => 'Selecionar orçamento(s).',
    'select_tag'                                => 'Selecionar tag(s).',
    'income_per_category'                       => 'Receitas por categoria',
    'expense_per_category'                      => 'Despesa por categoria',
    'expense_per_budget'                        => 'Despesa por orçamento',
    'income_per_account'                        => 'Rendimento por conta',
    'expense_per_account'                       => 'Por conta de despesas',
    'expense_per_tag'                           => 'Despesa por tag',
    'income_per_tag'                            => 'Rendimento por tag',
    'include_expense_not_in_budget'             => 'Despesas não incluídas no(s) orçamento(s) selecionado(s)',
    'include_expense_not_in_account'            => 'Despesas não incluídas na(s) contas(s) selecionada(s)',
    'include_expense_not_in_category'           => 'Despesas não incluídas na(s) categoria(s) selecionada(s)',
    'include_income_not_in_category'            => 'Rendimento não incluído na(s) categoria(s) selecionada(s)',
    'include_income_not_in_account'             => 'Rendimento não incluído na(s) conta(s) selecionada(s)',
    'include_income_not_in_tags'                => 'Rendimento não incluído na(s) tag(s) selecionada(s)',
    'include_expense_not_in_tags'               => 'Despesas não incluídas na(s) tag(s) selecionada(s)',
    'everything_else'                           => 'Todo o resto',
    'income_and_expenses'                       => 'Receitas e despesas',
    'spent_average'                             => 'Gastos (média)',
    'income_average'                            => 'Renda (média)',
    'transaction_count'                         => 'Contagem de transações',
    'average_spending_per_account'              => 'Média de gastos por conta',
    'average_income_per_account'                => 'Rendimento médio por conta',
    'total'                                     => 'Total',
    'description'                               => 'Descrição',
    'sum_of_period'                             => 'Soma de período',
    'average_in_period'                         => 'Média do período',
    'no_account_role'                           => '(sem função)',
    'account_role_defaultAsset'                 => 'Conta padrão',
    'account_role_sharedAsset'                  => 'Contas de ativos compartilhadas',
    'account_role_savingAsset'                  => 'Conta poupança',
    'account_role_ccAsset'                      => 'Cartão de crédito',
    'account_role_cashWalletAsset'              => 'Carteira de dinheiro',
    'budget_chart_click'                        => 'Clique no nome do orçamento na tabela acima para ver um gráfico.',
    'category_chart_click'                      => 'Clique no nome da categoria na tabela acima para ver um gráfico.',
    'in_out_accounts'                           => 'Ganhou e gastou por combinação',
    'in_out_accounts_per_asset'                 => 'Ganhos e gastos (por conta de ativo)',
    'in_out_per_category'                       => 'Ganhou e gastou por categoria',
    'out_per_budget'                            => 'Gasto por orçamento',
    'select_expense_revenue'                    => 'Selecione conta de despesa/receita',
    'multi_currency_report_sum'                 => 'Esta lista têm contas com várias moedas, portanto a(s) soma(s) que você vê talvez não faça(m) sentido. O relatório sempre usará sua moeda padrão.',
    'sum_in_default_currency'                   => 'A soma será sempre em sua moeda padrão.',
    'net_filtered_prefs'                        => 'Esse gráfico nunca irá incluir contas que têm a opção "incluir no patrimônio líquido" desmarcada.',


    // charts:
    'chart'                                     => 'Gráfico',
    'month'                                     => 'Mês',
    'budget'                                    => 'Orçamento',
    'spent'                                     => 'Gasto',
    'spent_capped'                              => 'Despesa (limitada)',
    'spent_in_budget'                           => 'Gasto no orçamento',
    'left_to_spend'                             => 'Restante para gastar',
    'earned'                                    => 'Ganho',
    'overspent'                                 => 'Gasto excedido',
    'left'                                      => 'Restante',
    'max-amount'                                => 'Valor Máximo',
    'min-amount'                                => 'Valor mínimo',
    'journal-amount'                            => 'Entrada atual da assinatura',
    'name'                                      => 'Nome',
    'expires_at'                                => 'Expira em',
    'date'                                      => 'Data',
    'date_and_time'                             => 'Data e hora',
    'time'                                      => 'Horário',
    'paid'                                      => 'Pago',
    'unpaid'                                    => 'Não pago',
    'day'                                       => 'Dia',
    'budgeted'                                  => 'Orçado',
    'period'                                    => 'Período',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'Entrada + Saída deste período',
    'sum'                                       => 'Soma',
    'summary'                                   => 'Resumo',
    'average'                                   => 'Média',
    'balanceFor'                                => 'Saldo para ":name"',
    'no_tags'                                   => '(no tags)',
    'nothing_found'                             => '(nada encontrado)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Configurações da página',
    'visible_columns'               => 'Colunas visíveis',
    'accounts_to_show'              => 'Contas para exibir',
    'active_accounts_only'          => 'Apenas contas ativas',
    'in_active_accounts_only'       => 'Apenas contas inativas',
    'show_all_accounts'             => 'Mostrar todas as contas',
    'group_accounts'                => 'Contas de grupo',

    // piggy banks:
    'event_history'                 => 'Histórico do evento',
    'add_money_to_piggy'            => 'Adicionar dinheiro ao cofrinho ":name"',
    'piggy_bank'                    => 'Cofrinho',
    'new_piggy_bank'                => 'Novo cofrinho',
    'store_piggy_bank'              => 'Armazenar novo cofrinho',
    'stored_piggy_bank'             => 'Armazenar novo cofrinho ":name"',
    'account_status'                => 'Status da Conta',
    'left_for_piggy_banks'          => 'Restante para cofrinhos',
    'sum_of_piggy_banks'            => 'Soma dos cofrinhos',
    'saved_so_far'                  => 'Poupado até agora',
    'saved_so_far_total'            => 'Salvos até agora no total',
    'reset_history'                 => 'redefinir histórico',
    'reset_history_confirm'         => 'Tem certeza de que deseja redefinir o histórico deste cofrinho? Isso fará com que o gráfico corresponda ao valor do cofrinho novamente.',
    'piggy_history_reset'           => 'O histórico do cofrinho foi redefinido',
    'left_to_save'                  => 'Restante para poupar',
    'suggested_amount'              => 'Quantia mensal sugerida para poupar',
    'add_money_to_piggy_title'      => 'Adicionar dinheiro ao cofrinho ":name"',
    'remove_money_from_piggy_title' => 'Retire o dinheiro do cofrinho ":name"',
    'add'                           => 'Adicionar',
    'no_money_for_piggy'            => 'Você não tem dinheiro para colocar nesse cofrinho.',
    'suggested_savings_per_month'   => 'Sugerido por mês',

    'remove'                    => 'Remover',
    'max_amount_add'            => 'É a quantidade máxima que você pode adicionar é',
    'max_amount_remove'         => 'É a quantidade máxima que você pode remover é',
    'update_piggy_button'       => 'Atualizar cofrinho',
    'update_piggy_title'        => 'Atualizar cofrinho ":name"',
    'updated_piggy_bank'        => 'Cofrinho ":name" atualizado',
    'details'                   => 'Detalhes',
    'events'                    => 'Eventos',
    'target_amount'             => 'Valor alvo',
    'start_date'                => 'Data de Início',
    'no_start_date'             => 'Sem data de início',
    'target_date'               => 'Data Alvo',
    'no_target_date'            => 'Nenhum data',
    'table'                     => 'Tabela',
    'delete_piggy_bank'         => 'Apagar cofrinho ":name"',
    'cannot_add_amount_piggy'   => 'Não foi possível adicionar :amount a ":name".',
    'cannot_remove_from_piggy'  => 'Não foi possível remover :amount de ":name".',
    'deleted_piggy_bank'        => 'Cofrinho ":name" excluído',
    'added_amount_to_piggy'     => 'Adicionado :amount em ":name"',
    'removed_amount_from_piggy' => 'Removido :amount de ":name"',
    'piggy_events'              => 'Relacionado ao cofrinho',

    // tags
    'delete_tag'                => 'Apagar tag ":tag"',
    'deleted_tag'               => 'Tag ":tag" excluída',
    'new_tag'                   => 'Fazer nova tag',
    'edit_tag'                  => 'Editar tag ":tag"',
    'updated_tag'               => 'Tag atualizada ":tag"',
    'created_tag'               => 'Tag ":tag" foi criada!',

    'transaction_journal_information'               => 'Informação da transação',
    'transaction_journal_amount'                    => 'Informação da quantidade',
    'transaction_journal_meta'                      => 'Meta-informação',
    'transaction_journal_more'                      => 'Mais informações',
    'basic_journal_information'                     => 'Informações básicas de transação',
    'transaction_journal_extra'                     => 'Informação extra',
    'att_part_of_journal'                           => 'Armazendo sob ":journal"',
    'total_amount'                                  => 'Valor total',
    'number_of_decimals'                            => 'Número de casas decimais',


    // administration
    'invite_is_already_redeemed'                    => 'O convite para ":address" já foi resgatado.',
    'invite_is_deleted'                             => 'O convite para ":address" foi removido.',
    'invite_new_user_title'                         => 'Convidar novo usuário',
    'invite_new_user_text'                          => 'Como administrador, você pode convidar usuários para se registrarem em sua instalação do Firefly III. Usando o link direto que você pode compartilhar com eles, eles serão capazes de registrar uma conta. O usuário convidado e seu link de convite aparecerão na tabela abaixo. Você é livre para compartilhar com eles o link do convite.',
    'invited_user_mail'                             => 'E-mail',
    'invite_user'                                   => 'Convidar usuário',
    'user_is_invited'                               => 'O e-mail ":address" foi convidado para Firefly III',
    'administration'                                => 'Administração',
    'system_settings'                               => 'Configurações do sistema',
    'code_already_used'                             => 'O código de convite foi utilizado',
    'user_administration'                           => 'Administração de usuários',
    'list_all_users'                                => 'Todos os usuários',
    'all_users'                                     => 'Todos os usuários',
    'instance_configuration'                        => 'Configuração',
    'firefly_instance_configuration'                => 'Configuração do Firefly III',
    'setting_single_user_mode'                      => 'Modo de usuário único',
    'setting_single_user_mode_explain'              => 'Por padrão, o Firefly III aceita apenas um (1) usuário registrado: você. Esta é uma medida de segurança para impedir que outros usem sua instância a menos que você os permita. Os registros futuros estão bloqueados. Quando você desmarca esta opção, outros podem usar sua instância se puderem acessá-la (quando ela está conectada à Internet).',
    'store_configuration'                           => 'Salvar configuração',
    'single_user_administration'                    => 'Administração de usuários para :email',
    'edit_user'                                     => 'Editar usuário :email',
    'hidden_fields_preferences'                     => 'Você pode habilitar mais opções de transação em suas <a href="preferences">preferências</a>.',
    'user_data_information'                         => 'Dados de usuário',
    'user_information'                              => 'Informações do usuário',
    'total_size'                                    => 'tamanho total',
    'budget_or_budgets'                             => ':count orçamento|:count orçamentos',
    'budgets_with_limits'                           => ':count orçamento com valor configurado|:count orçamentos com valor configurado',
    'nr_of_rules_in_total_groups'                   => ':count_rules regra (s) em :count_groups grupo(s) de regras',
    'tag_or_tags'                                   => ':count tag|:count tags',
    'configuration_updated'                         => 'A configuração foi atualizada',
    'setting_is_demo_site'                          => 'Site demo',
    'setting_is_demo_site_explain'                  => 'Se você marcar esta caixa, esta instância vai se comportar como se fosse o site de demonstração, o que pode ter efeitos colaterais estranhos.',
    'block_code_bounced'                            => 'Mensagem(s) de email devolvidas',
    'block_code_expired'                            => 'Conta de demonstração expirada',
    'no_block_code'                                 => 'Nenhuma razão para o bloqueio ou o usuário não está bloqueado',
    'demo_user_export'                              => 'O usuário de demonstração não pode exportar dados',
    'block_code_email_changed'                      => 'O usuário ainda não confirmou o novo endereço de e-mail',
    'admin_update_email'                            => 'Ao contrário da página de perfil, o usuário NÃO será notificado de que seu endereço de e-mail mudou!',
    'update_user'                                   => 'Atualizar usuário',
    'updated_user'                                  => 'Os dados do usuário foram alterados.',
    'delete_user'                                   => 'Excluir usuário :email',
    'user_deleted'                                  => 'O usuário foi apagado',
    'send_test_email'                               => 'Enviar e-mail de teste',
    'send_test_email_text'                          => 'Para ver se sua instalação é capaz de enviar uma notificação, por favor pressione este botão. Você não verá um erro aqui (se houver), <strong>os arquivos de log refletirão quaisquer erros</strong>. Você pode pressionar este botão quantas vezes quiser. Não há controle de spam. A mensagem será enviada para <code>:email</code> e deverá chegar em breve.',
    'send_message'                                  => 'Enviar mensagem',
    'send_test_triggered'                           => 'O teste foi desencadeado. Verifique a sua caixa de entrada e os arquivos de log.',
    'give_admin_careful'                            => 'Os usuários que obtiverem direitos de administrador podem retirar os seus. Tenha cuidado.',
    'admin_maintanance_title'                       => 'Manutenção',
    'admin_maintanance_expl'                        => 'Alguns botões úteis para a manutenção do Firefly III',
    'admin_maintenance_clear_cache'                 => 'Limpar o cache',
    'owner_notifications'                           => 'Notificações do Administrador',
    'owner_notifications_expl'                      => 'As seguintes notificações podem ser ativadas ou desativadas pelo administrador. Elas serão enviadas em TODOS os canais configurados. Alguns canais são configurados em suas variáveis de ambiente, outros podem ser definidos aqui.',
    'channel_settings'                              => 'Configurações para canais de notificação',
    'notification_test_failed'                      => 'Teste de notificação para o canal ":channel" falhou. Os logs terão mais detalhes.',
    'notification_test_executed'                    => 'Teste de notificação para o canal ":channel" executada. Os logs terão mais detalhes.',
    'settings_notifications'                        => 'Configurações para notificações',
    'title_owner_notifications'                     => 'Notificações do proprietário',
    'owner_notification_check_user_new_reg'         => 'Usuário recebe mensagem de boas-vindas pós-registro',
    'owner_notification_check_admin_new_reg'        => 'Administrador(es) recebem uma notificação de registro de novo usuário',
    'owner_notification_check_new_version'          => 'Uma nova versão está disponível',
    'owner_notification_check_invite_created'       => 'Um usuário foi convidado para Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Um convite de usuário foi resgatado',
    'owner_notification_check_unknown_user_attempt' => 'Um usuário desconhecido tentou fazer login',
    'all_invited_users'                             => 'Todos os usuários convidados',
    'save_notification_settings'                    => 'Salvar configurações',
    'notification_settings'                         => 'Configurações para notificações',
    'notification_settings_saved'                   => 'As configurações de notificação foram salvas',
    'available_channels_title'                      => 'Canais disponíveis',
    'available_channels_expl'                       => 'Estes canais estão disponíveis para enviar notificações. Para testar sua configuração, use os botões abaixo. Por favor, note que os botões não têm controle de spam.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'O canal de notificação do Slack também pode enviar notificações para o Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'não disponível',
    'configure_channel_in_env'                      => 'precisa de variáveis de ambiente',
    'test_notification_channel_name_email'          => 'Testar e-mail',
    'test_notification_channel_name_slack'          => 'Testar Slack',
    'test_notification_channel_name_ntfy'           => 'Testar Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Testar Pushover',
    'test_notification_channel_name_gotify'         => 'Testar Gotify',
    'test_notification_channel_name_pushbullet'     => 'Testar Pushbullet',

    'split_transaction_title'               => 'Descrição da transação dividida',
    'split_transaction_title_help'          => 'Se você criar uma transação dividida, deve haver uma descrição global para todas as partes da transação.',
    'split_title_help'                      => 'Se você criar uma transação dividida, é necessário haver uma descrição global para todas as partes da transação.',
    'you_create_transfer'                   => 'Você está criando uma transferência.',
    'you_create_withdrawal'                 => 'Você está criando uma saída.',
    'you_create_deposit'                    => 'Você está criando uma entrada.',

    // links
    'journal_link_configuration'            => 'Configuração de vínculos de transações',
    'create_new_link_type'                  => 'Crie um novo tipo de vínculo',
    'store_new_link_type'                   => 'Armazene novo tipo de vínculo',
    'update_link_type'                      => 'Atualize o tipo de vínculo',
    'edit_link_type'                        => 'Editar tipo de vínculo ":name"',
    'updated_link_type'                     => 'Tipo de vínculo ":name" atualizado',
    'delete_link_type'                      => 'Excluir tipo de vínculo ":name"',
    'deleted_link_type'                     => 'Tipo de vínculo ":name" excluído',
    'stored_new_link_type'                  => 'Armazene novo tipo de vínculo ":name"',
    'cannot_edit_link_type'                 => 'Não é possível editar o tipo de vínculo ":name"',
    'link_type_help_name'                   => 'Ou seja. "Duplicatas"',
    'link_type_help_inward'                 => 'Ou seja. "duplicatas"',
    'link_type_help_outward'                => 'Ou seja. "é duplicado por"',
    'save_connections_by_moving'            => 'Salve o vínculo entre essas transações movendo-as para outro tipo de vínculo:',
    'do_not_save_connection'                => '(não salve a conexão)',
    'link_transaction'                      => 'Vincular transação',
    'link_to_other_transaction'             => 'Vincule esta transação a outra transação',
    'select_transaction_to_link'            => 'Selecione uma transação para vincular com esta transação. Atualmente, os vínculos não são usados no Firefly III (além de serem exibidos), mas planejo mudar isso no futuro. Use a caixa de pesquisa para selecionar uma transação por título ou por ID. Se você quiser adicionar tipos de vínculo personalizados, confira as configurações.',
    'this_transaction'                      => 'Esta transação',
    'transaction'                           => 'Transação',
    'comments'                              => 'Comentários',
    'link_notes'                            => 'Quaisquer notas que você deseja armazenar com o link.',
    'invalid_link_selection'                => 'Não é possível vincular essas transações',
    'selected_transaction'                  => 'Transação selecionada',
    'journals_linked'                       => 'As transações estão vinculadas.',
    'journals_error_linked'                 => 'Essas transações já estão vinculadas.',
    'journals_link_to_self'                 => 'Você não pode vincular uma transação a ela mesma',
    'journal_links'                         => 'Transações vinculadas',
    'this_withdrawal'                       => 'Esta saída',
    'this_deposit'                          => 'Esta entrada',
    'this_transfer'                         => 'Esta transferência',
    'overview_for_link'                     => 'Visão geral para o tipo de vínculo ":name"',
    'source_transaction'                    => 'Transação de origem',
    'link_description'                      => 'Descrição do vínculo',
    'destination_transaction'               => 'Transação de destino',
    'delete_journal_link'                   => 'Excluir o vínculo entre <a href=":source_link">:source</a> e <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Vínculo excluído',

    // link translations:
    'Paid_name'                             => 'Pago',
    'Refund_name'                           => 'Devolução',
    'Reimbursement_name'                    => 'Reembolso',
    'Related_name'                          => 'Relacionado',
    'relates to_inward'                     => 'relacionado a',
    'is (partially) refunded by_inward'     => 'é (parcialmente) devolvido por',
    'is (partially) paid for by_inward'     => 'é (parcialmente) pago por',
    'is (partially) reimbursed by_inward'   => 'é (parcialmente) reembolsado por',
    'inward_transaction'                    => 'Transação interna',
    'outward_transaction'                   => 'Transação externa',
    'relates to_outward'                    => 'relacionado a',
    '(partially) refunds_outward'           => 'devolve (parcialmente)',
    '(partially) pays for_outward'          => 'paga (parcialmente) por',
    '(partially) reimburses_outward'        => 'reembolsa (parcialmente)',
    'is (partially) refunded by'            => 'foi (parcialmente) devolvido por',
    'is (partially) paid for by'            => 'foi (parcialmente) pago por',
    'is (partially) reimbursed by'          => 'foi (parcialmente) reembolsado por',
    'relates to'                            => 'relacionado a',
    '(partially) refunds'                   => '(parcialmente) devolve',
    '(partially) pays for'                  => 'paga (parcialmente)',
    '(partially) reimburses'                => '(parcialmente) reembolsa',

    // split a transaction:
    'splits'                                => 'Divisões',
    'add_another_split'                     => 'Adicionar outra divisão',
    'cannot_edit_opening_balance'           => 'Não é possível editar o saldo de abertura de uma conta.',
    'no_edit_multiple_left'                 => 'Você não selecionou nenhuma transação válida para editar.',
    'breadcrumb_convert_group'              => 'Converter transação',
    'convert_invalid_source'                => 'As informações de origem são inválidas para transações #%d.',
    'convert_invalid_destination'           => 'As informações de destino são inválidas para transações #%d.',
    'create_another'                        => 'Depois de armazenar, retorne aqui para criar outro.',
    'after_update_create_another'           => 'Depois de atualizar, retorne aqui para continuar editando.',
    'store_as_new'                          => 'Armazene como uma nova transação em vez de atualizar.',
    'reset_after'                           => 'Limpar o formulário após o envio',
    'errors_submission'                     => 'Algo deu errado com seu envio. Por favor, verifique os erros abaixo.',
    'errors_submission_v2'                  => 'Algo deu errado com seu envio. Por favor, verifique os erros abaixo: {{errorMessage}}',
    'transaction_expand_split'              => 'Exibir divisão',
    'transaction_remove_split'              => 'Remover divisão',
    'transaction_collapse_split'            => 'Esconder divisão',

    // object groups
    'default_group_title_name'              => '(não agrupado)',
    'default_group_title_name_plain'        => 'sem grupo',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Vamos criar uma conta de ativos!',
    'no_accounts_intro_asset'               => 'Ainda não possui contas de ativos. As contas de ativos são suas principais contas: sua conta corrente, conta poupança, conta compartilhada ou mesmo seu cartão de crédito.',
    'no_accounts_imperative_asset'          => 'Para começar a usar o Firefly III, você deve criar pelo menos uma conta de ativos. Vamos fazer agora:',
    'no_accounts_create_asset'              => 'Criar uma conta de ativo',
    'no_accounts_title_expense'             => 'Vamos criar uma conta de despesas!',
    'no_accounts_intro_expense'             => 'Você ainda não possui contas de despesas. As contas de despesas são os lugares onde você gasta dinheiro, como lojas e supermercados.',
    'no_accounts_imperative_expense'        => 'As contas de despesas são criadas automaticamente quando você cria transações, mas você também pode criar uma manualmente, se desejar. Vamos criar uma agora:',
    'no_accounts_create_expense'            => 'Criar uma conta de despesas',
    'no_accounts_title_revenue'             => 'Vamos criar uma conta de receita!',
    'no_accounts_intro_revenue'             => 'Você ainda não possui contas de receita. As contas de receita são os locais onde você recebe dinheiro, como o seu empregador.',
    'no_accounts_imperative_revenue'        => 'As contas de receita são criadas automaticamente quando você cria transações, mas você também pode criar uma manualmente, se desejar. Vamos criar um agora:',
    'no_accounts_create_revenue'            => 'Criar uma conta de receita',
    'no_accounts_title_liabilities'         => 'Vamos criar um passivo!',
    'no_accounts_intro_liabilities'         => 'Você ainda não tem nenhum passivo. Essas contas registram seus empréstimos e outras dívidas.',
    'no_accounts_imperative_liabilities'    => 'Você não precisa usar esse recurso, mas pode ser útil se você quer controlar esse tipo de coisas.',
    'no_accounts_create_liabilities'        => 'Criar um passivo',
    'no_budgets_title_default'              => 'Vamos criar um orçamento',
    'no_rules_title_default'                => 'Vamos criar uma regra',
    'no_budgets_intro_default'              => 'Você ainda não tem nenhum orçamento. Eles são utilizados para organizar suas despesas em grupos lógicos, que você pode aplicar para limitar suas despesas.',
    'no_rules_intro_default'                => 'Você ainda não tem regras. As regras são poderosas automações que podem gerenciar transações para você.',
    'no_rules_imperative_default'           => 'As regras podem ser muito úteis quando você está gerenciando transações. Vamos criar uma agora:',
    'no_budgets_imperative_default'         => 'Os orçamentos são as ferramentas básicas de gestão financeira. Vamos criar um agora:',
    'no_budgets_create_default'             => 'Criar orçamento',
    'no_rules_create_default'               => 'Criar uma regra',
    'no_categories_title_default'           => 'Vamos criar uma categoria!',
    'no_categories_intro_default'           => 'Você ainda não possui categorias. As categorias são usadas para ajustar suas transações e rotulá-las com a categoria designada.',
    'no_categories_imperative_default'      => 'As categorias são criadas automaticamente quando você cria transações, mas você também pode criar uma manualmente. Vamos criar uma agora:',
    'no_categories_create_default'          => 'Criar uma categoria',
    'no_tags_title_default'                 => 'Vamos criar uma tag!',
    'no_tags_intro_default'                 => 'Ainda não possui tags. As tags são usadas para ajustar suas transações e rotulá-las com palavras-chave específicas.',
    'no_tags_imperative_default'            => 'As tags são criadas automaticamente quando você cria transações, mas você também pode criar uma manualmente. Vamos criar uma agora:',
    'no_tags_create_default'                => 'Criar uma tag',
    'no_transactions_title_withdrawal'      => 'Vamos criar uma despesa!',
    'no_transactions_intro_withdrawal'      => 'Ainda não tem despesas. Você deve criar despesas para começar a gerenciar suas finanças.',
    'no_transactions_imperative_withdrawal' => 'Você gastou algum dinheiro? Então você deve anotá-lo:',
    'no_transactions_create_withdrawal'     => 'Crie uma despesa',
    'no_transactions_title_deposit'         => 'Vamos criar alguma renda!',
    'no_transactions_intro_deposit'         => 'Você não tem nenhuma renda registrada ainda. Você deve criar entradas de renda para começar a gerenciar suas finanças.',
    'no_transactions_imperative_deposit'    => 'Você recebeu algum dinheiro? Então você deve anotá-lo:',
    'no_transactions_create_deposit'        => 'Criar uma entrada',
    'no_transactions_title_transfers'       => 'Vamos criar uma transferência!',
    'no_transactions_intro_transfers'       => 'Você ainda não tem transferências. Quando você move dinheiro entre contas ativas, ele é registrado como uma transferência.',
    'no_transactions_imperative_transfers'  => 'Você moveu algum dinheiro? Então você deve anotá-lo:',
    'no_transactions_create_transfers'      => 'Criar uma transferência',
    'no_piggies_title_default'              => 'Vamos criar um cofrinho!',
    'no_piggies_intro_default'              => 'Você ainda não tem cofrinhos. Você pode criar cofrinhos para dividir suas economias e acompanhar para o que você está economizando.',
    'no_piggies_imperative_default'         => 'Você tem coisas para as quais você está economizando? Crie um cofrinho e acompanhe:',
    'no_piggies_create_default'             => 'Criar um novo cofrinho',
    'no_bills_title_default'                => 'Vamos criar uma assinatura!',
    'no_bills_intro_default'                => 'Você ainda não possui assinaturas. Você pode criar assinaturas para acompanhar as despesas regulares, como sua renda ou seguro.',
    'no_bills_imperative_default'           => 'Você tem esse tipo de assinatura regularmente? Crie uma assinatura e acompanhe seus pagamentos:',
    'no_bills_create_default'               => 'Criar uma assinatura',

    // recurring transactions
    'recurrence_max_count'                  => 'Estas transações recorrentes serão criadas no máximo :max vez(es), e já foram criadas :count vez(es).',
    'create_right_now'                      => 'Criar agora mesmo',
    'no_new_transaction_in_recurrence'      => 'Nenhuma transação nova foi criada. Talvez já tenha sido disparada nesta data?',
    'recurrences'                           => 'Transações recorrentes',
    'repeat_until_in_past'                  => 'Esta transação recorrente parou de repetir em :date.',
    'recurring_calendar_view'               => 'Calendário',
    'no_recurring_title_default'            => 'Vamos criar uma transação recorrente!',
    'no_recurring_intro_default'            => 'Você ainda não tem nenhuma transação recorrente. Você pode usá-las para que o Firefly III crie transações para você automaticamente.',
    'no_recurring_imperative_default'       => 'Essa é uma função bastante avançada, mas pode ser muito útil. Leia a documentação (ícone (?) no canto superior direito) antes de continuar.',
    'no_recurring_create_default'           => 'Criar transação recorrente',
    'make_new_recurring'                    => 'Criar transação recorrente',
    'recurring_daily'                       => 'Todos os dias',
    'recurring_weekly'                      => ':weekday toda semana',
    'recurring_weekly_skip'                 => 'A cada :skipª semana em :weekday',
    'recurring_monthly'                     => 'Todos os meses no dia :dayOfMonth',
    'recurring_monthly_skip'                => 'A cada mês :skipº no dia :dayOfMonth',
    'recurring_ndom'                        => 'Todos os meses na(o) :dayOfMonth ª/º :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Todos os anos em :date',
    'overview_for_recurrence'               => 'Visão geral da transação recorrente ":title"',
    'warning_duplicates_repetitions'        => 'Em raras ocasiões, as datas aparecem duas vezes na lista. Isso pode acontecer quando várias repetições colidem. Firefly III sempre irá gerar uma transação por dia.',
    'created_transactions'                  => 'Transações relacionadas',
    'expected_withdrawals'                  => 'Saídas previstas',
    'expected_deposits'                     => 'Entradas esperadas',
    'expected_transfers'                    => 'Transferências previstas',
    'created_withdrawals'                   => 'Saídas criadas',
    'created_deposits'                      => 'Entradas criadas',
    'created_transfers'                     => 'Transferências criadas',
    'recurring_info'                        => 'Transação recorrente :count / :total',
    'created_from_recurrence'               => 'Criado a partir da transação recorrente ":title" (#:id)',
    'recurring_never_cron'                  => 'Parece que o cron job necessário para dar suporte a transações recorrentes nunca foi executado. Isso é normal quando você acabou de instalar o Firefly III, mas deve ser configurado o quanto antes. Por favor, veja as páginas de ajuda usando o ícone (?) no canto superior direito da página.',
    'recurring_cron_long_ago'               => 'Faz mais de 36 horas que o cron job que dá suporte a transações recorrentes foi acionado pela última vez. Tem certeza de que foi configurado corretamente? Por favor, veja as páginas de ajuda usando o ícone (?) no canto superior direito da página.',

    'create_new_recurrence'              => 'Criar nova transação recorrente',
    'help_first_date'                    => 'Indique a primeira recorrência esperada. Isso deve ser no futuro.',
    'help_first_date_no_past'            => 'Indique a primeira recorrência esperada. Firefly III não irá criar transações no passado.',
    'no_currency'                        => '(sem moeda)',
    'mandatory_for_recurring'            => 'Informações obrigatórias de recorrência',
    'mandatory_for_transaction'          => 'Informações obrigatórias de transação',
    'optional_for_recurring'             => 'Informações opcionais de recorrência',
    'optional_for_transaction'           => 'Informações opcionais de transação',
    'change_date_other_options'          => 'Mude a "primeira data" para ver mais opções.',
    'mandatory_fields_for_tranaction'    => 'Os valores aqui estarão na(s) transação(ões) criada(s)',
    'click_for_calendar'                 => 'Clique aqui para ver um calendário que mostra quando a transação se repetiria.',
    'repeat_forever'                     => 'Repetir para sempre',
    'repeat_until_date'                  => 'Repetir até uma data',
    'repeat_times'                       => 'Repetir uma quantidade de vezes',
    'recurring_skips_one'                => 'Intercalado',
    'recurring_skips_more'               => 'Pular :count ocorrências',
    'store_new_recurrence'               => 'Salvar transação recorrente',
    'stored_new_recurrence'              => 'Transação recorrente ":title" armazenada com sucesso.',
    'edit_recurrence'                    => 'Editar transação recorrente ":title"',
    'recurring_repeats_until'            => 'Repetir até :date',
    'recurring_repeats_forever'          => 'Repetir sempre',
    'recurring_repeats_x_times'          => 'Repetir :count vez|Repetir :count vezes',
    'update_recurrence'                  => 'Atualizar transação recorrente',
    'updated_recurrence'                 => 'Atualizar transação recorrente ":title"',
    'recurrence_is_inactive'             => 'Esta transação recorrente não está ativa e não gerará novas transações.',
    'delete_recurring'                   => 'Apagar transação recorrente ":title"',
    'new_recurring_transaction'          => 'Nova transação recorrente',
    'help_weekend'                       => 'O que o Firefly III deve fazer quando a transação recorrente cai em um sábado ou domingo?',
    'do_nothing'                         => 'Apenas criar a transação',
    'skip_transaction'                   => 'Pular a ocorrência',
    'jump_to_friday'                     => 'Criar a transação na sexta-feira anterior',
    'jump_to_monday'                     => 'Criar a transação na segunda-feira seguinte',
    'will_jump_friday'                   => 'Será criada na sexta-feira em vez de nos finais de semana.',
    'will_jump_monday'                   => 'Será criada na segunda-feira em vez de nos finais de semana.',
    'except_weekends'                    => 'Exceto nos fins de semana',
    'recurrence_deleted'                 => 'Transação recorrente ":title" excluída',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Gasto (:currency)',
    'box_earned_in_currency'             => 'Ganho (:currency)',
    'box_budgeted_in_currency'           => 'Orçado (:currency)',
    'box_bill_paid_in_currency'          => 'Assinaturas pagas (:currency)',
    'box_bill_unpaid_in_currency'        => 'Assinaturas não pagas (:currency)',
    'box_left_to_spend_in_currency'      => 'Restante para gastar (:currency)',
    'box_net_worth_in_currency'          => 'Patrimônio líquido (:currency)',
    'box_spend_per_day'                  => 'Restante para gastar por dia: :amount',

    // debug page
    'debug_page'                         => 'Página de depuração',
    'debug_submit_instructions'          => 'Se você estiver com problemas, você pode usar as informações nesta caixa como informações de depuração. Por favor, copie e cole em um issue existente ou nova <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub</a>. Gerará uma linda tabela que pode ser usada para diagnosticar rapidamente seu problema.',
    'debug_pretty_table'                 => 'Se você copiar/colar a caixa abaixo em uma issue no GitHub, ela irá gerar uma tabela. Por favor, não coloque este texto entre acentos agudos ou aspas.',
    'debug_additional_data'              => 'Você também pode compartilhar o conteúdo da caixa abaixo. Você também pode copiar e colar isso em uma issue nova ou existente do <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub</a>. No entanto, o conteúdo desta caixa pode conter informações privadas, como nomes de conta, detalhes da transação ou endereços de e-mail.',

    // object groups
    'object_groups_menu_bar'             => 'Grupos',
    'object_groups_page_title'           => 'Grupos',
    'object_groups_breadcrumb'           => 'Grupos',
    'object_groups_index'                => 'Visão geral',
    'object_groups'                      => 'Grupos',
    'object_groups_empty_explain'        => 'Algumas coisas no Firefly III podem ser divididas em grupos. Cofrinhos, por exemplo, apresentam um campo "Grupo" nas telas de edição e criação. Quando definir este campo, você pode editar os nomes e a ordem dos grupos nesta página. Para obter mais informações, confira as páginas de ajuda no canto superior direito, abaixo do ícone (?).',
    'object_group_title'                 => 'Título',
    'edit_object_group'                  => 'Editar grupo ":title"',
    'delete_object_group'                => 'Excluir grupo ":title"',
    'update_object_group'                => 'Atualizar grupo',
    'updated_object_group'               => 'O grupo ":title" foi atualizado com sucesso',
    'deleted_object_group'               => 'O grupo ":title" foi deletado com sucesso',
    'object_group'                       => 'Grupo',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Entradas do log de auditoria',
    'ale_action_log_add'                 => 'Adicionado :amount ao cofrinho ":name"',
    'ale_action_log_remove'              => 'Retirado :amount do cofrinho ":name"',
    'ale_action_clear_budget'            => 'Removido do orçamento',
    'ale_action_update_group_title'      => 'Título do grupo de transações atualizado',
    'ale_action_update_date'             => 'Data de transação atualizada',
    'ale_action_update_order'            => 'Ordem de transação atualizada',
    'ale_action_clear_category'          => 'Removido da categoria',
    'ale_action_clear_notes'             => 'Anotações removidas',
    'ale_action_clear_tag'               => 'Tags apagadas',
    'ale_action_clear_all_tags'          => 'Todas as tags foram apagadas',
    'ale_action_set_bill'                => 'Vinculado a assinatura',
    'ale_action_switch_accounts'         => 'Conta de origem e destino alternados',
    'ale_action_set_budget'              => 'Definir orçamento',
    'ale_action_set_category'            => 'Definir categoria',
    'ale_action_set_source'              => 'Definir conta de origem',
    'ale_action_set_destination'         => 'Definir conta de destino',
    'ale_action_update_transaction_type' => 'Tipo de transação alterado',
    'ale_action_update_notes'            => 'Anotações alteradas',
    'ale_action_update_description'      => 'Descrição alterada',
    'ale_action_add_to_piggy'            => 'Cofrinho',
    'ale_action_remove_from_piggy'       => 'Cofrinho',
    'ale_action_add_tag'                 => 'Tag adicionada',
    'ale_action_update_amount'           => 'Valor atualizado',

    // dashboard
    'enable_auto_convert'                => 'Habilitar conversão de moeda',
    'disable_auto_convert'               => 'Desativar conversão de moeda',
];
