<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'opgeslagen onder ":timezone"',
    'displayed_in_tz'                           => 'weergegeven in ":timezone"',
    'close'                                     => 'Sluiten',
    'actions'                                   => 'Acties',
    'edit'                                      => 'Wijzig',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transactiejournal-ID',
    'delete'                                    => 'Verwijder',
    'split'                                     => 'Splitsen',
    'single_split'                              => 'Split',
    'clone'                                     => 'Dupliceren',
    'clone_and_edit'                            => 'Dupliceren en wijzigen',
    'confirm_action'                            => 'Actie bevestigen',
    'last_seven_days'                           => 'Laatste zeven dagen',
    'last_thirty_days'                          => 'Laatste dertig dagen',
    'last_180_days'                             => 'Laatste 180 dagen',
    'month_to_date'                             => 'Maand tot nu',
    'year_to_date'                              => 'Jaar tot nu',
    'YTD'                                       => 'YTD',
    'welcome_back'                              => 'Hoe staat het er voor?',
    'main_dashboard_page_title'                 => 'Home',
    'everything'                                => 'Alles',
    'today'                                     => 'vandaag',
    'customRange'                               => 'Zelf bereik kiezen',
    'date_range'                                => 'Datumbereik',
    'apply'                                     => 'Go',
    'select_date'                               => 'Selecteer periode..',
    'cancel'                                    => 'Annuleren',
    'from'                                      => 'Van',
    'to'                                        => 'Tot',
    'structure'                                 => 'Structuur',
    'help_translating'                          => 'Deze helptekst is nog niet beschikbaar in het Nederlands. <a href="https://crowdin.com/project/firefly-iii-help">Help je mee vertalen?</a>',
    'showEverything'                            => 'Laat alles zien',
    'never'                                     => 'Nooit',
    'no_results_for_empty_search'               => 'Je zoekopdracht was leeg, dus niets werd gevonden.',
    'removed_amount'                            => ':amount weggehaald',
    'added_amount'                              => ':amount toegevoegd',
    'asset_account_role_help'                   => 'Voorkeuren die voortkomen uit je keuze hier kan je later aangeven.',
    'Opening balance'                           => 'Startsaldo',
    'create_new_stuff'                          => 'Nieuw',
    'new_withdrawal'                            => 'Nieuwe uitgave',
    'create_new_transaction'                    => 'Maak een nieuwe transactie',
    'sidebar_frontpage_create'                  => 'Maak',
    'new_transaction'                           => 'Nieuwe transactie',
    'no_rules_for_bill'                         => 'Dit abonnement heeft geen regels.',
    'go_to_asset_accounts'                      => 'Bekijk je betaalrekeningen',
    'go_to_budgets'                             => 'Ga naar je budgetten',
    'go_to_withdrawals'                         => 'Ga naar je uitgaven',
    'clones_journal_x'                          => 'Deze transactie is een kloon van ":description" (#:id)',
    'go_to_categories'                          => 'Ga naar je categorieën',
    'go_to_bills'                               => 'Ga naar je abonnementen',
    'go_to_expense_accounts'                    => 'Bekijk je crediteuren',
    'go_to_revenue_accounts'                    => 'Bekijk je debiteuren',
    'go_to_piggies'                             => 'Ga naar je spaarpotjes',
    'new_deposit'                               => 'Nieuwe inkomsten',
    'new_transfer'                              => 'Nieuwe overschrijving',
    'new_transfers'                             => 'Nieuwe overschrijving',
    'new_asset_account'                         => 'Nieuwe betaalrekening',
    'new_expense_account'                       => 'Nieuwe crediteur',
    'new_revenue_account'                       => 'Nieuwe debiteur',
    'new_liabilities_account'                   => 'Nieuwe passiva',
    'new_budget'                                => 'Nieuw budget',
    'new_bill'                                  => 'Nieuw abonnement',
    'block_account_logout'                      => 'Je bent helaas uitgelogd. Geblokkeerde accounts kunnen deze site niet gebruiken. Heb je een geldig e-mailadres gebruikt toen je je registreerde?',
    'flash_success'                             => 'Gelukt!',
    'flash_info'                                => 'Melding',
    'flash_warning'                             => 'Waarschuwing!',
    'flash_error'                               => 'Fout!',
    'flash_danger'                              => 'Gevaar!',
    'flash_info_multiple'                       => 'Er is één melding|Er zijn :count meldingen',
    'flash_error_multiple'                      => 'Er is één fout|Er zijn :count fouten',
    'net_worth'                                 => 'Kapitaal',
    'help_for_this_page'                        => 'Hulp bij deze pagina',
    'help_for_this_page_body'                   => 'Meer informatie over deze pagina <a href="https://docs.firefly-iii.org/">vind je in de documentatie</a>.',
    'two_factor_welcome'                        => 'Hallo!',
    'two_factor_enter_code'                     => 'Vul je authenticatiecode in. Je authenticatieapplicatie kan deze voor je genereren.',
    'two_factor_code_here'                      => 'Code',
    'two_factor_title'                          => 'Authenticatie in twee stappen',
    'authenticate'                              => 'Inloggen',
    'two_factor_forgot_title'                   => 'Authenticatie in twee stappen werkt niet meer',
    'two_factor_forgot'                         => 'Ik kan geen codes meer genereren.',
    'two_factor_lost_header'                    => 'Kan je geen codes meer genereren?',
    'two_factor_lost_intro'                     => 'Als je ook je backupcodes kwijt bent heb je pech gehad. Dit kan je niet via de web-interface fixen. Je kan kiezen.',
    'two_factor_lost_fix_self'                  => 'Als dit jouw Firefly III-installatie is, lees dan <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">deze entry in de FAQ</a>.',
    'two_factor_lost_fix_owner'                 => 'Zo niet, stuur dan een e-mail naar <a href="mailto::site_owner">:site_owner</a> en vraag of ze je authenticatie in twee stappen willen resetten.',
    'mfa_backup_code'                           => 'Je hebt een backupcode gebruikt om in te loggen op Firefly III. Deze kan je niet meer gebruiken dus streep hem weg.',
    'pref_two_factor_new_backup_codes'          => 'Nieuwe backupcodes genereren',
    'pref_two_factor_backup_code_count'         => 'Je hebt :count geldige backupcode.|Je hebt :count geldige backupcodes.',
    '2fa_i_have_them'                           => 'Ik heb ze opgeslagen!',
    'warning_much_data'                         => 'Het kan even duren voor :days dagen aan gegevens geladen zijn.',
    'registered'                                => 'Je bent geregistreerd!',
    'Default asset account'                     => 'Standaard betaalrekening',
    'no_budget_pointer'                         => 'Je hebt nog geen budgetten. Maak er een aantal op de <a href="budgets">budgetten</a>-pagina. Met budgetten kan je je uitgaven beter bijhouden.',
    'no_bill_pointer'                           => 'Je hebt nog geen abonnementen. Maak er een aantal op de <a href="subscriptions">abonnementenpagina</a>. Met abonnementen kan je uitgaven bijhouden.',
    'Savings account'                           => 'Spaarrekening',
    'Credit card'                               => 'Credit card',
    'source_accounts'                           => 'Bronrekening|Bronrekeningen',
    'destination_accounts'                      => 'Doelrekening|Doelrekeningen',
    'user_id_is'                                => 'Je gebruikersnummer is <strong>:user</strong>',
    'field_supports_markdown'                   => 'Dit veld ondersteunt <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdown</a>.',
    'need_more_help'                            => 'Als je meer hulp nodig hebt met Firefly III, <a href="https://github.com/firefly-iii/firefly-iii/issues">open dan een ticket op Github</a>.',
    'reenable_intro_text'                       => 'Je kan de <a href="#" id="reenableGuidance">introductie-popupjes</a> ook weer aan zetten.',
    'intro_boxes_after_refresh'                 => 'De introductie-popupjes komen tevoorschijn als je de pagina opnieuw laadt.',
    'show_all_no_filter'                        => 'Laat alle transacties zien, zonder te groeperen op datum.',
    'expenses_by_category'                      => 'Uitgaven per categorie',
    'expenses_by_budget'                        => 'Uitgaven per budget',
    'income_by_category'                        => 'Inkomsten per categorie',
    'expenses_by_asset_account'                 => 'Uitgaven per betaalrekening',
    'expenses_by_expense_account'               => 'Uitgaven per doelrekening',
    'cannot_redirect_to_account'                => 'Firefly III kan je niet naar de goede pagina doorsturen. Sorry!',
    'sum_of_expenses'                           => 'Som van uitgaven',
    'sum_of_income'                             => 'Som van inkomsten',
    'liabilities'                               => 'Passiva',
    'spent_in_specific_budget'                  => 'Uitgegeven in budget ":budget"',
    'spent_in_specific_double'                  => 'Uitgegeven van rekening ":account"',
    'earned_in_specific_double'                 => 'Verdiend op rekening ":account"',
    'source_account'                            => 'Bronrekening',
    'source_account_reconciliation'             => 'Je kan de bronrekening van een afstemming niet wijzigen.',
    'destination_account'                       => 'Doelrekening',
    'destination_account_reconciliation'        => 'Je kan de doelrekening van een afstemming niet wijzigen.',
    'sum_of_expenses_in_budget'                 => 'Totaal uitgegeven in budget ":budget"',
    'left_in_budget_limit'                      => 'Nog uit te geven volgens budgettering',
    'current_period'                            => 'Huidige periode',
    'show_the_current_period_and_overview'      => 'Bekijk de huidige periode en overzicht',
    'pref_languages_locale'                     => 'Als je hier een andere taal dan Engels hebt geselecteerd, zorg er dan voor dat je besturingssysteem ook in staat is om valuta, data en bedragen in die taal weer te geven.',
    'budget_in_period'                          => 'Alle transacties voor budget ":name" tussen :start en :end in :currency',
    'chart_budget_in_period'                    => 'Grafiek voor alle transacties voor budget ":name" tussen :start en :end in :currency',
    'chart_budget_in_period_only_currency'      => 'Het bedrag dat je het begroot is in :currency, dus deze grafiek laat alleen transacties in :currency zien.',
    'chart_account_in_period'                   => 'Grafiek voor alle transacties voor rekening ":name" (:balance) tussen :start en :end',
    'chart_category_in_period'                  => 'Grafiek voor alle transacties voor categorie ":name" tussen :start en :end',
    'chart_category_all'                        => 'Grafiek voor alle transacties voor categorie ":name"',
    'clone_withdrawal'                          => 'Kopieer deze uitgave',
    'clone_deposit'                             => 'Kopieer deze inkomsten',
    'clone_transfer'                            => 'Kopieer deze overschrijving',
    'multi_select_no_selection'                 => 'Niets geselecteerd',
    'multi_select_select_all'                   => 'Selecteer alles',
    'multi_select_n_selected'                   => 'geselecteerd',
    'multi_select_all_selected'                 => 'Alles geselecteerd',
    'multi_select_filter_placeholder'           => 'Vinden..',
    'intro_next_label'                          => 'Volgende',
    'intro_prev_label'                          => 'Vorige',
    'intro_skip_label'                          => 'Overslaan',
    'intro_done_label'                          => 'Klaar',
    'between_dates_breadcrumb'                  => 'Tussen :start en :end',
    'all_journals_without_budget'               => 'Alle transacties zonder budget',
    'journals_without_budget'                   => 'Transacties zonder budget',
    'all_journals_without_category'             => 'Alle transacties zonder categorie',
    'journals_without_category'                 => 'Transacties zonder categorie',
    'all_journals_for_account'                  => 'Alle transacties voor rekening :name',
    'chart_all_journals_for_account'            => 'Grafiek van alle transacties voor rekening :name',
    'journals_in_period_for_account'            => 'Alle transacties voor rekening :name tussen :start en :end',
    'journals_in_period_for_account_js'         => 'Alle transacties voor rekening {title} tussen {start} en {end}',
    'transferred'                               => 'Overgeschreven',
    'all_withdrawal'                            => 'Alle uitgaven',
    'all_transactions'                          => 'Alle transacties',
    'title_withdrawal_between'                  => 'Alle uitgaven tussen :start en :end',
    'all_deposit'                               => 'Alle inkomsten',
    'title_deposit_between'                     => 'Alle inkomsten tussen :start en :end',
    'all_transfers'                             => 'Alle overschrijvingen',
    'title_transfers_between'                   => 'Alle overschrijvingen tussen :start en :end',
    'all_transfer'                              => 'Alle overschrijvingen',
    'all_journals_for_tag'                      => 'Alle transacties voor tag ":tag"',
    'title_transfer_between'                    => 'Alle overschrijvingen tussen :start en :end',
    'all_journals_for_category'                 => 'Alle transacties in categorie :name',
    'all_journals_for_budget'                   => 'Alle transacties voor budget :name',
    'chart_all_journals_for_budget'             => 'Grafiek van alle transacties voor budget :name',
    'journals_in_period_for_category'           => 'Alle transacties in categorie :name tussen :start en :end',
    'journals_in_period_for_tag'                => 'Alle transacties voor tag :tag tussen :start en :end',
    'not_available_demo_user'                   => 'De functie die je probeert te gebruiken is niet beschikbaar voor gebruikers van de demo.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Bronbetaalrekening "@source_name" accepteert alleen overschrijvingen in @source_currency. Doelbetaalrekening "@dest_name" accepteert alleen overschrijvingen in @dest_currency. Je moet het juiste bedrag in beide valuta opgeven.',
    'transaction_data'                          => 'Transactiegegevens',
    'invalid_server_configuration'              => 'Ongeldige serverconfiguratie',
    'invalid_locale_settings'                   => 'Firefly III kan geldbedragen niet goed weergeven, omdat je server de vereiste software mist. Je kan lezen <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">hoe je die moet installeren</a>.',
    'quickswitch'                               => 'Quickswitch',
    'sign_in_to_start'                          => 'Login om te beginnen',
    'sign_in'                                   => 'Inloggen',
    'register_new_account'                      => 'Registreer een nieuw account',
    'forgot_my_password'                        => 'Ik ben mijn wachtwoord vergeten',
    'problems_with_input'                       => 'Er zijn wat problemen met je input.',
    'reset_password'                            => 'Je wachtwoord resetten',
    'button_reset_password'                     => 'Reset wachtwoord',
    'reset_button'                              => 'Reset',
    'want_to_login'                             => 'Ik wil inloggen',
    'login_page_title'                          => 'Inloggen bij Firefly III',
    'register_page_title'                       => 'Registreren bij Firefly III',
    'forgot_pw_page_title'                      => 'Je wachtwoord voor Firefly III vergeten',
    'reset_pw_page_title'                       => 'Reset je Firefly III wachtwoord',
    'cannot_reset_demo_user'                    => 'Je kan het wachtwoord van de demo-gebruiker niet resetten.',
    'no_att_demo_user'                          => 'De demo user kan niks uploaden.',
    'button_register'                           => 'Registreren',
    'authorization'                             => 'Toestemming',
    'active_bills_only'                         => 'alleen actieve abonnementen',
    'active_bills_only_total'                   => 'alle actieve abonnementen',
    'active_exp_bills_only'                     => 'actieve en verwachte abonnementen',
    'active_exp_bills_only_total'               => 'alleen actieve en verwachte abonnementen',
    'per_period_sum_1D'                         => 'Verwachte dagelijkse kosten',
    'per_period_sum_1W'                         => 'Verwachte wekelijkse kosten',
    'per_period_sum_1M'                         => 'Verwachte maandelijkse kosten',
    'per_period_sum_3M'                         => 'Verwachte kwartaalkosten',
    'per_period_sum_6M'                         => 'Verwachte half-jaarlijkse kosten',
    'per_period_sum_1Y'                         => 'Verwachte jaarlijkse kosten',
    'average_per_bill'                          => 'gemiddeld per abonnement',
    'expected_total'                            => 'verwacht totaal',
    'reconciliation_account_name'               => ':name afstemming (:currency)',
    'saved'                                     => 'Opgeslagen',
    'advanced_options'                          => 'Geavanceerde opties',
    'advanced_options_explain'                  => 'Sommige pagina\'s in Firefly III hebben geavanceerde opties verborgen achter deze knop. Voor deze pagina geldt dat niet, maar check zeker de andere pagina\'s!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III heeft gedetecteerd dat je transacties van voor het jaar 1970 hebt. Corrigeer deze transacties zo snel mogelijk.',
    'anonymous_warning_on'                      => 'For your privacy, all amounts are now displayed as "zero". Warning: text input boxes may still show the original amounts!',
    'anonymous_warning_off'                     => 'Amounts will be visible again. Please be mindful of your surroundings.',

    // Webhooks
    'webhooks'                                  => 'Webhooks',
    'webhooks_breadcrumb'                       => 'Webhooks',
    'webhooks_menu_disabled'                    => 'uitgeschakeld',
    'no_webhook_messages'                       => 'Er zijn geen webhook-berichten',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'Na het maken van een transactie',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'Na het updaten van een transactie',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'Na het verwijderen van een transactie',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transactiedetails',
    'webhook_response_ACCOUNTS'                 => 'Rekeningdetails',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspecteren',
    'create_new_webhook'                        => 'Maak nieuwe webhook',
    'webhooks_create_breadcrumb'                => 'Maak nieuwe webhook',
    'webhook_trigger_form_help'                 => 'Geef aan bij welke gebeurtenis de webhook afgaat',
    'webhook_response_form_help'                => 'Geef aan wat de webhook mee moet sturen.',
    'webhook_delivery_form_help'                => 'Geef aan welk dataformaat gebruikt moet worden.',
    'webhook_active_form_help'                  => 'De webhook moet actief zijn anders doet-ie het niet.',
    'stored_new_webhook'                        => 'Nieuw webhook ":title" opgeslagen',
    'delete_webhook'                            => 'Webhook verwijderen',
    'deleted_webhook'                           => 'Webhook ":title" verwijderd',
    'edit_webhook'                              => 'Webhook ":title" wijzigen',
    'updated_webhook'                           => 'Webhook ":title" bijgewerkt',
    'edit_webhook_js'                           => 'Webhook "{title}" wijzigen',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'De webhook is getriggerd op de aangegeven transactie. Het resultaat zie je zometeen.',
    'webhook_messages'                          => 'Webhook-bericht',
    'view_message'                              => 'Bekijk bericht',
    'view_attempts'                             => 'Bekijk mislukte pogingen',
    'message_content_title'                     => 'Inhoud van webhook-bericht',
    'message_content_help'                      => 'Dit is de inhoud van het bericht dat verzonden was (of niet) met behulp van deze webhook.',
    'attempt_content_title'                     => 'Webhookpogingen',
    'attempt_content_help'                      => 'Dit zijn alle mislukte pogingen van de webhook om data te versturen. Na een paar keer stopt Firefly III met proberen.',
    'no_attempts'                               => 'Er zijn geen mislukte pogingen. Lekker toch?',
    'webhook_attempt_at'                        => 'Poging op {moment}',
    'logs'                                      => 'Logboeken',
    'response'                                  => 'Reactie',
    'visit_webhook_url'                         => 'Bezoek URL van webhook',
    'reset_webhook_secret'                      => 'Reset webhook-geheim',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ({title})</a> is opgeslagen.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID} ({title})</a> is geüpdatet.',

    // API access
    'authorization_request'                     => 'Firefly III v:version autorisatieverzoek',
    'authorization_request_intro'               => 'Applicatie "<strong>:client</strong>" vraagt ​​toestemming om toegang te krijgen tot je financiële administratie. Wil je <strong>:client</strong> autoriseren om toegang te krijgen tot je gegevens?',
    'authorization_request_site'                => 'Je wordt doorgestuurd naar <code>:url</code>, die vervolgens toegang heeft tot je Firefly III-gegevens.',
    'authorization_request_invalid'             => 'Dit toegangsverzoek is ongeldig. Volg deze link niet meer.',
    'scopes_will_be_able'                       => 'Deze applicatie krijgt toegang tot:',
    'button_authorize'                          => 'Toestaan',
    'none_in_select_list'                       => '(geen)',
    'no_piggy_bank'                             => '(geen spaarpotje)',
    'name_in_currency'                          => ':name in :currency',
    'paid_in_currency'                          => 'Betaald in :currency',
    'unpaid_in_currency'                        => 'Nog niet betaald in :currency',
    'is_alpha_warning'                          => 'Je gebruikt een ALPHA versie. Let op bugs en fouten.',
    'is_beta_warning'                           => 'Je gebruikt een BETA versie. Let op bugs en fouten.',
    'all_destination_accounts'                  => 'Doelrekeningen',
    'all_source_accounts'                       => 'Bronrekeningen',
    'back_to_index'                             => 'Terug naar de index',
    'cant_logout_guard'                         => 'Firefly III kan je niet uitloggen.',
    'internal_reference'                        => 'Interne referentie',

    // check for updates:
    'update_check_title'                        => 'Op updates controleren',
    'admin_update_check_title'                  => 'Controleer automatisch op updates',
    'admin_update_check_explain'                => 'Firefly III kan automatisch op updates controleren. Wanneer je deze instelling inschakelt, neemt Firefly III contact op met de update-server om te kijken of er een nieuwe versie van Firefly III beschikbaar is. Wanneer dit het geval is, ontvang je een melding. Je kan deze melding testen met de knop aan de rechterkant. Geef hieronder aan of je Firefly III wilt laten controleren op updates.',
    'check_for_updates_permission'              => 'Firefly III kan controleren op updates, maar heeft hiervoor je toestemming nodig. Ga naar <a href=":link">de instellingen</a> om aan te geven of deze functie moet worden ingeschakeld.',
    'updates_ask_me_later'                      => 'Later vragen',
    'updates_do_not_check'                      => 'Niet controleren op nieuwe versies',
    'updates_enable_check'                      => 'Controleren op nieuwe versies',
    'admin_update_check_now_title'              => 'Op updates controleren',
    'admin_update_check_now_explain'            => 'Als je op de knop drukt, kijkt Firefly III of je huidige versie de nieuwste is.',
    'check_for_updates_button'                  => 'Controleer nu!',
    'update_new_version_alert'                  => 'Er is een nieuwe versie van Firefly III beschikbaar. Je gebruikt :your_version, de nieuwste versie is :new_version die werd uitgebracht op :date.',
    'update_version_beta'                       => 'Dit is een BETA versie. Er kunnen bugs in zitten.',
    'update_version_alpha'                      => 'Dit is een ALPHA versie. Er kunnen bugs in zitten.',
    'update_current_dev_older'                  => 'Je gebruikt ontwikkelversie ":version", die ouder is dan de nieuwste versie :new_version. Doe een update!',
    'update_current_dev_newer'                  => 'Je gebruikt de ontwikkelversie ":version", die nieuwer is dan de nieuwste versie :new_version.',
    'update_current_version_alert'              => 'Je gebruikt :version, de nieuwste beschikbare versie.',
    'update_newer_version_alert'                => 'Je gebruikt :your_version, wat nieuwer is dan de nieuwste versie, :new_version.',
    'update_check_error'                        => 'Er is een fout opgetreden bij het controleren op updates: :error',
    'unknown_error'                             => 'Onbekende fout. Sorry.',
    'disabled_but_check'                        => 'Je hebt de update-controle uitgeschakeld. Vergeet dus niet zo nu en dan zelf te controleren op updates. Bedankt!',
    'admin_update_channel_title'                => 'Updatekanaal',
    'admin_update_channel_explain'              => 'Firefly III heeft drie "kanalen" die bepalen of en hoever je voorloopt als het gaat om features, wijzigingen en bugs. Gebruik het "beta"-kanaal als je een avontuurlijke bui hebt en gebruik het "alpha" kanaal als je ook graag met krokodillen zwemt.',
    'update_channel_stable'                     => 'Stabiel. Zou allemaal goed moeten gaan.',
    'update_channel_beta'                       => 'Beta. Nieuwe dingen, maar die kunnen stuk zijn.',
    'update_channel_alpha'                      => 'Alpha. We doen maar wat en jij mag testen.',

    // search
    'search'                                    => 'Zoeken',
    'search_query'                              => 'Zoekopdracht',
    'search_found_transactions'                 => 'Firefly III vond :count transactie in :time seconden.|Firefly III vond :count transacties in :time seconden.',
    'search_found_more_transactions'            => 'Firefly III vond meer dan :count transacties in :time seconden.',
    'search_for_overview'                       => 'Firefly III zoekt naar transacties die aan <b>al</b> deze voorwaarden voldoen:',
    'search_for_query'                          => 'Al deze woorden moeten aanwezig zijn: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'Geen van deze woorden mogen aanwezig zijn: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'De volgende zoekparameters zijn niet geldig en worden genegeerd.',

    // old


    'search_modifier_date_on'                             => 'Transactiedatum is ":value"',
    'search_modifier_not_date_on'                         => 'Transactiedatum is niet ":value"',
    'search_modifier_reconciled'                          => 'Transactie is afgestemd',
    'search_modifier_not_reconciled'                      => 'Transactie is niet afgestemd',
    'search_modifier_id'                                  => 'Transactie ID is ":value"',
    'search_modifier_not_id'                              => 'Transactie-ID is niet ":value"',
    'search_modifier_date_before'                         => 'Transactiedatum is vóór of op ":value"',
    'search_modifier_date_after'                          => 'Transactiedatum is na of op ":value"',
    'search_modifier_external_id_is'                      => 'Externe ID is ":value"',
    'search_modifier_not_external_id_is'                  => 'Externe ID is niet ":value"',
    'search_modifier_no_external_url'                     => 'De transactie heeft geen externe URL',
    'search_modifier_no_external_id'                      => 'De transactie heeft geen extern ID',
    'search_modifier_not_any_external_url'                => 'De transactie heeft geen externe URL',
    'search_modifier_not_any_external_id'                 => 'De transactie heeft geen extern ID',
    'search_modifier_any_external_url'                    => 'De transactie heeft een (welke dan ook) externe URL',
    'search_modifier_any_external_id'                     => 'De transactie heeft een (welke dan ook) extern ID',
    'search_modifier_not_no_external_url'                 => 'De transactie heeft een (welke dan ook) externe URL',
    'search_modifier_not_no_external_id'                  => 'De transactie heeft een (welke dan ook) extern ID',
    'search_modifier_internal_reference_is'               => 'Interne referentie is ":value"',
    'search_modifier_not_internal_reference_is'           => 'Interne referentie is niet ":value"',
    'search_modifier_description_starts'                  => 'Omschrijving begint met ":value"',
    'search_modifier_not_description_starts'              => 'Omschrijving begint niet met ":value"',
    'search_modifier_description_ends'                    => 'Omschrijving eindigt op ":value"',
    'search_modifier_not_description_ends'                => 'Omschrijving eindigt niet met ":value"',
    'search_modifier_description_contains'                => 'Omschrijving bevat ":value"',
    'search_modifier_not_description_contains'            => 'Omschrijving bevat niet ":value"',
    'search_modifier_description_is'                      => 'Omschrijving is ":value"',
    'search_modifier_not_description_is'                  => 'Omschrijving is niet ":value"',
    'search_modifier_currency_is'                         => 'Transactie (vreemde) valuta is ":value"',
    'search_modifier_not_currency_is'                     => 'Transactie (vreemde) valuta is niet ":value"',
    'search_modifier_foreign_currency_is'                 => 'Transactie vreemde valuta is ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transactie vreemde valuta is niet ":value"',
    'search_modifier_has_attachments'                     => 'De transactie moet een bijlage hebben',
    'search_modifier_has_no_category'                     => 'De transactie heeft geen categorie',
    'search_modifier_not_has_no_category'                 => 'Transactie heeft een (welke dan ook) categorie',
    'search_modifier_not_has_any_category'                => 'De transactie heeft geen categorie',
    'search_modifier_has_any_category'                    => 'Transactie heeft een (welke dan ook) categorie',
    'search_modifier_has_no_budget'                       => 'De transactie heeft geen budget',
    'search_modifier_not_has_any_budget'                  => 'De transactie heeft geen budget',
    'search_modifier_has_any_budget'                      => 'Transactie heeft een (welke dan ook) budget',
    'search_modifier_not_has_no_budget'                   => 'Transactie heeft een (welke dan ook) budget',
    'search_modifier_has_no_bill'                         => 'De transactie heeft geen abonnement',
    'search_modifier_not_has_no_bill'                     => 'Transactie heeft een (welke dan ook) abonnement',
    'search_modifier_has_any_bill'                        => 'Transactie heeft een (welke dan ook) abonnement',
    'search_modifier_not_has_any_bill'                    => 'De transactie heeft geen abonnement',
    'search_modifier_has_no_tag'                          => 'De transactie heeft geen tags',
    'search_modifier_not_has_any_tag'                     => 'De transactie heeft geen tags',
    'search_modifier_not_has_no_tag'                      => 'Transactie heeft een (welke dan ook) tag',
    'search_modifier_has_any_tag'                         => 'Transactie heeft een (welke dan ook) tag',
    'search_modifier_notes_contains'                      => 'De transactienotities bevatten ":value"',
    'search_modifier_not_notes_contains'                  => 'De transactienotities bevatten niet ":value"',
    'search_modifier_notes_starts'                        => 'De transactienotities beginnen met ":value"',
    'search_modifier_not_notes_starts'                    => 'De transactienotities beginnen niet met ":value"',
    'search_modifier_notes_ends'                          => 'De transactienotities eindigen op ":value"',
    'search_modifier_not_notes_ends'                      => 'De transactienotities eindigen niet op ":value"',
    'search_modifier_notes_is'                            => 'De transactienotities zijn ":value"',
    'search_modifier_not_notes_is'                        => 'De transactienotities zijn niet ":value"',
    'search_modifier_no_notes'                            => 'Transactie heeft geen notities',
    'search_modifier_not_no_notes'                        => 'Transactie heeft notities (eender wat dan)',
    'search_modifier_any_notes'                           => 'Transactie heeft notities (eender wat dan)',
    'search_modifier_not_any_notes'                       => 'Transactie heeft geen notities',
    'search_modifier_amount_is'                           => 'Bedrag is precies :value',
    'search_modifier_not_amount_is'                       => 'Bedrag is niet :value',
    'search_modifier_amount_less'                         => 'Bedrag is kleiner dan of gelijk aan :value',
    'search_modifier_not_amount_more'                     => 'Bedrag is kleiner dan of gelijk aan :value',
    'search_modifier_amount_more'                         => 'Bedrag is meer dan of gelijk aan :value',
    'search_modifier_not_amount_less'                     => 'Bedrag is meer dan of gelijk aan :value',
    'search_modifier_source_account_is'                   => 'Bronrekeningnaam is ":value"',
    'search_modifier_not_source_account_is'               => 'Bronrekeningnaam is niet ":value"',
    'search_modifier_source_account_contains'             => 'Bronrekeningnaam bevat ":value"',
    'search_modifier_not_source_account_contains'         => 'Bronrekeningnaam bevat niet ":value"',
    'search_modifier_source_account_starts'               => 'Bronrekeningnaam begint met ":value"',
    'search_modifier_not_source_account_starts'           => 'Bronrekeningnaam begint niet met ":value"',
    'search_modifier_source_account_ends'                 => 'Bronrekeningnaam eindigt met ":value"',
    'search_modifier_not_source_account_ends'             => 'Bronrekeningnaam eindigt niet met ":value"',
    'search_modifier_source_account_id'                   => 'Bronrekening ID is :value',
    'search_modifier_not_source_account_id'               => 'Bronrekening ID is niet :value',
    'search_modifier_source_account_nr_is'                => 'Bronrekeningnummer (IBAN) is ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Bronrekeningnummer (IBAN) is niet ":value"',
    'search_modifier_source_account_nr_contains'          => 'Bronrekeningnummer (IBAN) bevat ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Bronrekeningnummer (IBAN) bevat niet ":value"',
    'search_modifier_source_account_nr_starts'            => 'Bronrekeningnummer (IBAN) begint met ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Bronrekeningnummer (IBAN) begint niet met ":value"',
    'search_modifier_source_account_nr_ends'              => 'Bronrekeningnummer (IBAN) eindigt niet op ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Bronrekeningnummer (IBAN) eindigt niet op ":value"',
    'search_modifier_destination_account_is'              => 'Doelrekeningnaam is ":value"',
    'search_modifier_not_destination_account_is'          => 'Doelrekeningnaam is niet ":value"',
    'search_modifier_destination_account_contains'        => 'Doelrekeningnaam bevat ":value"',
    'search_modifier_not_destination_account_contains'    => 'Doelrekeningnaam bevat niet ":value"',
    'search_modifier_destination_account_starts'          => 'Doelrekeningnaam begint met ":value"',
    'search_modifier_not_destination_account_starts'      => 'Doelrekeningnaam start niet met ":value"',
    'search_modifier_destination_account_ends'            => 'Doelrekeningnaam eindigt met ":value"',
    'search_modifier_not_destination_account_ends'        => 'Doelrekeningnaam eindigt niet op ":value"',
    'search_modifier_destination_account_id'              => 'Doelrekening ID is ":value"',
    'search_modifier_not_destination_account_id'          => 'Doelrekening ID is niet ":value"',
    'search_modifier_destination_is_cash'                 => 'Doelrekening is de "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Doelrekening is niet de "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Bronrekening is de "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Bronrekening is niet de "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Doelrekeningnummer (IBAN) is ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Doelrekeningnummer (IBAN) is niet ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Doelrekeningnummer (IBAN) bevat ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Doelrekeningnummer (IBAN) bevat niet ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Doelrekeningnummer (IBAN) begint met ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Doelrekeningnummer (IBAN) begint niet met ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Doelrekeningnummer (IBAN) eindigt met ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Doelrekeningnummer (IBAN) eindigt niet op ":value"',
    'search_modifier_account_id'                          => 'Bron- of doelrekening ID is/zijn ":value"',
    'search_modifier_not_account_id'                      => 'Bron- of doelrekening ID is/zijn niet ":value"',
    'search_modifier_category_is'                         => 'Categorie is ":value"',
    'search_modifier_not_category_is'                     => 'Categorie is niet ":value"',
    'search_modifier_budget_is'                           => 'Budget is ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is niet ":value"',
    'search_modifier_bill_is'                             => 'Abonnement is ":value"',
    'search_modifier_not_bill_is'                         => 'Abonnement is niet ":value"',
    'search_modifier_transaction_type'                    => 'Transactietype is ":value"',
    'search_modifier_not_transaction_type'                => 'Transactietype is niet ":value"',
    'search_modifier_tag_is'                              => 'Tag is ":value"',
    'search_modifier_tag_contains'                        => 'Tag bevat ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag bevat niet ":value"',
    'search_modifier_tag_ends'                            => 'Tag eindigt op ":value"',
    'search_modifier_tag_starts'                          => 'Tag begint met ":value"',
    'search_modifier_not_tag_is'                          => 'Geen tag is ":value"',
    'search_modifier_date_on_year'                        => 'Transactie is in jaar ":value"',
    'search_modifier_not_date_on_year'                    => 'Transactie is niet in jaar ":value"',
    'search_modifier_date_on_month'                       => 'Transactie is in maand ":value"',
    'search_modifier_not_date_on_month'                   => 'Transactie is niet in maand ":value"',
    'search_modifier_date_on_day'                         => 'Transactie is op dag van de maand ":value"',
    'search_modifier_not_date_on_day'                     => 'Transactie is niet op dag van de maand ":value"',
    'search_modifier_date_before_year'                    => 'Transactie is in of voor ":value"',
    'search_modifier_date_before_month'                   => 'Transactie is in of voor maand ":value"',
    'search_modifier_date_before_day'                     => 'Transactie is voor of op dag van de maand ":value"',
    'search_modifier_date_after_year'                     => 'Transactie is in of na jaar ":value"',
    'search_modifier_date_after_month'                    => 'Transactie is in of na maand ":value"',
    'search_modifier_date_after_day'                      => 'Transactie is op of na dag van de maand ":value"',

    // new
    'search_modifier_tag_is_not'                          => 'Geen tag is ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tag is ":value"',
    'search_modifier_account_is'                          => 'Bron- of doelrekeningnaam is ":value"',
    'search_modifier_not_account_is'                      => 'Bron- noch doelrekeningnaam is ":value"',
    'search_modifier_account_contains'                    => 'Bron- of doelrekeningnaam bevat ":value"',
    'search_modifier_not_account_contains'                => 'Bron- noch doelrekeningnaam bevat ":value"',
    'search_modifier_account_ends'                        => 'Bron- of doelrekeningnaam eindigt op ":value"',
    'search_modifier_not_account_ends'                    => 'Bron- noch doelrekeningnaam eindigt op ":value"',
    'search_modifier_account_starts'                      => 'Bron- of doelrekeningnaam begint met ":value"',
    'search_modifier_not_account_starts'                  => 'Bron- noch doelrekeningnaam begint met ":value"',
    'search_modifier_account_nr_is'                       => 'Bron- of doelrekeningnummer / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Bron- noch doelrekeningnummer / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Bron- of doelrekeningnummer / IBAN bevat ":value"',
    'search_modifier_not_account_nr_contains'             => 'Bron- noch doelrekeningnummer / IBAN bevat ":value"',
    'search_modifier_account_nr_ends'                     => 'Bron- of doelrekeningnummer / IBAN eindigt op ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Bron- noch doelrekeningnummer / IBAN eindigt op ":value"',
    'search_modifier_account_nr_starts'                   => 'Bron- of doelrekeningnummer / IBAN begint met ":value"',
    'search_modifier_not_account_nr_starts'               => 'Bron- of doelrekeningnummer / IBAN begint niet met ":value"',
    'search_modifier_category_contains'                   => 'Categorie bevat ":value"',
    'search_modifier_not_category_contains'               => 'Categorie bevat niet ":value"',
    'search_modifier_category_ends'                       => 'Categorie eindigt op ":value"',
    'search_modifier_not_category_ends'                   => 'Categorie eindigt niet op ":value"',
    'search_modifier_category_starts'                     => 'Categorie begint met ":value"',
    'search_modifier_not_category_starts'                 => 'Categorie begint niet met ":value"',
    'search_modifier_budget_contains'                     => 'Budget bevat ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget bevat niet ":value"',
    'search_modifier_budget_ends'                         => 'Budget eindigt op ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget eindigt niet op ":value"',
    'search_modifier_budget_starts'                       => 'Budget begint met ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget begint niet met ":value"',
    'search_modifier_bill_contains'                       => 'Abonnement bevat ":value"',
    'search_modifier_not_bill_contains'                   => 'Abonnement bevat niet ":value"',
    'search_modifier_bill_ends'                           => 'Abonnement eindigt op ":value"',
    'search_modifier_not_bill_ends'                       => 'Abonnement eindigt niet met ":value"',
    'search_modifier_bill_starts'                         => 'Abonnement begint met ":value"',
    'search_modifier_not_bill_starts'                     => 'Abonnement begint niet met ":value"',
    'search_modifier_external_id_contains'                => 'Externe ID bevat ":value"',
    'search_modifier_not_external_id_contains'            => 'Externe ID bevat niet ":value"',
    'search_modifier_external_id_ends'                    => 'Externe ID eindigt op ":value"',
    'search_modifier_not_external_id_ends'                => 'Externe ID eindigt niet op ":value"',
    'search_modifier_external_id_starts'                  => 'Externe ID begint met ":value"',
    'search_modifier_not_external_id_starts'              => 'Externe ID begint niet met ":value"',
    'search_modifier_internal_reference_contains'         => 'Interne referentie bevat ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Interne referentie bevat niet ":value"',
    'search_modifier_internal_reference_ends'             => 'Interne referentie eindigt op ":value"',
    'search_modifier_internal_reference_starts'           => 'Interne referentie begint met ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Interne referentie eindigt niet op ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Interne referentie begint niet met ":value"',
    'search_modifier_external_url_is'                     => 'Externe URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'Externe URL is niet ":value"',
    'search_modifier_external_url_contains'               => 'Externe URL bevat ":value"',
    'search_modifier_not_external_url_contains'           => 'Externe URL bevat niet ":value"',
    'search_modifier_external_url_ends'                   => 'Externe URL eindigt op ":value"',
    'search_modifier_not_external_url_ends'               => 'Externe URL eindigt niet op ":value"',
    'search_modifier_external_url_starts'                 => 'Externe URL begint met ":value"',
    'search_modifier_not_external_url_starts'             => 'Externe ID begint niet met ":value"',
    'search_modifier_has_no_attachments'                  => 'Transactie heeft geen bijlagen',
    'search_modifier_not_has_no_attachments'              => 'Transactie heeft bijlagen',
    'search_modifier_not_has_attachments'                 => 'Transactie heeft geen bijlagen',
    'search_modifier_account_is_cash'                     => 'Bron- of doelrekening is de "(cash)"-rekening.',
    'search_modifier_not_account_is_cash'                 => 'Bron- noch doelrekening is de "(cash)"-rekening.',
    'search_modifier_journal_id'                          => 'Het journal-ID is ":value"',
    'search_modifier_not_journal_id'                      => 'Het journal-ID is niet ":value"',
    'search_modifier_recurrence_id'                       => 'Het ID van de periodieke transactie is ":value"',
    'search_modifier_not_recurrence_id'                   => 'Het ID van de periodieke transactie is niet ":value"',
    'search_modifier_foreign_amount_is'                   => 'Het bedrag in vreemde valuta is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'Het bedrag in vreemde valuta is niet ":value"',
    'search_modifier_foreign_amount_less'                 => 'Het bedrag in vreemde valuta is minder dan ":value"',
    'search_modifier_not_foreign_amount_more'             => 'Het bedrag in vreemde valuta is minder dan ":value"',
    'search_modifier_not_foreign_amount_less'             => 'Het bedrag in vreemde valuta is meer dan ":value"',
    'search_modifier_foreign_amount_more'                 => 'Het bedrag in vreemde valuta is meer dan ":value"',
    'search_modifier_exists'                              => 'Transactie bestaat (elke transactie)',
    'search_modifier_not_exists'                          => 'Transactie bestaat niet (geen transactie)',

    // date fields
    'search_modifier_interest_date_on'                    => 'De rentedatum is ":value"',
    'search_modifier_not_interest_date_on'                => 'De rentedatum is niet ":value"',
    'search_modifier_interest_date_on_year'               => 'De rentedatum is in jaar ":value"',
    'search_modifier_not_interest_date_on_year'           => 'De rentedatum is niet in jaar ":value"',
    'search_modifier_interest_date_on_month'              => 'De rentedatum is in maand ":value"',
    'search_modifier_not_interest_date_on_month'          => 'De rentedatum is niet in maand ":value"',
    'search_modifier_interest_date_on_day'                => 'De rentedatum is op dag van de maand ":value"',
    'search_modifier_not_interest_date_on_day'            => 'De rentedatum is niet op dag van de maand ":value"',
    'search_modifier_interest_date_before_year'           => 'De rentedatum is in of voor jaar ":value"',
    'search_modifier_interest_date_before_month'          => 'De rentedatum is in of voor maand ":value"',
    'search_modifier_interest_date_before_day'            => 'De rentedatum is op of voor dag van de maand ":value"',
    'search_modifier_interest_date_after_year'            => 'De rentedatum is in of na jaar ":value"',
    'search_modifier_interest_date_after_month'           => 'De rentedatum is in of na maand ":value"',
    'search_modifier_interest_date_after_day'             => 'De rentedatum is op of na dag van de maand ":value"',
    'search_modifier_book_date_on_year'                   => 'De boekdatum is in jaar ":value"',
    'search_modifier_book_date_on_month'                  => 'De boekdatum is in maand ":value"',
    'search_modifier_book_date_on_day'                    => 'De boekdatum is op dag van de maand ":value"',
    'search_modifier_not_book_date_on_year'               => 'De boekdatum is niet in jaar ":value"',
    'search_modifier_not_book_date_on_month'              => 'De boekdatum is niet in maand ":value"',
    'search_modifier_not_book_date_on_day'                => 'De boekdatum is niet op dag van de maand ":value"',
    'search_modifier_book_date_before_year'               => 'De boekdatum is in of voor jaar ":value"',
    'search_modifier_book_date_before_month'              => 'De boekdatum is in of voor maand ":value"',
    'search_modifier_book_date_before_day'                => 'De boekdatum op in of voor dag van de maand ":value"',
    'search_modifier_book_date_after_year'                => 'De boekdatum is in of na jaar ":value"',
    'search_modifier_book_date_after_month'               => 'De boekdatum is in of na maand ":value"',
    'search_modifier_book_date_after_day'                 => 'De boekdatum is op of na dag van de maand ":value"',
    'search_modifier_process_date_on_year'                => 'De verwerkingsdatum is in jaar ":value"',
    'search_modifier_process_date_on_month'               => 'De verwerkingsdatum is in maand ":value"',
    'search_modifier_process_date_on_day'                 => 'De verwerkingsdatum is op dag van de maand ":value"',
    'search_modifier_not_process_date_on_year'            => 'De verwerkingsdatum is niet in jaar ":value"',
    'search_modifier_not_process_date_on_month'           => 'De verwerkingsdatum is niet in maand ":value"',
    'search_modifier_not_process_date_on_day'             => 'De verwerkingsdatum is niet op dag van de maand ":value"',
    'search_modifier_process_date_before_year'            => 'De verwerkingsdatum is in of voor jaar ":value"',
    'search_modifier_process_date_before_month'           => 'De verwerkingsdatum is in of voor maand ":value"',
    'search_modifier_process_date_before_day'             => 'De verwerkingsdatum is op of voor dag van de maand ":value"',
    'search_modifier_process_date_after_year'             => 'De verwerkingsdatum is in of na jaar ":value"',
    'search_modifier_process_date_after_month'            => 'De verwerkingsdatum is in of na maand ":value"',
    'search_modifier_process_date_after_day'              => 'De verwerkingsdatum is op of na dag van de maand ":value"',
    'search_modifier_due_date_on_year'                    => 'De vervaldatum is in jaar ":value"',
    'search_modifier_due_date_on_month'                   => 'De vervaldatum is in maand ":value"',
    'search_modifier_due_date_on_day'                     => 'De vervaldatum is op dag van de maand ":value"',
    'search_modifier_not_due_date_on_year'                => 'De vervaldatum is niet in jaar ":value"',
    'search_modifier_not_due_date_on_month'               => 'De vervaldatum is niet in maand ":value"',
    'search_modifier_not_due_date_on_day'                 => 'De vervaldatum is niet op dag van de maand ":value"',
    'search_modifier_due_date_before_year'                => 'De vervaldatum is in of voor jaar ":value"',
    'search_modifier_due_date_before_month'               => 'De vervaldatum is in of voor maand ":value"',
    'search_modifier_due_date_before_day'                 => 'De vervaldatum is op of voor dag van de maand ":value"',
    'search_modifier_due_date_after_year'                 => 'De vervaldatum is in of na jaar ":value"',
    'search_modifier_due_date_after_month'                => 'De vervaldatum is in of na maand ":value"',
    'search_modifier_due_date_after_day'                  => 'De vervaldatum is op of na dag van de maand ":value"',
    'search_modifier_payment_date_on_year'                => 'De betalingsdatum is in jaar ":value"',
    'search_modifier_payment_date_on_month'               => 'De betalingsdatum is in maand ":value"',
    'search_modifier_payment_date_on_day'                 => 'De betalingsdatum is op dag van de maand ":value"',
    'search_modifier_not_payment_date_on_year'            => 'De betalingsdatum is niet in jaar ":value"',
    'search_modifier_not_payment_date_on_month'           => 'De betalingsdatum is niet in maand ":value"',
    'search_modifier_not_payment_date_on_day'             => 'De betalingsdatum is niet op dag van de maand ":value"',
    'search_modifier_payment_date_before_year'            => 'De betalingsdatum is in of voor jaar ":value"',
    'search_modifier_payment_date_before_month'           => 'De betalingsdatum is in of voor maand ":value"',
    'search_modifier_payment_date_before_day'             => 'De betalingsdatum is op of voor dag van de maand ":value"',
    'search_modifier_payment_date_after_year'             => 'De betalingsdatum is in of na jaar ":value"',
    'search_modifier_payment_date_after_month'            => 'De betalingsdatum is in of na maand ":value"',
    'search_modifier_payment_date_after_day'              => 'De betalingsdatum is op of na dag van de maand ":value"',
    'search_modifier_invoice_date_on_year'                => 'De factuurdatum is in jaar ":value"',
    'search_modifier_invoice_date_on_month'               => 'De factuurdatum is in maand ":value"',
    'search_modifier_invoice_date_on_day'                 => 'De factuurdatum is op dag van de maand ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'De factuurdatum is niet in jaar ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'De factuurdatum is niet in maand ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'De factuurdatum is niet op dag van de maand ":value"',
    'search_modifier_invoice_date_before_year'            => 'De factuurdatum is in of voor jaar ":value"',
    'search_modifier_invoice_date_before_month'           => 'De factuurdatum is in of voor maand ":value"',
    'search_modifier_invoice_date_before_day'             => 'De factuurdatum is op of voor dag van de maand ":value"',
    'search_modifier_invoice_date_after_year'             => 'De factuurdatum is in of na jaar ":value"',
    'search_modifier_invoice_date_after_month'            => 'De factuurdatum is in of na maand ":value"',
    'search_modifier_invoice_date_after_day'              => 'De factuurdatum is op of na dag van de maand ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'De transactie werd het laatst gewijzigd in jaar ":value"',
    'search_modifier_updated_at_on_month'                 => 'De transactie werd het laatst gewijzigd in maand ":value"',
    'search_modifier_updated_at_on_day'                   => 'De transactie werd het laatst gewijzigd op dag van de maand ":value"',
    'search_modifier_not_updated_at_on_year'              => 'De transactie werd niet het laatst gewijzigd in jaar ":value"',
    'search_modifier_not_updated_at_on_month'             => 'De transactie werd niet het laatst gewijzigd in maand ":value"',
    'search_modifier_not_updated_at_on_day'               => 'De transactie werd niet het laatst gewijzigd op dag van de maand ":value"',
    'search_modifier_updated_at_before_year'              => 'De transactie werd het laatst gewijzigd in of voor jaar ":value"',
    'search_modifier_updated_at_before_month'             => 'De transactie werd het laatst gewijzigd in of voor maand ":value"',
    'search_modifier_updated_at_before_day'               => 'De transactie werd het laatst gewijzigd op of voor dag van de maand ":value"',
    'search_modifier_updated_at_after_year'               => 'De transactie werd het laatst gewijzigd in of na jaar ":value"',
    'search_modifier_updated_at_after_month'              => 'De transactie werd het laatst gewijzigd in of na maand ":value"',
    'search_modifier_updated_at_after_day'                => 'Transactie werd laatst gewijzigd op of na dag van de maand ":value"',
    'search_modifier_created_at_on_year'                  => 'Transactie werd gemaakt in jaar ":value"',
    'search_modifier_created_at_on_month'                 => 'Transactie werd gemaakt in maand ":value"',
    'search_modifier_created_at_on_day'                   => 'Transactie werd gemaakt op dag van de maand ":value"',
    'search_modifier_not_created_at_on_year'              => 'De transactie werd niet gemaakt in jaar ":value"',
    'search_modifier_not_created_at_on_month'             => 'De transactie werd niet gemaakt in maand ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transactie werd niet gemaakt op dag van de maand ":value"',
    'search_modifier_created_at_before_year'              => 'Transactie werd gemaakt in of voor jaar ":value"',
    'search_modifier_created_at_before_month'             => 'Transactie werd gemaakt in of voor maand ":value"',
    'search_modifier_created_at_before_day'               => 'Transactie werd gemaakt op of voor dag van de maand ":value"',
    'search_modifier_created_at_after_year'               => 'Transactie werd gemaakt in of na jaar ":value"',
    'search_modifier_created_at_after_month'              => 'Transactie werd gemaakt in of na maand ":value"',
    'search_modifier_created_at_after_day'                => 'Transactie werd gemaakt op of na dag van de maand ":value"',
    'search_modifier_interest_date_before'                => 'Rentedatum is op of voor ":value"',
    'search_modifier_interest_date_after'                 => 'Rentedatum is op of na ":value"',
    'search_modifier_book_date_on'                        => 'Boekdatum is op ":value"',
    'search_modifier_not_book_date_on'                    => 'Boekdatum is niet op ":value"',
    'search_modifier_book_date_before'                    => 'Boekdatum is op of voor ":value"',
    'search_modifier_book_date_after'                     => 'Boekdatum is op of na ":value"',
    'search_modifier_process_date_on'                     => 'Verwerkingsdatum is op ":value"',
    'search_modifier_not_process_date_on'                 => 'Verwerkingsdatum is niet op ":value"',
    'search_modifier_process_date_before'                 => 'Verwerkingsdatum is op of voor ":value"',
    'search_modifier_process_date_after'                  => 'Verwerkingsdatum is op of na ":value"',
    'search_modifier_due_date_on'                         => 'Vervaldatum is op ":value"',
    'search_modifier_not_due_date_on'                     => 'Vervaldatum is niet op ":value"',
    'search_modifier_due_date_before'                     => 'Vervaldatum is op of voor ":value"',
    'search_modifier_due_date_after'                      => 'Vervaldatum is op of na ":value"',
    'search_modifier_payment_date_on'                     => 'Betalingsdatum is op ":value"',
    'search_modifier_not_payment_date_on'                 => 'Betalingsdatum is niet op ":value"',
    'search_modifier_payment_date_before'                 => 'Betalingsdatum is op of voor ":value"',
    'search_modifier_payment_date_after'                  => 'Betalingsdatum is op of na ":value"',
    'search_modifier_invoice_date_on'                     => 'Factuurdatum is op ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Factuurdatum is niet op ":value"',
    'search_modifier_invoice_date_before'                 => 'Factuurdatum is op of voor ":value"',
    'search_modifier_invoice_date_after'                  => 'Factuurdatum is op of na ":value"',
    'search_modifier_created_at_on'                       => 'Transactie werd gemaakt op ":value"',
    'search_modifier_not_created_at_on'                   => 'Transactie werd niet gemaakt op ":value"',
    'search_modifier_created_at_before'                   => 'Transactie werd gemaakt op of voor ":value"',
    'search_modifier_created_at_after'                    => 'Transactie werd gemaakt op of na ":value"',
    'search_modifier_updated_at_on'                       => 'Transactie werd gewijzigd op ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transactie werd niet het laatst gewijzigd op ":value"',
    'search_modifier_updated_at_before'                   => 'Transactie werd gewijzigd op of voor ":value"',
    'search_modifier_updated_at_after'                    => 'Transactie werd gewijzigd op of na ":value"',

    'search_modifier_attachment_name_is'            => 'Enige bijlage heet ":value"',
    'search_modifier_attachment_name_contains'      => 'Er is een bijlage waarvan de naam ":value" bevat',
    'search_modifier_attachment_name_starts'        => 'Er is een bijlage waarvan de naam begint met ":value"',
    'search_modifier_attachment_name_ends'          => 'Er is een bijlage waarvan de naam eindigt op ":value"',
    'search_modifier_attachment_notes_are'          => 'Er is een bijlage met notitie ":value"',
    'search_modifier_attachment_notes_contains'     => 'Er is een bijlage waarvan de notitie ":value" bevat',
    'search_modifier_attachment_notes_starts'       => 'Er is een bijlage waarvan de notitie begint met ":value"',
    'search_modifier_attachment_notes_ends'         => 'Er is een bijlage waarvan de notitie eindigt op ":value"',
    'search_modifier_not_attachment_name_is'        => 'Geen bijlage heet ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Er is geen bijlage waarvan de naam ":value" bevat',
    'search_modifier_not_attachment_name_starts'    => 'Er is geen bijlage waarvan de naam begint met ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Er is geen bijlage waarvan de naam eindigt op ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Er is een bijlage waarvan de notitie niet eindigt op ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Er is een bijlage waarvan de notitie niet ":value" bevatten',
    'search_modifier_not_attachment_notes_starts'   => 'Er is een bijlage waarvan de notitie begint met ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Er is een bijlage waarvan de notitie niet eindigt op ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Update regel ":rule" middels zoekquery',
    'create_rule_from_query'                        => 'Nieuwe regel op basis van zoekquery',
    'rule_from_search_words'                        => 'Firefly III heeft moeite met deze query: ":string". De voorgestelde regel die past bij je zoekquery kan afwijken. Controleer de regel zorgvuldig.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Het saldo van de doelrekening is precies ":value"',
    'search_modifier_not_destination_balance_is'    => 'Het saldo van de doelrekening is NIET precies ":value"',
    'search_modifier_source_balance_is'             => 'Het saldo van de bronrekening is precies ":value"',
    'search_modifier_not_source_balance_is'         => 'Het saldo van de bronrekening is niet ":value"',

    'search_modifier_destination_balance_lte'     => 'Het saldo van de doelrekening is minder dan of gelijk aan ":value"',
    'search_modifier_not_destination_balance_lte' => 'Het saldo van de doelrekening is meer dan ":value"',
    'search_modifier_source_balance_lte'          => 'Het saldo van de bronrekening is minder dan ":value"',
    'search_modifier_not_source_balance_lte'      => 'Het saldo van de bronrekening is meer dan ":value"',

    'search_modifier_destination_balance_lt'     => 'Het saldo van de doelrekening is minder dan ":value"',
    'search_modifier_not_destination_balance_lt' => 'Het saldo van de doelrekening is meer dan of gelijk aan ":value"',
    'search_modifier_source_balance_lt'          => 'Het saldo van de bronrekening is meer dan ":value"',
    'search_modifier_not_source_balance_lt'      => 'Het saldo van de bronrekening is meer dan of gelijk aan ":value"',

    'search_modifier_destination_balance_gte'     => 'Het saldo van de doelrekening is meer dan of gelijk aan ":value"',
    'search_modifier_not_destination_balance_gte' => 'Het saldo van de doelrekening is minder dan ":value"',
    'search_modifier_source_balance_gte'          => 'Het saldo van de bronrekening is meer dan of gelijk aan ":value"',
    'search_modifier_not_source_balance_gte'      => 'Het saldo van de bronrekening is minder dan ":value"',

    'search_modifier_destination_balance_gt'              => 'Het saldo van de doelrekening is meer dan ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Het saldo van de doelrekening is minder dan of gelijk aan ":value"',
    'search_modifier_source_balance_gt'                   => 'Het saldo van de bronrekening is meer dan ":value"',
    'search_modifier_not_source_balance_gt'               => 'Het saldo van de bronrekening is minder dan of gelijk aan ":value"',


    // END
    'general_search_error'                                => 'Er is een fout opgetreden tijdens het zoeken. Controleer de log-bestanden voor meer informatie.',
    'search_box'                                          => 'Zoeken',
    'search_box_intro'                                    => 'Welkom bij de zoekfunctie van Firefly III. Voer je zoekopdracht in het vak. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Bekijk zeker de help-pagina</a>, want de zoekfunctie is behoorlijk geadvanceerd.',
    'search_error'                                        => 'Fout tijdens het zoeken',
    'search_searching'                                    => 'Bezig met zoeken ...',
    'search_results'                                      => 'Zoekresultaten',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'jaarlijks',
    'repeat_freq_half-year'                               => 'elk half jaar',
    'repeat_freq_quarterly'                               => 'elk kwartaal',
    'repeat_freq_monthly'                                 => 'maandelijks',
    'repeat_freq_weekly'                                  => 'wekelijks',
    'repeat_freq_daily'                                   => 'dagelijks',
    'daily'                                               => 'dagelijks',
    'weekly'                                              => 'wekelijks',
    'quarterly'                                           => 'elk kwartaal',
    'half-year'                                           => 'elk half jaar',
    'yearly'                                              => 'elk jaar',

    // rules
    'is_not_rule_trigger'                                 => 'Niet',
    'cannot_fire_inactive_rules'                          => 'Inactieve regels doen het niet.',
    'show_triggers'                                       => 'Toon triggers',
    'show_actions'                                        => 'Toon acties',
    'rules'                                               => 'Regels',
    'rule_name'                                           => 'Regelnaam',
    'rule_triggers'                                       => 'Regel reageert op',
    'rule_actions'                                        => 'Regel zal dan',
    'new_rule'                                            => 'Nieuwe regel',
    'new_rule_group'                                      => 'Nieuwe regelgroep',
    'rule_priority_up'                                    => 'Geef regel meer prioriteit',
    'rule_priority_down'                                  => 'Geef regel minder prioriteit',
    'make_new_rule_group'                                 => 'Maak nieuwe regelgroep',
    'store_new_rule_group'                                => 'Sla nieuwe regelgroep op',
    'created_new_rule_group'                              => 'Nieuwe regelgroep ":title" opgeslagen!',
    'updated_rule_group'                                  => 'Regelgroep ":title" geüpdatet.',
    'edit_rule_group'                                     => 'Wijzig regelgroep ":title"',
    'duplicate_rule'                                      => 'Dupliceer regel ":title"',
    'rule_copy_of'                                        => 'Kopie van ":title"',
    'duplicated_rule'                                     => 'Regel ":title" gekopieerd naar ":newTitle"',
    'delete_rule_group'                                   => 'Verwijder regelgroep ":title"',
    'deleted_rule_group'                                  => 'Regelgroep ":title" verwijderd',
    'update_rule_group'                                   => 'Wijzig regelgroep',
    'no_rules_in_group'                                   => 'Er zijn geen regels in deze groep',
    'move_rule_group_up'                                  => 'Verplaats regelgroep omhoog',
    'move_rule_group_down'                                => 'Verplaats regelgroep omlaag',
    'save_rules_by_moving'                                => 'Red deze regel van de ondergang door ze te verplaatsen naar een andere regelgroep:|Red deze regels van de ondergang door ze te verplaatsen naar een andere regelgroep:',
    'make_new_rule'                                       => 'Maak een nieuwe regel in regelgroep ":title"',
    'make_new_rule_no_group'                              => 'Maak een nieuwe regel',
    'instructions_rule_from_bill'                         => 'Om transacties te kunnen koppelen aan je nieuwe abonnement ":name" moet Firefly III een nieuwe regel maken die automatisch checkt of nieuwe transacties horen bij dit nieuwe abonnement. Check de details hieronder en sla de nieuwe regel op, zodat Firefly III dit klusje voor je kan klaren.',
    'instructions_rule_from_journal'                      => 'Maak een regel op basis van één van je transacties. Vul dit formulier aan.',
    'rule_is_strict'                                      => 'strikte regel',
    'rule_is_not_strict'                                  => 'niet-strikte regel',
    'rule_help_stop_processing'                           => 'Door deze checkbox worden latere regels in deze groep niet uitgevoerd als deze specifieke regel getriggerd is.',
    'rule_help_strict'                                    => 'Voor strikte regels geldt dat ALLE triggers overeen moeten komen. Voor niet-strikte regel is één trigger genoeg om de acties uit te laten voeren.',
    'rule_help_active'                                    => 'Niet actieve regels zullen nooit worden gecontroleerd.',
    'stored_new_rule'                                     => 'Nieuwe regel ":title" opgeslagen',
    'deleted_rule'                                        => 'Regel ":title" verwijderd',
    'store_new_rule'                                      => 'Sla nieuwe regel op',
    'updated_rule'                                        => 'Regel ":title" geüpdatet',
    'default_rule_group_name'                             => 'Standaard regels',
    'default_rule_group_description'                      => 'Al je regels die niet in een bepaalde groep zitten.',
    'trigger'                                             => 'Trigger',
    'trigger_value'                                       => 'Trigger bij waarde',
    'stop_processing_other_triggers'                      => 'Reageer niet meer op andere triggers',
    'add_rule_trigger'                                    => 'Nieuwe trigger toevoegen',
    'action'                                              => 'Actie',
    'action_value'                                        => 'Actie-waarde',
    'stop_executing_other_actions'                        => 'Voer verdere acties niet uit',
    'add_rule_action'                                     => 'Nieuwe actie toevoegen',
    'edit_rule'                                           => 'Wijzig regel #:nr ":title"',
    'delete_rule'                                         => 'Verwijder regel ":title"',
    'update_rule'                                         => 'Werk regel bij',
    'test_rule_triggers'                                  => 'Bekijk welke transacties hieraan voldoen',
    'warning_no_matching_transactions'                    => 'Geen overeenkomende transacties gevonden.',
    'warning_no_valid_triggers'                           => 'Geen geldige triggers gevonden.',
    'apply_rule_selection'                                => 'Pas regel ":title" toe op een selectie van je transacties',
    'apply_rule_selection_intro'                          => 'Regels zoals ":title" worden normaal alleen op nieuwe of geüpdate transacties toegepast, maar Firefly III kan ze ook toepassen op (een selectie van) je bestaande transacties. Dit kan praktisch zijn als je een regels hebt veranderd en je wilt de veranderingen toepassen op al je transacties.',
    'include_transactions_from_accounts'                  => 'Gebruik transacties van deze rekeningen',
    'include'                                             => 'Opnemen?',
    'applied_rule_selection'                              => '{0} Er zijn geen transacties in je selectie veranderd door regel ":title".|[1] Eén transactie in je selectie is veranderd door regel ":title".|[2,*] :count transacties in je selectie zijn veranderd door regel ":title".',
    'execute'                                             => 'Uitvoeren',
    'apply_rule_group_selection'                          => 'Pas regelgroep ":title" toe op een selectie van je transacties',
    'apply_rule_group_selection_intro'                    => 'Regelgroepen zoals ":title" worden normaal alleen op nieuwe of geüpdate transacties toegepast, maar Firefly III kan ze ook toepassen op (een selectie van) je bestaande transacties. Dit kan praktisch zijn als je regels in de groep hebt veranderd en je wilt de veranderingen toepassen op al je transacties.',
    'applied_rule_group_selection'                        => 'Regelgroep ":title" is toegepast op je selectie.',
    'rule_run_after_creation' => 'If you check this box, you get the opportunity to run the rule after it has been created.',
    'rule_run_after_edit' => 'If you check this box, you get the opportunity to run the rule after it has been updated.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Als een transactie wordt gemaakt',
    'rule_trigger_update_journal'                         => 'Als een transactie wordt bijgewerkt',
    'rule_trigger_manual'                                 => 'Alleen door de gebruiker geactiveerd',
    'rule_trigger_user_action'                            => 'Gebruikersactie is ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Bronrekeningnaam begint met..',
    'rule_trigger_source_account_starts'                  => 'Bronrekeningnaam begint met ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Bronrekeningnaam eindigt op..',
    'rule_trigger_source_account_ends'                    => 'Bronrekeningnaam eindigt op ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Bronrekeningnaam is..',
    'rule_trigger_source_account_is'                      => 'Bronrekeningnaam is ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Bronrekeningnaam bevat..',
    'rule_trigger_source_account_contains'                => 'Bronrekeningnaam bevat ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Bron- of doelrekening-ID is..',
    'rule_trigger_account_id'                             => 'Bron- of doelrekening-ID is :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Bronrekening ID is..',
    'rule_trigger_source_account_id'                      => 'Bronrekening ID is :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Doelrekening ID is..',
    'rule_trigger_destination_account_id'                 => 'Doelrekening ID is precies :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Bron- of doelrekening is een cash-rekening',
    'rule_trigger_account_is_cash'                        => 'Bron- of doelrekening is een cash-rekening',
    'rule_trigger_source_is_cash_choice'                  => 'Bronrekening is (cash) account',
    'rule_trigger_source_is_cash'                         => 'Bronrekening is (cash) account',
    'rule_trigger_destination_is_cash_choice'             => 'Doelrekening is (cash) account',
    'rule_trigger_destination_is_cash'                    => 'Doelrekening is (cash) account',
    'rule_trigger_source_account_nr_starts_choice'        => 'Bronrekeningnummer begint met..',
    'rule_trigger_source_account_nr_starts'               => 'Bronrekeningnummer begint met ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Bronrekeningnummer eindigt op..',
    'rule_trigger_source_account_nr_ends'                 => 'Bronrekeningnummer eindigt op ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Bronrekeningnummer / IBAN is..',
    'rule_trigger_source_account_nr_is'                   => 'Bronrekeningnummer / IBAN is ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Bronrekeningnummer / IBAN bevat..',
    'rule_trigger_source_account_nr_contains'             => 'Bronrekeningnummer / IBAN bevat ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Doelrekeningnaam begint met..',
    'rule_trigger_destination_account_starts'             => 'Doelrekeningnaam begint met ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Doelrekeningnaam eindigt op..',
    'rule_trigger_destination_account_ends'               => 'Doelrekeningnaam eindigt op ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Doelrekeningnaam is..',
    'rule_trigger_destination_account_is'                 => 'Doelrekeningnaam is ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Doelrekeningnaam bevat..',
    'rule_trigger_destination_account_contains'           => 'Doelrekeningnaam bevat ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Doelrekeningnummer / IBAN begint met..',
    'rule_trigger_destination_account_nr_starts'          => 'Doelrekeningnummer / IBAN begint met ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Doelrekeningnummer / IBAN eindigt op..',
    'rule_trigger_destination_account_nr_ends'            => 'Doelrekeningnummer / IBAN eindigt op ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Doelrekeningnummer / IBAN is..',
    'rule_trigger_destination_account_nr_is'              => 'Doelrekeningnummer / IBAN is ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Doelrekeningnummer / IBAN bevat..',
    'rule_trigger_destination_account_nr_contains'        => 'Doelrekeningnummer / IBAN bevat ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Transactietype is..',
    'rule_trigger_transaction_type'                       => 'Transactiesoort is ":trigger_value" (Engels)',
    'rule_trigger_category_is_choice'                     => 'Categorie is..',
    'rule_trigger_category_is'                            => 'Categorie is ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Bedrag is kleiner dan of gelijk aan ..',
    'rule_trigger_amount_less'                            => 'Bedrag is kleiner dan of gelijk aan :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Bedrag is..',
    'rule_trigger_amount_is'                              => 'Bedrag is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Bedrag is groter dan of gelijk aan..',
    'rule_trigger_amount_more'                            => 'Bedrag is groter dan of gelijk aan :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Omschrijving begint met..',
    'rule_trigger_description_starts'                     => 'Omschrijving begint met ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Omschrijving eindigt op..',
    'rule_trigger_description_ends'                       => 'Omschrijving eindigt op ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Omschrijving bevat..',
    'rule_trigger_description_contains'                   => 'Omschrijving bevat ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Omschrijving is..',
    'rule_trigger_description_is'                         => 'Omschrijving is ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Transactiedatum is..',
    'rule_trigger_date_on'                                => 'Transactiedatum is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Transactiedatum is vóór..',
    'rule_trigger_date_before'                            => 'Transactiedatum is vóór ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Transactiedatum is na..',
    'rule_trigger_date_after'                             => 'Transactiedatum is na ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transactie is gemaakt op..',
    'rule_trigger_created_at_on'                          => 'Transactie werd gemaakt op ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transactie werd laatst gewijzigd op..',
    'rule_trigger_updated_at_on'                          => 'Transactie werd laatst gewijzigd op ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budget is..',
    'rule_trigger_budget_is'                              => 'Budget is ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Een tag is..',
    'rule_trigger_tag_is'                                 => 'Een tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Een (welke dan ook) tag bevat..',
    'rule_trigger_tag_contains'                           => 'Een tag (welke dan ook) tag bevat ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Een tag (welke dan ook) eindigt op..',
    'rule_trigger_tag_ends'                               => 'Een tag (welke dan ook) eindigt op ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Een tag (welke dan ook) begint met..',
    'rule_trigger_tag_starts'                             => 'Een tag (welke dan ook) begint met ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Transactievaluta is..',
    'rule_trigger_currency_is'                            => 'Transactievaluta is ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Transactie vreemde valuta is..',
    'rule_trigger_foreign_currency_is'                    => 'Transactie vreemde valuta is ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Heeft minstens één bijlage',
    'rule_trigger_has_attachments'                        => 'Heeft minstens één bijlage',
    'rule_trigger_has_no_category_choice'                 => 'Heeft geen categorie',
    'rule_trigger_has_no_category'                        => 'Transactie heeft geen categorie',
    'rule_trigger_has_any_category_choice'                => 'Heeft een (welke dan ook) categorie',
    'rule_trigger_has_any_category'                       => 'Transactie heeft een (welke dan ook) categorie',
    'rule_trigger_has_no_budget_choice'                   => 'Heeft geen budget',
    'rule_trigger_has_no_budget'                          => 'Transactie heeft geen budget',
    'rule_trigger_has_any_budget_choice'                  => 'Heeft een (welke dan ook) budget',
    'rule_trigger_has_any_budget'                         => 'Transactie heeft een (welke dan ook) budget',
    'rule_trigger_has_no_bill_choice'                     => 'Heeft geen abonnement',
    'rule_trigger_has_no_bill'                            => 'Transactie heeft geen abonnement',
    'rule_trigger_has_any_bill_choice'                    => 'Heeft een (eender) abonnement',
    'rule_trigger_has_any_bill'                           => 'Transactie heeft een (eender) abonnement',
    'rule_trigger_has_no_tag_choice'                      => 'Heeft geen tag(s)',
    'rule_trigger_has_no_tag'                             => 'Transactie heeft geen tag(s)',
    'rule_trigger_has_any_tag_choice'                     => 'Heeft een of meer tags',
    'rule_trigger_has_any_tag'                            => 'Transactie heeft een of meer tags',
    'rule_trigger_any_notes_choice'                       => 'Heeft (enige) notities',
    'rule_trigger_any_notes'                              => 'Transactie heeft (enige) notities',
    'rule_trigger_no_notes_choice'                        => 'Heeft geen notities',
    'rule_trigger_no_notes'                               => 'Transactie heeft geen notities',
    'rule_trigger_notes_is_choice'                        => 'Notities zijn..',
    'rule_trigger_notes_is'                               => 'Notities zijn ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notities bevatten..',
    'rule_trigger_notes_contains'                         => 'Notities bevatten ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notities beginnen met..',
    'rule_trigger_notes_starts'                           => 'Notities beginnen met ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notities eindigen op..',
    'rule_trigger_notes_ends'                             => 'Notities eindigen op ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Abonnement is..',
    'rule_trigger_bill_is'                                => 'Abonnement is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'Externe ID is..',
    'rule_trigger_external_id_is'                         => 'Externe ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Interne referentie is..',
    'rule_trigger_internal_reference_is'                  => 'Interne referentie is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Transactiejournaal ID is..',
    'rule_trigger_journal_id'                             => 'Transactiejournaal ID is ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transactie heeft een externe URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transactie heeft een extern ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'De transactie heeft geen externe URL',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transactie heeft geen extern ID',
    'rule_trigger_id_choice'                              => 'Transactie-ID is..',
    'rule_trigger_id'                                     => 'Transactie-ID is ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'Gebruikersactie is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'Geen tag is..',
    'rule_trigger_tag_is_not'                             => 'Geen enkele tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Bron- of doelrekeningnaam is..',
    'rule_trigger_account_is'                             => 'Bron- of doelrekeningnaam is ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Bron- of doelrekeningnaam bevat..',
    'rule_trigger_account_contains'                       => 'Bron- of doelrekeningnaam bevat ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Bron- of doelrekeningnaam eindigt op..',
    'rule_trigger_account_ends'                           => 'Bron- of doelrekeningnaam eindigt op ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Bron- of doelrekeningnaam begint met..',
    'rule_trigger_account_starts'                         => 'Bron- of doelrekeningnaam begint met ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Bron- of doelrekeningnummer / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Bron- of doelrekeningnummer / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Bron- of doelrekeningnummer / IBAN bevat..',
    'rule_trigger_account_nr_contains'                    => 'Bron- of doelrekeningnummer / IBAN bevat ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Bron- of doelrekeningnummer / IBAN eindigt op..',
    'rule_trigger_account_nr_ends'                        => 'Bron- of doelrekeningnummer / IBAN eindigt op ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Bron- of doelrekeningnummer / IBAN begint met..',
    'rule_trigger_account_nr_starts'                      => 'Bron- of doelrekeningnummer / IBAN begint met ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Categorie bevat..',
    'rule_trigger_category_contains'                      => 'Categorie bevat ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Categorie eindigt op..',
    'rule_trigger_category_ends'                          => 'Categorie eindigt op ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Categorie begint met..',
    'rule_trigger_category_starts'                        => 'Categorie begint met ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget bevat..',
    'rule_trigger_budget_contains'                        => 'Budget bevat ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget eindigt op..',
    'rule_trigger_budget_ends'                            => 'Budget eindigt op ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget begint met..',
    'rule_trigger_budget_starts'                          => 'Budget begint met ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Abonnement bevat..',
    'rule_trigger_bill_contains'                          => 'Abonnement bevat ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Abonnement eindigt op..',
    'rule_trigger_bill_ends'                              => 'Abonnement eindigt op ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Abonnement begint met..',
    'rule_trigger_bill_starts'                            => 'Abonnement begint met ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'Externe ID bevat..',
    'rule_trigger_external_id_contains'                   => 'Externe ID bevat ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'Externe ID eindigt op..',
    'rule_trigger_external_id_ends'                       => 'Externe ID eindigt op ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'Externe ID begint met..',
    'rule_trigger_external_id_starts'                     => 'Externe ID begint met ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Interne referentie bevat..',
    'rule_trigger_internal_reference_contains'            => 'Interne referentie bevat ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Interne referentie eindigt op..',
    'rule_trigger_internal_reference_ends'                => 'Interne referentie eindigt op ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Interne referentie begint met..',
    'rule_trigger_internal_reference_starts'              => 'Interne referentie begint met op ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'Externe URL is..',
    'rule_trigger_external_url_is'                        => 'Externe URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'Externe URL bevat..',
    'rule_trigger_external_url_contains'                  => 'Externe URL bevat ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'Externe URL eindigt op..',
    'rule_trigger_external_url_ends'                      => 'Externe URL eindigt op ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'Externe URL begint met..',
    'rule_trigger_external_url_starts'                    => 'Externe URL begint met ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Heeft geen bijlagen',
    'rule_trigger_has_no_attachments'                     => 'Transactie heeft geen bijlagen',
    'rule_trigger_recurrence_id_choice'                   => 'ID van de periodieke transactie is..',
    'rule_trigger_recurrence_id'                          => 'ID van de periodieke transactie is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Rentedatum is op..',
    'rule_trigger_interest_date_on'                       => 'Rentedatum is op ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Rentedatum is voor..',
    'rule_trigger_interest_date_before'                   => 'Rentedatum is voor ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Rentedatum is na..',
    'rule_trigger_interest_date_after'                    => 'Rentedatum is na ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Boekdatum is op..',
    'rule_trigger_book_date_on'                           => 'Boekdatum is op ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Boekdatum is voor..',
    'rule_trigger_book_date_before'                       => 'Boekdatum is voor ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Boekdatum is na..',
    'rule_trigger_book_date_after'                        => 'Boekdatum is na ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Verwerkingsdatum is op..',
    'rule_trigger_process_date_on'                        => 'Verwerkingsdatum is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Verwerkingsdatum is voor..',
    'rule_trigger_process_date_before'                    => 'Verwerkingsdatum is voor ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Verwerkingsdatum is na..',
    'rule_trigger_process_date_after'                     => 'Verwerkingsdatum is na ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Vervaldatum is op..',
    'rule_trigger_due_date_on'                            => 'Vervaldatum is ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Vervaldatum is voor..',
    'rule_trigger_due_date_before'                        => 'Vervaldatum is voor ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Vervaldatum is na..',
    'rule_trigger_due_date_after'                         => 'Vervaldatum is na ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Betalingsdatum is op..',
    'rule_trigger_payment_date_on'                        => 'Betalingsdatum is ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Betalingsdatum is voor..',
    'rule_trigger_payment_date_before'                    => 'Betalingsdatum is voor ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Betalingsdatum is na..',
    'rule_trigger_payment_date_after'                     => 'Betalingsdatum is na ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Factuurdatum is op..',
    'rule_trigger_invoice_date_on'                        => 'Factuurdatum is ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Factuurdatum is voor..',
    'rule_trigger_invoice_date_before'                    => 'Factuurdatum is voor ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Factuurdatum is na..',
    'rule_trigger_invoice_date_after'                     => 'Factuurdatum is na ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transactie werd gemaakt voor..',
    'rule_trigger_created_at_before'                      => 'Transactie werd gemaakt voor ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transactie werd gemaakt na..',
    'rule_trigger_created_at_after'                       => 'Transactie werd gemaakt na ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transactie werd laatst gewijzigd voor..',
    'rule_trigger_updated_at_before'                      => 'Transactie werd laatst gewijzigd voor ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transactie werd laatst gewijzigd na..',
    'rule_trigger_updated_at_after'                       => 'Transactie werd laatst gewijzigd na ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Bedrag in vreemde valuta is precies..',
    'rule_trigger_foreign_amount_is'                      => 'Bedrag in vreemde valuta is ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Bedrag in vreemde valuta is minder dan..',
    'rule_trigger_foreign_amount_less'                    => 'Bedrag in vreemde valuta is minder dan ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Bedrag in vreemde valuta is meer dan..',
    'rule_trigger_foreign_amount_more'                    => 'Bedrag in vreemde valuta is meer dan ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Er is een bijlage met naam..',
    'rule_trigger_attachment_name_is'                     => 'Er is een bijlage met naam ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Er is een bijlage waarvan de naam bevat..',
    'rule_trigger_attachment_name_contains'               => 'Er is een bijlage waarvan de naam ":trigger_value" bevat',
    'rule_trigger_attachment_name_starts_choice'          => 'Er is een bijlage waarvan de naam begint met..',
    'rule_trigger_attachment_name_starts'                 => 'Er is een bijlage waarvan de naam begint met ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Er is een bijlage waarvan de naam eindigt op..',
    'rule_trigger_attachment_name_ends'                   => 'Er is een bijlage waarvan de naam eindigt op ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Een bijlage\'s notitie is..',
    'rule_trigger_attachment_notes_are'                   => 'Er is een bijlage waarvan de notitie ":trigger_value" is',
    'rule_trigger_attachment_notes_contains_choice'       => 'Een bijlage\'s notitie bevat..',
    'rule_trigger_attachment_notes_contains'              => 'Er is een bijlage waarvan de notitie ":trigger_value" bevat',
    'rule_trigger_attachment_notes_starts_choice'         => 'Een bijlage\'s notitie begint met..',
    'rule_trigger_attachment_notes_starts'                => 'Er is een bijlage waarvan de notitie begint met ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Een bijlage\'s notitie eindigt op..',
    'rule_trigger_attachment_notes_ends'                  => 'Er is een bijlage waarvan de notitie eindigt op ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transactie is afgestemd',
    'rule_trigger_reconciled'                             => 'Transactie is afgestemd',
    'rule_trigger_exists_choice'                          => 'Elke transactie komt overeen(!)',
    'rule_trigger_exists'                                 => 'Elke transactie komt overeen',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Rekening-ID is niet ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Bronrekening-ID is niet ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Doelrekening-ID is niet ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transactietype is niet ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is niet ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Omschrijving is niet ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Omschrijving eindigt niet op ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Omschrijving begint niet met ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notitie is niet ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notitie bevat niet ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notitie eindigt niet op ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notitie begint niet met ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Bronrekening is niet ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Bronrekening bevat niet ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Bronrekening eindigt niet op ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Bronrekening begint niet met ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Bronrekeningnummer / IBAN is niet ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Bronrekeningnummer / IBAN bevat niet ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Bronrekeningnummer / IBAN eindigt niet op ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Bronrekeningnummer / IBAN begint niet met ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Doelrekening is niet ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Doelrekeningnaam bevat niet ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Doelrekening eindigt niet op ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Doelrekeningnaam begint niet met ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Doelrekeningnummer / IBAN is niet ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Doelrekeningnummer / IBAN bevat niet ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Doelrekeningnummer / IBAN eindigt niet op ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Doelrekeningnummer / IBAN start niet met ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Geen van beide rekeningen is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Geen van beide rekeningen bevat ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Geen van beide rekeningen eindigt op ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Geen van beide rekeningen begint met ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Geen van beide rekeningnummers / IBAN\'s is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Geen van beide rekeningnummers / IBAN\'s bevat ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Geen van beide rekeningnummers / IBAN\'s eindigt op ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Geen van beide rekeningnummers / IBAN\'s begint met ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Categorie is niet ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Categorie bevat niet ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Categorie eindigt niet op ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Categorie begint niet met ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is niet ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget bevat niet ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget eindigt niet op ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget begint niet met ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Abonnement is niet ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Abonnement bevat niet ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Abonnement eindigt niet op ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Abonnement eindigt niet op ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'Externe ID is niet ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'Externe ID bevat niet ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'Externe ID eindigt niet op ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'Externe ID begint niet met ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Interne referentie is niet ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Interne referentie bevat niet ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Interne referentie eindigt niet op ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Interne referentie begint niet met ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'Externe URL is niet ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'Externe URL bevat niet ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'Externe URL eindigt niet op ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'Externe URL begint niet met ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Valuta is niet ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Vreemde valuta is niet ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transactie-ID is niet ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transactiejournaal ID is ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Periodieke transactie-ID is niet ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Datum is niet op ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Datum is niet voor ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Datum is niet na ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Rentedatum is niet op ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Rentedatum is niet voor ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Rentedatum is niet na ":trigger_value"rente',
    'rule_trigger_not_book_date_on'                       => 'Boekdatum is niet ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Boekdatum is niet voor ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Boekdatum is niet na ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Verwerkingsdatum is niet op ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Verwerkingsdatum is niet voor ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Verwerkingsdatum is niet na ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Vervaldatum is niet op ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Vervaldatum is niet voor ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Vervaldatum is niet na ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Betalingsdatum is niet ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Betalingsdatum is niet voor ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Betalingsdatum is niet na ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Factuurdatum is niet op ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Factuurdatum is niet voor ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Factuurdatum is niet na ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transactie is niet gemaakt op ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transactie is niet gemaakt voor ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transactie is niet gemaakt na ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transactie is niet bijgewerkt op ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transactie is niet bijgewerkt voor ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transactie is niet bijgewerkt na ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transactiebedrag is niet ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transactiebedrag is meer dan ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transactiebedrag is minder dan ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Vreemde valutabedrag is niet ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Vreemde valutabedrag is meer dan ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Vreemde valutabedrag is minder dan ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'Geen bijlage met de naam ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'Geen bijlage waarvan de naam ":trigger_value" bevat',
    'rule_trigger_not_attachment_name_starts'             => 'Geen bijlage waarvan de naam begint met ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'Geen bijlage waarvan de naam eindigt op ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'Geen bijlagenotitie is ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'Geen bijlagenotitie bevat ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'Geen bijlagenotitie start met ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'Geen bijlagenotitie eindigt op ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transactie is niet afgestemd',
    'rule_trigger_not_exists'                             => 'Transactie bestaat niet',
    'rule_trigger_not_has_attachments'                    => 'Transactie heeft geen bijlagen',
    'rule_trigger_not_has_any_category'                   => 'Transactie heeft geen categorie',
    'rule_trigger_not_has_any_budget'                     => 'Transactie heeft geen budget',
    'rule_trigger_not_has_any_bill'                       => 'Transactie heeft geen abonnement',
    'rule_trigger_not_has_any_tag'                        => 'Transactie heeft geen tags',
    'rule_trigger_not_any_notes'                          => 'Transactie heeft geen notities',
    'rule_trigger_not_any_external_url'                   => 'De transactie heeft geen externe URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transactie heeft een bijlage',
    'rule_trigger_not_has_no_category'                    => 'Transactie heeft een (welke dan ook) categorie',
    'rule_trigger_not_has_no_budget'                      => 'Transactie heeft een (welke dan ook) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transactie heeft een (eender) abonnement',
    'rule_trigger_not_has_no_tag'                         => 'Transactie heeft een (welke dan ook) tag',
    'rule_trigger_not_no_notes'                           => 'Transactie heeft notities',
    'rule_trigger_not_no_external_url'                    => 'Transactie heeft een externe URL',
    'rule_trigger_not_source_is_cash'                     => 'Bronrekening is geen cash-rekening',
    'rule_trigger_not_destination_is_cash'                => 'Doelrekening is geen cash-rekening',
    'rule_trigger_not_account_is_cash'                    => 'Geen van beide rekeningen is een cash-rekening',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Doelrekeningsaldo is meer dan..',
    'rule_trigger_destination_balance_gte_choice'         => 'Doelrekeningsaldo is meer dan of gelijk aan..',
    'rule_trigger_destination_balance_is_choice'          => 'Doelrekeningsaldo is precies..',
    'rule_trigger_destination_balance_lt_choice'          => 'Doelrekeningsalso is minder dan..',
    'rule_trigger_destination_balance_lte_choice'         => 'Doelrekeningsaldo is minder dan of gelijk aan..',

    'rule_trigger_source_balance_gt_choice'  => 'Bronrekeningsaldo is meer dan..',
    'rule_trigger_source_balance_gte_choice' => 'Bronrekeningsaldo is meer dan of gelijk aan..',
    'rule_trigger_source_balance_is_choice'  => 'Bronrekeningsaldo is precies..',
    'rule_trigger_source_balance_lt_choice'  => 'Bronrekeningsaldo is minder dan..',
    'rule_trigger_source_balance_lte_choice' => 'Bronrekeningsaldo is minder dan of gelijk aan..',

    'rule_trigger_destination_balance_gt'  => 'Doelrekeningsaldo is meer dan :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Doelrekeningsaldo is meer dan of gelijk aan :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Doelrekeningsaldo is precies :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Doelrekeningsaldo is minder dan :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Doelrekeningsaldo is minder dan of gelijk aan :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Bronrekeningsaldo is meer dan :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Bronrekeningsaldo is meer dan of gelijk aan :trigger_value',
    'rule_trigger_source_balance_is'           => 'Bronrekening saldo is precies :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Bronrekening saldo is minder dan :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Bronrekening saldo is minder dan of gelijk aan :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Doelrekeningsaldo is minder dan of gelijk aan :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Doelrekeningsaldo is minder dan :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Doelrekeningsaldo is niet :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Doelrekeningsaldo is meer dan of gelijk aan :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Doelrekeningsaldo is meer dan :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Bronrekening saldo is minder dan of gelijk aan :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Bronrekening saldo is minder dan :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Bronrekening saldo is niet :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Bronrekeningsaldo is meer dan of gelijk aan :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Bronrekeningsaldo is meer dan :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'VERWIJDER transactie(!)',
    'rule_action_delete_transaction'             => 'VERWIJDER transactie(!)',
    'rule_action_set_category'                   => 'Verander categorie naar ":action_value"',
    'rule_action_clear_category'                 => 'Maak categorie-veld leeg',
    'rule_action_set_budget'                     => 'Sla op onder budget ":action_value"',
    'rule_action_clear_budget'                   => 'Sla op zonder budget',
    'rule_action_add_tag'                        => 'Voeg tag ":action_value" toe',
    'rule_action_remove_tag'                     => 'Haal tag ":action_value" weg',
    'rule_action_remove_all_tags'                => 'Haal alle tags weg',
    'rule_action_set_description'                => 'Geef omschrijving ":action_value"',
    'rule_action_append_description'             => 'Zet ":action_value" voor de omschrijving',
    'rule_action_prepend_description'            => 'Zet ":action_value" voor de omschrijving',
    'rule_action_set_category_choice'            => 'Stel categorie in op ..',
    'rule_action_clear_category_choice'          => 'Geef geen categorie',
    'rule_action_set_budget_choice'              => 'Stel budget in op ..',
    'rule_action_clear_budget_choice'            => 'Maak budget-veld leeg',
    'rule_action_add_tag_choice'                 => 'Voeg tag toe ..',
    'rule_action_remove_tag_choice'              => 'Haal tag weg ..',
    'rule_action_remove_all_tags_choice'         => 'Haal alle tags weg',
    'rule_action_set_description_choice'         => 'Stel omschrijving in op ..',
    'rule_action_update_piggy_choice'            => 'Voeg toe / verwijder het transactiebedrag in spaarpotje ..',
    'rule_action_update_piggy'                   => 'Voeg toe / verwijder het transactiebedrag in ":action_value"',
    'rule_action_append_description_choice'      => 'Zet .. achter de omschrijving',
    'rule_action_prepend_description_choice'     => 'Zet .. voor de omschrijving',
    'rule_action_set_source_account_choice'      => 'Verander bronrekening naar ..',
    'rule_action_set_source_account'             => 'Verander bronrekening naar ":action_value"',
    'rule_action_set_destination_account_choice' => 'Verander doelrekening naar ..',
    'rule_action_set_destination_account'        => 'Verander doelrekening naar ":action_value"',
    'rule_action_append_notes_choice'            => 'Vul notitie aan met ..',
    'rule_action_append_notes'                   => 'Vul notitie aan met ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Zet .. voor notitie',
    'rule_action_prepend_notes'                  => 'Zet tekst ":action_value" voor notitie',
    'rule_action_clear_notes_choice'             => 'Verwijder notitie',
    'rule_action_clear_notes'                    => 'Verwijder notitie',
    'rule_action_set_notes_choice'               => 'Stel notities in op ..',
    'rule_action_link_to_bill_choice'            => 'Koppel aan een abonnement..',
    'rule_action_link_to_bill'                   => 'Koppel aan abonnement ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Wissel bron- en doelrekening (alleen overschrijvingen!)',
    'rule_action_switch_accounts'                => 'Wissel bron- en doelrekening',
    'rule_action_set_notes'                      => 'Verander notitie in ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Verander de transactie in inkomsten',
    'rule_action_convert_deposit'                => 'Verander de transactie in inkomsten van ":action_value"',
    'rule_action_convert_withdrawal_choice'      => 'Verander de transactie in een uitgave',
    'rule_action_convert_withdrawal'             => 'Verander de transactie in een uitgave bij ":action_value"',
    'rule_action_convert_transfer_choice'        => 'Verander de transactie in een overschrijving',
    'rule_action_convert_transfer'               => 'Verander de transactie in een overschrijving met ":action_value"',
    'rule_action_append_descr_to_notes_choice'   => 'Voeg de omschrijving toe aan de transactienotities',
    'rule_action_append_notes_to_descr_choice'   => 'Voeg de transactienotities toe aan de omschrijving',
    'rule_action_move_descr_to_notes_choice'     => 'Vervang de huidige transactienotities door de omschrijving',
    'rule_action_move_notes_to_descr_choice'     => 'Vervang de huidige omschrijving door transactienotities',
    'rule_action_append_descr_to_notes'          => 'Voeg omschrijving toe aan notitie',
    'rule_action_append_notes_to_descr'          => 'Voeg notitie toe aan omschrijving',
    'rule_action_move_descr_to_notes'            => 'Notitie vervangen door omschrijving',
    'rule_action_move_notes_to_descr'            => 'Omschrijving vervangen door notitie',
    'rule_action_set_amount_choice'              => 'Stel bedrag in op ..',
    'rule_action_set_amount'                     => 'Stel bedrag in op ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Verander doelrekening naar (cash)-rekening',
    'rule_action_set_source_to_cash_choice'      => 'Verander bronrekening naar (cash)-rekening',
    'rulegroup_for_bills_title'                  => 'Regelgroep voor abonnementen',
    'rulegroup_for_bills_description'            => 'Een speciale regelgroep voor alle regels die betrekking hebben op abonnementen.',
    'rule_for_bill_title'                        => 'Automatisch gegenereerde regel voor abonnement ":name"',
    'rule_for_bill_description'                  => 'Deze regel is automatisch gegenereerd om te transacties te matchen met abonnement ":name".',
    'create_rule_for_bill'                       => 'Maak een nieuwe regel voor abonnement ":name"',
    'create_rule_for_bill_txt'                   => 'Goed bezig, je hebt nieuw abonnement ":name" gemaakt. Firefly III can automagisch naar je uitgaven kijken en deze koppelen aan dit abonnement. Als je bijvoorbeeld je huur betaalt wordt de uitgave gekoppeld aan abonnement "huur". Op die manier laat Firefly III je zien welke rekeningen nog betaald moeten worden en welke niet. Om dat te doen moet er een regel gemaakt worden. Firefly III heeft vast wat handige waardes ingevuld. Dubbelcheck deze. Als ze kloppen zal Firefly III automatisch de juiste uitgave aan het juiste abonnement koppelen. Kijk dus goed of de triggers kloppen en corrigeer waar nodig.',
    'new_rule_for_bill_title'                    => 'Regel voor abonnement ":name"',
    'new_rule_for_bill_description'              => 'Deze regel markeert uitgaven voor abonnement ":name".',

    'new_rule_for_journal_title'                => 'Regel gebaseerd op transactie ":description"',
    'new_rule_for_journal_description'          => 'Deze regel is gebaseerd op transactie ":description". Hij matcht met transacties die precies hetzelfde zijn.',

    // tags
    'store_new_tag'                             => 'Sla tag op',
    'update_tag'                                => 'Sla wijzigingen op',
    'no_location_set'                           => 'Zonder plaats',
    'meta_data'                                 => 'Metagegevens',
    'location'                                  => 'Plaats',
    'location_first_split'                      => 'De locatie voor deze transactie kan worden ingesteld bij de eerste splits van deze transactie.',
    'without_date'                              => 'Zonder datum',
    'result'                                    => 'Resultaat',
    'sums_apply_to_range'                       => 'Alle sommen gelden voor het geselecteerde bereik',
    'mapbox_api_key'                            => 'Om de kaart te gebruiken regel je een API-key bij <a href="https://www.mapbox.com/">Mapbox</a>. Open je <code>.env</code>-bestand en zet deze achter <code>MAPBOX_API_KEY=</code>.',
    'press_object_location'                     => 'Klik met de rechtermuisknop of druk lang om de locatie van het object in te stellen.',
    'click_tap_location'                        => 'Klik of tik op de kaart om een locatie toe te voegen',
    'clear_location'                            => 'Wis locatie',
    'delete_all_selected_tags'                  => 'Alle geselecteerde tags verwijderen',
    'select_tags_to_delete'                     => 'Vergeet niet om tags te selecteren.',
    'deleted_x_tags'                            => ':count tag verwijderd.|:count tags verwijderd.',
    'create_rule_from_transaction'              => 'Regel aanmaken op basis van een transactie',
    'create_recurring_from_transaction'         => 'Maak periodieke transactie gebaseerd op transactie',

    // preferences
    'test_notifications_buttons'                => 'Gebruik de knoppen hieronder om je configuratie te testen. Hou er rekening mee dat de knoppen geen spamcontrole hebben.',
    'dark_mode_option_browser'                  => 'Je browser bepaalt',
    'dark_mode_option_light'                    => 'Altijd licht',
    'dark_mode_option_dark'                     => 'Altijd donker',
    'equal_to_language'                         => '(zelfde als taal)',
    'dark_mode_preference'                      => 'Nachtmodus',
    'dark_mode_preference_help'                 => 'Stel nachtmodus in.',
    'pref_home_screen_accounts'                 => 'Voorpaginarekeningen',
    'pref_home_screen_accounts_help'            => 'Welke betaalrekeningen wil je op de voorpagina zien?',
    'pref_view_range'                           => 'Bereik',
    'pref_view_range_help'                      => 'Sommige grafieken worden automagisch gegroepeerd in periodes. Ook je budgetten zullen standaard in deze periode verdeeld worden. Welke periode mag het zijn?',
    'pref_1D'                                   => 'Eén dag',
    'pref_1W'                                   => 'Eén week',
    'pref_1M'                                   => 'Eén maand',
    'pref_3M'                                   => 'Drie maanden (kwartaal)',
    'pref_6M'                                   => 'Zes maanden',
    'pref_1Y'                                   => 'Eén jaar',
    'pref_last365'                              => 'Afgelopen jaar',
    'pref_last90'                               => 'Afgelopen 90 dagen',
    'pref_last30'                               => 'Afgelopen 30 dagen',
    'pref_last7'                                => 'Afgelopen 7 dagen',
    'pref_YTD'                                  => 'Jaar tot nu',
    'pref_QTD'                                  => 'Kwartaal tot nu',
    'pref_MTD'                                  => 'Maand tot nu',
    'pref_languages'                            => 'Talen',
    'pref_locale'                               => 'Lokale instellingen',
    'pref_languages_help'                       => 'Firefly III ondersteunt meerdere talen. Welke heeft jouw voorkeur?',
    'pref_locale_help'                          => 'Firefly III kan andere lokale instellingen gebruiken, die bepalen hoe valuta, nummers en datums worden weergegeven. De lijst hieronder is compleet maar niet alles wordt ondersteund door jouw systeem. Het kan zijn dat Firefly III bepaalde lokale instellingen niet lekker weergeeft; neem dan contact met me op.',
    'pref_locale_no_demo'                       => 'Deze functie werkt niet voor de demo-gebruiker.',
    'pref_convert_to_primary'                   => 'Bedragen in standaardvaluta tonen',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Instellingen voor boekjaar',
    'pref_custom_fiscal_year_label'             => 'Ingeschakeld',
    'pref_custom_fiscal_year_help'              => 'Voor in landen die een boekjaar gebruiken anders dan 1 januari tot 31 december',
    'pref_fiscal_year_start_label'              => 'Start van boekjaar',
    'pref_two_factor_auth'                      => 'Multi-factorauthenticatie',
    'pref_two_factor_auth_help'                 => 'Als je multi-factorauthenticatie (ook wel twee-factor authenticatie genoemd) inschakelt voeg je een extra beveiligingslaag toe aan je account. Je logt in met iets dat je weet (je wachtwoord) en iets dat je hebt (een verificatiecode). Verificatiecodes worden gegenereerd door apps op je telefoon, zoals Authy en Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Multi-factorauthenticatie inschakelen',
    'pref_two_factor_auth_disabled'             => 'Multi-factorauthenticatieverificatiecode verwijderd en uitgeschakeld',
    'pref_two_factor_auth_remove_it'            => 'Vergeet niet om je Firefly III account uit je authenticatie appje te verwijderen!',
    'pref_two_factor_auth_code'                 => 'Bevestig de code',
    'pref_two_factor_auth_code_help'            => 'Scan de QR-code met een app op uw je zoals Authy of Google Authenticator, en vul de gegenereerde code in. De QR-code verandert elke keer als je deze pagina bezoekt. Zorg dus dat je de meest recente code scant.',
    'pref_two_factor_auth_reset_code'           => 'Reset de verificatiecode',
    'pref_two_factor_auth_disable_2fa'          => 'MFA uitschakelen',
    '2fa_use_secret_instead'                    => 'Als je de QR code niet kan scannen gebruik dan de geheime code: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Sla deze backupcodes op zodat je toegang houdt als je je apparaat verliest.',
    '2fa_already_enabled'                       => 'Multi-factorauthenticatie is al ingeschakeld.',
    'wrong_mfa_code'                            => 'Deze code is niet geldig.',
    'pref_save_settings'                        => 'Instellingen opslaan',
    'saved_preferences'                         => 'Voorkeuren opgeslagen!',
    'preferences_general'                       => 'Algemeen',
    'preferences_frontpage'                     => 'Homepagina',
    'preferences_security'                      => 'Veiligheid',
    'preferences_layout'                        => 'Uiterlijk',
    'preferences_notifications'                 => 'Meldingen',
    'pref_home_show_deposits'                   => 'Laat inkomsten zien op de homepagina',
    'pref_home_show_deposits_info'              => 'De homepagina laat al crediteuren zien. Wil je ook je debiteuren zien?',
    'pref_home_do_show_deposits'                => 'Ja, kom maar op',
    'successful_count'                          => 'waarvan :count met succes',
    'list_page_size_title'                      => 'Paginalengte',
    'list_page_size_help'                       => 'Per lijst met dingen (accounts, transacties, enz.) zie je hooguit zoveel items.',
    'list_page_size_label'                      => 'Paginalengte',
    'between_dates'                             => '(:start en :end)',
    'pref_optional_fields_transaction'          => 'Optionele velden voor transacties',
    'pref_optional_fields_transaction_help'     => 'Standaard staan niet alle velden aan (vanwege het overzicht). Hier kan je zulke extra velden alsnog aanzetten, als je denkt dat ze handig zijn. Als je een veld uitzet, maar deze heeft wel degelijk een waarde, dan is-ie altijd zichtbaar, wat je ook doet.',
    'optional_tj_date_fields'                   => 'Datumvelden',
    'optional_tj_other_fields'                  => 'Overige velden',
    'optional_tj_attachment_fields'             => 'Bijlagen',
    'pref_optional_tj_interest_date'            => 'Rentedatum',
    'pref_optional_tj_book_date'                => 'Boekdatum',
    'pref_optional_tj_process_date'             => 'Verwerkingsdatum',
    'pref_optional_tj_due_date'                 => 'Vervaldatum',
    'pref_optional_tj_payment_date'             => 'Betalingsdatum',
    'pref_optional_tj_invoice_date'             => 'Factuurdatum',
    'pref_optional_tj_internal_reference'       => 'Interne referentie',
    'pref_optional_tj_notes'                    => 'Notities',
    'pref_optional_tj_attachments'              => 'Bijlagen',
    'pref_optional_tj_external_url'             => 'Externe URL',
    'pref_optional_tj_location'                 => 'Locatie',
    'pref_optional_tj_links'                    => 'Transactiekoppelingen',
    'optional_field_meta_dates'                 => 'Data',
    'optional_field_meta_business'              => 'Zakelijk',
    'optional_field_attachments'                => 'Bijlagen',
    'optional_field_meta_data'                  => 'Optionele meta-gegevens',
    'external_url'                              => 'Externe URL',
    'pref_notification_login_failure'           => 'Mislukte login',
    'pref_notification_bill_reminder'           => 'Herinnering over het verlopen van abonnementen',
    'pref_notification_new_access_token'        => 'Melding wanneer een nieuwe API-toegangstoken wordt aangemaakt',
    'pref_notification_transaction_creation'    => 'Melding wanneer een transactie automatisch wordt aangemaakt',
    'pref_notification_user_login'              => 'Melding wanneer je inlogt vanaf een nieuwe locatie',
    'pref_notification_rule_action_failures'    => 'Waarschuwing als regelacties niet lukken (niet over email)',
    'pref_notification_new_password'            => 'Je wachtwoord is gewijzigd',
    'pref_notification_enabled_mfa'             => 'Multi-factorauthenticatie is ingeschakeld',
    'pref_notification_disabled_mfa'            => 'Multi-factorauthenticatie is uitgeschakeld',
    'pref_notification_few_left_mfa'            => 'Je hebt nog maar een paar back-upcodes',
    'pref_notification_no_left_mfa'             => 'Je hebt geen paar back-upcodes meer',
    'pref_notification_many_failed_mfa'         => 'Multi-factorauthenticatie blijft mislukken',
    'pref_notification_new_backup_codes'        => 'Nieuwe back-upcodes zijn gegenereerd',
    'pref_notifications'                        => 'Meldingen',
    'pref_notifications_help'                   => 'Geef aan of dit meldingen zijn die je zou willen krijgen. Sommige meldingen kunnen gevoelige financiële informatie bevatten.',
    'pref_notifications_settings'               => 'Meldingsinstellingen',
    'pref_notifications_settings_help'          => 'Gebruik deze instellingen om je meldingskanalen te configureren. Houd er rekening mee dat meldingen worden verzonden naar alle kanalen. Sla je instellingen eerst op.',
    'slack_url_label'                           => 'Slack "binnenkomende webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Wisselkoersen',
    'header_exchange_rates'                     => 'Wisselkoersen',
    'exchange_rates_intro'                      => 'Firefly III kan wisselkoersen downloaden en gebruiken. Lees hier meer over in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">de documentatie</a>.',
    'exchange_rates_from_to'                    => 'Tussen {from} en {to} (en andersom)',
    'header_exchange_rates_rates'               => 'Wisselkoersen',
    'exchange_rates_intro_rates'                => 'Firefly III gebruikt de volgende wisselkoersen. De inverse berekent zichzelf als deze niet is opgegeven. Als er geen wisselkoers bestaat voor de datum van de transactie, gaat Firefly III terug in de tijd om er een te vinden. Als er geen aanwezig is, zal de koers "1" gebruikt worden.',
    'header_exchange_rates_table'               => 'Tabel met wisselkoersen',
    'help_rate_form'                            => 'Hoeveel {to} krijg je op deze dag voor één {from}?',
    'save_new_rate'                             => 'Nieuwe wisselkoers opslaan',
    'add_new_rate'                              => 'Nieuwe wisselkoers toevoegen',
    'not_enough_currencies'                     => 'Niet genoeg valuta\'s',
    'not_enough_currencies_enabled'             => 'Als je slechts één valuta ingeschakeld hebt, gaan we geen wisselkoersen invoeren natuurlijk.',

    // Financial administrations
    'administration_index'                      => 'Financiële administratie',
    'administrations_breadcrumb'                => 'Grootboeken',
    'administrations_page_title'                => 'Grootboeken',
    'administrations_index_menu'                => 'Grootboeken',
    'administrations_page_sub_title'            => 'Overzicht',
    'create_administration'                     => 'Maak nieuw grootboek',
    'administration_owner'                      => 'Grootboekeigenaar: {{email}}',
    'administration_you'                        => 'Jouw rol: {{role}}',
    'other_users_in_admin'                      => 'Andere gebruikers van dit grootboek',
    'administrations_create_breadcrumb'         => 'Maak nieuw grootboek',
    'administrations_page_create_sub_title'     => 'Maak nieuw grootboek',
    'basic_administration_information'          => 'Standaard grootboekinformatie',
    'new_administration_created'                => 'Nieuw grootboek "{{title}}" is aangemaakt',
    'edit_administration_breadcrumb'            => 'Wijzig grootboek ":title"',
    'administrations_page_edit_sub_title'       => 'Wijzig grootboek ":title"',
    'administrations_page_edit_sub_title_js'    => 'Wijzig grootboek "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Grootboek ":title" is aangepast',
    'flash_administration_created'              => 'Grootboek ":title" is aangemaakt',
    'flash_administration_deleted'              => 'Grootboek ":title" is verwijderd',

    // roles
    'administration_role_owner'                 => 'Eigenaar',
    'administration_role_ro'                    => 'Alleen lezen',
    'administration_role_mng_trx'               => 'Transacties beheren',
    'administration_role_mng_meta'              => 'Beheer indeling en metadata',
    'administration_role_mng_budgets'           => 'Beheer budgetten',
    'administration_role_mng_piggies'           => 'Beheer spaarpotjes',
    'administration_role_mng_subscriptions'     => 'Beheer abonnementen',
    'administration_role_mng_rules'             => 'Beheer regels',
    'administration_role_mng_recurring'         => 'Beheer periodieke transacties',
    'administration_role_mng_webhooks'          => 'Beheer webhooks',
    'administration_role_mng_currencies'        => 'Valuta beheren',
    'administration_role_view_reports'          => 'Rapporten bekijken',
    'administration_role_full'                  => 'Volledige toegang',

    // mfa
    'enable_mfa'                                => 'Multi-factorauthenticatie inschakelen',
    'mfa_index_title'                           => 'Multi-factorauthenticatie',
    'mfa_index_intro'                           => 'Firefly III ondersteunt multi-factor authenticatie (MFA). Je kunt MFA voor je account inschakelen om een extra beveiligingslaag toe te voegen. Applicaties zoals Authy, Google Authenticator en FreeOTP kunnen worden gebruikt om de codes te genereren die je nodig hebt om in te loggen. Beveiligingssleutels worden niet ondersteund door Firefly III, maar je kunt een beveiligingssleutel gebruiken als opslaglocatie voor je MFA-geheim.',
    'mfa_index_enabled'                         => 'Multi-factorauthenticatie is ingeschakeld voor je account.',
    'mfa_index_disabled'                        => 'Multi-factorauthenticatie is niet ingeschakeld voor je account.',
    'mfa_index_owner'                           => 'De eigenaar van deze installatie kan multi-factorauthenticatie voor je account uitschakelen.',
    'current_password_confirm_mfa'              => 'Voer je huidige wachtwoord in ',
    'mfa_warning_code_changes'                  => 'Je krijgt misschien een dialoogvenster nadat je je wachtwoord en een MFA-code hebt ingevoerd. Wacht dan een paar seconden op de volgende MFA-code, de code die je net ingevoerd hebt zal niet werken.',
    'mfa_already_disabled'                      => 'Multi-factorauthenticatie is niet ingeschakeld voor je account, dus je kan dit niet uitschakelen.',
    'disable_mfa_page'                          => 'Multi-factorauthenticatie uitschakelen',
    'disable_mfa_intro'                         => 'Je kan multi-factorauthenticatie uitschakelen. Voer hiervoor je wachtwoord en een multi-factorauthenticatie code in. Als je multi-factorauthenticatie wilt uitschakelen omdat je geen toegang meer hebt tot je code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">raadpleeg de documentatie</a>.',
    'pref_disable_mfa'                          => 'Multi-factorauthenticatie uitschakelen',
    'mfa_not_enabled'                           => 'Multi-factorauthenticatie is niet ingeschakeld.',
    'mfa_backup_codes_intro'                    => 'Firefly III kan back-upcodes genereren. Deze codes kunnen worden gebruikt om in te loggen wanneer je je code generator niet kunt gebruiken. Je kunt op elk moment een nieuwe set codes genereren. Als je een nieuwe set aanmaakt, wordt de oude set ongeldig.',
    'mfa_backup_codes_quick'                    => 'Als je heel snel door de setup van multi-factorauthenticatie gaat, heeft je app mogelijk nog geen nieuwe code gegenereerd. Weet dat MFA-codes slechts één keer gebruikt kunnen worden. Zorg ervoor dat je een andere code gebruikt dan de vorige.',
    'mfa_backup_codes_title'                    => 'Multi-factorauthenticatie back-upcodes',
    'mfa_backup_codes_post_title'               => 'Multi-factorauthenticatie back-upcodes',

    // profile:
    'manage_mfa_settings'                       => 'Multi-factorauthenticatie-instellingen beheren',
    'purge_data_title'                          => 'Gegevens wissen uit Firefly III',
    'purge_data_expl'                           => '"Wissen" betekent "verwijderen wat al is verwijderd". In normale omstandigheden verwijdert Firefly III niets definitief. Het verbergt het. De knop hieronder verwijdert al deze eerder "verwijderd" items VOOR ALTIJD.',
    'delete_stuff_header'                       => 'Gegevens verwijderen en wissen',
    'purge_all_data'                            => 'Wis alle verwijderde items',
    'purge_data'                                => 'Gegevens wissen',
    'purged_all_records'                        => 'Alle verwijderde records zijn gewist.',
    'delete_data_title'                         => 'Gegevens verwijderen uit Firefly III',
    'permanent_delete_stuff'                    => 'Je kan dingen verwijderen uit Firefly III. Met de knoppen hieronder kan je de genoemde items verwijderen en verbergen. Dit kan je niet ongedaan maken, tenzij je in de database gaat grutten naar de originele data.',
    'other_sessions_logged_out'                 => 'Al je andere sessies zijn uitgelogd.',
    'delete_unused_accounts'                    => 'Als je ongebruikte accounts verwijdert, worden ze ook uit je autocomplete-lijsten gewist.',
    'delete_all_unused_accounts'                => 'Ongebruikte accounts verwijderen',
    'deleted_all_unused_accounts'               => 'Alle ongebruikte accounts zijn verwijderd',
    'delete_all_budgets'                        => 'Verwijder ALLE budgetten',
    'delete_all_categories'                     => 'Verwijder ALLE categorieën',
    'delete_all_tags'                           => 'Verwijder ALLE tags',
    'delete_all_bills'                          => 'Verwijder AL je abonnementen',
    'delete_all_piggy_banks'                    => 'Verwijder AL je spaarpotjes',
    'delete_all_rules'                          => 'Verwijder AL je regels',
    'delete_all_recurring'                      => 'Verwijder AL je periodieke transacties',
    'delete_all_object_groups'                  => 'Verwijder AL je objectgroepen',
    'delete_all_accounts'                       => 'Verwijder AL je rekeningen',
    'delete_all_asset_accounts'                 => 'Verwijder AL je betaalrekeningen',
    'delete_all_expense_accounts'               => 'Verwijder AL je crediteuren',
    'delete_all_revenue_accounts'               => 'Verwijder AL je debiteuren',
    'delete_all_liabilities'                    => 'Verwijder AL je passiva',
    'delete_all_transactions'                   => 'Verwijder AL je transacties',
    'delete_all_withdrawals'                    => 'Verwijder AL je uitgaven',
    'delete_all_deposits'                       => 'Verwijder AL je inkomsten',
    'delete_all_transfers'                      => 'Verwijder AL je overschrijvingen',
    'also_delete_transactions'                  => 'Het verwijderen van rekeningen betekent dat ALLE bijbehorende transacties OOK worden verwijderd!',
    'deleted_all_budgets'                       => 'Alle budgets zijn verwijderd',
    'deleted_all_categories'                    => 'Alle categorieën zijn verwijderd',
    'deleted_all_tags'                          => 'Alle tags zijn verwijderd',
    'deleted_all_bills'                         => 'Al je abonnementen zijn verwijderd',
    'deleted_all_piggy_banks'                   => 'Al je spaarpotjes zijn verwijderd',
    'deleted_all_rules'                         => 'Al je regels en regelgroepen zijn verwijderd',
    'deleted_all_object_groups'                 => 'Al je groepen zijn verwijderd',
    'deleted_all_accounts'                      => 'Al je rekeningen zijn verwijderd',
    'deleted_all_asset_accounts'                => 'Al je betaalrekeningen zijn verwijderd',
    'deleted_all_expense_accounts'              => 'Al je crediteuren zijn verwijderd',
    'deleted_all_revenue_accounts'              => 'Al je debiteuren zijn verwijderd',
    'deleted_all_liabilities'                   => 'Al je passiva zijn verwijderd',
    'deleted_all_transactions'                  => 'Al je transacties zijn verwijderd',
    'deleted_all_withdrawals'                   => 'Al je uitgaven zijn verwijderd',
    'deleted_all_deposits'                      => 'Al je inkomsten zijn verwijderd',
    'deleted_all_transfers'                     => 'Al je overschrijvingen zijn verwijderd',
    'deleted_all_recurring'                     => 'Al je periodiek transacties zijn verwijderd',
    'change_your_password'                      => 'Verander je wachtwoord',
    'delete_account'                            => 'Verwijder je account',
    'current_password'                          => 'Huidige wachtwoord',
    'new_password'                              => 'Nieuw wachtwoord',
    'new_password_again'                        => 'Nieuw wachtwoord (bevestiging)',
    'delete_your_account'                       => 'Verwijder je account',
    'delete_your_account_help'                  => 'Als je je account verwijdert worden ook al je rekeningen, transacties en <em>alle andere zaken</em> verwijderd. Alles is dan WEG.',
    'delete_your_account_password'              => 'Voer je wachtwoord in om door te gaan.',
    'password'                                  => 'Wachtwoord',
    'are_you_sure'                              => 'Zeker weten? Je kan niet meer terug!',
    'are_you_sure_confirm'                      => 'Weet je het zeker?',
    'delete_account_button'                     => 'VERWIJDER je account',
    'invalid_current_password'                  => 'Huidige wachtwoord is niet geldig!',
    'password_changed'                          => 'Je wachtwoord is veranderd!',
    'should_change'                             => 'Vul ook echt een ander wachtwoord in.',
    'invalid_password'                          => 'Ongeldig wachtwoord!',
    'what_is_pw_security'                       => 'Wat is "Bevestig wachtwoordsterkte"?',
    'secure_pw_title'                           => 'Hoe kies je een veilig wachtwoord',
    'forgot_password_response'                  => 'Bedankt. Als er een account bestaat met dit e-mailadres, vind je de instructies in je inbox.',
    'secure_pw_history'                         => 'Elke week lees je wel hoe sites de wachtwoorden van hun gebruikers verliezen. Hackers en dieven gebruiken deze wachtwoorden om te kijken of ze je persoonsgegevens kunnen buitmaken. Deze gegevens zijn geld waard.',
    'secure_pw_ff'                              => 'Gebruik je overal hetzelfde wachtwoord? Als één site je wachtwoord kwijt raakt hebben hackers toegang tot al je data. Firefly III rekent er op dat je een sterk en uniek wachtwoord kiest om je financiële gegevens te beschermen.',
    'secure_pw_check_box'                       => 'Om je daarbij te helpen kan Firefly III checken of het wachtwoord dat je wilt gebruiken is gestolen in het verleden. Als dat zo is, raadt Firefly III je aan om dat wachtwoord NIET te gebruiken.',
    'secure_pw_working_title'                   => 'Hoe werkt het?',
    'secure_pw_working'                         => 'Als je het vinkje aanvinkt stuurt Firefly III de eerste vijf karakters van de SHA1-hash van je wachtwoord naar <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">de website van Troy Hunt</a> om te zien of-ie op de lijst staat. Dit voorkomt dat je een onveilig wachtwoord gebruikt, zoals is voorgeschreven in <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">een speciale publicatie van het NIST</a> over dit onderwerp.',
    'secure_pw_should'                          => 'Vinkje zetten of niet?',
    'secure_pw_long_password'                   => 'Ja. Controleer altijd of je wachtwoord is veilig.',
    'command_line_token'                        => 'Opdrachtprompt-token',
    'explain_command_line_token'                => 'Je hebt dit token nodig als je commando\'s op de commandline draait, zoals het exporteren van data. Zonder dit token werkt die gevoelige opdracht niet. Deel je opdrachtprompt-token niet. Niemand zal hier naar vragen, zelfs ik niet. Als je bang bent dat-ie op straat ligt, genereer dan een nieuw token.',
    'regenerate_command_line_token'             => 'Nieuw opdrachtprompt-token genereren',
    'token_regenerated'                         => 'Er is een nieuw opdrachtprompt-token gegenereerd',
    'change_your_email'                         => 'Verander je emailadres',
    'email_verification'                        => 'Het systeem verstuurt een mailtje naar je oude EN nieuwe emailadres. Uit veiligheidsoverwegingen ben je zometeen uitgelogd en kan je pas weer inloggen als je je emailadres hebt bevestigd. Doe dit niet als je niet zeker weet of je Firefly III installatie wel mail kan versturen. Als je een admin bent, test dit dan eerst in de <a href="settings">instellingen</a>.',
    'email_changed_logout'                      => 'Je kan niet inloggen tot je je emailadres bevestigd.',
    'login_with_new_email'                      => 'Je kan nu inloggen met je nieuwe emailadres.',
    'login_with_old_email'                      => 'Je kan nu weer inloggen met je oude emailadres.',
    'login_provider_local_only'                 => 'Je kan dit niet doen als je inlogt via ":login_provider".',
    'external_user_mgt_disabled'                => 'Deze actie is niet beschikbaar wanneer Firefly III niet verantwoordelijk is voor gebruikersbeheer of authenticatie.',
    'external_auth_disabled'                    => 'Deze actie is niet beschikbaar wanneer Firefly III niet verantwoordelijk is voor authenticatie.',
    'delete_local_info_only'                    => "Omdat Firefly III niet verantwoordelijk is voor gebruikersbeheer of authenticatie zal deze functie alleen de lokale Firefly III informatie verwijderen.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth Clients',
    'profile_oauth_no_clients'                  => 'Je hebt nog geen OAuth-clients aangemaakt.',
    'profile_oauth_clients_external_auth'       => 'Als je een externe verificatieprovider zoals Authelia gebruikt, dan zullen OAuth Clients niet werken. Je kan alleen persoonlijke toegangstokens gebruiken.',
    'profile_oauth_clients_header'              => 'Clients',
    'profile_oauth_client_id'                   => 'Client ID',
    'profile_oauth_client_name'                 => 'Naam',
    'profile_oauth_client_secret'               => 'Secret',
    'profile_oauth_create_new_client'           => 'Nieuwe client aanmaken',
    'profile_oauth_create_client'               => 'Client aanmaken',
    'profile_oauth_edit_client'                 => 'Client bewerken',
    'profile_oauth_name_help'                   => 'Iets dat je gebruikers herkennen en vertrouwen.',
    'profile_oauth_redirect_url'                => 'Redirect-URL',
    'profile_oauth_redirect_url_help'           => 'De authorisatie-callback-url van jouw applicatie.',
    'profile_authorized_apps'                   => 'Geautoriseerde toepassingen',
    'profile_authorized_clients'                => 'Geautoriseerde clients',
    'profile_scopes'                            => 'Scopes',
    'profile_revoke'                            => 'Intrekken',
    'profile_oauth_client_secret_title'         => 'Client secret',
    'profile_oauth_client_secret_expl'          => 'Hier is je nieuwe client secret. Dit is de enige keer dat deze getoond wordt dus verlies deze niet! Je kan dit secret gebruiken om API-aanvragen te maken.',
    'profile_personal_access_tokens'            => 'Persoonlijke toegangstokens',
    'profile_personal_access_token'             => 'Persoonlijk toegangstoken',
    'profile_oauth_confidential'                => 'Vertrouwelijk',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Hier is je nieuwe persoonlijke toegangstoken. Dit is de enige keer dat deze getoond wordt dus verlies deze niet! Je kan deze toegangstoken gebruiken om API-aanvragen te maken.',
    'profile_no_personal_access_token'          => 'Je hebt nog geen persoonlijke toegangstokens aangemaakt.',
    'profile_create_new_token'                  => 'Nieuwe token aanmaken',
    'profile_create_token'                      => 'Token aanmaken',
    'profile_create'                            => 'Creër',
    'profile_save_changes'                      => 'Aanpassingen opslaan',
    'profile_whoops'                            => 'Oeps!',
    'profile_something_wrong'                   => 'Er is iets mis gegaan!',
    'profile_try_again'                         => 'Er is iets misgegaan. Probeer het nogmaals.',
    'amounts'                                   => 'Bedragen',
    'multi_account_warning_unknown'             => 'Afhankelijk van het type transactie wordt de bron- en/of doelrekening overschreven door wat er in de eerste split staat.',
    'multi_account_warning_withdrawal'          => 'De bronrekening wordt overschreven door wat er in de eerste split staat.',
    'multi_account_warning_deposit'             => 'De doelrekening wordt overschreven door wat er in de eerste split staat.',
    'multi_account_warning_transfer'            => 'De bron + doelrekening wordt overschreven door wat er in de eerste split staat.',


    // export data:
    'export_data_title'                         => 'Gegevens exporteren uit Firefly III',
    'export_data_menu'                          => 'Exporteren',
    'export_data_bc'                            => 'Gegevens exporteren uit Firefly III',
    'export_data_main_title'                    => 'Gegevens exporteren uit Firefly III',
    'export_data_expl'                          => 'Met deze link kan je alle transacties + metadata uit Firefly III exporteren. Raadpleeg de help ((?)-pictogram) voor meer informatie over het proces.',
    'export_data_all_transactions'              => 'Exporteer alle transacties',
    'export_data_advanced_expl'                 => 'Als je een meer geavanceerde opties nodig hebt of specifieke data wilt exporteren, lees dan de hulp over het gebruik van het console commando <code>php artisan help firefly-iii:export -data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Eén bijlage|:count bijlagen',
    'attachments'                               => 'Bijlagen',
    'edit_attachment'                           => 'Wijzig bijlage ":name"',
    'update_attachment'                         => 'Update bijlage',
    'delete_attachment'                         => 'Verwijder bijlage ":name"',
    'attachment_deleted'                        => 'Bijlage ":name" verwijderd',
    'liabilities_deleted'                       => 'Passiva ":name" verwijderd',
    'attachment_updated'                        => 'Attachment ":name" geüpdatet',
    'upload_max_file_size'                      => 'Maximale grootte: :size',
    'list_all_attachments'                      => 'Lijst van alle bijlagen',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Omdat deze transactie al is afgestemd, kan je het bedrag noch de rekeningen wijzigen. Tenzij je het vinkje weghaalt.',
    'is_reconciled'                             => 'Is afgestemd',
    'title_expenses'                            => 'Uitgaven',
    'title_withdrawal'                          => 'Uitgaven',
    'title_revenue'                             => 'Inkomsten',
    'title_deposit'                             => 'Inkomsten',
    'title_transfer'                            => 'Overschrijvingen',
    'title_transfers'                           => 'Overschrijvingen',
    'submission_options'                        => 'Inzending opties',
    'apply_rules_checkbox'                      => 'Regels toepassen',
    'fire_webhooks_checkbox'                    => 'Webhooks starten',
    'select_source_account'                     => 'Selecteer of type een geldige bronrekeningnaam',
    'select_dest_account'                       => 'Selecteer of type een geldige doelrekeningnaam',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Deze transactie is al een uitgave',
    'convert_is_already_type_Deposit'           => 'Deze transactie is al inkomsten',
    'convert_is_already_type_Transfer'          => 'Deze transactie is al een overschrijving',
    'convert_to_Withdrawal'                     => 'Verander ":description" in een uitgave',
    'convert_to_Deposit'                        => 'Verander ":description" in inkomsten',
    'convert_to_Transfer'                       => 'Verander ":description" in een overschrijving',
    'convert_options_WithdrawalDeposit'         => 'Verander een uitgave in inkomsten',
    'convert_options_WithdrawalTransfer'        => 'Verander een uitgave in een overschrijving',
    'convert_options_DepositTransfer'           => 'Verander inkomsten in een overschrijving',
    'convert_options_DepositWithdrawal'         => 'Verander inkomsten in een uitgave',
    'convert_options_TransferWithdrawal'        => 'Verander een overschrijving in een uitgave',
    'convert_options_TransferDeposit'           => 'Verander een overschrijving in inkomsten',
    'convert_Withdrawal_to_deposit'             => 'Verander deze uitgave in inkomsten',
    'convert_Withdrawal_to_transfer'            => 'Verander deze uitgave in een overschrijving',
    'convert_Deposit_to_withdrawal'             => 'Verander deze inkomsten in een uitgave',
    'convert_Deposit_to_transfer'               => 'Verander deze inkomsten in een overschrijving',
    'convert_Transfer_to_deposit'               => 'Verander deze overschrijving in inkomsten',
    'convert_Transfer_to_withdrawal'            => 'Verander deze overschrijving in een uitgave',
    'convert_please_set_revenue_source'         => 'Kies de debiteur waar het geld vandaan gaat komen.',
    'convert_please_set_asset_destination'      => 'Kies de betaalrekening waar het geld heen zal gaan.',
    'convert_please_set_expense_destination'    => 'Kies de crediteur waar het geld heen zal gaan.',
    'convert_please_set_asset_source'           => 'Kies de betaalrekening waar het geld vandaan zal komen.',
    'convert_expl_w_d'                          => 'Als je de transactie converteert van een uitgave naar inkomsten, wordt het geld gestort in de weergegeven doelrekening, in plaats van dat het er uit gehaald wordt. Kies de nieuwe bronrekening om de conversie af te maken.|Als je de transactie converteert van een uitgave naar inkomsten, wordt het geld gestort in de weergegeven doelrekeningen, in plaats van dat het er uit gehaald wordt.',
    'convert_expl_w_t'                          => 'Als je een uitgave in een overschrijving converteert, wordt het geld overgemaakt van de bronrekening naar een andere betaalrekening of passiva in plaats van dat je het uitgeeft.|Als je een uitgave in een overschrijving converteert, wordt het geld overgemaakt van de bronrekeningen naar een andere betaalrekening of passiva in plaats van dat je het uitgeeft.',
    'convert_expl_d_w'                          => 'Als je inkomsten converteert naar een uitgave wordt het geld uitgegeven vanaf de aangegeven bronrekening in plaats van dat het daar wordt gestort.|Als je inkomsten converteert naar een uitgave wordt het geld uitgegeven vanaf de aangegeven bronrekeningen in plaats van dat het daar wordt gestort.',
    'convert_expl_d_t'                          => 'Wanneer je inkomsten in een overschrijving converteert, wordt het geld overgemaakt van de bronrekening naar een andere betaalrekening of passiva in plaats van dat je het uitgeeft.|Wanneer je inkomsten in een overschrijving converteert, wordt het geld overgemaakt van de bronrekeningen naar een andere betaalrekening of passiva in plaats van dat je het uitgeeft.',
    'convert_expl_t_w'                          => 'Als je converteert van een overschrijving naar een afschrijving wordt het geld uitgegeven bij de hier genoemde doelrekening in plaats van dat het wordt afgeschreven van de originele bronrekening.|Als je converteert van een overschrijving naar een afschrijving wordt het geld uitgegeven bij de hier genoemde doelrekeningen in plaats van dat het wordt afgeschreven van de originele bronrekeningen.',
    'convert_expl_t_d'                          => 'Als je een overschrijving converteert naar inkomsten wordt het geld gestort op de doelrekening die je hier ziet, in plaats van dat het als inkomsten binnenkomt. Kies de nieuwe bronrekening om de conversie af te maken.|Als je een overschrijving converteert naar inkomsten wordt het geld gestort op de doelrekeningen die je hier ziet, in plaats van dat het als inkomsten binnenkomt.',
    'convert_select_sources'                    => 'Kies de nieuwe bronrekening om de conversie af te maken.|Kies de nieuwe bronrekeningen om de conversie af te maken.',
    'convert_select_destinations'               => 'Kies de nieuwe doelrekening om de conversie af te maken.|Kies de nieuwe doelrekeningen om de conversie af te maken.',
    'converted_to_Withdrawal'                   => 'De transactie is veranderd in een uitgave',
    'converted_to_Deposit'                      => 'De transactie is veranderd in inkomsten',
    'converted_to_Transfer'                     => 'De transactie is veranderd in een overschrijving',
    'invalid_convert_selection'                 => 'De rekening die je hebt geselecteerd wordt al gebruikt in deze transactie, of bestaat niet.',
    'source_or_dest_invalid'                    => 'Kan de juiste transactiegegevens niet vinden. Conversie is niet mogelijk.',
    'convert_to_withdrawal'                     => 'Converteren naar een uitgave',
    'convert_to_deposit'                        => 'Converteer naar inkomsten',
    'convert_to_transfer'                       => 'Converteren naar een overschrijving',

    // create new stuff:
    'create_new_withdrawal'                     => 'Nieuwe uitgave',
    'create_new_deposit'                        => 'Nieuwe inkomsten',
    'create_new_transfer'                       => 'Nieuwe overschrijving',
    'create_new_asset'                          => 'Nieuwe betaalrekening',
    'create_new_liabilities'                    => 'Maak nieuwe passiva',
    'create_new_expense'                        => 'Nieuwe crediteur',
    'create_new_revenue'                        => 'Nieuwe debiteur',
    'create_new_piggy_bank'                     => 'Nieuw spaarpotje',
    'create_new_bill'                           => 'Maak een nieuw abonnement',
    'create_new_subscription'                   => 'Maak een nieuw abonnement',
    'create_new_rule'                           => 'Maak een nieuwe regel',

    // currencies:
    'create_currency'                           => 'Voeg nieuwe valuta toe',
    'store_currency'                            => 'Sla nieuwe valuta op',
    'update_currency'                           => 'Wijzig valuta',
    'new_default_currency'                      => '":name" is nu de standaardvaluta.',
    'default_currency_failed'                   => 'Kan ":name" niet de standaardvaluta maken. Check de logs.',
    'cannot_delete_currency'                    => 'Kan ":name" niet verwijderen, want deze is in gebruik.',
    'cannot_delete_fallback_currency'           => ':naam is de systeemvaluta en kan niet verwijderd worden.',
    'cannot_disable_currency_journals'          => 'Je kan :name niet uitschakelen, er zijn nog transacties die deze valuta gebruiken.',
    'cannot_disable_currency_last_left'         => 'Je kan :name niet uitschakelen, het is de laatste beschikbare valuta.',
    'cannot_disable_currency_account_meta'      => 'Je kan :name niet uitschakelen, er zijn nog betaalrekeningen die deze valuta gebruiken.',
    'cannot_disable_currency_bills'             => 'Je kan :name niet uitschakelen, er zijn nog abonnementen die deze valuta gebruiken.',
    'cannot_disable_currency_recurring'         => 'Je kan :name niet uitschakelen, er zijn nog herhalende transacties die deze valuta gebruiken.',
    'cannot_disable_currency_available_budgets' => 'Je kan :name niet uitschakelen, er zijn nog budgetten die deze valuta gebruiken.',
    'cannot_disable_currency_budget_limits'     => 'Je kan :name niet uitschakelen, er zijn nog budgetlimieten die deze valuta gebruiken.',
    'cannot_disable_currency_current_default'   => 'Je kan :name niet uitschakelen, het is de standaardvaluta.',
    'cannot_disable_currency_system_fallback'   => 'Je kan :name niet uitschakelen, het is de standaardvaluta van Firefly III.',
    'disable_EUR_side_effects'                  => 'De euro is de standardvaluta van Firefly III. Als je die uitzet kan het zijn dat je dingen sloopt. Doe dit op eigen risico.',
    'deleted_currency'                          => 'Valuta :name verwijderd',
    'created_currency'                          => 'Nieuwe valuta :name opgeslagen',
    'could_not_store_currency'                  => 'Kon nieuwe valuta niet opslaan.',
    'updated_currency'                          => 'Valuta :name bijgewerkt',
    'ask_site_owner'                            => 'Vraag :owner of deze valuta wilt toevoegen, verwijderen of wijzigen.',
    'currencies_intro'                          => 'Firefly III ondersteunt diverse valuta die je hier kan instellen en bewerken.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Maak standaard',
    'default_currency'                          => 'standaard',
    'primary_currency_button'                   => 'standaard',
    'currency_is_disabled'                      => 'Uitgeschakeld',
    'enable_currency'                           => 'Inschakelen',
    'disable_currency'                          => 'Uitschakelen',
    'currencies_default_disabled'               => 'De meeste van deze valuta zijn standaard uitgeschakeld. Om ze te gebruiken, moet je ze eerst inschakelen.',
    'currency_is_now_enabled'                   => 'Valuta ":name" is ingeschakeld',
    'could_not_enable_currency'                 => 'Kon valuta ":name" niet inschakelen. Check de logs',
    'currency_is_now_disabled'                  => 'Valuta ":name" is uitgeschakeld',
    'could_not_disable_currency'                => 'Kon valuta ":name" niet uitschakelen. Misschien is deze nog steeds in gebruik?',

    // forms:
    'mandatoryFields'                           => 'Verplichte velden',
    'optionalFields'                            => 'Optionele velden',
    'options'                                   => 'Opties',

    // budgets:
    'daily_budgets'                             => 'Dagelijkse budgetten',
    'weekly_budgets'                            => 'Wekelijkse budgetten',
    'monthly_budgets'                           => 'Maandelijkse budgetten',
    'quarterly_budgets'                         => 'Driemaandelijkse budgetten',
    'half_year_budgets'                         => 'Halfjaarlijkse budgetten',
    'yearly_budgets'                            => 'Jaarlijkse budgetten',
    'other_budgets'                             => 'Aangepaste budgetten',
    'budget_limit_not_in_range'                 => 'Dit bedrag is van toepassing op :start tot :end:',
    'total_available_budget'                    => 'Totaal beschikbare budget (tussen :start en :end)',
    'total_available_budget_in_currency'        => 'Totaal beschikbare budget in :currency',
    'see_below'                                 => 'zie onder',
    'create_new_budget'                         => 'Maak een nieuw budget',
    'store_new_budget'                          => 'Sla nieuw budget op',
    'stored_new_budget'                         => 'Nieuw budget ":name" opgeslagen',
    'available_between'                         => 'Beschikbaar tussen :start en :end',
    'transactionsWithoutBudget'                 => 'Uitgaven zonder budget',
    'transactions_no_budget'                    => 'Uitgaven zonder budget tussen :start en :end',
    'spent_between'                             => 'Al uitgegeven tussen :start en :end',
    'spent_between_left'                        => 'Uitgegeven :spent tussen :start en :end. Over: :left.',
    'set_available_amount'                      => 'Stel beschikbaar bedrag in',
    'update_available_amount'                   => 'Update beschikbaar bedrag',
    'ab_basic_modal_explain'                    => 'Gebruik dit formulier om aan te geven hoeveel je verwacht in de aangegeven periode (in totaal, in :currency) te kunnen begroten.',
    'createBudget'                              => 'Maak nieuw budget',
    'invalid_currency'                          => 'Dit is een ongeldige valuta',
    'invalid_amount'                            => 'Vul een bedrag in',
    'set_ab'                                    => 'Het beschikbare budgetbedrag is ingesteld',
    'updated_ab'                                => 'Het beschikbare budgetbedrag is bijgewerkt',
    'deleted_ab'                                => 'Het beschikbare budgetbedrag is verwijderd',
    'deleted_bl'                                => 'Het gebudgetteerde bedrag is verwijderd',
    'alt_currency_ab_create'                    => 'Stel beschikbare budget in in een andere valuta',
    'bl_create_btn'                             => 'Stel budget in in een andere valuta',
    'inactiveBudgets'                           => 'Inactieve budgetten',
    'without_budget_between'                    => 'Transacties zonder budget tussen :start en :end',
    'delete_budget'                             => 'Verwijder budget ":name"',
    'deleted_budget'                            => 'Budget ":name" verwijderd',
    'edit_budget'                               => 'Wijzig budget ":name"',
    'updated_budget'                            => 'Budget ":name" geüpdatet',
    'update_amount'                             => 'Bedrag bijwerken',
    'update_budget'                             => 'Budget bijwerken',
    'update_budget_amount_range'                => 'Update het verwacht beschikbare bedrag tussen :start en :end',
    'set_budget_limit_title'                    => 'Stel begroot bedrag in voor budget :budget tussen :start en :end',
    'set_budget_limit'                          => 'Stel begroot bedrag in',
    'budget_period_navigator'                   => 'Periodenavigator',
    'info_on_available_amount'                  => 'Wat heb ik beschikbaar?',
    'available_amount_indication'               => 'Gebruik deze bedragen om een indruk te krijgen van wat je totale budget zou kunnen zijn.',
    'suggested'                                 => 'Gesuggereerd',
    'average_between'                           => 'Gemiddelde tussen :start en :end',
    'transferred_in'                            => 'Overgeboekt (inkomend)',
    'transferred_away'                          => 'Overgeboekt (uitgaand)',
    'auto_budget_none'                          => 'Geen auto-budget',
    'auto_budget_reset'                         => 'Vast bedrag elke periode',
    'auto_budget_rollover'                      => 'Voeg elke periode een bedrag toe',
    'auto_budget_adjusted'                      => 'Voeg elke periode een bedrag toe en corrigeer voor overbesteding',
    'auto_budget_period_daily'                  => 'Dagelijks',
    'auto_budget_period_weekly'                 => 'Wekelijks',
    'auto_budget_period_monthly'                => 'Maandelijks',
    'auto_budget_period_quarterly'              => 'Elk kwartaal',
    'auto_budget_period_half_year'              => 'Elk half jaar',
    'auto_budget_period_yearly'                 => 'Jaarlijks',
    'auto_budget_help'                          => 'Je kan meer lezen over deze functie in de hulppagina\'s. Klik op het (?) icoontje rechtsboven.',
    'auto_budget_reset_icon'                    => 'Het budget wordt periodiek ingesteld',
    'auto_budget_rollover_icon'                 => 'Het budget wordt periodiek aangevuld',
    'auto_budget_adjusted_icon'                 => 'Het bedrag zal periodiek stijgen en corrigeren bij overmatige uitgaven',
    'remove_budgeted_amount'                    => 'Verwijder gebudgetteerd bedrag in :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Gebruik het "Overslaan"-veld om bijvoorbeeld tweemaandelijkse entries te maken (Overslaan = 1).',
    'subscription'                              => 'Abonnement',
    'not_expected_period'                       => 'Niet verwacht deze periode',
    'subscriptions_in_group'                    => 'Abonnementen in groep "{{title}}"',
    'subscr_expected_x_times'                   => 'Verwacht {{amount}} {{times}} keer te betalen in deze periode',
    'not_or_not_yet'                            => '(nog) niet',
    'visit_bill'                                => 'Bekijk abonnement ":name" in Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Abonnement past bij transacties tussen :low en :high.',
    'running_again_loss'                        => 'Eerder gekoppelde transacties met dit abonnement kunnen hun koppeling verliezen, als ze (niet langer) overeenkomen met de regel(s).',
    'bill_related_rules'                        => 'Regels gerelateerd aan dit abonnement',
    'repeats'                                   => 'Herhaalt',
    'bill_end_date_help'                        => 'Optioneel veld. Het abonnement eindigt op deze datum.',
    'bill_extension_date_help'                  => 'Optioneel veld. Het abonnement moet verlengd of opgezegd worden voor of op deze datum.',
    'bill_end_index_line'                       => 'Dit abonnement eindigt op :date',
    'bill_extension_index_line'                 => 'Het abonnement moet verlengd of opgezegd worden op :date',
    'connected_journals'                        => 'Verbonden transacties',
    'auto_match_on'                             => 'Automatisch herkend door Firefly III',
    'auto_match_off'                            => 'Niet automatisch herkend door Firefly III',
    'next_expected_match'                       => 'Volgende verwachte transactie',
    'delete_bill'                               => 'Abonnement ":name " verwijderen',
    'deleted_bill'                              => 'Abonnement ":name " verwijderd',
    'edit_bill'                                 => 'Abonnement ":name " bewerken',
    'more'                                      => 'Meer',
    'rescan_old'                                => 'Voer regels opnieuw uit op alle transacties',
    'update_bill'                               => 'Abonnement bijwerken',
    'updated_bill'                              => 'Abonnement ":name " bijgewerkt',
    'store_new_bill'                            => 'Nieuw abonnement opslaan',
    'stored_new_bill'                           => 'Abonnement ":name " opgeslagen',
    'cannot_scan_inactive_bill'                 => 'Inactieve abonnementen kunnen niet worden gescand.',
    'rescanned_bill'                            => 'Alles is opnieuw gescand, en :count transactie is gekoppeld aan het abonnement.|Alles is opnieuw gescand, en :count transacties zijn gekoppeld aan het abonnement.',
    'average_bill_amount_year'                  => 'Gemiddeld abonnementsbedrag (:year)',
    'average_bill_amount_overall'               => 'Gemiddeld abonnementsbedrag (gehele periode)',
    'bill_is_active'                            => 'Abonnement actief',
    'bill_expected_between'                     => 'Verwacht tussen :start en :end',
    'bill_will_automatch'                       => 'Waar van toepassing wordt dit abonnement automatisch gekoppeld aan transacties',
    'skips_over'                                => 'slaat over',
    'bill_store_error'                          => 'Er ging wat fout bij het opslaan van het abonnement. Kijk in de logbestanden',
    'list_inactive_rule'                        => 'inactieve regel',
    'bill_edit_rules'                           => 'Firefly III gaat proberen de gerelateerde regel ook aan te passen. Als je deze zelf al hebt gewijzigd echter, zal dit niet gebeuren.|Firefly III gaat proberen de :count gerelateerde regels ook aan te passen. Als je deze zelf al hebt gewijzigd echter, zal dit niet gebeuren.',
    'bill_expected_date'                        => 'Verwacht :date',
    'bill_expected_date_js'                     => 'Verwacht op {date}',
    'expected_amount'                           => '(Verwacht) bedrag',
    'bill_paid_on'                              => 'Betaald op {date}',
    'bill_repeats_weekly'                       => 'Herhaalt wekelijks',
    'bill_repeats_monthly'                      => 'Herhaalt maandelijks',
    'bill_repeats_quarterly'                    => 'Herhaalt elk kwartaal',
    'bill_repeats_half-year'                    => 'Herhaalt elk half jaar',
    'bill_repeats_yearly'                       => 'Herhaalt jaarlijks',
    'bill_repeats_weekly_other'                 => 'Herhaalt om de week',
    'bill_repeats_monthly_other'                => 'Herhaalt om de maand',
    'bill_repeats_quarterly_other'              => 'Herhaalt om het kwartaal',
    'bill_repeats_half-year_other'              => 'Herhaalt jaarlijks',
    'bill_repeats_yearly_other'                 => 'Herhaalt om het jaar',
    'bill_repeats_weekly_skip'                  => 'Herhaalt elke {skip} weken',
    'bill_repeats_monthly_skip'                 => 'Herhaalt elke {skip} maanden',
    'bill_repeats_quarterly_skip'               => 'Herhaalt elke {skip} kwartalen',
    'bill_repeats_half-year_skip'               => 'Herhaalt elke {skip} halve jaren',
    'bill_repeats_yearly_skip'                  => 'Herhaalt elke {skip} jaar',
    'subscriptions'                             => 'Abonnementen',
    'go_to_subscriptions'                       => 'Ga naar je abonnementen',
    'forever'                                   => 'Voor altijd',
    'extension_date_is'                         => 'Verlengdatum is {date}',

    // accounts:
    'account_locked_currency'                   => 'De valuta van deze rekening moet :name blijven zolang er spaarpotjes aan gekoppeld zijn.',
    'i_am_owed_amount'                          => 'Het bedrag is mij verschuldigd',
    'i_owe_amount'                              => 'Ik ben het bedrag verschuldigd',
    'inactive_account_link'                     => 'Je hebt :count inactieve (gearchiveerde) rekening, die je kan bekijken op deze aparte pagina.|Je hebt :count inactieve (gearchiveerde) rekeningen, die je kan bekijken op deze aparte pagina.',
    'all_accounts_inactive'                     => 'Dit zijn je inactieve rekeningen.',
    'active_account_link'                       => 'Deze link gaat terug naar je actieve rekeningen.',
    'account_missing_transaction'               => 'Rekening #:id (":name") kan je niet bekijken in Firefly III, maar het origineel is kwijt.',
    'cc_monthly_payment_date_help'              => 'Maakt niet uit welk jaar of welke maand. Alleen de dag van de maand is relevant.',
    'details_for_asset'                         => 'Overzicht voor betaalrekening ":name"',
    'details_for_expense'                       => 'Overzicht voor crediteur ":name"',
    'details_for_revenue'                       => 'Overzicht voor debiteur ":name"',
    'details_for_cash'                          => 'Overzicht voor contant geldrekening ":name"',
    'store_new_asset_account'                   => 'Sla nieuwe betaalrekening op',
    'store_new_expense_account'                 => 'Sla nieuwe crediteur op',
    'store_new_revenue_account'                 => 'Sla nieuwe debiteur op',
    'edit_asset_account'                        => 'Wijzig betaalrekening ":name"',
    'edit_expense_account'                      => 'Wijzig crediteur ":name"',
    'edit_revenue_account'                      => 'Wijzig debiteur ":name"',
    'delete_asset_account'                      => 'Verwijder betaalrekening ":name"',
    'delete_expense_account'                    => 'Verwijder crediteur ":name"',
    'delete_revenue_account'                    => 'Verwijder debiteur ":name"',
    'delete_liabilities_account'                => 'Verwijder passiva ":name"',
    'asset_deleted'                             => 'Betaalrekening ":name" is verwijderd.',
    'account_deleted'                           => 'Rekening ":name" is verwijderd',
    'expense_deleted'                           => 'Crediteur ":name" is verwijderd.',
    'revenue_deleted'                           => 'Debiteur ":name" is verwijderd.',
    'update_asset_account'                      => 'Wijzig betaalrekening',
    'update_undefined_account'                  => 'Account bijwerken',
    'update_liabilities_account'                => 'Update passiva',
    'update_expense_account'                    => 'Wijzig crediteur',
    'update_revenue_account'                    => 'Wijzig debiteur',
    'make_new_asset_account'                    => 'Nieuwe betaalrekening',
    'make_new_expense_account'                  => 'Nieuwe crediteur',
    'make_new_revenue_account'                  => 'Nieuwe debiteur',
    'make_new_liabilities_account'              => 'Maak nieuwe passiva',
    'asset_accounts'                            => 'Betaalrekeningen',
    'undefined_accounts'                        => 'Rekeningen',
    'asset_accounts_inactive'                   => 'Betaalrekeningen (inactief)',
    'expense_account'                           => 'Crediteur',
    'expense_accounts'                          => 'Crediteuren',
    'expense_accounts_inactive'                 => 'Crediteuren (inactief)',
    'revenue_account'                           => 'Debiteur',
    'revenue_accounts'                          => 'Debiteuren',
    'revenue_accounts_inactive'                 => 'Debiteuren (inactief)',
    'cash_accounts'                             => 'Contant geldrekeningen',
    'Cash account'                              => 'Contant geldrekening',
    'liabilities_accounts'                      => 'Passiva',
    'liabilities_accounts_inactive'             => 'Passiva (inactief)',
    'reconcile_account'                         => 'Afstemmen betaalrekening ":account"',
    'overview_of_reconcile_modal'               => 'Overview van afstemming',
    'delete_reconciliation'                     => 'Verwijder afstemmingstransactie',
    'update_reconciliation'                     => 'Update afstemmingstransactie',
    'amount_cannot_be_zero'                     => 'Het bedrag mag niet nul zijn',
    'end_of_reconcile_period'                   => 'Einde van afstemmingsperiode: :period',
    'start_of_reconcile_period'                 => 'Begin van afstemmingsperiode: :period',
    'start_balance'                             => 'Startsaldo',
    'end_balance'                               => 'Eindsaldo',
    'update_balance_dates_instruction'          => 'Vergelijk de bedragen en datums hierboven met je bankafschrift en druk op "Begin met afstemmen"',
    'select_transactions_instruction'           => 'Selecteer de transacties die op je bankafschrift staan.',
    'select_range_and_balance'                  => 'Controleer eerst het datumbereik en de saldo\'s. Druk vervolgens op "Begin met afstemmen"',
    'date_change_instruction'                   => 'Als je het datumbereik nu wijzigt, gaat je voortgang verloren.',
    'update_selection'                          => 'Selectie bijwerken',
    'store_reconcile'                           => 'Afstemming opslaan',
    'reconciliation_transaction'                => 'Afstemmingstransactie',
    'Reconciliation'                            => 'Afstemming',
    'reconciliation'                            => 'Afstemming',
    'reconcile_options'                         => 'Afstemmingsopties',
    'reconcile_range'                           => 'Afstemmingsbereik',
    'start_reconcile'                           => 'Begin met afstemmen',
    'cash_account_type'                         => 'Cash',
    'cash'                                      => 'contant',
    'cant_find_redirect_account'                => 'Firefly III probeerde je door te sturen maar het ging mis. Sorry. Terug naar de index.',
    'account_type'                              => 'Rekeningtype',
    'save_transactions_by_moving'               => 'Bewaar deze transactie door ze aan een andere rekening te koppelen:|Bewaar deze transacties door ze aan een andere rekening te koppelen:',
    'save_transactions_by_moving_js'            => 'Geen transacties|Bewaar deze transactie door ze aan een andere rekening te koppelen.|Bewaar deze transacties door ze aan een andere rekening te koppelen.',
    'stored_new_account'                        => 'Nieuwe rekening ":name" opgeslagen!',
    'stored_new_account_js'                     => 'Nieuwe account "<a href="accounts/show/{ID}">{name}</a>" opgeslagen!',
    'updated_account'                           => 'Rekening ":name" geüpdatet',
    'updated_account_js'                        => 'Account "<a href="accounts/show/{ID}">{title}</a>" bijgewerkt.',
    'credit_card_options'                       => 'Opties voor credit cards',
    'no_transactions_account'                   => 'Betaalrekening ":name" heeft geen transacties (in deze periode).',
    'no_transactions_period'                    => 'Er zijn geen transacties (in deze periode).',
    'no_data_for_chart'                         => 'Er is (nog) niet genoeg informatie om deze grafiek te tekenen.',
    'select_at_least_one_account'               => 'Selecteer ten minste één betaalrekening',
    'select_at_least_one_category'              => 'Selecteer ten minste één categorie',
    'select_at_least_one_budget'                => 'Selecteer ten minste één budget',
    'select_at_least_one_tag'                   => 'Selecteer ten minste één tag',
    'select_at_least_one_expense'               => 'Kies minstens één combinatie van crediteuren/debiteuren. Als die die niet hebt (de lijst is leeg) is dit rapport niet beschikbaar voor jou.',
    'account_default_currency'                  => 'Dit wordt de valuta die standaard gekoppeld wordt met de rekening.',
    'piggy_default_currency'                    => 'Spaarpotjes kunnen maar in één valuta geld sparen.',
    'piggy_account_currency_match'              => 'Alleen rekeningen die de eerder geselecteerde valuta gebruiken worden geaccepteerd.',
    'reconcile_has_more'                        => 'Je Firefly III boekhouding bevat meer geld dan je bank beweert dat er in zou moeten zitten. Je hebt verschillende opties. Kies wat je wilt doen, en klik dan "Bevestig afstemming".',
    'reconcile_has_less'                        => 'Je Firefly III boekhouding bevat minder geld dan je bank beweert dat er in zou moeten zitten. Je hebt verschillende opties. Kies wat je wilt doen, en klik dan "Bevestig afstemming".',
    'reconcile_is_equal'                        => 'Je Firefly III boekhouding en je bankafschriften lopen gelijk. Je hoeft niets te doen. Klik op "Bevestig afstemming" om je invoer te bevestigen.',
    'create_pos_reconcile_transaction'          => 'Markeer de geselecteerde transacties als afgestemd, en voeg :amount toe aan de betaalrekening.',
    'create_neg_reconcile_transaction'          => 'Markeer de geselecteerde transacties als afgestemd, en verwijder :amount van de betaalrekening.',
    'reconcile_do_nothing'                      => 'Markeer de geselecteerde transacties als afgestemd, maar maak geen afstemmingstransactie (correctie).',
    'reconcile_go_back'                         => 'Je kan een afstemmingstransactie later altijd wijzigen.',
    'must_be_asset_account'                     => 'Je kan alleen betaalrekeningen afstemmen',
    'reconciliation_stored'                     => 'Afstemming opgeslagen',
    'reconciliation_error'                      => 'De correctie is niet opgeslagen, maar de transacties zijn wel aangemerkt als afgestemd: :error.',
    'reconciliation_transaction_title'          => 'Afstemming (:from tot :to)',
    'sum_of_reconciliation'                     => 'Som van afstemming',
    'reconcile_this_account'                    => 'Stem deze rekening af',
    'reconcile'                                 => 'Afstemmen',
    'show'                                      => 'Bekijken',
    'confirm_reconciliation'                    => 'Bevestig afstemming',
    'submitted_start_balance'                   => 'Ingevoerd startsaldo',
    'selected_transactions'                     => 'Geselecteerde transacties (:count)',
    'already_cleared_transactions'              => 'Al afgestemde transacties (:count)',
    'submitted_end_balance'                     => 'Ingevoerd eindsaldo',
    'initial_balance_description'               => 'Startsaldo voor ":account"',
    'liability_credit_description'              => 'Leningkrediet voor ":account"',
    'interest_calc_'                            => 'onbekend',
    'interest_calc_daily'                       => 'Per dag',
    'interest_calc_monthly'                     => 'Per maand',
    'interest_calc_yearly'                      => 'Per jaar',
    'interest_calc_weekly'                      => 'Per week',
    'interest_calc_half-year'                   => 'Per half jaar',
    'interest_calc_quarterly'                   => 'Per kwartaal',
    'initial_balance_account'                   => 'Startsaldorekening voor :account',
    'list_options'                              => 'Lijstopties',
    'account_column_opt_drag_and_drop'          => 'Sleur en pleur',
    'account_column_opt_active'                 => 'Actief',
    'account_column_opt_name'                   => 'Naam',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Passivasoort',
    'account_column_opt_liability_direction'    => 'Passiva in- of uitgaand',
    'account_column_opt_liability_interest'     => 'Passivarente',
    'account_column_opt_number'                 => 'Rekeningnummer',
    'account_column_opt_current_balance'        => 'Huidig saldo',
    'account_column_opt_amount_due'             => 'Verschuldigd bedrag',
    'account_column_opt_last_activity'          => 'Laatste activiteit',
    'account_column_opt_balance_difference'     => 'Saldoverschil',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Nieuwe categorie',
    'create_new_category'                       => 'Nieuwe categorie',
    'without_category'                          => 'Zonder categorie',
    'update_category'                           => 'Update categorie',
    'updated_category'                          => 'Categorie ":name" geüpdatet',
    'categories'                                => 'Categorieën',
    'edit_category'                             => 'Wijzig categorie ":name"',
    'no_category'                               => '(geen categorie)',
    'unknown_category_plain'                    => 'Geen categorie',
    'category'                                  => 'Categorie',
    'delete_category'                           => 'Verwijder categorie ":name"',
    'deleted_category'                          => 'Categorie ":name" verwijderd',
    'store_category'                            => 'Sla nieuwe categorie op',
    'stored_category'                           => 'Nieuwe categorie ":name" opgeslagen',
    'without_category_between'                  => 'Zonder categorie tussen :start en :end',


    // transactions:
    'wait_loading_transaction'                  => 'Wacht even tot het formulier geladen is',
    'wait_loading_data'                         => 'Wacht even tot de gegevens er zijn...',
    'wait_attachments'                          => 'Wacht even tot de bijlagen geüpload zijn.',
    'errors_upload'                             => 'De upload is mislukt. Check je browserconsole, daar zie je de foutmelding.',
    'amount_foreign_if'                         => 'Optioneel, bedrag in vreemde valuta',
    'amount_destination_account'                => 'Bedrag in de valuta van de doelrekening',
    'edit_transaction_title'                    => 'Wijzig transactie ":description"',
    'unreconcile'                               => 'Ongedaan maken van afstemming',
    'update_withdrawal'                         => 'Wijzig uitgave',
    'update_deposit'                            => 'Wijzig inkomsten',
    'update_transaction'                        => 'Update transactie',
    'update_transfer'                           => 'Wijzig overschrijving',
    'updated_withdrawal'                        => 'Uitgave ":description" geüpdatet',
    'updated_deposit'                           => 'Inkomsten ":description" geüpdatet',
    'updated_transfer'                          => 'Overschrijving ":description" geüpdatet',
    'no_changes_withdrawal'                     => 'Uitgave ":description" is niet gewijzigd.',
    'no_changes_deposit'                        => 'Inkomsten ":description" is niet gewijzigd.',
    'no_changes_transfer'                       => 'Overschrijving ":description" is niet gewijzigd.',
    'delete_withdrawal'                         => 'Verwijder uitgave ":description"',
    'delete_deposit'                            => 'Verwijder inkomsten ":description"',
    'delete_transfer'                           => 'Verwijder overschrijving ":description"',
    'deleted_withdrawal'                        => 'Uitgave ":description" verwijderd',
    'deleted_deposit'                           => 'Inkomsten ":description" verwijderd',
    'deleted_transfer'                          => 'Overschrijving ":description" verwijderd',
    'deleted_reconciliation'                    => 'Afstemming ":description" verwijderd',
    'stored_journal'                            => 'Nieuw transactie ":description" opgeslagen',
    'stored_journal_js'                         => 'Nieuw transactie "{{description}}" opgeslagen',
    'stored_journal_no_descr'                   => 'Je nieuwe transactie is succesvol aangemaakt',
    'updated_journal_no_descr'                  => 'De transactie is geüpdatet',
    'select_transactions'                       => 'Selecteer transacties',
    'rule_group_select_transactions'            => '":title" op transacties toepassen',
    'rule_select_transactions'                  => '":title" op transacties toepassen',
    'stop_selection'                            => 'Stop met selecteren',
    'reconcile_selected'                        => 'Afstemmen',
    'mass_delete_journals'                      => 'Verwijder een aantal transacties',
    'mass_edit_journals'                        => 'Wijzig een aantal transacties',
    'mass_bulk_journals'                        => 'Wijzig een aantal transacties in bulk',
    'mass_bulk_journals_explain'                => 'Gebruik dit formulier om de onderstaande transacties in één keer aan te passen. Alle transacties die je hier ziet worden geüpdated.',
    'part_of_split'                             => 'Deze transactie is onderdeel van een gesplitste transactie. Als je niet alle splits hebt geselecteerd dan verander je wellicht maar één stuk van een gesplitste transactie.',
    'bulk_set_new_values'                       => 'Gebruik de velden hieronder voor nieuwe waarden. Als je ze leeg laat, worden ze leeggemaakt voor alle gebruikers. Denk eraan dat alleen uitgaven een budget kunnen krijgen.',
    'no_bulk_category'                          => 'Update categorie niet',
    'no_bulk_budget'                            => 'Update budget niet',
    'no_bulk_tags'                              => 'Update tag(s) niet',
    'replace_with_these_tags'                   => 'Vervang met deze tags',
    'append_these_tags'                         => 'Voeg deze tags toe',
    'mass_edit'                                 => 'Wijzig in lijst',
    'bulk_edit'                                 => 'Wijzig in bulk',
    'mass_delete'                               => 'Verwijder',
    'cannot_edit_other_fields'                  => 'Je kan andere velden dan de velden die je hier ziet niet groepsgewijs wijzigen. Er is geen ruimte om ze te laten zien. Als je deze velden toch wilt wijzigen, volg dan de link naast de transactie en wijzig ze stuk voor stuk.',
    'cannot_change_amount_reconciled'           => 'Je kunt het bedrag of de rekening(en) van afgestemde transacties niet wijzigen.',
    'no_budget'                                 => '(geen budget)',
    'no_bill'                                   => '(geen abonnement)',
    'account_per_budget'                        => 'Rekening per budget',
    'account_per_category'                      => 'Rekening per categorie',
    'create_new_object'                         => 'Opslaan',
    'empty'                                     => '(leeg)',
    'all_other_budgets'                         => '(alle andere budgetten)',
    'all_other_accounts'                        => '(alle andere rekeningen)',
    'expense_per_source_account'                => 'Uitgaven per bronrekening',
    'expense_per_destination_account'           => 'Uitgaven per doelrekening',
    'income_per_destination_account'            => 'Inkomen per doelrekening',
    'spent_in_specific_category'                => 'Uitgegeven in categorie ":category"',
    'earned_in_specific_category'               => 'Verdiend in categorie ":category"',
    'spent_in_specific_tag'                     => 'Uitgegeven in tag ":tag"',
    'earned_in_specific_tag'                    => 'Verdiend in tag ":tag"',
    'income_per_source_account'                 => 'Inkomen per bronrekening',
    'average_spending_per_destination'          => 'Gemiddelde uitgave per doelrekening',
    'average_spending_per_source'               => 'Gemiddelde uitgave per bronrekening',
    'average_earning_per_source'                => 'Gemiddelde inkomsten per bronrekening',
    'average_earning_per_destination'           => 'Gemiddelde inkomsten per doelrekening',
    'account_per_tag'                           => 'Rekening per tag',
    'tag_report_expenses_listed_once'           => 'Uitgaven en inkomsten worden nooit dubbel vermeld. Als een transactie meerdere tags heeft komt-ie waarschijnlijk maar één keer voorbij, onder één van de tags. De lijst lijkt dus gegevens te missen maar de bedragen zijn correct.',
    'double_report_expenses_charted_once'       => 'Uitgaven en inkomsten worden nooit dubbel vermeld. Als een transactie meerdere tags heeft kan het zijn dat-ie maar onder één tag in beeld komt. De grafiek lijkt dus informatie te missen, maar de bedragen zullen kloppen.',
    'tag_report_chart_single_tag'               => 'Deze grafiek slaat op een enkele tag. Als een transactie meerdere tags heeft kan het dus zijn dat je dit in andere grafieken terug ziet komen.',
    'tag'                                       => 'Tag',
    'no_budget_squared'                         => '(geen budget)',
    'perm-delete-many'                          => 'Als je veel transacties in één keer verwijderd kan dit je boekhouding aardig verstoren. Wees dus voorzichtig. Je hebt hier ook de mogelijkheid om één split van een gesplitste transactie weg te gooien, dus let op.',
    'mass_deleted_transactions_success'         => ':count transactie verwijderd.|:count transacties verwijderd.',
    'mass_edited_transactions_success'          => ':count transactie geüpdatet.|:count transacties geüpdatet.',
    'opt_group_'                                => '(geen rekeningtype)',
    'opt_group_no_account_type'                 => '(geen rekeningtype)',
    'opt_group_defaultAsset'                    => 'Standaard betaalrekeningen',
    'opt_group_savingAsset'                     => 'Spaarrekeningen',
    'opt_group_sharedAsset'                     => 'Gedeelde betaalrekeningen',
    'opt_group_ccAsset'                         => 'Creditcards',
    'opt_group_cashWalletAsset'                 => 'Cash portomonees',
    'opt_group_expense_account'                 => 'Crediteuren',
    'opt_group_revenue_account'                 => 'Debiteuren',
    'opt_group_l_Loan'                          => 'Passiva: lening',
    'opt_group_cash_account'                    => 'Contant geldrekening',
    'opt_group_l_Debt'                          => 'Passiva: schuld',
    'opt_group_l_Mortgage'                      => 'Passiva: hypotheek',
    'opt_group_l_Credit card'                   => 'Passiva: credit card',
    'notes'                                     => 'Notities',
    'view_notes'                                => 'Bekijk notities',
    'set_budget_limit_notes'                    => 'Bekijk de notities van het gebudgeteerde bedrag',
    'edit_bl_notes'                             => 'Wijzig notities',
    'update_bl_notes'                           => 'Sla notities op',
    'unknown_journal_error'                     => 'Kon de transactie niet opslaan. Kijk in de logbestanden.',
    'attachment_not_found'                      => 'Deze bijlage kon niet gevonden worden.',
    'journal_link_bill'                         => 'Deze transactie is gekoppeld aan abonnement <a href=":route">:name</a>. Om de verbinding te verwijderen haal je het vinkje weg. Gebruik regels om een ander abonnement te koppelen.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Transactie #{ID} ("{title}")</a> is opgeslagen.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Transactie #{ID}</a> is opgeslagen.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Transactie #{ID}</a> ("{title}") is geüpdatet.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Transactie #{ID}</a> ("{title}") is niet gewijzigd.',
    'first_split_decides'                       => 'De eerste split bepaalt wat hier staat',
    'first_split_overrules_source'              => 'De eerste split kan de bronrekening overschrijven',
    'first_split_overrules_destination'         => 'De eerste split kan de doelrekening overschrijven',
    'spent_x_of_y'                              => '{amount} van {total} uitgegeven',

    // new user:
    'welcome'                                   => 'Welkom bij Firefly III!',
    'submit'                                    => 'Invoeren',
    'submission'                                => 'Indienen',
    'submit_yes_really'                         => 'Invoeren (ik weet wat ik doe)',
    'getting_started'                           => 'Aan de start!',
    'to_get_started'                            => 'Het is goed om te zien dat de installatie van Firefly III gelukt is. Voer de naam van je bank in en het saldo van je belangrijkste betaalrekening. Meerdere rekeningen kan je later toevoegen, maar we moeten ergens beginnen natuurlijk.',
    'savings_balance_text'                      => 'Firefly III maakt automatisch een spaarrekening voor je. Daar zit normaal geen geld in, maar je kan hier opgeven hoeveel er op staat.',
    'finish_up_new_user'                        => 'That\'s it! Druk op <strong>Opslaan</strong> om door te gaan. Je gaat dan naar de homepage van Firefly III.',
    'stored_new_accounts_new_user'              => 'Hoera! Je nieuwe accounts zijn opgeslagen.',
    'set_preferred_language'                    => 'Als je Firefly III liever in een andere taal gebruikt, geef dat dan hier aan.',
    'language'                                  => 'Taal',
    'new_savings_account'                       => ':bank_name spaarrekening',
    'cash_wallet'                               => 'Cash-rekening',
    'currency_not_present'                      => 'Geen zorgen als de valuta die je gewend bent er niet tussen staat. Je kan je eigen valuta maken onder Opties > Valuta.',

    // home page:
    'transaction_table_description'             => 'Een tabel met je transacties',
    'opposing_account'                          => 'Tegenrekening',
    'yourAccounts'                              => 'Je betaalrekeningen',
    'your_accounts'                             => 'Je rekeningoverzicht',
    'category_overview'                         => 'Categorieoverzicht',
    'expense_overview'                          => 'Crediteurenoverzicht',
    'revenue_overview'                          => 'Debiteurenoverzicht',
    'budgetsAndSpending'                        => 'Budgetten en uitgaven',
    'budgets_and_spending'                      => 'Budgetten en uitgaven',
    'go_to_budget'                              => 'Ga naar budget "{budget}"',
    'go_to_deposits'                            => 'Ga naar je inkomsten',
    'go_to_expenses'                            => 'Ga naar je uitgaven',
    'savings'                                   => 'Sparen',
    'newWithdrawal'                             => 'Nieuwe uitgave',
    'newDeposit'                                => 'Nieuwe inkomsten',
    'newTransfer'                               => 'Nieuwe overschrijving',
    'bills_to_pay'                              => 'Te betalen abonnementen',
    'per_day'                                   => 'Per dag',
    'left_to_spend_per_day'                     => 'Te besteden per dag',
    'bills_paid'                                => 'Betaalde abonnementen',
    'custom_period'                             => 'Aangepaste periode',
    'reset_to_current'                          => 'Reset naar huidige periode',
    'select_period'                             => 'Selecteer een periode',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuta',
    'preferences'                               => 'Voorkeuren',
    'logout'                                    => 'Uitloggen',
    'logout_other_sessions'                     => 'Alle andere sessies afmelden',
    'toggleNavigation'                          => 'Navigatie aan of uit',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Zoeken...',
    'version'                                   => 'Versie',
    'dashboard'                                 => 'Dashboard',
    'income_and_expense'                        => 'Inkomsten en uitgaven',
    'all_money'                                 => 'Al je geld',
    'unknown_source_plain'                      => 'Onbekend bronrekening',
    'unknown_dest_plain'                        => 'Onbekende doelrekening',
    'unknown_any_plain'                         => 'Onbekende rekening',
    'unknown_budget_plain'                      => 'Geen budget',
    'available_budget'                          => 'Beschikbaar budget ({currency})',
    'currencies'                                => 'Valuta',
    'activity'                                  => 'Activiteit',
    'usage'                                     => 'Gebruik',
    'accounts'                                  => 'Rekeningen',
    'Asset account'                             => 'Betaalrekening',
    'Default account'                           => 'Betaalrekening',
    'Expense account'                           => 'Crediteur',
    'Revenue account'                           => 'Debiteur',
    'Initial balance account'                   => 'Startbalansrekening',
    'account_type_Asset account'                => 'Betaalrekening',
    'account_type_Expense account'              => 'Crediteur',
    'account_type_Revenue account'              => 'Debiteur',
    'account_type_Debt'                         => 'Schuld',
    'account_type_Loan'                         => 'Lening',
    'account_type_Mortgage'                     => 'Hypotheek',
    'account_type_debt'                         => 'Schuld',
    'account_type_loan'                         => 'Lening',
    'account_type_mortgage'                     => 'Hypotheek',
    'account_type_Credit card'                  => 'Credit card',
    'credit_card_type_monthlyFull'              => 'Volledige betaling elke maand',
    'liability_direction_credit'                => 'Ik krijg dit bedrag terug',
    'liability_direction_debit'                 => 'Ik moet dit bedrag terugbetalen',
    'liability_direction_credit_short'          => 'Schuldeiser',
    'liability_direction_debit_short'           => 'Schuldenaar',
    'liability_direction__short'                => 'Onbekend',
    'liability_direction_null_short'            => 'Onbekend',
    'Liability credit'                          => 'Leningkrediet',
    'budgets'                                   => 'Budgetten',
    'tags'                                      => 'Tags',
    'reports'                                   => 'Overzichten',
    'transactions'                              => 'Transacties',
    'expenses'                                  => 'Uitgaven',
    'income'                                    => 'Inkomsten',
    'transfers'                                 => 'Overschrijvingen',
    'moneyManagement'                           => 'Geldbeheer',
    'money_management'                          => 'Geldbeheer',
    'tools'                                     => 'Extra',
    'piggyBanks'                                => 'Spaarpotjes',
    'piggy_banks'                               => 'Spaarpotjes',
    'amount_x_of_y'                             => '{current} van {total}',
    'bills'                                     => 'Abonnementen',
    'withdrawal'                                => 'Uitgave',
    'opening_balance'                           => 'Startsaldo',
    'deposit'                                   => 'Inkomsten',
    'account'                                   => 'Rekening',
    'transfer'                                  => 'Overschrijving',
    'Withdrawal'                                => 'Uitgave',
    'Deposit'                                   => 'Inkomsten',
    'Transfer'                                  => 'Overschrijving',
    'bill'                                      => 'Abonnement',
    'yes'                                       => 'Ja',
    'no'                                        => 'Nee',
    'amount'                                    => 'Bedrag',
    'overview'                                  => 'Overzicht',
    'saveOnAccount'                             => 'Sparen op rekening',
    'saveOnAccounts'                            => 'Spaar op rekening(en)',
    'unknown'                                   => 'Onbekend',
    'monthly'                                   => 'Maandelijks',
    'profile'                                   => 'Profiel',
    'errors'                                    => 'Fouten',
    'debt_start_date'                           => 'Begindatum van schuld',
    'debt_start_amount'                         => 'Beginbedrag van schuld',
    'debt_start_amount_help'                    => 'Het is handig om hier een negatief bedrag in te stellen. Lees de help-pagina\'s ((?)-icoontje rechtsboven) voor meer info.',
    'interest_period_help'                      => 'Dit veld doet verder niks. Firefly III gaat dit niet voor je uitrekenen. Banken pakken dit toch altijd net anders aan.',
    'store_new_liabilities_account'             => 'Nieuwe passiva opslaan',
    'edit_liabilities_account'                  => 'Passiva ":name" wijzigen',
    'financial_control'                         => 'Financieel overzicht',
    'accounting'                                => 'Boekhouden',
    'automation'                                => 'Automatisering',
    'others'                                    => 'Overige',
    'classification'                            => 'Indeling',
    'store_transaction'                         => 'Transactie opslaan',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Standaard financieel rapport (:start tot :end)',
    'report_audit'                              => 'Transactiehistorie-overzicht van :start tot :end',
    'report_category'                           => 'Categorierapport van :start tot :end',
    'report_double'                             => 'Debiteuren/crediteurenrapport tussen :start en :end',
    'report_budget'                             => 'Budgetrapport van :start tot :end',
    'report_tag'                                => 'Tagrapport van :start tot :end',
    'quick_link_reports'                        => 'Snelle links',
    'quick_link_examples'                       => 'Dit zijn wat voorbeelden om mee te beginnnen. Check de help-pagina\'s onder de (?)-knop voor meer info over de overzichten en de "magic words" die je kan gebruiken.',
    'quick_link_default_report'                 => 'Standaard financieel rapport',
    'quick_link_audit_report'                   => 'Transactiehistorie-overzicht',
    'report_this_month_quick'                   => 'Deze maand, alle rekeningen',
    'report_last_month_quick'                   => 'Afgelopen maand, alle rekeningen',
    'report_this_year_quick'                    => 'Dit jaar, alle rekeningen',
    'report_this_fiscal_year_quick'             => 'Huidig boekjaar, alle rekeningen',
    'report_all_time_quick'                     => 'Gehele periode, alle rekeningen',
    'reports_can_bookmark'                      => 'Je kan rapporten aan je favorieten toevoegen.',
    'incomeVsExpenses'                          => 'Inkomsten tegenover uitgaven',
    'accountBalances'                           => 'Rekeningsaldi',
    'balanceStart'                              => 'Saldo aan het begin van de periode',
    'balanceEnd'                                => 'Saldo aan het einde van de periode',
    'splitByAccount'                            => 'Per betaalrekening',
    'coveredWithTags'                           => 'Gecorrigeerd met tags',
    'leftInBudget'                              => 'Over van budget',
    'left_in_debt'                              => 'Verschuldigd bedrag',
    'sumOfSums'                                 => 'Alles bij elkaar',
    'noCategory'                                => '(zonder categorie)',
    'notCharged'                                => '(Nog) niet betaald',
    'inactive'                                  => 'Niet actief',
    'active'                                    => 'Actief',
    'difference'                                => 'Verschil',
    'money_flowing_in'                          => 'In',
    'money_flowing_out'                         => 'Uit',
    'topX'                                      => 'top :number',
    'show_full_list'                            => 'Laat hele lijst zien',
    'show_only_top'                             => 'Alleen top :number',
    'report_type'                               => 'Rapporttype',
    'report_type_default'                       => 'Standard financieel rapport',
    'report_type_audit'                         => 'Transactiehistorie-overzicht (audit)',
    'report_type_category'                      => 'Categorierapport',
    'report_type_budget'                        => 'Budgetrapport',
    'report_type_tag'                           => 'Tagrapport',
    'report_type_double'                        => 'Debiteuren/crediteurenrapport',
    'more_info_help'                            => 'Meer informatie over deze rapporten vind je in de hulppagina\'s. Klik daarvoor op het (?) icoontje rechtsboven.',
    'report_included_accounts'                  => 'Accounts in rapport',
    'report_date_range'                         => 'Datumbereik',
    'report_preset_ranges'                      => 'Standaardbereik',
    'shared'                                    => 'Gedeeld',
    'fiscal_year'                               => 'Boekjaar',
    'income_entry'                              => 'Inkomsten naar rekening ":name" tussen :start en :end',
    'expense_entry'                             => 'Uitgaven naar rekening ":name" tussen :start en :end',
    'category_entry'                            => 'Inkomen en uitgaven in categorie ":name" tussen :start en :end',
    'budget_spent_amount'                       => 'Uitgaven in budget ":budget" tussen :start en :end',
    'balance_amount'                            => 'Uitgaven in :budget betaald van rekening ":account" tussen :start en :end',
    'no_audit_activity'                         => 'Geen activiteit op betaalrekening <a href=":url" title=":account_name">:account_name</a> tussen :start en :end.',
    'audit_end_balance'                         => 'Aan het einde van de dag, :end, was het saldo van betaalrekening <a href=":url" title=":account_name">:account_name</a> :balance',
    'reports_extra_options'                     => 'Extra opties',
    'report_has_no_extra_options'               => 'Er zijn geen extra opties voor dit overzicht',
    'reports_submit'                            => 'Bekijk overzicht',
    'end_after_start_date'                      => 'Einddatum moet na begindatum liggen.',
    'select_category'                           => 'Selecteer categorie(ën)',
    'select_budget'                             => 'Selecteer budget(ten).',
    'select_tag'                                => 'Selecteer tag(s).',
    'income_per_category'                       => 'Inkomen per categorie',
    'expense_per_category'                      => 'Uitgaven per categorie',
    'expense_per_budget'                        => 'Uitgaven per budget',
    'income_per_account'                        => 'Inkomen per rekening',
    'expense_per_account'                       => 'Uitgaven per rekening',
    'expense_per_tag'                           => 'Uitgaven per tag',
    'income_per_tag'                            => 'Inkomsten per tag',
    'include_expense_not_in_budget'             => 'Inclusief uitgaven niet in deze budget(ten)',
    'include_expense_not_in_account'            => 'Inclusief uitgaven niet vanaf deze rekening(en)',
    'include_expense_not_in_category'           => 'Inclusief uitgaven niet in deze categorie(ën)',
    'include_income_not_in_category'            => 'Inclusief inkomsten niet in deze categorie(ën)',
    'include_income_not_in_account'             => 'Inclusief inkomsten niet op deze rekening(en)',
    'include_income_not_in_tags'                => 'Inclusief inkomsten niet getagged met deze tag(s)',
    'include_expense_not_in_tags'               => 'Inclusief uitgaven niet getagged met deze tag(s)',
    'everything_else'                           => 'De rest',
    'income_and_expenses'                       => 'Inkomsten en uitgaven',
    'spent_average'                             => 'Uitgegeven (gemiddeld)',
    'income_average'                            => 'Inkomsten (gemiddeld)',
    'transaction_count'                         => 'Transacties',
    'average_spending_per_account'              => 'Gemiddeld uitgegeven per rekening',
    'average_income_per_account'                => 'Gemiddeld verdiend per rekening',
    'total'                                     => 'Totaal',
    'description'                               => 'Omschrijving',
    'sum_of_period'                             => 'Som van periode',
    'average_in_period'                         => 'Gemiddelde in periode',
    'no_account_role'                           => '(geen rol)',
    'account_role_defaultAsset'                 => 'Standaard betaalrekening',
    'account_role_sharedAsset'                  => 'Gedeelde betaalrekening',
    'account_role_savingAsset'                  => 'Spaarrekening',
    'account_role_ccAsset'                      => 'Credit card',
    'account_role_cashWalletAsset'              => 'Cash',
    'budget_chart_click'                        => 'Klik op een budgetnaam in de tabel hierboven om een ​​grafiek te zien.',
    'category_chart_click'                      => 'Klik op een categorienaam in de tabel hierboven om een ​​grafiek te zien.',
    'in_out_accounts'                           => 'Inkomsten en uitgaven per combinatie',
    'in_out_accounts_per_asset'                 => 'Inkomsten en uitgaven (per betaalrekening)',
    'in_out_per_category'                       => 'Verdiend en uitgegeven per categorie',
    'out_per_budget'                            => 'Uitgaven per budget',
    'select_expense_revenue'                    => 'Selecteer debiteur+crediteur',
    'multi_currency_report_sum'                 => 'Omdat deze tabel rekeningen met diverse valuta bevat, kan het zijn dat de optelsommen nergens op slaan. De pagina valt altijd terug op je standaardvaluta.',
    'sum_in_default_currency'                   => 'Deze lijst is altijd in je standaardvaluta.',
    'net_filtered_prefs'                        => 'Deze grafiek bevat nooit betaalrekeningen die je niet het vinkje "meetellen in kapitaal" hebt gegeven.',


    // charts:
    'chart'                                     => 'Diagram',
    'month'                                     => 'Maand',
    'budget'                                    => 'Budget',
    'spent'                                     => 'Uitgegeven',
    'spent_capped'                              => 'Uitgegeven (beperkt)',
    'spent_in_budget'                           => 'Uitgegeven in budget',
    'left_to_spend'                             => 'Over om uit te geven',
    'earned'                                    => 'Verdiend',
    'overspent'                                 => 'Teveel uitgegeven',
    'left'                                      => 'Over',
    'max-amount'                                => 'Maximumbedrag',
    'min-amount'                                => 'Minimumbedrag',
    'journal-amount'                            => 'Huidig abonnement',
    'name'                                      => 'Naam',
    'expires_at'                                => 'Verloopt op',
    'date'                                      => 'Datum',
    'date_and_time'                             => 'Datum en tijd',
    'time'                                      => 'Tijd',
    'paid'                                      => 'Betaald',
    'unpaid'                                    => 'Niet betaald',
    'day'                                       => 'Dag',
    'budgeted'                                  => 'Gebudgetteerd',
    'period'                                    => 'Periode',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'In + uit deze periode',
    'sum'                                       => 'Som',
    'summary'                                   => 'Samenvatting',
    'average'                                   => 'Gemiddeld',
    'balanceFor'                                => 'Saldo op :name',
    'no_tags'                                   => '(geen tags)',
    'nothing_found'                             => '(niets gevonden)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Pagina-instellingen',
    'visible_columns'               => 'Zichtbare kolommen',
    'accounts_to_show'              => 'Zichtbare rekeningen',
    'active_accounts_only'          => 'Alleen actieve accounts',
    'in_active_accounts_only'       => 'Alleen inactieve accounts',
    'show_all_accounts'             => 'Alle rekeningen weergeven',
    'group_accounts'                => 'Rekeningen groeperen',

    // piggy banks:
    'event_history'                 => 'Gebeurtenisgeschiedenis',
    'add_money_to_piggy'            => 'Stop geld in spaarpotje ":name"',
    'piggy_bank'                    => 'Spaarpotje',
    'new_piggy_bank'                => 'Nieuw spaarpotje',
    'store_piggy_bank'              => 'Sla spaarpotje op',
    'stored_piggy_bank'             => 'Nieuw spaarpotje ":name" opgeslagen',
    'account_status'                => 'Rekeningoverzicht',
    'left_for_piggy_banks'          => 'Over voor spaarpotjes',
    'sum_of_piggy_banks'            => 'Som van spaarpotjes',
    'saved_so_far'                  => 'Gespaard',
    'saved_so_far_total'            => 'Totaal gespaard tot nu toe',
    'reset_history'                 => 'reset geschiedenis',
    'reset_history_confirm'         => 'Weet je zeker dat je de geschiedenis van dit spaarpotje wilt resetten? Dit zorgt ervoor dat het grafiekbedrag weer overeenkomt met het bedrag van het spaarpotje.',
    'piggy_history_reset'           => 'De geschiedenis van het spaarpotje is gereset',
    'left_to_save'                  => 'Te sparen',
    'suggested_amount'              => 'Voorgesteld spaarbedrag per maand',
    'add_money_to_piggy_title'      => 'Stop geld in spaarpotje ":name"',
    'remove_money_from_piggy_title' => 'Haal geld uit spaarpotje ":name"',
    'add'                           => 'Toevoegen',
    'no_money_for_piggy'            => 'Er is geen geld voor dit spaarpotje.',
    'suggested_savings_per_month'   => 'Voorgesteld per maand',

    'remove'                    => 'Verwijderen',
    'max_amount_add'            => 'Hooguit toe te voegen',
    'max_amount_remove'         => 'Hooguit te verwijderen',
    'update_piggy_button'       => 'Wijzig spaarpotje',
    'update_piggy_title'        => 'Wijzig spaarpotje ":name"',
    'updated_piggy_bank'        => 'Spaarpotje ":name" geüpdatet',
    'details'                   => 'Details',
    'events'                    => 'Gebeurtenissen',
    'target_amount'             => 'Doelbedrag',
    'start_date'                => 'Startdatum',
    'no_start_date'             => 'Geen startdatum',
    'target_date'               => 'Doeldatum',
    'no_target_date'            => 'Geen doeldatum',
    'table'                     => 'Tabel',
    'delete_piggy_bank'         => 'Verwijder spaarpotje ":name"',
    'cannot_add_amount_piggy'   => 'Kon bedrag :amount niet aan ":name" toevoegen.',
    'cannot_remove_from_piggy'  => 'Kon bedrag :amount niet weghalen uit ":name".',
    'deleted_piggy_bank'        => 'Spaarpotje ":name" verwijderd',
    'added_amount_to_piggy'     => ':amount aan ":name" toegevoegd',
    'removed_amount_from_piggy' => ':amount uit ":name" gehaald',
    'piggy_events'              => 'Gerelateerde spaarpotjes',

    // tags
    'delete_tag'                => 'Verwijder tag ":tag"',
    'deleted_tag'               => 'Tag ":tag" verwijderd',
    'new_tag'                   => 'Maak nieuwe tag',
    'edit_tag'                  => 'Wijzig tag ":tag"',
    'updated_tag'               => 'Tag ":tag" geüpdatet',
    'created_tag'               => 'Tag ":tag" opgeslagen!',

    'transaction_journal_information'               => 'Transactieinformatie',
    'transaction_journal_amount'                    => 'Bedraginformatie',
    'transaction_journal_meta'                      => 'Metainformatie',
    'transaction_journal_more'                      => 'Meer informatie',
    'basic_journal_information'                     => 'Standaard transactieinformatie',
    'transaction_journal_extra'                     => 'Extra informatie',
    'att_part_of_journal'                           => 'Opgeslagen onder ":journal"',
    'total_amount'                                  => 'Totaalbedrag',
    'number_of_decimals'                            => 'Aantal decimalen',


    // administration
    'invite_is_already_redeemed'                    => 'De uitnodiging aan ":address" is al gebruikt.',
    'invite_is_deleted'                             => 'De uitnodiging aan ":address" is verwijderd.',
    'invite_new_user_title'                         => 'Nieuwe gebruiker uitnodigen',
    'invite_new_user_text'                          => 'Als beheerder kun je gebruikers uitnodigen om zich te registreren bij jouw Firefly III-installatie. Je kan een directe link maken en deze vervolgens delen met gebruiker. Hiermee kunnen ze een account maken. De uitgenodigde gebruiker en hun uitnodigingslink verschijnen in de onderstaande tabel. Je kan die link met ze delen.',
    'invited_user_mail'                             => 'E-mailadres',
    'invite_user'                                   => 'Gebruiker uitnodigen',
    'user_is_invited'                               => 'E-mailadres ":address" is uitgenodigd voor Firefly III',
    'administration'                                => 'Administratie',
    'system_settings'                               => 'Systeeminstellingen',
    'code_already_used'                             => 'Uitnodigingscode is al gebruikt',
    'user_administration'                           => 'Gebruikersadministratie',
    'list_all_users'                                => 'Alle gebruikers',
    'all_users'                                     => 'Alle gebruikers',
    'instance_configuration'                        => 'Instellingen',
    'firefly_instance_configuration'                => 'Firefly III configuratie',
    'setting_single_user_mode'                      => 'Enkele gebruiker-modus',
    'setting_single_user_mode_explain'              => 'Standaard accepteert Firefly III maar één (1) gebruiker: jijzelf. Dit is een veiligheidsmaatregel, zodat anderen niet zomaar jouw installatie kunnen gebruiken, tenzij je dit aanzet. Toekomstige registraties zijn nu geblokkeerd. Als je dit vinkje uitzet kunnen anderen jouw installatie ook gebruiken, gegeven dat ze er bij kunnen (je installatie hangt aan het internet).',
    'store_configuration'                           => 'Configuratie opslaan',
    'single_user_administration'                    => 'Gebruikersadministratie voor :email',
    'edit_user'                                     => 'Wijzig gebruiker :email',
    'hidden_fields_preferences'                     => 'Je kan meer transactieopties inschakelen in je <a href="preferences">instellingen</a>.',
    'user_data_information'                         => 'Gebruikersgegevens',
    'user_information'                              => 'Gebruikersinformatie',
    'total_size'                                    => 'totale grootte',
    'budget_or_budgets'                             => ':count budget|:count budgetten',
    'budgets_with_limits'                           => ':count budget met een ingesteld bedrag|:count budgetten met een ingesteld bedrag',
    'nr_of_rules_in_total_groups'                   => ':count_rules regel(s) in :count_groups regelgroep(en)',
    'tag_or_tags'                                   => ':count tag|:count tags',
    'configuration_updated'                         => 'De configuratie is bijgewerkt',
    'setting_is_demo_site'                          => 'Demo website',
    'setting_is_demo_site_explain'                  => 'Als je dit aanzet doet jouw installatie alsof het een demo-site is, en dat kan problemen opleveren.',
    'block_code_bounced'                            => 'Email kwam niet aan',
    'block_code_expired'                            => 'Demo-account verlopen',
    'no_block_code'                                 => 'Geen reden of gebruiker niet geblokkeerd',
    'demo_user_export'                              => 'De demo-gebruiker kan geen gegevens exporteren',
    'block_code_email_changed'                      => 'De gebruiker heeft zijn nieuwe emailadres nog niet bevestigd',
    'admin_update_email'                            => 'Integendeel tot de profielpagina krijgt de gebruiker hier geen notificatie van!',
    'update_user'                                   => 'Gebruiker bijwerken',
    'updated_user'                                  => 'Gebruikersgegevens zijn gewijzigd.',
    'delete_user'                                   => 'Verwijder gebruiker :email',
    'user_deleted'                                  => 'De gebruiker is verwijderd',
    'send_test_email'                               => 'Stuur testmail',
    'send_test_email_text'                          => 'Druk op deze knop om te zien of je installatie mail kan versturen. Je ziet hier geen foutmeldingen (als ze er zijn), deze <strong>vind je in de logboeken</strong>. Je kan deze knop zo vaak indrukken als je wilt. Er is geen optie die spam voorkomt. Het testbericht wordt verstuurd naar <code>:email</code> en zou vrij vlot aan moeten komen.',
    'send_message'                                  => 'Verstuur bericht',
    'send_test_triggered'                           => 'Testmail verstuurd. Check je inbox en de logboeken.',
    'give_admin_careful'                            => 'Gebruikers die je beheerdersrechten geeft kunnen die van jou afpakken. Wees voorzichtig.',
    'admin_maintanance_title'                       => 'Onderhoud',
    'admin_maintanance_expl'                        => 'Handige knopjes voor Firefly III onderhoud',
    'admin_maintenance_clear_cache'                 => 'Cache leegmaken',
    'owner_notifications'                           => 'Adminnotificaties',
    'owner_notifications_expl'                      => 'De volgende meldingen kunnen worden ingeschakeld of uitgeschakeld door de admin. Deze zal via ALLE geconfigureerde kanalen worden verzonden. Sommige kanalen zijn geconfigureerd in de omgevingsvariabelen, andere kunnen hier worden ingesteld.',
    'channel_settings'                              => 'Instellingen voor meldingskanalen',
    'notification_test_failed'                      => 'Notificatietest voor kanaal ":channel" is mislukt. De logs zullen meer details hebben.',
    'notification_test_executed'                    => 'Notificatietest voor kanaal ":channel" is uitgevoerd. De logs zullen meer details hebben.',
    'settings_notifications'                        => 'Meldingsinstellingen',
    'title_owner_notifications'                     => 'Adminnotificaties',
    'owner_notification_check_user_new_reg'         => 'Gebruiker krijgt na registratie een welkomstbericht',
    'owner_notification_check_admin_new_reg'        => 'Eigenaar krijgt een melding bij nieuwe gebruikers',
    'owner_notification_check_new_version'          => 'Een nieuwe versie is beschikbaar',
    'owner_notification_check_invite_created'       => 'Een gebruiker is uitgenodigd voor Firefly III',
    'owner_notification_check_invite_redeemed'      => 'Een gebruikersuitnodiging is gebruikt',
    'owner_notification_check_unknown_user_attempt' => 'Een onbekende gebruiker heeft geprobeerd in te loggen',
    'all_invited_users'                             => 'Alle uitgenodigde gebruikers',
    'save_notification_settings'                    => 'Instellingen opslaan',
    'notification_settings'                         => 'Meldingsinstellingen',
    'notification_settings_saved'                   => 'De instellingen voor meldingen zijn opgeslagen',
    'available_channels_title'                      => 'Beschikbare kanalen',
    'available_channels_expl'                       => 'Deze kanalen zijn beschikbaar om meldingen te verzenden. Gebruik de knoppen hieronder om je configuratie te testen. Houd er rekening mee dat de knoppen geen spamcontrole hebben.',
    'notification_channel_name_email'               => 'E-mail',
    'slack_discord_double'                          => 'Het Slack notificatiekanaal kan ook meldingen verzenden naar Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'niet beschikbaar',
    'configure_channel_in_env'                      => 'heeft omgevingsvariabelen nodig',
    'test_notification_channel_name_email'          => 'Test e-mail',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Omschrijving van de gesplitste transactie',
    'split_transaction_title_help'          => 'Als je een gesplitste transactie maakt, moet er een algemene omschrijving zijn voor alle splitsingen van de transactie.',
    'split_title_help'                      => 'Als je een gesplitste transactie maakt, moet er een algemene omschrijving zijn voor alle splitsingen van de transactie.',
    'you_create_transfer'                   => 'Je maakt een overschrijving.',
    'you_create_withdrawal'                 => 'Je maakt een uitgave.',
    'you_create_deposit'                    => 'Je maakt inkomsten.',

    // links
    'journal_link_configuration'            => 'Instellingen voor transactiekoppelingen',
    'create_new_link_type'                  => 'Maak nieuw koppeltype',
    'store_new_link_type'                   => 'Sla nieuw koppeltype op',
    'update_link_type'                      => 'Update koppeltype',
    'edit_link_type'                        => 'Wijzig linktype ":name"',
    'updated_link_type'                     => 'Koppeltype ":name" gewijzigd',
    'delete_link_type'                      => 'Koppeltype ":name" verwijderen',
    'deleted_link_type'                     => 'Koppeltype ":name" verwijderd',
    'stored_new_link_type'                  => 'Koppeltype ":name" opgeslagen',
    'cannot_edit_link_type'                 => 'Kan koppeltype ":name" niet wijzigen',
    'link_type_help_name'                   => 'Bijv. "Dupliceert"',
    'link_type_help_inward'                 => 'Bijv. "dupliceert"',
    'link_type_help_outward'                => 'Bijv. "is duplicaat van"',
    'save_connections_by_moving'            => 'Sla de link tussen deze transacties op door ze te op te slaan onder een ander linktype:',
    'do_not_save_connection'                => '(gooi ook koppelingen weg)',
    'link_transaction'                      => 'Koppel transactie',
    'link_to_other_transaction'             => 'Koppel deze transactie aan een andere transactie',
    'select_transaction_to_link'            => 'Selecteer een transactie om te koppelen. De links worden door Firefly III verder niet gebruikt (behalve voor de show), maar dit gaat nog veranderen. Gebruik de box om een transactie te selecteren op ID of omschrijving. Als je je eigen linktypes wilt toevoegen moet je even in de instellingen kijken.',
    'this_transaction'                      => 'Deze transactie',
    'transaction'                           => 'Transactie',
    'comments'                              => 'Opmerkingen',
    'link_notes'                            => 'Notities voor bij de link.',
    'invalid_link_selection'                => 'Deze transacties kunnen niet worden gekoppeld',
    'selected_transaction'                  => 'Geselecteerde transactie',
    'journals_linked'                       => 'De transacties zijn gekoppeld.',
    'journals_error_linked'                 => 'Deze transacties zijn al gekoppeld.',
    'journals_link_to_self'                 => 'Je kan een transactie niet aan zichzelf koppelen',
    'journal_links'                         => 'Transactiekoppelingen',
    'this_withdrawal'                       => 'Deze uitgave',
    'this_deposit'                          => 'Deze inkomsten',
    'this_transfer'                         => 'Deze overschrijving',
    'overview_for_link'                     => 'Overzicht voor koppeltype ":name"',
    'source_transaction'                    => 'Brontransactie',
    'link_description'                      => 'Omschrijving van koppeling',
    'destination_transaction'               => 'Doeltransactie',
    'delete_journal_link'                   => 'Verwijder de koppeling tussen <a href=":source_link">:source</a> en <a href=":destination_link">:destination</a>',
    'deleted_link'                          => 'Koppeling verwijderd',

    // link translations:
    'Paid_name'                             => 'Betaald',
    'Refund_name'                           => 'Restitutie',
    'Reimbursement_name'                    => 'Vergoeding',
    'Related_name'                          => 'Gerelateerd',
    'relates to_inward'                     => 'gerelateerd aan',
    'is (partially) refunded by_inward'     => 'wordt (deels) terugbetaald door',
    'is (partially) paid for by_inward'     => 'wordt (deels) betaald door',
    'is (partially) reimbursed by_inward'   => 'wordt (deels) vergoed door',
    'inward_transaction'                    => 'Actieve transactie',
    'outward_transaction'                   => 'Passieve transactie',
    'relates to_outward'                    => 'gerelateerd aan',
    '(partially) refunds_outward'           => 'is een (gedeeltelijke) terugbetaling voor',
    '(partially) pays for_outward'          => 'betaalt (deels) voor',
    '(partially) reimburses_outward'        => 'vergoedt (deels)',
    'is (partially) refunded by'            => 'wordt (deels) terugbetaald door',
    'is (partially) paid for by'            => 'wordt (deels) betaald door',
    'is (partially) reimbursed by'          => 'wordt (deels) vergoed door',
    'relates to'                            => 'gerelateerd aan',
    '(partially) refunds'                   => 'is een (gedeeltelijke) terugbetaling voor',
    '(partially) pays for'                  => 'betaalt (deels) voor',
    '(partially) reimburses'                => 'vergoedt (deels)',

    // split a transaction:
    'splits'                                => 'Splitten',
    'add_another_split'                     => 'Voeg een split toe',
    'cannot_edit_opening_balance'           => 'Je kan het startsaldo van een rekening niet wijzigen via dit scherm.',
    'no_edit_multiple_left'                 => 'Je hebt geen geldige transacties geselecteerd.',
    'breadcrumb_convert_group'              => 'Verander transactie',
    'convert_invalid_source'                => 'Broninformatie is ongeldig voor transactie #%d.',
    'convert_invalid_destination'           => 'Doelrekeninginformatie is ongeldig voor transactie #%d.',
    'create_another'                        => 'Terug naar deze pagina voor een nieuwe transactie.',
    'after_update_create_another'           => 'Na het opslaan terug om door te gaan met wijzigen.',
    'store_as_new'                          => 'Opslaan als nieuwe transactie ipv de huidige bij te werken.',
    'reset_after'                           => 'Reset formulier na opslaan',
    'errors_submission'                     => 'Er ging iets mis. Check de errors.',
    'errors_submission_v2'                  => 'Er ging iets mis. Check de errors: {{errorMessage}}',
    'transaction_expand_split'              => 'Split uitklappen',
    'transaction_remove_split'              => 'Split verwijderen',
    'transaction_collapse_split'            => 'Split inklappen',

    // object groups
    'default_group_title_name'              => '(ongegroepeerd)',
    'default_group_title_name_plain'        => 'ongegroepeerd',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Je hebt een betaalrekening nodig!',
    'no_accounts_intro_asset'               => 'Je hebt nog geen betaalrekeningen. Betaalrekeningen zijn je meest belangrijke rekeningen: je bankrekening, spaarrekening, gedeelde rekening of zelfs je creditcard.',
    'no_accounts_imperative_asset'          => 'Om Firefly III te gebruiken moet je minstens één betaalrekening hebben. Die kan je nu maken:',
    'no_accounts_create_asset'              => 'Maak een betaalrekening',
    'no_accounts_title_expense'             => 'Je hebt een crediteur nodig!',
    'no_accounts_intro_expense'             => 'Je hebt nog geen crediteuren-rekeningen. Crediteuren zijn de plaatsen waar je geld uitgeeft, zoals winkels en supermarkten.',
    'no_accounts_imperative_expense'        => 'Crediteuren worden automatisch gemaakt als je transacties maakt, maar je kan ze ook met de hand maken. Die kan je nu maken:',
    'no_accounts_create_expense'            => 'Maak een crediteur',
    'no_accounts_title_revenue'             => 'Je hebt een debiteur nodig!',
    'no_accounts_intro_revenue'             => 'Je hebt nog geen debiteuren-rekeningen. Debiteuren zijn de plaatsen of mensen waar je geld van ontvangt, zoals je werkgever.',
    'no_accounts_imperative_revenue'        => 'Dediteuren worden automatisch aangemaakt als je transacties aanmaakt, maar je kan ze ook met de hand maken. Zoals nu:',
    'no_accounts_create_revenue'            => 'Maak een debiteur',
    'no_accounts_title_liabilities'         => 'Maak een passiva!',
    'no_accounts_intro_liabilities'         => 'Je hebt nog geen passiva. "Passiva" is de technische term voor schulden, leningen, hypotheken en meer van die dingen.',
    'no_accounts_imperative_liabilities'    => 'Je hoeft deze functie niet gebruiken maar het is handig als je zulke dingen wilt bijhouden.',
    'no_accounts_create_liabilities'        => 'Maak een passiva',
    'no_budgets_title_default'              => 'Je hebt een budget nodig',
    'no_rules_title_default'                => 'Je hebt een regel nodig',
    'no_budgets_intro_default'              => 'Je hebt nog geen budgetten. Budgetten gebruik je om je uitgaven te groeperen. Daarmee kan je je uitgaven beperken.',
    'no_rules_intro_default'                => 'Je hebt nog geen regels. Regels zijn handige automaatjes die transacties voor je kunnen verwerken.',
    'no_rules_imperative_default'           => 'Regels kunnen erg handig zijn bij het beheren van transacties. Je kan er nu een maken:',
    'no_budgets_imperative_default'         => 'Budgetten zijn de basis-gereedschappen van financieel beheer. Je kan nu een budget maken:',
    'no_budgets_create_default'             => 'Maak een budget',
    'no_rules_create_default'               => 'Maak een regel',
    'no_categories_title_default'           => 'Je hebt een categorie nodig!',
    'no_categories_intro_default'           => 'Je hebt nog geen categorieën. Categorieën gebruik je om je transacties gedetailleerd in te delen.',
    'no_categories_imperative_default'      => 'Categorieën worden automatisch aangemaakt als je transacties maakt, maar dit kan ook met de hand. Zoals nu:',
    'no_categories_create_default'          => 'Maak een categorie',
    'no_tags_title_default'                 => 'Je hebt tags nodig!',
    'no_tags_intro_default'                 => 'Je hebt nog geen tags. Tags gebruik je om je transacties te voorzien van specifieke keywords.',
    'no_tags_imperative_default'            => 'Tags worden automatisch gemaakt als je ze toevoegt aan een transactie, maar dit kan ook met de hand. Zoals nu:',
    'no_tags_create_default'                => 'Maak een tag',
    'no_transactions_title_withdrawal'      => 'Je hebt uitgaven nodig!',
    'no_transactions_intro_withdrawal'      => 'Je hebt nog geen uitgaven opgeslagen. Doe dit om te beginnen met het beheren van je financiën.',
    'no_transactions_imperative_withdrawal' => 'Heb je geld uitgegeven? Schrijf het dan op:',
    'no_transactions_create_withdrawal'     => 'Registreer een uitgave',
    'no_transactions_title_deposit'         => 'Je hebt inkomsten nodig!',
    'no_transactions_intro_deposit'         => 'Je hebt nog geen inkomsten opgeslagen. Doe dit om te beginnen met het beheren van je financiën.',
    'no_transactions_imperative_deposit'    => 'Heb je geld ontvangen? Schrijf het dan op:',
    'no_transactions_create_deposit'        => 'Registreer inkomsten',
    'no_transactions_title_transfers'       => 'Je hebt overschrijvingen nodig!',
    'no_transactions_intro_transfers'       => 'Je hebt nog geen overschrijvingen opgeslagen. Doe dit om te beginnen met het beheren van je financiën.',
    'no_transactions_imperative_transfers'  => 'Heb je geld heen-en-weer geschoven? Schrijf het dan op:',
    'no_transactions_create_transfers'      => 'Registreer een overschrijving',
    'no_piggies_title_default'              => 'Je hebt spaarpotjes nodig!',
    'no_piggies_intro_default'              => 'Je hebt nog geen spaarpotjes. Maak spaarpotjes om je spaargeld te verdelen over de zaken waar je voor wilt sparen.',
    'no_piggies_imperative_default'         => 'Heb je zaken waar je voor wilt sparen? Maak dan een spaarpotje en houd het bij:',
    'no_piggies_create_default'             => 'Maak een spaarpotje',
    'no_bills_title_default'                => 'Je hebt een abonnement nodig!',
    'no_bills_intro_default'                => 'Je hebt nog geen abonnementen. Je kan contracten gebruiken om terugkerende uitgaven bij te houden, zoals de huur of verzekeringen.',
    'no_bills_imperative_default'           => 'Heb je zulke uitgaven? Maak dan een abonnement en houd de betalingen bij:',
    'no_bills_create_default'               => 'Abonnement maken',

    // recurring transactions
    'recurrence_max_count'                  => 'Deze periodieke transacties zullen hooguit :max keer worden gemaakt, en zijn al :count keer aangemaakt.',
    'create_right_now'                      => 'Nu maken',
    'no_new_transaction_in_recurrence'      => 'Geen nieuwe transactie is aangemaakt. Misschien was deze al uitgevoerd voor deze datum?',
    'recurrences'                           => 'Periodieke transacties',
    'repeat_until_in_past'                  => 'Deze periodieke transactie stopte met herhalen op :date.',
    'recurring_calendar_view'               => 'Kalender',
    'no_recurring_title_default'            => 'Maak een periodieke transactie!',
    'no_recurring_intro_default'            => 'Je hebt nog geen periodieke transacties. Je kan deze gebruiken om er voor te zorgen dat Firefly III automatisch nieuwe transacties voor je maakt.',
    'no_recurring_imperative_default'       => 'Dit is een behoorlijk geadvanceerde functie maar het kan vreselijk handig zijn. Lees ook zeker de documentatie (?)-icoontje rechtsboven) voor je verder gaat.',
    'no_recurring_create_default'           => 'Maak een periodieke transactie',
    'make_new_recurring'                    => 'Maak een periodieke transactie',
    'recurring_daily'                       => 'Elke dag',
    'recurring_weekly'                      => 'Elke week op :weekday',
    'recurring_weekly_skip'                 => 'Elke :skip(e) week op :weekday',
    'recurring_monthly'                     => 'Elke maand op de :dayOfMonth(e) dag',
    'recurring_monthly_skip'                => 'Elke :skip(e) maand op de :dayOfMonth(e) dag',
    'recurring_ndom'                        => 'Elke maand op de :dayOfMonth(e) :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => 'Elk jaar op :date',
    'overview_for_recurrence'               => 'Overzicht voor periodieke transactie ":title"',
    'warning_duplicates_repetitions'        => 'Soms zie je hier datums dubbel staan. Dat kan als meerdere herhalingen in elkaars vaarwater zitten. Firefly III maakt altijd maar één transactie per dag.',
    'created_transactions'                  => 'Gerelateerde transacties',
    'expected_withdrawals'                  => 'Verwachte uitgaven',
    'expected_deposits'                     => 'Verwachte inkomsten',
    'expected_transfers'                    => 'Verwachte overschrijvingen',
    'created_withdrawals'                   => 'Gemaakte uitgaven',
    'created_deposits'                      => 'Gemaakte inkomsten',
    'created_transfers'                     => 'Gemaakte overschrijvingen',
    'recurring_info'                        => 'Periodieke transactie :count van :total',
    'created_from_recurrence'               => 'Gemaakt door periodieke transactie ":title" (#:id)',
    'recurring_never_cron'                  => 'Het lijkt er op dat je cronjob die nodig is voor periodieke transacties nog nooit gedraaid heeft. Niet zo gek natuurlijk als je Firefly III echt net geïnstalleerd hebt, maar denk eraan dat je dit regelt. Check de helppagina\'s via het (?)-icoontje rechtsboven.',
    'recurring_cron_long_ago'               => 'Het lijkt er op dat het meer dan 36 uur geleden is sinds de cronjob heeft gedraaid die je nodig hebt voor het maken van periodieke transacties. Weet je zeker dat deze goed is ingesteld? Check de helppagina\'s onder het (?)-icoontje rechtsboven voor meer informatie.',

    'create_new_recurrence'              => 'Maak een nieuwe periodieke transactie',
    'help_first_date'                    => 'Geef aan wanneer je de eerste transactie verwacht. Dit moet in de toekomst zijn.',
    'help_first_date_no_past'            => 'Geef aan wanneer je de eerste transactie verwacht. Firefly III zal geen transacties in het verleden maken.',
    'no_currency'                        => '(geen valuta)',
    'mandatory_for_recurring'            => 'Verplichte periodieke informatie',
    'mandatory_for_transaction'          => 'Verplichte transactieinformatie',
    'optional_for_recurring'             => 'Optionele periodieke informatie',
    'optional_for_transaction'           => 'Optionele transactieinformatie',
    'change_date_other_options'          => 'Wijzig de "eerste datum" om meer opties te zien.',
    'mandatory_fields_for_tranaction'    => 'De waarden die je hier invult worden gebruikt om de transactie(s) te maken',
    'click_for_calendar'                 => 'Hier vind je een kalender die laat zien wanneer de transactie zal herhalen.',
    'repeat_forever'                     => 'Voor altijd herhalen',
    'repeat_until_date'                  => 'Herhalen tot een datum',
    'repeat_times'                       => 'Een aantal maal herhalen',
    'recurring_skips_one'                => 'Elke tweede',
    'recurring_skips_more'               => 'Slaat :count keer over',
    'store_new_recurrence'               => 'Sla periodieke transactie op',
    'stored_new_recurrence'              => 'Periodieke transactie ":title" is opgeslagen.',
    'edit_recurrence'                    => 'Wijzig periodieke transactie ":title"',
    'recurring_repeats_until'            => 'Herhaalt tot :date',
    'recurring_repeats_forever'          => 'Blijft herhalen',
    'recurring_repeats_x_times'          => 'Herhaalt :count keer|Herhaalt :count keer',
    'update_recurrence'                  => 'Wijzig periodieke transactie',
    'updated_recurrence'                 => 'Periodieke transactie ":title" is gewijzigd',
    'recurrence_is_inactive'             => 'Deze periodieke transactie is niet actief en maakt geen transacties aan.',
    'delete_recurring'                   => 'Verwijder periodieke transactie ":title"',
    'new_recurring_transaction'          => 'Nieuwe periodieke transactie',
    'help_weekend'                       => 'Wat moet Firefly III doen als de periodieke transactie in het weekend valt?',
    'do_nothing'                         => 'Gewoon transactie maken',
    'skip_transaction'                   => 'Transactie overslaan',
    'jump_to_friday'                     => 'Transactie maken op de vrijdag ervoor',
    'jump_to_monday'                     => 'Transactie maken op de maandag erna',
    'will_jump_friday'                   => 'Wordt op de vrijdag ervoor gemaakt i.p.v. in het weekend.',
    'will_jump_monday'                   => 'Wordt op de maandag erna gemaakt i. p. v. in het weekend.',
    'except_weekends'                    => 'Behalve de weekenden',
    'recurrence_deleted'                 => 'Periodieke transactie ":title" verwijderd',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Uitgegeven (:currency)',
    'box_earned_in_currency'             => 'Verdiend (:currency)',
    'box_budgeted_in_currency'           => 'Gebudgetteerd (:currency)',
    'box_bill_paid_in_currency'          => 'Betaalde abonnementen (:currency)',
    'box_bill_unpaid_in_currency'        => 'Niet betaalde abonnementen (:currency)',
    'box_left_to_spend_in_currency'      => 'Uit te geven (:currency)',
    'box_net_worth_in_currency'          => 'Kapitaal (:currency)',
    'box_spend_per_day'                  => 'Te besteden per dag: :amount',

    // debug page
    'debug_page'                         => 'Debugpagina',
    'debug_submit_instructions'          => 'Gebruik de inhoud van dit vak als je tegen problemen aanloopt. Copy en paste dit in een nieuw of bestaand <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. Er wordt een mooie tabel gegenereerd die handig is voor de diagnose.',
    'debug_pretty_table'                 => 'Als je de content van dit vak in GitHub copypaste komt er een tabel tevoorschijn. Zet hier dus geen haakjes of quotes omheen.',
    'debug_additional_data'              => 'Je mag ook de content van deze box delen. Die kan je copy-pasten in een nieuw of bestaand <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub issue</a>. Dikke kans echter dat hier privégegevens instaan zoals rekeningnamen, transactiedetails of e-mailadressen.',

    // object groups
    'object_groups_menu_bar'             => 'Groepen',
    'object_groups_page_title'           => 'Groepen',
    'object_groups_breadcrumb'           => 'Groepen',
    'object_groups_index'                => 'Overzicht',
    'object_groups'                      => 'Groepen',
    'object_groups_empty_explain'        => 'Sommige dingen in Firefly III kan je groeperen. Spaarpotjes bijvoorbeeld hebben een "Groep"-veld als je ze wijzigt of maakt. Als je dit veld gebruikt kan je hier de namen en volgorde van die groepen wijzigen. Check de helppagina\'s, rechtsboven het (?) icoontje, voor meer info.',
    'object_group_title'                 => 'Titel',
    'edit_object_group'                  => 'Wijzig groep ":title"',
    'delete_object_group'                => 'Verwijder groep ":title"',
    'update_object_group'                => 'Groep bijwerken',
    'updated_object_group'               => 'Groep ":title" geüpdatet',
    'deleted_object_group'               => 'Groep ":title" verwijderd',
    'object_group'                       => 'Groep',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit logboek items',
    'ale_action_log_add'                 => ':amount toegevoegd aan spaarpotje ":name"',
    'ale_action_log_remove'              => ':amount is verwijderd uit spaarpotje ":name"',
    'ale_action_clear_budget'            => 'Verwijderd uit budget',
    'ale_action_update_group_title'      => 'Transactietitel bijgewerkt',
    'ale_action_update_date'             => 'Transactiedatum bijgewerkt',
    'ale_action_update_order'            => 'Transactievolgorde bijgewerkt',
    'ale_action_clear_category'          => 'Verwijderd uit categorie',
    'ale_action_clear_notes'             => 'Verwijderde notities',
    'ale_action_clear_tag'               => 'Tag gewist',
    'ale_action_clear_all_tags'          => 'Alle tags gewist',
    'ale_action_set_bill'                => 'Gekoppeld aan een abonnement',
    'ale_action_switch_accounts'         => 'Bron- en doelrekening gewisseld',
    'ale_action_set_budget'              => 'Budget ingesteld',
    'ale_action_set_category'            => 'Categorie ingesteld',
    'ale_action_set_source'              => 'Bronrekening veranderd',
    'ale_action_set_destination'         => 'Doelrekening veranderd',
    'ale_action_update_transaction_type' => 'Transactietype gewijzigd',
    'ale_action_update_notes'            => 'Notities veranderd',
    'ale_action_update_description'      => 'Omschrijving veranderd',
    'ale_action_add_to_piggy'            => 'Spaarpotje',
    'ale_action_remove_from_piggy'       => 'Spaarpotje',
    'ale_action_add_tag'                 => 'Tag toegevoegd',
    'ale_action_update_amount'           => 'Bedrag bijgewerkt',

    // dashboard
    'enable_auto_convert'                => 'Doe valutaconversie',
    'disable_auto_convert'               => 'Doe geen valutaconversie',
];
