<?php

/**
 * firefly.php
 * Copyright (c) 2019 james@firefly-iii.org
 *
 * This file is part of Firefly III (https://github.com/firefly-iii).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

declare(strict_types=1);


return [
    // general stuff:
    'stored_in_tz'                              => 'stored in ":timezone"',
    'displayed_in_tz'                           => 'displayed in ":timezone"',
    'close'                                     => 'Sulje',
    'actions'                                   => 'Toiminnot',
    'edit'                                      => 'Muokkaa',
    'loading'                                   => 'Loading',
    'transaction_journal_id'                    => 'Transaction journal ID',
    'delete'                                    => 'Poista',
    'split'                                     => 'Jaa',
    'single_split'                              => 'Jako',
    'clone'                                     => 'Kopioi',
    'clone_and_edit'                            => 'Monista ja muokkaa',
    'confirm_action'                            => 'Vahvista toiminto',
    'last_seven_days'                           => 'Viimeiset 7 päivää',
    'last_thirty_days'                          => 'Viimeiset 30 päivää',
    'last_180_days'                             => 'Viimeiset 180 päivää',
    'month_to_date'                             => 'Kuukauden alusta',
    'year_to_date'                              => 'Vuoden alusta',
    'YTD'                                       => 'Vuoden alusta',
    'welcome_back'                              => 'Mitä kuuluu?',
    'main_dashboard_page_title'                 => 'Etusivu',
    'everything'                                => 'Kaikki',
    'today'                                     => 'tänään',
    'customRange'                               => 'Muokattu jakso',
    'date_range'                                => 'Ajanjakso',
    'apply'                                     => 'Käytä',
    'select_date'                               => 'Valitse päivämäärä ...',
    'cancel'                                    => 'Peruuta',
    'from'                                      => 'Lähettäjä',
    'to'                                        => 'Saaja',
    'structure'                                 => 'Rakenne',
    'help_translating'                          => 'Tämä opasteteksti ei ole vielä saatavilla Suomeksi. <a href="https://crowdin.com/project/firefly-iii-help">Haluatko auttaa käännöstyössä?</a>',
    'showEverything'                            => 'Näytä kaikki',
    'never'                                     => 'Ei koskaan',
    'no_results_for_empty_search'               => 'Hakusi oli tyhjä, joten mitään ei löytynyt.',
    'removed_amount'                            => 'Poistettiin :amount',
    'added_amount'                              => 'Lisättiin :amount',
    'asset_account_role_help'                   => 'Kaikki valinnoistasi seuraavat lisäoptiot voidaan asettaa myöhemmin.',
    'Opening balance'                           => 'Alkusaldo',
    'create_new_stuff'                          => 'Luo uusia juttuja',
    'new_withdrawal'                            => 'Uusi nosto',
    'create_new_transaction'                    => 'Luo uusi tapahtuma',
    'sidebar_frontpage_create'                  => 'Luo',
    'new_transaction'                           => 'Uusi tapahtuma',
    'no_rules_for_bill'                         => 'This subscription has no rules associated to it.',
    'go_to_asset_accounts'                      => 'Tarkastele omaisuustilejäsi',
    'go_to_budgets'                             => 'Avaa omat budjetit',
    'go_to_withdrawals'                         => 'Siirry sinun nostoihisi',
    'clones_journal_x'                          => 'Tämä on kopio tapahtumasta ":description" (#:id)',
    'go_to_categories'                          => 'Avaa omat kategoriat',
    'go_to_bills'                               => 'Siirry tilauksiisi',
    'go_to_expense_accounts'                    => 'Tarkastele kulutustilejäsi',
    'go_to_revenue_accounts'                    => 'Tarkastele tuottotilejäsi',
    'go_to_piggies'                             => 'Tarkastele säästöpossujasi',
    'new_deposit'                               => 'Uusi talletus',
    'new_transfer'                              => 'Uusi siirto',
    'new_transfers'                             => 'Uusi siirto',
    'new_asset_account'                         => 'Uusi omaisuustili',
    'new_expense_account'                       => 'Uusi kulutustili',
    'new_revenue_account'                       => 'Uusi tuottotili',
    'new_liabilities_account'                   => 'Uusi laina',
    'new_budget'                                => 'Uusi budjetti',
    'new_bill'                                  => 'Uusi tilaus',
    'block_account_logout'                      => 'Sinut on kirjattu ulos. Estetyt käyttäjät eivät pysty käyttämään tätä sivustoa. Rekisteröidyitkö oikealla sähköpostiosoitteella?',
    'flash_success'                             => 'Valmista tuli!',
    'flash_info'                                => 'Viesti',
    'flash_warning'                             => 'Varoitus!',
    'flash_error'                               => 'Virhe!',
    'flash_danger'                              => 'Vaara!',
    'flash_info_multiple'                       => 'Sinulle on yksi viesti|Sinulle on :count viestiä',
    'flash_error_multiple'                      => 'On tapahtunut virhe|On tapahtunut :count virhettä',
    'net_worth'                                 => 'Varallisuus',
    'help_for_this_page'                        => 'Opastus tälle sivulle',
    'help_for_this_page_body'                   => 'Löydät lisätietoja tästä sivusta <a href="https://docs.firefly-iii.org/">dokumentaatiosta</a>.',
    'two_factor_welcome'                        => 'Tervehdys!',
    'two_factor_enter_code'                     => 'Jatkaaksesi, anna kaksivaiheisen tunnistautumisen koodi. Tunnistautumisohjelmasi voi luoda sen sinulle.',
    'two_factor_code_here'                      => 'Kirjoita koodi tähän',
    'two_factor_title'                          => 'Kaksivaiheinen tunnistautuminen',
    'authenticate'                              => 'Tunnistaudu',
    'two_factor_forgot_title'                   => 'Kaksivaiheisen tunnistuksen tiedot ovat hävinneet',
    'two_factor_forgot'                         => 'Unohdin kaksivaiheisen tunnistusjuttuni.',
    'two_factor_lost_header'                    => 'Unohdit kaksivaiheisen tunnistuksen koodisi?',
    'two_factor_lost_intro'                     => 'Jos olet hävittänyt myös varakoodisi, onnesi on kääntynyt. Tätä et ikävä kyllä pysty korjaamaan selaimella. Sinulla on nyt kaksi vaihtoehtoa.',
    'two_factor_lost_fix_self'                  => 'Jos käytät omaa Firefly III -instanssia, lue <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">tämä kohta </a> usein kysytyissä kysymyksissä saadaksesi ohjeet.',
    'two_factor_lost_fix_owner'                 => 'Muussa tapauksessa, ota yhteyttä ylläpitäjään, <a href="mailto::site_owner">:site_owner</a> ja pyydä että kaksivaiheinen tunnistautumisesi nollataan.',
    'mfa_backup_code'                           => 'Olet käyttänyt varakoodin kirjautuessasi Firefly III:een. Varakoodi on kertakäyttöinen, joten muista merkitä se käytetyksi.',
    'pref_two_factor_new_backup_codes'          => 'Luo uudet varmistuskoodit',
    'pref_two_factor_backup_code_count'         => 'Sinulla on :count voimassa oleva varmuuskopiokoodi.|Sinulla on :count voimassa olevaa varmuuskopiokoodia.',
    '2fa_i_have_them'                           => 'Tallensin ne!',
    'warning_much_data'                         => ':days päivän tietojen lataus saattaa kestää jonkin aikaa.',
    'registered'                                => 'Rekisteröitymisesi onnistui!',
    'Default asset account'                     => 'Oletusomaisuustili',
    'no_budget_pointer'                         => 'Sinulla ei näytä olevan vielä budjetteja. Sinun pitäisi luoda joitakin <a href="budgets">budjetit</a>-sivulla. Budjetit auttavat sinua pitämään kirjaa kuluista.',
    'no_bill_pointer'                           => 'You seem to have no subscription yet. You should create some on the <a href="subscriptions">subscription</a>-page. Subscriptions can help you keep track of expenses.',
    'Savings account'                           => 'Säästötili',
    'Credit card'                               => 'Luottokortti',
    'source_accounts'                           => 'Lähdetili|Lähdetilit',
    'destination_accounts'                      => 'Kohdetili|Kohdetilit',
    'user_id_is'                                => 'Käyttäjätunnuksesi on <strong>:user</strong>',
    'field_supports_markdown'                   => 'Tämä kenttä tukee <a href="https://en.support.wordpress.com/markdown-quick-reference/">Markdownia</a>.',
    'need_more_help'                            => 'Jos tarvitset lisäopastusta Firefly III:n käyttöön, <a href="https://github.com/firefly-iii/firefly-iii/issues">avaa tiketti Githubissa (englanniksi)</a>.',
    'reenable_intro_text'                       => 'Täältä voit kytkeä <a href="#" id="reenableGuidance">esittelytoiminnon</a> uudelleen päälle.',
    'intro_boxes_after_refresh'                 => 'Esittelytekstit ilmestyvät jälleen kun päivität tämän sivun.',
    'show_all_no_filter'                        => 'Näytä kaikki tapahtumat ryhmittelemättä niitä päivämäärittäin.',
    'expenses_by_category'                      => 'Kustannukset kategorioittain',
    'expenses_by_budget'                        => 'Kustannukset budjeteittain',
    'income_by_category'                        => 'Tulot kategorioittain',
    'expenses_by_asset_account'                 => 'Kulut omaisuustileittäin',
    'expenses_by_expense_account'               => 'Expenses by destination account',
    'cannot_redirect_to_account'                => 'Firefly III ei pysty ohjaamaan sinua oikealle sivulle. Pahoittelut.',
    'sum_of_expenses'                           => 'Kulut yhteensä',
    'sum_of_income'                             => 'Tulot yhteensä',
    'liabilities'                               => 'Lainat',
    'spent_in_specific_budget'                  => 'Kulutettu budjetista ":budget"',
    'spent_in_specific_double'                  => 'Kulutettu tililtä ":account"',
    'earned_in_specific_double'                 => 'Tulot tilillä ":account"',
    'source_account'                            => 'Lähdetili',
    'source_account_reconciliation'             => 'Et voi muokata täsmäytystapahtuman lähdetiliä.',
    'destination_account'                       => 'Kohdetili',
    'destination_account_reconciliation'        => 'Et voi muokata täsmäytystapahtuman kohdetiliä.',
    'sum_of_expenses_in_budget'                 => 'Kulutettu yhteensä budjetista ":budget"',
    'left_in_budget_limit'                      => 'Budjetissa jäljellä',
    'current_period'                            => 'Nykyinen jakso',
    'show_the_current_period_and_overview'      => 'Näytä nykyinen jakso sekä yhteenveto',
    'pref_languages_locale'                     => 'Jotta muut kielet kuin Englanti toimisivat oikein, käyttöjärjestelmässäsi täytyy olla myös vastaavat kieliasetukset. Jos näitä ei ole, valuuttatiedot, päivämäärät ja summat voivat näkyä väärin.',
    'budget_in_period'                          => 'Kaikki tapahtumat budjetissa ":name" välillä :start ja :end valuutassa :currency',
    'chart_budget_in_period'                    => 'Kuvaaja kaikista tapahtumista budjetissa ":name" välillä :start ja :end valuutassa :currency',
    'chart_budget_in_period_only_currency'      => 'Budjetoitu summa oli merkitty valuutassa :currency, joten tämä kuvaaja näyttää tapahtumat ainoastaan samassa valuutassa :currency.',
    'chart_account_in_period'                   => 'Kuvaaja kaikista tapahtumista tilillä ":name" (:balance) välillä :start ja :end',
    'chart_category_in_period'                  => 'Kuvaaja kaikista tapahtumista kategoriassa ":name" välillä :start ja :end',
    'chart_category_all'                        => 'Kuvaaja kaikista tapahtumista kategoriassa ":name"',
    'clone_withdrawal'                          => 'Kopioi tämä nosto',
    'clone_deposit'                             => 'Kopioi tämä talletus',
    'clone_transfer'                            => 'Kopioi tämä siirto',
    'multi_select_no_selection'                 => 'Ei valintaa',
    'multi_select_select_all'                   => 'Valitse kaikki',
    'multi_select_n_selected'                   => 'valittu',
    'multi_select_all_selected'                 => 'Kaikki valitut',
    'multi_select_filter_placeholder'           => 'Etsi ...',
    'intro_next_label'                          => 'Seuraava',
    'intro_prev_label'                          => 'Edellinen',
    'intro_skip_label'                          => 'Ohita',
    'intro_done_label'                          => 'Valmis',
    'between_dates_breadcrumb'                  => 'Välillä :start ja :end',
    'all_journals_without_budget'               => 'Kaikki budjetoimattomat tapahtumat',
    'journals_without_budget'                   => 'Budjetoimattomat tapahtumat',
    'all_journals_without_category'             => 'Kaikki tapahtumat ilman kategoriaa',
    'journals_without_category'                 => 'Tapahtumat ilman kategoriaa',
    'all_journals_for_account'                  => 'Kaikki tapahtumat tilillä :name',
    'chart_all_journals_for_account'            => 'Kuvaaja kaikista tapahtumista tilillä :name',
    'journals_in_period_for_account'            => 'Kaikki tapahtumat tilillä :name välillä :start ja :end',
    'journals_in_period_for_account_js'         => 'Kaikki tapahtumat tilillä {title} välillä {start} ja {end}',
    'transferred'                               => 'Siirretty',
    'all_withdrawal'                            => 'Kaikki kustannukset',
    'all_transactions'                          => 'Kaikki tapahtumat',
    'title_withdrawal_between'                  => 'Kaikki kustannukset välillä :start ja :end',
    'all_deposit'                               => 'Kaikki tuotot',
    'title_deposit_between'                     => 'Kaikki tuotot välillä :start ja :end',
    'all_transfers'                             => 'Kaikki siirrot',
    'title_transfers_between'                   => 'Kaikki siirrot välillä :start ja :end',
    'all_transfer'                              => 'Kaikki siirrot',
    'all_journals_for_tag'                      => 'Kaikki tapahtumat tägillä ":tag"',
    'title_transfer_between'                    => 'Kaikki siirrot välillä :start ja :end',
    'all_journals_for_category'                 => 'Kaikki tapahtumat kategoriassa :name',
    'all_journals_for_budget'                   => 'Kaikki tapahtumat budjetissa :name',
    'chart_all_journals_for_budget'             => 'Kuvaaja kaikista tapahtumista budjetissa :name',
    'journals_in_period_for_category'           => 'Kaikki tapahtumat kategoriassa :name välillä :start ja :end',
    'journals_in_period_for_tag'                => 'Kaikki tapahtumat tägillä :tag välillä :start ja :end',
    'not_available_demo_user'                   => 'Tämä toiminto ei ole käytössä esittelytilassa.',
    'exchange_rate_instructions'                => 'Asset account "@name" only accepts transactions in @primary_currency. If you wish to use @foreign_currency instead, make sure that the amount in @primary_currency is known as well:',
    'transfer_exchange_rate_instructions'       => 'Lähdetili "@source_name" hyväksyy tapahtumia ainoastaan valuutassa @source_currency. Kohdetili "@dest_name" hyväksyy tapahtumia ainoastaan valuutassa @dest_currency. Siirretty summa täytyy syöttää oikein - molemmilla valuutoilla.',
    'transaction_data'                          => 'Tapahtuman tiedot',
    'invalid_server_configuration'              => 'Serverin asetukset eivät ole kunnossa',
    'invalid_locale_settings'                   => 'Firefly III is unable to format monetary amounts because your server is missing the required packages. There are <a href="https://docs.firefly-iii.org/how-to/firefly-iii/advanced/locales/">instructions how to do this</a>.',
    'quickswitch'                               => 'Pikakytkin',
    'sign_in_to_start'                          => 'Aloita istunto kirjautumalla sisään',
    'sign_in'                                   => 'Kirjaudu sisään',
    'register_new_account'                      => 'Rekisteröi uusi käyttäjätili',
    'forgot_my_password'                        => 'Unohdin salasanani',
    'problems_with_input'                       => 'Antamiesi tietojen kanssa oli ongelmia.',
    'reset_password'                            => 'Nollaa salasanasi',
    'button_reset_password'                     => 'Nollaa salasana',
    'reset_button'                              => 'Nollaa',
    'want_to_login'                             => 'Haluan kirjautua',
    'login_page_title'                          => 'Kirjaudu Firefly III:een',
    'register_page_title'                       => 'Rekisteröidy Firefly III:een',
    'forgot_pw_page_title'                      => 'Unohdit salasanasi Firefly III:een',
    'reset_pw_page_title'                       => 'Nollaa salasanasi Firefly III:een',
    'cannot_reset_demo_user'                    => 'Demokäyttäjän salasanaa ei voi nollata.',
    'no_att_demo_user'                          => 'Demokäyttäjä ei voi lähettää liitteitä.',
    'button_register'                           => 'Rekisteröidy',
    'authorization'                             => 'Valtuutus',
    'active_bills_only'                         => 'active subscription only',
    'active_bills_only_total'                   => 'all active subscriptions',
    'active_exp_bills_only'                     => 'active and expected subscriptions only',
    'active_exp_bills_only_total'               => 'all active expected subscriptions only',
    'per_period_sum_1D'                         => 'Odotettavissa olevat päivittäiset kulut',
    'per_period_sum_1W'                         => 'Odotettavissa olevat viikottaiset kulut',
    'per_period_sum_1M'                         => 'Odotettavissa olevat kuukausittaiset kulut',
    'per_period_sum_3M'                         => 'Odotettavissa olevat neljännesvuosittaiset kustannukset',
    'per_period_sum_6M'                         => 'Odotettavissa olevat puolivuotiskulut',
    'per_period_sum_1Y'                         => 'Odotettavissa olevat vuotuiset kulut',
    'average_per_bill'                          => 'average per subscription',
    'expected_total'                            => 'odotettavissa yhteensä',
    'reconciliation_account_name'               => ':name täsmäytys (:currency)',
    'saved'                                     => 'Tallennettu',
    'advanced_options'                          => 'Lisävalinnat',
    'advanced_options_explain'                  => 'Joillakin Firefly III:n sivuilla on lisäasetukset piilossa tämän painikkeen takana. Tällä sivulla täällä ei ole mitään hienoa, mutta tutustu muihin!',
    'here_be_dragons'                           => 'Hic sunt dracones',
    'bad_date_transaction'                      => 'Firefly III has detected you have transactions from before the year 1970. Please correct these transactions at your earliest convenience.',

    // Webhooks
    'webhooks'                                  => 'Webhookit',
    'webhooks_breadcrumb'                       => 'Verkkotoimintokutsut',
    'webhooks_menu_disabled'                    => 'disabled',
    'no_webhook_messages'                       => 'Verkkotoimintokutsuviestejä ei ole',
    'webhook_trigger_ANY'         => 'After any event',
    'webhook_trigger_STORE_TRANSACTION'         => 'After transaction creation',
    'webhook_trigger_UPDATE_TRANSACTION'        => 'After transaction update',
    'webhook_trigger_DESTROY_TRANSACTION'       => 'After transaction delete',
    'webhook_trigger_STORE_BUDGET'              => 'After budget creation',
    'webhook_trigger_UPDATE_BUDGET'             => 'After budget update',
    'webhook_trigger_DESTROY_BUDGET'            => 'After budget delete',
    'webhook_trigger_STORE_UPDATE_BUDGET_LIMIT' => 'After budgeted amount change',
    'webhook_response_TRANSACTIONS'             => 'Transaction details',
    'webhook_response_ACCOUNTS'                 => 'Tilin tiedot',
    'webhook_response_BUDGET'                   => 'Budget details',
    'webhook_response_RELEVANT'                 => 'Relevant details',
    'webhook_response_NONE'                     => 'No details',
    'webhook_delivery_JSON'                     => 'JSON',
    'inspect'                                   => 'Inspect',
    'create_new_webhook'                        => 'Create new webhook',
    'webhooks_create_breadcrumb'                => 'Create new webhook',
    'webhook_trigger_form_help'                 => 'Indicate on what event the webhook will trigger',
    'webhook_response_form_help'                => 'Indicate what the webhook must submit to the URL.',
    'webhook_delivery_form_help'                => 'Which format the webhook must deliver data in.',
    'webhook_active_form_help'                  => 'The webhook must be active or it won\'t be called.',
    'stored_new_webhook'                        => 'Stored new webhook ":title"',
    'delete_webhook'                            => 'Delete webhook',
    'deleted_webhook'                           => 'Deleted webhook ":title"',
    'edit_webhook'                              => 'Edit webhook ":title"',
    'updated_webhook'                           => 'Updated webhook ":title"',
    'edit_webhook_js'                           => 'Edit webhook "{title}"',
    'show_webhook'                              => 'Webhook ":title"',
    'webhook_was_triggered'                     => 'The webhook was triggered on the indicated transaction. Please wait for results to appear.',
    'webhook_messages'                          => 'Webhook message',
    'view_message'                              => 'View message',
    'view_attempts'                             => 'View failed attempts',
    'message_content_title'                     => 'Webhook message content',
    'message_content_help'                      => 'This is the content of the message that was sent (or tried) using this webhook.',
    'attempt_content_title'                     => 'Webhook attempts',
    'attempt_content_help'                      => 'These are all the unsuccessful attempts of this webhook message to submit to the configured URL. After some time, Firefly III will stop trying.',
    'no_attempts'                               => 'There are no unsuccessful attempts. That\'s a good thing!',
    'webhook_attempt_at'                        => 'Attempt at {moment}',
    'logs'                                      => 'Lokitiedot',
    'response'                                  => 'Response',
    'visit_webhook_url'                         => 'Visit webhook URL',
    'reset_webhook_secret'                      => 'Reset webhook secret',
    'webhook_stored_link'                       => '<a href="webhooks/show/{ID}">Webhook #{ID} ("{title}")</a> has been stored.',
    'webhook_updated_link'                      => '<a href="webhooks/show/{ID}">Webhook #{ID}</a> ("{title}") has been updated.',

    // API access
    'authorization_request'                     => 'Firefly III v:version Valtuutus Pyyntö',
    'authorization_request_intro'               => 'Sovellus "<strong>:client</strong>" pyytää lupaa saada pääsy taloushallintoosi. Haluatko sallia <strong>:client</strong> pääsyn näihin tietoihin?',
    'authorization_request_site'                => 'Sinut ohjataan uudelleen osoitteeseen <code>:url</code> joka sitten voi käyttää Firefly III -tietoja.',
    'authorization_request_invalid'             => 'Tämä käyttöoikeuspyyntö on virheellinen. Ole hyvä äläkä koskaan enää seuraa tätä linkkiä.',
    'scopes_will_be_able'                       => 'Tämä sovellus voi:',
    'button_authorize'                          => 'Valtuuta',
    'none_in_select_list'                       => '(ei mitään)',
    'no_piggy_bank'                             => '(ei säästöpossu)',
    'name_in_currency'                          => ':name valuutassa :currency',
    'paid_in_currency'                          => 'Maksettu valuutassa :currency',
    'unpaid_in_currency'                        => 'Maksamatta valuutassa :currency',
    'is_alpha_warning'                          => 'Käytät ALPHA-versiota. Varaudu virheisiin ja ongelmiin.',
    'is_beta_warning'                           => 'Käytät BETA-versiota. Varaudu virheisiin ja ongelmiin.',
    'all_destination_accounts'                  => 'Kohdetilit',
    'all_source_accounts'                       => 'Lähdetilit',
    'back_to_index'                             => 'Takaisin valikkoon',
    'cant_logout_guard'                         => 'Firefly III ei voi kirjata sinua ulos.',
    'internal_reference'                        => 'Sisäinen viite',

    // check for updates:
    'update_check_title'                        => 'Tarkista päivitykset',
    'admin_update_check_title'                  => 'Tarkista päivitykset automaattisesti',
    'admin_update_check_explain'                => 'Firefly III voi tarkistaa päivitykset puolestasi automaattisesti. Kun tämä asetus otetaan käyttöön, järjestelmä ottaa yhteyden Firefly III päivityspalvelimeen tarkistaakseen onko uusi versio julkaistu. Saat näytölle viestin kun ohjelmaan on tarjolla päivitys. Voit testata tätä viestiä käyttämällä oikeanpuoleista nappia. Valitse alla haluatko Firefly III:n tarkistavan päivitykset puolestasi.',
    'check_for_updates_permission'              => 'Firefly III can check for updates, but it needs your permission to do so. Please go to the <a href=":link">settings</a> to indicate if you would like this feature to be enabled.',
    'updates_ask_me_later'                      => 'Kysy myöhemmin',
    'updates_do_not_check'                      => 'Älä tarkista päivityksiä',
    'updates_enable_check'                      => 'Ota käyttöön päivityksen automaattinen tarkistus',
    'admin_update_check_now_title'              => 'Tarkista päivitykset nyt',
    'admin_update_check_now_explain'            => 'Jos painat tätä, Firefly III käy tarkistamassa onko nykyiseen versioosi tullut päivityksiä.',
    'check_for_updates_button'                  => 'Tarkista nyt!',
    'update_new_version_alert'                  => 'Firefly III:sta on julkaistu uusi versio. Käytät versiota :your_version, viimeisin versio :new_version on julkaistu :date.',
    'update_version_beta'                       => 'Tämä on BETA versio. Saatat törmätä hankaluuksiin.',
    'update_version_alpha'                      => 'Tämä on ALPHA versio. Saatat törmätä hankaluuksiin.',
    'update_current_dev_older'                  => 'You are running development release ":version", which is older than the latest release :new_version. Please update!',
    'update_current_dev_newer'                  => 'You are running development release ":version", which is newer than the latest release :new_version.',
    'update_current_version_alert'              => 'Käytät versiota :version, se on viimeisin julkaistu versio.',
    'update_newer_version_alert'                => 'Käytät versiota :your_version, joka on uudempi kuin viimeisin julkaistu versio, :new_version.',
    'update_check_error'                        => 'Päivityksiä tarkistettaessa tapahtui virhe: :error',
    'unknown_error'                             => 'Tuntematon virhe. Pahoittelut siitä.',
    'disabled_but_check'                        => 'Poistit päivityksen tarkistuksen käytöstä. Älä unohda tarkistaa päivityksiä aina silloin tällöin. Kiitos!',
    'admin_update_channel_title'                => 'Päivityskanava',
    'admin_update_channel_explain'              => 'Firefly III:lla on kolme päivitys-"kanavaa" jotka määrittävät kuinka kehityksen huipulla olet ominaisuuksissa, parannuksissa ja ohjelmavirheissä. Käytä "beta"-kanavaa jos olet seikkailija ja "alpha"-kanavaa jos haluat elää vaarallisesti.',
    'update_channel_stable'                     => 'Vakaa. Kaiken pitäisi toimia kuten oletat.',
    'update_channel_beta'                       => 'Beta. Uusia ominaisuuksia mutta kaikki ei välttämättä toimi kunnolla.',
    'update_channel_alpha'                      => 'Alpha. Heitämme uusia ominaisuuksia pinon päällimmäiseksi ja käytämme kaikkea mikä ei tipu tai irtoile.',

    // search
    'search'                                    => 'Hae',
    'search_query'                              => 'Kysely',
    'search_found_transactions'                 => 'Firefly III löysi :count tapahtuman :time sekunnissa.| Firefly III löysi :count tapahtumaa :time sekunnissa.',
    'search_found_more_transactions'            => 'Firefly III löysi enemmän kuin :count tapahtumaa :time sekunnissa.',
    'search_for_overview'                       => 'Firefly III is searching for transactions that fulfill <b>all</b> of the following conditions:',
    'search_for_query'                          => 'All of these words must be present: <span class="text-info">:query</span>',
    'search_for_excluded_words'                 => 'None of these words may be present: <span class="text-info">:excluded_words</span>',
    'invalid_operators_list'                    => 'Nämä hakuparametrit eivät ole kelvollisia ja ne on ohitettu.',

    // old


    'search_modifier_date_on'                             => 'Tapahtumapäivä on ":value"',
    'search_modifier_not_date_on'                         => 'Transaction date is not ":value"',
    'search_modifier_reconciled'                          => 'Transaction is reconciled',
    'search_modifier_not_reconciled'                      => 'Transaction is not reconciled',
    'search_modifier_id'                                  => 'Tapahtuman tunniste on ":value"',
    'search_modifier_not_id'                              => 'Transaction ID is not ":value"',
    'search_modifier_date_before'                         => 'Tapahtumapäivä on joko ":value" tai sitä ennen',
    'search_modifier_date_after'                          => 'Tapahtumapäivä on joko ":value" tai sen jälkeen',
    'search_modifier_external_id_is'                      => 'Ulkoinen tunnus on ":value"',
    'search_modifier_not_external_id_is'                  => 'Ulkoinen tunniste ei ole ":value"',
    'search_modifier_no_external_url'                     => 'Tapahtumalla ei ole ulkoista URL-osoitetta',
    'search_modifier_no_external_id'                      => 'Tapahtumalla ei ole ulkoista tunnistetta',
    'search_modifier_not_any_external_url'                => 'Tapahtumalla ei ole ulkoista URL-osoitetta',
    'search_modifier_not_any_external_id'                 => 'Tapahtumalla ei ole ulkoista tunnistetta',
    'search_modifier_any_external_url'                    => 'Tapahtumalla on oltava ulkoinen URL (mikä tahansa)',
    'search_modifier_any_external_id'                     => 'Tapahtumalla on oltava (mikä tahansa) ulkoinen tunniste',
    'search_modifier_not_no_external_url'                 => 'Tapahtumalla on oltava (mikä tahansa) ulkoinen URL-osoite',
    'search_modifier_not_no_external_id'                  => 'Tapahtumalla on oltava (mikä tahansa) ulkoinen tunniste',
    'search_modifier_internal_reference_is'               => 'Sisäinen viite on ":value"',
    'search_modifier_not_internal_reference_is'           => 'Sisäinen viite ei ole ":value"',
    'search_modifier_description_starts'                  => 'Kuvaus alkaa tekstillä ":value"',
    'search_modifier_not_description_starts'              => 'Kuvaus ei ala tekstillä ":value"',
    'search_modifier_description_ends'                    => 'Kuvaus loppuu tekstiin ":value"',
    'search_modifier_not_description_ends'                => 'Kuvaus ei lopu tekstiin ":value"',
    'search_modifier_description_contains'                => 'Kuvaus sisältää ":value"',
    'search_modifier_not_description_contains'            => 'Description does not contain ":value"',
    'search_modifier_description_is'                      => 'Kuvaus on tarkalleen ":value"',
    'search_modifier_not_description_is'                  => 'Description is exactly not ":value"',
    'search_modifier_currency_is'                         => 'Tapahtuman (ulkomaan) valuutta on ":value"',
    'search_modifier_not_currency_is'                     => 'Transaction (foreign) currency is not ":value"',
    'search_modifier_foreign_currency_is'                 => 'Tapahtuman ulkomaan valuutta on ":value"',
    'search_modifier_not_foreign_currency_is'             => 'Transaction foreign currency is not ":value"',
    'search_modifier_has_attachments'                     => 'Tapahtumalla on oltava liite',
    'search_modifier_has_no_category'                     => 'Tapahtumalla ei saa olla kategoriaa',
    'search_modifier_not_has_no_category'                 => 'The transaction must have a (any) category',
    'search_modifier_not_has_any_category'                => 'The transaction must have no category',
    'search_modifier_has_any_category'                    => 'Tapahtumalla on oltava kategoria (mikä tahansa)',
    'search_modifier_has_no_budget'                       => 'Tapahtumalla ei saa olla budjettia',
    'search_modifier_not_has_any_budget'                  => 'The transaction must have no budget',
    'search_modifier_has_any_budget'                      => 'Tapahtumalla on oltava budjetti',
    'search_modifier_not_has_no_budget'                   => 'The transaction must have a (any) budget',
    'search_modifier_has_no_bill'                         => 'The transaction must have no subscription',
    'search_modifier_not_has_no_bill'                     => 'The transaction must have a (any) subscription',
    'search_modifier_has_any_bill'                        => 'The transaction must have a (any) subscription',
    'search_modifier_not_has_any_bill'                    => 'The transaction must have no subscription',
    'search_modifier_has_no_tag'                          => 'Tapahtumalla ei saa olla tageja',
    'search_modifier_not_has_any_tag'                     => 'The transaction must have no tags',
    'search_modifier_not_has_no_tag'                      => 'The transaction must have a (any) tag',
    'search_modifier_has_any_tag'                         => 'Tapahtumalla on oltava tagi (mikä tahansa)',
    'search_modifier_notes_contains'                      => 'The transaction notes contain ":value"',
    'search_modifier_not_notes_contains'                  => 'The transaction notes do not contain ":value"',
    'search_modifier_notes_starts'                        => 'The transaction notes start with ":value"',
    'search_modifier_not_notes_starts'                    => 'The transaction notes do not start with ":value"',
    'search_modifier_notes_ends'                          => 'The transaction notes end with ":value"',
    'search_modifier_not_notes_ends'                      => 'The transaction notes do not end with ":value"',
    'search_modifier_notes_is'                            => 'The transaction notes are exactly ":value"',
    'search_modifier_not_notes_is'                        => 'The transaction notes are exactly not ":value"',
    'search_modifier_no_notes'                            => 'Tapahtumalla ei ole muistiinpanoja',
    'search_modifier_not_no_notes'                        => 'The transaction must have notes',
    'search_modifier_any_notes'                           => 'Tapahtumalla on oltava muistiinpanoja',
    'search_modifier_not_any_notes'                       => 'The transaction has no notes',
    'search_modifier_amount_is'                           => 'Summa on tarkalleen :value',
    'search_modifier_not_amount_is'                       => 'Amount is not :value',
    'search_modifier_amount_less'                         => 'Summa on pienempi tai yhtä suuri kuin :value',
    'search_modifier_not_amount_more'                     => 'Amount is less than or equal to :value',
    'search_modifier_amount_more'                         => 'Summa on suurempi tai yhtä suuri kuin :value',
    'search_modifier_not_amount_less'                     => 'Amount is more than or equal to :value',
    'search_modifier_source_account_is'                   => 'Lähdetilin nimi on täsmälleen ":value"',
    'search_modifier_not_source_account_is'               => 'Source account name is not ":value"',
    'search_modifier_source_account_contains'             => 'Lähdetilin nimi sisältää ":value"',
    'search_modifier_not_source_account_contains'         => 'Source account name does not contain ":value"',
    'search_modifier_source_account_starts'               => 'Lähdetilin nimi alkaa ":value"',
    'search_modifier_not_source_account_starts'           => 'Source account name does not start with ":value"',
    'search_modifier_source_account_ends'                 => 'Lähdetilin nimi päättyy ":value"',
    'search_modifier_not_source_account_ends'             => 'Source account name does not end with ":value"',
    'search_modifier_source_account_id'                   => 'Lähdetilin tunnus on :value',
    'search_modifier_not_source_account_id'               => 'Lähdetilin tunnus ei ole :value',
    'search_modifier_source_account_nr_is'                => 'Lähdetilin numero (IBAN) on ":value"',
    'search_modifier_not_source_account_nr_is'            => 'Lähdetilin tilinumero (IBAN) ei ole ":value"',
    'search_modifier_source_account_nr_contains'          => 'Lähdetilin numero (IBAN) sisältää ":value"',
    'search_modifier_not_source_account_nr_contains'      => 'Lähdetilin tilinumero (IBAN) ei sisällä ":value"',
    'search_modifier_source_account_nr_starts'            => 'Lähdetilin numero (IBAN) alkaa ":value"',
    'search_modifier_not_source_account_nr_starts'        => 'Lähdetilin tilinumero (IBAN) ei ala ":value"',
    'search_modifier_source_account_nr_ends'              => 'Lähdetilin tilinumero (IBAN) loppuu ":value"',
    'search_modifier_not_source_account_nr_ends'          => 'Lähdetilin tilinumero (IBAN) ei lopu ":value"',
    'search_modifier_destination_account_is'              => 'Kohdetilin nimi on täsmälleen ":value"',
    'search_modifier_not_destination_account_is'          => 'Kohdetilin nimi ei ole ":value"',
    'search_modifier_destination_account_contains'        => 'Kohdetilin nimi sisältää ":value"',
    'search_modifier_not_destination_account_contains'    => 'Destination account name does not contain ":value"',
    'search_modifier_destination_account_starts'          => 'Kohdetilin nimi alkaa ":value"',
    'search_modifier_not_destination_account_starts'      => 'Destination account name does not start with ":value"',
    'search_modifier_destination_account_ends'            => 'Destination account name ends on ":value"',
    'search_modifier_not_destination_account_ends'        => 'Destination account name does not end on ":value"',
    'search_modifier_destination_account_id'              => 'Kohdetilin tunnus on :value',
    'search_modifier_not_destination_account_id'          => 'Destination account ID is not :value',
    'search_modifier_destination_is_cash'                 => 'Destination account is the "(cash)" account',
    'search_modifier_not_destination_is_cash'             => 'Destination account is not the "(cash)" account',
    'search_modifier_source_is_cash'                      => 'Source account is the "(cash)" account',
    'search_modifier_not_source_is_cash'                  => 'Source account is not the "(cash)" account',
    'search_modifier_destination_account_nr_is'           => 'Kohdetilin numero (IBAN) on ":value"',
    'search_modifier_not_destination_account_nr_is'       => 'Kohdetilin tilinumero (IBAN) on ":value"',
    'search_modifier_destination_account_nr_contains'     => 'Kohdetilin numero (IBAN) sisältää ":value"',
    'search_modifier_not_destination_account_nr_contains' => 'Destination account number (IBAN) does not contain ":value"',
    'search_modifier_destination_account_nr_starts'       => 'Kohdetilin numero (IBAN) alkaa ":value"',
    'search_modifier_not_destination_account_nr_starts'   => 'Destination account number (IBAN) does not start with ":value"',
    'search_modifier_destination_account_nr_ends'         => 'Kohdetilin numero (IBAN) päättyy ":value"',
    'search_modifier_not_destination_account_nr_ends'     => 'Destination account number (IBAN) does not end with ":value"',
    'search_modifier_account_id'                          => 'Lähde- tai kohdetilin tunnus on/tunnukset ovat: :value',
    'search_modifier_not_account_id'                      => 'Source or destination account ID\'s is/are not: :value',
    'search_modifier_category_is'                         => 'Kategoria on ":value"',
    'search_modifier_not_category_is'                     => 'Kategoria ei ole ":value"',
    'search_modifier_budget_is'                           => 'Budjetti on ":value"',
    'search_modifier_not_budget_is'                       => 'Budget is not ":value"',
    'search_modifier_bill_is'                             => 'Subscription is ":value"',
    'search_modifier_not_bill_is'                         => 'Subscription is not ":value"',
    'search_modifier_transaction_type'                    => 'Tapahtuman tyyppi on ":value"',
    'search_modifier_not_transaction_type'                => 'Tapahtuman tyyppi ei ole ":value"',
    'search_modifier_tag_is'                              => 'Tägi on ":value"',
    'search_modifier_tag_contains'                        => 'Tag contains ":value"',
    'search_modifier_not_tag_contains'                    => 'Tag does not contain ":value"',
    'search_modifier_tag_ends'                            => 'Tag ends with ":value"',
    'search_modifier_tag_starts'                          => 'Tag starts with ":value"',
    'search_modifier_not_tag_is'                          => 'No tag is ":value"',
    'search_modifier_date_on_year'                        => 'Tapahtuma on vuonna ":value"',
    'search_modifier_not_date_on_year'                    => 'Transaction is not in year ":value"',
    'search_modifier_date_on_month'                       => 'Transaction is in month ":value"',
    'search_modifier_not_date_on_month'                   => 'Transaction is not in month ":value"',
    'search_modifier_date_on_day'                         => 'Transaction is on day of month ":value"',
    'search_modifier_not_date_on_day'                     => 'Transaction is not on day of month ":value"',
    'search_modifier_date_before_year'                    => 'Tapahtuman vuosi on joko ":value" tai sitä ennen',
    'search_modifier_date_before_month'                   => 'Tapahtuman kuukausi on joko ":value" tai sitä ennen',
    'search_modifier_date_before_day'                     => 'Tapahtuman kuukauden päivä on joko ":value" tai sitä ennen',
    'search_modifier_date_after_year'                     => 'Tapahtuman vuosi on joko ":value" tai sen jälkeen',
    'search_modifier_date_after_month'                    => 'Tapahtuman kuukausi on joko ":value" tai sen jälkeen',
    'search_modifier_date_after_day'                      => 'Tapahtuman kuukauden päivä on joko ":value" tai sen jälkeen',

    // new
    'search_modifier_tag_is_not'                          => 'Yksikään tunniste ei ole ":value"',
    'search_modifier_not_tag_is_not'                      => 'Tunniste on ":value"',
    'search_modifier_account_is'                          => 'Either account is ":value"',
    'search_modifier_not_account_is'                      => 'Neither account is ":value"',
    'search_modifier_account_contains'                    => 'Either account contains ":value"',
    'search_modifier_not_account_contains'                => 'Neither account contains ":value"',
    'search_modifier_account_ends'                        => 'Either account ends with ":value"',
    'search_modifier_not_account_ends'                    => 'Neither account ends with ":value"',
    'search_modifier_account_starts'                      => 'Either account starts with ":value"',
    'search_modifier_not_account_starts'                  => 'Neither account starts with ":value"',
    'search_modifier_account_nr_is'                       => 'Either account number / IBAN is ":value"',
    'search_modifier_not_account_nr_is'                   => 'Neither account number / IBAN is ":value"',
    'search_modifier_account_nr_contains'                 => 'Either account number / IBAN contains ":value"',
    'search_modifier_not_account_nr_contains'             => 'Neither account number / IBAN contains ":value"',
    'search_modifier_account_nr_ends'                     => 'Either account number / IBAN ends with ":value"',
    'search_modifier_not_account_nr_ends'                 => 'Neither account number / IBAN ends with ":value"',
    'search_modifier_account_nr_starts'                   => 'Either account number / IBAN starts with ":value"',
    'search_modifier_not_account_nr_starts'               => 'Neither account number / IBAN starts with ":value"',
    'search_modifier_category_contains'                   => 'Kategoria sisältää ":value"',
    'search_modifier_not_category_contains'               => 'Category does not contain ":value"',
    'search_modifier_category_ends'                       => 'Category ends on ":value"',
    'search_modifier_not_category_ends'                   => 'Category does not end on ":value"',
    'search_modifier_category_starts'                     => 'Kategoria alkaa ":value"',
    'search_modifier_not_category_starts'                 => 'Category does not start with ":value"',
    'search_modifier_budget_contains'                     => 'Budjetti sisältää ":value"',
    'search_modifier_not_budget_contains'                 => 'Budget does not contain ":value"',
    'search_modifier_budget_ends'                         => 'Budjetti päättyy ":value"',
    'search_modifier_not_budget_ends'                     => 'Budget does not end on ":value"',
    'search_modifier_budget_starts'                       => 'Budjetti alkaa ":value"',
    'search_modifier_not_budget_starts'                   => 'Budget does not start with ":value"',
    'search_modifier_bill_contains'                       => 'Subscription contains ":value"',
    'search_modifier_not_bill_contains'                   => 'Subscription does not contain ":value"',
    'search_modifier_bill_ends'                           => 'Subscription ends with ":value"',
    'search_modifier_not_bill_ends'                       => 'Subscription does not end on ":value"',
    'search_modifier_bill_starts'                         => 'Subscription starts with ":value"',
    'search_modifier_not_bill_starts'                     => 'Subscription does not start with ":value"',
    'search_modifier_external_id_contains'                => 'External ID contains ":value"',
    'search_modifier_not_external_id_contains'            => 'External ID does not contain ":value"',
    'search_modifier_external_id_ends'                    => 'External ID ends with ":value"',
    'search_modifier_not_external_id_ends'                => 'External ID does not end with ":value"',
    'search_modifier_external_id_starts'                  => 'External ID starts with ":value"',
    'search_modifier_not_external_id_starts'              => 'External ID does not start with ":value"',
    'search_modifier_internal_reference_contains'         => 'Sisäinen viite sisältää ":value"',
    'search_modifier_not_internal_reference_contains'     => 'Sisäinen viite ei sisällä ":value"',
    'search_modifier_internal_reference_ends'             => 'Internal reference ends with ":value"',
    'search_modifier_internal_reference_starts'           => 'Internal reference starts with ":value"',
    'search_modifier_not_internal_reference_ends'         => 'Internal reference does not end with ":value"',
    'search_modifier_not_internal_reference_starts'       => 'Internal reference does not start with ":value"',
    'search_modifier_external_url_is'                     => 'External URL is ":value"',
    'search_modifier_not_external_url_is'                 => 'External URL is not ":value"',
    'search_modifier_external_url_contains'               => 'External URL contains ":value"',
    'search_modifier_not_external_url_contains'           => 'External URL does not contain ":value"',
    'search_modifier_external_url_ends'                   => 'External URL ends with ":value"',
    'search_modifier_not_external_url_ends'               => 'External URL does not end with ":value"',
    'search_modifier_external_url_starts'                 => 'External URL starts with ":value"',
    'search_modifier_not_external_url_starts'             => 'External URL does not start with ":value"',
    'search_modifier_has_no_attachments'                  => 'Tapahtumassa ei ole liitteitä',
    'search_modifier_not_has_no_attachments'              => 'Transaction has attachments',
    'search_modifier_not_has_attachments'                 => 'Transaction has no attachments',
    'search_modifier_account_is_cash'                     => 'Either account is the "(cash)" account.',
    'search_modifier_not_account_is_cash'                 => 'Neither account is the "(cash)" account.',
    'search_modifier_journal_id'                          => 'The journal ID is ":value"',
    'search_modifier_not_journal_id'                      => 'The journal ID is not ":value"',
    'search_modifier_recurrence_id'                       => 'The recurring transaction ID is ":value"',
    'search_modifier_not_recurrence_id'                   => 'The recurring transaction ID is not ":value"',
    'search_modifier_foreign_amount_is'                   => 'The foreign amount is ":value"',
    'search_modifier_not_foreign_amount_is'               => 'The foreign amount is not ":value"',
    'search_modifier_foreign_amount_less'                 => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_more'             => 'The foreign amount is less than ":value"',
    'search_modifier_not_foreign_amount_less'             => 'The foreign amount is more than ":value"',
    'search_modifier_foreign_amount_more'                 => 'The foreign amount is more than ":value"',
    'search_modifier_exists'                              => 'Transaction exists (any transaction)',
    'search_modifier_not_exists'                          => 'Transaction does not exist (no transaction)',

    // date fields
    'search_modifier_interest_date_on'                    => 'Transaction interest date is ":value"',
    'search_modifier_not_interest_date_on'                => 'Transaction interest date is not ":value"',
    'search_modifier_interest_date_on_year'               => 'Transaction interest date is in year ":value"',
    'search_modifier_not_interest_date_on_year'           => 'Transaction interest date is not in year ":value"',
    'search_modifier_interest_date_on_month'              => 'Transaction interest date is in month ":value"',
    'search_modifier_not_interest_date_on_month'          => 'Transaction interest date is not in month ":value"',
    'search_modifier_interest_date_on_day'                => 'Transaction interest date is on day of month ":value"',
    'search_modifier_not_interest_date_on_day'            => 'Transaction interest date is not on day of month ":value"',
    'search_modifier_interest_date_before_year'           => 'Transaction interest date is before or in year ":value"',
    'search_modifier_interest_date_before_month'          => 'Transaction interest date is before or in month ":value"',
    'search_modifier_interest_date_before_day'            => 'Transaction interest date is before or on day of month ":value"',
    'search_modifier_interest_date_after_year'            => 'Transaction interest date is after or in year ":value"',
    'search_modifier_interest_date_after_month'           => 'Transaction interest date is after or in month ":value"',
    'search_modifier_interest_date_after_day'             => 'Transaction interest date is after or on day of month ":value"',
    'search_modifier_book_date_on_year'                   => 'Transaction book date is in year ":value"',
    'search_modifier_book_date_on_month'                  => 'Transaction book date is in month ":value"',
    'search_modifier_book_date_on_day'                    => 'Transaction book date is on day of month ":value"',
    'search_modifier_not_book_date_on_year'               => 'Transaction book date is not in year ":value"',
    'search_modifier_not_book_date_on_month'              => 'Transaction book date is not in month ":value"',
    'search_modifier_not_book_date_on_day'                => 'Transaction book date is not on day of month ":value"',
    'search_modifier_book_date_before_year'               => 'Transaction book date is before or in year ":value"',
    'search_modifier_book_date_before_month'              => 'Transaction book date is before or in month ":value"',
    'search_modifier_book_date_before_day'                => 'Transaction book date is before or on day of month ":value"',
    'search_modifier_book_date_after_year'                => 'Transaction book date is after or in year ":value"',
    'search_modifier_book_date_after_month'               => 'Transaction book date is after or in month ":value"',
    'search_modifier_book_date_after_day'                 => 'Transaction book date is after or on day of month ":value"',
    'search_modifier_process_date_on_year'                => 'Transaction process date is in year ":value"',
    'search_modifier_process_date_on_month'               => 'Transaction process date is in month ":value"',
    'search_modifier_process_date_on_day'                 => 'Transaction process date is on day of month ":value"',
    'search_modifier_not_process_date_on_year'            => 'Transaction process date is not in year ":value"',
    'search_modifier_not_process_date_on_month'           => 'Transaction process date is not in month ":value"',
    'search_modifier_not_process_date_on_day'             => 'Transaction process date is not on day of month ":value"',
    'search_modifier_process_date_before_year'            => 'Transaction process date is before or in year ":value"',
    'search_modifier_process_date_before_month'           => 'Transaction process date is before or in month ":value"',
    'search_modifier_process_date_before_day'             => 'Transaction process date is before or on day of month ":value"',
    'search_modifier_process_date_after_year'             => 'Transaction process date is after or in year ":value"',
    'search_modifier_process_date_after_month'            => 'Transaction process date is after or in month ":value"',
    'search_modifier_process_date_after_day'              => 'Transaction process date is after or on day of month ":value"',
    'search_modifier_due_date_on_year'                    => 'Tapahtuman eräpäivä on vuonna ":value"',
    'search_modifier_due_date_on_month'                   => 'Transaction due date is in month ":value"',
    'search_modifier_due_date_on_day'                     => 'Transaction due date is on day of month ":value"',
    'search_modifier_not_due_date_on_year'                => 'Transaction due date is not in year ":value"',
    'search_modifier_not_due_date_on_month'               => 'Transaction due date is not in month ":value"',
    'search_modifier_not_due_date_on_day'                 => 'Transaction due date is not on day of month ":value"',
    'search_modifier_due_date_before_year'                => 'Transaction due date is before or in year ":value"',
    'search_modifier_due_date_before_month'               => 'Transaction due date is before or in month ":value"',
    'search_modifier_due_date_before_day'                 => 'Transaction due date is before or on day of month ":value"',
    'search_modifier_due_date_after_year'                 => 'Transaction due date is after or in year ":value"',
    'search_modifier_due_date_after_month'                => 'Transaction due date is after or in month ":value"',
    'search_modifier_due_date_after_day'                  => 'Transaction due date is after or on day of month ":value"',
    'search_modifier_payment_date_on_year'                => 'Transaction payment date is in year ":value"',
    'search_modifier_payment_date_on_month'               => 'Transaction payment date is in month ":value"',
    'search_modifier_payment_date_on_day'                 => 'Transaction payment date is on day of month ":value"',
    'search_modifier_not_payment_date_on_year'            => 'Transaction payment date is not in year ":value"',
    'search_modifier_not_payment_date_on_month'           => 'Transaction payment date is not in month ":value"',
    'search_modifier_not_payment_date_on_day'             => 'Transaction payment date is not on day of month ":value"',
    'search_modifier_payment_date_before_year'            => 'Transaction payment date is before or in year ":value"',
    'search_modifier_payment_date_before_month'           => 'Transaction payment date is before or in month ":value"',
    'search_modifier_payment_date_before_day'             => 'Transaction payment date is before or on day of month ":value"',
    'search_modifier_payment_date_after_year'             => 'Transaction payment date is after or in year ":value"',
    'search_modifier_payment_date_after_month'            => 'Transaction payment date is after or in month ":value"',
    'search_modifier_payment_date_after_day'              => 'Transaction payment date is after or on day of month ":value"',
    'search_modifier_invoice_date_on_year'                => 'Transaction invoice date is in year ":value"',
    'search_modifier_invoice_date_on_month'               => 'Transaction invoice date is in month ":value"',
    'search_modifier_invoice_date_on_day'                 => 'Transaction invoice date is on day of month ":value"',
    'search_modifier_not_invoice_date_on_year'            => 'Transaction invoice date is not in year ":value"',
    'search_modifier_not_invoice_date_on_month'           => 'Transaction invoice date is not in month ":value"',
    'search_modifier_not_invoice_date_on_day'             => 'Transaction invoice date is not on day of month ":value"',
    'search_modifier_invoice_date_before_year'            => 'Transaction invoice date is before or in year ":value"',
    'search_modifier_invoice_date_before_month'           => 'Transaction invoice date is before or in month ":value"',
    'search_modifier_invoice_date_before_day'             => 'Transaction invoice date is before or on day of month ":value"',
    'search_modifier_invoice_date_after_year'             => 'Transaction invoice date is after or in year ":value"',
    'search_modifier_invoice_date_after_month'            => 'Transaction invoice date is after or in month ":value"',
    'search_modifier_invoice_date_after_day'              => 'Transaction invoice date is after or on day of month ":value"',
    // other dates
    'search_modifier_updated_at_on_year'                  => 'Transaction was last updated in year ":value"',
    'search_modifier_updated_at_on_month'                 => 'Transaction was last updated in month ":value"',
    'search_modifier_updated_at_on_day'                   => 'Transaction was last updated on day of month ":value"',
    'search_modifier_not_updated_at_on_year'              => 'Transaction was not last updated in year ":value"',
    'search_modifier_not_updated_at_on_month'             => 'Transaction was not last updated in month ":value"',
    'search_modifier_not_updated_at_on_day'               => 'Transaction was not last updated on day of month ":value"',
    'search_modifier_updated_at_before_year'              => 'Transaction was last updated in or before year ":value"',
    'search_modifier_updated_at_before_month'             => 'Transaction was last updated in or before month ":value"',
    'search_modifier_updated_at_before_day'               => 'Transaction was last updated on or before day of month ":value"',
    'search_modifier_updated_at_after_year'               => 'Transaction was last updated in or after year ":value"',
    'search_modifier_updated_at_after_month'              => 'Transaction was last updated in or after month ":value"',
    'search_modifier_updated_at_after_day'                => 'Transaction was last updated on or after day of month ":value"',
    'search_modifier_created_at_on_year'                  => 'Tapahtuma luotiin vuonna ":value"',
    'search_modifier_created_at_on_month'                 => 'Transaction was created in month ":value"',
    'search_modifier_created_at_on_day'                   => 'Transaction was created on day of month ":value"',
    'search_modifier_not_created_at_on_year'              => 'Transaction was not created in year ":value"',
    'search_modifier_not_created_at_on_month'             => 'Transaction was not created in month ":value"',
    'search_modifier_not_created_at_on_day'               => 'Transaction was not created on day of month ":value"',
    'search_modifier_created_at_before_year'              => 'Transaction was created in or before year ":value"',
    'search_modifier_created_at_before_month'             => 'Transaction was created in or before month ":value"',
    'search_modifier_created_at_before_day'               => 'Transaction was created on or before day of month ":value"',
    'search_modifier_created_at_after_year'               => 'Transaction was created in or after year ":value"',
    'search_modifier_created_at_after_month'              => 'Transaction was created in or after month ":value"',
    'search_modifier_created_at_after_day'                => 'Transaction was created on or after day of month ":value"',
    'search_modifier_interest_date_before'                => 'Transaction interest date is on or before ":value"',
    'search_modifier_interest_date_after'                 => 'Transaction interest date is on or after ":value"',
    'search_modifier_book_date_on'                        => 'Transaction book date is on ":value"',
    'search_modifier_not_book_date_on'                    => 'Transaction book date is not on ":value"',
    'search_modifier_book_date_before'                    => 'Transaction book date is on or before ":value"',
    'search_modifier_book_date_after'                     => 'Transaction book date is on or after ":value"',
    'search_modifier_process_date_on'                     => 'Transaction process date is on ":value"',
    'search_modifier_not_process_date_on'                 => 'Transaction process date is not on ":value"',
    'search_modifier_process_date_before'                 => 'Transaction process date is on or before ":value"',
    'search_modifier_process_date_after'                  => 'Transaction process date is on or after ":value"',
    'search_modifier_due_date_on'                         => 'Transaction due date is on ":value"',
    'search_modifier_not_due_date_on'                     => 'Transaction due date is not on ":value"',
    'search_modifier_due_date_before'                     => 'Transaction due date is on or before ":value"',
    'search_modifier_due_date_after'                      => 'Transaction due date is on or after ":value"',
    'search_modifier_payment_date_on'                     => 'Transaction payment date is on ":value"',
    'search_modifier_not_payment_date_on'                 => 'Transaction payment date is not on ":value"',
    'search_modifier_payment_date_before'                 => 'Transaction payment date is on or before ":value"',
    'search_modifier_payment_date_after'                  => 'Transaction payment date is on or after ":value"',
    'search_modifier_invoice_date_on'                     => 'Transaction invoice date is on ":value"',
    'search_modifier_not_invoice_date_on'                 => 'Transaction invoice date is not on ":value"',
    'search_modifier_invoice_date_before'                 => 'Transaction invoice date is on or before ":value"',
    'search_modifier_invoice_date_after'                  => 'Transaction invoice date is on or after ":value"',
    'search_modifier_created_at_on'                       => 'Transaction was created on ":value"',
    'search_modifier_not_created_at_on'                   => 'Transaction was not created on ":value"',
    'search_modifier_created_at_before'                   => 'Transaction was created on or before ":value"',
    'search_modifier_created_at_after'                    => 'Transaction was created on or after ":value"',
    'search_modifier_updated_at_on'                       => 'Transaction was updated on ":value"',
    'search_modifier_not_updated_at_on'                   => 'Transaction was not updated on ":value"',
    'search_modifier_updated_at_before'                   => 'Transaction was updated on or before ":value"',
    'search_modifier_updated_at_after'                    => 'Transaction was updated on or after ":value"',

    'search_modifier_attachment_name_is'            => 'Any attachment\'s name is ":value"',
    'search_modifier_attachment_name_contains'      => 'Any attachment\'s name contains ":value"',
    'search_modifier_attachment_name_starts'        => 'Any attachment\'s name starts with ":value"',
    'search_modifier_attachment_name_ends'          => 'Any attachment\'s name ends with ":value"',
    'search_modifier_attachment_notes_are'          => 'Any attachment\'s notes are ":value"',
    'search_modifier_attachment_notes_contains'     => 'Any attachment\'s notes contain ":value"',
    'search_modifier_attachment_notes_starts'       => 'Any attachment\'s notes start with ":value"',
    'search_modifier_attachment_notes_ends'         => 'Any attachment\'s notes end with ":value"',
    'search_modifier_not_attachment_name_is'        => 'Any attachment\'s name is not ":value"',
    'search_modifier_not_attachment_name_contains'  => 'Any attachment\'s name does not contain ":value"',
    'search_modifier_not_attachment_name_starts'    => 'Any attachment\'s name does not start with ":value"',
    'search_modifier_not_attachment_name_ends'      => 'Any attachment\'s name does not end with ":value"',
    'search_modifier_not_attachment_notes_are'      => 'Any attachment\'s notes are not ":value"',
    'search_modifier_not_attachment_notes_contains' => 'Any attachment\'s notes do not contain ":value"',
    'search_modifier_not_attachment_notes_starts'   => 'Any attachment\'s notes start with ":value"',
    'search_modifier_not_attachment_notes_ends'     => 'Any attachment\'s notes do not end with ":value"',
    'search_modifier_sepa_ct_is'                    => 'SEPA CT is ":value"',
    'update_rule_from_query'                        => 'Päivitä sääntö ":rule" hausta',
    'create_rule_from_query'                        => 'Luo uusi sääntö hausta',
    'rule_from_search_words'                        => 'Sääntömoottorilla on vaikeuksia käsitellä ":string". Ehdotettu sääntö, joka sopii hakuusi, voi antaa erilaisia tuloksia. Tarkista säännön ehdot huolellisesti.',

    // more new stuff
    'search_modifier_destination_balance_is'        => 'Destination account balance is exactly ":value"',
    'search_modifier_not_destination_balance_is'    => 'Destination account balance is NOT exactly ":value"',
    'search_modifier_source_balance_is'             => 'Source account balance is exactly ":value"',
    'search_modifier_not_source_balance_is'         => 'Source account balance is NOT exactly ":value"',

    'search_modifier_destination_balance_lte'     => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_not_destination_balance_lte' => 'Destination account balance is more than ":value"',
    'search_modifier_source_balance_lte'          => 'Source account balance is less than or equal to ":value"',
    'search_modifier_not_source_balance_lte'      => 'Source account balance is more than ":value"',

    'search_modifier_destination_balance_lt'     => 'Destination account balance is less than ":value"',
    'search_modifier_not_destination_balance_lt' => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_source_balance_lt'          => 'Source account balance is less than ":value"',
    'search_modifier_not_source_balance_lt'      => 'Source account balance is more than or equal to ":value"',

    'search_modifier_destination_balance_gte'     => 'Destination account balance is more than or equal to ":value"',
    'search_modifier_not_destination_balance_gte' => 'Destination account balance is less than ":value"',
    'search_modifier_source_balance_gte'          => 'Source account balance is more than or equal to ":value"',
    'search_modifier_not_source_balance_gte'      => 'Source account balance is less than ":value"',

    'search_modifier_destination_balance_gt'              => 'Destination account balance is more than ":value"',
    'search_modifier_not_destination_balance_gt'          => 'Destination account balance is less than or equal to ":value"',
    'search_modifier_source_balance_gt'                   => 'Source account balance is more than ":value"',
    'search_modifier_not_source_balance_gt'               => 'Source account balance is less than or equal to ":value"',


    // END
    'general_search_error'                                => 'Haussa tapahtui virhe. Virhe tallennettiin lokitiedostoon.',
    'search_box'                                          => 'Hae',
    'search_box_intro'                                    => 'Welcome to the search function of Firefly III. Enter your search query in the box. <a href="https://docs.firefly-iii.org/how-to/firefly-iii/features/search/">Make sure you check out the help file</a> because the search is pretty advanced.',
    'search_error'                                        => 'Hakuvirhe',
    'search_searching'                                    => 'Haetaan ...',
    'search_results'                                      => 'Haun tulokset',

    // repeat frequencies:
    'repeat_freq_yearly'                                  => 'vuosittain',
    'repeat_freq_half-year'                               => 'puoli-vuosittain',
    'repeat_freq_quarterly'                               => 'neljännesvuosittain',
    'repeat_freq_monthly'                                 => 'kuukausittain',
    'repeat_freq_weekly'                                  => 'viikoittain',
    'repeat_freq_daily'                                   => 'päivittäin',
    'daily'                                               => 'päivittäin',
    'weekly'                                              => 'viikoittain',
    'quarterly'                                           => 'neljännesvuosittain',
    'half-year'                                           => 'puoli-vuosittain',
    'yearly'                                              => 'vuosittain',

    // rules
    'is_not_rule_trigger'                                 => 'Ei ole',
    'cannot_fire_inactive_rules'                          => 'Et voi suorittaa aktivoimattomia sääntöjä.',
    'show_triggers'                                       => 'Show triggers',
    'show_actions'                                        => 'Show actions',
    'rules'                                               => 'Säännöt',
    'rule_name'                                           => 'Säännön nimi',
    'rule_triggers'                                       => 'Sääntö toteutuu kun',
    'rule_actions'                                        => 'Säännön toiminto',
    'new_rule'                                            => 'Uusi sääntö',
    'new_rule_group'                                      => 'Uusi sääntöryhmä',
    'rule_priority_up'                                    => 'Kasvata säännön tärkeysjärjestystä',
    'rule_priority_down'                                  => 'Pienennä säännön tärkeysjärjestystä',
    'make_new_rule_group'                                 => 'Luo uusi sääntöryhmä',
    'store_new_rule_group'                                => 'Tallenna uusi sääntöryhmä',
    'created_new_rule_group'                              => 'Uusi sääntöryhmä ":title" tallennettiin!',
    'updated_rule_group'                                  => 'Sääntöryhmän ":title" päivitys onnistui.',
    'edit_rule_group'                                     => 'Muokkaa sääntöryhmää ":title"',
    'duplicate_rule'                                      => 'Kopioi sääntö ":title"',
    'rule_copy_of'                                        => 'Kopioitu säännöstä ":title"',
    'duplicated_rule'                                     => 'Sääntö ":title" kopioitu uudeksi säännöksi ":newTitle"',
    'delete_rule_group'                                   => 'Poista sääntöryhmä ":title"',
    'deleted_rule_group'                                  => 'Poistettiin sääntöryhmä ":title"',
    'update_rule_group'                                   => 'Päivitä sääntöryhmä',
    'no_rules_in_group'                                   => 'Tässä ryhmässä ei ole yhtään sääntöä',
    'move_rule_group_up'                                  => 'Siirrä sääntöryhmää ylös',
    'move_rule_group_down'                                => 'Siirrä sääntöryhmää alas',
    'save_rules_by_moving'                                => 'Tallenna tämä sääntö siirtämällä se toiseen sääntöryhmään:|Tallenna nämä säännöt siirtämällä ne toiseen sääntöryhmään:',
    'make_new_rule'                                       => 'Luo uusi sääntö ryhmään ":title"',
    'make_new_rule_no_group'                              => 'Luo uusi sääntö',
    'instructions_rule_from_bill'                         => 'In order to match transactions to your new subscription ":name", Firefly III can create a rule that will automatically be checked against any transactions you store. Please verify the details below and store the rule to have Firefly III automatically match transactions to your new bill.',
    'instructions_rule_from_journal'                      => 'Luo tapahtumaasi perustuva sääntö. Täydennä tai hyväksy alla oleva lomake.',
    'rule_is_strict'                                      => 'tiukka sääntö',
    'rule_is_not_strict'                                  => 'pehmeä sääntö',
    'rule_help_stop_processing'                           => 'When you check this box, later rules in this group will not be executed if this particular rule is executed.',
    'rule_help_strict'                                    => 'Tiukoissa säännöissä KAIKKIEN ehtojen täytyy toteutua jotta toiminto tapahtuu. Pehmeissä säännöissä MINKÄ TAHANSA ehdon toteutuminen riittää toiminnon tapahtumiseen.',
    'rule_help_active'                                    => 'Aktivoimattomat säännöt eivät koskaan toteudu.',
    'stored_new_rule'                                     => 'Tallennettiin uusi sääntö nimellä ":title"',
    'deleted_rule'                                        => 'Poistettiin sääntö ":title"',
    'store_new_rule'                                      => 'Tallenna uusi sääntö',
    'updated_rule'                                        => 'Päivitettiin sääntö ":title"',
    'default_rule_group_name'                             => 'Oletussäännöt',
    'default_rule_group_description'                      => 'Kaikki ryhmittämättömät sääntösi.',
    'trigger'                                             => 'Ehto',
    'trigger_value'                                       => 'Ehdon arvo',
    'stop_processing_other_triggers'                      => 'Älä arvioi loppuja ehtoja',
    'add_rule_trigger'                                    => 'Lisää uusi ehto',
    'action'                                              => 'Toiminto',
    'action_value'                                        => 'Toiminnon arvo',
    'stop_executing_other_actions'                        => 'Älä suorita loppuja toimintoja',
    'add_rule_action'                                     => 'Lisää uusi toiminto',
    'edit_rule'                                           => 'Edit rule #:nr ":title"',
    'delete_rule'                                         => 'Poista sääntö ":title"',
    'update_rule'                                         => 'Päivitä sääntö',
    'test_rule_triggers'                                  => 'Testaa sääntöä - näytä sääntöön sopivat tapahtumat',
    'warning_no_matching_transactions'                    => 'Vastaavia tapahtumia ei löytynyt.',
    'warning_no_valid_triggers'                           => 'Yhtään kelvollista ehtoa ei ole annettu.',
    'apply_rule_selection'                                => 'Aja sääntö ":title" valitsemillesi tapahtumille',
    'apply_rule_selection_intro'                          => 'Säännöt kuten ":title" ajetaan normaalisti ainoastaan uusille tai päivitetyille tapahtumille, mutta voit pyytää Firefly III:a ajamaan sen myös sinun valitsemillesi, jo olemassa oleville tapahtumille. Tämä voi olla kätevää kun päivität sääntöä ja haluat muutosten vaikuttavan jo olemassaoleviin tapahtumiin.',
    'include_transactions_from_accounts'                  => 'Sisällytä tapahtumat näiltä tileiltä',
    'include'                                             => 'Sisällytä?',
    'applied_rule_selection'                              => '{0} Sääntö ":title" ei muuttanut yhtään tapahtumaa valinnastasi.|[1] Yhtä valintasi tapahtumaa muutettiin säännöllä ":title".|[2,*] :count tapahtumaa valinnastasi muutettiin säännöllä ":title".',
    'execute'                                             => 'Suorita',
    'apply_rule_group_selection'                          => 'Aja sääntöryhmä ":title" valituille tapahtumille',
    'apply_rule_group_selection_intro'                    => 'Sääntöryhmät kuten ":title" ajetaan normaalisti ainoastaan uusille tai päivitetyille tapahtumille, mutta voit pyytää Firefly III:a ajamaan kaikki ryhmän säännöt myös sinun valitsemillesi, jo olemassa oleville tapahtumille. Tämä voi olla kätevää kun olet päivittänyt ryhmän sääntöjä ja haluat muutosten vaikuttavan jo olemassaoleviin tapahtumiin.',
    'applied_rule_group_selection'                        => 'Sääntöryhmä ":title" on ajettu valituille tapahtumille.',

    // actions and triggers
    'rule_trigger_store_journal'                          => 'Kun tapahtuma luodaan',
    'rule_trigger_update_journal'                         => 'Kun tapahtuma päivitetään',
    'rule_trigger_manual'                                 => 'Only when user-activated',
    'rule_trigger_user_action'                            => 'Käyttäjän toiminto on ":trigger_value"',

    // OLD values (remove non-doubles later):
    'rule_trigger_source_account_starts_choice'           => 'Lähdetilin nimi alkaa ...',
    'rule_trigger_source_account_starts'                  => 'Lähdetilin nimi alkaa tekstillä ":trigger_value"',
    'rule_trigger_source_account_ends_choice'             => 'Lähdetilin nimi päättyy..',
    'rule_trigger_source_account_ends'                    => 'Lähdetilin nimi loppuu tekstiin ":trigger_value"',
    'rule_trigger_source_account_is_choice'               => 'Lähdetilin nimi on..',
    'rule_trigger_source_account_is'                      => 'Lähdetilin nimi on ":trigger_value"',
    'rule_trigger_source_account_contains_choice'         => 'Lähdetilin nimi sisältää..',
    'rule_trigger_source_account_contains'                => 'Lähdetilin nimi sisältää ":trigger_value"',
    'rule_trigger_account_id_choice'                      => 'Either account ID is exactly..',
    'rule_trigger_account_id'                             => 'Either account ID is exactly :trigger_value',
    'rule_trigger_source_account_id_choice'               => 'Lähdetili ID on tarkalleen..',
    'rule_trigger_source_account_id'                      => 'Lähdetilin tunniste on täsmälleen :trigger_value',
    'rule_trigger_destination_account_id_choice'          => 'Kohdetilin ID on tarkalleen..',
    'rule_trigger_destination_account_id'                 => 'Kohdetilin tunniste on täsmälleen :trigger_value',
    'rule_trigger_account_is_cash_choice'                 => 'Either account is cash',
    'rule_trigger_account_is_cash'                        => 'Either account is cash',
    'rule_trigger_source_is_cash_choice'                  => 'Lähdetili on (käteis) tili',
    'rule_trigger_source_is_cash'                         => 'Lähdetili on (käteis) tili',
    'rule_trigger_destination_is_cash_choice'             => 'Kohdetili on (käteis) tili',
    'rule_trigger_destination_is_cash'                    => 'Kohdetili on (käteis) tili',
    'rule_trigger_source_account_nr_starts_choice'        => 'Lähdetilin numero / IBAN alkaa..',
    'rule_trigger_source_account_nr_starts'               => 'Lähdetilin numero / IBAN alkaa ":trigger_value"',
    'rule_trigger_source_account_nr_ends_choice'          => 'Lähdetilin numero / IBAN päättyy..',
    'rule_trigger_source_account_nr_ends'                 => 'Lähdetilin numero / IBAN päättyy ":trigger_value"',
    'rule_trigger_source_account_nr_is_choice'            => 'Lähdetilin numero / IBAN on..',
    'rule_trigger_source_account_nr_is'                   => 'Lähdetilin numero / IBAN on ":trigger_value"',
    'rule_trigger_source_account_nr_contains_choice'      => 'Lähdetilin numero / IBAN sisältää..',
    'rule_trigger_source_account_nr_contains'             => 'Lähdetilin numero / IBAN sisältää ":trigger_value"',
    'rule_trigger_destination_account_starts_choice'      => 'Kohdetilin nimi alkaa..',
    'rule_trigger_destination_account_starts'             => 'Kohdetilin nimi alkaa ":trigger_value"',
    'rule_trigger_destination_account_ends_choice'        => 'Kohdetilin nimi päättyy..',
    'rule_trigger_destination_account_ends'               => 'Kohdetilin nimi päättyy ":trigger_value"',
    'rule_trigger_destination_account_is_choice'          => 'Kohdetilin nimi on..',
    'rule_trigger_destination_account_is'                 => 'Kohdetilin nimi on ":trigger_value"',
    'rule_trigger_destination_account_contains_choice'    => 'Kohdetilin nimi sisältää..',
    'rule_trigger_destination_account_contains'           => 'Kohdetilin nimi sisältää ":trigger_value"',
    'rule_trigger_destination_account_nr_starts_choice'   => 'Kohdetilin numero / IBAN alkaa..',
    'rule_trigger_destination_account_nr_starts'          => 'Kohdetilin numero / IBAN alkaa ":trigger_value"',
    'rule_trigger_destination_account_nr_ends_choice'     => 'Kohdetilin numero / IBAN päättyy..',
    'rule_trigger_destination_account_nr_ends'            => 'Kohdetilin numero / IBAN päättyy ":trigger_value"',
    'rule_trigger_destination_account_nr_is_choice'       => 'Kohdetilin numero / IBAN on..',
    'rule_trigger_destination_account_nr_is'              => 'Kohdetilin numero / IBAN on ":trigger_value"',
    'rule_trigger_destination_account_nr_contains_choice' => 'Kohdetilin numero / IBAN sisältää..',
    'rule_trigger_destination_account_nr_contains'        => 'Kohdetilin numero / IBAN sisältää ":trigger_value"',
    'rule_trigger_transaction_type_choice'                => 'Tapahtuman tyyppi on ...',
    'rule_trigger_transaction_type'                       => 'Tapahtuman tyyppi on ":trigger_value"',
    'rule_trigger_category_is_choice'                     => 'Kategoria on ...',
    'rule_trigger_category_is'                            => 'Kategoria on ":trigger_value"',
    'rule_trigger_amount_less_choice'                     => 'Amount is less than or equal to ..',
    'rule_trigger_amount_less'                            => 'Amount is less than or equal to :trigger_value',
    'rule_trigger_amount_is_choice'                       => 'Summa on..',
    'rule_trigger_amount_is'                              => 'Amount is :trigger_value',
    'rule_trigger_amount_more_choice'                     => 'Amount is more than or equal to..',
    'rule_trigger_amount_more'                            => 'Amount is more than or equal to :trigger_value',
    'rule_trigger_description_starts_choice'              => 'Kuvaus alkaa tekstillä ...',
    'rule_trigger_description_starts'                     => 'Kuvaus alkaa tekstillä ":trigger_value"',
    'rule_trigger_description_ends_choice'                => 'Kuvaus päättyy tekstiin ...',
    'rule_trigger_description_ends'                       => 'Kuvaus päättyy tekstiin ":trigger_value"',
    'rule_trigger_description_contains_choice'            => 'Kuvaus sisältää ...',
    'rule_trigger_description_contains'                   => 'Kuvaus sisältää tekstin ":trigger_value"',
    'rule_trigger_description_is_choice'                  => 'Kuvaus on ...',
    'rule_trigger_description_is'                         => 'Kuvaus on ":trigger_value"',
    'rule_trigger_date_on_choice'                         => 'Tapahtumapäivä on..',
    'rule_trigger_date_on'                                => 'Transaction date is ":trigger_value"',
    'rule_trigger_date_before_choice'                     => 'Tapahtumapäivä on ennen..',
    'rule_trigger_date_before'                            => 'Tapahtumapäivä on ennen: ":trigger_value"',
    'rule_trigger_date_after_choice'                      => 'Tapahtumapäivä on jälkeen..',
    'rule_trigger_date_after'                             => 'Tapahtumapäivä on jälkeen: ":trigger_value"',
    'rule_trigger_created_at_on_choice'                   => 'Transaction was made on..',
    'rule_trigger_created_at_on'                          => 'Transaction was made on ":trigger_value"',
    'rule_trigger_updated_at_on_choice'                   => 'Transaction was last edited on..',
    'rule_trigger_updated_at_on'                          => 'Transaction was last edited on ":trigger_value"',
    'rule_trigger_budget_is_choice'                       => 'Budjetti on ...',
    'rule_trigger_budget_is'                              => 'Budjetti on ":trigger_value"',
    'rule_trigger_tag_is_choice'                          => 'Any tag is..',
    'rule_trigger_tag_is'                                 => 'Any tag is ":trigger_value"',
    'rule_trigger_tag_contains_choice'                    => 'Any tag contains..',
    'rule_trigger_tag_contains'                           => 'Any tag contains ":trigger_value"',
    'rule_trigger_not_tag_contains'                           => 'No tag contains ":trigger_value"',
    'rule_trigger_tag_ends_choice'                        => 'Any tag ends with..',
    'rule_trigger_tag_ends'                               => 'Any tag ends with ":trigger_value"',
    'rule_trigger_tag_starts_choice'                      => 'Any tag starts with..',
    'rule_trigger_tag_starts'                             => 'Any tag starts with ":trigger_value"',
    'rule_trigger_currency_is_choice'                     => 'Tapahtuman valuutta on ...',
    'rule_trigger_currency_is'                            => 'Tapahtuman valuutta on ":trigger_value"',
    'rule_trigger_foreign_currency_is_choice'             => 'Tapahtuman valuutta on..',
    'rule_trigger_foreign_currency_is'                    => 'Tapahtuman ulkomaan valuutta on ":trigger_value"',
    'rule_trigger_has_attachments_choice'                 => 'Has any attachments',
    'rule_trigger_has_attachments'                        => 'Has any attachment(s)',
    'rule_trigger_has_no_category_choice'                 => 'Ei kategoriaa',
    'rule_trigger_has_no_category'                        => 'Tapahtumalla ei ole kategoriaa',
    'rule_trigger_has_any_category_choice'                => 'Mikä tahansa kategoria',
    'rule_trigger_has_any_category'                       => 'Tapahtumalla on kategoria (mikä tahansa)',
    'rule_trigger_has_no_budget_choice'                   => 'Ei budjettia',
    'rule_trigger_has_no_budget'                          => 'Tapahtumalla ei ole budjettia',
    'rule_trigger_has_any_budget_choice'                  => 'On budjetti (mikä tahansa)',
    'rule_trigger_has_any_budget'                         => 'Tapahtumalla on budjetti (mikä tahansa)',
    'rule_trigger_has_no_bill_choice'                     => 'Has no subscription',
    'rule_trigger_has_no_bill'                            => 'Transaction has no subscription',
    'rule_trigger_has_any_bill_choice'                    => 'Has a (any) subscription',
    'rule_trigger_has_any_bill'                           => 'Transaction has a (any) subscription',
    'rule_trigger_has_no_tag_choice'                      => 'Ei tägejä',
    'rule_trigger_has_no_tag'                             => 'Tapahtumalla ei ole tägejä',
    'rule_trigger_has_any_tag_choice'                     => 'On tägi/tägejä (mitä tahansa)',
    'rule_trigger_has_any_tag'                            => 'Tapahtumalla on tägi tai tägejä (mitä tahansa)',
    'rule_trigger_any_notes_choice'                       => 'On muistiinpano (mitä tahansa)',
    'rule_trigger_any_notes'                              => 'Tapahtumalla on muistiinpano (mitä tahansa)',
    'rule_trigger_no_notes_choice'                        => 'Ei muistiinpanoja',
    'rule_trigger_no_notes'                               => 'Tapahtumalla ei ole muistiinpanoja',
    'rule_trigger_notes_is_choice'                        => 'Notes are..',
    'rule_trigger_notes_is'                               => 'Notes are ":trigger_value"',
    'rule_trigger_notes_contains_choice'                  => 'Notes contain..',
    'rule_trigger_notes_contains'                         => 'Notes contain ":trigger_value"',
    'rule_trigger_notes_starts_choice'                    => 'Notes start with..',
    'rule_trigger_notes_starts'                           => 'Notes start with ":trigger_value"',
    'rule_trigger_notes_ends_choice'                      => 'Notes end with..',
    'rule_trigger_notes_ends'                             => 'Notes end with ":trigger_value"',
    'rule_trigger_bill_is_choice'                         => 'Subscription is..',
    'rule_trigger_bill_is'                                => 'Subscription is ":trigger_value"',
    'rule_trigger_external_id_is_choice'                  => 'External ID is..',
    'rule_trigger_external_id_is'                         => 'External ID is ":trigger_value"',
    'rule_trigger_internal_reference_is_choice'           => 'Internal reference is..',
    'rule_trigger_internal_reference_is'                  => 'Internal reference is ":trigger_value"',
    'rule_trigger_journal_id_choice'                      => 'Tapahtumatietueen tunnus on..',
    'rule_trigger_journal_id'                             => 'Tapahtumatietueen tunnus on ":trigger_value"',
    'rule_trigger_any_external_url'                       => 'Transaction has an (any) external URL',
    'rule_trigger_any_external_url_choice'                => 'Has an (any) external URL',
    'rule_trigger_any_external_id'                        => 'Transaction has an (any) external ID',
    'rule_trigger_any_external_id_choice'                 => 'Has an (any) external ID',
    'rule_trigger_no_external_url_choice'                 => 'Has no external URL',
    'rule_trigger_no_external_url'                        => 'Tapahtumalla ei ole ulkoista URL-osoitetta',
    'rule_trigger_no_external_id_choice'                  => 'Has no external ID',
    'rule_trigger_no_external_id'                         => 'Transaction has no external ID',
    'rule_trigger_id_choice'                              => 'Tapahtuman tunnus on..',
    'rule_trigger_id'                                     => 'Tapahtumatunnus on ":trigger_value"',
    'rule_trigger_sepa_ct_is_choice'                      => 'SEPA CT is..',
    'rule_trigger_sepa_ct_is'                             => 'SEPA CT is ":trigger_value"',

    // new values:
    'rule_trigger_user_action_choice'                     => 'User action is ":trigger_value"',
    'rule_trigger_tag_is_not_choice'                      => 'No tag is..',
    'rule_trigger_tag_is_not'                             => 'No tag is ":trigger_value"',
    'rule_trigger_account_is_choice'                      => 'Either account is exactly..',
    'rule_trigger_account_is'                             => 'Either account is exactly ":trigger_value"',
    'rule_trigger_account_contains_choice'                => 'Either account contains..',
    'rule_trigger_account_contains'                       => 'Either account contains ":trigger_value"',
    'rule_trigger_account_ends_choice'                    => 'Either account ends with..',
    'rule_trigger_account_ends'                           => 'Either account ends with ":trigger_value"',
    'rule_trigger_account_starts_choice'                  => 'Either account starts with..',
    'rule_trigger_account_starts'                         => 'Either account starts with ":trigger_value"',
    'rule_trigger_account_nr_is_choice'                   => 'Either account number / IBAN is..',
    'rule_trigger_account_nr_is'                          => 'Either account number / IBAN is ":trigger_value"',
    'rule_trigger_account_nr_contains_choice'             => 'Either account number / IBAN contains..',
    'rule_trigger_account_nr_contains'                    => 'Either account number / IBAN contains ":trigger_value"',
    'rule_trigger_account_nr_ends_choice'                 => 'Either account number / IBAN ends with..',
    'rule_trigger_account_nr_ends'                        => 'Either account number / IBAN ends with ":trigger_value"',
    'rule_trigger_account_nr_starts_choice'               => 'Either account number / IBAN starts with..',
    'rule_trigger_account_nr_starts'                      => 'Either account number / IBAN starts with ":trigger_value"',
    'rule_trigger_category_contains_choice'               => 'Category contains..',
    'rule_trigger_category_contains'                      => 'Category contains ":trigger_value"',
    'rule_trigger_category_ends_choice'                   => 'Category ends with..',
    'rule_trigger_category_ends'                          => 'Category ends with ":trigger_value"',
    'rule_trigger_category_starts_choice'                 => 'Category starts with..',
    'rule_trigger_category_starts'                        => 'Category starts with ":trigger_value"',
    'rule_trigger_budget_contains_choice'                 => 'Budget contains..',
    'rule_trigger_budget_contains'                        => 'Budget contains ":trigger_value"',
    'rule_trigger_budget_ends_choice'                     => 'Budget ends with..',
    'rule_trigger_budget_ends'                            => 'Budget ends with ":trigger_value"',
    'rule_trigger_budget_starts_choice'                   => 'Budget starts with..',
    'rule_trigger_budget_starts'                          => 'Budget starts with ":trigger_value"',
    'rule_trigger_bill_contains_choice'                   => 'Subscription contains..',
    'rule_trigger_bill_contains'                          => 'Subscription contains ":trigger_value"',
    'rule_trigger_bill_ends_choice'                       => 'Subscription ends with..',
    'rule_trigger_bill_ends'                              => 'Subscription ends with ":trigger_value"',
    'rule_trigger_bill_starts_choice'                     => 'Subscription starts with..',
    'rule_trigger_bill_starts'                            => 'Subscription starts with ":trigger_value"',
    'rule_trigger_external_id_contains_choice'            => 'External ID contains..',
    'rule_trigger_external_id_contains'                   => 'External ID contains ":trigger_value"',
    'rule_trigger_external_id_ends_choice'                => 'External ID ends with..',
    'rule_trigger_external_id_ends'                       => 'External ID ends with ":trigger_value"',
    'rule_trigger_external_id_starts_choice'              => 'External ID starts with..',
    'rule_trigger_external_id_starts'                     => 'External ID starts with ":trigger_value"',
    'rule_trigger_internal_reference_contains_choice'     => 'Internal reference contains..',
    'rule_trigger_internal_reference_contains'            => 'Internal reference contains ":trigger_value"',
    'rule_trigger_internal_reference_ends_choice'         => 'Internal reference ends with..',
    'rule_trigger_internal_reference_ends'                => 'Internal reference ends with ":trigger_value"',
    'rule_trigger_internal_reference_starts_choice'       => 'Internal reference starts with..',
    'rule_trigger_internal_reference_starts'              => 'Internal reference starts with ":trigger_value"',
    'rule_trigger_external_url_is_choice'                 => 'External URL is..',
    'rule_trigger_external_url_is'                        => 'External URL is ":trigger_value"',
    'rule_trigger_external_url_contains_choice'           => 'External URL contains..',
    'rule_trigger_external_url_contains'                  => 'External URL contains ":trigger_value"',
    'rule_trigger_external_url_ends_choice'               => 'External URL ends with..',
    'rule_trigger_external_url_ends'                      => 'External URL ends with ":trigger_value"',
    'rule_trigger_external_url_starts_choice'             => 'External URL starts with..',
    'rule_trigger_external_url_starts'                    => 'External URL starts with ":trigger_value"',
    'rule_trigger_has_no_attachments_choice'              => 'Has no attachments',
    'rule_trigger_has_no_attachments'                     => 'Transaction has no attachments',
    'rule_trigger_recurrence_id_choice'                   => 'Recurring transaction ID is..',
    'rule_trigger_recurrence_id'                          => 'Recurring transaction ID is ":trigger_value"',
    'rule_trigger_interest_date_on_choice'                => 'Interest date is on..',
    'rule_trigger_interest_date_on'                       => 'Interest date is on ":trigger_value"',
    'rule_trigger_interest_date_before_choice'            => 'Interest date is before..',
    'rule_trigger_interest_date_before'                   => 'Interest date is before ":trigger_value"',
    'rule_trigger_interest_date_after_choice'             => 'Interest date is after..',
    'rule_trigger_interest_date_after'                    => 'Interest date is after ":trigger_value"',
    'rule_trigger_book_date_on_choice'                    => 'Book date is on..',
    'rule_trigger_book_date_on'                           => 'Book date is on ":trigger_value"',
    'rule_trigger_book_date_before_choice'                => 'Book date is before..',
    'rule_trigger_book_date_before'                       => 'Book date is before ":trigger_value"',
    'rule_trigger_book_date_after_choice'                 => 'Book date is after..',
    'rule_trigger_book_date_after'                        => 'Book date is after ":trigger_value"',
    'rule_trigger_process_date_on_choice'                 => 'Process date is on..',
    'rule_trigger_process_date_on'                        => 'Process date is ":trigger_value"',
    'rule_trigger_process_date_before_choice'             => 'Process date is before..',
    'rule_trigger_process_date_before'                    => 'Process date is before ":trigger_value"',
    'rule_trigger_process_date_after_choice'              => 'Process date is after..',
    'rule_trigger_process_date_after'                     => 'Process date is after ":trigger_value"',
    'rule_trigger_due_date_on_choice'                     => 'Due date is on..',
    'rule_trigger_due_date_on'                            => 'Due date is on ":trigger_value"',
    'rule_trigger_due_date_before_choice'                 => 'Due date is before..',
    'rule_trigger_due_date_before'                        => 'Due date is before ":trigger_value"',
    'rule_trigger_due_date_after_choice'                  => 'Due date is after..',
    'rule_trigger_due_date_after'                         => 'Due date is after ":trigger_value"',
    'rule_trigger_payment_date_on_choice'                 => 'Payment date is on..',
    'rule_trigger_payment_date_on'                        => 'Payment date is on ":trigger_value"',
    'rule_trigger_payment_date_before_choice'             => 'Payment date is before..',
    'rule_trigger_payment_date_before'                    => 'Payment date is before ":trigger_value"',
    'rule_trigger_payment_date_after_choice'              => 'Payment date is after..',
    'rule_trigger_payment_date_after'                     => 'Payment date is after ":trigger_value"',
    'rule_trigger_invoice_date_on_choice'                 => 'Invoice date is on..',
    'rule_trigger_invoice_date_on'                        => 'Invoice date is on ":trigger_value"',
    'rule_trigger_invoice_date_before_choice'             => 'Invoice date is before..',
    'rule_trigger_invoice_date_before'                    => 'Invoice date is before ":trigger_value"',
    'rule_trigger_invoice_date_after_choice'              => 'Invoice date is after..',
    'rule_trigger_invoice_date_after'                     => 'Invoice date is after ":trigger_value"',
    'rule_trigger_created_at_before_choice'               => 'Transaction was created before..',
    'rule_trigger_created_at_before'                      => 'Transaction was created before ":trigger_value"',
    'rule_trigger_created_at_after_choice'                => 'Transaction was created after..',
    'rule_trigger_created_at_after'                       => 'Transaction was created after ":trigger_value"',
    'rule_trigger_updated_at_before_choice'               => 'Transaction was last updated before..',
    'rule_trigger_updated_at_before'                      => 'Transaction was last updated before ":trigger_value"',
    'rule_trigger_updated_at_after_choice'                => 'Transaction was last updated after..',
    'rule_trigger_updated_at_after'                       => 'Transaction was last updated after ":trigger_value"',
    'rule_trigger_foreign_amount_is_choice'               => 'Foreign amount is exactly..',
    'rule_trigger_foreign_amount_is'                      => 'Foreign amount is exactly ":trigger_value"',
    'rule_trigger_foreign_amount_less_choice'             => 'Foreign amount is less than..',
    'rule_trigger_foreign_amount_less'                    => 'Foreign amount is less than ":trigger_value"',
    'rule_trigger_foreign_amount_more_choice'             => 'Foreign amount is more than..',
    'rule_trigger_foreign_amount_more'                    => 'Foreign amount is more than ":trigger_value"',
    'rule_trigger_attachment_name_is_choice'              => 'Any attachment\'s name is..',
    'rule_trigger_attachment_name_is'                     => 'Any attachment\'s name is ":trigger_value"',
    'rule_trigger_attachment_name_contains_choice'        => 'Any attachment\'s name contains..',
    'rule_trigger_attachment_name_contains'               => 'Any attachment\'s name contains ":trigger_value"',
    'rule_trigger_attachment_name_starts_choice'          => 'Any attachment\'s name starts with..',
    'rule_trigger_attachment_name_starts'                 => 'Any attachment\'s name starts with ":trigger_value"',
    'rule_trigger_attachment_name_ends_choice'            => 'Any attachment\'s name ends with..',
    'rule_trigger_attachment_name_ends'                   => 'Any attachment\'s name ends with ":trigger_value"',
    'rule_trigger_attachment_notes_are_choice'            => 'Any attachment\'s notes are..',
    'rule_trigger_attachment_notes_are'                   => 'Any attachment\'s notes are ":trigger_value"',
    'rule_trigger_attachment_notes_contains_choice'       => 'Any attachment\'s notes contain..',
    'rule_trigger_attachment_notes_contains'              => 'Any attachment\'s notes contain ":trigger_value"',
    'rule_trigger_attachment_notes_starts_choice'         => 'Any attachment\'s notes start with..',
    'rule_trigger_attachment_notes_starts'                => 'Any attachment\'s notes start with ":trigger_value"',
    'rule_trigger_attachment_notes_ends_choice'           => 'Any attachment\'s notes end with..',
    'rule_trigger_attachment_notes_ends'                  => 'Any attachment\'s notes end with ":trigger_value"',
    'rule_trigger_reconciled_choice'                      => 'Transaction is reconciled',
    'rule_trigger_reconciled'                             => 'Transaction is reconciled',
    'rule_trigger_exists_choice'                          => 'Any transaction matches(!)',
    'rule_trigger_exists'                                 => 'Any transaction matches',

    // more values for new types:
    'rule_trigger_not_account_id'                         => 'Account ID is not ":trigger_value"',
    'rule_trigger_not_source_account_id'                  => 'Source account ID is not ":trigger_value"',
    'rule_trigger_not_destination_account_id'             => 'Destination account ID is not ":trigger_value"',
    'rule_trigger_not_transaction_type'                   => 'Transaction type is not ":trigger_value"',
    'rule_trigger_not_tag_is'                             => 'Tag is not ":trigger_value"',
    'rule_trigger_not_tag_is_not'                         => 'Tag is ":trigger_value"',
    'rule_trigger_not_description_is'                     => 'Description is not ":trigger_value"',
    'rule_trigger_not_description_contains'               => 'Description does not contain ":trigger_value"',
    'rule_trigger_not_description_ends'                   => 'Description does not end with ":trigger_value"',
    'rule_trigger_not_description_starts'                 => 'Description does not start with ":trigger_value"',
    'rule_trigger_not_notes_is'                           => 'Notes are not ":trigger_value"',
    'rule_trigger_not_notes_contains'                     => 'Notes do not contain ":trigger_value"',
    'rule_trigger_not_notes_ends'                         => 'Notes do not end on ":trigger_value"',
    'rule_trigger_not_notes_starts'                       => 'Notes do not start with ":trigger_value"',
    'rule_trigger_not_source_account_is'                  => 'Source account is not ":trigger_value"',
    'rule_trigger_not_source_account_contains'            => 'Source account does not contain ":trigger_value"',
    'rule_trigger_not_source_account_ends'                => 'Source account does not end on ":trigger_value"',
    'rule_trigger_not_source_account_starts'              => 'Source account does not start with ":trigger_value"',
    'rule_trigger_not_source_account_nr_is'               => 'Source account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_source_account_nr_contains'         => 'Source account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_source_account_nr_ends'             => 'Source account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_source_account_nr_starts'           => 'Source account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_is'             => 'Destination account is not ":trigger_value"',
    'rule_trigger_not_destination_account_contains'       => 'Destination account does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_ends'           => 'Destination account does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_starts'         => 'Destination account does not start with ":trigger_value"',
    'rule_trigger_not_destination_account_nr_is'          => 'Destination account number / IBAN is not ":trigger_value"',
    'rule_trigger_not_destination_account_nr_contains'    => 'Destination account number / IBAN does not contain ":trigger_value"',
    'rule_trigger_not_destination_account_nr_ends'        => 'Destination account number / IBAN does not end on ":trigger_value"',
    'rule_trigger_not_destination_account_nr_starts'      => 'Destination account number / IBAN does not start with ":trigger_value"',
    'rule_trigger_not_account_is'                         => 'Neither account is ":trigger_value"',
    'rule_trigger_not_account_contains'                   => 'Neither account contains ":trigger_value"',
    'rule_trigger_not_account_ends'                       => 'Neither account ends on ":trigger_value"',
    'rule_trigger_not_account_starts'                     => 'Neither account starts with ":trigger_value"',
    'rule_trigger_not_account_nr_is'                      => 'Neither account number / IBAN is ":trigger_value"',
    'rule_trigger_not_account_nr_contains'                => 'Neither account number / IBAN contains ":trigger_value"',
    'rule_trigger_not_account_nr_ends'                    => 'Neither account number / IBAN ends on ":trigger_value"',
    'rule_trigger_not_account_nr_starts'                  => 'Neither account number / IBAN starts with ":trigger_value"',
    'rule_trigger_not_category_is'                        => 'Category is not ":trigger_value"',
    'rule_trigger_not_category_contains'                  => 'Category does not contain ":trigger_value"',
    'rule_trigger_not_category_ends'                      => 'Category does not end on ":trigger_value"',
    'rule_trigger_not_category_starts'                    => 'Category does not start with ":trigger_value"',
    'rule_trigger_not_budget_is'                          => 'Budget is not ":trigger_value"',
    'rule_trigger_not_budget_contains'                    => 'Budget does not contain ":trigger_value"',
    'rule_trigger_not_budget_ends'                        => 'Budget does not end on ":trigger_value"',
    'rule_trigger_not_budget_starts'                      => 'Budget does not start with ":trigger_value"',
    'rule_trigger_not_bill_is'                            => 'Subscription is not is ":trigger_value"',
    'rule_trigger_not_bill_contains'                      => 'Subscription does not contain ":trigger_value"',
    'rule_trigger_not_bill_ends'                          => 'Subscription does not end on ":trigger_value"',
    'rule_trigger_not_bill_starts'                        => 'Subscription does not end with ":trigger_value"',
    'rule_trigger_not_external_id_is'                     => 'External ID is not ":trigger_value"',
    'rule_trigger_not_external_id_contains'               => 'External ID does not contain ":trigger_value"',
    'rule_trigger_not_external_id_ends'                   => 'External ID does not end on ":trigger_value"',
    'rule_trigger_not_external_id_starts'                 => 'External ID does not start with ":trigger_value"',
    'rule_trigger_not_internal_reference_is'              => 'Internal reference is not ":trigger_value"',
    'rule_trigger_not_internal_reference_contains'        => 'Internal reference does not contain ":trigger_value"',
    'rule_trigger_not_internal_reference_ends'            => 'Internal reference does not end on ":trigger_value"',
    'rule_trigger_not_internal_reference_starts'          => 'Internal reference does not start with ":trigger_value"',
    'rule_trigger_not_external_url_is'                    => 'External URL is not ":trigger_value"',
    'rule_trigger_not_external_url_contains'              => 'External URL does not contain ":trigger_value"',
    'rule_trigger_not_external_url_ends'                  => 'External URL does not end on ":trigger_value"',
    'rule_trigger_not_external_url_starts'                => 'External URL does not start with ":trigger_value"',
    'rule_trigger_not_currency_is'                        => 'Currency is not ":trigger_value"',
    'rule_trigger_not_foreign_currency_is'                => 'Foreign currency is not ":trigger_value"',
    'rule_trigger_not_id'                                 => 'Transaction ID is not ":trigger_value"',
    'rule_trigger_not_journal_id'                         => 'Transaction journal ID is not ":trigger_value"',
    'rule_trigger_not_recurrence_id'                      => 'Recurrence ID is not ":trigger_value"',
    'rule_trigger_not_date_on'                            => 'Date is not on ":trigger_value"',
    'rule_trigger_not_date_before'                        => 'Date is not before ":trigger_value"',
    'rule_trigger_not_date_after'                         => 'Date is not after ":trigger_value"',
    'rule_trigger_not_interest_date_on'                   => 'Interest date is not on ":trigger_value"',
    'rule_trigger_not_interest_date_before'               => 'Interest date is not before ":trigger_value"',
    'rule_trigger_not_interest_date_after'                => 'Interest date is not after ":trigger_value"',
    'rule_trigger_not_book_date_on'                       => 'Book date is not on ":trigger_value"',
    'rule_trigger_not_book_date_before'                   => 'Book date is not before ":trigger_value"',
    'rule_trigger_not_book_date_after'                    => 'Book date is not after ":trigger_value"',
    'rule_trigger_not_process_date_on'                    => 'Process date is not on ":trigger_value"',
    'rule_trigger_not_process_date_before'                => 'Process date is not before ":trigger_value"',
    'rule_trigger_not_process_date_after'                 => 'Process date is not after ":trigger_value"',
    'rule_trigger_not_due_date_on'                        => 'Due date is not on ":trigger_value"',
    'rule_trigger_not_due_date_before'                    => 'Due date is not before ":trigger_value"',
    'rule_trigger_not_due_date_after'                     => 'Due date is not after ":trigger_value"',
    'rule_trigger_not_payment_date_on'                    => 'Payment date is not on ":trigger_value"',
    'rule_trigger_not_payment_date_before'                => 'Payment date is not before ":trigger_value"',
    'rule_trigger_not_payment_date_after'                 => 'Payment date is not after ":trigger_value"',
    'rule_trigger_not_invoice_date_on'                    => 'Invoice date is not on ":trigger_value"',
    'rule_trigger_not_invoice_date_before'                => 'Invoice date is not before ":trigger_value"',
    'rule_trigger_not_invoice_date_after'                 => 'Invoice date is not after ":trigger_value"',
    'rule_trigger_not_created_at_on'                      => 'Transaction is not created on ":trigger_value"',
    'rule_trigger_not_created_at_before'                  => 'Transaction is not created before ":trigger_value"',
    'rule_trigger_not_created_at_after'                   => 'Transaction is not created after ":trigger_value"',
    'rule_trigger_not_updated_at_on'                      => 'Transaction is not updated on ":trigger_value"',
    'rule_trigger_not_updated_at_before'                  => 'Transaction is not updated before ":trigger_value"',
    'rule_trigger_not_updated_at_after'                   => 'Transaction is not updated after ":trigger_value"',
    'rule_trigger_not_amount_is'                          => 'Transaction amount is not ":trigger_value"',
    'rule_trigger_not_amount_less'                        => 'Transaction amount is more than ":trigger_value"',
    'rule_trigger_not_amount_more'                        => 'Transaction amount is less than ":trigger_value"',
    'rule_trigger_not_foreign_amount_is'                  => 'Foreign transaction amount is not ":trigger_value"',
    'rule_trigger_not_foreign_amount_less'                => 'Foreign transaction amount is more than ":trigger_value"',
    'rule_trigger_not_foreign_amount_more'                => 'Foreign transaction amount is less than ":trigger_value"',
    'rule_trigger_not_attachment_name_is'                 => 'No attachment is named ":trigger_value"',
    'rule_trigger_not_attachment_name_contains'           => 'No attachment name contains ":trigger_value"',
    'rule_trigger_not_attachment_name_starts'             => 'No attachment name starts with ":trigger_value"',
    'rule_trigger_not_attachment_name_ends'               => 'No attachment name ends on ":trigger_value"',
    'rule_trigger_not_attachment_notes_are'               => 'No attachment notes are ":trigger_value"',
    'rule_trigger_not_attachment_notes_contains'          => 'No attachment notes contain ":trigger_value"',
    'rule_trigger_not_attachment_notes_starts'            => 'No attachment notes start with ":trigger_value"',
    'rule_trigger_not_attachment_notes_ends'              => 'No attachment notes end on ":trigger_value"',
    'rule_trigger_not_reconciled'                         => 'Transaction is not reconciled',
    'rule_trigger_not_exists'                             => 'Transaction does not exist',
    'rule_trigger_not_has_attachments'                    => 'Transaction has no attachments',
    'rule_trigger_not_has_any_category'                   => 'Transaction has no category',
    'rule_trigger_not_has_any_budget'                     => 'Transaction has no budget',
    'rule_trigger_not_has_any_bill'                       => 'Transaction has no subscription',
    'rule_trigger_not_has_any_tag'                        => 'Transaction has no tags',
    'rule_trigger_not_any_notes'                          => 'Transaction has no notes',
    'rule_trigger_not_any_external_url'                   => 'Transaction has no external URL',
    'rule_trigger_not_has_no_attachments'                 => 'Transaction has a (any) attachment(s)',
    'rule_trigger_not_has_no_category'                    => 'Transaction has a (any) category',
    'rule_trigger_not_has_no_budget'                      => 'Transaction has a (any) budget',
    'rule_trigger_not_has_no_bill'                        => 'Transaction has a (any) subscription',
    'rule_trigger_not_has_no_tag'                         => 'Transaction has a (any) tag',
    'rule_trigger_not_no_notes'                           => 'Transaction has any notes',
    'rule_trigger_not_no_external_url'                    => 'Transaction has an external URL',
    'rule_trigger_not_source_is_cash'                     => 'Source account is not a cash account',
    'rule_trigger_not_destination_is_cash'                => 'Destination account is not a cash account',
    'rule_trigger_not_account_is_cash'                    => 'Neither account is a cash account',

    // new account balance things.
    'rule_trigger_destination_balance_gt_choice'          => 'Destination account balance is more than..',
    'rule_trigger_destination_balance_gte_choice'         => 'Destination account balance is more than or equal to..',
    'rule_trigger_destination_balance_is_choice'          => 'Destination account balance is exactly..',
    'rule_trigger_destination_balance_lt_choice'          => 'Destination account balance is less than..',
    'rule_trigger_destination_balance_lte_choice'         => 'Destination account balance is less than or equal to..',

    'rule_trigger_source_balance_gt_choice'  => 'Source account balance is more than..',
    'rule_trigger_source_balance_gte_choice' => 'Source account balance is more than or equal to..',
    'rule_trigger_source_balance_is_choice'  => 'Source account balance is exactly..',
    'rule_trigger_source_balance_lt_choice'  => 'Source account balance is less than..',
    'rule_trigger_source_balance_lte_choice' => 'Source account balance is less than or equal to..',

    'rule_trigger_destination_balance_gt'  => 'Destination account balance is more than :trigger_value',
    'rule_trigger_destination_balance_gte' => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_destination_balance_is'  => 'Destination account balance is exactly :trigger_value',
    'rule_trigger_destination_balance_lt'  => 'Destination account balance is less than :trigger_value',
    'rule_trigger_destination_balance_lte' => 'Destination account balance is less than or equal to :trigger_value',

    'rule_trigger_source_balance_gt'           => 'Source account balance is more than :trigger_value',
    'rule_trigger_source_balance_gte'          => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_source_balance_is'           => 'Source account balance is exactly :trigger_value',
    'rule_trigger_source_balance_lt'           => 'Source account balance is less than :trigger_value',
    'rule_trigger_source_balance_lte'          => 'Source account balance is less than or equal to :trigger_value',

    // NOT
    'rule_trigger_not_destination_balance_gt'  => 'Destination account balance is less than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_gte' => 'Destination account balance is less than :trigger_value',
    'rule_trigger_not_destination_balance_is'  => 'Destination account balance is not :trigger_value',
    'rule_trigger_not_destination_balance_lt'  => 'Destination account balance is more than or equal to :trigger_value',
    'rule_trigger_not_destination_balance_lte' => 'Destination account balance is more than :trigger_value',

    'rule_trigger_not_source_balance_gt'         => 'Source account balance is less than or equal to :trigger_value',
    'rule_trigger_not_source_balance_gte'        => 'Source account balance is less than :trigger_value',
    'rule_trigger_not_source_balance_is'         => 'Source account balance is not :trigger_value',
    'rule_trigger_not_source_balance_lt'         => 'Source account balance is more than or equal to :trigger_value',
    'rule_trigger_not_source_balance_lte'        => 'Source account balance is more than :trigger_value',


    // actions
    // set, clear, add, remove, append/prepend
    'rule_action_delete_transaction_choice'      => 'DELETE transaction(!)',
    'rule_action_delete_transaction'             => 'DELETE transaction(!)',
    'rule_action_set_category'                   => 'Aseta kategoriaksi ":action_value"',
    'rule_action_clear_category'                 => 'Tyhjennä kategoria',
    'rule_action_set_budget'                     => 'Aseta budjetiksi ":action_value"',
    'rule_action_clear_budget'                   => 'Tyhjennä budjetti',
    'rule_action_add_tag'                        => 'Lisää tägi ":action_value"',
    'rule_action_remove_tag'                     => 'Poista tägi ":action_value"',
    'rule_action_remove_all_tags'                => 'Poista kaikki tägit',
    'rule_action_set_description'                => 'Aseta kuvaus ":action_value"',
    'rule_action_append_description'             => 'Liitä kuvauksen loppuun teksti ":action_value"',
    'rule_action_prepend_description'            => 'Aloita kuvaus tekstillä ":action_value"',
    'rule_action_set_category_choice'            => 'Set category to ..',
    'rule_action_clear_category_choice'          => 'Tyhjennä kategoria',
    'rule_action_set_budget_choice'              => 'Set budget to ..',
    'rule_action_clear_budget_choice'            => 'Tyhjennä budjetti',
    'rule_action_add_tag_choice'                 => 'Add tag ..',
    'rule_action_remove_tag_choice'              => 'Remove tag ..',
    'rule_action_remove_all_tags_choice'         => 'Poista kaikki tägit',
    'rule_action_set_description_choice'         => 'Set description to ..',
    'rule_action_update_piggy_choice'            => 'Add / remove transaction amount in piggy bank ..',
    'rule_action_update_piggy'                   => 'Add / remove transaction amount in piggy bank ":action_value"',
    'rule_action_append_description_choice'      => 'Append description with ..',
    'rule_action_prepend_description_choice'     => 'Prepend description with ..',
    'rule_action_set_source_account_choice'      => 'Set source account to ..',
    'rule_action_set_source_account'             => 'Aseta lähdetiliksi :action_value',
    'rule_action_set_destination_account_choice' => 'Set destination account to ..',
    'rule_action_set_destination_account'        => 'Aseta kohdetiliksi :action_value',
    'rule_action_append_notes_choice'            => 'Append notes with ..',
    'rule_action_append_notes'                   => 'Liitä muistiinpanon loppuun teksti ":action_value"',
    'rule_action_prepend_notes_choice'           => 'Prepend notes with ..',
    'rule_action_prepend_notes'                  => 'Aloita muistiinpano tekstillä ":action_value"',
    'rule_action_clear_notes_choice'             => 'Poista kaikki muistiinpanot',
    'rule_action_clear_notes'                    => 'Poista kaikki muistiinpanot',
    'rule_action_set_notes_choice'               => 'Set notes to ..',
    'rule_action_link_to_bill_choice'            => 'Link to a subscription ..',
    'rule_action_link_to_bill'                   => 'Link to subscription ":action_value"',
    'rule_action_switch_accounts_choice'         => 'Switch source and destination accounts (transfers only!)',
    'rule_action_switch_accounts'                => 'Switch source and destination',
    'rule_action_set_notes'                      => 'Aseta muistiinpano tapahtumalle ":action_value"',
    'rule_action_convert_deposit_choice'         => 'Muuta tapahtuma talletukseksi',
    'rule_action_convert_deposit'                => 'Muuta ":action_value" talletukseksi',
    'rule_action_convert_withdrawal_choice'      => 'Muuta tapahtuma nostoksi',
    'rule_action_convert_withdrawal'             => 'Muuta ":action_value" nostoksi',
    'rule_action_convert_transfer_choice'        => 'Muuta tapahtuma siirroksi',
    'rule_action_convert_transfer'               => 'Muunna tapahtuma siirroksi tilin ":action_value" kanssa',
    'rule_action_append_descr_to_notes_choice'   => 'Append the description to the transaction notes',
    'rule_action_append_notes_to_descr_choice'   => 'Append the transaction notes to the description',
    'rule_action_move_descr_to_notes_choice'     => 'Replace the current transaction notes with the description',
    'rule_action_move_notes_to_descr_choice'     => 'Replace the current description with the transaction notes',
    'rule_action_append_descr_to_notes'          => 'Append description to notes',
    'rule_action_append_notes_to_descr'          => 'Append notes to description',
    'rule_action_move_descr_to_notes'            => 'Replace notes with description',
    'rule_action_move_notes_to_descr'            => 'Replace description with notes',
    'rule_action_set_amount_choice'              => 'Set amount to ..',
    'rule_action_set_amount'                     => 'Set amount to ":action_value"',
    'rule_action_set_destination_to_cash_choice' => 'Set destination account to (cash)',
    'rule_action_set_source_to_cash_choice'      => 'Set source account to (cash)',
    'rulegroup_for_bills_title'                  => 'Rule group for subscriptions',
    'rulegroup_for_bills_description'            => 'A special rule group for all the rules that involve subscriptions.',
    'rule_for_bill_title'                        => 'Auto-generated rule for subscription ":name"',
    'rule_for_bill_description'                  => 'This rule is auto-generated to try to match subscription ":name".',
    'create_rule_for_bill'                       => 'Create a new rule for subscription ":name"',
    'create_rule_for_bill_txt'                   => 'You have just created a new subscription called ":name", congratulations! Firefly III can automagically match new withdrawals to this subscription. For example, whenever you pay your rent, the subscription "rent" will be linked to the expense. This way, Firefly III can accurately show you which subscriptions are due and which ones aren\'t. In order to do so, a new rule must be created. Firefly III has filled in some sensible defaults for you. Please make sure these are correct. If these values are correct, Firefly III will automatically link the correct withdrawal to the correct subscription. Please check out the triggers to see if they are correct, and add some if they\'re wrong.',
    'new_rule_for_bill_title'                    => 'Rule for subscription ":name"',
    'new_rule_for_bill_description'              => 'This rule marks transactions for subscription ":name".',

    'new_rule_for_journal_title'                => 'Tapahtumaan ":description" perustuva sääntö',
    'new_rule_for_journal_description'          => 'Tämä sääntö perustuu tapahtumaan ":description". Se täsmää tapahtumiin jotka ovat tarkalleen samanlaisia.',

    // tags
    'store_new_tag'                             => 'Tallenna uusi tägi',
    'update_tag'                                => 'Päivitä tägi',
    'no_location_set'                           => 'Sijaintia ei ole asetettu.',
    'meta_data'                                 => 'Metatieto',
    'location'                                  => 'Sijainti',
    'location_first_split'                      => 'The location for this transaction can be set on the first split of this transaction.',
    'without_date'                              => 'Ilman päiväystä',
    'result'                                    => 'Tulos',
    'sums_apply_to_range'                       => 'Kaikki summat sisältyvät valittuun jaksoon',
    'mapbox_api_key'                            => 'Käyttääksesi karttaa, hanki API-avain <a href="https://www.mapbox.com/">Mapboxilta</a>. Avaa <code>.env</code> tiedostosi ja lisää koodi <code>MAPBOX_API_KEY=</code> perään.',
    'press_object_location'                     => 'Oikealla hiiren napilla (tai pitkä painallus) voit asettaa paikkatiedon.',
    'click_tap_location'                        => 'Click or tap the map to add a location',
    'clear_location'                            => 'Tyhjennä sijainti',
    'delete_all_selected_tags'                  => 'Poista kaikki valitut tägit',
    'select_tags_to_delete'                     => 'Älä unohda valita tägejä.',
    'deleted_x_tags'                            => 'Poistettu :count tagi.|Poistettu :count tagia.',
    'create_rule_from_transaction'              => 'Luo tapahtumaan perustuva sääntö',
    'create_recurring_from_transaction'         => 'Luo toistuva tapahtuma tämän tapahtuman perusteella',

    // preferences
    'test_notifications_buttons'                => 'To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'dark_mode_option_browser'                  => 'Let your browser decide',
    'dark_mode_option_light'                    => 'Always light',
    'dark_mode_option_dark'                     => 'Always dark',
    'equal_to_language'                         => '(sama kuin kieli)',
    'dark_mode_preference'                      => 'Dark mode',
    'dark_mode_preference_help'                 => 'Tell Firefly III when to use dark mode.',
    'pref_home_screen_accounts'                 => 'Etusivun tilit',
    'pref_home_screen_accounts_help'            => 'Mitkä tilit näytetään etusivulla?',
    'pref_view_range'                           => 'Tarkasteltava jakso',
    'pref_view_range_help'                      => 'Osa kuvaajista ryhmitellään automaattisesti jaksoihin. Budjettisi ryhmitellään myös jaksoihin. Minkälaista jaksoa haluat käyttää?',
    'pref_1D'                                   => 'Yksi päivä',
    'pref_1W'                                   => 'Yksi viikko',
    'pref_1M'                                   => 'Yksi kuukausi',
    'pref_3M'                                   => 'Kolme kuukautta (vuosineljännes)',
    'pref_6M'                                   => 'Kuusi kuukautta',
    'pref_1Y'                                   => 'Yksi vuosi',
    'pref_last365'                              => 'Edellinen vuosi',
    'pref_last90'                               => 'Viimeiset 90 päivää',
    'pref_last30'                               => 'Viimeiset 30 päivää',
    'pref_last7'                                => 'Viimeiset 7 päivää',
    'pref_YTD'                                  => 'Vuoden alusta',
    'pref_QTD'                                  => 'Neljännesvuoden alusta',
    'pref_MTD'                                  => 'Kuukauden alusta',
    'pref_languages'                            => 'Kielet',
    'pref_locale'                               => 'Alueasetukset',
    'pref_languages_help'                       => 'Firefly III tukee useita kieliä. Mitä niistä haluat käyttää?',
    'pref_locale_help'                          => 'Firefly III antaa sinun asettaa erikseen paikallisia asetuksia, kuten valuuttojen, numeroiden ja päivämäärien muotoilun. Järjestelmäsi ei ehkä tue kaikkia tämän luettelon alueasetuksia. Firefly III:lla ei ole oikeita päivämääräasetuksia jokaiselle alueelle; ota minuun yhteyttä saadaksesi parannuksia.',
    'pref_locale_no_demo'                       => 'Tämä ominaisuus ei toimi demokäyttäjälle.',
    'pref_convert_to_primary'                   => 'Display amounts in your primary currency',
    'pref_convert_to_primary_help'              => 'This option will make Firefly III try to display and show your primary currency in as many places as possible, converting amounts where necessary. This sacrifices accuracy for ease of use, because conversion is not always exact. Please verify that Firefly III has the necessary conversion rates on the "exchange rates"-page.',
    'pref_convert_primary_help'                 => 'Display primary amounts',
    'pref_custom_fiscal_year'                   => 'Tilikauden asetukset',
    'pref_custom_fiscal_year_label'             => 'Käytössä',
    'pref_custom_fiscal_year_help'              => 'Maissa joiden tilikausi on jokin muu kuin Tammikuun 1:stä Joulukuun 31:seen päivään, voit valita tämän ja määrittää tilikauden aloitus- ja lopetuspäivän',
    'pref_fiscal_year_start_label'              => 'Tilikauden aloituspäivä',
    'pref_two_factor_auth'                      => 'Multi-factor authentication',
    'pref_two_factor_auth_help'                 => 'When you enable multi-factor authentication (also known as two-factor authentication), you add an extra layer of security to your account. You sign in with something you know (your password) and something you have (a verification code). Verification codes are generated by an application on your phone, such as Authy or Google Authenticator.',
    'pref_enable_two_factor_auth'               => 'Enable multi-factor authentication',
    'pref_two_factor_auth_disabled'             => 'Multi-factor authentication verification code removed and disabled',
    'pref_two_factor_auth_remove_it'            => 'Älä unohda poistaa tiliä tunnistusohjelmastasi!',
    'pref_two_factor_auth_code'                 => 'Tarkista koodi',
    'pref_two_factor_auth_code_help'            => 'Scan the QR code with an application on your phone such as Authy or Google Authenticator and enter the generated code. The QR code changes every time you visit this page. Make sure you use the most recent one.',
    'pref_two_factor_auth_reset_code'           => 'Nollaa vahvistuskoodi',
    'pref_two_factor_auth_disable_2fa'          => 'Poista monivaiheinen tunnistautuminen käytöstä',
    '2fa_use_secret_instead'                    => 'Jos et voi skannata QR koodia, voit sen sijaan käyttää koodia: <code>:secret</code>.',
    '2fa_backup_codes'                          => 'Tallenna nämä varakoodit, jotta et menetä pääsyä Firefly III:een jos vaikka puhelimesi pääsee häviämään.',
    '2fa_already_enabled'                       => 'Multi-factor authentication verification is already enabled.',
    'wrong_mfa_code'                            => 'Tämä MFA-koodi ei ole voimassa.',
    'pref_save_settings'                        => 'Tallenna asetukset',
    'saved_preferences'                         => 'Asetukset tallennettu!',
    'preferences_general'                       => 'Yleiset',
    'preferences_frontpage'                     => 'Etusivu',
    'preferences_security'                      => 'Turvallisuus',
    'preferences_layout'                        => 'Asettelu',
    'preferences_notifications'                 => 'Ilmoitukset',
    'pref_home_show_deposits'                   => 'Näytä talletukset etusivulla',
    'pref_home_show_deposits_info'              => 'Kulutustilisi näkyvät jo etusivulla. Pitäisikö tuottotilisi myös näkyä siellä?',
    'pref_home_do_show_deposits'                => 'Kyllä, näytä ne',
    'successful_count'                          => 'joista :count onnistui',
    'list_page_size_title'                      => 'Sivun koko',
    'list_page_size_help'                       => 'Listojen pituus - koskee mitä tahansa listaa asioista (tilit, tapahtumat, jne).',
    'list_page_size_label'                      => 'Sivun koko',
    'between_dates'                             => '(:start ja :end)',
    'pref_optional_fields_transaction'          => 'Tapahtumien valinnaiset kentät',
    'pref_optional_fields_transaction_help'     => 'Yksinkertaisuuden nimissä kaikki kentät eivät alkuun ole näkyvissä luodessasi uusia tapahtumia. Alla voit ottaa käyttöön sinulle hyödyllisiä kenttiä. Asetuksesta huolimatta kaikki kentät joissa jo on sisältöä näytetään - tietenkin.',
    'optional_tj_date_fields'                   => 'Päivämääräkentät',
    'optional_tj_other_fields'                  => 'Muut kentät',
    'optional_tj_attachment_fields'             => 'Liitekentät',
    'pref_optional_tj_interest_date'            => 'Korkopäivä',
    'pref_optional_tj_book_date'                => 'Kirjauspäivä',
    'pref_optional_tj_process_date'             => 'Käsittelypäivä',
    'pref_optional_tj_due_date'                 => 'Eräpäivä',
    'pref_optional_tj_payment_date'             => 'Maksupäivä',
    'pref_optional_tj_invoice_date'             => 'Laskun päivämäärä',
    'pref_optional_tj_internal_reference'       => 'Sisäinen viite',
    'pref_optional_tj_notes'                    => 'Muistiinpanot',
    'pref_optional_tj_attachments'              => 'Liitteet',
    'pref_optional_tj_external_url'             => 'Ulkoinen URL',
    'pref_optional_tj_location'                 => 'Sijainti',
    'pref_optional_tj_links'                    => 'Tapahtuman linkit',
    'optional_field_meta_dates'                 => 'Päivämäärät',
    'optional_field_meta_business'              => 'Yritys',
    'optional_field_attachments'                => 'Liitteet',
    'optional_field_meta_data'                  => 'Valinnainen metatieto',
    'external_url'                              => 'Ulkoinen URL',
    'pref_notification_login_failure'           => 'Login failure',
    'pref_notification_bill_reminder'           => 'Reminder about expiring subscriptions',
    'pref_notification_new_access_token'        => 'Alert when a new API access token is created',
    'pref_notification_transaction_creation'    => 'Alert when a transaction is created automatically',
    'pref_notification_user_login'              => 'Alert when you login from a new location',
    'pref_notification_rule_action_failures'    => 'Alert when rule actions fail to execute (not over email)',
    'pref_notification_new_password'            => 'Your password changed',
    'pref_notification_enabled_mfa'             => 'Monivaiheinen tunnistautuminen on käytössä',
    'pref_notification_disabled_mfa'            => 'Monivaiheinen tunnistautuminen ei ole käytössä',
    'pref_notification_few_left_mfa'            => 'You have just a few backup codes left',
    'pref_notification_no_left_mfa'             => 'You have no backup codes left',
    'pref_notification_many_failed_mfa'         => 'The multi factor authentication check keeps failing',
    'pref_notification_new_backup_codes'        => 'New backup codes have been generated',
    'pref_notifications'                        => 'Notifications',
    'pref_notifications_help'                   => 'Indicate if these are notifications you would like to get. Some notifications may contain sensitive financial information.',
    'pref_notifications_settings'               => 'Notifications settings',
    'pref_notifications_settings_help'          => 'Use these settings to configure your notification channels. Please note that notifications will be sent to ALL channels. Please save your settings FIRST.',
    'slack_url_label'                           => 'Slack "incoming webhook" URL',
    'discord_url_label'                         => 'Discord webhook URL',

    // exchange rates
    'menu_exchange_rates_index'                 => 'Exchange rates',
    'header_exchange_rates'                     => 'Exchange rates',
    'exchange_rates_intro'                      => 'Firefly III supports downloading and using exchange rates. Read more about this in <a href="https://docs.firefly-iii.org/explanation/financial-concepts/exchange-rates/">the documentation</a>.',
    'exchange_rates_from_to'                    => 'Between {from} and {to} (and the other way around)',
    'header_exchange_rates_rates'               => 'Exchange rates',
    'exchange_rates_intro_rates'                => 'Firefly III uses the following exchange rates. The inverse is automatically calculated when it is not provided. If no exchange rate exists for the date of the transaction, Firefly III will go back in time to find one. If none are present, the rate "1" will be used.',
    'header_exchange_rates_table'               => 'Table with exchange rates',
    'help_rate_form'                            => 'On this day, how many {to} will you get for one {from}?',
    'save_new_rate'                             => 'Save new rate',
    'add_new_rate'                              => 'Add a new exchange rate',
    'not_enough_currencies'                     => 'Not enough currencies',
    'not_enough_currencies_enabled'             => 'If you have just one currency enabled, there is no need to add exchange rates.',

    // Financial administrations
    'administration_index'                      => 'Financial administration',
    'administrations_breadcrumb'                => 'Financial administrations',
    'administrations_page_title'                => 'Financial administrations',
    'administrations_index_menu'                => 'Financial administrations',
    'administrations_page_sub_title'            => 'Overview',
    'create_administration'                     => 'Create new administration',
    'administration_owner'                      => 'Administration owner: {{email}}',
    'administration_you'                        => 'Your role: {{role}}',
    'other_users_in_admin'                      => 'Other users in this administration',
    'administrations_create_breadcrumb'         => 'Create new financial administration',
    'administrations_page_create_sub_title'     => 'Create new financial administration',
    'basic_administration_information'          => 'Basic administration information',
    'new_administration_created'                => 'New financial administration "{{title}}" has been created',
    'edit_administration_breadcrumb'            => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title'       => 'Edit financial administration ":title"',
    'administrations_page_edit_sub_title_js'    => 'Edit financial administration "{title}"',
    'temp_administrations_introduction'         => 'Firefly III will soon get the ability to manage multiple financial administrations. Right now, you only have the one. You can set the title of this administration and its primary currency. This replaces the previous setting where you would set your "default currency". This setting is now tied to the financial administration and can be different per administration.',
    'temp_administrations_introduction_edit'    => 'Currently, you can only set the "primary currency" of the default financial administration. This replaces the "default currency" setting. This setting is now tied to the financial administration and can be different per administration.',
    'administration_currency_form_help'         => 'It may take a long time for the page to load if you change the primary currency because transaction may need to be converted to your (new) primary currency.',
    'flash_administration_updated'              => 'Administration ":title" has been updated',
    'flash_administration_created'              => 'Administration ":title" has been created',
    'flash_administration_deleted'              => 'Administration ":title" has been deleted',

    // roles
    'administration_role_owner'                 => 'Owner',
    'administration_role_ro'                    => 'Read-only',
    'administration_role_mng_trx'               => 'Manage transactions',
    'administration_role_mng_meta'              => 'Manage classification and meta-data',
    'administration_role_mng_budgets'           => 'Manage budgets',
    'administration_role_mng_piggies'           => 'Manage piggy banks',
    'administration_role_mng_subscriptions'     => 'Manage subscriptions',
    'administration_role_mng_rules'             => 'Manage rules',
    'administration_role_mng_recurring'         => 'Manage recurring transactions',
    'administration_role_mng_webhooks'          => 'Manage webhooks',
    'administration_role_mng_currencies'        => 'Manage currencies',
    'administration_role_view_reports'          => 'View reports',
    'administration_role_full'                  => 'Full access',

    // mfa
    'enable_mfa'                                => 'Ota monivaiheinen tunnistautuminen käyttöön',
    'mfa_index_title'                           => 'Multi-factor authentication',
    'mfa_index_intro'                           => 'Firefly III supports multi-factor authentication (MFA). You can enable MFA for your account to add an extra layer of security. Applications like Authy, Google Authenticator and FreeOTP can be used to generate the codes you need to log in. Security keys are not supported by Firefly III but you can use a security key as a storage device for your MFA secret.',
    'mfa_index_enabled'                         => 'Multi-factor authentication is enabled for your account.',
    'mfa_index_disabled'                        => 'Multi-factor authentication is not enabled for your account.',
    'mfa_index_owner'                           => 'The owner of this instance will always be able to disable multi-factor authentication for your account.',
    'current_password_confirm_mfa'              => 'Enter your current password',
    'mfa_warning_code_changes'                  => 'You may get a MFA dialog after you entered your password and a MFA code. In that case, please wait for your application to generate a new MFA code, and do not recycle the one you just used.',
    'mfa_already_disabled'                      => 'Multi-factor authentication is not enabled, so you cannot disable it.',
    'disable_mfa_page'                          => 'Disable multi-factor authentication',
    'disable_mfa_intro'                         => 'You can disable multi-factor authentication. To do so, please enter your password and a multi-factor authentication code. If you want to disable multi-factor authentication because you have lost access to your code generator, <a href="https://docs.firefly-iii.org/references/faq/firefly-iii/using/#i-lost-my-2fa-token-generator-or-2fa-has-stopped-working">please refer to the documentation instead</a>.',
    'pref_disable_mfa'                          => 'Disable multi-factor authentication',
    'mfa_not_enabled'                           => 'Multi-factor authentication is not enabled.',
    'mfa_backup_codes_intro'                    => 'Firefly III can generate backup codes for you. These codes can be used to log in when you cannot use your code generator. You can generate a new set of codes at any time. If you generate a new set, the old set will be invalidated.',
    'mfa_backup_codes_quick'                    => 'If you are very fast coming from the setup page of multi-factor authentication, your app may not have generated a new code yet. Please know that MFA codes can only be used once. Make sure you use a different code from the previous one.',
    'mfa_backup_codes_title'                    => 'Multi-factor authentication backup codes',
    'mfa_backup_codes_post_title'               => 'Multi-factor authentication backup codes',

    // profile:
    'manage_mfa_settings'                       => 'Manage multi-factor authentication settings',
    'purge_data_title'                          => 'Purge data from Firefly III',
    'purge_data_expl'                           => '"Purging" means "deleting that which is already deleted". In normal circumstances, Firefly III deletes nothing permanently. It just hides it. The button below deletes all of these previously "deleted" records FOREVER.',
    'delete_stuff_header'                       => 'Delete and purge data',
    'purge_all_data'                            => 'Purge all deleted records',
    'purge_data'                                => 'Purge data',
    'purged_all_records'                        => 'All deleted records have been purged.',
    'delete_data_title'                         => 'Delete data from Firefly III',
    'permanent_delete_stuff'                    => 'You can delete stuff from Firefly III. Using the buttons below means that your items will be removed from view and hidden. There is no undo-button for this, but the items may remain in the database where you can salvage them if necessary.',
    'other_sessions_logged_out'                 => 'Kaikki muut istuntosi on kirjattu ulos.',
    'delete_unused_accounts'                    => 'Deleting unused accounts will clean your auto-complete lists.',
    'delete_all_unused_accounts'                => 'Delete unused accounts',
    'deleted_all_unused_accounts'               => 'All unused accounts are deleted',
    'delete_all_budgets'                        => 'Poista KAIKKI budjettisi',
    'delete_all_categories'                     => 'Poista KAIKKI kategoriasi',
    'delete_all_tags'                           => 'Poista KAIKKI tägit',
    'delete_all_bills'                          => 'Delete ALL your subscriptions',
    'delete_all_piggy_banks'                    => 'Poista KAIKKI säästöpossusi',
    'delete_all_rules'                          => 'Poista KAIKKI sääntösi',
    'delete_all_recurring'                      => 'Poista KAIKKI toistuvat tapahtumasi',
    'delete_all_object_groups'                  => 'Poista KAIKKI objektiryhmät',
    'delete_all_accounts'                       => 'Poista KAIKKI tilisi',
    'delete_all_asset_accounts'                 => 'Poista KAIKKI tulotilisi',
    'delete_all_expense_accounts'               => 'Poista KAIKKI kulutilisi',
    'delete_all_revenue_accounts'               => 'Poista kaikki tulotilisi',
    'delete_all_liabilities'                    => 'Poista KAIKKI lainasi',
    'delete_all_transactions'                   => 'Poista KAIKKI tapahtumasi',
    'delete_all_withdrawals'                    => 'Poista KAIKKI nostosi',
    'delete_all_deposits'                       => 'Poista KAIKKI talletuksesi',
    'delete_all_transfers'                      => 'Poista KAIKKI siirtosi',
    'also_delete_transactions'                  => 'Tilien poistaminen poistaa myös KAIKKI niille tehdyt nostot, talletukset ja siirrot!',
    'deleted_all_budgets'                       => 'Kaikki budjetit on poistettu',
    'deleted_all_categories'                    => 'Kaikki kategoriat on poistettu',
    'deleted_all_tags'                          => 'Kaikki tägit on poistettu',
    'deleted_all_bills'                         => 'All subscriptions have been deleted',
    'deleted_all_piggy_banks'                   => 'Kaikki säästöpossut on poistettu',
    'deleted_all_rules'                         => 'Kaikki säännöt ja sääntöryhmät on poistettu',
    'deleted_all_object_groups'                 => 'Kaikki ryhmät on poistettu',
    'deleted_all_accounts'                      => 'Kaikki tilit on poistettu',
    'deleted_all_asset_accounts'                => 'Kaikki omaisuustilit on poistettu',
    'deleted_all_expense_accounts'              => 'Kaikki kulutilit on poistettu',
    'deleted_all_revenue_accounts'              => 'Kaikki tulotilit on poistettu',
    'deleted_all_liabilities'                   => 'Kaikki lainat on poistettu',
    'deleted_all_transactions'                  => 'Kaikki tapahtumat on poistettu',
    'deleted_all_withdrawals'                   => 'Kaikki nostot on poistettu',
    'deleted_all_deposits'                      => 'Kaikki talletukset on poistettu',
    'deleted_all_transfers'                     => 'Kaikki siirrot on poistettu',
    'deleted_all_recurring'                     => 'Kaikki toistuvat tapahtumat on poistettu',
    'change_your_password'                      => 'Vaihda salasana',
    'delete_account'                            => 'Poista käyttäjätili',
    'current_password'                          => 'Nykyinen salasana',
    'new_password'                              => 'Uusi salasana',
    'new_password_again'                        => 'Salasana (uudestaan)',
    'delete_your_account'                       => 'Poista käyttäjätunnuksesi',
    'delete_your_account_help'                  => 'Poistamalla käyttäjätilisi poistat myös kaikki tilisi, tapahtumasi, <em>kaikki</em> mitä olet tallentanut Firefly III:een. Nämä kaikki POISTETAAN LOPULLISESTI.',
    'delete_your_account_password'              => 'Syötä salasanasi jatkaaksesi.',
    'password'                                  => 'Salasana',
    'are_you_sure'                              => 'Oletko varma? Et pysty perumaan tätä.',
    'are_you_sure_confirm'                      => 'Are you sure?',
    'delete_account_button'                     => 'POISTA käyttäjätilisi',
    'invalid_current_password'                  => 'Virheellinen nykyinen salasana!',
    'password_changed'                          => 'Salasana vaihdettu!',
    'should_change'                             => 'Tarkoituksena olisi vaihtaa salasanasi.',
    'invalid_password'                          => 'Virheellinen salasana!',
    'what_is_pw_security'                       => 'Mikä on "varmista salasanan turvallisuus"?',
    'secure_pw_title'                           => 'Turvallisen salasanan valitseminen',
    'forgot_password_response'                  => 'Kiitos. Jos sinulla on tili tällä sähköpostiosoitteella, löydät ohjeet saapuneet-kansiostasi.',
    'secure_pw_history'                         => 'Yhtään viikkoa ei kulu ilman uutisia verkkosivustojen vuotaneista käyttäjien kirjautumistiedoista. Hakkerit ja varkaat käyttävät näitä salasanoja yrittäessään varastaa sinun yksityisiä tietoja. Tämä tieto on arvokasta.',
    'secure_pw_ff'                              => 'Käytätkö samaa salasanaa kaikkialla internetissä? Jos yksi sivusto vuotaa sinun salasanasi, hakkereilla on pääsy kaikkiin sinun tietoihin. Firefly III luottaa, että sinä valitset vahvan ja yksilöllisen salasanan suojellaksesi taloudellisia tietojasi.',
    'secure_pw_check_box'                       => 'Auttaaksesi sinua tässä Firefly III voi tarkistaa onko ehdottamasi ja/tai käyttämäsi salasana jo aikaisemmin vuotaneiden joukossa. Jos näin on päässyt tapahtumaan, Firefly III neuvoo sinua olemaan käyttämättä valittua salasanaa.',
    'secure_pw_working_title'                   => 'Kuinka se toimii?',
    'secure_pw_working'                         => 'Kun valitset tämän valintaruudun, Firefly III lähettää ensimmäiset 5 kirjainta salasanasi SHA1 tarkisteesta <a href="https://www.troyhunt.com/introducing-306-million-freely-downloadable-pwned-passwords/">Troy Huntin verkkosivulle</a> vertailua varten. Jos listalta löytyy osumia, salasanasi saattaa olla vaarantunut. Tämä (toivottavasti) estää sinua käyttämästä vaarantuneita salasanoja kuten viimeisin <a href="https://pages.nist.gov/800-63-3/sp800-63b.html">NIST Erikoisjulkaisukin</a> suosittelee.',
    'secure_pw_should'                          => 'Pitäisikö minun valita tämä?',
    'secure_pw_long_password'                   => 'Kyllä. Varmista aina, että salasanasi on turvallinen.',
    'command_line_token'                        => 'Komentorivin tunnus',
    'explain_command_line_token'                => 'Tarvitset tämän tunnuksen käyttääksesi komentorivikomentoja kuten tietojen vienti. Ilman sitä, nämä komennot eivät toimi. Älä koskaan kerro kenellekään sinun komentorivitunnustasi. Kukaan ei kysy sinulta sitä, en edes minä. Jos pelkäät kadottaneesi tunnuksen tai olet vähän edes epävarma, voit aina luoda uuden tunnuksen tällä napilla.',
    'regenerate_command_line_token'             => 'Luo uusi komentorivitunnus',
    'token_regenerated'                         => 'Uusi komentorivitunnus luotiin',
    'change_your_email'                         => 'Muuta sähköpostiosoitetta',
    'email_verification'                        => 'An email message will be sent to your old AND new email address. For security purposes, you will not be able to login until you verify your new email address. If you are unsure if your Firefly III installation is capable of sending email, please do not use this feature. If you are an administrator, you can test this in the <a href="settings">settings</a>.',
    'email_changed_logout'                      => 'Et voi kirjautua sisään, ennen kuin olet vahvistanut sähköpostiosoitteesi.',
    'login_with_new_email'                      => 'Voit nyt kirjautua uudella sähköpostiosoitteella.',
    'login_with_old_email'                      => 'Voit kirjautua jälleen vanhalla sähköpostiosoitteellasi.',
    'login_provider_local_only'                 => 'Tämä toiminto ei ole käytettävissä käytettäessä palveluntarjoajaa ":login_provider" tunnistautumiseen.',
    'external_user_mgt_disabled'                => 'Tämä toiminto ei ole käytettävissä, kun Firefly III ei vastaa käyttäjän hallinnasta tai todennuksen käsittelystä.',
    'external_auth_disabled'                    => 'Tämä toiminto ei ole käytettävissä, kun Firefly III ei vastaa todennuksen käsittelystä.',
    'delete_local_info_only'                    => "Koska Firefly III ei ole vastuussa käyttäjän hallinnasta tai todentamisen käsittelystä, tämä toiminto poistaa vain paikalliset Firefly III tiedot.",
    'oauth'                                     => 'OAuth',
    'profile_oauth_clients'                     => 'OAuth Asiakkaat',
    'profile_oauth_no_clients'                  => 'Et ole luonut yhtään OAuth-asiakasta.',
    'profile_oauth_clients_external_auth'       => 'If you\'re using an external authentication provider like Authelia, OAuth Clients will not work. You can use Personal Access Tokens only.',
    'profile_oauth_clients_header'              => 'Asiakasohjelmat',
    'profile_oauth_client_id'                   => 'Asiakastunnus',
    'profile_oauth_client_name'                 => 'Nimi',
    'profile_oauth_client_secret'               => 'Salaisuus',
    'profile_oauth_create_new_client'           => 'Luo Uusi Asiakas',
    'profile_oauth_create_client'               => 'Luo Asiakas',
    'profile_oauth_edit_client'                 => 'Muokkaa asiakasta',
    'profile_oauth_name_help'                   => 'Jotain käyttäjillesi tuttua ja luotettavaa.',
    'profile_oauth_redirect_url'                => 'URL:n uudelleenohjaus',
    'profile_oauth_redirect_url_help'           => 'Sovelluksesi valtuutuksen callback URL.',
    'profile_authorized_apps'                   => 'Valtuutetut sovellukset',
    'profile_authorized_clients'                => 'Valtuutetut asiakkaat',
    'profile_scopes'                            => 'Aihepiirit',
    'profile_revoke'                            => 'Peruuta',
    'profile_oauth_client_secret_title'         => 'Asiakkaan salausavain (Client secret)',
    'profile_oauth_client_secret_expl'          => 'Tässä on uusi asiakkaan salausavaimesi. Tämä on ainoa kerta kun se näytetään, joten älä hukkaa sitä! Voit nyt käyttää tätä avainta tehdäksesi API komentoja.',
    'profile_personal_access_tokens'            => 'Henkilökohtaiset Käyttöoikeuskoodit',
    'profile_personal_access_token'             => 'Henkilökohtainen Käyttöoikeuskoodi',
    'profile_oauth_confidential'                => 'Luottamuksellinen',
    'profile_oauth_confidential_help'           => 'Require the client to authenticate with a secret. Confidential clients can hold credentials in a secure way without exposing them to unauthorized parties. Public applications, such as native desktop or JavaScript SPA applications, are unable to hold secrets securely.',
    'profile_personal_access_token_explanation' => 'Tässä on uusi henkilökohtainen pääsytunnuksesi. Tämä on ainoa kerta, kun se näytetään, joten älä hävitä sitä! Voit nyt käyttää tätä tunnusta tehdäksesi API-pyyntöjä.',
    'profile_no_personal_access_token'          => 'Et ole luonut henkilökohtaisia käyttöoikeustunnuksia.',
    'profile_create_new_token'                  => 'Luo uusi tunnus',
    'profile_create_token'                      => 'Luo tunnus',
    'profile_create'                            => 'Luo',
    'profile_save_changes'                      => 'Tallenna muutokset',
    'profile_whoops'                            => 'Hupsis!',
    'profile_something_wrong'                   => 'Jokin meni vikaan!',
    'profile_try_again'                         => 'Jokin meni vikaan. Yritä uudelleen.',
    'amounts'                                   => 'Summat',
    'multi_account_warning_unknown'             => 'Riippuen luomasi tapahtuman tyypistä, myöhempien jaotteluiden lähde- ja/tai kohdetilin tyyppi voidaan kumota sen mukaan, mitä on määritelty tapahtuman ensimmäisessä jaossa.',
    'multi_account_warning_withdrawal'          => 'Muista, että myöhempien jakojen lähdetili määräytyy noston ensimmäisen jaon määritysten mukaan.',
    'multi_account_warning_deposit'             => 'Muista, että myöhempien jakojen kohdetili määräytyy talletuksen ensimmäisen jaon määritysten mukaan.',
    'multi_account_warning_transfer'            => 'Muista, että myöhempien jakojen lähde- ja kohdetili määräytyvät ensimmäisen jaon määritysten mukaan.',


    // export data:
    'export_data_title'                         => 'Vie tietoja Firefly III:sta',
    'export_data_menu'                          => 'Vie tietoja',
    'export_data_bc'                            => 'Vie tietoja Firefly III:sta',
    'export_data_main_title'                    => 'Vie tietoja Firefly III:sta',
    'export_data_expl'                          => 'Tämän linkin avulla voit viedä kaikki tapahtumat ja metatiedot Firefly III:sta. Katso ohjeista (oikeassa yläkulmassa (?) - kuvake) saadaksesi lisätietoja prosessista.',
    'export_data_all_transactions'              => 'Vie kaikki tapahtumat',
    'export_data_advanced_expl'                 => 'Jos tarvitset edistyneempää tai tietyn tyyppistä vientiä, lue ohjeet konsolikomennon käytöstä <code>php artisan help firefly-iii:export-data</code>.',

    // attachments
    'nr_of_attachments'                         => 'Yksi liite|:count liitettä',
    'attachments'                               => 'Liitteet',
    'edit_attachment'                           => 'Muokkaa liitettä ":name"',
    'update_attachment'                         => 'Päivitä liite',
    'delete_attachment'                         => 'Poista liite ":name"',
    'attachment_deleted'                        => 'Liite ":name" poistettu',
    'liabilities_deleted'                       => 'Laina ":name" poistettu',
    'attachment_updated'                        => 'Liite ":name" päivitetty',
    'upload_max_file_size'                      => 'Tiedoston enimmäiskoko: :size',
    'list_all_attachments'                      => 'Lista kaikista liitteistä',

    // transaction index
    'is_reconciled_fields_dropped'              => 'Because this transaction is reconciled, you will not be able to update the accounts, nor the amount(s) unless you remove the reconciliation flag.',
    'is_reconciled'                             => 'Is reconciled',
    'title_expenses'                            => 'Kustannukset',
    'title_withdrawal'                          => 'Kustannukset',
    'title_revenue'                             => 'Tuotto / ansio',
    'title_deposit'                             => 'Tuotto / ansio',
    'title_transfer'                            => 'Tilisiirrot',
    'title_transfers'                           => 'Tilisiirrot',
    'submission_options'                        => 'Submission options',
    'apply_rules_checkbox'                      => 'Apply rules',
    'fire_webhooks_checkbox'                    => 'Fire webhooks',
    'select_source_account'                     => 'Please select or type a valid source account name',
    'select_dest_account'                       => 'Please select or type a valid destination account name',

    // convert stuff:
    'convert_is_already_type_Withdrawal'        => 'Tämä tapahtuma on jo nosto',
    'convert_is_already_type_Deposit'           => 'Tämä tapahtuma on jo talletus',
    'convert_is_already_type_Transfer'          => 'Tämä tapahtuma on jo siirto',
    'convert_to_Withdrawal'                     => 'Muuta ":description" nostoksi',
    'convert_to_Deposit'                        => 'Muuta ":description" talletukseksi',
    'convert_to_Transfer'                       => 'Muuta ":description" siirroksi',
    'convert_options_WithdrawalDeposit'         => 'Muuta nosto talletukseksi',
    'convert_options_WithdrawalTransfer'        => 'Muuta nosto siirroksi',
    'convert_options_DepositTransfer'           => 'Muuta talletus siirroksi',
    'convert_options_DepositWithdrawal'         => 'Muuta talletus nostoksi',
    'convert_options_TransferWithdrawal'        => 'Muuta siirto nostoksi',
    'convert_options_TransferDeposit'           => 'Muuta siirto talletukseksi',
    'convert_Withdrawal_to_deposit'             => 'Muuta tämä nosto talletukseksi',
    'convert_Withdrawal_to_transfer'            => 'Muuta tämä nosto siirroksi',
    'convert_Deposit_to_withdrawal'             => 'Muuta tämä talletus nostoksi',
    'convert_Deposit_to_transfer'               => 'Muuta tämä talletus siirroksi',
    'convert_Transfer_to_deposit'               => 'Muuta tämä siirto talletukseksi',
    'convert_Transfer_to_withdrawal'            => 'Muuta tämä siirto nostoksi',
    'convert_please_set_revenue_source'         => 'Valitse tuottotili jolta raha tulee.',
    'convert_please_set_asset_destination'      => 'Valitse omaisuustili jonne raha menee.',
    'convert_please_set_expense_destination'    => 'Valitse kulutustili jonne raha menee.',
    'convert_please_set_asset_source'           => 'Valitse omaisuustili jolta raha tulee.',
    'convert_expl_w_d'                          => 'Kun nosto muunnetaan talletukseksi, summa talletetaan näytettävälle kohdetilille sen sijaan, että ne poistettaisiin siltä.|Kun nosto muunnetaan talletukseksi, summa talletetaan näytettäville määrätileille sen sijaan, että se poistettaisiin niiltä.',
    'convert_expl_w_t'                          => 'Kun nosto muutetaan siirroksi, raha siirretään pois lähdetililtä muuhun omaisuus- tai lainatilille sen sijaan, että se käytettäisiin alkuperäiseen kulutiliin.|Kun nosto muutetaan siirroksi, raha siirretään pois lähdetileiltä muihin omaisuus- tai lainatileille sen sijaan, että se käytettäisiin alkuperäisiin kulutileihin.',
    'convert_expl_d_w'                          => 'Kun talletus muunnetaan nostoksi, rahat poistetaan näytetyltä lähdetililtä sen sijaan, että ne talletettaisiin sille.|Kun talletus muunnetaan nostoksi, rahat poistetaan näytetyiltä lähdetileiltä sen sijaan, että ne talletettaisiin niille.',
    'convert_expl_d_t'                          => 'Kun muutat talletuksen siirroksi, rahat talletetaan listan kohdetilille miltä tahansa omaisuus- tai lainatililtäsi.|Kun muutat talletuksen siirroksi, rahat talletetaan listan kohdetileille miltä tahansa omaisuus- tai lainatileiltäsi.',
    'convert_expl_t_w'                          => 'Kun muunnat siirron nostoksi, rahat talletetaan kohdetilille, jonka olet määrittänyt täällä, sen sijaan, että ne siirrettäisiin pois.|Kun muunnat siirron nostoksi, rahat talletetaan kohdetileille, jotka olet määrittänyt täällä, sen sijaan, että ne siirrettäisiin pois.',
    'convert_expl_t_d'                          => 'Kun muunnat siirron talletukseksi, summa talletetaan kohdetilille, jonka näet täällä, sen sijaan että se siirrettäisiin sille.|Kun muunnat siirron talletukseksi, summa talletetaan kohdetileille, jotka näet täällä, sen sijaan että se siirrettäisiin niille.',
    'convert_select_sources'                    => 'Viimeistelläksesi muuntamisen, aseta alla uusi lähdetili.|Viimeistelläksesi muuntamisen, aseta alla uudet lähdetilit.',
    'convert_select_destinations'               => 'Viimeistelläksesi muuntamisen, valitse alta uusi kohdetili.|Viimeistelläksesi muuntamisen, valitse alta uudet kohdetilit.',
    'converted_to_Withdrawal'                   => 'Tapahtuma on muutettu nostoksi',
    'converted_to_Deposit'                      => 'Tapahtuma on muutettu talletukseksi',
    'converted_to_Transfer'                     => 'Tapahtuma on muutettu siirroksi',
    'invalid_convert_selection'                 => 'Valitsemaasi tiliä on joko jo käytetty tässä tapahtumassa tai sitä ei ole olemassa.',
    'source_or_dest_invalid'                    => 'Tapahtuman tiedot eivät joko riitä tai kelpaa muunnoksen tekemiseen. Muunnos ei ole mahdollinen.',
    'convert_to_withdrawal'                     => 'Muuta nostoksi',
    'convert_to_deposit'                        => 'Muuta talletukseksi',
    'convert_to_transfer'                       => 'Muuta siirroksi',

    // create new stuff:
    'create_new_withdrawal'                     => 'Luo uusi nosto',
    'create_new_deposit'                        => 'Luo uusi talletus',
    'create_new_transfer'                       => 'Luo uusi siirto',
    'create_new_asset'                          => 'Luo uusi omaisuustili',
    'create_new_liabilities'                    => 'Luo uusi laina',
    'create_new_expense'                        => 'Luo uusi maksutili',
    'create_new_revenue'                        => 'Luo uusi tuottotili',
    'create_new_piggy_bank'                     => 'Luo uusi säästöpossu',
    'create_new_bill'                           => 'Create new subscription',
    'create_new_subscription'                   => 'Create new subscription',
    'create_new_rule'                           => 'Create new rule',

    // currencies:
    'create_currency'                           => 'Luo uusi valuutta',
    'store_currency'                            => 'Tallenna uusi valuutta',
    'update_currency'                           => 'Päivitä valuutta',
    'new_default_currency'                      => '":name" is now the default currency.',
    'default_currency_failed'                   => 'Could not make ":name" the default currency. Please check the logs.',
    'cannot_delete_currency'                    => 'Valuuttaa :name ei voida poistaa koska se on yhä käytössä.',
    'cannot_delete_fallback_currency'           => ':name on järjestelmän varavaluutta eikä sitä voi poistaa.',
    'cannot_disable_currency_journals'          => 'Valuuttaa :name ei voi poistaa käytöstä koska tapahtumat käyttävät sitä yhä.',
    'cannot_disable_currency_last_left'         => 'Valuuttaa :name ei voi poistaa käytöstä koska se on viimeinen käytössä oleva valuutta.',
    'cannot_disable_currency_account_meta'      => 'Valuuttaa :name ei voi poistaa käytöstä koska se on käytössä omaisuustileissä.',
    'cannot_disable_currency_bills'             => 'Cannot disable :name because it is used in subscriptions.',
    'cannot_disable_currency_recurring'         => 'Valuuttaa :name ei voi poistaa käytöstä koska se on käytössä toistuvissa tapahtumissa.',
    'cannot_disable_currency_available_budgets' => 'Valuuttaa :name ei voi poistaa käytöstä koska se on käytössä budjeteissa.',
    'cannot_disable_currency_budget_limits'     => 'Valuuttaa :name ei voi poistaa käytöstä koska se on käytössä budjettirajoissa.',
    'cannot_disable_currency_current_default'   => 'Valuuttaa :name ei voi poistaa käytöstä koska se on tämän hetkinen oletusvaluutta.',
    'cannot_disable_currency_system_fallback'   => 'Valuuttaa :name ei voi poistaa käytöstä koska se on Firefly III:n oletusvaluutta.',
    'disable_EUR_side_effects'                  => 'Euro on Firefly III:n  hätävaraoletusvaluutta. Sen poistaminen käytöstä voi aiheuttaa epätoivottuja ja yllättäviä oireita ja ainakin mitätöi tuotetakuun.',
    'deleted_currency'                          => 'Valuutta :name poistettu',
    'created_currency'                          => 'Valuutta :name luotu',
    'could_not_store_currency'                  => 'Uutta valuuttaa ei voitu tallentaa.',
    'updated_currency'                          => 'Valuutta :name päivitetty',
    'ask_site_owner'                            => 'Pyydä että :owner lisää, poistaa tai muokkaa valuuttoja.',
    'currencies_intro'                          => 'Firefly III tukee useita valuuttoja joita voit luoda ja ottaa käyttöön täällä.',
    'currencies_switch_default'                 => 'You can switch the primary currency for your current administration on the "Financial administrations"-page.',
    'make_default_currency'                     => 'Aseta oletukseksi',
    'default_currency'                          => 'oletus',
    'primary_currency_button'                   => 'primary',
    'currency_is_disabled'                      => 'Ei käytössä',
    'enable_currency'                           => 'Ota käyttöön',
    'disable_currency'                          => 'Poista käytöstä',
    'currencies_default_disabled'               => 'Suurin osa näistä valuutoista on alkuun poistettu käytöstä. Ne pitää erikseen kytkeä päälle jos haluat käyttää niitä.',
    'currency_is_now_enabled'                   => 'Valuutta ":name" on otettu käyttöön',
    'could_not_enable_currency'                 => 'Could not enable currency ":name". Please review the logs.',
    'currency_is_now_disabled'                  => 'Valuutta ":name" poistettiin käytöstä',
    'could_not_disable_currency'                => 'Could not disable currency ":name". Perhaps it is still in use?',

    // forms:
    'mandatoryFields'                           => 'Pakolliset kentät',
    'optionalFields'                            => 'Valinnaiset kentät',
    'options'                                   => 'Valinnat',

    // budgets:
    'daily_budgets'                             => 'Päivittäiset budjetit',
    'weekly_budgets'                            => 'Viikoittaiset budjetit',
    'monthly_budgets'                           => 'Kuukausittaiset budjetit',
    'quarterly_budgets'                         => 'Neljännesvuosittaiset budjetit',
    'half_year_budgets'                         => 'Puolivuosittaiset budjetit',
    'yearly_budgets'                            => 'Vuosittaiset budjetit',
    'other_budgets'                             => 'Mukautetun ajan budjetit',
    'budget_limit_not_in_range'                 => 'Tämä summa on voimassa välillä :start - :end:',
    'total_available_budget'                    => 'Budjetissa jäljellä (välillä :start ja :end)',
    'total_available_budget_in_currency'        => 'Budjetissa jäljellä valuutassa :currency',
    'see_below'                                 => 'katso alla',
    'create_new_budget'                         => 'Luo uusi budjetti',
    'store_new_budget'                          => 'Tallenna uusi budjetti',
    'stored_new_budget'                         => 'Tallennettiin uusi budjetti ":name"',
    'available_between'                         => 'Rahaa jäljellä välillä :start ja :end',
    'transactionsWithoutBudget'                 => 'Kulut ilman budjettia',
    'transactions_no_budget'                    => 'Kulut ilman budjettia välillä :start ja :end',
    'spent_between'                             => 'Jo kulutettu välillä :start ja :end',
    'spent_between_left'                        => 'Spent :spent between :start and :end, leaving :left.',
    'set_available_amount'                      => 'Aseta käytettävissä oleva summa',
    'update_available_amount'                   => 'Päivitä käytettävissä oleva summa',
    'ab_basic_modal_explain'                    => 'Käytä tätä lomaketta arvioidessasi kuinka paljon uskot pystyväsi budjetoimaan (kokonaisuudessaan, valuutassa :currency) valitulla jaksolla.',
    'createBudget'                              => 'Uusi budjetti',
    'invalid_currency'                          => 'Tämä ei kelpaa valuutaksi',
    'invalid_amount'                            => 'Anna summa',
    'set_ab'                                    => 'Käytettävissä oleva budjetti on asetettu',
    'updated_ab'                                => 'Käytettävissä oleva budjetti on päivitetty',
    'deleted_ab'                                => 'Käytettävissä oleva budjetti on poistettu',
    'deleted_bl'                                => 'Budjetoitu summa on poistettu',
    'alt_currency_ab_create'                    => 'Aseta käytettävissä oleva budjetti toisessa valuutassa',
    'bl_create_btn'                             => 'Aseta budjetti toisessa valuutassa',
    'inactiveBudgets'                           => 'Ei käytössä olevat budjetit',
    'without_budget_between'                    => 'Siirrot ilman budjettia välillä :start ja :end',
    'delete_budget'                             => 'Poista budjetti ":name"',
    'deleted_budget'                            => 'Poistettiin budjetti ":name"',
    'edit_budget'                               => 'Muokkaa budjettia ":name"',
    'updated_budget'                            => 'Päivitettiin budjetti ":name"',
    'update_amount'                             => 'Päivitä summa',
    'update_budget'                             => 'Päivitä budjetti',
    'update_budget_amount_range'                => 'Päivitä (odotettavissa oleva) jäljellä oleva summa välillä :start ja :end',
    'set_budget_limit_title'                    => 'Aseta budjetoitu summa budjetille :budget välillä :start ja :end',
    'set_budget_limit'                          => 'Aseta budjetoitu summa',
    'budget_period_navigator'                   => 'Jakson valitsin',
    'info_on_available_amount'                  => 'Paljonko rahaa minulla on jäljellä?',
    'available_amount_indication'               => 'Käytä näitä arvoja arvioidaksesi kokonaisbudjettiasi.',
    'suggested'                                 => 'Ehdotus',
    'average_between'                           => 'Keskiarvo välillä :start ja :end',
    'transferred_in'                            => 'Siirretty (sisään)',
    'transferred_away'                          => 'Siirretty (ulos)',
    'auto_budget_none'                          => 'Ei automaattibudjettia',
    'auto_budget_reset'                         => 'Aseta sama kiinteä summa kaikille jaksoille',
    'auto_budget_rollover'                      => 'Kasvata summaa joka jaksossa',
    'auto_budget_adjusted'                      => 'Add an amount every period and correct for overspending',
    'auto_budget_period_daily'                  => 'Päivittäin',
    'auto_budget_period_weekly'                 => 'Viikoittain',
    'auto_budget_period_monthly'                => 'Kuukausittain',
    'auto_budget_period_quarterly'              => 'Neljännesvuosittain',
    'auto_budget_period_half_year'              => 'Puoli-vuosittain',
    'auto_budget_period_yearly'                 => 'Vuosittain',
    'auto_budget_help'                          => 'Voit lukea lisää tästä ominaisuudesta ohjeesta. Napsauta oikean yläkulman (?)-kuvaketta.',
    'auto_budget_reset_icon'                    => 'Tämä budjetti asetetaan määräajoin',
    'auto_budget_rollover_icon'                 => 'Budjetin summa kasvaa säännöllisesti',
    'auto_budget_adjusted_icon'                 => 'The budget amount will increase periodically and will correct for overspending',
    'remove_budgeted_amount'                    => 'Poista budjetoitu summa :currency',

    // bills:
    'left_to_pay_active_bills'                  => 'active, expected and not yet paid subscriptions',
    'left_to_pay_lc'                            => 'left to pay',
    'less_than_expected'                        => 'less than expected',
    'more_than_expected'                        => 'more than expected',
    'skip_help_text'                            => 'Use the skip field to create bi-monthly (skip = 1) or other custom intervals.',
    'subscription'                              => 'Subscription',
    'not_expected_period'                       => 'Ei odotettavissa tässä jaksossa',
    'subscriptions_in_group'                    => 'Subscriptions in group "{{title}}"',
    'subscr_expected_x_times'                   => 'Expect to pay {{amount}} {{times}} times this period',
    'not_or_not_yet'                            => 'Ei (vielä)',
    'visit_bill'                                => 'Visit subscription ":name" at Firefly III',
    'visit_bills'                               => 'Visit subscriptions at Firefly III',
    'match_between_amounts'                     => 'Subscription matches transactions between :low and :high.',
    'running_again_loss'                        => 'Previously linked transactions to this subscription may lose their connection, if they (no longer) match the rule(s).',
    'bill_related_rules'                        => 'Rules related to this subscription',
    'repeats'                                   => 'Toistot',
    'bill_end_date_help'                        => 'Optional field. The subscription is expected to end on this date.',
    'bill_extension_date_help'                  => 'Optional field. The subscription must be extended (or cancelled) on or before this date.',
    'bill_end_index_line'                       => 'This subscription ends on :date',
    'bill_extension_index_line'                 => 'This subscription must be extended or cancelled on :date',
    'connected_journals'                        => 'Linkitetyt tapahtumat',
    'auto_match_on'                             => 'Firefly III:n automaattisesti yhdistämät',
    'auto_match_off'                            => 'Näitä Firefly III ei ole automaattisesti yhdistänyt',
    'next_expected_match'                       => 'Seuraava lasku odotettavissa',
    'delete_bill'                               => 'Delete subscription ":name"',
    'deleted_bill'                              => 'Deleted subscription ":name"',
    'edit_bill'                                 => 'Edit subscription ":name"',
    'more'                                      => 'Lisää',
    'rescan_old'                                => 'Aja säännöt uudestaan, kaikille tapahtumille',
    'update_bill'                               => 'Update subscription',
    'updated_bill'                              => 'Updated subscription ":name"',
    'store_new_bill'                            => 'Store new subscription',
    'stored_new_bill'                           => 'Stored new subscription ":name"',
    'cannot_scan_inactive_bill'                 => 'Inactive subscriptions cannot be scanned.',
    'rescanned_bill'                            => 'Rescanned everything, and linked :count transaction to the subscription.|Rescanned everything, and linked :count transactions to the subscription.',
    'average_bill_amount_year'                  => 'Average subscription amount (:year)',
    'average_bill_amount_overall'               => 'Average subscription amount (overall)',
    'bill_is_active'                            => 'Subscription is active',
    'bill_expected_between'                     => 'Odotettavissa välillä :start ja :end',
    'bill_will_automatch'                       => 'Subscription will automatically linked to matching transactions',
    'skips_over'                                => 'ohittaa',
    'bill_store_error'                          => 'An unexpected error occurred while storing your new subscription. Please check the log files',
    'list_inactive_rule'                        => 'käytöstä poistettu sääntö',
    'bill_edit_rules'                           => 'Firefly III will attempt to edit the rule related to this subscription as well. If you\'ve edited this rule yourself however, Firefly III won\'t change anything.|Firefly III will attempt to edit the :count rules related to this subscription as well. If you\'ve edited these rules yourself however, Firefly III won\'t change anything.',
    'bill_expected_date'                        => 'Odotettavissa :date',
    'bill_expected_date_js'                     => 'Odotettavissa {date}',
    'expected_amount'                           => '(Expected) amount',
    'bill_paid_on'                              => 'Maksettu {date}',
    'bill_repeats_weekly'                       => 'Toistuu viikoittain',
    'bill_repeats_monthly'                      => 'Toistuu kuukausittain',
    'bill_repeats_quarterly'                    => 'Toistuu neljännesvuosittain',
    'bill_repeats_half-year'                    => 'Toistuu puolen vuoden välein',
    'bill_repeats_yearly'                       => 'Toistuu vuosittain',
    'bill_repeats_weekly_other'                 => 'Toistuu joka toinen viikko',
    'bill_repeats_monthly_other'                => 'Toistuu joka toinen kuukausi',
    'bill_repeats_quarterly_other'              => 'Toistuu joka toinen neljännes',
    'bill_repeats_half-year_other'              => 'Toistuu vuosittain',
    'bill_repeats_yearly_other'                 => 'Toistuu joka toinen vuosi',
    'bill_repeats_weekly_skip'                  => 'Toistuu {skip} viikon välein',
    'bill_repeats_monthly_skip'                 => 'Toistuu {skip} kuukauden välein',
    'bill_repeats_quarterly_skip'               => 'Toista {skip} vuosineljänneksen välein',
    'bill_repeats_half-year_skip'               => 'Toistuu {skip} puolen vuoden välein',
    'bill_repeats_yearly_skip'                  => 'Toistuu {skip} vuoden välein',
    'subscriptions'                             => 'Tilaukset',
    'go_to_subscriptions'                       => 'Go to your subscriptions',
    'forever'                                   => 'Ikuisesti',
    'extension_date_is'                         => 'Laajennuksen päivämäärä on {date}',

    // accounts:
    'account_locked_currency'                   => 'The currency of this account must remain :name as long as piggy banks are linked to it.',
    'i_am_owed_amount'                          => 'I am owed amount',
    'i_owe_amount'                              => 'I owe amount',
    'inactive_account_link'                     => 'Sinulla on :count passiivinen (arkistoitu) tili, jota voit tarkastella tällä erillisellä sivulla.|Sinulla on :count passiivista (arkistoitua) tiliä, joita voit tarkastella tällä erillisellä sivulla.',
    'all_accounts_inactive'                     => 'Nämä ovat käytöstä poistettuja tilejä.',
    'active_account_link'                       => 'Tämä linkki vie sinut takaisin aktiivisiin tileihisi.',
    'account_missing_transaction'               => 'Tiliä #:id (":name") ei voi tarkastella suoraan, mutta Firefly:lta puuttuvat uudelleenohjaustiedot.',
    'cc_monthly_payment_date_help'              => 'Valitse mikä tahansa vuosi ja mikä tahansa kuukausi, ne jätetään kuitenkin huomiotta. Vain kuukauden päivä on merkityksellinen.',
    'details_for_asset'                         => 'Yksityiskohdat omaisuustilille ":name"',
    'details_for_expense'                       => 'Yksityiskohdat kulutustilille ":name"',
    'details_for_revenue'                       => 'Yksityiskohdat tuottotilille ":name"',
    'details_for_cash'                          => 'Yksityiskohdat käteistilille ":name"',
    'store_new_asset_account'                   => 'Tallenna uusi omaisuustili',
    'store_new_expense_account'                 => 'Tallenna uusi kulutustili',
    'store_new_revenue_account'                 => 'Tallenna uusi tuottotili',
    'edit_asset_account'                        => 'Muokkaa omaisuustiliä ":name"',
    'edit_expense_account'                      => 'Muokkaa kulutustiliä ":name"',
    'edit_revenue_account'                      => 'Muokkaa tuottotiliä ":name"',
    'delete_asset_account'                      => 'Poista omaisuustili ":name"',
    'delete_expense_account'                    => 'Poista kulutustili ":name"',
    'delete_revenue_account'                    => 'Poista tuottotili ":name"',
    'delete_liabilities_account'                => 'Poista laina ":name"',
    'asset_deleted'                             => 'Poistettiin onnistuneesti omaisuustili ":name"',
    'account_deleted'                           => 'Tilin ":name" poistaminen onnistui',
    'expense_deleted'                           => 'Poistettiin onnistuneesti kulutustili ":name"',
    'revenue_deleted'                           => 'Poistettiin onnistuneesti tuottotili ":name"',
    'update_asset_account'                      => 'Päivitä omaisuustili',
    'update_undefined_account'                  => 'Päivitä tili',
    'update_liabilities_account'                => 'Päivitä laina',
    'update_expense_account'                    => 'Päivitä kulutustili',
    'update_revenue_account'                    => 'Päivitä tuottotili',
    'make_new_asset_account'                    => 'Luo uusi omaisuustili',
    'make_new_expense_account'                  => 'Luo uusi kulutustili',
    'make_new_revenue_account'                  => 'Luo uusi tuottotili',
    'make_new_liabilities_account'              => 'Luo uusi laina',
    'asset_accounts'                            => 'Käyttötilit',
    'undefined_accounts'                        => 'Tilit',
    'asset_accounts_inactive'                   => 'Käyttötilit (ei käytössä)',
    'expense_account'                           => 'Expense account',
    'expense_accounts'                          => 'Kulutustilit',
    'expense_accounts_inactive'                 => 'Kulutustilit (ei käytössä)',
    'revenue_account'                           => 'Revenue account',
    'revenue_accounts'                          => 'Tuottotilit',
    'revenue_accounts_inactive'                 => 'Tuottotilit (ei käytössä)',
    'cash_accounts'                             => 'Käteistilit',
    'Cash account'                              => 'Käteistili',
    'liabilities_accounts'                      => 'Lainat',
    'liabilities_accounts_inactive'             => 'Lainat (Ei aktiiviset)',
    'reconcile_account'                         => 'Täsmäytä tili ":account"',
    'overview_of_reconcile_modal'               => 'Täsmäytyksen yleiskatsaus',
    'delete_reconciliation'                     => 'Poista täsmäytys',
    'update_reconciliation'                     => 'Päivitä täsmäytys',
    'amount_cannot_be_zero'                     => 'Summa yhteensä ei voi olla nolla',
    'end_of_reconcile_period'                   => 'Täsmäytysjakson loppu: :period',
    'start_of_reconcile_period'                 => 'Täsmäytysjakson alku: :period',
    'start_balance'                             => 'Alkusaldo',
    'end_balance'                               => 'Loppusaldo',
    'update_balance_dates_instruction'          => 'Täsmää yllä olevat summat ja päivämäärät tiliotteesi kanssa ja paina "Aloita täsmäytys"',
    'select_transactions_instruction'           => 'Valitse tapahtumat jotka löytyvät pankkisi tiliotteesta.',
    'select_range_and_balance'                  => 'Varmista ensin päivämäärärajat sekä saldot. Valitse sitten "Aloita täsmäytys"',
    'date_change_instruction'                   => 'Jos muutat päivämäärärajoja nyt, kaikki muutokset menetetään.',
    'update_selection'                          => 'Päivitä valinta',
    'store_reconcile'                           => 'Tallenna täsmäytys',
    'reconciliation_transaction'                => 'Täsmäytystapahtuma',
    'Reconciliation'                            => 'Täsmäytys',
    'reconciliation'                            => 'Täsmäytys',
    'reconcile_options'                         => 'Täsmäytysvalinnat',
    'reconcile_range'                           => 'Täsmäytyksen aikarajat',
    'start_reconcile'                           => 'Aloita täsmäytys',
    'cash_account_type'                         => 'Käteinen',
    'cash'                                      => 'käteinen',
    'cant_find_redirect_account'                => 'Firefly III yritti tehdä pyytämääsi uudelleenohjausta mutta epäonnistui. Pahoittelut siitä. Takaisin valikkoon.',
    'account_type'                              => 'Tilin tyyppi',
    'save_transactions_by_moving'               => 'Tallenna tämä tapahtuma siirtämällä se toiselle tilille:|Tallenna nämä tapahtumat siirtämällä ne toiselle tilille:',
    'save_transactions_by_moving_js'            => 'Ei tapahtumia|Tallenna tämä tapahtuma siirtämällä se toiselle tilille. |Tallenna nämä tapahtumat siirtämällä ne toiselle tilille.',
    'stored_new_account'                        => 'Uusi tili ":name" tallennettiin!',
    'stored_new_account_js'                     => 'Uusi tili "<a href="accounts/show/{ID}">{name}</a>" tallennettu!',
    'updated_account'                           => 'Tiliä ":name" päivitettiin',
    'updated_account_js'                        => 'Päivitetty tili "<a href="accounts/show/{ID}">{title}</a>".',
    'credit_card_options'                       => 'Luottokorttivalinnat',
    'no_transactions_account'                   => 'Tilillä ":name" ei ole yhtään tapahtumaa (tässä jaksossa).',
    'no_transactions_period'                    => 'Ei tapahtumia (tässä jaksossa).',
    'no_data_for_chart'                         => 'Tämän kuvaajan luomiseen ei ole (vielä) riittävästi tietoja.',
    'select_at_least_one_account'               => 'Valitse vähintään yksi omaisuustili',
    'select_at_least_one_category'              => 'Valitse vähintään yksi kategoria',
    'select_at_least_one_budget'                => 'Valitse vähintään yksi budjetti',
    'select_at_least_one_tag'                   => 'Valitse vähintään yksi tägi',
    'select_at_least_one_expense'               => 'Valitse vähintään yksi meno- ja tulotilien kombinaatio. Jos sinulla ei ole yhtään (lista on tyhjä) tämä raportti ei ole saatavilla.',
    'account_default_currency'                  => 'Valitsit tälle tilille juuri oletusvaluutan.',
    'piggy_default_currency'                    => 'Piggy banks can only save money in a single currency.',
    'piggy_account_currency_match'              => 'Only accounts that use the previously selected currency will be accepted.',
    'reconcile_has_more'                        => 'Firefly III:n pääkirjassa on enemmän rahaa kuin mitä sinun pankkisi sanoo sinulla olevan. Sinulla on useita valintoja - valitse mitä haluat tehdä. Kun olet valmis valitse "Vahvista täsmäytys".',
    'reconcile_has_less'                        => 'Firefly III:n pääkirjassa on vähemmän rahaa kuin mitä sinun pankkisi sanoo sinulla olevan. Sinulla on useita valintoja - valitse mitä haluat tehdä. Kun olet valmis valitse "Vahvista täsmäytys".',
    'reconcile_is_equal'                        => 'Firefly III:n pääkirja ja sinun pankkisi lausunnot täsmäävät. Mitään ei tarvitse tehdä. Valitse "Vahvista täsmäytys" vahvistaaksesi antamasi tiedot.',
    'create_pos_reconcile_transaction'          => 'Merkitse valitut tapahtumat selvitetyksi ja luo korjaus lisäämällä :amount tälle omaisuustilille.',
    'create_neg_reconcile_transaction'          => 'Merkitse valitut tapahtumat selvitetyksi ja luo korjaus poistamalla :amount tältä omaisuustililtä.',
    'reconcile_do_nothing'                      => 'Merkitse valitut tapahtumat selvitetyksi, mutta älä korjaa.',
    'reconcile_go_back'                         => 'Voit aina muokata tai poistaa korjauksia myöhemmin.',
    'must_be_asset_account'                     => 'Voit täsmäyttää ainoastaan omaisuustilejä',
    'reconciliation_stored'                     => 'Täsmäytys tallennettu',
    'reconciliation_error'                      => 'Tapahtuneen virheen vuoksi tapahtumat merkittiin tarkistetuiksi mutta korjausta ei tallennettu: :error.',
    'reconciliation_transaction_title'          => 'Täsmäytys (:from - :to)',
    'sum_of_reconciliation'                     => 'Täsmäytykset yhteensä',
    'reconcile_this_account'                    => 'Täsmäytä tämä tili',
    'reconcile'                                 => 'Täsmäytä',
    'show'                                      => 'Näytä',
    'confirm_reconciliation'                    => 'Vahvista täsmäytys',
    'submitted_start_balance'                   => 'Annettu avaussaldo',
    'selected_transactions'                     => 'Valitut tapahtumat (:count)',
    'already_cleared_transactions'              => 'Jo selvitetyt tapahtumat (:count)',
    'submitted_end_balance'                     => 'Annettu loppusaldo',
    'initial_balance_description'               => 'Avaussaldo tilille ":account"',
    'liability_credit_description'              => 'Lainan luotto tilille ":account"',
    'interest_calc_'                            => 'tuntematon',
    'interest_calc_daily'                       => 'Päivässä',
    'interest_calc_monthly'                     => 'Kuukaudessa',
    'interest_calc_yearly'                      => 'Vuodessa',
    'interest_calc_weekly'                      => 'Viikossa',
    'interest_calc_half-year'                   => 'Puolessa vuodessa',
    'interest_calc_quarterly'                   => 'Neljännestä kohden',
    'initial_balance_account'                   => 'Alkutasetili :account',
    'list_options'                              => 'Listan valinnat',
    'account_column_opt_drag_and_drop'          => 'Drag and drop',
    'account_column_opt_active'                 => 'Active',
    'account_column_opt_name'                   => 'Name',
    'account_column_opt_type'                   => 'Type',
    'account_column_opt_liability_type'         => 'Liability type',
    'account_column_opt_liability_direction'    => 'Liability direction',
    'account_column_opt_liability_interest'     => 'Liability interest',
    'account_column_opt_number'                 => 'Account number',
    'account_column_opt_current_balance'        => 'Current balance',
    'account_column_opt_amount_due'             => 'Amount due',
    'account_column_opt_last_activity'          => 'Last activity',
    'account_column_opt_balance_difference'     => 'Balance difference',
    'account_column_opt_menu'                   => 'Menu',

    // categories:
    'new_category'                              => 'Uusi kategoria',
    'create_new_category'                       => 'Luo uusi kategoria',
    'without_category'                          => 'Ilman kategoriaa',
    'update_category'                           => 'Päivitä kategoria',
    'updated_category'                          => 'Päivitettiin kategoria ":name"',
    'categories'                                => 'Kategoriat',
    'edit_category'                             => 'Muokkaa kategoriaa ":name"',
    'no_category'                               => '(ei kategoriaa)',
    'unknown_category_plain'                    => 'No category',
    'category'                                  => 'Kategoria',
    'delete_category'                           => 'Poista kategoria ":name"',
    'deleted_category'                          => 'Poistettiin kategoria ":name"',
    'store_category'                            => 'Tallenna uusi kategoria',
    'stored_category'                           => 'Tallennettiin uusi kategoria ":name"',
    'without_category_between'                  => 'Ilman kategoriaa välillä :start ja :end',


    // transactions:
    'wait_loading_transaction'                  => 'Please wait for the form to load',
    'wait_loading_data'                         => 'Please wait for your information to load...',
    'wait_attachments'                          => 'Please wait for the attachments to upload.',
    'errors_upload'                             => 'The upload has failed. Please check your browser console for the error.',
    'amount_foreign_if'                         => 'Amount in foreign currency, if any',
    'amount_destination_account'                => 'Amount in the currency of the destination account',
    'edit_transaction_title'                    => 'Edit transaction ":description"',
    'unreconcile'                               => 'Undo reconciliation',
    'update_withdrawal'                         => 'Päivitä nosto',
    'update_deposit'                            => 'Päivitä talletus',
    'update_transaction'                        => 'Päivitä tapahtuma',
    'update_transfer'                           => 'Päivitä siirto',
    'updated_withdrawal'                        => 'Päivitettiin nosto ":description"',
    'updated_deposit'                           => 'Päivitettiin talletus ":description"',
    'updated_transfer'                          => 'Päivitettiin siirto ":description"',
    'no_changes_withdrawal'                     => 'Nosto ":description" ei muuttunut.',
    'no_changes_deposit'                        => 'Talletus ":description" ei muuttunut.',
    'no_changes_transfer'                       => 'Tilisiirto ":description" ei muuttunut.',
    'delete_withdrawal'                         => 'Poista nosto ":description"',
    'delete_deposit'                            => 'Poista talletus ":description"',
    'delete_transfer'                           => 'Poista siirto ":description"',
    'deleted_withdrawal'                        => 'Noston ":description" poisto onnistui',
    'deleted_deposit'                           => 'Talletuksen ":description" poisto onnistui',
    'deleted_transfer'                          => 'Siirron ":description" poisto onnistui',
    'deleted_reconciliation'                    => 'Täsmäytystapahtuma ":description" poistettiin onnistuneesti',
    'stored_journal'                            => 'Loit onnistuneesti uuden tapahtuman ":description"',
    'stored_journal_js'                         => 'Successfully created new transaction "{{description}}"',
    'stored_journal_no_descr'                   => 'Loit onnistuneesti uuden tapahtumasi',
    'updated_journal_no_descr'                  => 'Päivitit tapahtumaasi onnistuneesti',
    'select_transactions'                       => 'Valitse tapahtumat',
    'rule_group_select_transactions'            => 'Aja tapahtumille sääntöryhmä ":title"',
    'rule_select_transactions'                  => 'Aja tapahtumille sääntö ":title"',
    'stop_selection'                            => 'Lopeta tapahtumien valinta',
    'reconcile_selected'                        => 'Täsmäytä',
    'mass_delete_journals'                      => 'Poista tapahtumia',
    'mass_edit_journals'                        => 'Muokkaa tapahtumia',
    'mass_bulk_journals'                        => 'Muokkaa valittuja tapahtumia yhdessä',
    'mass_bulk_journals_explain'                => 'Tällä lomakkeella voit muuttaa alla listattujen tapahtumien ominaisuuksia yhdellä päivityksellä. Kaikki taulukon tapahtumat päivitetään kun muutat tässä näkyviä ominaisuuksia.',
    'part_of_split'                             => 'Tämä tapahtuma on osa jaettua tapahtumaa. Jos et ole valinnut kaikkia tapahtuman osia, saatat tehdä muutoksen ainoastaan osaan tapahtumasta.',
    'bulk_set_new_values'                       => 'Käytä alla olevia kenttiä uusien arvojen antamiseen. Jos jätät ne tyhjiksi, ne tyhjennetään kaikilta. Huomaa lisäksi, että ainoastaan nostoille asetetaan budjetti.',
    'no_bulk_category'                          => 'Älä päivitä kategoriaa',
    'no_bulk_budget'                            => 'Älä päivitä budjettia',
    'no_bulk_tags'                              => 'Älä päivitä tägejä',
    'replace_with_these_tags'                   => 'Korvaa näillä tageilla',
    'append_these_tags'                         => 'Lisää nämä tagit',
    'mass_edit'                                 => 'Muokkaa valittuja yksitellen',
    'bulk_edit'                                 => 'Muokkaa kaikkia valittuja yhtäaikaa',
    'mass_delete'                               => 'Poista valitut',
    'cannot_edit_other_fields'                  => 'Et voi massamuuttaa tapahtumien muita kuin tässä näkyviä kenttiä, koska ne eivät mahdu ruudulle. Jos niitä täytyy kuitenkin muokata, seuraa linkkiä ja muokkaa niitä yksitellen.',
    'cannot_change_amount_reconciled'           => 'You can\'t change the amount or account(s) of reconciled transactions.',
    'no_budget'                                 => '(ei budjettia)',
    'no_bill'                                   => '(no subscription)',
    'account_per_budget'                        => 'Tili per budjetti',
    'account_per_category'                      => 'Tili per kategoria',
    'create_new_object'                         => 'Luo',
    'empty'                                     => '(tyhjä)',
    'all_other_budgets'                         => '(kaikki muut budjetit)',
    'all_other_accounts'                        => '(kaikki muut tilit)',
    'expense_per_source_account'                => 'Menot lähdetileittäin',
    'expense_per_destination_account'           => 'Menot kohdetileittäin',
    'income_per_destination_account'            => 'Tuotot kohdetileittäin',
    'spent_in_specific_category'                => 'Kulutettu kategoriassa ":category"',
    'earned_in_specific_category'               => 'Ansaittu kategoriassa ":category"',
    'spent_in_specific_tag'                     => 'Kulutettu tägillä ":tag"',
    'earned_in_specific_tag'                    => 'Ansaittu tägillä ":tag"',
    'income_per_source_account'                 => 'Tulot lähdetileittäin',
    'average_spending_per_destination'          => 'Keskimääräinen kulu kohdetileittäin',
    'average_spending_per_source'               => 'Keskimääräinen kulu lähdetileittäin',
    'average_earning_per_source'                => 'Keskimääräinen tulo lähdetileittäin',
    'average_earning_per_destination'           => 'Keskimääräinen tulo kohdetileittäin',
    'account_per_tag'                           => 'Tilit tägeittäin',
    'tag_report_expenses_listed_once'           => 'Kuluja ja ansioita ei koskaan listata kahdesti. Jos tapahtumalla on useita tägejä, se näkyy ainoastaan yhden tägin alla. Tämä lista saattaa näyttää, että siitä puuttuu tietoja, mutta summat ovat silti oikein.',
    'double_report_expenses_charted_once'       => 'Kuluja ja ansioita ei koskaan näytetä kahdesti. Jos tapahtumalla on useita tägejä, se näkyy ainoastaan yhden tägin alla. Tämä kuvaaja saattaa näyttää, että siitä puuttuu tietoja, mutta summat ovat silti oikein.',
    'tag_report_chart_single_tag'               => 'Tämä kuvaaja kuvaa yhden tägin alta löytyvät tapahtumat. Jos tapahtumalla on useita tägejä, täällä näkyvät asiat saattavat näkyä myös muiden tägien kuvaajissa.',
    'tag'                                       => 'Tägi',
    'no_budget_squared'                         => '(ei budjettia)',
    'perm-delete-many'                          => 'Suuren tapahtumamäärän poistaminen kerralla on hyvin riskialtista. Olethan varovainen. Täällä saatat tuhota esimerkiksi osia jaetuista tapahtumista, joten ole tarkkana.',
    'mass_deleted_transactions_success'         => 'Poistettiin :count tapahtuma.|Poistettiin :count tapahtumaa.',
    'mass_edited_transactions_success'          => 'Päivitettiin :count tapahtuma.|Päivitettiin :count tapahtumaa.',
    'opt_group_'                                => '(ei tilityyppiä)',
    'opt_group_no_account_type'                 => '(ei tilityyppiä)',
    'opt_group_defaultAsset'                    => 'Oletuskäyttötilit',
    'opt_group_savingAsset'                     => 'Säästötilit',
    'opt_group_sharedAsset'                     => 'Jaetut käyttötilit',
    'opt_group_ccAsset'                         => 'Luottokortit',
    'opt_group_cashWalletAsset'                 => 'Käteinen',
    'opt_group_expense_account'                 => 'Kulutustilit',
    'opt_group_revenue_account'                 => 'Tuottotilit',
    'opt_group_l_Loan'                          => 'Laina: Laina',
    'opt_group_cash_account'                    => 'Käteistili',
    'opt_group_l_Debt'                          => 'Laina: Velka',
    'opt_group_l_Mortgage'                      => 'Laina: Kiinnelaina',
    'opt_group_l_Credit card'                   => 'Laina: Luottokortti',
    'notes'                                     => 'Muistiinpanot',
    'view_notes'                                => 'View notes',
    'set_budget_limit_notes'                    => 'View the notes for this budgeted amount',
    'edit_bl_notes'                             => 'Edit notes',
    'update_bl_notes'                           => 'Update notes',
    'unknown_journal_error'                     => 'Tapahtuman tallennus epäonnistui. Syy tallentui lokitiedostoon.',
    'attachment_not_found'                      => 'Tätä liitettä ei löydy.',
    'journal_link_bill'                         => 'This transaction is linked to subscription <a href=":route">:name</a>. To remove the connection, uncheck the checkbox. Use rules to connect it to another subscription.',
    'transaction_stored_link'                   => '<a href="transactions/show/{ID}">Tapahtuma #{ID} ("{title}")</a> on tallennettu.',
    'transaction_new_stored_link'               => '<a href="transactions/show/{ID}">Tapahtuma #{ID}</a> on tallennettu.',
    'transaction_updated_link'                  => '<a href="transactions/show/{ID}">Tapahtuma #{ID}</a> ("{title}") on päivitetty.',
    'transaction_updated_no_changes'            => '<a href="transactions/show/{ID}">Tapahtuma #{ID}</a> ("{title}") ei muuttunut.',
    'first_split_decides'                       => 'Ensimmäinen jako määrittää tämän kentän arvon',
    'first_split_overrules_source'              => 'Ensimmäinen jako voi kumota lähdetilin',
    'first_split_overrules_destination'         => 'Ensimmäinen jako voi kumota kohdetilin',
    'spent_x_of_y'                              => 'Käytetty {amount} / {total}',

    // new user:
    'welcome'                                   => 'Tervetuloa Firefly III:een!',
    'submit'                                    => 'Vahvista',
    'submission'                                => 'Vahvistus',
    'submit_yes_really'                         => 'Vahvista (Tiedän mitä olen tekemässä)',
    'getting_started'                           => 'Käytön aloittaminen',
    'to_get_started'                            => 'Hienoa, olet onnistuneesti asentanut Firefly III:en. Alkuun päästäksesi anna käyttötilisi saldo sekä pankin nimi. Älä vielä tässä vaiheessa välitä vaikka tilejä olisi useita, voit lisätä loput myöhemmin. Firefly III tarvitsee alkutietoja näyttääkseen pääkäyttöliittymässä jotain.',
    'savings_balance_text'                      => 'Firefly III luo sinulle tarvittessa automaattisesti tilin. Alkuun tilillä ei ole yhtään rahaa, mutta voit kertoa Firefly III:lle saldon jolloin se tallennetaan.',
    'finish_up_new_user'                        => 'Valmista tuli! Voit jatkaa painamalla <strong>Vahvista</strong>. Sinut viedään Firefly III:en valikkoon.',
    'stored_new_accounts_new_user'              => 'No niin! Uudet tilisi on tallennettu.',
    'set_preferred_language'                    => 'Jos haluat käyttää Firefly III:a jollain toisella kielellä, valitse se tässä.',
    'language'                                  => 'Kieli',
    'new_savings_account'                       => ':bank_name säästötili',
    'cash_wallet'                               => 'Käteinen',
    'currency_not_present'                      => 'Älä välitä vaikka normaalisti käyttämäsi valuutta ei olisi listalla. Voit luoda omia valuuttoja Optiot > Valuutat valikossa.',

    // home page:
    'transaction_table_description'             => 'Taulu, joka sisältää tapahtumasi',
    'opposing_account'                          => 'Vastatili',
    'yourAccounts'                              => 'Omat tilisi',
    'your_accounts'                             => 'Tiliesi yleiskuva',
    'category_overview'                         => 'Kategorioiden tarkastelu',
    'expense_overview'                          => 'Kulutustilien tarkastelu',
    'revenue_overview'                          => 'Tuottotilien tarkastelu',
    'budgetsAndSpending'                        => 'Budjetit ja kulutus',
    'budgets_and_spending'                      => 'Budjetit ja kulutus',
    'go_to_budget'                              => 'Avaa budjetti "{budget}"',
    'go_to_deposits'                            => 'Siirry talletuksiin',
    'go_to_expenses'                            => 'Siirry kuluihin',
    'savings'                                   => 'Säästöt',
    'newWithdrawal'                             => 'Uusi kustannus',
    'newDeposit'                                => 'Uusi talletus',
    'newTransfer'                               => 'Uusi siirto',
    'bills_to_pay'                              => 'Subscriptions to pay',
    'per_day'                                   => 'Päivässä',
    'left_to_spend_per_day'                     => 'Käytettävissä per päivä',
    'bills_paid'                                => 'Subscriptions paid',
    'custom_period'                             => 'Mukautettu jakso',
    'reset_to_current'                          => 'Palauta nykyiselle kaudelle',
    'select_period'                             => 'Valitse kausi',

    // menu and titles, should be recycled as often as possible:
    'currency'                                  => 'Valuutta',
    'preferences'                               => 'Asetukset',
    'logout'                                    => 'Kirjaudu ulos',
    'logout_other_sessions'                     => 'Kirjaudu ulos kaikista muista istunnoista',
    'toggleNavigation'                          => 'Vaihda navigointia',
    'toggle_dropdown'                           => 'Toggle dropdown',
    'searchPlaceholder'                         => 'Hae ...',
    'version'                                   => 'Versio',
    'dashboard'                                 => 'Etusivu',
    'income_and_expense'                        => 'Income and expense',
    'all_money'                                 => 'All your money',
    'unknown_source_plain'                      => 'Unknown source account',
    'unknown_dest_plain'                        => 'Unknown destination account',
    'unknown_any_plain'                         => 'Unknown account',
    'unknown_budget_plain'                      => 'No budget',
    'available_budget'                          => 'Budjetista jäljellä ({currency})',
    'currencies'                                => 'Valuutat',
    'activity'                                  => 'Toiminta',
    'usage'                                     => 'Käyttö',
    'accounts'                                  => 'Tilit',
    'Asset account'                             => 'Käyttötili',
    'Default account'                           => 'Käyttötili',
    'Expense account'                           => 'Kulutustili',
    'Revenue account'                           => 'Tuottotili',
    'Initial balance account'                   => 'Alkutasetili',
    'account_type_Asset account'                => 'Asset account',
    'account_type_Expense account'              => 'Expense account',
    'account_type_Revenue account'              => 'Revenue account',
    'account_type_Debt'                         => 'Velka',
    'account_type_Loan'                         => 'Laina',
    'account_type_Mortgage'                     => 'Kiinnelaina',
    'account_type_debt'                         => 'Velka',
    'account_type_loan'                         => 'Laina',
    'account_type_mortgage'                     => 'Kiinnelaina',
    'account_type_Credit card'                  => 'Luottokortti',
    'credit_card_type_monthlyFull'              => 'Täysi maksu joka kuukausi',
    'liability_direction_credit'                => 'Minulle ollaan velkaa tämä',
    'liability_direction_debit'                 => 'Olen tämän velkaa jollekin muulle',
    'liability_direction_credit_short'          => 'Minulle ollaan velkaa',
    'liability_direction_debit_short'           => 'Olen velkaa',
    'liability_direction__short'                => 'Tuntematon',
    'liability_direction_null_short'            => 'Tuntematon',
    'Liability credit'                          => 'Lainan luotto',
    'budgets'                                   => 'Budjetit',
    'tags'                                      => 'Tägit',
    'reports'                                   => 'Raportit',
    'transactions'                              => 'Tapahtumat',
    'expenses'                                  => 'Kustannukset',
    'income'                                    => 'Tuotto / ansio',
    'transfers'                                 => 'Tilisiirrot',
    'moneyManagement'                           => 'Talouden hallinta',
    'money_management'                          => 'Talouden hallinta',
    'tools'                                     => 'Työkalut',
    'piggyBanks'                                => 'Säästöpossut',
    'piggy_banks'                               => 'Säästöpossut',
    'amount_x_of_y'                             => '{current} / {total}',
    'bills'                                     => 'Subscriptions',
    'withdrawal'                                => 'Nosto',
    'opening_balance'                           => 'Alkusaldo',
    'deposit'                                   => 'Talletus',
    'account'                                   => 'Tili',
    'transfer'                                  => 'Siirto',
    'Withdrawal'                                => 'Nosto',
    'Deposit'                                   => 'Talletus',
    'Transfer'                                  => 'Siirto',
    'bill'                                      => 'Subscription',
    'yes'                                       => 'Kyllä',
    'no'                                        => 'Ei',
    'amount'                                    => 'Summa',
    'overview'                                  => 'Yleiskatsaus',
    'saveOnAccount'                             => 'Tallenna tilille',
    'saveOnAccounts'                            => 'Save on account(s)',
    'unknown'                                   => 'Tuntematon',
    'monthly'                                   => 'Kuukausittain',
    'profile'                                   => 'Profiili',
    'errors'                                    => 'Virheet',
    'debt_start_date'                           => 'Velan aloituspäivä',
    'debt_start_amount'                         => 'Velan aloitussaldo',
    'debt_start_amount_help'                    => 'Tämä arvo on aina paras asettaa negatiiviseksi. Lue lisätietoja ohjesivuilta ((?) - kuvake oikeassa yläkulmassa).',
    'interest_period_help'                      => 'Tämä kenttä on puhtaasti kosmeettinen, eikä sitä lasketa sinulle. Kuten huomaat, pankit ovat erittäin salaperäisiä, joten Firefly III ei koskaan osaa tehdä näitä oikein.',
    'store_new_liabilities_account'             => 'Tallenna uusi laina',
    'edit_liabilities_account'                  => 'Muokkaa lainaa ":name"',
    'financial_control'                         => 'Talouden hallinta',
    'accounting'                                => 'Kirjanpito',
    'automation'                                => 'Automaatio',
    'others'                                    => 'Muut',
    'classification'                            => 'Luokitus',
    'store_transaction'                         => 'Tallenna tapahtuma',


    // reports:
    'quick_link_needs_accounts'                 => 'In order to generate reports, you need to add at least one asset account to Firefly III.',
    'report_default'                            => 'Talousraportti välillä :start ja :end',
    'report_audit'                              => 'Tapahtumahistorian yleiskatsaus välillä :start ja :end',
    'report_category'                           => 'Kategoriaraportti välillä :start ja :end',
    'report_double'                             => 'Kulutus- ja ansiotilien raportti välillä :start ja :end',
    'report_budget'                             => 'Budjettiraportti välillä :start ja :end',
    'report_tag'                                => 'Tägiraportti välillä :start ja :end',
    'quick_link_reports'                        => 'Pikalinkit',
    'quick_link_examples'                       => 'Nämä ovat vain esimerkkilinkkejä helpottamaan alkuun pääsyä. Lue opassivut (?)-painikkeen alta löytääksesi tietoa kaikista raporteista ja taikasanoista joita voit käyttää.',
    'quick_link_default_report'                 => 'Talousraportti',
    'quick_link_audit_report'                   => 'Tapahtumahistorian yleiskatsaus',
    'report_this_month_quick'                   => 'Kuluva kuukausi, kaikki tilit',
    'report_last_month_quick'                   => 'Viime kuu, kaikki tilit',
    'report_this_year_quick'                    => 'Kuluva vuosi, kaikki tilit',
    'report_this_fiscal_year_quick'             => 'Kuluva tilivuosi, kaikki tilit',
    'report_all_time_quick'                     => 'Kaikki tiedot, kaikki tilit',
    'reports_can_bookmark'                      => 'Muista: pystyt tekemään kirjanmerkin raporttiin.',
    'incomeVsExpenses'                          => 'Tulot ja menot',
    'accountBalances'                           => 'Tilien saldot',
    'balanceStart'                              => 'Saldo jakson alussa',
    'balanceEnd'                                => 'Saldo jakson lopussa',
    'splitByAccount'                            => 'Tileittäin',
    'coveredWithTags'                           => 'Tägitetty',
    'leftInBudget'                              => 'Budjetissa jäljellä',
    'left_in_debt'                              => 'Maksettavaa',
    'sumOfSums'                                 => 'Summat yhteensä',
    'noCategory'                                => '(ei kategoriaa)',
    'notCharged'                                => 'Ei veloitettu (vielä)',
    'inactive'                                  => 'Ei aktiivinen',
    'active'                                    => 'Aktiivinen',
    'difference'                                => 'Ero',
    'money_flowing_in'                          => 'Sisään',
    'money_flowing_out'                         => 'Ulos',
    'topX'                                      => 'ensimmäiset :number',
    'show_full_list'                            => 'Näytä koko lista',
    'show_only_top'                             => 'Näytä vain ensimmäiset :number',
    'report_type'                               => 'Raportin tyyppi',
    'report_type_default'                       => 'Talousraportti',
    'report_type_audit'                         => 'Tapahtumahistorian yleisnäkymä (tilintarkastus)',
    'report_type_category'                      => 'Kategoriaraportti',
    'report_type_budget'                        => 'Budjettiraportti',
    'report_type_tag'                           => 'Tägiraportti',
    'report_type_double'                        => 'Kulutus- ja tuottotilien raportti',
    'more_info_help'                            => 'Lisätietoja tämän tyyppisistä raporteista löydät opastesivuilta. Valitse (?) ikoni oikeassa yläkulmassa.',
    'report_included_accounts'                  => 'Sisältää tilit',
    'report_date_range'                         => 'Aikaväli',
    'report_preset_ranges'                      => 'Esiasetetut jaksot',
    'shared'                                    => 'Yhteiset',
    'fiscal_year'                               => 'Tilikausi',
    'income_entry'                              => 'Tulot tililtä ":name" välillä :start ja :end',
    'expense_entry'                             => 'Kulut tilillä ":name" välillä :start ja :end',
    'category_entry'                            => 'Kulut ja ansiot kategoriassa ":name" välillä :start ja :end',
    'budget_spent_amount'                       => 'Kulut budjetissa ":budget" välillä :start ja :end',
    'balance_amount'                            => 'Kulut budjetissa ":budget" tililtä ":account" välillä :start ja :end',
    'no_audit_activity'                         => 'Tilillä <a href=":url" title=":account_name">:account_name</a> ei ole kirjattuja tapahtumia välillä :start ja :end.',
    'audit_end_balance'                         => 'Tilin <a href=":url" title=":account_name">:account_name</a> saldo jakson :end lopussa: :balance',
    'reports_extra_options'                     => 'Lisävalinnat',
    'report_has_no_extra_options'               => 'Tällä raportilla ei ole lisävalintoja',
    'reports_submit'                            => 'Näytä raportti',
    'end_after_start_date'                      => 'Raportin aloituspäivän täytyy olla ennen loppupäivää.',
    'select_category'                           => 'Valitse kategoria(t)',
    'select_budget'                             => 'Valitse budjetti/budjetit.',
    'select_tag'                                => 'Valitse tägi(t).',
    'income_per_category'                       => 'Tulot kategorioittain',
    'expense_per_category'                      => 'Kulut kategorioittain',
    'expense_per_budget'                        => 'Kulut budjeteittain',
    'income_per_account'                        => 'Tulot tileittäin',
    'expense_per_account'                       => 'Menot tileittäin',
    'expense_per_tag'                           => 'Kulut tägeittäin',
    'income_per_tag'                            => 'Tulot tägeittäin',
    'include_expense_not_in_budget'             => 'Sisällytetyt kulut eivät kuulu valittuihin budjetteihin',
    'include_expense_not_in_account'            => 'Sisällytetyt kulut eivät kuulu valittuihin tileihin',
    'include_expense_not_in_category'           => 'Sisällytetyt kulut eivät kuulu valittuihin kategorioihin',
    'include_income_not_in_category'            => 'Sisällytetyt tulot eivät kuulu valittuihin kategorioihin',
    'include_income_not_in_account'             => 'Sisällytetyt tulot eivät kuulu valittuihin tileihin',
    'include_income_not_in_tags'                => 'Sisällytetyt tulot eivät kuulu valittuihin tägeihin',
    'include_expense_not_in_tags'               => 'Sisällytetyt kulut eivät kuulu valittuihin tägeihin',
    'everything_else'                           => 'Kaikki muu',
    'income_and_expenses'                       => 'Tulot ja menot',
    'spent_average'                             => 'Kulutettu (keskiarvo)',
    'income_average'                            => 'Tulot (keskiarvo)',
    'transaction_count'                         => 'Tapahtumien lukumäärä',
    'average_spending_per_account'              => 'Keskimääräinen meno tileittäin',
    'average_income_per_account'                => 'Keskimääräinen tulo tileittäin',
    'total'                                     => 'Yhteensä',
    'description'                               => 'Kuvaus',
    'sum_of_period'                             => 'Jakson loppusumma',
    'average_in_period'                         => 'Keskiarvo tässä jaksossa',
    'no_account_role'                           => '(no role)',
    'account_role_defaultAsset'                 => 'Oletuskäyttötili',
    'account_role_sharedAsset'                  => 'Jaettu käyttötili',
    'account_role_savingAsset'                  => 'Säästötili',
    'account_role_ccAsset'                      => 'Luottokortti',
    'account_role_cashWalletAsset'              => 'Käteinen',
    'budget_chart_click'                        => 'Valitse yllä olevasta taulukosta budjetin nimi nähdäksesi tämän kuvaajan.',
    'category_chart_click'                      => 'Valitse yllä olevasta taulukosta kategorian nimi nähdäksesi tämän kuvaajan.',
    'in_out_accounts'                           => 'Tulot ja menot kombinaatioittain',
    'in_out_accounts_per_asset'                 => 'Tulot ja menot (käyttötileittäin)',
    'in_out_per_category'                       => 'Tulot ja menot kategorioittain',
    'out_per_budget'                            => 'Kulut budjeteittain',
    'select_expense_revenue'                    => 'Valitse kulutus- tai tuottotili',
    'multi_currency_report_sum'                 => 'Koska tämä listä sisältää tilejä useammalla valuutalla, summat eivät välttämättä pidä paikkaansa. Raportti käyttää aina oletusvaluuttaasi.',
    'sum_in_default_currency'                   => 'Summa on aina oletusvaluutassasi.',
    'net_filtered_prefs'                        => 'Tässä kuvaajassa ei koskaan ole tilejä joissa on "Sisällytä varallisuuteen"-optio valitsematta.',


    // charts:
    'chart'                                     => 'Kuvaaja',
    'month'                                     => 'Kuukausi',
    'budget'                                    => 'Budjetti',
    'spent'                                     => 'Käytetty',
    'spent_capped'                              => 'Käytetty (rajattu)',
    'spent_in_budget'                           => 'Budjetista käytetty',
    'left_to_spend'                             => 'Käytettävissä',
    'earned'                                    => 'Ansaittu',
    'overspent'                                 => 'Varojen ylitys',
    'left'                                      => 'Jäljellä',
    'max-amount'                                => 'Enimmäissumma',
    'min-amount'                                => 'Vähimmäissumma',
    'journal-amount'                            => 'Current subscription entry',
    'name'                                      => 'Nimi',
    'expires_at'                                => 'Expires at',
    'date'                                      => 'Päivämäärä',
    'date_and_time'                             => 'Päivämäärä ja aika',
    'time'                                      => 'Aika',
    'paid'                                      => 'Maksettu',
    'unpaid'                                    => 'Maksamatta',
    'day'                                       => 'Päivä',
    'budgeted'                                  => 'Budjetoitu',
    'period'                                    => 'Jakso',
    'balance'                                   => 'Saldo',
    'in_out_period'                             => 'In + out this period',
    'sum'                                       => 'Yhteensä',
    'summary'                                   => 'Yhteenveto',
    'average'                                   => 'Keskiarvo',
    'balanceFor'                                => 'Tilin :name saldo',
    'no_tags'                                   => '(ei tägejä)',
    'nothing_found'                             => '(nothing found)',

    // page settings and wizard dialogs

    'page_settings_header'          => 'Page settings',
    'visible_columns'               => 'Visible columns',
    'accounts_to_show'              => 'Accounts to show',
    'active_accounts_only'          => 'Active accounts only',
    'in_active_accounts_only'       => 'Inactive accounts only',
    'show_all_accounts'             => 'Show all accounts',
    'group_accounts'                => 'Group accounts',

    // piggy banks:
    'event_history'                 => 'Event history',
    'add_money_to_piggy'            => 'Lisää rahaa säästöpossuun ":name"',
    'piggy_bank'                    => 'Säästöpossu',
    'new_piggy_bank'                => 'Uusi säästöpossu',
    'store_piggy_bank'              => 'Tallenna uusi säästöpossu',
    'stored_piggy_bank'             => 'Tallenna uusi säästöpossu ":name"',
    'account_status'                => 'Tilin tilanne',
    'left_for_piggy_banks'          => 'Jäljellä säästöpossuihin',
    'sum_of_piggy_banks'            => 'Säästöpossut yhteensä',
    'saved_so_far'                  => 'Tähän mennessä säästetty',
    'saved_so_far_total'            => 'Saved so far in total',
    'reset_history'                 => 'reset history',
    'reset_history_confirm'         => 'Are you sure you want to reset the history of this piggy bank? This will make the chart match the piggy bank\'s amount again.',
    'piggy_history_reset'           => 'The piggy bank history has been reset',
    'left_to_save'                  => 'Säästettävää jäljellä',
    'suggested_amount'              => 'Ehdotettu kuukausittainen säästösumma',
    'add_money_to_piggy_title'      => 'Lisää rahaa säästöpossuun ":name"',
    'remove_money_from_piggy_title' => 'Poista rahaa säästöpossusta ":name"',
    'add'                           => 'Lisää',
    'no_money_for_piggy'            => 'Sinulla ei ole rahaa pistää tähän säästöpossuun.',
    'suggested_savings_per_month'   => 'Ehdotus per kuukausi',

    'remove'                    => 'Poista',
    'max_amount_add'            => 'Maksimisumma jonka voit lisätä',
    'max_amount_remove'         => 'Maksimisumma jonka voit poistaa',
    'update_piggy_button'       => 'Päivitä säästöpossu',
    'update_piggy_title'        => 'Päivitä säästöpossu ":name"',
    'updated_piggy_bank'        => 'Päivitettiin säästöpossu ":name"',
    'details'                   => 'Yksityiskohdat',
    'events'                    => 'Tapahtumat',
    'target_amount'             => 'Tavoitesumma',
    'start_date'                => 'Aloituspäivä',
    'no_start_date'             => 'Ei aloituspäivää',
    'target_date'               => 'Tavoitepäivä',
    'no_target_date'            => 'Ei tavoitepäivää',
    'table'                     => 'Taulukko',
    'delete_piggy_bank'         => 'Poista säästöpossu ":name"',
    'cannot_add_amount_piggy'   => 'Summan :amount lisääminen possuun ":name" epäonnistui.',
    'cannot_remove_from_piggy'  => 'Summan :amount poistaminen possusta ":name" epäonnistui.',
    'deleted_piggy_bank'        => 'Poistettiin säästöpossu ":name"',
    'added_amount_to_piggy'     => 'Lisättiin :amount possuun ":name"',
    'removed_amount_from_piggy' => 'Poistettiin :amount possusta ":name"',
    'piggy_events'              => 'Tähän liittyvät säästöporsaat',

    // tags
    'delete_tag'                => 'Poista tägi ":tag"',
    'deleted_tag'               => 'Poistettiin tägi ":tag"',
    'new_tag'                   => 'Luo uusi tägi',
    'edit_tag'                  => 'Muokkaa tägiä ":tag"',
    'updated_tag'               => 'Päivitettiin tägi ":tag"',
    'created_tag'               => 'Luotiin ":tag"-tägi!',

    'transaction_journal_information'               => 'Tapahtumatiedot',
    'transaction_journal_amount'                    => 'Amount information',
    'transaction_journal_meta'                      => 'Metatiedot',
    'transaction_journal_more'                      => 'Lisätietoja',
    'basic_journal_information'                     => 'Tapahtuman perustiedot',
    'transaction_journal_extra'                     => 'Lisätiedot',
    'att_part_of_journal'                           => 'Tallennettu tietueeseen ":journal"',
    'total_amount'                                  => 'Kokonaissumma',
    'number_of_decimals'                            => 'Desimaalien määrä',


    // administration
    'invite_is_already_redeemed'                    => 'The invite to ":address" has already been redeemed.',
    'invite_is_deleted'                             => 'The invite to ":address" has been deleted.',
    'invite_new_user_title'                         => 'Invite new user',
    'invite_new_user_text'                          => 'As an administrator, you can invite users to register to your Firefly III installation. Using the direct link you can share with them, they will be able to register an account. The invited user and their invite link will appear in the table below. You are free to share the invitation link with them.',
    'invited_user_mail'                             => 'Email address',
    'invite_user'                                   => 'Invite user',
    'user_is_invited'                               => 'Email address ":address" was invited to Firefly III',
    'administration'                                => 'Ylläpito',
    'system_settings'                               => 'System settings',
    'code_already_used'                             => 'Invite code has been used',
    'user_administration'                           => 'Käyttäjähallinta',
    'list_all_users'                                => 'Kaikki käyttäjät',
    'all_users'                                     => 'Kaikki käyttäjät',
    'instance_configuration'                        => 'Asetukset',
    'firefly_instance_configuration'                => 'Firefly III configuration',
    'setting_single_user_mode'                      => 'Yhden käyttäjän tila',
    'setting_single_user_mode_explain'              => 'Normaalisti Firefly III hyväksyy vain yhden käyttäjän rekisteröitymisen - Sinut. Tämä on tehty turvallisuutesi takia, estämään muita käyttämästä ohjelmaa ilman sinun lupaasi. Seuraavat rekisteröitymiset on estetty. Jos poistat valinnan tästä valintaruudusta, muut pystyvät myös kirjautumaan. Verkon yli kirjautuminen vaatii, että ohjelman internet-yhteysasetukset ovat myös oikein määritelty.',
    'store_configuration'                           => 'Tallenna asetukset',
    'single_user_administration'                    => 'Käyttäjän :email ylläpito',
    'edit_user'                                     => 'Muokkaa käyttäjää :email',
    'hidden_fields_preferences'                     => 'Voit ottaa käyttöön lisää tapahtumavalintoja <a href="preferences">asetuksissa</a>.',
    'user_data_information'                         => 'Käyttäjätiedot',
    'user_information'                              => 'Käyttäjätiedot',
    'total_size'                                    => 'koko yhteensä',
    'budget_or_budgets'                             => ':count budjetti|:count budjettia',
    'budgets_with_limits'                           => ':count budjetti määritetyllä summalla|:count budjettia määritetyllä summalla',
    'nr_of_rules_in_total_groups'                   => ':count_rules sääntöä :count_groups sääntöryhmässä',
    'tag_or_tags'                                   => ':count tagi|:count tagia',
    'configuration_updated'                         => 'Asetukset on päivitetty',
    'setting_is_demo_site'                          => 'Esittelytila',
    'setting_is_demo_site_explain'                  => 'Tämä valintaruutu aktivoi esittelytilan - valinnalla saattaa olla outoja sivuvaikutuksia.',
    'block_code_bounced'                            => 'Sähköpostiviesti palautui',
    'block_code_expired'                            => 'Demokäyttäjän tili on vanhentunut',
    'no_block_code'                                 => 'Ei syytä estoon tai käyttäjää ei ole estetty',
    'demo_user_export'                              => 'The demo user cannot export data',
    'block_code_email_changed'                      => 'Käyttäjä ei ole vielä vahvistanut uutta sähköpostiosoitetta',
    'admin_update_email'                            => 'Profiilisivun tiedoista poiketen käyttäjää ei informoida sähköpostiosoitteen muutoksesta!',
    'update_user'                                   => 'Päivitä käyttäjä',
    'updated_user'                                  => 'Käyttäjän tiedot on muutettu.',
    'delete_user'                                   => 'Poista käyttäjätili ":email"',
    'user_deleted'                                  => 'Käyttäjä on poistettu',
    'send_test_email'                               => 'Testaa sähköpostin lähetystä',
    'send_test_email_text'                          => 'To see if your installation is capable of sending a notification, please press this button. You will not see an error here (if any), <strong>the log files will reflect any errors</strong>. You can press this button as many times as you like. There is no spam control. The message will be sent to <code>:email</code> and should arrive shortly.',
    'send_message'                                  => 'Lähetä viesti',
    'send_test_triggered'                           => 'Testiviesti lähetettiin. Tarkista sähköpostisi sekä lokitiedostot.',
    'give_admin_careful'                            => 'Käyttäjät, joille on annettu järjestelmänvalvojan oikeudet, voivat poistaa oikeudet sinulta. Ole varovainen.',
    'admin_maintanance_title'                       => 'Huolto',
    'admin_maintanance_expl'                        => 'Joitakin käteviä nappeja Firefly III -huoltoon',
    'admin_maintenance_clear_cache'                 => 'Tyhjennä välimuisti',
    'owner_notifications'                           => 'Admin notifications',
    'owner_notifications_expl'                      => 'The following notifications can be enabled or disabled by the administrator. It will be sent over ALL configured channels. Some channels are configured in your environment variables, others can be set here.',
    'channel_settings'                              => 'Settings for notification channels',
    'notification_test_failed'                      => 'Notification test for channel ":channel" failed. The logs will have more details.',
    'notification_test_executed'                    => 'Notification test for channel ":channel" executed. Check your logs for details.',
    'settings_notifications'                        => 'Settings for notifications',
    'title_owner_notifications'                     => 'Owner notifications',
    'owner_notification_check_user_new_reg'         => 'User gets post-registration welcome message',
    'owner_notification_check_admin_new_reg'        => 'Administrator(s) get new user registration notification',
    'owner_notification_check_new_version'          => 'A new version is available',
    'owner_notification_check_invite_created'       => 'A user is invited to Firefly III',
    'owner_notification_check_invite_redeemed'      => 'A user invitation is redeemed',
    'owner_notification_check_unknown_user_attempt' => 'An unknown user tries to login',
    'all_invited_users'                             => 'All invited users',
    'save_notification_settings'                    => 'Save settings',
    'notification_settings'                         => 'Settings for notifications',
    'notification_settings_saved'                   => 'The notification settings have been saved',
    'available_channels_title'                      => 'Available channels',
    'available_channels_expl'                       => 'These channels are available to send notifications over. To test your configuration, use the buttons below. Please note that the buttons have no spam control.',
    'notification_channel_name_email'               => 'Email',
    'slack_discord_double'                          => 'The Slack notification channel can also send notifications to Discord.',
    'notification_channel_name_slack'               => 'Slack',
    'notification_channel_name_ntfy'                => 'Ntfy.sh',
    'notification_channel_name_pushover'            => 'Pushover',
    'notification_channel_name_gotify'              => 'Gotify',
    'notification_channel_name_pushbullet'          => 'Pushbullet',
    'channel_not_available'                         => 'not available',
    'configure_channel_in_env'                      => 'needs environment variables',
    'test_notification_channel_name_email'          => 'Test email',
    'test_notification_channel_name_slack'          => 'Test Slack',
    'test_notification_channel_name_ntfy'           => 'Test Ntfy.sh',
    'test_notification_channel_name_pushover'       => 'Test Pushover',
    'test_notification_channel_name_gotify'         => 'Test Gotify',
    'test_notification_channel_name_pushbullet'     => 'Test Pushbullet',

    'split_transaction_title'               => 'Jaetun tapahtuman kuvaus',
    'split_transaction_title_help'          => 'Jos luot jaetun tapahtuman, kokonaisuudelle tarvitaan nimi.',
    'split_title_help'                      => 'Jos luot jaetun tapahtuman, kokonaisuudelle tarvitaan nimi.',
    'you_create_transfer'                   => 'Olet luomassa siirtoa.',
    'you_create_withdrawal'                 => 'Olet luomassa nostoa.',
    'you_create_deposit'                    => 'Olet luomassa talletusta.',

    // links
    'journal_link_configuration'            => 'Tapahtumien linkitysasetukset',
    'create_new_link_type'                  => 'Luo uusi linkkityyppi',
    'store_new_link_type'                   => 'Tallenna uusi linkkityyppi',
    'update_link_type'                      => 'Päivitä linkkityyppi',
    'edit_link_type'                        => 'Muokkaa linkkityyppiä ":name"',
    'updated_link_type'                     => 'Päivitettiin linkkityyppi ":name"',
    'delete_link_type'                      => 'Poista linkkityyppi ":name"',
    'deleted_link_type'                     => 'Poistettiin linkkityyppi ":name"',
    'stored_new_link_type'                  => 'Tallenna uusi linkkityyppi ":name"',
    'cannot_edit_link_type'                 => 'Linkkityyppiä ":name" ei voi muokata',
    'link_type_help_name'                   => 'Ts. "Kopioi"',
    'link_type_help_inward'                 => 'Ts. "kopioi"',
    'link_type_help_outward'                => 'Ts. "on kopioitu"',
    'save_connections_by_moving'            => 'Tallenna linkki näiden tapahtumien välillä siirtämällä ne toiseen linkkityyppiin:',
    'do_not_save_connection'                => '(älä tallenna linkkiä)',
    'link_transaction'                      => 'Linkitä tapahtuma',
    'link_to_other_transaction'             => 'Linkitä tämä tapahtuma toiseen tapahtumaan',
    'select_transaction_to_link'            => 'Select a transaction to link this transaction to. The links are currently unused in Firefly III (apart from being shown), but I plan to change this in the future. Use the search box to select a transaction either by title or by ID. If you want to add custom link types, check out the settings.',
    'this_transaction'                      => 'Tämä tapahtuma',
    'transaction'                           => 'Tapahtuma',
    'comments'                              => 'Kommentit',
    'link_notes'                            => 'Haluatko tallentaa linkille muistiinpanoja.',
    'invalid_link_selection'                => 'Näitä tapahtumia ei voi linkittää',
    'selected_transaction'                  => 'Valittu tapahtuma',
    'journals_linked'                       => 'Tapahtumat on linkitetty.',
    'journals_error_linked'                 => 'Tapahtumilla on jo linkki.',
    'journals_link_to_self'                 => 'Et voi linkittää tapahtumaa itseensä',
    'journal_links'                         => 'Tapahtuman linkit',
    'this_withdrawal'                       => 'Tämä nosto',
    'this_deposit'                          => 'Tämä talletus',
    'this_transfer'                         => 'Tämä siirto',
    'overview_for_link'                     => 'Yleisnäkymä linkkityypille ":name"',
    'source_transaction'                    => 'Lähdetapahtuma',
    'link_description'                      => 'Linkin kuvaus',
    'destination_transaction'               => 'Kohdetapahtuma',
    'delete_journal_link'                   => 'Poista tapahtumien <a href=":source_link">:source</a> ja <a href=":destination_link">:destination</a> linkki',
    'deleted_link'                          => 'Linkki poistettiin',

    // link translations:
    'Paid_name'                             => 'Maksettu',
    'Refund_name'                           => 'Hyvitys',
    'Reimbursement_name'                    => 'Korvaus',
    'Related_name'                          => 'Liittyvä',
    'relates to_inward'                     => 'liittyy',
    'is (partially) refunded by_inward'     => 'on (osittain) palauttanut',
    'is (partially) paid for by_inward'     => 'on (osittain) maksanut',
    'is (partially) reimbursed by_inward'   => 'on (osittain) korvannut',
    'inward_transaction'                    => 'Tapahtuma sisäänpäin',
    'outward_transaction'                   => 'Tapahtuma ulospäin',
    'relates to_outward'                    => 'liittyy',
    '(partially) refunds_outward'           => '(osittainen) palautus',
    '(partially) pays for_outward'          => '(osittainen) maksu',
    '(partially) reimburses_outward'        => '(osittainen) korvaus',
    'is (partially) refunded by'            => 'on (osittain) palauttanut',
    'is (partially) paid for by'            => 'on (osittain) maksanut',
    'is (partially) reimbursed by'          => 'on (osittain) korvannut',
    'relates to'                            => 'liittyy',
    '(partially) refunds'                   => '(osittainen) palautus',
    '(partially) pays for'                  => '(osittainen) maksu',
    '(partially) reimburses'                => '(osittainen) korvaus',

    // split a transaction:
    'splits'                                => 'Tapahtuman osat',
    'add_another_split'                     => 'Lisää tapahtumaan uusi osa',
    'cannot_edit_opening_balance'           => 'Et voi muokata tilin alkusaldoa.',
    'no_edit_multiple_left'                 => 'Yhtään kelvollista tapahtumaa ei ole valittu.',
    'breadcrumb_convert_group'              => 'Muuta tapahtumaa',
    'convert_invalid_source'                => 'Lähtötilin tiedot eivät kelpaa tapahtumalle #%d.',
    'convert_invalid_destination'           => 'Kohdetilin tiedot eivät kelpaa tapahtumalle #%d.',
    'create_another'                        => 'Tallennuksen jälkeen, palaa takaisin luomaan uusi tapahtuma.',
    'after_update_create_another'           => 'Päivityksen jälkeen, palaa takaisin jatkamaan muokkausta.',
    'store_as_new'                          => 'Tallenna uutena tapahtumana päivityksen sijaan.',
    'reset_after'                           => 'Tyhjennä lomake lähetyksen jälkeen',
    'errors_submission'                     => 'There was something wrong with your submission. Please check out the errors below.',
    'errors_submission_v2'                  => 'There was something wrong with your submission. Please check out the errors below: {{errorMessage}}',
    'transaction_expand_split'              => 'Laajenna jako',
    'transaction_remove_split'              => 'Remove split',
    'transaction_collapse_split'            => 'Yhdistä jako',

    // object groups
    'default_group_title_name'              => '(ryhmittelemättömät)',
    'default_group_title_name_plain'        => 'ungrouped',

    // empty lists? no objects? instructions:
    'no_accounts_title_asset'               => 'Luodaan käyttötili!',
    'no_accounts_intro_asset'               => 'Sinulla ei ole vielä yhtään käyttötiliä. Käyttötilit ovat päätilejäsi: palkkatili, säästötili, pankkikortti, jaetut tilit ja jopa luottokorttisi.',
    'no_accounts_imperative_asset'          => 'Aloittaaksesi käyttämään Firefly III:sta joudut luomaan ainakin yhden käyttötilin. Luodaan se nyt:',
    'no_accounts_create_asset'              => 'Luo käyttötili',
    'no_accounts_title_expense'             => 'Luodaan kulutustili!',
    'no_accounts_intro_expense'             => 'Sinulla ei ole vielä yhtään kulutustiliä. Kulutustilit ovat paikkoja tai henkilöitä joille maksat rahaa, esimerkiksi kaupat ja supermarketit.',
    'no_accounts_imperative_expense'        => 'Käyttötili luodaan tarvittaessa automaattisesti kun luot tapahtumia, mutta voit halutessasi luoda niitä myös tässä. Luodaan yksi nyt:',
    'no_accounts_create_expense'            => 'Luo kulutustili',
    'no_accounts_title_revenue'             => 'Luodaan tuottotili!',
    'no_accounts_intro_revenue'             => 'Sinulla ei ole vielä yhtään tuottotiliä. Tuottotilit ovat tilejä, joille saat rahaa jostain - esimerkiksi palkkana työnantajaltasi.',
    'no_accounts_imperative_revenue'        => 'Tuottotili luodaan tarvittaessa automaattisesti kun luot tapahtumia, mutta voit halutessasi luoda niitä myös tässä. Luodaan yksi nyt:',
    'no_accounts_create_revenue'            => 'Luo tuottotili',
    'no_accounts_title_liabilities'         => 'Luodaan laina!',
    'no_accounts_intro_liabilities'         => 'Sinulla ei ole vielä yhtään lainatilejä. Lainat ovat tilejä joille merkitset lainat ja velat. Esimerkkeinä opinto- tai asuntolaina.',
    'no_accounts_imperative_liabilities'    => 'Tätä ominaisuutta ei tarvitse käyttää, mutta se on käytännöllinen jos sinun täytyy seurata tällaisia asioita.',
    'no_accounts_create_liabilities'        => 'Luo laina',
    'no_budgets_title_default'              => 'Luodaan budjetti',
    'no_rules_title_default'                => 'Luodaan sääntö',
    'no_budgets_intro_default'              => 'Sinulla ei ole vielä yhtään budjettia. Budjetteja käytetään organisoimaan kustannuksiasi loogisiin ryhmiin, joissa voit asettaa arvioita menoillesi.',
    'no_rules_intro_default'                => 'Sinulla ei ole vielä sääntöjä. Säännöt ovat tehokkaita automaatioita, jotka voivat käsitellä tapahtumia sinulle.',
    'no_rules_imperative_default'           => 'Säännöt voivat olla erittäin hyödyllisiä, kun hallinnoit maksutapahtumia. Luodaan sellainen nyt:',
    'no_budgets_imperative_default'         => 'Budjetit ovat rahojen hallinnan perustyökaluja. Luodaan sellainen nyt:',
    'no_budgets_create_default'             => 'Luo budjetti',
    'no_rules_create_default'               => 'Luo sääntö',
    'no_categories_title_default'           => 'Luodaan kategoria!',
    'no_categories_intro_default'           => 'Sinulla ei ole vielä yhtään kategoriaa. Kategorioita käytetään tapahtumien hienosäätämiseen - kategorioimaan niitä.',
    'no_categories_imperative_default'      => 'Kategorioita luodaan tarvittaessa automaattisesti samalla kun luot tapahtumia, mutta voit luoda niitä myös tässä. Luodaanpa sellainen nyt:',
    'no_categories_create_default'          => 'Luo kategoria',
    'no_tags_title_default'                 => 'Luodaan tägi!',
    'no_tags_intro_default'                 => 'Sinulla ei ole vielä yhtään tägiä. Tägejä käytetään hienosäätämään tapahtumiasi ja merkitsemään niitä valituilla avainsanoilla.',
    'no_tags_imperative_default'            => 'Tägit luodaan tarvittaessa automaattisesti kun luot tapahtumia, mutta voit luoda sellaisen tässä. Luotaisiinko yksi tägi nyt:',
    'no_tags_create_default'                => 'Luo tägi',
    'no_transactions_title_withdrawal'      => 'Luodaan kustannus!',
    'no_transactions_intro_withdrawal'      => 'Sinulla ei ole vielä kustannuksia. Talouden hallintaa varten tänne kirjataan kustannukset.',
    'no_transactions_imperative_withdrawal' => 'Oletko kuluttanut rahaa? Se pitää kirjata tänne:',
    'no_transactions_create_withdrawal'     => 'Luo kustannus',
    'no_transactions_title_deposit'         => 'Luodaanpa sitten hieman ansioita!',
    'no_transactions_intro_deposit'         => 'Sinulla ei ole vielä ansioita. Talouden hallintaa varten tänne kirjataan ansiot.',
    'no_transactions_imperative_deposit'    => 'Oletko vastaanottanut rahaa? Se kirjataan tänne:',
    'no_transactions_create_deposit'        => 'Luo talletus',
    'no_transactions_title_transfers'       => 'Luodaan siirto!',
    'no_transactions_intro_transfers'       => 'Sinulla ei ole vielä yhtään siirtoa. Kun siirrät rahaa omaisuustilien välillä, se tallennetaan siirtona.',
    'no_transactions_imperative_transfers'  => 'Oletko siirtänyt rahaa tiliesi välillä, eli tehnyt siirtoja? Ne kirjataan tänne:',
    'no_transactions_create_transfers'      => 'Luo siirto',
    'no_piggies_title_default'              => 'Luodaan säästöpossu!',
    'no_piggies_intro_default'              => 'Sinulla ei ole vielä yhtään säästöpossua. Voit luoda säästöpossuja jaotellaksesi säästöjäsi ja pitääksesi kirjaa asioista joihin olet säästämässä rahaa.',
    'no_piggies_imperative_default'         => 'Säästätkö rahaa johonkin tarkoitukseen? Luo säästöpossu ja seuraa edistymistäsi:',
    'no_piggies_create_default'             => 'Luo uusi säästöpossu',
    'no_bills_title_default'                => 'Let\'s create a subscription!',
    'no_bills_intro_default'                => 'You have no subscriptions yet. You can create subscriptions to keep track of regular expenses, like your rent or insurance.',
    'no_bills_imperative_default'           => 'Do you have such regular subscriptions? Create a subscription and keep track of your payments:',
    'no_bills_create_default'               => 'Create a subscription',

    // recurring transactions
    'recurrence_max_count'                  => 'This recurring transactions will be created at most :max time(s), and has been created :count time(s) already.',
    'create_right_now'                      => 'Create right now',
    'no_new_transaction_in_recurrence'      => 'No new transaction was created. Perhaps it was already fired for this date?',
    'recurrences'                           => 'Toistuvat tapahtumat',
    'repeat_until_in_past'                  => 'Tämä toistuva tapahtuma lakkasi toistumasta :date.',
    'recurring_calendar_view'               => 'Kalenteri',
    'no_recurring_title_default'            => 'Luodaan toistuva tapahtuma!',
    'no_recurring_intro_default'            => 'Sinulla ei ole vielä yhtään toistuvaa tapahtumaa. Niiden avulla Firefly III osaa luoda automaattisesti tapahtumia sinulle.',
    'no_recurring_imperative_default'       => 'Tämä on aika edistynyt toiminto, mutta siitä voi olla paljon hyötyä. Lue käyttöohje (?)-ikonin alta oikeasta ylänurkasta ennen jatkamista.',
    'no_recurring_create_default'           => 'Luo toistuva tapahtuma',
    'make_new_recurring'                    => 'Luo toistuva tapahtuma',
    'recurring_daily'                       => 'Joka päivä',
    'recurring_weekly'                      => 'Joka viikon :weekday',
    'recurring_weekly_skip'                 => ':weekday joka :skip. viikko',
    'recurring_monthly'                     => 'Joka kuun :dayOfMonth. päivä',
    'recurring_monthly_skip'                => 'Joka :skip. kuun :dayOfMonth. päivä',
    'recurring_ndom'                        => 'Joka kuun :dayOfMonth. :weekday',
    'recurring_ndom_skip'                   => 'Every :skip(st/nd/rd/th) month on the :dayOfMonth(st/nd/rd/th) :weekday',
    'recurring_yearly'                      => ':date vuosittain',
    'overview_for_recurrence'               => 'Toistuvan tapahtuman ":title" yleisnäkymä',
    'warning_duplicates_repetitions'        => 'Joissain harvoissa tapauksissa päivämäärät näkyvät kahdesti tällä listalla. Näin saattaa tapahtua kun toistuvissa tapahtumissa tapahtuu törmäyksiä. Firefly III luo vain yhden tapahtuman päivässä.',
    'created_transactions'                  => 'Liittyy tapahtumiin',
    'expected_withdrawals'                  => 'Odotettavissa olevat nostot',
    'expected_deposits'                     => 'Odotettavissa olevat talletukset',
    'expected_transfers'                    => 'Odotettavissa olevat siirrot',
    'created_withdrawals'                   => 'Luodut nostot',
    'created_deposits'                      => 'Luodut talletukset',
    'created_transfers'                     => 'Luodut siirrot',
    'recurring_info'                        => 'Toistuva tapahtuma :count / :total',
    'created_from_recurrence'               => 'Luotu toistuvasta tapahtumasta ":title" (#:id)',
    'recurring_never_cron'                  => '"Cron" ajoitustapahtuma jota käytetään toistuvien tapahtumien suoritukseen ei ole kertaakaan käynnistynyt. Tämä on normaalia kun Firefly III:n asennus on uusi, mutta tämä kannattaisi korjata niin pian kuin suinkin. Lue opastus Cronin määrittämisestä (?)-ikonista sivun oikeasta yläkulmasta.',
    'recurring_cron_long_ago'               => 'Näyttää siltä että toistuvia tapahtumia tukevan "Cron" prosessin edellisestä ajosta on kulunut yli 36 tuntia. Oletko varma että se on määritelty oikein? Lue ohjeet ohjesivuilta, löydät ne tämän sivun oikean yläkulman (?)-ikonin alta.',

    'create_new_recurrence'              => 'Luo uusi toistuva tapahtuma',
    'help_first_date'                    => 'Milloin tapahtuma tapahtuu ensimmäisen kerran? Valitun päivämäärän täytyy olla tulevaisuudessa. Päivän voi korjata myöhemmin.',
    'help_first_date_no_past'            => 'Milloin tapahtuma toistuu ensimmäisen kerran? Firefly III ei luo näitä tapahtumia menneisyyteen.',
    'no_currency'                        => '(ei valuuttaa)',
    'mandatory_for_recurring'            => 'Pakolliset toistuvan tapahtuman tiedot',
    'mandatory_for_transaction'          => 'Pakollinen tapahtuman tieto',
    'optional_for_recurring'             => 'Valinnainen toistuvan tapahtuman tieto',
    'optional_for_transaction'           => 'Valinnainen tapahtuman tieto',
    'change_date_other_options'          => 'Muuta "Aloituspäivämäärä" nähdäksesi lisää valintoja.',
    'mandatory_fields_for_tranaction'    => 'Nämä arvot päätyvät tapahtumiin joita olet luomassa',
    'click_for_calendar'                 => 'Tästä saat avattua kalenterinäytön nähdäksesi tapahtuman toistot.',
    'repeat_forever'                     => 'Toista tästä eteenpäin',
    'repeat_until_date'                  => 'Toisto päättyy päivämäärään',
    'repeat_times'                       => 'Lisää toistojen lukumäärä',
    'recurring_skips_one'                => 'Joka toinen',
    'recurring_skips_more'               => 'Ohitetaan :count tapahtumaa',
    'store_new_recurrence'               => 'Tallenna toistuva tapahtuma',
    'stored_new_recurrence'              => 'Toistuva tapahtuma ":title" tallennettu onnistuneesti.',
    'edit_recurrence'                    => 'Muokkaa toistuvaa tapahtumaa ":title"',
    'recurring_repeats_until'            => 'Toistuu :date asti',
    'recurring_repeats_forever'          => 'Toistuu loputtomiin',
    'recurring_repeats_x_times'          => 'Toistuu :count kerran|Toistuu :count kertaa',
    'update_recurrence'                  => 'Päivitä toistuva tapahtuma',
    'updated_recurrence'                 => 'Päivitettiin toistuva tapahtuma ":title"',
    'recurrence_is_inactive'             => 'Tämä toistuva tapahtuma ei ole aktiivinen, eikä tule luomaan uusi tapahtumia.',
    'delete_recurring'                   => 'Poista toistuva tapahtuma ":title"',
    'new_recurring_transaction'          => 'Uusi toistuva tapahtuma',
    'help_weekend'                       => 'Mitä Firefly III:n pitäisi tehdä kun toistuva tapahtuma osuu Lauantaille tai Sunnuntaille?',
    'do_nothing'                         => 'Luo vain tämä tapahtuma',
    'skip_transaction'                   => 'Ohita tämä tapahtuma',
    'jump_to_friday'                     => 'Luo tapahtuma jo edellisenä Perjantaina',
    'jump_to_monday'                     => 'Luo tapahtuma vasta seuraavana Maanantaina',
    'will_jump_friday'                   => 'Luodaan perjantaina osuttaessa viikonloppuun.',
    'will_jump_monday'                   => 'Siirtyy maanantaille osuttaessa viikonloppuun.',
    'except_weekends'                    => 'Paitsi viikonloppuisin',
    'recurrence_deleted'                 => 'Toistuva tapahtuma ":title" poistettu',


    // new lines for summary controller.
    'box_balance_in_currency'            => 'Saldo (:currency)',
    'box_spent_in_currency'              => 'Kulutettu (:currency)',
    'box_earned_in_currency'             => 'Tienattu (:currency)',
    'box_budgeted_in_currency'           => 'Budjetoitu (:currency)',
    'box_bill_paid_in_currency'          => 'Subscriptions paid (:currency)',
    'box_bill_unpaid_in_currency'        => 'Subscriptions unpaid (:currency)',
    'box_left_to_spend_in_currency'      => 'Kulutettavaa (:currency)',
    'box_net_worth_in_currency'          => 'Varallisuus (:currency)',
    'box_spend_per_day'                  => 'Käytettävissä per päivä: :amount',

    // debug page
    'debug_page'                         => 'Virheenkorjaussivu',
    'debug_submit_instructions'          => 'Jos sinulla on ongelmia, voit käyttää tässä ruudussa olevia tietoja virheenjäljitystietoina. Kopioi ja liitä uuteen tai olemassa olevaan <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub ongelmaan</a>. Se luo kauniin taulukon, jolla voidaan nopeasti diagnosoida ongelmia.',
    'debug_pretty_table'                 => 'Jos kopioit/liität alla olevan ruudun GitHub-tikettiin, se luo taulukon. Älä lisää tähän tekstiin lainausmerkkejä.',
    'debug_additional_data'              => 'Voit myös jakaa alla olevan laatikon sisällön. Voit myös kopioida ja liittää tämän uuteen tai olemassa olevaan <a href="https://github.com/firefly-iii/firefly-iii/issues">GitHub tikettiin</a>. Tämän kentän sisältö voi kuitenkin sisältää yksityisiä tietoja, kuten tilien nimiä, tapahtumatietoja tai sähköpostiosoitteita.',

    // object groups
    'object_groups_menu_bar'             => 'Ryhmät',
    'object_groups_page_title'           => 'Ryhmät',
    'object_groups_breadcrumb'           => 'Ryhmät',
    'object_groups_index'                => 'Yleiskatsaus',
    'object_groups'                      => 'Ryhmät',
    'object_groups_empty_explain'        => 'Joitakin asioita Firefly III:ssa voidaan jakaa ryhmiin. Esimerkiksi Säästöpossuilla on kenttä nimeltä "Ryhmä" muokkaa ja luo sivuilla. Kun asetat tälle kentälle arvon, voit muokata ryhmien nimiä ja järjestystä tällä sivulla. Lisätietoja saat tutustumalla ohjeisiin oikean yläkulman (?)-kuvakkeen alla.',
    'object_group_title'                 => 'Otsikko',
    'edit_object_group'                  => 'Muokkaa ryhmää ":title"',
    'delete_object_group'                => 'Poista ryhmä ":title"',
    'update_object_group'                => 'Päivitä ryhmä',
    'updated_object_group'               => 'Ryhmän ":title" päivitys onnistui',
    'deleted_object_group'               => 'Ryhmän ":title" poistaminen onnistui',
    'object_group'                       => 'Ryhmä',

    // other stuff
    'placeholder'                        => '[Placeholder]',

    // audit log entries
    'audit_log_entries'                  => 'Audit log entries',
    'ale_action_log_add'                 => 'Added :amount to piggy bank ":name"',
    'ale_action_log_remove'              => 'Removed :amount from piggy bank ":name"',
    'ale_action_clear_budget'            => 'Removed from budget',
    'ale_action_update_group_title'      => 'Updated transaction group title',
    'ale_action_update_date'             => 'Updated transaction date',
    'ale_action_update_order'            => 'Updated transaction order',
    'ale_action_clear_category'          => 'Removed from category',
    'ale_action_clear_notes'             => 'Removed notes',
    'ale_action_clear_tag'               => 'Cleared tag',
    'ale_action_clear_all_tags'          => 'Cleared all tags',
    'ale_action_set_bill'                => 'Linked to subscription',
    'ale_action_switch_accounts'         => 'Switched source and destination account',
    'ale_action_set_budget'              => 'Set budget',
    'ale_action_set_category'            => 'Set category',
    'ale_action_set_source'              => 'Set source account',
    'ale_action_set_destination'         => 'Set destination account',
    'ale_action_update_transaction_type' => 'Changed transaction type',
    'ale_action_update_notes'            => 'Changed notes',
    'ale_action_update_description'      => 'Changed description',
    'ale_action_add_to_piggy'            => 'Piggy bank',
    'ale_action_remove_from_piggy'       => 'Piggy bank',
    'ale_action_add_tag'                 => 'Added tag',
    'ale_action_update_amount'           => 'Updated amount',

    // dashboard
    'enable_auto_convert'                => 'Enable currency conversion',
    'disable_auto_convert'               => 'Disable currency conversion',
];
