/* malevic@0.20.2 - Aug 10, 2024 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('malevic/dom')) :
    typeof define === 'function' && define.amd ? define(['exports', 'malevic/dom'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory((global.Malevic = global.Malevic || {}, global.Malevic.State = {}), global.Malevic.DOM));
})(this, (function (exports, dom) { 'use strict';

    /******************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise, SuppressedError, Symbol */


    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
            if (ar || !(i in from)) {
                if (!ar) ar = Array.prototype.slice.call(from, 0, i);
                ar[i] = from[i];
            }
        }
        return to.concat(ar || Array.prototype.slice.call(from));
    }

    typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
        var e = new Error(message);
        return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
    };

    var currentUseStateFn = null;
    function useState(initialState) {
        if (!currentUseStateFn) {
            throw new Error('`useState()` should be called inside a component');
        }
        return currentUseStateFn(initialState);
    }
    function withState(type) {
        var Stateful = function (props) {
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var context = dom.getContext();
            var useState = function (initial) {
                if (!context) {
                    return { state: initial, setState: null };
                }
                var store = context.store, refresh = context.refresh;
                store.state = store.state || initial;
                var setState = function (newState) {
                    if (lock) {
                        throw new Error('Setting state during unboxing causes infinite loop');
                    }
                    store.state = __assign(__assign({}, store.state), newState);
                    refresh();
                };
                return {
                    state: store.state,
                    setState: setState,
                };
            };
            var lock = true;
            var prevUseStateFn = currentUseStateFn;
            currentUseStateFn = useState;
            var result;
            try {
                result = type.apply(void 0, __spreadArray([props], children, false));
            }
            finally {
                currentUseStateFn = prevUseStateFn;
                lock = false;
            }
            return result;
        };
        return Stateful;
    }

    exports.useState = useState;
    exports.withState = withState;

}));
