const sessions = require('../sessions.js');

/** Tracks sessions as the main process lifetime. */
class MainProcessSession {
    constructor(_options = {}) {
        this._options = _options;
        this.name = MainProcessSession.id;
    }
    /** @inheritDoc */
    setupOnce() {
        void sessions.startSession(!!this._options.sendOnCreate);
        sessions.endSessionOnExit();
    }
}
/** @inheritDoc */
MainProcessSession.id = 'MainProcessSession';

exports.MainProcessSession = MainProcessSession;
//# sourceMappingURL=main-process-session.js.map
