import { contextBridge, ipcRenderer } from 'electron';

var IPCChannel;
(function (IPCChannel) {
    /** IPC to check main process is listening */
    IPCChannel["RENDERER_START"] = "sentry-electron.renderer-start";
    /** IPC to send a captured event to Sentry. */
    IPCChannel["EVENT"] = "sentry-electron.event";
    /** IPC to pass scope changes to main process. */
    IPCChannel["SCOPE"] = "sentry-electron.scope";
    /** IPC to pass envelopes to the main process. */
    IPCChannel["ENVELOPE"] = "sentry-electron.envelope";
    /** IPC to pass renderer status updates */
    IPCChannel["STATUS"] = "sentry-electron.status";
})(IPCChannel || (IPCChannel = {}));

/**
 * This preload script may be used with sandbox mode enabled which means regular require is not available.
 */
// eslint-disable-next-line no-restricted-globals
if (window.__SENTRY_IPC__) {
    // eslint-disable-next-line no-console
    console.log('Sentry Electron preload has already been run');
}
else {
    const ipcObject = {
        sendRendererStart: () => ipcRenderer.send(IPCChannel.RENDERER_START),
        sendScope: (scopeJson) => ipcRenderer.send(IPCChannel.SCOPE, scopeJson),
        sendEvent: (eventJson) => ipcRenderer.send(IPCChannel.EVENT, eventJson),
        sendEnvelope: (envelope) => ipcRenderer.send(IPCChannel.ENVELOPE, envelope),
        sendStatus: (status) => ipcRenderer.send(IPCChannel.STATUS, status),
    };
    // eslint-disable-next-line no-restricted-globals
    window.__SENTRY_IPC__ = ipcObject;
    // We attempt to use contextBridge if it's available
    if (contextBridge) {
        // This will fail if contextIsolation is not enabled
        try {
            contextBridge.exposeInMainWorld('__SENTRY_IPC__', ipcObject);
        }
        catch (e) {
            //
        }
    }
}
//# sourceMappingURL=index.js.map
