/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Arrays;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.FactoryAnyD;
import org.ojalgo.structure.MatrixView;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.MutateAnyD;
import org.ojalgo.structure.StructureAnyD;
import org.ojalgo.structure.VectorView;
import org.ojalgo.type.context.NumberContext;

public interface AccessAnyD<N extends Comparable<N>>
extends StructureAnyD,
Access1D<N> {
    public static AccessAnyD<Double> asPrimitiveAnyD(final AccessAnyD<?> access) {
        return new AccessAnyD<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long count(int dimension) {
                return access.count(dimension);
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long[] ref) {
                return access.doubleValue(ref);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long[] ref) {
                return access.doubleValue(ref);
            }

            @Override
            public long[] shape() {
                return access.shape();
            }
        };
    }

    public static boolean equals(AccessAnyD<?> accessA, AccessAnyD<?> accessB, NumberContext accuracy) {
        long tmpCount;
        boolean retVal = true;
        int d = 0;
        while ((retVal &= (tmpCount = accessA.count(d)) == accessB.count(d)) && (++d <= 3 || tmpCount > 1L)) {
        }
        return retVal && Access1D.equals(accessA, accessB, accuracy);
    }

    public static String toString(AccessAnyD<?> array) {
        return Arrays.toString(array.shape()) + " " + Access1D.toString(array);
    }

    default public <NN extends Comparable<NN>, R extends MutateAnyD.Receiver<NN>> Collectable<NN, R> asCollectableAnyD() {
        return new Collectable<NN, R>(){

            @Override
            public long count(int dimension) {
                return AccessAnyD.this.count(dimension);
            }

            @Override
            public long[] shape() {
                return AccessAnyD.this.shape();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(AccessAnyD.this);
            }
        };
    }

    @Override
    default public byte byteValue(long index) {
        return this.byteValue(StructureAnyD.reference(index, this.shape()));
    }

    default public byte byteValue(long[] ref) {
        return (byte)this.shortValue(ref);
    }

    @Override
    default public double doubleValue(long index) {
        return this.doubleValue(StructureAnyD.reference(index, this.shape()));
    }

    public double doubleValue(long[] var1);

    @Override
    default public float floatValue(long index) {
        return this.floatValue(StructureAnyD.reference(index, this.shape()));
    }

    default public float floatValue(long[] ref) {
        return (float)this.doubleValue(ref);
    }

    @Override
    default public N get(long index) {
        return this.get(StructureAnyD.reference(index, this.shape()));
    }

    public N get(long[] var1);

    @Override
    default public int intValue(long index) {
        return this.intValue(StructureAnyD.reference(index, this.shape()));
    }

    default public int intValue(long[] ref) {
        return (int)this.longValue(ref);
    }

    @Override
    default public long longValue(long index) {
        return this.longValue(StructureAnyD.reference(index, this.shape()));
    }

    default public long longValue(long[] ref) {
        return Math.round(this.doubleValue(ref));
    }

    default public Iterable<MatrixView<N>> matrices() {
        return new MatrixView(this);
    }

    default public Iterable<VectorView<N>> vectors() {
        return new VectorView(this);
    }

    @Override
    default public short shortValue(long index) {
        return this.shortValue(StructureAnyD.reference(index, this.shape()));
    }

    default public short shortValue(long[] ref) {
        return (short)this.intValue(ref);
    }

    public static interface Visitable<N extends Comparable<N>>
    extends StructureAnyD,
    Access1D.Visitable<N> {
        public void visitOne(long[] var1, VoidFunction<N> var2);

        public void visitSet(int var1, long var2, VoidFunction<N> var4);

        public void visitSet(long[] var1, int var2, VoidFunction<N> var3);
    }

    public static interface Sliceable<N extends Comparable<N>>
    extends StructureAnyD,
    Access1D.Sliceable<N> {
        public Access1D<N> sliceSet(long[] var1, int var2);
    }

    public static interface Collectable<N extends Comparable<N>, R extends MutateAnyD>
    extends StructureAnyD {
        default public <I extends R> I collect(FactoryAnyD<I> factory) {
            MutateAnyD retVal = (MutateAnyD)factory.make(this.shape());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Comparable<N>>
    extends StructureAnyD,
    Access1D.Aggregatable<N> {
        public N aggregateSet(int var1, long var2, Aggregator var4);

        public N aggregateSet(long[] var1, int var2, Aggregator var3);

        default public void reduce(int dimension, Aggregator aggregator, Mutate1D receiver) {
            long count1 = this.count(dimension);
            long count2 = receiver.count();
            long limit = Math.min(count1, count2);
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Comparable<?>)this.aggregateSet(dimension, i, aggregator));
            }
        }
    }
}

