/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.Eigenvalue;
import org.ojalgo.matrix.decomposition.EigenvalueDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.structure.Access2D;

final class GeneralisedEvD<N extends Comparable<N>>
extends EigenvalueDecomposition<N>
implements Eigenvalue.Generalised<N> {
    private final Cholesky<N> myCholesky;
    private final Eigenvalue<N> myEigenvalue;
    private final PhysicalStore.Factory<N, ? extends DecompositionStore<N>> myFactory;
    private transient PhysicalStore<N> myRecovered = null;
    private transient PhysicalStore<N> myReduced = null;
    private final Eigenvalue.Generalisation myType;

    GeneralisedEvD(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory, Cholesky<N> cholesky, Eigenvalue<N> eigenvalue, Eigenvalue.Generalisation type) {
        super(factory);
        this.myFactory = factory;
        this.myCholesky = cholesky;
        this.myEigenvalue = eigenvalue;
        this.myType = type;
    }

    @Override
    public N getDeterminant() {
        return this.myEigenvalue.getDeterminant();
    }

    @Override
    public ComplexNumber getTrace() {
        return this.myEigenvalue.getTrace();
    }

    @Override
    public boolean isHermitian() {
        return this.myEigenvalue.isHermitian();
    }

    @Override
    public boolean isOrdered() {
        return this.myEigenvalue.isOrdered();
    }

    @Override
    public boolean prepare(Access2D.Collectable<N, ? super PhysicalStore<N>> matrixB) {
        return this.myCholesky.decompose(matrixB);
    }

    @Override
    public MatrixStore<N> reconstruct() {
        if (this.myReduced == null) {
            this.myReduced = this.myEigenvalue.reconstruct().copy();
        }
        return this.myReduced;
    }

    @Override
    public void reset() {
        super.reset();
        this.myEigenvalue.reset();
        this.myReduced = null;
        this.myRecovered = null;
    }

    @Override
    protected boolean doDecompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean valuesOnly) {
        this.myReduced = this.myCholesky.isComputed() ? this.reduce(matrix) : (PhysicalStore)matrix.collect(this.myFactory);
        if (valuesOnly) {
            return this.myEigenvalue.computeValuesOnly(this.myReduced);
        }
        return this.myEigenvalue.decompose(this.myReduced);
    }

    @Override
    protected MatrixStore<N> makeD() {
        return this.myEigenvalue.getD();
    }

    @Override
    protected Array1D<ComplexNumber> makeEigenvalues() {
        return this.myEigenvalue.getEigenvalues();
    }

    @Override
    protected MatrixStore<N> makeV() {
        MatrixStore<N> subV = this.myEigenvalue.getV();
        if (this.myCholesky.isComputed()) {
            return this.recover(subV);
        }
        return subV;
    }

    MatrixStore<N> recover(MatrixStore<N> reduced) {
        MatrixStore<N> mtrxL = this.myCholesky.getL();
        switch (this.myType) {
            case BA: {
                if (this.myRecovered == null) {
                    this.myRecovered = this.makeZero(reduced);
                }
                this.myRecovered.fillByMultiplying(mtrxL, reduced);
                return this.myRecovered;
            }
        }
        if (reduced instanceof PhysicalStore) {
            this.myRecovered = (PhysicalStore)reduced;
        } else if (this.myRecovered != null) {
            reduced.supplyTo(this.myRecovered);
        } else {
            this.myRecovered = (PhysicalStore)reduced.collect(this.myFactory);
        }
        this.myRecovered.substituteBackwards(mtrxL, false, true, false);
        return this.myRecovered;
    }

    PhysicalStore<N> reduce(Access2D.Collectable<N, ? super PhysicalStore<N>> original) {
        MatrixStore<N> mtrxL = this.myCholesky.getL();
        switch (this.myType) {
            case A_B: {
                if (this.myRecovered != null) {
                    original.supplyTo(this.myRecovered);
                } else {
                    this.myRecovered = (PhysicalStore)original.collect(this.myFactory);
                }
                this.myRecovered.substituteForwards(mtrxL, false, false, false);
                this.myReduced = this.myRecovered.transpose().copy();
                this.myReduced.substituteForwards(mtrxL, false, false, false);
                return this.myReduced;
            }
        }
        if (this.myReduced != null) {
            original.supplyTo(this.myReduced);
        } else {
            this.myReduced = (PhysicalStore)original.collect(this.myFactory);
        }
        if (this.myRecovered == null) {
            this.myRecovered = this.makeZero(original);
        }
        this.myRecovered.fillByMultiplying(this.myReduced, mtrxL);
        this.myReduced.fillByMultiplying(mtrxL.transpose(), this.myRecovered);
        return this.myReduced;
    }
}

