/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.NormalizingTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.xcontent.ParseField;

public class ASCIIFoldingTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    public static final ParseField PRESERVE_ORIGINAL = new ParseField("preserve_original", new String[0]);
    public static final boolean DEFAULT_PRESERVE_ORIGINAL = false;
    private final boolean preserveOriginal;

    public ASCIIFoldingTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name);
        this.preserveOriginal = settings.getAsBoolean(PRESERVE_ORIGINAL.getPreferredName(), Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ASCIIFoldingFilter(tokenStream, this.preserveOriginal);
    }

    public TokenFilterFactory getSynonymFilter() {
        if (!this.preserveOriginal) {
            return this;
        }
        return new TokenFilterFactory(){

            public String name() {
                return ASCIIFoldingTokenFilterFactory.this.name();
            }

            public TokenStream create(TokenStream tokenStream) {
                return new ASCIIFoldingFilter(tokenStream, false);
            }
        };
    }

    public TokenStream normalize(TokenStream tokenStream) {
        return new ASCIIFoldingFilter(tokenStream, false);
    }
}

