/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.gcs.GcsRepositoryStatsCollector;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageClientSettings;
import org.elasticsearch.repositories.gcs.MeteredStorage;
import org.elasticsearch.repositories.gcs.ShouldRetryDecorator;

public class GoogleCloudStorageService {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageService.class);
    private volatile Map<String, GoogleCloudStorageClientSettings> clientSettings = Collections.emptyMap();
    private final boolean isServerless;
    private volatile Map<String, MeteredStorage> clientCache = Collections.emptyMap();

    public GoogleCloudStorageService() {
        this.isServerless = false;
    }

    public GoogleCloudStorageService(boolean isServerless) {
        this.isServerless = isServerless;
    }

    public boolean isServerless() {
        return this.isServerless;
    }

    public synchronized void refreshAndClearCache(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
        this.clientCache = Collections.emptyMap();
        this.clientSettings = Maps.ofEntries(clientsSettings.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeteredStorage client(String clientName, String repositoryName, GcsRepositoryStatsCollector statsCollector) throws IOException {
        MeteredStorage storage = this.clientCache.get(repositoryName);
        if (storage != null) {
            return storage;
        }
        GoogleCloudStorageService googleCloudStorageService = this;
        synchronized (googleCloudStorageService) {
            MeteredStorage existing = this.clientCache.get(repositoryName);
            if (existing != null) {
                return existing;
            }
            GoogleCloudStorageClientSettings settings = this.clientSettings.get(clientName);
            if (settings == null) {
                throw new IllegalArgumentException("Unknown client name [" + clientName + "]. Existing client configs: " + org.elasticsearch.common.Strings.collectionToDelimitedString(this.clientSettings.keySet(), (String)","));
            }
            logger.debug(() -> Strings.format((String)"creating GCS client with client_name [%s], endpoint [%s]", (Object[])new Object[]{clientName, settings.getHost()}));
            MeteredStorage storage2 = this.createClient(settings, statsCollector);
            this.clientCache = Maps.copyMapWithAddedEntry(this.clientCache, (Object)repositoryName, (Object)storage2);
            return storage2;
        }
    }

    synchronized void closeRepositoryClients(String repositoryName) {
        this.clientCache = this.clientCache.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(repositoryName)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private MeteredStorage createClient(GoogleCloudStorageClientSettings gcsClientSettings, GcsRepositoryStatsCollector statsCollector) throws IOException {
        NetHttpTransport httpTransport;
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        try {
            KeyStore certTrustStore = SecurityUtils.getJavaKeyStore();
            try (InputStream keyStoreStream = GoogleUtils.class.getResourceAsStream("google.jks");){
                SecurityUtils.loadKeyStore((KeyStore)certTrustStore, (InputStream)keyStoreStream, (String)"notasecret");
            }
            builder.trustCertificates(certTrustStore);
            Proxy proxy = gcsClientSettings.getProxy();
            if (proxy != null) {
                builder.setProxy(proxy);
                this.notifyProxyIsSet(proxy);
            }
            httpTransport = builder.build();
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpTransportOptions httpTransportOptions = new HttpTransportOptions(HttpTransportOptions.newBuilder().setConnectTimeout(GoogleCloudStorageService.toTimeout(gcsClientSettings.getConnectTimeout()).intValue()).setReadTimeout(GoogleCloudStorageService.toTimeout(gcsClientSettings.getReadTimeout()).intValue()).setHttpTransportFactory(() -> GoogleCloudStorageService.lambda$createClient$2((HttpTransport)httpTransport))){

            public HttpRequestInitializer getHttpRequestInitializer(ServiceOptions<?, ?> serviceOptions) {
                HttpRequestInitializer requestInitializer = super.getHttpRequestInitializer(serviceOptions);
                return httpRequest -> {
                    if (requestInitializer != null) {
                        requestInitializer.initialize(httpRequest);
                    }
                    httpRequest.setResponseInterceptor(GcsRepositoryStatsCollector.METERING_INTERCEPTOR);
                };
            }
        };
        StorageOptions storageOptions = this.createStorageOptions(gcsClientSettings, httpTransportOptions);
        return new MeteredStorage((Storage)storageOptions.getService(), statsCollector);
    }

    StorageOptions createStorageOptions(GoogleCloudStorageClientSettings gcsClientSettings, HttpTransportOptions httpTransportOptions) {
        StorageOptions.Builder storageOptionsBuilder = (StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setStorageRetryStrategy(this.getRetryStrategy()).setTransportOptions((TransportOptions)httpTransportOptions)).setHeaderProvider(() -> org.elasticsearch.common.Strings.hasLength((String)gcsClientSettings.getApplicationName()) ? Map.of("user-agent", gcsClientSettings.getApplicationName()) : Map.of());
        if (org.elasticsearch.common.Strings.hasLength((String)gcsClientSettings.getHost())) {
            storageOptionsBuilder.setHost(gcsClientSettings.getHost());
        }
        if (org.elasticsearch.common.Strings.hasLength((String)gcsClientSettings.getProjectId())) {
            storageOptionsBuilder.setProjectId(gcsClientSettings.getProjectId());
        } else {
            String defaultProjectId = null;
            try {
                defaultProjectId = ServiceOptions.getDefaultProjectId();
                if (defaultProjectId != null) {
                    storageOptionsBuilder.setProjectId(defaultProjectId);
                }
            }
            catch (Exception e) {
                logger.warn("failed to load default project id", (Throwable)e);
            }
            if (defaultProjectId == null) {
                try {
                    String projectId = GoogleCloudStorageService.getDefaultProjectId(gcsClientSettings.getProxy());
                    if (projectId != null) {
                        storageOptionsBuilder.setProjectId(projectId);
                    }
                }
                catch (Exception e) {
                    logger.warn("failed to load default project id fallback", (Throwable)e);
                }
            }
        }
        if (gcsClientSettings.getCredential() == null) {
            try {
                storageOptionsBuilder.setCredentials((Credentials)GoogleCredentials.getApplicationDefault());
            }
            catch (Exception e) {
                logger.warn("failed to load Application Default Credentials", (Throwable)e);
            }
        } else {
            ServiceAccountCredentials serviceAccountCredentials = gcsClientSettings.getCredential();
            URI tokenServerUri = gcsClientSettings.getTokenUri();
            if (org.elasticsearch.common.Strings.hasLength((String)tokenServerUri.toString())) {
                serviceAccountCredentials = serviceAccountCredentials.toBuilder().setTokenServerUri(tokenServerUri).build();
            }
            storageOptionsBuilder.setCredentials((Credentials)serviceAccountCredentials);
        }
        return storageOptionsBuilder.build();
    }

    protected StorageRetryStrategy getRetryStrategy() {
        return ShouldRetryDecorator.decorate(StorageRetryStrategy.getLegacyStorageRetryStrategy(), (prevThrowable, prevResponse, delegate) -> {
            if (ExceptionsHelper.unwrap((Throwable)prevThrowable, (Class[])new Class[]{UnknownHostException.class}) != null) {
                return true;
            }
            if (ExceptionsHelper.unwrap((Throwable)prevThrowable, (Class[])new Class[]{SocketException.class}) != null) {
                return true;
            }
            return delegate.shouldRetry(prevThrowable, prevResponse);
        });
    }

    @SuppressForbidden(reason="ok to open connection here")
    static String getDefaultProjectId(@Nullable Proxy proxy) throws IOException {
        block12: {
            String metaHost = System.getenv("GCE_METADATA_HOST");
            if (metaHost == null) {
                metaHost = "metadata.google.internal";
            }
            URL url = new URL("http://" + metaHost + "/computeMetadata/v1/project/project-id");
            HttpURLConnection connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("Metadata-Flavor", "Google");
            try (InputStream input = connection.getInputStream();){
                String string;
                if (connection.getResponseCode() != 200) break block12;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                    string = reader.readLine();
                }
                return string;
            }
        }
        return null;
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return -1;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.getMillis());
    }

    void notifyProxyIsSet(Proxy proxy) {
    }

    private static /* synthetic */ HttpTransport lambda$createClient$2(HttpTransport httpTransport) {
        return httpTransport;
    }
}

