/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patternedtext;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextValueProcessor;

public class PatternedTextDocValues
extends BinaryDocValues {
    private final SortedSetDocValues templateDocValues;
    private final SortedSetDocValues argsDocValues;

    PatternedTextDocValues(SortedSetDocValues templateDocValues, SortedSetDocValues argsDocValues) {
        this.templateDocValues = templateDocValues;
        this.argsDocValues = argsDocValues;
    }

    static PatternedTextDocValues from(LeafReader leafReader, String templateFieldName, String argsFieldName) throws IOException {
        SortedSetDocValues templateDocValues = DocValues.getSortedSet((LeafReader)leafReader, (String)templateFieldName);
        if (templateDocValues.getValueCount() == 0L) {
            return null;
        }
        SortedSetDocValues argsDocValues = DocValues.getSortedSet((LeafReader)leafReader, (String)argsFieldName);
        return new PatternedTextDocValues(templateDocValues, argsDocValues);
    }

    private String getNextStringValue() throws IOException {
        assert (this.templateDocValues.docValueCount() == 1);
        String template = this.templateDocValues.lookupOrd(this.templateDocValues.nextOrd()).utf8ToString();
        int argsCount = PatternedTextValueProcessor.countArgs(template);
        if (argsCount > 0) {
            assert (this.argsDocValues.docValueCount() == 1);
            BytesRef mergedArgs = this.argsDocValues.lookupOrd(this.argsDocValues.nextOrd());
            List<String> args = PatternedTextValueProcessor.decodeRemainingArgs(mergedArgs.utf8ToString());
            return PatternedTextValueProcessor.merge(new PatternedTextValueProcessor.Parts(template, args));
        }
        return template;
    }

    public BytesRef binaryValue() throws IOException {
        return new BytesRef((CharSequence)this.getNextStringValue());
    }

    public boolean advanceExact(int i) throws IOException {
        this.argsDocValues.advanceExact(i);
        return this.templateDocValues.advanceExact(i);
    }

    public int docID() {
        return this.templateDocValues.docID();
    }

    public int nextDoc() throws IOException {
        int templateNext = this.templateDocValues.nextDoc();
        int argsAdvance = this.argsDocValues.advance(templateNext);
        assert (argsAdvance >= templateNext);
        return templateNext;
    }

    public int advance(int i) throws IOException {
        int templateAdvance = this.templateDocValues.advance(i);
        int argsAdvance = this.argsDocValues.advance(templateAdvance);
        assert (argsAdvance >= templateAdvance);
        return templateAdvance;
    }

    public long cost() {
        return this.templateDocValues.cost() + this.argsDocValues.cost();
    }
}

