/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.transport.Header;

public class InboundMessage
implements Releasable {
    private final Header header;
    private final ReleasableBytesReference content;
    private final Exception exception;
    private final boolean isPing;
    private Releasable breakerRelease;
    private StreamInput streamInput;
    private boolean closed;
    private static final VarHandle CLOSED;

    public InboundMessage(Header header, ReleasableBytesReference content, Releasable breakerRelease) {
        this.header = header;
        this.content = content;
        this.breakerRelease = breakerRelease;
        this.exception = null;
        this.isPing = false;
    }

    public InboundMessage(Header header, Exception exception) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = exception;
        this.isPing = false;
    }

    public InboundMessage(Header header, boolean isPing) {
        this.header = header;
        this.content = null;
        this.breakerRelease = null;
        this.exception = null;
        this.isPing = isPing;
    }

    public Header getHeader() {
        return this.header;
    }

    public int getContentLength() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length();
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isPing() {
        return this.isPing;
    }

    public boolean isShortCircuit() {
        return this.exception != null;
    }

    public Releasable takeBreakerReleaseControl() {
        Releasable toReturn = this.breakerRelease;
        this.breakerRelease = null;
        return Objects.requireNonNullElse(toReturn, () -> {});
    }

    public StreamInput openOrGetStreamInput() throws IOException {
        assert (!this.isPing && this.content != null);
        assert (!CLOSED.getAcquire(this));
        if (this.streamInput == null) {
            this.streamInput = this.content.streamInput();
            this.streamInput.setTransportVersion(this.header.getVersion());
        }
        return this.streamInput;
    }

    public String toString() {
        return "InboundMessage{" + String.valueOf(this.header) + "}";
    }

    public void close() {
        if (!CLOSED.compareAndSet(this, false, true)) {
            return;
        }
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.streamInput, this.content, this.breakerRelease});
        }
        catch (Exception e) {
            assert (false) : e;
            throw new ElasticsearchException(e);
        }
    }

    static {
        try {
            CLOSED = MethodHandles.lookup().findVarHandle(InboundMessage.class, "closed", Boolean.TYPE);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

