/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;

@ServerlessScope(value=Scope.INTERNAL)
public class RestSnapshotsStatusAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_snapshot/{repository}/{snapshot}/_status"), new RestHandler.Route(RestRequest.Method.GET, "/_snapshot/{repository}/_status"), new RestHandler.Route(RestRequest.Method.GET, "/_snapshot/_status"));
    }

    @Override
    public String getName() {
        return "snapshot_status_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] snapshots = request.paramAsStringArray("snapshot", Strings.EMPTY_ARRAY);
        if (snapshots.length == 1 && "_all".equalsIgnoreCase(snapshots[0])) {
            snapshots = Strings.EMPTY_ARRAY;
        }
        SnapshotsStatusRequest snapshotsStatusRequest = new SnapshotsStatusRequest(RestUtils.getMasterNodeTimeout(request), request.param("repository", "_all"));
        snapshotsStatusRequest.snapshots(snapshots);
        snapshotsStatusRequest.ignoreUnavailable(request.paramAsBoolean("ignore_unavailable", snapshotsStatusRequest.ignoreUnavailable()));
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).admin().cluster().snapshotsStatus(snapshotsStatusRequest, new RestRefCountedChunkedToXContentListener<SnapshotsStatusResponse>((RestChannel)channel));
    }
}

