/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ReservedStateErrorMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateHandlerMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.reservedstate.ReservedStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.reservedstate.service.ErrorState;
import org.elasticsearch.reservedstate.service.ReservedStateChunk;
import org.elasticsearch.reservedstate.service.ReservedStateVersion;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;

public abstract class ReservedStateUpdateTask<T extends ReservedStateHandler<?>>
implements ClusterStateTaskListener {
    private static final Logger logger = LogManager.getLogger(ReservedStateUpdateTask.class);
    private final String namespace;
    private final ReservedStateChunk stateChunk;
    private final ReservedStateVersionCheck versionCheck;
    private final Map<String, T> handlers;
    private final Collection<String> orderedHandlers;
    private final Consumer<ErrorState> errorReporter;
    private final ActionListener<ActionResponse.Empty> listener;

    public ReservedStateUpdateTask(String namespace, ReservedStateChunk stateChunk, ReservedStateVersionCheck versionCheck, Map<String, T> handlers, Collection<String> orderedHandlers, Consumer<ErrorState> errorReporter, ActionListener<ActionResponse.Empty> listener) {
        this.namespace = namespace;
        this.stateChunk = stateChunk;
        this.versionCheck = versionCheck;
        this.handlers = handlers;
        this.orderedHandlers = orderedHandlers;
        this.errorReporter = errorReporter;
        this.listener = listener;
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    ActionListener<ActionResponse.Empty> listener() {
        return this.listener;
    }

    protected abstract Optional<ProjectId> projectId();

    protected abstract TransformState transform(T var1, Object var2, TransformState var3) throws Exception;

    abstract ClusterState execute(ClusterState var1);

    final Tuple<ClusterState, ReservedStateMetadata> execute(ClusterState state, Map<String, ReservedStateMetadata> reservedStateMap) {
        Map<String, Object> reservedState = this.stateChunk.state();
        ReservedStateVersion reservedStateVersion = this.stateChunk.metadata();
        ReservedStateMetadata reservedStateMetadata = reservedStateMap.get(this.namespace);
        if (!ReservedStateUpdateTask.checkMetadataVersion(this.projectId(), this.namespace, reservedStateMetadata, reservedStateVersion, this.versionCheck)) {
            return null;
        }
        ReservedStateMetadata.Builder reservedMetadataBuilder = new ReservedStateMetadata.Builder(this.namespace).version(reservedStateVersion.version());
        ArrayList<String> errors = new ArrayList<String>();
        for (String handlerName : this.orderedHandlers) {
            ReservedStateHandler handler = (ReservedStateHandler)this.handlers.get(handlerName);
            try {
                Set<String> existingKeys = ReservedStateUpdateTask.keysForHandler(reservedStateMetadata, handlerName);
                TransformState transformState = this.transform(handler, reservedState.get(handlerName), new TransformState(state, existingKeys));
                state = transformState.state();
                reservedMetadataBuilder.putHandler(new ReservedStateHandlerMetadata(handlerName, transformState.keys()));
            }
            catch (Exception e) {
                errors.add(Strings.format((String)"Error processing %s state change: %s", (Object[])new Object[]{handler.name(), ExceptionsHelper.stackTrace(e)}));
            }
        }
        this.checkAndThrowOnError(errors, reservedStateVersion, this.versionCheck);
        reservedMetadataBuilder.errorMetadata(null);
        return Tuple.tuple((Object)state, (Object)reservedMetadataBuilder.build());
    }

    private void checkAndThrowOnError(List<String> errors, ReservedStateVersion version, ReservedStateVersionCheck versionCheck) {
        if (!errors.isEmpty()) {
            logger.debug("Error processing state change request for [{}] with the following errors [{}]", (Object)this.namespace, errors);
            ErrorState errorState = new ErrorState(this.projectId(), this.namespace, version.version(), versionCheck, errors, ReservedStateErrorMetadata.ErrorKind.VALIDATION);
            this.errorReporter.accept(errorState);
            throw new IllegalStateException("Error processing state change request for " + this.namespace + ", errors: " + String.valueOf(errorState));
        }
    }

    static Set<String> keysForHandler(ReservedStateMetadata reservedStateMetadata, String handlerName) {
        if (reservedStateMetadata == null || reservedStateMetadata.handlers().get(handlerName) == null) {
            return Collections.emptySet();
        }
        return reservedStateMetadata.handlers().get(handlerName).keys();
    }

    static boolean checkMetadataVersion(Optional<ProjectId> projectId, String namespace, ReservedStateMetadata existingMetadata, ReservedStateVersion reservedStateVersion, ReservedStateVersionCheck versionCheck) {
        if (reservedStateVersion.buildVersion().isFutureVersion()) {
            logger.warn(() -> Strings.format((String)"Reserved %s version [%s] for namespace [%s] is not compatible with this Elasticsearch node", (Object[])new Object[]{projectId.map(p -> "project state [" + String.valueOf(p) + "]").orElse("cluster state"), reservedStateVersion.buildVersion(), namespace}));
            return false;
        }
        Long newVersion = reservedStateVersion.version();
        if (newVersion.equals(ReservedStateMetadata.EMPTY_VERSION)) {
            return true;
        }
        if (newVersion <= 0L) {
            logger.warn(() -> Strings.format((String)"Not updating reserved %s for namespace [%s], because version [%s] is less or equal to 0", (Object[])new Object[]{projectId.map(p -> "project state [" + String.valueOf(p) + "]").orElse("cluster state"), namespace, newVersion}));
            return false;
        }
        if (existingMetadata == null) {
            return true;
        }
        Long currentVersion = existingMetadata.version();
        if (versionCheck.test(currentVersion, newVersion)) {
            return true;
        }
        logger.warn(() -> {
            Object[] objectArray = new Object[5];
            objectArray[0] = projectId.map(p -> "project state [" + String.valueOf(p) + "]").orElse("cluster state");
            objectArray[1] = namespace;
            objectArray[2] = newVersion;
            objectArray[3] = switch (versionCheck) {
                default -> throw new MatchException(null, null);
                case ReservedStateVersionCheck.HIGHER_OR_SAME_VERSION -> "less than";
                case ReservedStateVersionCheck.HIGHER_VERSION_ONLY -> "less than or equal to";
            };
            objectArray[4] = currentVersion;
            return Strings.format((String)"Not updating reserved %s for namespace [%s], because version [%s] is %s the current metadata version [%s]", (Object[])objectArray);
        });
        return false;
    }
}

