/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.ExponentiallyWeightedMovingRate;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.IndexingStatsSettings;
import org.elasticsearch.index.shard.ShardId;

final class InternalIndexingStats
implements IndexingOperationListener {
    private static final Logger logger = LogManager.getLogger(InternalIndexingStats.class);
    private final LongSupplier relativeTimeInNanosSupplier;
    private final StatsHolder totalStats;

    InternalIndexingStats(LongSupplier relativeTimeInNanosSupplier, IndexingStatsSettings settings) {
        this.relativeTimeInNanosSupplier = relativeTimeInNanosSupplier;
        this.totalStats = new StatsHolder(relativeTimeInNanosSupplier.getAsLong(), settings.getRecentWriteLoadHalfLifeForNewShards());
    }

    IndexingStats stats(boolean isThrottled, long currentThrottleInMillis, long indexingTimeBeforeShardStartedInNanos, long indexingLoadBeforeShardStartedInNanos, long timeSinceShardStartedInNanos, long currentTimeInNanos, double recentIndexingLoadAtShardStarted) {
        IndexingStats.Stats total = this.totalStats.stats(isThrottled, currentThrottleInMillis, indexingTimeBeforeShardStartedInNanos, indexingLoadBeforeShardStartedInNanos, timeSinceShardStartedInNanos, currentTimeInNanos, recentIndexingLoadAtShardStarted);
        return new IndexingStats(total);
    }

    long totalIndexingTimeInNanos() {
        return this.totalStats.indexMetric.sum();
    }

    long totalIndexingExecutionTimeInNanos() {
        return this.totalStats.indexMetric.sum() + this.totalStats.writeIndexingBufferTime.sum();
    }

    double recentIndexingLoad(long timeInNanos) {
        return this.totalStats.recentIndexMetric.getRate(timeInNanos);
    }

    @Override
    public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        if (!operation.origin().isRecovery()) {
            this.totalStats.indexCurrent.inc();
        }
        return operation;
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (index.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.indexMetric.inc(took);
                this.totalStats.recentIndexMetric.addIncrement(took, this.relativeTimeInNanosSupplier.getAsLong());
                this.totalStats.indexCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postIndex(shardId, index, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + String.valueOf((Object)result.getResultType()));
            }
        }
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (!index.origin().isRecovery()) {
            this.totalStats.indexCurrent.dec();
            this.totalStats.indexFailed.inc();
            if (ExceptionsHelper.unwrapCause(ex) instanceof VersionConflictEngineException) {
                this.totalStats.indexFailedDueToVersionConflicts.inc();
            }
        }
    }

    @Override
    public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.inc();
        }
        return delete;
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                if (delete.origin().isRecovery()) break;
                long took = result.getTook();
                this.totalStats.deleteMetric.inc(took);
                this.totalStats.deleteCurrent.dec();
                break;
            }
            case FAILURE: {
                this.postDelete(shardId, delete, result.getFailure());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown result type: " + String.valueOf((Object)result.getResultType()));
            }
        }
    }

    @Override
    public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
        if (!delete.origin().isRecovery()) {
            this.totalStats.deleteCurrent.dec();
        }
    }

    void noopUpdate() {
        this.totalStats.noopUpdates.inc();
    }

    void writeIndexingBuffersTime(long took) {
        this.totalStats.writeIndexingBufferTime.add(took);
        this.totalStats.recentIndexMetric.addIncrement(took, this.relativeTimeInNanosSupplier.getAsLong());
    }

    static class StatsHolder {
        private final MeanMetric indexMetric = new MeanMetric();
        private final LongAdder writeIndexingBufferTime = new LongAdder();
        private final ExponentiallyWeightedMovingRate recentIndexMetric;
        private final AtomicReference<Double> peakIndexMetric;
        private final MeanMetric deleteMetric = new MeanMetric();
        private final CounterMetric indexCurrent = new CounterMetric();
        private final CounterMetric indexFailed = new CounterMetric();
        private final CounterMetric indexFailedDueToVersionConflicts = new CounterMetric();
        private final CounterMetric deleteCurrent = new CounterMetric();
        private final CounterMetric noopUpdates = new CounterMetric();

        StatsHolder(long startTimeInNanos, TimeValue recentWriteLoadHalfLife) {
            double lambdaInInverseNanos = Math.log(2.0) / (double)recentWriteLoadHalfLife.nanos();
            logger.debug("Initialized stats for new shard calculating recent indexing load with half-life {} (decay parameter {} ns^-1)", (Object)recentWriteLoadHalfLife, (Object)lambdaInInverseNanos);
            this.recentIndexMetric = new ExponentiallyWeightedMovingRate(lambdaInInverseNanos, startTimeInNanos);
            this.peakIndexMetric = new AtomicReference<Double>(0.0);
        }

        IndexingStats.Stats stats(boolean isThrottled, long currentThrottleMillis, long indexingTimeBeforeShardStartedInNanos, long indexingLoadBeforeShardStartedInNanos, long timeSinceShardStartedInNanos, long currentTimeInNanos, double recentIndexingLoadAtShardStarted) {
            long totalIndexingTimeInNanos = this.indexMetric.sum();
            long totalIndexingTimeSinceShardStartedInNanos = totalIndexingTimeInNanos - indexingTimeBeforeShardStartedInNanos;
            long totalIndexingExecutionTimeInNanos = totalIndexingTimeInNanos + this.writeIndexingBufferTime.sum();
            long totalIndexingExecutionTimeSinceShardStartedInNanos = totalIndexingExecutionTimeInNanos - indexingLoadBeforeShardStartedInNanos;
            double recentIndexingLoadSinceShardStarted = this.recentIndexMetric.calculateRateSince(currentTimeInNanos, this.recentIndexMetric.getRate(currentTimeInNanos), currentTimeInNanos - timeSinceShardStartedInNanos, recentIndexingLoadAtShardStarted);
            double peakIndexingLoad = this.peakIndexMetric.accumulateAndGet(recentIndexingLoadSinceShardStarted, Math::max);
            logger.debug(() -> Strings.format("Generating stats for an index shard with indexing time %s and active time %s giving unweighted write load %g, while the recency-weighted write load is %g using a half-life of %s and the peak write load is %g", TimeValue.timeValueNanos((long)totalIndexingTimeSinceShardStartedInNanos), TimeValue.timeValueNanos((long)timeSinceShardStartedInNanos), 1.0 * (double)totalIndexingTimeSinceShardStartedInNanos / (double)timeSinceShardStartedInNanos, recentIndexingLoadSinceShardStarted, TimeValue.timeValueNanos((long)((long)this.recentIndexMetric.getHalfLife())), peakIndexingLoad));
            return new IndexingStats.Stats(this.indexMetric.count(), TimeUnit.NANOSECONDS.toMillis(totalIndexingTimeInNanos), this.indexCurrent.count(), this.indexFailed.count(), this.indexFailedDueToVersionConflicts.count(), this.deleteMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.deleteMetric.sum()), this.deleteCurrent.count(), this.noopUpdates.count(), isThrottled, TimeUnit.MILLISECONDS.toMillis(currentThrottleMillis), totalIndexingTimeSinceShardStartedInNanos, totalIndexingExecutionTimeSinceShardStartedInNanos, timeSinceShardStartedInNanos, recentIndexingLoadSinceShardStarted, peakIndexingLoad);
        }
    }
}

