/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Objects;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.elasticsearch.common.logging.HeaderWarning;

@Plugin(category="Converter", name="TraceIdConverter")
@ConverterKeys(value={"trace_id"})
public final class TraceIdConverter
extends LogEventPatternConverter {
    public static TraceIdConverter newInstance(String[] options) {
        return new TraceIdConverter();
    }

    public TraceIdConverter() {
        super("trace_id", "trace_id");
    }

    public static String getTraceId() {
        return HeaderWarning.THREAD_CONTEXT.stream().map(t -> t.getHeader("trace.id")).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        String traceId = TraceIdConverter.getTraceId();
        if (traceId != null) {
            toAppendTo.append(traceId);
        }
    }
}

