/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;

public class AwarenessAllocationDecider
extends AllocationDecider {
    public static final String NAME = "awareness";
    public static final Setting<List<String>> CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING = Setting.stringListSetting("cluster.routing.allocation.awareness.attributes", Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final String FORCE_GROUP_SETTING_PREFIX = "cluster.routing.allocation.awareness.force.";
    public static final Setting<Settings> CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING = Setting.groupSetting("cluster.routing.allocation.awareness.force.", AwarenessAllocationDecider::validateForceAwarenessSettings, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile List<String> awarenessAttributes;
    private volatile Map<String, List<String>> forcedAwarenessAttributes;
    private static final Decision YES_NOT_ENABLED = Decision.single(Decision.Type.YES, "awareness", "allocation awareness is not enabled, set cluster setting [" + CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey() + "] to enable it", new Object[0]);
    private static final Decision YES_AUTO_EXPAND_ALL = Decision.single(Decision.Type.YES, "awareness", "allocation awareness is ignored, this index is set to auto-expand to all nodes", new Object[0]);
    private static final Decision YES_ALL_MET = Decision.single(Decision.Type.YES, "awareness", "node meets all awareness attribute requirements", new Object[0]);

    public AwarenessAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.awarenessAttributes = CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING, this::setAwarenessAttributes);
        this.setForcedAwarenessAttributes(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_AWARENESS_FORCE_GROUP_SETTING, this::setForcedAwarenessAttributes);
    }

    private void setForcedAwarenessAttributes(Settings forceSettings) {
        HashMap<String, List<String>> forcedAwarenessAttributes = new HashMap<String, List<String>>();
        Map<String, Settings> forceGroups = forceSettings.getAsGroups();
        for (Map.Entry<String, Settings> entry : forceGroups.entrySet()) {
            List<String> aValues = entry.getValue().getAsList("values");
            if (aValues.size() <= 0) continue;
            forcedAwarenessAttributes.put(entry.getKey(), aValues);
        }
        this.forcedAwarenessAttributes = forcedAwarenessAttributes;
    }

    private void setAwarenessAttributes(List<String> awarenessAttributes) {
        this.awarenessAttributes = awarenessAttributes;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetadata indexMetadata = allocation.metadata().indexMetadata(shardRouting.index());
        return this.underCapacity(indexMetadata, shardRouting, node, allocation, true);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.underCapacity(indexMetadata, shardRouting, node, allocation, false);
    }

    private Decision underCapacity(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, boolean moveToNode) {
        if (this.awarenessAttributes.isEmpty()) {
            return YES_NOT_ENABLED;
        }
        boolean debug = allocation.debugDecision();
        if (indexMetadata.getAutoExpandReplicas().expandToAllNodes()) {
            return YES_AUTO_EXPAND_ALL;
        }
        int shardCount = indexMetadata.getNumberOfReplicas() + 1;
        for (String awarenessAttribute : this.awarenessAttributes) {
            List<String> forcedValues;
            int valueCount;
            int maximumShardsPerAttributeValue;
            if (!node.node().getAttributes().containsKey(awarenessAttribute)) {
                return debug ? AwarenessAllocationDecider.debugNoMissingAttribute(awarenessAttribute, this.awarenessAttributes) : Decision.NO;
            }
            Set<String> actualAttributeValues = allocation.routingNodes().getAttributeValues(awarenessAttribute);
            String targetAttributeValue = node.node().getAttributes().get(awarenessAttribute);
            assert (targetAttributeValue != null) : "attribute [" + awarenessAttribute + "] missing on " + String.valueOf(node.node());
            assert (actualAttributeValues.contains(targetAttributeValue)) : "attribute [" + awarenessAttribute + "] on " + String.valueOf(node.node()) + " is not in " + String.valueOf(actualAttributeValues);
            int shardsForTargetAttributeValue = 0;
            for (ShardRouting assignedShard : allocation.routingNodes().assignedShards(shardRouting.shardId())) {
                RoutingNode assignedNode;
                if (!assignedShard.started() && !assignedShard.initializing() || !targetAttributeValue.equals((assignedNode = allocation.routingNodes().node(assignedShard.currentNodeId())).node().getAttributes().get(awarenessAttribute))) continue;
                ++shardsForTargetAttributeValue;
            }
            if (moveToNode) {
                if (shardRouting.assignedToNode()) {
                    RoutingNode currentNode = allocation.routingNodes().node(shardRouting.relocating() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId());
                    if (!targetAttributeValue.equals(currentNode.node().getAttributes().get(awarenessAttribute))) {
                        ++shardsForTargetAttributeValue;
                    }
                } else {
                    ++shardsForTargetAttributeValue;
                }
            }
            if (shardsForTargetAttributeValue <= (maximumShardsPerAttributeValue = (shardCount + (valueCount = (forcedValues = this.forcedAwarenessAttributes.get(awarenessAttribute)) == null ? actualAttributeValues.size() : Math.toIntExact(Stream.concat(actualAttributeValues.stream(), forcedValues.stream()).distinct().count())) - 1) / valueCount)) continue;
            return debug ? AwarenessAllocationDecider.debugNoTooManyCopies(shardCount, awarenessAttribute, node.node().getAttributes().get(awarenessAttribute), valueCount, actualAttributeValues.stream().sorted().collect(Collectors.toList()), forcedValues == null ? null : forcedValues.stream().sorted().collect(Collectors.toList()), shardsForTargetAttributeValue, maximumShardsPerAttributeValue) : Decision.NO;
        }
        return YES_ALL_MET;
    }

    private static Decision debugNoTooManyCopies(int shardCount, String attributeName, String attributeValue, int numberOfAttributes, List<String> realAttributes, List<String> forcedAttributes, int actualShardCount, int maximumShardCount) {
        return Decision.single(Decision.Type.NO, NAME, "there are [%d] copies of this shard and [%d] values for attribute [%s] (%s from nodes in the cluster and %s) so there may be at most [%d] copies of this shard allocated to nodes with each value, but (including this copy) there would be [%d] copies allocated to nodes with [node.attr.%s: %s]", shardCount, numberOfAttributes, attributeName, realAttributes, forcedAttributes == null ? "no forced awareness" : String.valueOf(forcedAttributes) + " from forced awareness", maximumShardCount, actualShardCount, attributeName, attributeValue);
    }

    private static Decision debugNoMissingAttribute(String awarenessAttribute, List<String> awarenessAttributes) {
        return Decision.single(Decision.Type.NO, NAME, "node does not contain the awareness attribute [%s]; required attributes cluster setting [%s=%s]", awarenessAttribute, CLUSTER_ROUTING_ALLOCATION_AWARENESS_ATTRIBUTE_SETTING.getKey(), Strings.collectionToCommaDelimitedString(awarenessAttributes));
    }

    private static void validateForceAwarenessSettings(Settings forceSettings) {
        Map<String, Settings> settingGroups;
        try {
            settingGroups = forceSettings.getAsGroups();
        }
        catch (SettingsException e) {
            throw new IllegalArgumentException("invalid forced awareness settings with prefix [cluster.routing.allocation.awareness.force.]", e);
        }
        for (Map.Entry<String, Settings> entry : settingGroups.entrySet()) {
            Optional<String> notValues = entry.getValue().keySet().stream().filter(s -> !s.equals("values")).findFirst();
            if (!notValues.isPresent()) continue;
            throw new IllegalArgumentException("invalid forced awareness setting [cluster.routing.allocation.awareness.force." + entry.getKey() + "." + notValues.get() + "]");
        }
    }
}

