/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStatsAndWeightsCalculator;
import org.elasticsearch.telemetry.metric.DoubleWithAttributes;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class DesiredBalanceMetrics {
    public static final String UNASSIGNED_SHARDS_METRIC_NAME = "es.allocator.desired_balance.shards.unassigned.current";
    public static final String TOTAL_SHARDS_METRIC_NAME = "es.allocator.desired_balance.shards.current";
    public static final String UNDESIRED_ALLOCATION_COUNT_METRIC_NAME = "es.allocator.desired_balance.allocations.undesired.current";
    public static final String UNDESIRED_ALLOCATION_RATIO_METRIC_NAME = "es.allocator.desired_balance.allocations.undesired.ratio";
    public static final String DESIRED_BALANCE_NODE_WEIGHT_METRIC_NAME = "es.allocator.desired_balance.allocations.node_weight.current";
    public static final String DESIRED_BALANCE_NODE_SHARD_COUNT_METRIC_NAME = "es.allocator.desired_balance.allocations.node_shard_count.current";
    public static final String DESIRED_BALANCE_NODE_WRITE_LOAD_METRIC_NAME = "es.allocator.desired_balance.allocations.node_write_load.current";
    public static final String DESIRED_BALANCE_NODE_DISK_USAGE_METRIC_NAME = "es.allocator.desired_balance.allocations.node_disk_usage_bytes.current";
    public static final String CURRENT_NODE_WEIGHT_METRIC_NAME = "es.allocator.allocations.node.weight.current";
    public static final String CURRENT_NODE_SHARD_COUNT_METRIC_NAME = "es.allocator.allocations.node.shard_count.current";
    public static final String CURRENT_NODE_WRITE_LOAD_METRIC_NAME = "es.allocator.allocations.node.write_load.current";
    public static final String CURRENT_NODE_DISK_USAGE_METRIC_NAME = "es.allocator.allocations.node.disk_usage_bytes.current";
    public static final String CURRENT_NODE_UNDESIRED_SHARD_COUNT_METRIC_NAME = "es.allocator.allocations.node.undesired_shard_count.current";
    public static final String CURRENT_NODE_FORECASTED_DISK_USAGE_METRIC_NAME = "es.allocator.allocations.node.forecasted_disk_usage_bytes.current";
    public static final AllocationStats EMPTY_ALLOCATION_STATS = new AllocationStats(-1L, -1L, -1L);
    private volatile boolean nodeIsMaster = false;
    private volatile long unassignedShards;
    private volatile long totalAllocations;
    private volatile long undesiredAllocationsExcludingShuttingDownNodes;
    private final AtomicReference<Map<DiscoveryNode, NodeWeightStats>> weightStatsPerNodeRef = new AtomicReference(Map.of());
    private final AtomicReference<Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight>> allocationStatsPerNodeRef = new AtomicReference(Map.of());

    public void updateMetrics(AllocationStats allocationStats, Map<DiscoveryNode, NodeWeightStats> weightStatsPerNode, Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> nodeAllocationStats) {
        assert (allocationStats != null) : "allocation stats cannot be null";
        assert (weightStatsPerNode != null) : "node balance weight stats cannot be null";
        if (allocationStats != EMPTY_ALLOCATION_STATS) {
            this.unassignedShards = allocationStats.unassignedShards;
            this.totalAllocations = allocationStats.totalAllocations;
            this.undesiredAllocationsExcludingShuttingDownNodes = allocationStats.undesiredAllocationsExcludingShuttingDownNodes;
        }
        this.weightStatsPerNodeRef.set(weightStatsPerNode);
        this.allocationStatsPerNodeRef.set(nodeAllocationStats);
    }

    public DesiredBalanceMetrics(MeterRegistry meterRegistry) {
        meterRegistry.registerLongsGauge(UNASSIGNED_SHARDS_METRIC_NAME, "Current number of unassigned shards", "{shard}", this::getUnassignedShardsMetrics);
        meterRegistry.registerLongsGauge(TOTAL_SHARDS_METRIC_NAME, "Total number of shards", "{shard}", this::getTotalAllocationsMetrics);
        meterRegistry.registerLongsGauge(UNDESIRED_ALLOCATION_COUNT_METRIC_NAME, "Total number of shards allocated on undesired nodes excluding shutting down nodes", "{shard}", this::getUndesiredAllocationsExcludingShuttingDownNodesMetrics);
        meterRegistry.registerDoublesGauge(UNDESIRED_ALLOCATION_RATIO_METRIC_NAME, "Ratio of undesired allocations to shard count excluding shutting down nodes", "1", this::getUndesiredAllocationsRatioMetrics);
        meterRegistry.registerDoublesGauge(DESIRED_BALANCE_NODE_WEIGHT_METRIC_NAME, "Weight of nodes in the computed desired balance", "unit", this::getDesiredBalanceNodeWeightMetrics);
        meterRegistry.registerDoublesGauge(DESIRED_BALANCE_NODE_WRITE_LOAD_METRIC_NAME, "Write load of nodes in the computed desired balance", "threads", this::getDesiredBalanceNodeWriteLoadMetrics);
        meterRegistry.registerDoublesGauge(DESIRED_BALANCE_NODE_DISK_USAGE_METRIC_NAME, "Disk usage of nodes in the computed desired balance", "bytes", this::getDesiredBalanceNodeDiskUsageMetrics);
        meterRegistry.registerLongsGauge(DESIRED_BALANCE_NODE_SHARD_COUNT_METRIC_NAME, "Shard count of nodes in the computed desired balance", "unit", this::getDesiredBalanceNodeShardCountMetrics);
        meterRegistry.registerDoublesGauge(CURRENT_NODE_WEIGHT_METRIC_NAME, "The weight of nodes based on the current allocation state", "unit", this::getCurrentNodeWeightMetrics);
        meterRegistry.registerDoublesGauge(CURRENT_NODE_WRITE_LOAD_METRIC_NAME, "The current write load of nodes", "threads", this::getCurrentNodeWriteLoadMetrics);
        meterRegistry.registerLongsGauge(CURRENT_NODE_DISK_USAGE_METRIC_NAME, "The current disk usage of nodes", "bytes", this::getCurrentNodeDiskUsageMetrics);
        meterRegistry.registerLongsGauge(CURRENT_NODE_SHARD_COUNT_METRIC_NAME, "The current shard count of nodes", "unit", this::getCurrentNodeShardCountMetrics);
        meterRegistry.registerLongsGauge(CURRENT_NODE_FORECASTED_DISK_USAGE_METRIC_NAME, "The current forecasted disk usage of nodes", "bytes", this::getCurrentNodeForecastedDiskUsageMetrics);
        meterRegistry.registerLongsGauge(CURRENT_NODE_UNDESIRED_SHARD_COUNT_METRIC_NAME, "The current undesired shard count of nodes", "unit", this::getCurrentNodeUndesiredShardCountMetrics);
    }

    public void setNodeIsMaster(boolean nodeIsMaster) {
        this.nodeIsMaster = nodeIsMaster;
    }

    public long unassignedShards() {
        return this.unassignedShards;
    }

    public long totalAllocations() {
        return this.totalAllocations;
    }

    public long undesiredAllocations() {
        return this.undesiredAllocationsExcludingShuttingDownNodes;
    }

    private List<LongWithAttributes> getUnassignedShardsMetrics() {
        return this.getIfPublishing(this.unassignedShards);
    }

    private List<DoubleWithAttributes> getDesiredBalanceNodeWeightMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeWeightStats> stats = this.weightStatsPerNodeRef.get();
        ArrayList<DoubleWithAttributes> doubles = new ArrayList<DoubleWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            NodeWeightStats stat = stats.get(node);
            doubles.add(new DoubleWithAttributes(stat.nodeWeight(), this.getNodeAttributes(node)));
        }
        return doubles;
    }

    private List<DoubleWithAttributes> getDesiredBalanceNodeWriteLoadMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeWeightStats> stats = this.weightStatsPerNodeRef.get();
        ArrayList<DoubleWithAttributes> doubles = new ArrayList<DoubleWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            doubles.add(new DoubleWithAttributes(stats.get(node).writeLoad(), this.getNodeAttributes(node)));
        }
        return doubles;
    }

    private List<DoubleWithAttributes> getDesiredBalanceNodeDiskUsageMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeWeightStats> stats = this.weightStatsPerNodeRef.get();
        ArrayList<DoubleWithAttributes> doubles = new ArrayList<DoubleWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            doubles.add(new DoubleWithAttributes(stats.get(node).diskUsageInBytes(), this.getNodeAttributes(node)));
        }
        return doubles;
    }

    private List<LongWithAttributes> getDesiredBalanceNodeShardCountMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeWeightStats> stats = this.weightStatsPerNodeRef.get();
        ArrayList<LongWithAttributes> values = new ArrayList<LongWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            values.add(new LongWithAttributes(stats.get(node).shardCount(), this.getNodeAttributes(node)));
        }
        return values;
    }

    private List<LongWithAttributes> getCurrentNodeDiskUsageMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> stats = this.allocationStatsPerNodeRef.get();
        ArrayList<LongWithAttributes> values = new ArrayList<LongWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            values.add(new LongWithAttributes(stats.get(node).currentDiskUsage(), this.getNodeAttributes(node)));
        }
        return values;
    }

    private List<DoubleWithAttributes> getCurrentNodeWriteLoadMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> stats = this.allocationStatsPerNodeRef.get();
        ArrayList<DoubleWithAttributes> doubles = new ArrayList<DoubleWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            doubles.add(new DoubleWithAttributes(stats.get(node).forecastedIngestLoad(), this.getNodeAttributes(node)));
        }
        return doubles;
    }

    private List<LongWithAttributes> getCurrentNodeShardCountMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> stats = this.allocationStatsPerNodeRef.get();
        ArrayList<LongWithAttributes> values = new ArrayList<LongWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            values.add(new LongWithAttributes(stats.get(node).shards(), this.getNodeAttributes(node)));
        }
        return values;
    }

    private List<LongWithAttributes> getCurrentNodeForecastedDiskUsageMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> stats = this.allocationStatsPerNodeRef.get();
        ArrayList<LongWithAttributes> values = new ArrayList<LongWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            values.add(new LongWithAttributes(stats.get(node).forecastedDiskUsage(), this.getNodeAttributes(node)));
        }
        return values;
    }

    private List<LongWithAttributes> getCurrentNodeUndesiredShardCountMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> stats = this.allocationStatsPerNodeRef.get();
        ArrayList<LongWithAttributes> values = new ArrayList<LongWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            values.add(new LongWithAttributes(stats.get(node).undesiredShards(), this.getNodeAttributes(node)));
        }
        return values;
    }

    private List<DoubleWithAttributes> getCurrentNodeWeightMetrics() {
        if (!this.nodeIsMaster) {
            return List.of();
        }
        Map<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> stats = this.allocationStatsPerNodeRef.get();
        ArrayList<DoubleWithAttributes> doubles = new ArrayList<DoubleWithAttributes>(stats.size());
        for (DiscoveryNode node : stats.keySet()) {
            doubles.add(new DoubleWithAttributes(stats.get(node).currentNodeWeight(), this.getNodeAttributes(node)));
        }
        return doubles;
    }

    private Map<String, Object> getNodeAttributes(DiscoveryNode node) {
        return Map.of("node_id", node.getId(), "node_name", node.getName());
    }

    private List<LongWithAttributes> getTotalAllocationsMetrics() {
        return this.getIfPublishing(this.totalAllocations);
    }

    private List<LongWithAttributes> getUndesiredAllocationsExcludingShuttingDownNodesMetrics() {
        return this.getIfPublishing(this.undesiredAllocationsExcludingShuttingDownNodes);
    }

    private List<LongWithAttributes> getIfPublishing(long value) {
        if (this.nodeIsMaster) {
            return List.of(new LongWithAttributes(value));
        }
        return List.of();
    }

    private List<DoubleWithAttributes> getUndesiredAllocationsRatioMetrics() {
        if (this.nodeIsMaster) {
            long total = this.totalAllocations;
            long undesired = this.undesiredAllocationsExcludingShuttingDownNodes;
            return List.of(new DoubleWithAttributes(total != 0L ? (double)undesired / (double)total : 0.0));
        }
        return List.of();
    }

    public void zeroAllMetrics() {
        this.unassignedShards = 0L;
        this.totalAllocations = 0L;
        this.undesiredAllocationsExcludingShuttingDownNodes = 0L;
        this.weightStatsPerNodeRef.set(Map.of());
        this.allocationStatsPerNodeRef.set(Map.of());
    }

    public record AllocationStats(long unassignedShards, long totalAllocations, long undesiredAllocationsExcludingShuttingDownNodes) {
    }

    public record NodeWeightStats(long shardCount, double diskUsageInBytes, double writeLoad, double nodeWeight) {
        public static final NodeWeightStats ZERO = new NodeWeightStats(0L, 0.0, 0.0, 0.0);
    }
}

