/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.env.BuildVersion;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;

public record VersionInformation(BuildVersion buildVersion, Version nodeVersion, IndexVersion minIndexVersion, IndexVersion minReadOnlyIndexVersion, IndexVersion maxIndexVersion) {
    public static final VersionInformation CURRENT = new VersionInformation(BuildVersion.current(), IndexVersions.MINIMUM_COMPATIBLE, IndexVersions.MINIMUM_READONLY_COMPATIBLE, IndexVersion.current());

    public VersionInformation {
        Objects.requireNonNull(buildVersion);
        Objects.requireNonNull(nodeVersion);
        Objects.requireNonNull(minIndexVersion);
        Objects.requireNonNull(minReadOnlyIndexVersion);
        Objects.requireNonNull(maxIndexVersion);
        assert (minReadOnlyIndexVersion.onOrBefore(minIndexVersion)) : String.valueOf(minReadOnlyIndexVersion) + " > " + String.valueOf(minIndexVersion);
    }

    public VersionInformation(BuildVersion version, IndexVersion minIndexVersion, IndexVersion minReadOnlyIndexVersion, IndexVersion maxIndexVersion) {
        this(version, Version.CURRENT, minIndexVersion, minReadOnlyIndexVersion, maxIndexVersion);
        assert (version.equals(BuildVersion.current())) : String.valueOf(version) + " is not " + String.valueOf(BuildVersion.current());
    }

    @Deprecated
    public VersionInformation(Version version, IndexVersion minIndexVersion, IndexVersion maxIndexVersion) {
        this(version, minIndexVersion, minIndexVersion, maxIndexVersion);
    }

    @Deprecated
    public VersionInformation(Version version, IndexVersion minIndexVersion, IndexVersion minReadOnlyIndexVersion, IndexVersion maxIndexVersion) {
        this(BuildVersion.fromVersionId(version.id()), version, minIndexVersion, minReadOnlyIndexVersion, maxIndexVersion);
    }

    @Deprecated
    public static VersionInformation inferVersions(Version nodeVersion) {
        if (nodeVersion == null) {
            return null;
        }
        if (nodeVersion.equals(Version.CURRENT)) {
            return CURRENT;
        }
        if (nodeVersion.before(Version.V_8_11_0)) {
            return new VersionInformation(nodeVersion, IndexVersion.getMinimumCompatibleIndexVersion(nodeVersion.id), IndexVersion.fromId(nodeVersion.id));
        }
        throw new IllegalArgumentException("Node versions can only be inferred before release version 8.10.0");
    }
}

