/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.forcemerge;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportForceMergeAction
extends TransportBroadcastByNodeAction<ForceMergeRequest, BroadcastResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private final IndicesService indicesService;
    private final ThreadPool threadPool;
    private final ProjectResolver projectResolver;

    @Inject
    public TransportForceMergeAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/forcemerge", clusterService, transportService, actionFilters, indexNameExpressionResolver, ForceMergeRequest::new, transportService.getThreadPool().executor("management"));
        this.indicesService = indicesService;
        this.threadPool = transportService.getThreadPool();
        this.projectResolver = projectResolver;
    }

    @Override
    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    @Override
    protected TransportBroadcastByNodeAction.ResponseFactory<BroadcastResponse, TransportBroadcastByNodeAction.EmptyResult> getResponseFactory(ForceMergeRequest request, ClusterState clusterState) {
        return (totalShards, successfulShards, failedShards, responses, shardFailures) -> new BroadcastResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ForceMergeRequest readRequestFrom(StreamInput in) throws IOException {
        return new ForceMergeRequest(in);
    }

    @Override
    protected void shardOperation(ForceMergeRequest request, ShardRouting shardRouting, Task task, ActionListener<TransportBroadcastByNodeAction.EmptyResult> listener) {
        assert (!(task instanceof CancellableTask));
        SubscribableListener.newForked(l -> {
            IndexShard indexShard = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex()).getShard(shardRouting.shardId().id());
            indexShard.ensureMutable(l.map(unused -> indexShard), false);
        }).andThen((l, indexShard) -> this.threadPool.executor("force_merge").execute(ActionRunnable.supply(l, () -> {
            indexShard.forceMerge(request);
            return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
        }))).addListener(listener);
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, ForceMergeRequest request, String[] concreteIndices) {
        return clusterState.routingTable(this.projectResolver.getProjectId()).allShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ForceMergeRequest request) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ForceMergeRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE, concreteIndices);
    }
}

