/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.streams.logs;

import java.util.Locale;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SequentialAckingBatchedTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.StreamsMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.streams.logs.LogsStreamsActivationToggleAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportLogsStreamsToggleActivation
extends AcknowledgedTransportMasterNodeAction<LogsStreamsActivationToggleAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportLogsStreamsToggleActivation.class);
    private final ProjectResolver projectResolver;
    private final MasterServiceTaskQueue<StreamsMetadataUpdateTask> taskQueue;

    @Inject
    public TransportLogsStreamsToggleActivation(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(LogsStreamsActivationToggleAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, LogsStreamsActivationToggleAction.Request::new, (Executor)threadPool.executor("management"));
        this.taskQueue = clusterService.createTaskQueue("streams-update-state-queue", Priority.NORMAL, (ClusterStateTaskExecutor)new SequentialAckingBatchedTaskExecutor());
        this.projectResolver = projectResolver;
    }

    protected void masterOperation(Task task, LogsStreamsActivationToggleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        ProjectId projectId = this.projectResolver.getProjectId();
        StreamsMetadata streamsState = (StreamsMetadata)state.projectState(projectId).metadata().custom("streams", (Metadata.ProjectCustom)StreamsMetadata.EMPTY);
        boolean currentlyEnabled = streamsState.isLogsEnabled();
        boolean shouldEnable = request.shouldEnable();
        if (shouldEnable != currentlyEnabled) {
            StreamsMetadataUpdateTask updateTask = new StreamsMetadataUpdateTask(request, listener, projectId, shouldEnable);
            String taskName = String.format(Locale.ROOT, "enable-streams-logs-[%s]", shouldEnable ? "enable" : "disable");
            this.taskQueue.submitTask(taskName, (ClusterStateTaskListener)updateTask, updateTask.timeout());
        } else {
            logger.debug("Logs streams are already in the requested state: {}", (Object)shouldEnable);
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }
    }

    protected ClusterBlockException checkBlock(LogsStreamsActivationToggleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    static class StreamsMetadataUpdateTask
    extends AckedClusterStateUpdateTask {
        private final ProjectId projectId;
        private final boolean enabled;

        StreamsMetadataUpdateTask(AcknowledgedRequest<?> request, ActionListener<? extends AcknowledgedResponse> listener, ProjectId projectId, boolean enabled) {
            super(request, listener);
            this.projectId = projectId;
            this.enabled = enabled;
        }

        public ClusterState execute(ClusterState currentState) throws Exception {
            return currentState.copyAndUpdateProject(this.projectId, builder -> builder.putCustom("streams", (Metadata.ProjectCustom)new StreamsMetadata(this.enabled)));
        }
    }
}

