/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.tool;

import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.cli.KeyStoreAwareCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.CommandLineHttpClient;
import org.elasticsearch.xpack.core.security.HttpResponse;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.file.FileUserPasswdStore;
import org.elasticsearch.xpack.security.authc.file.FileUserRolesStore;
import org.elasticsearch.xpack.security.support.FileAttributesChecker;
import org.elasticsearch.xpack.security.tool.CommandUtils;

public abstract class BaseRunAsSuperuserCommand
extends KeyStoreAwareCommand {
    private static final String[] ROLES = new String[]{"superuser"};
    private static final int PASSWORD_LENGTH = 14;
    private final OptionSpecBuilder force;
    protected final OptionSpec<String> urlOption;
    private final Function<Environment, CommandLineHttpClient> clientFunction;
    private final CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction;

    public BaseRunAsSuperuserCommand(Function<Environment, CommandLineHttpClient> clientFunction, CheckedFunction<Environment, KeyStoreWrapper, Exception> keyStoreFunction, String description) {
        super(description);
        this.clientFunction = clientFunction;
        this.keyStoreFunction = keyStoreFunction;
        this.force = this.parser.acceptsAll(List.of("f", "force"), "Use this option to force execution of the command against a cluster that is currently unhealthy.");
        this.urlOption = this.parser.accepts("url", "the URL where the elasticsearch node listens for connections.").withRequiredArg();
    }

    public final void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        Environment newEnv;
        Settings settings;
        this.validate(terminal, options, env);
        BaseRunAsSuperuserCommand.ensureFileRealmEnabled(env.settings());
        KeyStoreWrapper keyStoreWrapper = (KeyStoreWrapper)this.keyStoreFunction.apply((Object)env);
        if (keyStoreWrapper != null) {
            BaseRunAsSuperuserCommand.decryptKeyStore((KeyStoreWrapper)keyStoreWrapper, (Terminal)terminal);
            Settings.Builder settingsBuilder = Settings.builder();
            settingsBuilder.put(env.settings(), true);
            if (settingsBuilder.getSecureSettings() == null) {
                settingsBuilder.setSecureSettings((SecureSettings)keyStoreWrapper);
            }
            settings = settingsBuilder.build();
            newEnv = new Environment(settings, env.configDir());
        } else {
            newEnv = env;
            settings = env.settings();
        }
        String username = CommandUtils.generateUsername("autogenerated_", null, 8);
        try (SecureString password = new SecureString(CommandUtils.generatePassword(14));){
            Hasher hasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
            Path passwordFile = FileUserPasswdStore.resolveFile(newEnv);
            Path rolesFile = FileUserRolesStore.resolveFile(newEnv);
            FileAttributesChecker attributesChecker = new FileAttributesChecker(passwordFile, rolesFile);
            Map<String, String[]> userRoles = FileUserRolesStore.parseFile(rolesFile, null);
            if (userRoles == null) {
                throw new IllegalStateException("File realm configuration file [" + String.valueOf(rolesFile) + "] is missing");
            }
            userRoles = new HashMap<String, String[]>(userRoles);
            userRoles.put(username, ROLES);
            FileUserRolesStore.writeFile(userRoles, rolesFile);
            Map<String, char[]> users = FileUserPasswdStore.parseFile(passwordFile, null, settings);
            if (users == null) {
                throw new IllegalStateException("File realm configuration file [" + String.valueOf(passwordFile) + "] is missing");
            }
            users = new HashMap<String, char[]>(users);
            users.put(username, hasher.hash(password));
            FileUserPasswdStore.writeFile(users, passwordFile);
            attributesChecker.check(terminal);
            boolean forceExecution = options.has((OptionSpec)this.force);
            this.checkClusterHealthWithRetries(newEnv, options, terminal, username, password, 5, forceExecution);
            this.executeCommand(terminal, options, newEnv, username, password);
        }
        catch (Exception e) {
            int exitCode = e instanceof UserException ? ((UserException)e).exitCode : 65;
            throw new UserException(exitCode, e.getMessage());
        }
        finally {
            BaseRunAsSuperuserCommand.cleanup(terminal, newEnv, username);
        }
    }

    private static void cleanup(Terminal terminal, Environment env, String username) throws Exception {
        Path passwordFile = FileUserPasswdStore.resolveFile(env);
        Path rolesFile = FileUserRolesStore.resolveFile(env);
        ArrayList<CallSite> errorMessages = new ArrayList<CallSite>();
        FileAttributesChecker attributesChecker = new FileAttributesChecker(passwordFile, rolesFile);
        Map<String, char[]> users = FileUserPasswdStore.parseFile(passwordFile, null, env.settings());
        if (users == null) {
            errorMessages.add((CallSite)((Object)("File realm configuration file [" + String.valueOf(passwordFile) + "] is missing")));
        } else {
            char[] passwd = (users = new HashMap<String, char[]>(users)).remove(username);
            if (passwd != null) {
                FileUserPasswdStore.writeFile(users, passwordFile);
                Arrays.fill(passwd, '\u0000');
            }
        }
        Map<String, String[]> userRoles = FileUserRolesStore.parseFile(rolesFile, null);
        if (userRoles == null) {
            errorMessages.add((CallSite)((Object)("File realm configuration file [" + String.valueOf(rolesFile) + "] is missing")));
        } else {
            String[] roles = (userRoles = new HashMap<String, String[]>(userRoles)).remove(username);
            if (roles != null) {
                FileUserRolesStore.writeFile(userRoles, rolesFile);
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new UserException(78, String.join((CharSequence)" , ", errorMessages));
        }
        attributesChecker.check(terminal);
    }

    private static void ensureFileRealmEnabled(Settings settings) throws Exception {
        Map realms = RealmSettings.getRealmSettings((Settings)settings);
        Map<RealmConfig.RealmIdentifier, Settings> fileRealmSettings = realms.entrySet().stream().filter(e -> ((RealmConfig.RealmIdentifier)e.getKey()).getType().equals("file")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (fileRealmSettings.size() == 1) {
            String fileRealmName = fileRealmSettings.entrySet().iterator().next().getKey().getName();
            if (!((Boolean)((Setting.AffixSetting)RealmSettings.ENABLED_SETTING.apply("file")).getConcreteSettingForNamespace(fileRealmName).get(settings)).booleanValue()) {
                throw new UserException(78, "File realm must be enabled");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkClusterHealthWithRetries(Environment env, OptionSet options, Terminal terminal, String username, SecureString password, int retries, boolean force) throws Exception {
        HttpResponse response;
        CommandLineHttpClient client = this.clientFunction.apply(env);
        URL baseUrl = options.has(this.urlOption) ? new URL((String)options.valueOf(this.urlOption)) : new URL(client.getDefaultURL());
        URL clusterHealthUrl = CommandLineHttpClient.createURL((URL)baseUrl, (String)"_cluster/health", (String)"?pretty");
        try {
            response = client.execute("GET", clusterHealthUrl, username, password, () -> null, CommandLineHttpClient::responseBuilder);
        }
        catch (Exception e) {
            throw new UserException(69, "Failed to determine the health of the cluster.", (Throwable)e);
        }
        int responseStatus = response.getHttpStatus();
        if (responseStatus != 200) {
            if (responseStatus != 401 && responseStatus != 403 || retries <= 0) throw new UserException(65, "Failed to determine the health of the cluster. Unexpected http status [" + responseStatus + "]");
            terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("Unexpected http status [" + responseStatus + "] while attempting to determine cluster health. Will retry at most " + retries + " more times."));
            Thread.sleep(1000L);
            this.checkClusterHealthWithRetries(env, options, terminal, username, password, --retries, force);
            return;
        } else {
            String clusterStatus = Objects.toString(response.getResponseBody().get("status"), "");
            if (clusterStatus.isEmpty()) {
                throw new UserException(65, "Failed to determine the health of the cluster. Cluster health API did not return a status value.");
            }
            if (!"red".equalsIgnoreCase(clusterStatus) || force) return;
            terminal.errorPrintln("Failed to determine the health of the cluster. Cluster health is currently RED.");
            terminal.errorPrintln("This means that some cluster data is unavailable and your cluster is not fully functional.");
            terminal.errorPrintln("The cluster logs (" + String.valueOf(ReferenceDocs.LOGGING) + ") might contain information/indications for the underlying cause");
            terminal.errorPrintln("It is recommended that you resolve the issues with your cluster before continuing");
            terminal.errorPrintln("It is very likely that the command will fail when run against an unhealthy cluster.");
            terminal.errorPrintln("");
            terminal.errorPrintln("If you still want to attempt to execute this command against an unhealthy cluster, you can pass the `-f` parameter.");
            throw new UserException(69, "Failed to determine the health of the cluster. Cluster health is currently RED.");
        }
    }

    protected abstract void executeCommand(Terminal var1, OptionSet var2, Environment var3, String var4, SecureString var5) throws Exception;

    protected abstract void validate(Terminal var1, OptionSet var2, Environment var3) throws Exception;
}

