/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.security.authz.RBACEngine;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

public class DlsFlsLicenseRequestInterceptor
implements RequestInterceptor {
    private static final Logger logger = LogManager.getLogger(DlsFlsLicenseRequestInterceptor.class);
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;

    public DlsFlsLicenseRequestInterceptor(ThreadContext threadContext, XPackLicenseState licenseState) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
    }

    @Override
    public SubscribableListener<Void> intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        Role role;
        if (requestInfo.getRequest() instanceof IndicesRequest && !TransportActionProxy.isProxyAction((String)requestInfo.getAction()) && ((role = RBACEngine.maybeGetRBACEngineRole((AuthorizationEngine.AuthorizationInfo)this.threadContext.getTransient("_authz_info"))) == null || role.hasFieldOrDocumentLevelSecurity())) {
            logger.trace("Role has DLS or FLS. Checking for whether the request touches any indices that have DLS or FLS configured");
            IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
            if (indicesAccessControl != null) {
                XPackLicenseState frozenLicenseState = this.licenseState.copyCurrentLicenseState();
                if (logger.isDebugEnabled()) {
                    IndicesAccessControl.DlsFlsUsage dlsFlsUsage = indicesAccessControl.getFieldAndDocumentLevelSecurityUsage();
                    if (dlsFlsUsage.hasFieldLevelSecurity()) {
                        logger.debug(() -> Strings.format((String)"User [%s] has field level security on [%s]", (Object[])new Object[]{requestInfo.getAuthentication(), indicesAccessControl.getIndicesWithFieldLevelSecurity()}));
                    }
                    if (dlsFlsUsage.hasDocumentLevelSecurity()) {
                        logger.debug(() -> Strings.format((String)"User [%s] has document level security on [%s]", (Object[])new Object[]{requestInfo.getAuthentication(), indicesAccessControl.getIndicesWithDocumentLevelSecurity()}));
                    }
                }
                if (!SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(frozenLicenseState) || !SecurityField.FIELD_LEVEL_SECURITY_FEATURE.checkWithoutTracking(frozenLicenseState)) {
                    boolean incompatibleLicense = false;
                    IndicesAccessControl.DlsFlsUsage dlsFlsUsage = indicesAccessControl.getFieldAndDocumentLevelSecurityUsage();
                    if (dlsFlsUsage.hasDocumentLevelSecurity() && !SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.check(frozenLicenseState)) {
                        incompatibleLicense = true;
                    }
                    if (dlsFlsUsage.hasFieldLevelSecurity() && !SecurityField.FIELD_LEVEL_SECURITY_FEATURE.check(frozenLicenseState)) {
                        incompatibleLicense = true;
                    }
                    if (incompatibleLicense) {
                        ElasticsearchSecurityException licenseException = LicenseUtils.newComplianceException((String)"field and document level security");
                        licenseException.addMetadata("es.indices_with_dls_or_fls", indicesAccessControl.getIndicesWithFieldOrDocumentLevelSecurity());
                        return SubscribableListener.newFailed((Exception)((Object)licenseException));
                    }
                }
            }
        }
        return SubscribableListener.nullSuccess();
    }
}

