/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequestBuilder;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;

public class ReservedRoleMappingAction
implements ReservedProjectStateHandler<List<PutRoleMappingRequest>> {
    public static final String NAME = "role_mappings";

    public String name() {
        return NAME;
    }

    public TransformState transform(ProjectId projectId, List<PutRoleMappingRequest> source, TransformState prevState) throws Exception {
        ProjectMetadata projectMetadata;
        Set<ExpressionRoleMapping> roleMappings = this.validateAndTranslate(source);
        RoleMappingMetadata newRoleMappingMetadata = new RoleMappingMetadata(roleMappings);
        if (newRoleMappingMetadata.equals((Object)RoleMappingMetadata.getFromProject((ProjectMetadata)(projectMetadata = prevState.state().getMetadata().getProject(projectId))))) {
            return prevState;
        }
        ProjectMetadata newProjectMetadata = newRoleMappingMetadata.updateProject(projectMetadata);
        Set entities = newRoleMappingMetadata.getRoleMappings().stream().map(ExpressionRoleMapping::getName).collect(Collectors.toSet());
        return new TransformState(ClusterState.builder((ClusterState)prevState.state()).putProjectMetadata(newProjectMetadata).build(), entities);
    }

    public List<PutRoleMappingRequest> fromXContent(XContentParser parser) throws IOException {
        ArrayList<PutRoleMappingRequest> result = new ArrayList<PutRoleMappingRequest>();
        Map source = parser.map();
        for (String name : source.keySet()) {
            Map content = (Map)source.get(name);
            XContentParser mappingParser = XContentHelper.mapToXContentParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (Map)content);
            try {
                result.add((PutRoleMappingRequest)new PutRoleMappingRequestBuilder(null).source(name, mappingParser).request());
            }
            finally {
                if (mappingParser == null) continue;
                mappingParser.close();
            }
        }
        return result;
    }

    private Set<ExpressionRoleMapping> validateAndTranslate(List<PutRoleMappingRequest> roleMappings) {
        ArrayList<Object> exceptions = new ArrayList<Object>();
        for (PutRoleMappingRequest roleMapping : roleMappings) {
            ActionRequestValidationException exception = roleMapping.validate(false);
            if (exception == null) continue;
            exceptions.add(exception);
        }
        if (!exceptions.isEmpty()) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("error on validating put role mapping requests");
            exceptions.forEach((Consumer<Object>)((Consumer<Exception>)illegalArgumentException::addSuppressed));
            throw illegalArgumentException;
        }
        return roleMappings.stream().map(r -> RoleMappingMetadata.copyWithNameInMetadata((ExpressionRoleMapping)r.getMapping())).collect(Collectors.toUnmodifiableSet());
    }
}

