/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.ingest.geoip.GeoIpDownloader;
import org.elasticsearch.ingest.geoip.GeoIpProcessor;
import org.elasticsearch.ingest.geoip.GeoIpTaskParams;
import org.elasticsearch.ingest.geoip.GeoIpTaskState;
import org.elasticsearch.ingest.geoip.HttpClient;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteTransportException;

public final class GeoIpDownloaderTaskExecutor
extends PersistentTasksExecutor<GeoIpTaskParams>
implements ClusterStateListener {
    private static final boolean ENABLED_DEFAULT = !"false".equals(System.getProperty("ingest.geoip.downloader.enabled.default", "true"));
    public static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting((String)"ingest.geoip.downloader.enabled", (boolean)ENABLED_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.ProjectScope});
    public static final Setting<TimeValue> POLL_INTERVAL_SETTING = Setting.timeSetting((String)"ingest.geoip.downloader.poll.interval", (TimeValue)TimeValue.timeValueDays((long)3L), (TimeValue)TimeValue.timeValueDays((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Boolean> EAGER_DOWNLOAD_SETTING = Setting.boolSetting((String)"ingest.geoip.downloader.eager.download", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(GeoIpDownloader.class);
    private final Client client;
    private final HttpClient httpClient;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final PersistentTasksService persistentTasksService;
    private volatile TimeValue pollInterval;
    private volatile boolean eagerDownload;
    private final ConcurrentHashMap<ProjectId, Boolean> atLeastOneGeoipProcessorByProject = new ConcurrentHashMap();
    private final ConcurrentHashMap<ProjectId, AtomicBoolean> taskIsBootstrappedByProject = new ConcurrentHashMap();
    private final ConcurrentHashMap<ProjectId, GeoIpDownloader> tasks = new ConcurrentHashMap();
    private final ProjectResolver projectResolver;

    GeoIpDownloaderTaskExecutor(Client client, HttpClient httpClient, ClusterService clusterService, ThreadPool threadPool) {
        super("geoip-downloader", (Executor)threadPool.generic());
        this.client = new OriginSettingClient(client, "ingest");
        this.httpClient = httpClient;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = clusterService.getSettings();
        this.persistentTasksService = new PersistentTasksService(clusterService, threadPool, client);
        this.pollInterval = (TimeValue)POLL_INTERVAL_SETTING.get(this.settings);
        this.eagerDownload = (Boolean)EAGER_DOWNLOAD_SETTING.get(this.settings);
        this.projectResolver = client.projectResolver();
    }

    public void init() {
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ENABLED_SETTING, this::setEnabled);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(EAGER_DOWNLOAD_SETTING, this::setEagerDownload);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(POLL_INTERVAL_SETTING, this::setPollInterval);
    }

    private void setEnabled(boolean enabled) {
        if (!this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (enabled) {
            this.startTask(ProjectId.DEFAULT, () -> {});
        } else {
            this.stopTask(ProjectId.DEFAULT, () -> {});
        }
    }

    private void setEagerDownload(Boolean eagerDownload) {
        if (!Objects.equals(this.eagerDownload, eagerDownload)) {
            this.eagerDownload = eagerDownload;
            GeoIpDownloader currentDownloader = this.getTask(ProjectId.DEFAULT);
            if (currentDownloader != null && Objects.equals(eagerDownload, Boolean.TRUE)) {
                currentDownloader.requestReschedule();
            }
        }
    }

    private void setPollInterval(TimeValue pollInterval) {
        if (!Objects.equals(this.pollInterval, pollInterval)) {
            this.pollInterval = pollInterval;
            GeoIpDownloader currentDownloader = this.getTask(ProjectId.DEFAULT);
            if (currentDownloader != null) {
                currentDownloader.requestReschedule();
            }
        }
    }

    protected void nodeOperation(AllocatedPersistentTask task, GeoIpTaskParams params, PersistentTaskState state) {
        GeoIpDownloader downloader = (GeoIpDownloader)task;
        GeoIpTaskState geoIpTaskState = state == null ? GeoIpTaskState.EMPTY : (GeoIpTaskState)state;
        downloader.setState(geoIpTaskState);
        this.tasks.put(this.projectResolver.getProjectId(), downloader);
        if (((Boolean)ENABLED_SETTING.get(this.clusterService.state().metadata().settings(), this.settings)).booleanValue()) {
            downloader.runDownloader();
        }
    }

    protected GeoIpDownloader createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<GeoIpTaskParams> taskInProgress, Map<String, String> headers) {
        ProjectId projectId = this.projectResolver.getProjectId();
        return new GeoIpDownloader(this.client, this.httpClient, this.clusterService, this.threadPool, this.settings, id, type, action, this.getDescription(taskInProgress), parentTaskId, headers, () -> this.pollInterval, () -> this.eagerDownload, () -> this.atLeastOneGeoipProcessorByProject.getOrDefault(projectId, false), projectId);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().nodes().getMasterNode();
        if (masterNode == null) {
            return;
        }
        if (!event.metadataChanged()) {
            return;
        }
        for (ProjectMetadata projectMetadata : event.state().metadata().projects().values()) {
            ProjectId projectId = projectMetadata.id();
            AtomicBoolean taskIsBootstrapped = this.taskIsBootstrappedByProject.computeIfAbsent(projectId, k -> new AtomicBoolean(false));
            if (!taskIsBootstrapped.getAndSet(true)) {
                this.atLeastOneGeoipProcessorByProject.computeIfAbsent(projectId, k -> GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(projectMetadata));
                if (((Boolean)ENABLED_SETTING.get(event.state().getMetadata().settings(), this.settings)).booleanValue()) {
                    logger.debug("Bootstrapping geoip downloader task for project [{}]", (Object)projectId);
                    this.startTask(projectId, () -> taskIsBootstrapped.set(false));
                } else {
                    logger.debug("Stopping geoip downloader task for project [{}]", (Object)projectId);
                    this.stopTask(projectId, () -> taskIsBootstrapped.set(false));
                }
            }
            boolean hasIngestPipelineChanges = event.customMetadataChanged(projectId, "ingest");
            boolean hasIndicesChanges = false;
            boolean projectExisted = event.previousState().metadata().hasProject(projectId);
            if (projectExisted) {
                boolean bl = hasIndicesChanges = !event.previousState().metadata().getProject(projectId).indices().equals(projectMetadata.indices());
            }
            if (!hasIngestPipelineChanges && !hasIndicesChanges) continue;
            boolean atLeastOneGeoipProcessor = this.atLeastOneGeoipProcessorByProject.getOrDefault(projectId, false);
            boolean newAtLeastOneGeoipProcessor = GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(projectMetadata);
            if (newAtLeastOneGeoipProcessor != atLeastOneGeoipProcessor) {
                this.atLeastOneGeoipProcessorByProject.put(projectId, newAtLeastOneGeoipProcessor);
            }
            if (!newAtLeastOneGeoipProcessor || atLeastOneGeoipProcessor) continue;
            logger.trace("Scheduling runDownloader for project [{}] because a geoip processor has been added", (Object)projectId);
            GeoIpDownloader currentDownloader = this.getTask(projectId);
            if (currentDownloader == null) continue;
            currentDownloader.requestReschedule();
        }
    }

    static boolean hasAtLeastOneGeoipProcessor(ProjectMetadata projectMetadata) {
        if (!GeoIpDownloaderTaskExecutor.pipelinesWithGeoIpProcessor(projectMetadata, true).isEmpty()) {
            return true;
        }
        Set<String> checkReferencedPipelines = GeoIpDownloaderTaskExecutor.pipelinesWithGeoIpProcessor(projectMetadata, false);
        if (checkReferencedPipelines.isEmpty()) {
            return false;
        }
        for (IndexMetadata indexMetadata : projectMetadata.indices().values()) {
            String defaultPipeline = (String)IndexSettings.DEFAULT_PIPELINE.get(indexMetadata.getSettings());
            String finalPipeline = (String)IndexSettings.FINAL_PIPELINE.get(indexMetadata.getSettings());
            if (!checkReferencedPipelines.contains(defaultPipeline) && !checkReferencedPipelines.contains(finalPipeline)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> pipelinesWithGeoIpProcessor(ProjectMetadata projectMetadata, boolean downloadDatabaseOnPipelineCreation) {
        List configurations = IngestService.getPipelines((ProjectMetadata)projectMetadata, (String[])new String[0]);
        HashMap<String, PipelineConfiguration> pipelineConfigById = HashMap.newHashMap(configurations.size());
        for (PipelineConfiguration configuration : configurations) {
            pipelineConfigById.put(configuration.getId(), configuration);
        }
        HashMap<String, Boolean> pipelineHasGeoProcessorById = HashMap.newHashMap(configurations.size());
        HashSet<String> ids = new HashSet<String>();
        for (PipelineConfiguration configuration : configurations) {
            List processors = (List)configuration.getConfig().get("processors");
            String pipelineName = configuration.getId();
            if (pipelineHasGeoProcessorById.containsKey(pipelineName) || !GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(processors, downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById)) continue;
            ids.add(pipelineName);
        }
        return Collections.unmodifiableSet(ids);
    }

    private static boolean hasAtLeastOneGeoipProcessor(List<Map<String, Object>> processors, boolean downloadDatabaseOnPipelineCreation, Map<String, PipelineConfiguration> pipelineConfigById, Map<String, Boolean> pipelineHasGeoProcessorById) {
        if (processors != null) {
            for (Map<String, Object> processor : processors) {
                if (!GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(processor, downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasAtLeastOneGeoipProcessor(Map<String, Object> processor, boolean downloadDatabaseOnPipelineCreation, Map<String, PipelineConfiguration> pipelineConfigById, Map<String, Boolean> pipelineHasGeoProcessorById) {
        if (processor == null) {
            return false;
        }
        Map processorConfig = (Map)processor.get("geoip");
        if (processorConfig != null) {
            return GeoIpProcessor.Factory.downloadDatabaseOnPipelineCreation(processorConfig) == downloadDatabaseOnPipelineCreation;
        }
        processorConfig = (Map)processor.get("ip_location");
        if (processorConfig != null) {
            return GeoIpProcessor.Factory.downloadDatabaseOnPipelineCreation(processorConfig) == downloadDatabaseOnPipelineCreation;
        }
        return GeoIpDownloaderTaskExecutor.isProcessorWithOnFailureGeoIpProcessor(processor, downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById) || GeoIpDownloaderTaskExecutor.isForeachProcessorWithGeoipProcessor(processor, downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById) || GeoIpDownloaderTaskExecutor.isPipelineProcessorWithGeoIpProcessor(processor, downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById);
    }

    private static boolean isProcessorWithOnFailureGeoIpProcessor(Map<String, Object> processor, boolean downloadDatabaseOnPipelineCreation, Map<String, PipelineConfiguration> pipelineConfigById, Map<String, Boolean> pipelineHasGeoProcessorById) {
        for (Object value : processor.values()) {
            if (!(value instanceof Map) || !GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor((List)((Map)value).get("on_failure"), downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById)) continue;
            return true;
        }
        return false;
    }

    private static boolean isForeachProcessorWithGeoipProcessor(Map<String, Object> processor, boolean downloadDatabaseOnPipelineCreation, Map<String, PipelineConfiguration> pipelineConfigById, Map<String, Boolean> pipelineHasGeoProcessorById) {
        Map processorConfig = (Map)processor.get("foreach");
        return processorConfig != null && GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor((Map)processorConfig.get("processor"), downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById);
    }

    private static boolean isPipelineProcessorWithGeoIpProcessor(Map<String, Object> processor, boolean downloadDatabaseOnPipelineCreation, Map<String, PipelineConfiguration> pipelineConfigById, Map<String, Boolean> pipelineHasGeoProcessorById) {
        String pipelineName;
        Map processorConfig = (Map)processor.get("pipeline");
        if (processorConfig != null && (pipelineName = (String)processorConfig.get("name")) != null) {
            if (pipelineHasGeoProcessorById.containsKey(pipelineName)) {
                if (pipelineHasGeoProcessorById.get(pipelineName) == null) {
                    pipelineHasGeoProcessorById.put(pipelineName, false);
                }
            } else {
                List childProcessors = null;
                PipelineConfiguration config = pipelineConfigById.get(pipelineName);
                if (config != null) {
                    childProcessors = (List)config.getConfig().get("processors");
                }
                pipelineHasGeoProcessorById.put(pipelineName, null);
                pipelineHasGeoProcessorById.put(pipelineName, GeoIpDownloaderTaskExecutor.hasAtLeastOneGeoipProcessor(childProcessors, downloadDatabaseOnPipelineCreation, pipelineConfigById, pipelineHasGeoProcessorById));
            }
            return pipelineHasGeoProcessorById.get(pipelineName);
        }
        return false;
    }

    private void startTask(ProjectId projectId, Runnable onFailure) {
        this.persistentTasksService.sendProjectStartRequest(projectId, GeoIpDownloaderTaskExecutor.getTaskId(projectId, this.projectResolver.supportsMultipleProjects()), "geoip-downloader", (PersistentTaskParams)new GeoIpTaskParams(), MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, ActionListener.wrap(r -> logger.debug("Started geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceAlreadyExistsException)) {
                logger.error("failed to create geoip downloader task", (Throwable)e);
                onFailure.run();
            }
        }));
    }

    private void stopTask(ProjectId projectId, Runnable onFailure) {
        ActionListener listener = ActionListener.wrap(r -> logger.debug("Stopped geoip downloader task"), e -> {
            Throwable t;
            Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
            if (!(t instanceof ResourceNotFoundException)) {
                logger.error("failed to remove geoip downloader task", (Throwable)e);
                onFailure.run();
            }
        });
        this.persistentTasksService.sendProjectRemoveRequest(projectId, GeoIpDownloaderTaskExecutor.getTaskId(projectId, this.projectResolver.supportsMultipleProjects()), MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, ActionListener.runAfter((ActionListener)listener, () -> {
            IndexAbstraction databasesAbstraction = (IndexAbstraction)this.clusterService.state().metadata().getProject(projectId).getIndicesLookup().get(".geoip_databases");
            if (databasesAbstraction != null) {
                Index databasesIndex = databasesAbstraction.getWriteIndex();
                this.client.projectClient(projectId).admin().indices().prepareDelete(new String[]{databasesIndex.getName()}).execute(ActionListener.wrap(rr -> {
                    this.tasks.remove(projectId);
                    this.taskIsBootstrappedByProject.remove(projectId);
                    this.atLeastOneGeoipProcessorByProject.remove(projectId);
                }, e -> {
                    Throwable t;
                    Throwable throwable = t = e instanceof RemoteTransportException ? ExceptionsHelper.unwrapCause((Throwable)e) : e;
                    if (!(t instanceof ResourceNotFoundException)) {
                        logger.warn("failed to remove " + String.valueOf(databasesIndex), (Throwable)e);
                    }
                }));
            }
        }));
    }

    public GeoIpDownloader getTask(ProjectId projectId) {
        return this.tasks.get(projectId);
    }

    public static String getTaskId(ProjectId projectId, boolean supportsMultipleProjects) {
        return supportsMultipleProjects ? String.valueOf(projectId) + "/geoip-downloader" : "geoip-downloader";
    }
}

