/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.repository.url;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.url.http.URLHttpClient;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.url.URLRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class URLRepositoryPlugin
extends Plugin
implements RepositoryPlugin {
    private final AtomicReference<URLHttpClient.Factory> httpClientFactory = new AtomicReference();

    public List<Setting<?>> getSettings() {
        return Arrays.asList(URLRepository.ALLOWED_URLS_SETTING, URLRepository.REPOSITORIES_URL_SETTING, URLRepository.SUPPORTED_PROTOCOLS_SETTING);
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics) {
        return Collections.singletonMap("url", (projectId, metadata) -> new URLRepository(projectId, metadata, env, namedXContentRegistry, clusterService, bigArrays, recoverySettings, this.httpClientFactory.updateAndGet(factory -> factory == null ? new URLHttpClient.Factory() : factory)));
    }

    public void close() throws IOException {
        super.close();
        IOUtils.closeWhileHandlingException((Closeable)this.httpClientFactory.get());
    }
}

