/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.allocation;

import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.xpack.ccr.CcrSettings;

public final class CcrPrimaryFollowerAllocationDecider
extends AllocationDecider {
    static final String NAME = "ccr_primary_follower";

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetadata indexMetadata = allocation.metadata().indexMetadata(shardRouting.index());
        if (!((Boolean)CcrSettings.CCR_FOLLOWING_INDEX_SETTING.get(indexMetadata.getSettings())).booleanValue()) {
            return allocation.decision(Decision.YES, NAME, "shard is not a follower and is not under the purview of this decider", new Object[0]);
        }
        if (!shardRouting.primary()) {
            return allocation.decision(Decision.YES, NAME, "shard is a replica follower and is not under the purview of this decider", new Object[0]);
        }
        RecoverySource recoverySource = shardRouting.recoverySource();
        if (recoverySource == null || recoverySource.getType() != RecoverySource.Type.SNAPSHOT) {
            return allocation.decision(Decision.YES, NAME, "shard is a primary follower but was bootstrapped already; hence is not under the purview of this decider", new Object[0]);
        }
        if (!node.node().isRemoteClusterClient()) {
            return allocation.decision(Decision.NO, NAME, "shard is a primary follower and being bootstrapped, but node does not have the " + DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role", new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, "shard is a primary follower and node has the " + DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE.roleName() + " role", new Object[0]);
    }
}

