/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.RefCountAwareThreadedActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.countedterms.CountedTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplerAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ObjectPath;
import org.elasticsearch.xpack.profiling.action.CO2Calculator;
import org.elasticsearch.xpack.profiling.action.CostCalculator;
import org.elasticsearch.xpack.profiling.action.GetStackTracesRequest;
import org.elasticsearch.xpack.profiling.action.GetStackTracesResponse;
import org.elasticsearch.xpack.profiling.action.GetStackTracesResponseBuilder;
import org.elasticsearch.xpack.profiling.action.HostMetadata;
import org.elasticsearch.xpack.profiling.action.IndexAllocation;
import org.elasticsearch.xpack.profiling.action.KvIndexResolver;
import org.elasticsearch.xpack.profiling.action.ProfilingLicenseChecker;
import org.elasticsearch.xpack.profiling.action.Resampler;
import org.elasticsearch.xpack.profiling.action.StackFrame;
import org.elasticsearch.xpack.profiling.action.StackTrace;
import org.elasticsearch.xpack.profiling.action.StopWatch;
import org.elasticsearch.xpack.profiling.action.SubGroupCollector;
import org.elasticsearch.xpack.profiling.action.TraceEvent;
import org.elasticsearch.xpack.profiling.action.TraceEventID;
import org.elasticsearch.xpack.profiling.persistence.EventsIndex;

public class TransportGetStackTracesAction
extends TransportAction<GetStackTracesRequest, GetStackTracesResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetStackTracesAction.class);
    public static final Setting<Integer> PROFILING_MAX_STACKTRACE_QUERY_SLICES = Setting.intSetting((String)"xpack.profiling.query.stacktrace.max_slices", (int)16, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> PROFILING_MAX_DETAIL_QUERY_SLICES = Setting.intSetting((String)"xpack.profiling.query.details.max_slices", (int)16, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> PROFILING_QUERY_REALTIME = Setting.boolSetting((String)"xpack.profiling.query.realtime", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> PROFILING_KV_INDEX_OVERLAP = Setting.positiveTimeSetting((String)"xpack.profiling.kv_index.overlap", (TimeValue)TimeValue.timeValueHours((long)6L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final int MAX_TRACE_EVENTS_RESULT_SIZE = 150000;
    private static final String CUSTOM_EVENT_SUB_AGGREGATION_NAME = "custom_event_group";
    public static final double DEFAULT_SAMPLING_FREQUENCY = 19.0;
    private final NodeClient nodeClient;
    private final ProfilingLicenseChecker licenseChecker;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Executor responseExecutor;
    private final KvIndexResolver resolver;
    private final int desiredSlices;
    private final int desiredDetailSlices;
    private final boolean realtime;

    @Inject
    public TransportGetStackTracesAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, NodeClient nodeClient, ProfilingLicenseChecker licenseChecker, IndexNameExpressionResolver resolver) {
        super("indices:data/read/profiling/stack_traces", actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nodeClient = nodeClient;
        this.licenseChecker = licenseChecker;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.responseExecutor = threadPool.executor("profiling");
        this.resolver = new KvIndexResolver(resolver, (TimeValue)PROFILING_KV_INDEX_OVERLAP.get(settings));
        this.desiredSlices = (Integer)PROFILING_MAX_STACKTRACE_QUERY_SLICES.get(settings);
        this.desiredDetailSlices = (Integer)PROFILING_MAX_DETAIL_QUERY_SLICES.get(settings);
        this.realtime = (Boolean)PROFILING_QUERY_REALTIME.get(settings);
    }

    protected void doExecute(Task task, GetStackTracesRequest request, ActionListener<GetStackTracesResponse> submitListener) {
        this.licenseChecker.requireSupportedLicense();
        assert (task instanceof CancellableTask);
        CancellableTask submitTask = (CancellableTask)task;
        GetStackTracesResponseBuilder responseBuilder = new GetStackTracesResponseBuilder(request);
        ParentTaskAssigningClient client = new ParentTaskAssigningClient((Client)this.nodeClient, this.transportService.getLocalNode(), (Task)submitTask);
        if (request.isUserProvidedIndices()) {
            this.searchGenericEvents(submitTask, (Client)client, request, submitListener, responseBuilder);
        } else {
            this.searchProfilingEvents(submitTask, (Client)client, request, submitListener, responseBuilder);
        }
    }

    private void searchProfilingEvents(CancellableTask submitTask, Client client, GetStackTracesRequest request, ActionListener<GetStackTracesResponse> submitListener, GetStackTracesResponseBuilder responseBuilder) {
        StopWatch watch = new StopWatch("getResampledIndex");
        EventsIndex mediumDownsampled = EventsIndex.MEDIUM_DOWNSAMPLED;
        client.prepareSearch(new String[]{mediumDownsampled.getName()}).setSize(0).setQuery(request.getQuery()).setTrackTotalHits(true).execute(ActionListener.wrap(searchResponse -> {
            long sampleCount = searchResponse.getHits().getTotalHits().value();
            EventsIndex resampledIndex = mediumDownsampled.getResampledIndex(request.getSampleSize(), sampleCount);
            log.debug("User requested [{}] samples, [{}] samples matched in [{}]. Picking [{}]", (Object)request.getSampleSize(), (Object)sampleCount, (Object)mediumDownsampled, (Object)resampledIndex);
            log.debug(watch::report);
            this.searchEventGroupedByStackTrace(submitTask, client, request, submitListener, responseBuilder, resampledIndex);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                String missingIndex = ((IndexNotFoundException)e).getIndex().getName();
                EventsIndex fullIndex = EventsIndex.FULL_INDEX;
                log.debug("Index [{}] does not exist. Using [{}] instead.", (Object)missingIndex, (Object)fullIndex.getName());
                this.searchEventGroupedByStackTrace(submitTask, client, request, submitListener, responseBuilder, fullIndex);
            } else {
                submitListener.onFailure(e);
            }
        }));
    }

    private void searchGenericEvents(CancellableTask submitTask, Client client, GetStackTracesRequest request, ActionListener<GetStackTracesResponse> submitListener, GetStackTracesResponseBuilder responseBuilder) {
        StopWatch watch = new StopWatch("getSamplingRate");
        client.prepareSearch(request.getIndices()).setSize(0).setTrackTotalHits(true).setRequestCache(Boolean.valueOf(true)).setPreference(String.valueOf(request.hashCode())).setQuery(request.getQuery()).execute(ActionListener.wrap(searchResponse -> {
            int requestedSampleCount;
            long sampleCount = searchResponse.getHits().getTotalHits().value();
            if (sampleCount <= (long)(requestedSampleCount = request.getSampleSize()) * 2L) {
                responseBuilder.setSamplingRate(1.0);
            } else {
                responseBuilder.setSamplingRate((double)requestedSampleCount / (double)sampleCount);
            }
            log.debug(watch::report);
            log.debug("User requested [{}] samples, [{}] samples matched in [{}]. Sampling rate is [{}].", (Object)requestedSampleCount, (Object)sampleCount, (Object)request.getIndices(), (Object)responseBuilder.getSamplingRate());
            if (sampleCount > 0L) {
                this.searchGenericEventGroupedByStackTrace(submitTask, client, request, submitListener, responseBuilder);
            } else {
                submitListener.onResponse((Object)responseBuilder.build());
            }
        }, arg_0 -> submitListener.onFailure(arg_0)));
    }

    private void searchGenericEventGroupedByStackTrace(CancellableTask submitTask, Client client, GetStackTracesRequest request, ActionListener<GetStackTracesResponse> submitListener, GetStackTracesResponseBuilder responseBuilder) {
        CountedTermsAggregationBuilder groupByStackTraceId = (CountedTermsAggregationBuilder)new CountedTermsAggregationBuilder("group_by").size(150000).field(request.getStackTraceIdsField());
        SubGroupCollector subGroups = SubGroupCollector.attach(groupByStackTraceId, request.getAggregationFields());
        RandomSamplerAggregationBuilder randomSampler = (RandomSamplerAggregationBuilder)new RandomSamplerAggregationBuilder("sample").setSeed(request.hashCode()).setProbability(responseBuilder.getSamplingRate()).subAggregation((AggregationBuilder)groupByStackTraceId);
        if (request.getShardSeed() != null) {
            randomSampler.setShardSeed(request.getShardSeed().intValue());
        }
        client.prepareSearch(request.getIndices()).setTrackTotalHits(false).setSize(0).setRequestCache(Boolean.valueOf(true)).setPreference(String.valueOf(request.hashCode())).setQuery(request.getQuery()).addAggregation((AggregationBuilder)new MinAggregationBuilder("min_time").field("@timestamp")).addAggregation((AggregationBuilder)new MaxAggregationBuilder("max_time").field("@timestamp")).addAggregation((AggregationBuilder)randomSampler).execute(this.handleEventsGroupedByStackTrace(submitTask, client, responseBuilder, submitListener, searchResponse -> {
            long totalSamples = 0L;
            SingleBucketAggregation sample = (SingleBucketAggregation)searchResponse.getAggregations().get("sample");
            Terms stacktraces = (Terms)sample.getAggregations().get("group_by");
            HashMap<TraceEventID, TraceEvent> stackTraceEvents = new HashMap<TraceEventID, TraceEvent>();
            for (Terms.Bucket stacktraceBucket : stacktraces.getBuckets()) {
                long count = stacktraceBucket.getDocCount();
                totalSamples += count;
                String stackTraceID = stacktraceBucket.getKeyAsString();
                TraceEventID eventID = new TraceEventID("", "", "", stackTraceID, 19.0);
                TraceEvent event = stackTraceEvents.computeIfAbsent(eventID, k -> new TraceEvent());
                event.count += count;
                subGroups.collectResults((MultiBucketsAggregation.Bucket)stacktraceBucket, event);
            }
            responseBuilder.setTotalSamples(totalSamples);
            log.debug("Found [{}] stacktrace events.", (Object)stackTraceEvents.size());
            return stackTraceEvents;
        }));
    }

    private void searchEventGroupedByStackTrace(CancellableTask submitTask, Client client, GetStackTracesRequest request, ActionListener<GetStackTracesResponse> submitListener, GetStackTracesResponseBuilder responseBuilder, EventsIndex eventsIndex) {
        responseBuilder.setSamplingRate(eventsIndex.getSampleRate());
        TermsAggregationBuilder groupByStackTraceId = (TermsAggregationBuilder)((TermsAggregationBuilder)new TermsAggregationBuilder("group_by").size(150000).field("Stacktrace.id")).executionHint("map").subAggregation((AggregationBuilder)new SumAggregationBuilder("count").field("Stacktrace.count"));
        TermsAggregationBuilder groupByHostId = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)new TermsAggregationBuilder("group_by").size(150000).field("host.id")).missing((Object)"")).executionHint("map").subAggregation((AggregationBuilder)groupByStackTraceId);
        TermsAggregationBuilder groupByThreadName = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)new TermsAggregationBuilder("group_by").size(150000).field("process.thread.name")).missing((Object)"")).executionHint("map").subAggregation((AggregationBuilder)groupByHostId);
        TermsAggregationBuilder groupByExecutableName = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)new TermsAggregationBuilder("group_by").size(150000).field("process.executable.name")).missing((Object)"")).executionHint("map").subAggregation((AggregationBuilder)groupByThreadName);
        SubGroupCollector subGroups = SubGroupCollector.attach(groupByStackTraceId, request.getAggregationFields());
        client.prepareSearch(new String[]{eventsIndex.getName()}).setTrackTotalHits(false).setSize(0).setRequestCache(Boolean.valueOf(true)).setPreference(String.valueOf(request.hashCode())).setQuery(request.getQuery()).addAggregation((AggregationBuilder)new MinAggregationBuilder("min_time").field("@timestamp")).addAggregation((AggregationBuilder)new MaxAggregationBuilder("max_time").field("@timestamp")).addAggregation((AggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)new TermsAggregationBuilder("group_by").size(150000).field("Stacktrace.sampling_frequency")).missing((Object)19L)).executionHint("map").subAggregation((AggregationBuilder)groupByExecutableName)).subAggregation((AggregationBuilder)new SumAggregationBuilder("total_count").field("Stacktrace.count"))).addAggregation((AggregationBuilder)new SumAggregationBuilder("total_count").field("Stacktrace.count")).execute(this.handleEventsGroupedByStackTrace(submitTask, client, responseBuilder, submitListener, searchResponse -> {
            long maxSamplingFrequency = 0L;
            Terms samplingFrequencies = (Terms)searchResponse.getAggregations().get("group_by");
            for (Terms.Bucket samplingFrequencyBucket : samplingFrequencies.getBuckets()) {
                double samplingFrequency = samplingFrequencyBucket.getKeyAsNumber().doubleValue();
                if (!(samplingFrequency > (double)maxSamplingFrequency)) continue;
                maxSamplingFrequency = (long)samplingFrequency;
            }
            long totalCount = 0L;
            for (Terms.Bucket samplingFrequencyBucket : samplingFrequencies.getBuckets()) {
                InternalNumericMetricsAggregation.SingleValue count = (InternalNumericMetricsAggregation.SingleValue)samplingFrequencyBucket.getAggregations().get("total_count");
                double samplingFrequency = samplingFrequencyBucket.getKeyAsNumber().doubleValue();
                double samplingFactor = (double)maxSamplingFrequency / samplingFrequency;
                totalCount += Math.round(count.value() * samplingFactor);
            }
            Resampler resampler = new Resampler(request, responseBuilder.getSamplingRate(), totalCount);
            long totalFinalCount = 0L;
            HashMap<TraceEventID, TraceEvent> stackTraceEvents = new HashMap<TraceEventID, TraceEvent>(150000);
            for (Terms.Bucket samplingFrequencyBucket : samplingFrequencies.getBuckets()) {
                double samplingFrequency = samplingFrequencyBucket.getKeyAsNumber().doubleValue();
                double samplingFactor = (double)maxSamplingFrequency / samplingFrequency;
                Terms executableNames = (Terms)samplingFrequencyBucket.getAggregations().get("group_by");
                for (Terms.Bucket executableBucket : executableNames.getBuckets()) {
                    String executableName = executableBucket.getKeyAsString();
                    Terms threads = (Terms)executableBucket.getAggregations().get("group_by");
                    for (Terms.Bucket threadBucket : threads.getBuckets()) {
                        String threadName = threadBucket.getKeyAsString();
                        Terms hosts = (Terms)threadBucket.getAggregations().get("group_by");
                        for (Terms.Bucket hostBucket : hosts.getBuckets()) {
                            String hostID = hostBucket.getKeyAsString();
                            Terms stacktraces = (Terms)hostBucket.getAggregations().get("group_by");
                            for (Terms.Bucket stacktraceBucket : stacktraces.getBuckets()) {
                                Sum count = (Sum)stacktraceBucket.getAggregations().get("count");
                                int finalCount = resampler.adjustSampleCount((int)Math.round(count.value() * samplingFactor));
                                if (finalCount <= 0) continue;
                                totalFinalCount += (long)finalCount;
                                String stackTraceID = stacktraceBucket.getKeyAsString();
                                TraceEventID eventID = new TraceEventID(executableName, threadName, hostID, stackTraceID, maxSamplingFrequency);
                                TraceEvent event = stackTraceEvents.computeIfAbsent(eventID, k -> new TraceEvent());
                                event.count += (long)finalCount;
                                subGroups.collectResults((MultiBucketsAggregation.Bucket)stacktraceBucket, event);
                            }
                        }
                    }
                }
            }
            responseBuilder.setTotalSamples(totalFinalCount);
            log.debug("Found [{}] stacktrace events, resampled with sample rate [{}] to [{}] events ([{}] unique stack traces).", (Object)totalCount, (Object)responseBuilder.getSamplingRate(), (Object)totalFinalCount, (Object)stackTraceEvents.size());
            return stackTraceEvents;
        }));
    }

    private ActionListener<SearchResponse> handleEventsGroupedByStackTrace(CancellableTask submitTask, Client client, GetStackTracesResponseBuilder responseBuilder, ActionListener<GetStackTracesResponse> submitListener, Function<SearchResponse, Map<TraceEventID, TraceEvent>> stacktraceCollector) {
        StopWatch watch = new StopWatch("eventsGroupedByStackTrace");
        return ActionListener.wrap(searchResponse -> {
            long minTime = TransportGetStackTracesAction.getAggValueAsLong(searchResponse, "min_time");
            long maxTime = TransportGetStackTracesAction.getAggValueAsLong(searchResponse, "max_time");
            Map stackTraceEvents = (Map)stacktraceCollector.apply((SearchResponse)searchResponse);
            log.debug(watch::report);
            if (!stackTraceEvents.isEmpty()) {
                responseBuilder.setStart(Instant.ofEpochMilli(minTime));
                responseBuilder.setEnd(Instant.ofEpochMilli(maxTime));
                responseBuilder.setStackTraceEvents(stackTraceEvents);
                this.retrieveStackTraces(submitTask, client, responseBuilder, submitListener);
            } else {
                submitListener.onResponse((Object)responseBuilder.build());
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                log.debug("Index [{}] does not exist. Returning empty response.", (Object)((IndexNotFoundException)e).getIndex());
                submitListener.onResponse((Object)responseBuilder.build());
            } else {
                submitListener.onFailure(e);
            }
        });
    }

    private static long getAggValueAsLong(SearchResponse searchResponse, String field) {
        InternalNumericMetricsAggregation.SingleValue x = (InternalNumericMetricsAggregation.SingleValue)searchResponse.getAggregations().get(field);
        return Math.round(x.value());
    }

    private void retrieveStackTraces(CancellableTask submitTask, Client client, GetStackTracesResponseBuilder responseBuilder, ActionListener<GetStackTracesResponse> submitListener) {
        if (submitTask.notifyIfCancelled(submitListener)) {
            return;
        }
        TreeSet<String> stacktraceIds = new TreeSet<String>();
        TreeSet<String> hostIds = new TreeSet<String>();
        for (TraceEventID id : responseBuilder.getStackTraceEvents().keySet()) {
            stacktraceIds.add(id.stacktraceID());
            hostIds.add(id.hostID());
        }
        log.info("Using [{}] hostIds and [{}] stacktraceIds.", (Object)hostIds.size(), (Object)stacktraceIds.size());
        ClusterState clusterState = this.clusterService.state();
        List<Index> indices = this.resolver.resolve(clusterState, "profiling-stacktraces", responseBuilder.getStart(), responseBuilder.getEnd());
        int sliceCount = IndexAllocation.isAnyOnWarmOrColdTier(clusterState, indices) ? 1 : this.desiredSlices;
        log.trace("Using [{}] slice(s) to lookup stacktraces.", (Object)sliceCount);
        List slicedEventIds = TransportGetStackTracesAction.sliced(new ArrayList(stacktraceIds), sliceCount);
        StackTraceHandler handler = new StackTraceHandler(submitTask, clusterState, client, responseBuilder, submitListener, stacktraceIds.size(), slicedEventIds.size() * indices.size() + (hostIds.isEmpty() ? 0 : 1), hostIds.size());
        for (List<String> list : slicedEventIds) {
            this.mget(client, indices, list, (ActionListener<MultiGetResponse>)ActionListener.wrap(handler::onStackTraceResponse, arg_0 -> submitListener.onFailure(arg_0)));
        }
        if (hostIds.isEmpty()) {
            return;
        }
        client.prepareSearch(new String[]{"profiling-hosts"}).setTrackTotalHits(false).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"@timestamp").gte((Object)responseBuilder.getStart().minus(Duration.ofHours(6L)).toEpochMilli()).lt((Object)responseBuilder.getEnd().toEpochMilli()).format("epoch_millis")).filter((QueryBuilder)QueryBuilders.termsQuery((String)"host.id", hostIds))).setCollapse(new CollapseBuilder("host.id")).addSort(new FieldSortBuilder("@timestamp").order(SortOrder.DESC)).setFrom(0).execute(ActionListener.wrap(handler::onHostsResponse, arg_0 -> submitListener.onFailure(arg_0)));
    }

    static <T> List<List<T>> sliced(List<T> c, int slices) {
        if (c.size() <= slices || slices == 1) {
            return List.of(c);
        }
        ArrayList<List<T>> slicedList = new ArrayList<List<T>>();
        int batchSize = c.size() / slices;
        for (int slice = 0; slice < slices; ++slice) {
            int upperIndex = slice + 1 < slices ? (slice + 1) * batchSize : c.size();
            List<T> ids = c.subList(slice * batchSize, upperIndex);
            slicedList.add(ids);
        }
        return Collections.unmodifiableList(slicedList);
    }

    private void retrieveStackTraceDetails(CancellableTask submitTask, ClusterState clusterState, Client client, GetStackTracesResponseBuilder responseBuilder, List<String> stackFrameIds, List<String> executableIds, ActionListener<GetStackTracesResponse> submitListener) {
        if (submitTask.notifyIfCancelled(submitListener)) {
            return;
        }
        List<Index> stackFrameIndices = this.resolver.resolve(clusterState, "profiling-stackframes", responseBuilder.getStart(), responseBuilder.getEnd());
        List<Index> executableIndices = this.resolver.resolve(clusterState, "profiling-executables", responseBuilder.getStart(), responseBuilder.getEnd());
        int stackFrameSliceCount = IndexAllocation.isAnyOnWarmOrColdTier(clusterState, stackFrameIndices) ? 1 : this.desiredDetailSlices;
        int executableSliceCount = IndexAllocation.isAnyOnWarmOrColdTier(clusterState, executableIndices) ? 1 : this.desiredDetailSlices;
        log.trace("Using [{}] slice(s) to lookup stack frames and [{}] slice(s) to lookup executables.", (Object)stackFrameSliceCount, (Object)executableSliceCount);
        List<List<String>> slicedStackFrameIds = TransportGetStackTracesAction.sliced(stackFrameIds, stackFrameSliceCount);
        List<List<String>> slicedExecutableIds = TransportGetStackTracesAction.sliced(executableIds, executableSliceCount);
        DetailsHandler handler = new DetailsHandler(responseBuilder, submitListener, executableIds.size(), stackFrameIds.size(), slicedExecutableIds.size() * executableIndices.size(), slicedStackFrameIds.size() * stackFrameIndices.size());
        if (stackFrameIds.isEmpty()) {
            handler.onStackFramesResponse(new MultiGetResponse(new MultiGetItemResponse[0]));
        } else {
            for (List<String> slice : slicedStackFrameIds) {
                this.mget(client, stackFrameIndices, slice, (ActionListener<MultiGetResponse>)ActionListener.wrap(handler::onStackFramesResponse, arg_0 -> submitListener.onFailure(arg_0)));
            }
        }
        if (executableIds.isEmpty()) {
            handler.onExecutableDetailsResponse(new MultiGetResponse(new MultiGetItemResponse[0]));
        } else {
            for (List<String> slice : slicedExecutableIds) {
                this.mget(client, executableIndices, slice, (ActionListener<MultiGetResponse>)ActionListener.wrap(handler::onExecutableDetailsResponse, arg_0 -> submitListener.onFailure(arg_0)));
            }
        }
    }

    private void mget(Client client, List<Index> indices, List<String> slice, ActionListener<MultiGetResponse> listener) {
        for (Index index : indices) {
            client.prepareMultiGet().addIds(index.getName(), slice).setRealtime(this.realtime).execute((ActionListener)new RefCountAwareThreadedActionListener(this.responseExecutor, listener));
        }
    }

    private class StackTraceHandler {
        private final AtomicInteger expectedResponses;
        private final CancellableTask submitTask;
        private final ClusterState clusterState;
        private final Client client;
        private final GetStackTracesResponseBuilder responseBuilder;
        private final ActionListener<GetStackTracesResponse> submitListener;
        private final Map<String, StackTrace> stackTracePerId;
        private final Set<String> stackFrameIds;
        private final Set<String> executableIds;
        private final AtomicInteger totalFrames = new AtomicInteger();
        private final StopWatch watch = new StopWatch("retrieveStackTraces");
        private final StopWatch hostsWatch = new StopWatch("retrieveHostMetadata");
        private final Map<String, HostMetadata> hostMetadata;

        private StackTraceHandler(CancellableTask submitTask, ClusterState clusterState, Client client, GetStackTracesResponseBuilder responseBuilder, ActionListener<GetStackTracesResponse> submitListener, int stackTraceCount, int expectedResponses, int expectedHosts) {
            this.submitTask = submitTask;
            this.clusterState = clusterState;
            this.stackTracePerId = new ConcurrentHashMap<String, StackTrace>(stackTraceCount);
            this.stackFrameIds = ConcurrentHashMap.newKeySet(stackTraceCount * 5);
            this.executableIds = ConcurrentHashMap.newKeySet(stackTraceCount);
            this.expectedResponses = new AtomicInteger(expectedResponses);
            this.client = client;
            this.responseBuilder = responseBuilder;
            this.submitListener = submitListener;
            this.hostMetadata = new HashMap<String, HostMetadata>(expectedHosts);
        }

        public void onStackTraceResponse(MultiGetResponse multiGetItemResponses) {
            for (MultiGetItemResponse trace : multiGetItemResponses) {
                StackTrace stacktrace;
                String id;
                if (trace.isFailed()) {
                    this.submitListener.onFailure(trace.getFailure().getFailure());
                    return;
                }
                if (!trace.getResponse().isExists() || this.stackTracePerId.containsKey(id = trace.getId()) || this.stackTracePerId.putIfAbsent(id, stacktrace = StackTrace.fromSource(trace.getResponse().getSource())) != null) continue;
                this.totalFrames.addAndGet(stacktrace.frameIds.length);
                this.stackFrameIds.addAll(List.of(stacktrace.frameIds));
                stacktrace.forNativeAndKernelFrames(this.executableIds::add);
            }
            this.mayFinish();
        }

        public void onHostsResponse(SearchResponse searchResponse) {
            SearchHit[] hits;
            for (SearchHit hit : hits = searchResponse.getHits().getHits()) {
                HostMetadata host = HostMetadata.fromSource(hit.getSourceAsMap());
                this.hostMetadata.put(host.hostID, host);
            }
            log.debug(this.hostsWatch::report);
            log.debug("Got [{}] host metadata items", (Object)this.hostMetadata.size());
            this.mayFinish();
        }

        public void calculateCO2AndCosts() {
            StopWatch watch = new StopWatch("calculateCO2AndCosts");
            CO2Calculator co2Calculator = new CO2Calculator(this.hostMetadata, this.responseBuilder.getRequestedDuration(), this.responseBuilder.getCustomCO2PerKWH(), this.responseBuilder.getCustomDatacenterPUE(), this.responseBuilder.getCustomPerCoreWattX86(), this.responseBuilder.getCustomPerCoreWattARM64());
            CostCalculator costCalculator = new CostCalculator(this.hostMetadata, this.responseBuilder.getRequestedDuration(), this.responseBuilder.getAWSCostFactor(), this.responseBuilder.getAzureCostFactor(), this.responseBuilder.getCustomCostPerCoreHour());
            this.responseBuilder.getStackTraceEvents().forEach((eventId, event) -> {
                event.annualCO2Tons += co2Calculator.getAnnualCO2Tons(eventId.hostID(), event.count, eventId.samplingFrequency());
                event.annualCostsUSD += costCalculator.annualCostsUSD(eventId.hostID(), event.count, eventId.samplingFrequency());
            });
            log.debug(watch::report);
        }

        public void mayFinish() {
            if (this.expectedResponses.decrementAndGet() == 0) {
                this.calculateCO2AndCosts();
                this.responseBuilder.setStackTraces(this.stackTracePerId);
                this.responseBuilder.setTotalFrames(this.totalFrames.get());
                log.debug("retrieveStackTraces found [{}] stack traces, [{}] frames, [{}] executables.", (Object)this.stackTracePerId.size(), (Object)this.stackFrameIds.size(), (Object)this.executableIds.size());
                log.debug(this.watch::report);
                TransportGetStackTracesAction.this.retrieveStackTraceDetails(this.submitTask, this.clusterState, this.client, this.responseBuilder, new ArrayList<String>(this.stackFrameIds), new ArrayList<String>(this.executableIds), this.submitListener);
            }
        }
    }

    private static class DetailsHandler {
        private static final String[] PATH_FILE_NAME = new String[]{"Executable", "file", "name"};
        private final GetStackTracesResponseBuilder builder;
        private final ActionListener<GetStackTracesResponse> submitListener;
        private final Map<String, String> executables;
        private final Map<String, StackFrame> stackFrames;
        private final AtomicInteger expectedSlices;
        private final AtomicInteger totalInlineFrames = new AtomicInteger();
        private final StopWatch watch = new StopWatch("retrieveStackTraceDetails");

        private DetailsHandler(GetStackTracesResponseBuilder builder, ActionListener<GetStackTracesResponse> submitListener, int executableCount, int stackFrameCount, int expectedExecutableSlices, int expectedStackFrameSlices) {
            this.builder = builder;
            this.submitListener = submitListener;
            this.executables = new ConcurrentHashMap<String, String>(executableCount);
            this.stackFrames = new ConcurrentHashMap<String, StackFrame>(stackFrameCount);
            this.expectedSlices = new AtomicInteger(expectedExecutableSlices + expectedStackFrameSlices);
        }

        public void onStackFramesResponse(MultiGetResponse multiGetItemResponses) {
            for (MultiGetItemResponse frame : multiGetItemResponses) {
                if (frame.isFailed()) {
                    this.submitListener.onFailure(frame.getFailure().getFailure());
                    return;
                }
                if (!frame.getResponse().isExists() || this.stackFrames.containsKey(frame.getId())) continue;
                StackFrame stackFrame = StackFrame.fromSource(frame.getResponse().getSource());
                if (!stackFrame.isEmpty()) {
                    if (this.stackFrames.putIfAbsent(frame.getId(), stackFrame) != null) continue;
                    this.totalInlineFrames.addAndGet(stackFrame.inlineFrameCount());
                    continue;
                }
                log.trace("Stack frame with id [{}] has no properties.", (Object)frame.getId());
            }
            this.mayFinish();
        }

        public void onExecutableDetailsResponse(MultiGetResponse multiGetItemResponses) {
            for (MultiGetItemResponse executable : multiGetItemResponses) {
                if (executable.isFailed()) {
                    this.submitListener.onFailure(executable.getFailure().getFailure());
                    return;
                }
                if (!executable.getResponse().isExists() || this.executables.containsKey(executable.getId())) continue;
                Map source = executable.getResponse().getSource();
                String fileName = (String)ObjectPath.eval((String[])PATH_FILE_NAME, (Object)source);
                if (fileName == null) {
                    fileName = (String)source.get("Executable.file.name");
                }
                if (fileName != null) {
                    this.executables.putIfAbsent(executable.getId(), fileName);
                    continue;
                }
                String priorKey = this.executables.putIfAbsent(executable.getId(), "<missing>");
                if (priorKey != null) continue;
                log.trace("Executable with id [{}] has no file name.", (Object)executable.getId());
            }
            this.mayFinish();
        }

        public void mayFinish() {
            if (this.expectedSlices.decrementAndGet() == 0) {
                this.builder.setExecutables(this.executables);
                this.builder.setStackFrames(this.stackFrames);
                this.builder.addTotalFrames(this.totalInlineFrames.get());
                log.debug("retrieveStackTraceDetails found [{}] stack frames, [{}] executables.", (Object)this.stackFrames.size(), (Object)this.executables.size());
                log.debug(this.watch::report);
                this.submitListener.onResponse((Object)this.builder.build());
            }
        }
    }
}

