/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.network.CIDRUtils;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;

public class NetworkDirectionProcessor
extends AbstractProcessor {
    static final byte[] UNDEFINED_IP4 = new byte[]{0, 0, 0, 0};
    static final byte[] UNDEFINED_IP6 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte[] BROADCAST_IP4 = new byte[]{-1, -1, -1, -1};
    public static final String TYPE = "network_direction";
    public static final String DIRECTION_INTERNAL = "internal";
    public static final String DIRECTION_EXTERNAL = "external";
    public static final String DIRECTION_INBOUND = "inbound";
    public static final String DIRECTION_OUTBOUND = "outbound";
    private static final String LOOPBACK_NAMED_NETWORK = "loopback";
    private static final String GLOBAL_UNICAST_NAMED_NETWORK = "global_unicast";
    private static final String UNICAST_NAMED_NETWORK = "unicast";
    private static final String LINK_LOCAL_UNICAST_NAMED_NETWORK = "link_local_unicast";
    private static final String INTERFACE_LOCAL_NAMED_NETWORK = "interface_local_multicast";
    private static final String LINK_LOCAL_MULTICAST_NAMED_NETWORK = "link_local_multicast";
    private static final String MULTICAST_NAMED_NETWORK = "multicast";
    private static final String UNSPECIFIED_NAMED_NETWORK = "unspecified";
    private static final String PRIVATE_NAMED_NETWORK = "private";
    private static final String PUBLIC_NAMED_NETWORK = "public";
    private final String sourceIpField;
    private final String destinationIpField;
    private final String targetField;
    private final List<TemplateScript.Factory> internalNetworks;
    private final String internalNetworksField;
    private final boolean ignoreMissing;

    NetworkDirectionProcessor(String tag, String description, String sourceIpField, String destinationIpField, String targetField, List<TemplateScript.Factory> internalNetworks, String internalNetworksField, boolean ignoreMissing) {
        super(tag, description);
        this.sourceIpField = sourceIpField;
        this.destinationIpField = destinationIpField;
        this.targetField = targetField;
        this.internalNetworks = internalNetworks;
        this.internalNetworksField = internalNetworksField;
        this.ignoreMissing = ignoreMissing;
    }

    public String getSourceIpField() {
        return this.sourceIpField;
    }

    public String getDestinationIpField() {
        return this.destinationIpField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public List<TemplateScript.Factory> getInternalNetworks() {
        return this.internalNetworks;
    }

    public String getInternalNetworksField() {
        return this.internalNetworksField;
    }

    public boolean getIgnoreMissing() {
        return this.ignoreMissing;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        String direction = this.getDirection(ingestDocument);
        if (direction == null) {
            if (this.ignoreMissing) {
                return ingestDocument;
            }
            throw new IllegalArgumentException("unable to calculate network direction from document");
        }
        ingestDocument.setFieldValue(this.targetField, (Object)direction);
        return ingestDocument;
    }

    private String getDirection(IngestDocument d) throws Exception {
        List<Object> networks = new ArrayList();
        if (this.internalNetworksField != null) {
            List stringList = (List)d.getFieldValue(this.internalNetworksField, networks.getClass(), this.ignoreMissing);
            if (stringList == null) {
                return null;
            }
            networks.addAll(stringList);
        } else {
            networks = this.internalNetworks.stream().map(network -> d.renderTemplate(network)).toList();
        }
        String sourceIpAddrString = (String)d.getFieldValue(this.sourceIpField, String.class, this.ignoreMissing);
        if (sourceIpAddrString == null) {
            return null;
        }
        String destIpAddrString = (String)d.getFieldValue(this.destinationIpField, String.class, this.ignoreMissing);
        if (destIpAddrString == null) {
            return null;
        }
        boolean sourceInternal = NetworkDirectionProcessor.isInternal(networks, sourceIpAddrString);
        boolean destinationInternal = NetworkDirectionProcessor.isInternal(networks, destIpAddrString);
        if (sourceInternal && destinationInternal) {
            return DIRECTION_INTERNAL;
        }
        if (sourceInternal) {
            return DIRECTION_OUTBOUND;
        }
        if (destinationInternal) {
            return DIRECTION_INBOUND;
        }
        return DIRECTION_EXTERNAL;
    }

    private static boolean isInternal(List<String> networks, String ip) {
        for (String network : networks) {
            if (!NetworkDirectionProcessor.inNetwork(ip, network)) continue;
            return true;
        }
        return false;
    }

    private static boolean inNetwork(String ip, String network) {
        InetAddress address = InetAddresses.forString((String)ip);
        return switch (network) {
            case LOOPBACK_NAMED_NETWORK -> NetworkDirectionProcessor.isLoopback(address);
            case GLOBAL_UNICAST_NAMED_NETWORK, UNICAST_NAMED_NETWORK -> NetworkDirectionProcessor.isUnicast(address);
            case LINK_LOCAL_UNICAST_NAMED_NETWORK -> NetworkDirectionProcessor.isLinkLocalUnicast(address);
            case INTERFACE_LOCAL_NAMED_NETWORK -> NetworkDirectionProcessor.isInterfaceLocalMulticast(address);
            case LINK_LOCAL_MULTICAST_NAMED_NETWORK -> NetworkDirectionProcessor.isLinkLocalMulticast(address);
            case MULTICAST_NAMED_NETWORK -> NetworkDirectionProcessor.isMulticast(address);
            case UNSPECIFIED_NAMED_NETWORK -> NetworkDirectionProcessor.isUnspecified(address);
            case PRIVATE_NAMED_NETWORK -> NetworkDirectionProcessor.isPrivate(ip);
            case PUBLIC_NAMED_NETWORK -> NetworkDirectionProcessor.isPublic(ip);
            default -> CIDRUtils.isInRange((String)ip, (String[])new String[]{network});
        };
    }

    private static boolean isLoopback(InetAddress ip) {
        return ip.isLoopbackAddress();
    }

    private static boolean isUnicast(InetAddress ip) {
        return !Arrays.equals(ip.getAddress(), BROADCAST_IP4) && !NetworkDirectionProcessor.isUnspecified(ip) && !NetworkDirectionProcessor.isLoopback(ip) && !NetworkDirectionProcessor.isMulticast(ip) && !NetworkDirectionProcessor.isLinkLocalUnicast(ip);
    }

    private static boolean isLinkLocalUnicast(InetAddress ip) {
        return ip.isLinkLocalAddress();
    }

    private static boolean isInterfaceLocalMulticast(InetAddress ip) {
        return ip.isMCNodeLocal();
    }

    private static boolean isLinkLocalMulticast(InetAddress ip) {
        return ip.isMCLinkLocal();
    }

    private static boolean isMulticast(InetAddress ip) {
        return ip.isMulticastAddress();
    }

    private static boolean isUnspecified(InetAddress ip) {
        byte[] address = ip.getAddress();
        return Arrays.equals(UNDEFINED_IP4, address) || Arrays.equals(UNDEFINED_IP6, address);
    }

    private static boolean isPrivate(String ip) {
        return CIDRUtils.isInRange((String)ip, (String[])new String[]{"10.0.0.0/8", "172.16.0.0/12", "192.168.0.0/16", "fd00::/8"});
    }

    private static boolean isPublic(String ip) {
        return !NetworkDirectionProcessor.isLocalOrPrivate(ip);
    }

    private static boolean isLocalOrPrivate(String ip) {
        InetAddress address = InetAddresses.forString((String)ip);
        return NetworkDirectionProcessor.isPrivate(ip) || NetworkDirectionProcessor.isLoopback(address) || NetworkDirectionProcessor.isUnspecified(address) || NetworkDirectionProcessor.isLinkLocalUnicast(address) || NetworkDirectionProcessor.isLinkLocalMulticast(address) || NetworkDirectionProcessor.isInterfaceLocalMulticast(address) || Arrays.equals(address.getAddress(), BROADCAST_IP4);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    implements Processor.Factory {
        private final ScriptService scriptService;
        static final String DEFAULT_SOURCE_IP = "source.ip";
        static final String DEFAULT_DEST_IP = "destination.ip";
        static final String DEFAULT_TARGET = "network.direction";

        public Factory(ScriptService scriptService) {
            this.scriptService = scriptService;
        }

        public NetworkDirectionProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            String sourceIpField = ConfigurationUtils.readStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"source_ip", (String)DEFAULT_SOURCE_IP);
            String destIpField = ConfigurationUtils.readStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"destination_ip", (String)DEFAULT_DEST_IP);
            String targetField = ConfigurationUtils.readStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"target_field", (String)DEFAULT_TARGET);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"ignore_missing", (boolean)true);
            List internalNetworks = ConfigurationUtils.readOptionalList((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"internal_networks");
            String internalNetworksField = ConfigurationUtils.readOptionalStringProperty((String)NetworkDirectionProcessor.TYPE, (String)processorTag, config, (String)"internal_networks_field");
            if (internalNetworks == null && internalNetworksField == null) {
                throw ConfigurationUtils.newConfigurationException((String)NetworkDirectionProcessor.TYPE, (String)processorTag, (String)"internal_networks", (String)"or [internal_networks_field] must be specified");
            }
            if (internalNetworks != null && internalNetworksField != null) {
                throw ConfigurationUtils.newConfigurationException((String)NetworkDirectionProcessor.TYPE, (String)processorTag, (String)"internal_networks", (String)"and [internal_networks_field] cannot both be used in the same processor");
            }
            List<TemplateScript.Factory> internalNetworkTemplates = null;
            if (internalNetworks != null) {
                internalNetworkTemplates = internalNetworks.stream().map(n -> ConfigurationUtils.compileTemplate((String)NetworkDirectionProcessor.TYPE, (String)processorTag, (String)"internal_networks", (String)n, (ScriptService)this.scriptService)).toList();
            }
            return new NetworkDirectionProcessor(processorTag, description, sourceIpField, destIpField, targetField, internalNetworkTemplates, internalNetworksField, ignoreMissing);
        }
    }
}

