/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.rerank;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIServiceSettings;

public class VoyageAIRerankServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
VoyageAIRateLimitServiceSettings {
    public static final String NAME = "voyageai_rerank_service_settings";
    private static final Logger logger = LogManager.getLogger(VoyageAIRerankServiceSettings.class);
    private final VoyageAIServiceSettings commonSettings;

    public static VoyageAIRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        VoyageAIServiceSettings commonServiceSettings = VoyageAIServiceSettings.fromMap(map, context);
        return new VoyageAIRerankServiceSettings(commonServiceSettings);
    }

    public VoyageAIRerankServiceSettings(VoyageAIServiceSettings commonSettings) {
        this.commonSettings = commonSettings;
    }

    public VoyageAIRerankServiceSettings(StreamInput in) throws IOException {
        this.commonSettings = new VoyageAIServiceSettings(in);
    }

    public VoyageAIServiceSettings getCommonSettings() {
        return this.commonSettings;
    }

    public String modelId() {
        return this.commonSettings.modelId();
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.commonSettings.rateLimitSettings();
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder = this.commonSettings.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.commonSettings.toXContentFragmentOfExposedFields(builder, params);
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return TransportVersions.VOYAGE_AI_INTEGRATION_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.onOrAfter((VersionId)TransportVersions.VOYAGE_AI_INTEGRATION_ADDED) || version.isPatchFrom(TransportVersions.VOYAGE_AI_INTEGRATION_ADDED_BACKPORT_8_X);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.commonSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VoyageAIRerankServiceSettings that = (VoyageAIRerankServiceSettings)o;
        return Objects.equals(this.commonSettings, that.commonSettings);
    }

    public int hashCode() {
        return Objects.hash(this.commonSettings);
    }
}

