/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.common.amazon.AwsSecretSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerServiceSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerTaskSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredServiceSchema;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredTaskSchema;

public class SageMakerModel
extends Model {
    private final SageMakerServiceSettings serviceSettings;
    private final SageMakerTaskSettings taskSettings;
    private final AwsSecretSettings awsSecretSettings;

    SageMakerModel(ModelConfigurations configurations, ModelSecrets secrets, SageMakerServiceSettings serviceSettings, SageMakerTaskSettings taskSettings, AwsSecretSettings awsSecretSettings) {
        super(configurations, secrets);
        this.serviceSettings = serviceSettings;
        this.taskSettings = taskSettings;
        this.awsSecretSettings = awsSecretSettings;
    }

    public Optional<AwsSecretSettings> awsSecretSettings() {
        return Optional.ofNullable(this.awsSecretSettings);
    }

    public String region() {
        return this.serviceSettings.region();
    }

    public String endpointName() {
        return this.serviceSettings.endpointName();
    }

    public String api() {
        return this.serviceSettings.api();
    }

    public Optional<String> customAttributes() {
        return Optional.ofNullable(this.taskSettings.customAttributes());
    }

    public Optional<String> enableExplanations() {
        return Optional.ofNullable(this.taskSettings.enableExplanations());
    }

    public Optional<String> inferenceComponentName() {
        return Optional.ofNullable(this.serviceSettings.inferenceComponentName());
    }

    public Optional<String> inferenceIdForDataCapture() {
        return Optional.ofNullable(this.taskSettings.inferenceIdForDataCapture());
    }

    public Optional<String> sessionId() {
        return Optional.ofNullable(this.taskSettings.sessionId());
    }

    public Optional<String> targetContainerHostname() {
        return Optional.ofNullable(this.serviceSettings.targetContainerHostname());
    }

    public Optional<String> targetModel() {
        return Optional.ofNullable(this.serviceSettings.targetModel());
    }

    public Optional<String> targetVariant() {
        return Optional.ofNullable(this.taskSettings.targetVariant());
    }

    public Optional<Integer> batchSize() {
        return Optional.ofNullable(this.serviceSettings.batchSize());
    }

    public SageMakerModel override(Map<String, Object> taskSettingsOverride) {
        if (taskSettingsOverride == null || taskSettingsOverride.isEmpty()) {
            return this;
        }
        return new SageMakerModel(this.getConfigurations(), this.getSecrets(), this.serviceSettings, this.taskSettings.override(taskSettingsOverride), this.awsSecretSettings);
    }

    public static List<NamedWriteableRegistry.Entry> namedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(ServiceSettings.class, "sage_maker_service_settings", SageMakerServiceSettings::new), new NamedWriteableRegistry.Entry(TaskSettings.class, "sage_maker_task_settings", SageMakerTaskSettings::new));
    }

    public SageMakerStoredServiceSchema apiServiceSettings() {
        return this.serviceSettings.apiServiceSettings();
    }

    public SageMakerStoredTaskSchema apiTaskSettings() {
        return this.taskSettings.apiTaskSettings();
    }

    SageMakerServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    SageMakerTaskSettings taskSettings() {
        return this.taskSettings;
    }
}

