/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.openai.OpenAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.action.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class OpenAiModel
extends RateLimitGroupingModel {
    private final OpenAiRateLimitServiceSettings rateLimitServiceSettings;
    private final SecureString apiKey;
    private final URI uri;

    public OpenAiModel(ModelConfigurations configurations, ModelSecrets secrets, OpenAiRateLimitServiceSettings rateLimitServiceSettings, @Nullable ApiKeySecrets apiKeySecrets, URI uri) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
        this.uri = Objects.requireNonNull(uri);
    }

    protected OpenAiModel(OpenAiModel model, TaskSettings taskSettings) {
        super((RateLimitGroupingModel)model, taskSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
        this.uri = model.uri;
    }

    protected OpenAiModel(OpenAiModel model, ServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
        this.uri = model.uri;
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public OpenAiRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public abstract ExecutableAction accept(OpenAiActionVisitor var1, Map<String, Object> var2);

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.rateLimitServiceSettings.modelId(), this.apiKey, this.uri);
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitServiceSettings.rateLimitSettings();
    }

    public URI uri() {
        return this.uri;
    }
}

