/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai;

import java.util.concurrent.Flow;
import java.util.function.Function;
import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiStreamingProcessor;
import org.elasticsearch.xpack.inference.services.googlevertexai.response.GoogleVertexAiErrorResponseEntity;

public class GoogleVertexAiResponseHandler
extends BaseResponseHandler {
    static final String GOOGLE_VERTEX_AI_UNAVAILABLE = "The Google Vertex AI service may be temporarily overloaded or down";

    public GoogleVertexAiResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, GoogleVertexAiErrorResponseEntity::fromResponse);
    }

    public GoogleVertexAiResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction, boolean canHandleStreamingResponses) {
        super(requestType, parseFunction, errorParseFunction, canHandleStreamingResponses);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        if (result.isSuccessfulResponse()) {
            return;
        }
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (statusCode == 500) {
            throw new RetryException(true, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 503) {
            throw new RetryException(true, this.buildError(GOOGLE_VERTEX_AI_UNAVAILABLE, request, result));
        }
        if (statusCode > 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError("Received a rate limit status code", request, result));
        }
        if (statusCode == 404) {
            throw new RetryException(false, this.buildError(GoogleVertexAiResponseHandler.resourceNotFoundError(request), request, result));
        }
        if (statusCode == 403) {
            throw new RetryException(false, this.buildError("Received a permission denied error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }

    private static String resourceNotFoundError(Request request) {
        return Strings.format((String)"Resource not found at [%s]", (Object[])new Object[]{request.getURI()});
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        GoogleVertexAiStreamingProcessor googleVertexAiProcessor = new GoogleVertexAiStreamingProcessor();
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(googleVertexAiProcessor);
        return new StreamingChatCompletionResults((Flow.Publisher)googleVertexAiProcessor);
    }
}

