/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.registry;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class ModelRegistryMetadata
implements Metadata.ProjectCustom {
    public static final String TYPE = "model_registry";
    public static final ModelRegistryMetadata EMPTY_NOT_UPGRADED = new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)ImmutableOpenMap.of(), Set.of());
    public static final ModelRegistryMetadata EMPTY_UPGRADED = new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)ImmutableOpenMap.of());
    private static final ParseField UPGRADED_FIELD = new ParseField("upgraded", new String[0]);
    private static final ParseField MODELS_FIELD = new ParseField("models", new String[0]);
    private static final ParseField TOMBSTONES_FIELD = new ParseField("tombstones", new String[0]);
    private static final ConstructingObjectParser<ModelRegistryMetadata, Void> PARSER = new ConstructingObjectParser("model_registry", false, args -> {
        boolean isUpgraded = (Boolean)args[0];
        ImmutableOpenMap settingsMap = (ImmutableOpenMap)args[1];
        List deletedIDs = (List)args[2];
        if (isUpgraded) {
            return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)settingsMap);
        }
        return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)settingsMap, new HashSet<String>(deletedIDs));
    });
    private final boolean isUpgraded;
    private final ImmutableOpenMap<String, MinimalServiceSettings> modelMap;
    private final Set<String> tombstones;

    public static ModelRegistryMetadata fromState(ProjectMetadata projectMetadata) {
        ModelRegistryMetadata resp = (ModelRegistryMetadata)projectMetadata.custom(TYPE);
        return resp != null ? resp : EMPTY_NOT_UPGRADED;
    }

    public ModelRegistryMetadata withAddedModel(String inferenceEntityId, MinimalServiceSettings settings) {
        MinimalServiceSettings existing = (MinimalServiceSettings)this.modelMap.get((Object)inferenceEntityId);
        if (existing != null && settings.equals((Object)existing)) {
            return this;
        }
        ImmutableOpenMap.Builder settingsBuilder = ImmutableOpenMap.builder(this.modelMap);
        settingsBuilder.fPut((Object)inferenceEntityId, (Object)settings);
        if (this.isUpgraded) {
            return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)settingsBuilder.build());
        }
        HashSet<String> newTombstone = new HashSet<String>(this.tombstones);
        newTombstone.remove(inferenceEntityId);
        return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)settingsBuilder.build(), newTombstone);
    }

    public ModelRegistryMetadata withRemovedModel(Set<String> inferenceEntityIds) {
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder(this.modelMap);
        for (String toDelete : inferenceEntityIds) {
            mapBuilder.remove((Object)toDelete);
        }
        if (this.isUpgraded) {
            return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)mapBuilder.build());
        }
        HashSet<String> newTombstone = new HashSet<String>(this.tombstones);
        newTombstone.addAll(inferenceEntityIds);
        return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)mapBuilder.build(), newTombstone);
    }

    public ModelRegistryMetadata withUpgradedModels(Map<String, MinimalServiceSettings> indexModels) {
        if (this.isUpgraded) {
            throw new IllegalArgumentException("Already upgraded");
        }
        ImmutableOpenMap.Builder builder = ImmutableOpenMap.builder(this.modelMap);
        for (Map.Entry<String, MinimalServiceSettings> entry : indexModels.entrySet()) {
            if (builder.containsKey((Object)entry.getKey()) || this.tombstones.contains(entry.getKey())) continue;
            builder.fPut((Object)entry.getKey(), (Object)entry.getValue());
        }
        return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)builder.build());
    }

    public ModelRegistryMetadata(ImmutableOpenMap<String, MinimalServiceSettings> modelMap) {
        this.isUpgraded = true;
        this.modelMap = modelMap;
        this.tombstones = null;
    }

    public ModelRegistryMetadata(ImmutableOpenMap<String, MinimalServiceSettings> modelMap, Set<String> tombstone) {
        this.isUpgraded = false;
        this.modelMap = modelMap;
        this.tombstones = Collections.unmodifiableSet(tombstone);
    }

    public ModelRegistryMetadata(StreamInput in) throws IOException {
        this.isUpgraded = in.readBoolean();
        this.modelMap = in.readImmutableOpenMap(StreamInput::readString, MinimalServiceSettings::new);
        this.tombstones = this.isUpgraded ? null : in.readCollectionAsSet(StreamInput::readString);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isUpgraded);
        out.writeMap(this.modelMap, StreamOutput::writeWriteable);
        if (!this.isUpgraded) {
            out.writeStringCollection(this.tombstones);
        }
    }

    public static ModelRegistryMetadata fromXContent(XContentParser parser) throws IOException {
        return (ModelRegistryMetadata)PARSER.parse(parser, null);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat((Iterator[])new Iterator[]{Iterators.single((b, p) -> b.field(UPGRADED_FIELD.getPreferredName(), this.isUpgraded)), ChunkedToXContentHelper.object((String)MODELS_FIELD.getPreferredName(), this.modelMap, e -> (b, p) -> ((MinimalServiceSettings)e.getValue()).toXContent(b.field((String)e.getKey()), p)), this.isUpgraded ? Collections.emptyIterator() : ChunkedToXContentHelper.array((String)TOMBSTONES_FIELD.getPreferredName(), (Iterator)Iterators.map(this.tombstones.iterator(), e -> (b, p) -> b.value(e)))});
    }

    public boolean isUpgraded() {
        return this.isUpgraded;
    }

    public ImmutableOpenMap<String, MinimalServiceSettings> getModelMap() {
        return this.modelMap;
    }

    public MinimalServiceSettings getMinimalServiceSettings(String inferenceEntityId) {
        return (MinimalServiceSettings)this.modelMap.get((Object)inferenceEntityId);
    }

    public Diff<Metadata.ProjectCustom> diff(Metadata.ProjectCustom before) {
        return new ModelRegistryMetadataDiff((ModelRegistryMetadata)before, this);
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFrom(StreamInput in) throws IOException {
        return new ModelRegistryMetadataDiff(in);
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public boolean isRestorable() {
        return false;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.INFERENCE_MODEL_REGISTRY_METADATA_8_19;
    }

    public boolean supportsVersion(TransportVersion version) {
        return ModelRegistryMetadata.shouldSerialize(version);
    }

    public int hashCode() {
        return Objects.hash(this.modelMap, this.tombstones, this.isUpgraded);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ModelRegistryMetadata other = (ModelRegistryMetadata)obj;
        return Objects.equals(this.modelMap, other.modelMap) && this.isUpgraded == other.isUpgraded;
    }

    public String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }

    public Collection<String> getTombstones() {
        return this.tombstones;
    }

    static boolean shouldSerialize(TransportVersion version) {
        return version.isPatchFrom(TransportVersions.INFERENCE_MODEL_REGISTRY_METADATA_8_19) || version.onOrAfter((VersionId)TransportVersions.INFERENCE_MODEL_REGISTRY_METADATA);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), UPGRADED_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            ImmutableOpenMap.Builder modelMap = ImmutableOpenMap.builder();
            while (p.nextToken() != XContentParser.Token.END_OBJECT) {
                String name = p.currentName();
                modelMap.put((Object)name, (Object)MinimalServiceSettings.parse((XContentParser)p));
            }
            return modelMap.build();
        }, MODELS_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), TOMBSTONES_FIELD);
    }

    static class ModelRegistryMetadataDiff
    implements NamedDiff<Metadata.ProjectCustom> {
        private static final DiffableUtils.DiffableValueReader<String, MinimalServiceSettings> SETTINGS_DIFF_READER = new DiffableUtils.DiffableValueReader(MinimalServiceSettings::new, MinimalServiceSettings::readDiffFrom);
        final boolean isUpgraded;
        final DiffableUtils.MapDiff<String, MinimalServiceSettings, ImmutableOpenMap<String, MinimalServiceSettings>> settingsDiff;
        final Set<String> tombstone;

        ModelRegistryMetadataDiff(ModelRegistryMetadata before, ModelRegistryMetadata after) {
            this.isUpgraded = after.isUpgraded;
            this.settingsDiff = DiffableUtils.diff(before.modelMap, after.modelMap, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer());
            this.tombstone = after.isUpgraded ? null : after.tombstones;
        }

        ModelRegistryMetadataDiff(StreamInput in) throws IOException {
            this.isUpgraded = in.readBoolean();
            this.settingsDiff = DiffableUtils.readImmutableOpenMapDiff((StreamInput)in, (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), SETTINGS_DIFF_READER);
            this.tombstone = this.isUpgraded ? null : in.readCollectionAsSet(StreamInput::readString);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.isUpgraded);
            this.settingsDiff.writeTo(out);
            if (!this.isUpgraded) {
                out.writeStringCollection(this.tombstone);
            }
        }

        public String getWriteableName() {
            return ModelRegistryMetadata.TYPE;
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.INFERENCE_MODEL_REGISTRY_METADATA_8_19;
        }

        public boolean supportsVersion(TransportVersion version) {
            return ModelRegistryMetadata.shouldSerialize(version);
        }

        public Metadata.ProjectCustom apply(Metadata.ProjectCustom part) {
            ModelRegistryMetadata metadata = (ModelRegistryMetadata)part;
            if (this.isUpgraded) {
                return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)((ImmutableOpenMap)this.settingsDiff.apply(metadata.modelMap)));
            }
            return new ModelRegistryMetadata((ImmutableOpenMap<String, MinimalServiceSettings>)((ImmutableOpenMap)this.settingsDiff.apply(metadata.modelMap)), this.tombstone);
        }
    }
}

