/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.close.TransportCloseIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.elasticsearch.action.admin.indices.readonly.TransportAddIndexBlockAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.deprecation.DeprecatedIndexPredicate;
import org.elasticsearch.xpack.migrate.action.CopyLifecycleIndexMetadataAction;
import org.elasticsearch.xpack.migrate.action.CreateIndexFromSourceAction;
import org.elasticsearch.xpack.migrate.action.ReindexDataStreamIndexAction;

public class ReindexDataStreamIndexTransportAction
extends HandledTransportAction<ReindexDataStreamIndexAction.Request, ReindexDataStreamIndexAction.Response> {
    public static final String REINDEX_MAX_REQUESTS_PER_SECOND_KEY = "migrate.data_stream_reindex_max_request_per_second";
    public static final Setting<Float> REINDEX_MAX_REQUESTS_PER_SECOND_SETTING = new Setting("migrate.data_stream_reindex_max_request_per_second", Float.toString(1000.0f), s -> {
        if (s.equals("-1")) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        return Float.valueOf(Float.parseFloat(s));
    }, value -> {
        if (value.floatValue() <= 0.0f) {
            throw new IllegalArgumentException("Failed to parse value [" + value + "] for setting [migrate.data_stream_reindex_max_request_per_second] must be greater than 0 or -1 for infinite");
        }
    }, new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(ReindexDataStreamIndexTransportAction.class);
    private static final IndicesOptions IGNORE_MISSING_OPTIONS = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false);
    private final ClusterService clusterService;
    private final Client client;
    private final TransportService transportService;
    private final AtomicInteger ingestNodeOffsetGenerator = new AtomicInteger(Randomness.get().nextInt(28));

    @Inject
    public ReindexDataStreamIndexTransportAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, Client client) {
        super("indices:admin/data_stream/index/reindex", false, transportService, actionFilters, ReindexDataStreamIndexAction.Request::new, (Executor)transportService.getThreadPool().executor("generic"));
        this.clusterService = clusterService;
        this.client = client;
        this.transportService = transportService;
    }

    protected void doExecute(Task task, ReindexDataStreamIndexAction.Request request, ActionListener<ReindexDataStreamIndexAction.Response> listener) {
        ProjectState project = this.clusterService.state().projectState();
        String sourceIndexName = request.getSourceIndex();
        String destIndexName = ReindexDataStreamIndexTransportAction.generateDestIndexName(sourceIndexName);
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        IndexMetadata sourceIndex = project.metadata().index(sourceIndexName);
        if (sourceIndex == null) {
            listener.onFailure((Exception)new ResourceNotFoundException("source index [{}] does not exist", new Object[]{sourceIndexName}));
            return;
        }
        Settings settingsBefore = sourceIndex.getSettings();
        Predicate hasOldVersion = DeprecatedIndexPredicate.getReindexRequiredPredicate((ProjectMetadata)project.metadata(), (boolean)false, (boolean)true);
        if (!hasOldVersion.test(sourceIndex.getIndex())) {
            logger.warn("Migrating index [{}] with version [{}] is unnecessary as its version is not before [{}]", (Object)sourceIndexName, (Object)sourceIndex.getCreationVersion(), (Object)DeprecatedIndexPredicate.MINIMUM_WRITEABLE_VERSION_AFTER_UPGRADE);
        }
        boolean wasClosed = ReindexDataStreamIndexTransportAction.isClosed(sourceIndex);
        SubscribableListener.newForked(l -> this.removeMetadataBlocks(sourceIndexName, taskId, (ActionListener<AcknowledgedResponse>)l)).andThen(l -> this.openIndexIfClosed(sourceIndexName, wasClosed, (ActionListener<OpenIndexResponse>)l, taskId)).andThen(l -> this.setReadOnly(sourceIndexName, (ActionListener<AcknowledgedResponse>)l, taskId)).andThen(l -> this.refresh(sourceIndexName, (ActionListener<BroadcastResponse>)l, taskId)).andThen(l -> this.deleteDestIfExists(destIndexName, (ActionListener<AcknowledgedResponse>)l, taskId)).andThen(l -> this.createIndex(sourceIndex, destIndexName, (ActionListener<AcknowledgedResponse>)l, taskId)).andThen(l -> this.reindex(sourceIndexName, destIndexName, (ActionListener<BulkByScrollResponse>)l, taskId)).andThen(l -> this.copyOldSourceSettingsToDest(settingsBefore, destIndexName, (ActionListener<AcknowledgedResponse>)l, taskId)).andThen(l -> this.copyIndexMetadataToDest(sourceIndexName, destIndexName, (ActionListener<AcknowledgedResponse>)l, taskId)).andThen(l -> this.sanityCheck(sourceIndexName, destIndexName, (ActionListener<AcknowledgedResponse>)l, taskId)).andThen(l -> this.closeIndexIfWasClosed(destIndexName, wasClosed, (ActionListener<CloseIndexResponse>)l, taskId)).andThen(l -> this.removeAPIBlocks(sourceIndexName, taskId, (ActionListener<AcknowledgedResponse>)l, IndexMetadata.APIBlock.READ_ONLY)).andThenApply(ignored -> new ReindexDataStreamIndexAction.Response(destIndexName)).addListener(listener);
    }

    private void openIndexIfClosed(String indexName, boolean isClosed, ActionListener<OpenIndexResponse> listener, TaskId parentTaskId) {
        if (isClosed) {
            logger.debug("Opening index [{}]", (Object)indexName);
            OpenIndexRequest request = new OpenIndexRequest(new String[]{indexName});
            request.setParentTask(parentTaskId);
            this.client.execute((ActionType)OpenIndexAction.INSTANCE, (ActionRequest)request, listener);
        } else {
            listener.onResponse(null);
        }
    }

    private void closeIndexIfWasClosed(String indexName, boolean wasClosed, ActionListener<CloseIndexResponse> listener, TaskId parentTaskId) {
        if (wasClosed) {
            logger.debug("Closing index [{}]", (Object)indexName);
            CloseIndexRequest request = new CloseIndexRequest(new String[]{indexName});
            request.setParentTask(parentTaskId);
            this.client.execute(TransportCloseIndexAction.TYPE, (ActionRequest)request, listener);
        } else {
            listener.onResponse(null);
        }
    }

    private static boolean isClosed(IndexMetadata indexMetadata) {
        return indexMetadata.getState().equals((Object)IndexMetadata.State.CLOSE);
    }

    private void setReadOnly(final String sourceIndexName, final ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        logger.debug("Setting read-only on source index [{}]", (Object)sourceIndexName);
        this.addBlockToIndex(IndexMetadata.APIBlock.READ_ONLY, sourceIndexName, new ActionListener<AddIndexBlockResponse>(this){

            public void onResponse(AddIndexBlockResponse response) {
                if (response.isAcknowledged()) {
                    listener.onResponse(null);
                } else {
                    String errorMessage = String.format(Locale.ROOT, "Could not set read-only on source index [%s]", sourceIndexName);
                    listener.onFailure((Exception)new ElasticsearchException(errorMessage, new Object[0]));
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof ClusterBlockException || e.getCause() instanceof ClusterBlockException) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure(e);
                }
            }
        }, parentTaskId);
    }

    private void refresh(String sourceIndexName, ActionListener<BroadcastResponse> listener, TaskId parentTaskId) {
        logger.debug("Refreshing source index [{}]", (Object)sourceIndexName);
        RefreshRequest refreshRequest = new RefreshRequest(new String[]{sourceIndexName});
        refreshRequest.setParentTask(parentTaskId);
        this.client.execute((ActionType)RefreshAction.INSTANCE, (ActionRequest)refreshRequest, listener);
    }

    private void deleteDestIfExists(String destIndexName, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        logger.debug("Attempting to delete index [{}]", (Object)destIndexName);
        DeleteIndexRequest deleteIndexRequest = (DeleteIndexRequest)new DeleteIndexRequest(destIndexName).indicesOptions(IGNORE_MISSING_OPTIONS).masterNodeTimeout(TimeValue.MAX_VALUE);
        deleteIndexRequest.setParentTask(parentTaskId);
        String errorMessage = String.format(Locale.ROOT, "Failed to acknowledge delete of index [%s]", destIndexName);
        this.client.admin().indices().delete(deleteIndexRequest, ReindexDataStreamIndexTransportAction.failIfNotAcknowledged(listener, errorMessage));
    }

    private void createIndex(IndexMetadata sourceIndex, String destIndexName, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        logger.debug("Creating destination index [{}] for source index [{}]", (Object)destIndexName, (Object)sourceIndex.getIndex().getName());
        Settings settingsOverride = Settings.builder().put("index.number_of_replicas", 0).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), -1).putNull("index.lifecycle.name").build();
        CreateIndexFromSourceAction.Request request = new CreateIndexFromSourceAction.Request(sourceIndex.getIndex().getName(), destIndexName, settingsOverride, Map.of(), true);
        request.setParentTask(parentTaskId);
        String errorMessage = String.format(Locale.ROOT, "Could not create index [%s]", request.destIndex());
        this.client.execute(CreateIndexFromSourceAction.INSTANCE, (ActionRequest)request, ReindexDataStreamIndexTransportAction.failIfNotAcknowledged(listener, errorMessage));
    }

    void reindex(String sourceIndexName, String destIndexName, ActionListener<BulkByScrollResponse> listener, TaskId parentTaskId) {
        logger.debug("Reindex to destination index [{}] from source index [{}]", (Object)destIndexName, (Object)sourceIndexName);
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceIndices(new String[]{sourceIndexName});
        reindexRequest.setDestPipeline("reindex-data-stream-pipeline");
        reindexRequest.getSearchRequest().allowPartialSearchResults(false);
        reindexRequest.getSearchRequest().source().fetchSource(true);
        reindexRequest.setDestIndex(destIndexName);
        reindexRequest.setParentTask(parentTaskId);
        reindexRequest.setRequestsPerSecond(((Float)this.clusterService.getClusterSettings().get(REINDEX_MAX_REQUESTS_PER_SECOND_SETTING)).floatValue());
        reindexRequest.setSlices(0);
        ActionListener checkForFailuresListener = ActionListener.wrap(bulkByScrollResponse -> {
            if (!bulkByScrollResponse.getSearchFailures().isEmpty()) {
                ScrollableHitSource.SearchFailure firstSearchFailure = (ScrollableHitSource.SearchFailure)bulkByScrollResponse.getSearchFailures().get(0);
                listener.onFailure((Exception)new ElasticsearchException("Failure reading data from {} caused by {}", firstSearchFailure.getReason(), new Object[]{sourceIndexName, firstSearchFailure.getReason().getMessage()}));
            } else if (!bulkByScrollResponse.getBulkFailures().isEmpty()) {
                BulkItemResponse.Failure firstBulkFailure = (BulkItemResponse.Failure)bulkByScrollResponse.getBulkFailures().get(0);
                listener.onFailure((Exception)new ElasticsearchException("Failure loading data from {} into {} caused by {}", (Throwable)firstBulkFailure.getCause(), new Object[]{sourceIndexName, destIndexName, firstBulkFailure.getCause().getMessage()}));
            } else {
                listener.onResponse(bulkByScrollResponse);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        DiscoveryNode[] ingestNodes = (DiscoveryNode[])this.clusterService.state().getNodes().getIngestNodes().values().toArray(DiscoveryNode[]::new);
        if (ingestNodes.length == 0) {
            listener.onFailure((Exception)new NoNodeAvailableException("No ingest nodes in cluster"));
        } else {
            DiscoveryNode ingestNode = ingestNodes[Math.floorMod(this.ingestNodeOffsetGenerator.incrementAndGet(), ingestNodes.length)];
            logger.debug("Sending reindex request to {}", (Object)ingestNode.getName());
            this.transportService.sendRequest(ingestNode, "indices:data/write/reindex", (TransportRequest)reindexRequest, (TransportResponseHandler)new ActionListenerResponseHandler(checkForFailuresListener, BulkByScrollResponse::new, TransportResponseHandler.TRANSPORT_WORKER));
        }
    }

    private void updateSettings(String index, Settings.Builder settings, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(settings.build(), new String[]{index});
        updateSettingsRequest.setParentTask(parentTaskId);
        String errorMessage = String.format(Locale.ROOT, "Could not update settings on index [%s]", index);
        this.client.admin().indices().updateSettings(updateSettingsRequest, ReindexDataStreamIndexTransportAction.failIfNotAcknowledged(listener, errorMessage));
    }

    private void copyOldSourceSettingsToDest(Settings settingsBefore, String destIndexName, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        logger.debug("Updating settings on destination index after reindex completes");
        Settings.Builder settings = Settings.builder();
        ReindexDataStreamIndexTransportAction.copySettingOrUnset(settingsBefore, settings, "index.number_of_replicas");
        ReindexDataStreamIndexTransportAction.copySettingOrUnset(settingsBefore, settings, IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey());
        this.updateSettings(destIndexName, settings, listener, parentTaskId);
    }

    private void copyIndexMetadataToDest(String sourceIndexName, String destIndexName, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        logger.debug("Copying index metadata to destination index [{}] from source index [{}]", (Object)destIndexName, (Object)sourceIndexName);
        CopyLifecycleIndexMetadataAction.Request request = new CopyLifecycleIndexMetadataAction.Request(TimeValue.MAX_VALUE, sourceIndexName, destIndexName);
        request.setParentTask(parentTaskId);
        String errorMessage = String.format(Locale.ROOT, "Failed to acknowledge copying index metadata from source [%s] to dest [%s]", sourceIndexName, destIndexName);
        this.client.execute(CopyLifecycleIndexMetadataAction.INSTANCE, (ActionRequest)request, ReindexDataStreamIndexTransportAction.failIfNotAcknowledged(listener, errorMessage));
    }

    private static void copySettingOrUnset(Settings settingsBefore, Settings.Builder builder, String setting) {
        if (settingsBefore.get(setting) != null) {
            builder.copy(setting, settingsBefore);
        } else {
            builder.putNull(setting);
        }
    }

    static String generateDestIndexName(String sourceIndex) {
        String prefix = "migrated-";
        if (sourceIndex.startsWith(".")) {
            return "." + prefix + sourceIndex.substring(1);
        }
        return prefix + sourceIndex;
    }

    private static <U extends AcknowledgedResponse> ActionListener<U> failIfNotAcknowledged(ActionListener<U> listener, String errorMessage) {
        return listener.delegateFailure((delegate, response) -> {
            if (response.isAcknowledged()) {
                delegate.onResponse(null);
            } else {
                delegate.onFailure((Exception)new ElasticsearchException(errorMessage, new Object[0]));
            }
        });
    }

    private void addBlockToIndex(IndexMetadata.APIBlock block, String index, ActionListener<AddIndexBlockResponse> listener, TaskId parentTaskId) {
        AddIndexBlockRequest addIndexBlockRequest = new AddIndexBlockRequest(block, new String[]{index});
        addIndexBlockRequest.markVerified(false);
        addIndexBlockRequest.setParentTask(parentTaskId);
        this.client.admin().indices().execute(TransportAddIndexBlockAction.TYPE, (ActionRequest)addIndexBlockRequest, listener);
    }

    private void removeMetadataBlocks(String indexName, TaskId parentTaskId, ActionListener<AcknowledgedResponse> listener) {
        logger.debug("Removing metadata blocks from index [{}]", (Object)indexName);
        this.removeAPIBlocks(indexName, parentTaskId, listener, IndexMetadata.APIBlock.METADATA, IndexMetadata.APIBlock.READ_ONLY);
    }

    private void removeAPIBlocks(String indexName, TaskId parentTaskId, ActionListener<AcknowledgedResponse> listener, IndexMetadata.APIBlock ... blocks) {
        Settings.Builder settings = Settings.builder();
        Arrays.stream(blocks).forEach(b -> settings.putNull(b.settingName()));
        UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(settings.build(), new String[]{indexName});
        updateSettingsRequest.setParentTask(parentTaskId);
        this.client.execute(TransportUpdateSettingsAction.TYPE, (ActionRequest)updateSettingsRequest, listener);
    }

    private void getIndexDocCount(String index, TaskId parentTaskId, ActionListener<Long> listener) {
        SearchRequest countRequest = new SearchRequest(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).trackTotalHits(true);
        countRequest.allowPartialSearchResults(false);
        countRequest.source(searchSourceBuilder);
        countRequest.setParentTask(parentTaskId);
        this.client.search(countRequest, listener.delegateFailure((delegate, response) -> {
            TotalHits totalHits = response.getHits().getTotalHits();
            assert (totalHits.relation() == TotalHits.Relation.EQUAL_TO);
            delegate.onResponse((Object)totalHits.value());
        }));
    }

    private void sanityCheck(String sourceIndexName, String destIndexName, ActionListener<AcknowledgedResponse> listener, TaskId parentTaskId) {
        if (Assertions.ENABLED) {
            logger.debug("Comparing source [{}] and dest [{}] doc counts", (Object)sourceIndexName, (Object)destIndexName);
            RefreshRequest refreshRequest = new RefreshRequest(new String[]{destIndexName});
            refreshRequest.setParentTask(parentTaskId);
            this.client.execute((ActionType)RefreshAction.INSTANCE, (ActionRequest)refreshRequest, listener.delegateFailureAndWrap((delegate, ignored) -> this.getIndexDocCount(sourceIndexName, parentTaskId, (ActionListener<Long>)delegate.delegateFailureAndWrap((delegate1, sourceCount) -> this.getIndexDocCount(destIndexName, parentTaskId, (ActionListener<Long>)delegate1.delegateFailureAndWrap((delegate2, destCount) -> {
                assert (Objects.equals(sourceCount, destCount)) : String.format(Locale.ROOT, "source index [%s] has %d docs and dest [%s] has %d docs", sourceIndexName, sourceCount, destIndexName, destCount);
                delegate2.onResponse(null);
            }))))));
        } else {
            listener.onResponse(null);
        }
    }
}

