/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.autoscaling;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ml.autoscaling.AbstractNodeAvailabilityZoneMapper;
import org.elasticsearch.xpack.ml.autoscaling.NodeAvailabilityZoneMapper;

public class NodeFakeAvailabilityZoneMapper
extends AbstractNodeAvailabilityZoneMapper {
    public NodeFakeAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings) {
        this(settings, clusterSettings, null);
    }

    public NodeFakeAvailabilityZoneMapper(Settings settings, ClusterSettings clusterSettings, DiscoveryNodes discoveryNodes) {
        super(settings, clusterSettings, discoveryNodes);
        this.updateNodesByAvailabilityZone();
    }

    @Override
    public NodeAvailabilityZoneMapper.NodesByAvailabilityZone buildNodesByAvailabilityZone(DiscoveryNodes discoveryNodes) {
        Collection nodes = discoveryNodes.getNodes().values();
        HashMap<List<String>, List<DiscoveryNode>> allNodesByAvailabilityZone = new HashMap<List<String>, List<DiscoveryNode>>();
        HashMap<List<String>, List<DiscoveryNode>> mlNodesByAvailabilityZone = new HashMap<List<String>, List<DiscoveryNode>>();
        for (DiscoveryNode node : nodes) {
            List<String> nodeIdValues = List.of(node.getId());
            List<DiscoveryNode> nodeList = List.of(node);
            allNodesByAvailabilityZone.put(nodeIdValues, nodeList);
            if (!node.getRoles().contains(DiscoveryNodeRole.ML_ROLE)) continue;
            mlNodesByAvailabilityZone.put(nodeIdValues, nodeList);
        }
        return new NodeAvailabilityZoneMapper.NodesByAvailabilityZone(Map.copyOf(allNodesByAvailabilityZone), Map.copyOf(mlNodesByAvailabilityZone));
    }

    @Override
    public Map<List<String>, Collection<DiscoveryNode>> buildMlNodesByAvailabilityZone(ClusterState clusterState) {
        return this.buildNodesByAvailabilityZone(clusterState.nodes()).mlNodes();
    }
}

